/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.nineoldandroids.animation;

import android.view.View;
import io.dcloud.nineoldandroids.animation.PreHoneycombCompat;
import io.dcloud.nineoldandroids.animation.PropertyValuesHolder;
import io.dcloud.nineoldandroids.animation.TypeEvaluator;
import io.dcloud.nineoldandroids.animation.ValueAnimator;
import io.dcloud.nineoldandroids.util.Property;
import io.dcloud.nineoldandroids.view.animation.AnimatorProxy;
import java.util.HashMap;
import java.util.Map;

public final class ObjectAnimator
extends ValueAnimator {
    private static final boolean DBG = false;
    private static final Map<String, Property> PROXY_PROPERTIES = new HashMap<String, Property>();
    private Object mTarget;
    private String mPropertyName;
    private Property mProperty;

    static {
        PROXY_PROPERTIES.put("alpha", PreHoneycombCompat.ALPHA);
        PROXY_PROPERTIES.put("pivotX", PreHoneycombCompat.PIVOT_X);
        PROXY_PROPERTIES.put("pivotY", PreHoneycombCompat.PIVOT_Y);
        PROXY_PROPERTIES.put("translationX", PreHoneycombCompat.TRANSLATION_X);
        PROXY_PROPERTIES.put("translationY", PreHoneycombCompat.TRANSLATION_Y);
        PROXY_PROPERTIES.put("rotation", PreHoneycombCompat.ROTATION);
        PROXY_PROPERTIES.put("rotationX", PreHoneycombCompat.ROTATION_X);
        PROXY_PROPERTIES.put("rotationY", PreHoneycombCompat.ROTATION_Y);
        PROXY_PROPERTIES.put("scaleX", PreHoneycombCompat.SCALE_X);
        PROXY_PROPERTIES.put("scaleY", PreHoneycombCompat.SCALE_Y);
        PROXY_PROPERTIES.put("scrollX", PreHoneycombCompat.SCROLL_X);
        PROXY_PROPERTIES.put("scrollY", PreHoneycombCompat.SCROLL_Y);
        PROXY_PROPERTIES.put("x", PreHoneycombCompat.X);
        PROXY_PROPERTIES.put("y", PreHoneycombCompat.Y);
    }

    public ObjectAnimator() {
    }

    private ObjectAnimator(Object object, String string2) {
        ObjectAnimator objectAnimator = this;
        objectAnimator.mTarget = object;
        objectAnimator.setPropertyName(string2);
    }

    private <T> ObjectAnimator(T t, Property<T, ?> property) {
        ObjectAnimator objectAnimator = this;
        objectAnimator.mTarget = t;
        objectAnimator.setProperty(property);
    }

    public static ObjectAnimator ofInt(Object object, String string2, int ... nArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(object, string2);
        objectAnimator.setIntValues(nArray);
        return objectAnimator;
    }

    public static <T> ObjectAnimator ofInt(T t, Property<T, Integer> property, int ... nArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(t, property);
        objectAnimator.setIntValues(nArray);
        return objectAnimator;
    }

    public static ObjectAnimator ofFloat(Object object, String string2, float ... fArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(object, string2);
        objectAnimator.setFloatValues(fArray);
        return objectAnimator;
    }

    public static <T> ObjectAnimator ofFloat(T t, Property<T, Float> property, float ... fArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(t, property);
        objectAnimator.setFloatValues(fArray);
        return objectAnimator;
    }

    public static ObjectAnimator ofObject(Object object, String string2, TypeEvaluator typeEvaluator, Object ... objectArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(object, string2);
        objectAnimator.setObjectValues(objectArray);
        objectAnimator.setEvaluator(typeEvaluator);
        return objectAnimator;
    }

    public static <T, V> ObjectAnimator ofObject(T t, Property<T, V> property, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(t, property);
        objectAnimator.setObjectValues(VArray);
        objectAnimator.setEvaluator(typeEvaluator);
        return objectAnimator;
    }

    public static ObjectAnimator ofPropertyValuesHolder(Object object, PropertyValuesHolder ... propertyValuesHolderArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator();
        objectAnimator.mTarget = object;
        objectAnimator.setValues(propertyValuesHolderArray);
        return objectAnimator;
    }

    public void setPropertyName(String string2) {
        Object object = this.mValues;
        if (this.mValues != null) {
            ObjectAnimator objectAnimator = this;
            object = object[0];
            String string3 = ((PropertyValuesHolder)object).getPropertyName();
            ((PropertyValuesHolder)object).setPropertyName(string2);
            objectAnimator.mValuesMap.remove(string3);
            objectAnimator.mValuesMap.put(string2, (PropertyValuesHolder)object);
        }
        ObjectAnimator objectAnimator = this;
        objectAnimator.mPropertyName = string2;
        objectAnimator.mInitialized = false;
    }

    public void setProperty(Property property) {
        Object object = this.mValues;
        if (this.mValues != null) {
            ObjectAnimator objectAnimator = this;
            object = object[0];
            String string2 = ((PropertyValuesHolder)object).getPropertyName();
            ((PropertyValuesHolder)object).setProperty(property);
            objectAnimator.mValuesMap.remove(string2);
            objectAnimator.mValuesMap.put(this.mPropertyName, (PropertyValuesHolder)object);
        }
        if (this.mProperty != null) {
            this.mPropertyName = property.getName();
        }
        ObjectAnimator objectAnimator = this;
        objectAnimator.mProperty = property;
        objectAnimator.mInitialized = false;
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    @Override
    public void setIntValues(int ... nArray) {
        Object object = propertyValuesHolderArray3.mValues;
        if (propertyValuesHolderArray3.mValues != null && ((PropertyValuesHolder[])object).length != 0) {
            super.setIntValues(nArray);
        } else {
            object = propertyValuesHolderArray3.mProperty;
            if (object != null) {
                PropertyValuesHolder[] propertyValuesHolderArray = propertyValuesHolderArray3;
                PropertyValuesHolder[] propertyValuesHolderArray2 = new PropertyValuesHolder[1];
                PropertyValuesHolder[] propertyValuesHolderArray3 = propertyValuesHolderArray2;
                propertyValuesHolderArray2[0] = PropertyValuesHolder.ofInt(object, nArray);
                propertyValuesHolderArray.setValues(propertyValuesHolderArray3);
            } else {
                propertyValuesHolderArray3.setValues(PropertyValuesHolder.ofInt(propertyValuesHolderArray3.mPropertyName, nArray));
            }
        }
    }

    @Override
    public void setFloatValues(float ... fArray) {
        Object object = propertyValuesHolderArray3.mValues;
        if (propertyValuesHolderArray3.mValues != null && ((PropertyValuesHolder[])object).length != 0) {
            super.setFloatValues(fArray);
        } else {
            object = propertyValuesHolderArray3.mProperty;
            if (object != null) {
                PropertyValuesHolder[] propertyValuesHolderArray = propertyValuesHolderArray3;
                PropertyValuesHolder[] propertyValuesHolderArray2 = new PropertyValuesHolder[1];
                PropertyValuesHolder[] propertyValuesHolderArray3 = propertyValuesHolderArray2;
                propertyValuesHolderArray2[0] = PropertyValuesHolder.ofFloat(object, fArray);
                propertyValuesHolderArray.setValues(propertyValuesHolderArray3);
            } else {
                propertyValuesHolderArray3.setValues(PropertyValuesHolder.ofFloat(propertyValuesHolderArray3.mPropertyName, fArray));
            }
        }
    }

    @Override
    public void setObjectValues(Object ... objectArray) {
        Object object = propertyValuesHolderArray3.mValues;
        if (propertyValuesHolderArray3.mValues != null && ((PropertyValuesHolder[])object).length != 0) {
            super.setObjectValues(objectArray);
        } else {
            object = propertyValuesHolderArray3.mProperty;
            if (object != null) {
                PropertyValuesHolder[] propertyValuesHolderArray = propertyValuesHolderArray3;
                PropertyValuesHolder[] propertyValuesHolderArray2 = new PropertyValuesHolder[1];
                PropertyValuesHolder[] propertyValuesHolderArray3 = propertyValuesHolderArray2;
                propertyValuesHolderArray2[0] = PropertyValuesHolder.ofObject((Property)object, null, objectArray);
                propertyValuesHolderArray.setValues(propertyValuesHolderArray3);
            } else {
                propertyValuesHolderArray3.setValues(PropertyValuesHolder.ofObject(propertyValuesHolderArray3.mPropertyName, null, objectArray));
            }
        }
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    void initAnimation() {
        if (!this.mInitialized) {
            Map<String, Property> map;
            if (this.mProperty == null && AnimatorProxy.NEEDS_PROXY && this.mTarget instanceof View && (map = PROXY_PROPERTIES).containsKey(this.mPropertyName)) {
                this.setProperty(map.get(this.mPropertyName));
            }
            int n2 = this.mValues.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    super.initAnimation();
                    break;
                }
                this.mValues[n3].setupSetterAndGetter(this.mTarget);
                ++n3;
            }
        }
    }

    @Override
    public ObjectAnimator setDuration(long l2) {
        ObjectAnimator objectAnimator = this;
        super.setDuration(l2);
        return objectAnimator;
    }

    public Object getTarget() {
        return this.mTarget;
    }

    @Override
    public void setTarget(Object object) {
        Object object2 = this.mTarget;
        if (object2 != object) {
            this.mTarget = object;
            if (object2 != null && object != null && object2.getClass() == object.getClass()) {
                return;
            }
            this.mInitialized = false;
        }
    }

    @Override
    public void setupStartValues() {
        ObjectAnimator objectAnimator = this;
        objectAnimator.initAnimation();
        int n2 = objectAnimator.mValues.length;
        int n3 = 0;
        while (n3 < n2) {
            this.mValues[n3].setupStartValue(this.mTarget);
            ++n3;
        }
        return;
    }

    @Override
    public void setupEndValues() {
        ObjectAnimator objectAnimator = this;
        objectAnimator.initAnimation();
        int n2 = objectAnimator.mValues.length;
        int n3 = 0;
        while (n3 < n2) {
            this.mValues[n3].setupEndValue(this.mTarget);
            ++n3;
        }
        return;
    }

    @Override
    void animateValue(float f2) {
        ObjectAnimator objectAnimator = this;
        super.animateValue(f2);
        int n2 = objectAnimator.mValues.length;
        int n3 = 0;
        while (n3 < n2) {
            this.mValues[n3].setAnimatedValue(this.mTarget);
            ++n3;
        }
        return;
    }

    @Override
    public ObjectAnimator clone() {
        return (ObjectAnimator)super.clone();
    }

    @Override
    public String toString() {
        String string2 = "ObjectAnimator@" + Integer.toHexString(this.hashCode()) + ", target " + this.mTarget;
        if (this.mValues != null) {
            for (int i2 = 0; i2 < this.mValues.length; ++i2) {
                string2 = String.valueOf(string2) + "\n    " + this.mValues[i2].toString();
            }
        }
        return string2;
    }
}

