/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.nineoldandroids.animation;

import android.view.animation.Interpolator;
import io.dcloud.nineoldandroids.animation.FloatKeyframeSet;
import io.dcloud.nineoldandroids.animation.IntKeyframeSet;
import io.dcloud.nineoldandroids.animation.Keyframe;
import io.dcloud.nineoldandroids.animation.TypeEvaluator;
import java.util.ArrayList;
import java.util.Arrays;

class KeyframeSet {
    int mNumKeyframes;
    Keyframe mFirstKeyframe;
    Keyframe mLastKeyframe;
    Interpolator mInterpolator;
    ArrayList<Keyframe> mKeyframes;
    TypeEvaluator mEvaluator;

    public KeyframeSet(Keyframe ... keyframeArray) {
        ArrayList<Keyframe> arrayList;
        ArrayList<Keyframe> arrayList2;
        KeyframeSet keyframeSet = keyframe;
        keyframeSet.mNumKeyframes = keyframeArray.length;
        ArrayList<Keyframe> arrayList3 = arrayList2 = arrayList;
        arrayList3();
        ((KeyframeSet)((Object)keyframe)).mKeyframes = arrayList3;
        arrayList.addAll(Arrays.asList(keyframeArray));
        keyframeSet.mFirstKeyframe = keyframeSet.mKeyframes.get(0);
        Keyframe keyframe = keyframeSet.mKeyframes.get(((KeyframeSet)((Object)keyframe)).mNumKeyframes - 1);
        keyframeSet.mLastKeyframe = keyframe;
        keyframeSet.mInterpolator = keyframe.getInterpolator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyframeSet ofInt(int ... nArray) {
        int n2 = nArray.length;
        Keyframe.IntKeyframe[] intKeyframeArray = new Keyframe.IntKeyframe[Math.max(n2, 2)];
        if (n2 == 1) {
            intKeyframeArray[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f);
            intKeyframeArray[1] = (Keyframe.IntKeyframe)Keyframe.ofInt(1.0f, nArray[0]);
            return new IntKeyframeSet(intKeyframeArray);
        }
        intKeyframeArray[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f, nArray[0]);
        int n3 = 1;
        while (n3 < n2) {
            int n4 = n3;
            intKeyframeArray[n4] = (Keyframe.IntKeyframe)Keyframe.ofInt((float)n4 / (float)(n2 - 1), nArray[n3]);
            ++n3;
        }
        return new IntKeyframeSet(intKeyframeArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyframeSet ofFloat(float ... fArray) {
        int n2 = fArray.length;
        Keyframe.FloatKeyframe[] floatKeyframeArray = new Keyframe.FloatKeyframe[Math.max(n2, 2)];
        if (n2 == 1) {
            floatKeyframeArray[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f);
            floatKeyframeArray[1] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(1.0f, fArray[0]);
            return new FloatKeyframeSet(floatKeyframeArray);
        }
        floatKeyframeArray[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f, fArray[0]);
        int n3 = 1;
        while (n3 < n2) {
            int n4 = n3;
            floatKeyframeArray[n4] = (Keyframe.FloatKeyframe)Keyframe.ofFloat((float)n4 / (float)(n2 - 1), fArray[n3]);
            ++n3;
        }
        return new FloatKeyframeSet(floatKeyframeArray);
    }

    public static KeyframeSet ofKeyframe(Keyframe ... keyframeArray) {
        int n2 = keyframeArray.length;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        while (true) {
            if (n5 >= n2) {
                if (n3 != 0 && n4 == 0 && !bl) {
                    Keyframe.FloatKeyframe[] floatKeyframeArray = new Keyframe.FloatKeyframe[n2];
                    n3 = 0;
                    while (true) {
                        if (n3 >= n2) {
                            return new FloatKeyframeSet(floatKeyframeArray);
                        }
                        floatKeyframeArray[n3] = (Keyframe.FloatKeyframe)keyframeArray[n3];
                        ++n3;
                    }
                }
                if (n4 != 0 && n3 == 0 && !bl) {
                    Keyframe.IntKeyframe[] intKeyframeArray = new Keyframe.IntKeyframe[n2];
                    n4 = 0;
                    while (true) {
                        if (n4 >= n2) {
                            return new IntKeyframeSet(intKeyframeArray);
                        }
                        intKeyframeArray[n4] = (Keyframe.IntKeyframe)keyframeArray[n4];
                        ++n4;
                    }
                }
                return new KeyframeSet(keyframeArray);
            }
            if (keyframeArray[n5] instanceof Keyframe.FloatKeyframe) {
                n3 = 1;
            } else if (keyframeArray[n5] instanceof Keyframe.IntKeyframe) {
                n4 = 1;
            } else {
                bl = true;
            }
            ++n5;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyframeSet ofObject(Object ... objectArray) {
        int n2 = objectArray.length;
        Keyframe[] keyframeArray = new Keyframe.ObjectKeyframe[Math.max(n2, 2)];
        if (n2 == 1) {
            keyframeArray[0] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(0.0f);
            keyframeArray[1] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(1.0f, objectArray[0]);
            return new KeyframeSet(keyframeArray);
        }
        keyframeArray[0] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(0.0f, objectArray[0]);
        int n3 = 1;
        while (n3 < n2) {
            int n4 = n3;
            keyframeArray[n4] = (Keyframe.ObjectKeyframe)Keyframe.ofObject((float)n4 / (float)(n2 - 1), objectArray[n3]);
            ++n3;
        }
        return new KeyframeSet(keyframeArray);
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        this.mEvaluator = typeEvaluator;
    }

    public KeyframeSet clone() {
        ArrayList<Keyframe> arrayList = ((KeyframeSet)((Object)arrayList)).mKeyframes;
        int n2 = arrayList.size();
        Keyframe[] keyframeArray = new Keyframe[n2];
        int n3 = 0;
        while (n3 < n2) {
            keyframeArray[n3] = ((Keyframe)arrayList.get(n3)).clone();
            ++n3;
        }
        return new KeyframeSet(keyframeArray);
    }

    public Object getValue(float f2) {
        Object object;
        int n2 = ((KeyframeSet)object).mNumKeyframes;
        if (n2 == 2) {
            Interpolator interpolator = ((KeyframeSet)object).mInterpolator;
            if (interpolator != null) {
                f2 = interpolator.getInterpolation(f2);
            }
            KeyframeSet keyframeSet = object;
            object = keyframeSet.mFirstKeyframe.getValue();
            return ((KeyframeSet)object).mEvaluator.evaluate(f2, object, keyframeSet.mLastKeyframe.getValue());
        }
        if (f2 <= 0.0f) {
            Keyframe keyframe = ((KeyframeSet)object).mKeyframes.get(1);
            Interpolator interpolator = keyframe.getInterpolator();
            if (interpolator != null) {
                f2 = interpolator.getInterpolation(f2);
            }
            float f3 = f2;
            f2 = ((KeyframeSet)object).mFirstKeyframe.getFraction();
            f2 = (f3 - f2) / (keyframe.getFraction() - f2);
            object = ((KeyframeSet)object).mFirstKeyframe.getValue();
            return ((KeyframeSet)object).mEvaluator.evaluate(f2, object, keyframe.getValue());
        }
        if (f2 >= 1.0f) {
            KeyframeSet keyframeSet = object;
            Keyframe keyframe = keyframeSet.mKeyframes.get(n2 - 2);
            Interpolator interpolator = keyframeSet.mLastKeyframe.getInterpolator();
            if (interpolator != null) {
                f2 = interpolator.getInterpolation(f2);
            }
            float f4 = f2;
            f2 = keyframe.getFraction();
            f2 = (f4 - f2) / (((KeyframeSet)object).mLastKeyframe.getFraction() - f2);
            Object object2 = object;
            object = keyframe.getValue();
            return ((KeyframeSet)object).mEvaluator.evaluate(f2, object, ((KeyframeSet)object2).mLastKeyframe.getValue());
        }
        Keyframe keyframe = ((KeyframeSet)object).mFirstKeyframe;
        int n3 = 1;
        while (n3 < ((KeyframeSet)object).mNumKeyframes) {
            Keyframe keyframe2;
            Keyframe keyframe3 = ((KeyframeSet)object).mKeyframes.get(n3);
            if (f2 < keyframe2.getFraction()) {
                Interpolator interpolator = keyframe3.getInterpolator();
                if (interpolator != null) {
                    f2 = interpolator.getInterpolation(f2);
                }
                float f5 = keyframe.getFraction();
                f5 = (f2 - f5) / (keyframe3.getFraction() - f5);
                Object object3 = keyframe.getValue();
                return ((KeyframeSet)object).mEvaluator.evaluate(f5, object3, keyframe3.getValue());
            }
            ++n3;
            keyframe = keyframe3;
        }
        return ((KeyframeSet)object).mLastKeyframe.getValue();
    }

    public String toString() {
        String string2 = " ";
        int n2 = 0;
        while (n2 < this.mNumKeyframes) {
            string2 = String.valueOf(string2) + this.mKeyframes.get(n2).getValue() + "  ";
            ++n2;
        }
        return string2;
    }
}

