/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.nativeObj.photoview.subscaleview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.dcloud.common.util.StringUtil;
import io.dcloud.feature.nativeObj.photoview.subscaleview.ImageSource;
import io.dcloud.feature.nativeObj.photoview.subscaleview.ImageViewState;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.CompatDecoderFactory;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.DecoderFactory;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.ImageDecoder;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.ImageRegionDecoder;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.SkiaImageDecoder;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.SkiaImageRegionDecoder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import pl.droidsonroids.gif.GifImageView;

public class SubsamplingScaleImageView
extends GifImageView {
    private static final String TAG = SubsamplingScaleImageView.class.getSimpleName();
    public static final int ORIENTATION_USE_EXIF = -1;
    public static final int ORIENTATION_0 = 0;
    public static final int ORIENTATION_90 = 90;
    public static final int ORIENTATION_180 = 180;
    public static final int ORIENTATION_270 = 270;
    private static final List<Integer> VALID_ORIENTATIONS = Arrays.asList(0, 90, 180, 270, -1);
    public static final int ZOOM_FOCUS_FIXED = 1;
    public static final int ZOOM_FOCUS_CENTER = 2;
    public static final int ZOOM_FOCUS_CENTER_IMMEDIATE = 3;
    private static final List<Integer> VALID_ZOOM_STYLES = Arrays.asList(1, 2, 3);
    public static final int EASE_OUT_QUAD = 1;
    public static final int EASE_IN_OUT_QUAD = 2;
    private static final List<Integer> VALID_EASING_STYLES = Arrays.asList(2, 1);
    public static final int PAN_LIMIT_INSIDE = 1;
    public static final int PAN_LIMIT_OUTSIDE = 2;
    public static final int PAN_LIMIT_CENTER = 3;
    private static final List<Integer> VALID_PAN_LIMITS = Arrays.asList(1, 2, 3);
    public static final int SCALE_TYPE_CENTER_INSIDE = 1;
    public static final int SCALE_TYPE_CENTER_CROP = 2;
    public static final int SCALE_TYPE_CUSTOM = 3;
    public static final int SCALE_TYPE_START = 4;
    private static final List<Integer> VALID_SCALE_TYPES = Arrays.asList(2, 1, 3, 4);
    public static final int ORIGIN_ANIM = 1;
    public static final int ORIGIN_TOUCH = 2;
    public static final int ORIGIN_FLING = 3;
    public static final int ORIGIN_DOUBLE_TAP_ZOOM = 4;
    public static final int TILE_SIZE_AUTO = Integer.MAX_VALUE;
    private static final int MESSAGE_LONG_CLICK = 1;
    private static Bitmap.Config preferredBitmapConfig;
    private Bitmap bitmap;
    private boolean bitmapIsPreview;
    private boolean bitmapIsCached;
    private Uri uri;
    private int fullImageSampleSize;
    private Map<Integer, List<Tile>> tileMap;
    private boolean debug;
    private int orientation;
    private float maxScale;
    private float minScale;
    private int minimumTileDpi;
    private int panLimit;
    private int minimumScaleType;
    private int maxTileWidth;
    private int maxTileHeight;
    private Executor executor;
    private boolean eagerLoadingEnabled;
    private boolean panEnabled;
    private boolean zoomEnabled;
    private boolean quickScaleEnabled;
    private float doubleTapZoomScale;
    private int doubleTapZoomStyle;
    private int doubleTapZoomDuration;
    private float scale;
    private float scaleStart;
    private PointF vTranslate;
    private PointF vTranslateStart;
    private PointF vTranslateBefore;
    private Float pendingScale;
    private PointF sPendingCenter;
    private PointF sRequestedCenter;
    private int sWidth;
    private int sHeight;
    private int sOrientation;
    private Rect sRegion;
    private Rect pRegion;
    private boolean isZooming;
    private boolean isPanning;
    private boolean isQuickScaling;
    private int maxTouchCount;
    private GestureDetector detector;
    private GestureDetector singleDetector;
    private ImageRegionDecoder decoder;
    private final ReadWriteLock decoderLock;
    private DecoderFactory<? extends ImageDecoder> bitmapDecoderFactory;
    private DecoderFactory<? extends ImageRegionDecoder> regionDecoderFactory;
    private PointF vCenterStart;
    private float vDistStart;
    private final float quickScaleThreshold;
    private float quickScaleLastDistance;
    private boolean quickScaleMoved;
    private PointF quickScaleVLastPoint;
    private PointF quickScaleSCenter;
    private PointF quickScaleVStart;
    private Anim anim;
    private boolean readySent;
    private boolean imageLoadedSent;
    private OnImageEventListener onImageEventListener;
    private OnStateChangedListener onStateChangedListener;
    private View.OnLongClickListener onLongClickListener;
    private final Handler handler;
    private Paint bitmapPaint;
    private Paint debugTextPaint;
    private Paint debugLinePaint;
    private Paint tileBgPaint;
    private ScaleAndTranslate satTemp;
    private Matrix matrix;
    private RectF sRect;
    private final float[] srcArray;
    private final float[] dstArray;
    private final float density;
    private TilesInited inited;

    public SubsamplingScaleImageView(Context context, AttributeSet attributeSet) {
        SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView3;
        SubsamplingScaleImageView subsamplingScaleImageView2 = subsamplingScaleImageView3;
        super(context, attributeSet);
        subsamplingScaleImageView2.orientation = 0;
        subsamplingScaleImageView2.maxScale = 2.0f;
        subsamplingScaleImageView2.minScale = subsamplingScaleImageView2.minScale();
        subsamplingScaleImageView2.minimumTileDpi = -1;
        subsamplingScaleImageView2.panLimit = 1;
        subsamplingScaleImageView2.minimumScaleType = 3;
        subsamplingScaleImageView2.maxTileWidth = Integer.MAX_VALUE;
        subsamplingScaleImageView2.maxTileHeight = Integer.MAX_VALUE;
        subsamplingScaleImageView2.executor = AsyncTask.THREAD_POOL_EXECUTOR;
        subsamplingScaleImageView2.eagerLoadingEnabled = true;
        subsamplingScaleImageView2.panEnabled = true;
        subsamplingScaleImageView2.zoomEnabled = true;
        subsamplingScaleImageView2.quickScaleEnabled = true;
        subsamplingScaleImageView2.doubleTapZoomScale = 1.0f;
        subsamplingScaleImageView2.doubleTapZoomStyle = 1;
        subsamplingScaleImageView2.doubleTapZoomDuration = 200;
        subsamplingScaleImageView2.decoderLock = new ReentrantReadWriteLock(true);
        subsamplingScaleImageView2.bitmapDecoderFactory = new CompatDecoderFactory<SkiaImageDecoder>(SkiaImageDecoder.class);
        subsamplingScaleImageView2.regionDecoderFactory = new CompatDecoderFactory<SkiaImageRegionDecoder>(SkiaImageRegionDecoder.class);
        subsamplingScaleImageView2.srcArray = new float[8];
        subsamplingScaleImageView2.dstArray = new float[8];
        subsamplingScaleImageView2.density = subsamplingScaleImageView2.getResources().getDisplayMetrics().density;
        subsamplingScaleImageView2.setMinimumDpi(160);
        subsamplingScaleImageView2.setDoubleTapZoomDpi(160);
        subsamplingScaleImageView2.setMinimumTileDpi(320);
        subsamplingScaleImageView3.setGestureDetector(context);
        subsamplingScaleImageView3.handler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message message) {
                if (message.what == 1 && SubsamplingScaleImageView.this.onLongClickListener != null) {
                    1 v0 = this;
                    SubsamplingScaleImageView.access$102(v0.SubsamplingScaleImageView.this, 0);
                    SubsamplingScaleImageView subsamplingScaleImageView = v0.SubsamplingScaleImageView.this;
                    SubsamplingScaleImageView.super.setOnLongClickListener(subsamplingScaleImageView.onLongClickListener);
                    v0.SubsamplingScaleImageView.this.performLongClick();
                    SubsamplingScaleImageView.super.setOnLongClickListener(null);
                }
                return true;
            }
        });
        SubsamplingScaleImageView subsamplingScaleImageView3 = context.getResources().getDisplayMetrics();
        subsamplingScaleImageView.quickScaleThreshold = TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)subsamplingScaleImageView3);
    }

    public SubsamplingScaleImageView(Context context) {
        this(context, null);
    }

    public static Bitmap.Config getPreferredBitmapConfig() {
        return preferredBitmapConfig;
    }

    public static void setPreferredBitmapConfig(Bitmap.Config config) {
        preferredBitmapConfig = config;
    }

    private void reset(boolean bl) {
        Object object;
        this.debug("reset newImage=" + bl, new Object[0]);
        this.scale = 0.0f;
        this.scaleStart = 0.0f;
        this.vTranslate = null;
        this.vTranslateStart = null;
        this.vTranslateBefore = null;
        this.pendingScale = Float.valueOf(0.0f);
        this.sPendingCenter = null;
        this.sRequestedCenter = null;
        this.isZooming = false;
        this.isPanning = false;
        this.isQuickScaling = false;
        this.maxTouchCount = 0;
        this.fullImageSampleSize = 0;
        this.vCenterStart = null;
        this.vDistStart = 0.0f;
        this.quickScaleLastDistance = 0.0f;
        this.quickScaleMoved = false;
        this.quickScaleSCenter = null;
        this.quickScaleVLastPoint = null;
        this.quickScaleVStart = null;
        this.anim = null;
        this.satTemp = null;
        this.matrix = null;
        this.sRect = null;
        if (bl) {
            Object object2;
            block9: {
                SubsamplingScaleImageView subsamplingScaleImageView = this;
                subsamplingScaleImageView.uri = null;
                subsamplingScaleImageView.decoderLock.writeLock().lock();
                try {
                    object2 = subsamplingScaleImageView.decoder;
                    if (object2 == null) break block9;
                }
                catch (Throwable throwable) {
                    this.decoderLock.writeLock().unlock();
                    throw throwable;
                }
                object2.recycle();
                this.decoder = null;
            }
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            subsamplingScaleImageView.decoderLock.writeLock().unlock();
            object2 = subsamplingScaleImageView.bitmap;
            if (object2 != null && !this.bitmapIsCached) {
                object2.recycle();
            }
            if (this.bitmap != null && this.bitmapIsCached && (object2 = this.onImageEventListener) != null) {
                object2.onPreviewReleased();
            }
            SubsamplingScaleImageView subsamplingScaleImageView2 = this;
            subsamplingScaleImageView2.sWidth = 0;
            subsamplingScaleImageView2.sHeight = 0;
            subsamplingScaleImageView2.sOrientation = 0;
            subsamplingScaleImageView2.sRegion = null;
            subsamplingScaleImageView2.pRegion = null;
            subsamplingScaleImageView2.readySent = false;
            subsamplingScaleImageView2.imageLoadedSent = false;
            subsamplingScaleImageView2.bitmap = null;
            subsamplingScaleImageView2.bitmapIsPreview = false;
            subsamplingScaleImageView2.bitmapIsCached = false;
        }
        if ((object = this.tileMap) != null) {
            object = object.entrySet().iterator();
            while (object.hasNext()) {
                for (Tile tile : (List)((Map.Entry)object.next()).getValue()) {
                    Tile.access$402(tile, false);
                    if (tile.bitmap == null) continue;
                    Tile tile2 = tile;
                    tile2.bitmap.recycle();
                    Tile.access$502(tile2, null);
                }
            }
            this.tileMap = null;
        }
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        subsamplingScaleImageView.setGestureDetector(subsamplingScaleImageView.getContext());
    }

    private void setGestureDetector(final Context context) {
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener;
        GestureDetector gestureDetector;
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener2;
        GestureDetector gestureDetector2;
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        GestureDetector gestureDetector3 = gestureDetector2;
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener3 = simpleOnGestureListener2;
        simpleOnGestureListener2 = new GestureDetector.SimpleOnGestureListener(){

            public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f2, float f3) {
                if (SubsamplingScaleImageView.this.panEnabled && SubsamplingScaleImageView.this.readySent && SubsamplingScaleImageView.this.vTranslate != null && motionEvent != null && motionEvent2 != null && (Math.abs(motionEvent.getX() - motionEvent2.getX()) > 50.0f || Math.abs(motionEvent.getY() - motionEvent2.getY()) > 50.0f) && (Math.abs(f2) > 500.0f || Math.abs(f3) > 500.0f) && !SubsamplingScaleImageView.this.isZooming) {
                    PointF pointF;
                    2 v0 = this;
                    motionEvent = pointF;
                    pointF = new PointF(((SubsamplingScaleImageView)SubsamplingScaleImageView.this).vTranslate.x + f2 * 0.25f, ((SubsamplingScaleImageView)SubsamplingScaleImageView.this).vTranslate.y + f3 * 0.25f);
                    float f4 = ((float)(v0.SubsamplingScaleImageView.this.getWidth() / 2) - motionEvent.x) / SubsamplingScaleImageView.this.scale;
                    float f5 = ((float)(v0.SubsamplingScaleImageView.this.getHeight() / 2) - motionEvent.y) / SubsamplingScaleImageView.this.scale;
                    new AnimationBuilder(SubsamplingScaleImageView.this, new PointF(f4, f5)).withEasing(1).withPanLimited(false).withOrigin(3).start();
                    return true;
                }
                return super.onFling(motionEvent, motionEvent2, f2, f3);
            }

            public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
                SubsamplingScaleImageView.this.performClick();
                return true;
            }

            public boolean onDoubleTap(MotionEvent motionEvent) {
                if (this_.SubsamplingScaleImageView.this.zoomEnabled && this_.SubsamplingScaleImageView.this.readySent && this_.SubsamplingScaleImageView.this.vTranslate != null) {
                    PointF pointF;
                    PointF pointF2;
                    2 v0 = this_;
                    v0.SubsamplingScaleImageView.this.setGestureDetector(this_.context);
                    if (v0.SubsamplingScaleImageView.this.quickScaleEnabled) {
                        2 v1 = this_;
                        MotionEvent motionEvent2 = motionEvent;
                        float f2 = motionEvent2.getX();
                        SubsamplingScaleImageView.access$1702(v1.SubsamplingScaleImageView.this, new PointF(f2, motionEvent2.getY()));
                        SubsamplingScaleImageView.access$1802(v1.SubsamplingScaleImageView.this, new PointF(((SubsamplingScaleImageView)this_.SubsamplingScaleImageView.this).vTranslate.x, ((SubsamplingScaleImageView)this_.SubsamplingScaleImageView.this).vTranslate.y));
                        SubsamplingScaleImageView subsamplingScaleImageView = v1.SubsamplingScaleImageView.this;
                        SubsamplingScaleImageView.access$1902(subsamplingScaleImageView, subsamplingScaleImageView.scale);
                        SubsamplingScaleImageView.access$2002(v1.SubsamplingScaleImageView.this, true);
                        SubsamplingScaleImageView.access$902(v1.SubsamplingScaleImageView.this, true);
                        SubsamplingScaleImageView.access$2102(v1.SubsamplingScaleImageView.this, -1.0f);
                        SubsamplingScaleImageView subsamplingScaleImageView2 = v1.SubsamplingScaleImageView.this;
                        SubsamplingScaleImageView.access$2202(subsamplingScaleImageView2, subsamplingScaleImageView2.viewToSourceCoord(subsamplingScaleImageView2.vCenterStart));
                        MotionEvent motionEvent3 = motionEvent;
                        float f3 = motionEvent3.getX();
                        SubsamplingScaleImageView.access$2302(v1.SubsamplingScaleImageView.this, new PointF(f3, motionEvent3.getY()));
                        SubsamplingScaleImageView.access$2402(v1.SubsamplingScaleImageView.this, new PointF(((SubsamplingScaleImageView)this_.SubsamplingScaleImageView.this).quickScaleSCenter.x, ((SubsamplingScaleImageView)this_.SubsamplingScaleImageView.this).quickScaleSCenter.y));
                        SubsamplingScaleImageView.access$2502(v1.SubsamplingScaleImageView.this, false);
                        return false;
                    }
                    SubsamplingScaleImageView subsamplingScaleImageView = this_.SubsamplingScaleImageView.this;
                    2 this_ = pointF2;
                    MotionEvent motionEvent4 = motionEvent;
                    float f4 = motionEvent4.getX();
                    pointF2 = new PointF(f4, motionEvent4.getY());
                    this_ = subsamplingScaleImageView.viewToSourceCoord((PointF)this_);
                    PointF pointF3 = pointF;
                    MotionEvent motionEvent5 = motionEvent;
                    float f5 = motionEvent5.getX();
                    pointF = new PointF(f5, motionEvent5.getY());
                    subsamplingScaleImageView.doubleTapZoom((PointF)this_, pointF3);
                    return true;
                }
                return super.onDoubleTapEvent(motionEvent);
            }
        };
        gestureDetector2 = new GestureDetector(context, (GestureDetector.OnGestureListener)simpleOnGestureListener3);
        subsamplingScaleImageView.detector = gestureDetector3;
        gestureDetector3 = gestureDetector;
        simpleOnGestureListener3 = simpleOnGestureListener;
        simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
                SubsamplingScaleImageView.this.performClick();
                return true;
            }

            public void onLongPress(MotionEvent motionEvent) {
                SubsamplingScaleImageView.this.performLongClick();
            }
        };
        gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)simpleOnGestureListener3);
        subsamplingScaleImageView.singleDetector = gestureDetector3;
    }

    private boolean onTouchEventInternal(@NonNull MotionEvent motionEvent) {
        int n2;
        block44: {
            int n3;
            block45: {
                block47: {
                    block46: {
                        MotionEvent motionEvent2 = motionEvent;
                        n2 = motionEvent2.getPointerCount();
                        n3 = motionEvent2.getAction();
                        if (n3 == 0) break block44;
                        if (n3 == 1) break block45;
                        if (n3 == 2) break block46;
                        if (n3 == 5) break block44;
                        if (n3 == 6) break block45;
                        if (n3 == 261) break block44;
                        if (n3 == 262) break block45;
                        break block47;
                    }
                    n3 = 0;
                    if (this.maxTouchCount > 0) {
                        if (n2 >= 2) {
                            MotionEvent motionEvent3 = motionEvent;
                            MotionEvent motionEvent4 = motionEvent;
                            float f2 = motionEvent4.getX(0);
                            float f3 = motionEvent4.getX(1);
                            float f4 = motionEvent4.getY(0);
                            float f5 = motionEvent4.getY(1);
                            f2 = this.distance(f2, f3, f4, f5);
                            f3 = (motionEvent3.getX(0) + motionEvent.getX(1)) / 2.0f;
                            float f6 = (motionEvent3.getY(0) + motionEvent.getY(1)) / 2.0f;
                            if (this.zoomEnabled) {
                                SubsamplingScaleImageView subsamplingScaleImageView = this;
                                PointF pointF = subsamplingScaleImageView.vCenterStart;
                                f4 = pointF.x;
                                f5 = pointF.y;
                                if (subsamplingScaleImageView.distance(f4, f3, f5, f6) > 5.0f || Math.abs(f2 - this.vDistStart) > 5.0f || this.isPanning) {
                                    SubsamplingScaleImageView subsamplingScaleImageView2;
                                    float f7;
                                    float f8;
                                    SubsamplingScaleImageView subsamplingScaleImageView3 = this;
                                    subsamplingScaleImageView3.isZooming = true;
                                    subsamplingScaleImageView3.isPanning = true;
                                    n3 = 1;
                                    double d2 = subsamplingScaleImageView3.scale;
                                    this.scale = f8 = Math.min(subsamplingScaleImageView3.maxScale, f2 / this.vDistStart * this.scaleStart);
                                    if (f7 <= subsamplingScaleImageView2.minScale()) {
                                        SubsamplingScaleImageView subsamplingScaleImageView4 = this;
                                        subsamplingScaleImageView4.vDistStart = f2;
                                        subsamplingScaleImageView4.scaleStart = subsamplingScaleImageView4.minScale();
                                        subsamplingScaleImageView4.vCenterStart.set(f3, f6);
                                        subsamplingScaleImageView4.vTranslateStart.set(this.vTranslate);
                                    } else if (this.panEnabled) {
                                        SubsamplingScaleImageView subsamplingScaleImageView5 = this;
                                        PointF pointF2 = subsamplingScaleImageView5.vCenterStart;
                                        PointF pointF3 = this.vTranslateStart;
                                        float f9 = pointF2.x - pointF3.x;
                                        float f10 = this.scale;
                                        float f11 = this.scaleStart;
                                        f9 *= f10 / f11;
                                        f11 = (pointF2.y - pointF3.y) * (f10 / f11);
                                        PointF pointF4 = subsamplingScaleImageView5.vTranslate;
                                        pointF4.x = f3 - f9;
                                        subsamplingScaleImageView5.vTranslate.y = f6 - f11;
                                        if (d2 * (double)subsamplingScaleImageView5.sHeight() < (double)this.getHeight() && this.scale * (float)this.sHeight() >= (float)this.getHeight() || d2 * (double)this.sWidth() < (double)this.getWidth() && this.scale * (float)this.sWidth() >= (float)this.getWidth()) {
                                            SubsamplingScaleImageView subsamplingScaleImageView6 = this;
                                            subsamplingScaleImageView6.fitToBounds(true);
                                            subsamplingScaleImageView6.vCenterStart.set(f3, f6);
                                            subsamplingScaleImageView6.vTranslateStart.set(this.vTranslate);
                                            subsamplingScaleImageView6.scaleStart = subsamplingScaleImageView6.scale;
                                            this.vDistStart = f2;
                                        }
                                    } else if (this.sRequestedCenter != null) {
                                        SubsamplingScaleImageView subsamplingScaleImageView7 = this;
                                        subsamplingScaleImageView7.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * this.sRequestedCenter.x;
                                        subsamplingScaleImageView7.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * this.sRequestedCenter.y;
                                    } else {
                                        SubsamplingScaleImageView subsamplingScaleImageView8 = this;
                                        subsamplingScaleImageView8.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * (float)(this.sWidth() / 2);
                                        subsamplingScaleImageView8.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * (float)(this.sHeight() / 2);
                                    }
                                    SubsamplingScaleImageView subsamplingScaleImageView9 = this;
                                    subsamplingScaleImageView9.fitToBounds(true);
                                    subsamplingScaleImageView9.refreshRequiredTiles(subsamplingScaleImageView9.eagerLoadingEnabled);
                                }
                            }
                        } else if (this.isQuickScaling) {
                            PointF pointF;
                            SubsamplingScaleImageView subsamplingScaleImageView = this;
                            float f12 = Math.abs(subsamplingScaleImageView.quickScaleVStart.y - motionEvent.getY()) * 2.0f + this.quickScaleThreshold;
                            if (subsamplingScaleImageView.quickScaleLastDistance == -1.0f) {
                                this.quickScaleLastDistance = f12;
                            }
                            PointF pointF5 = this.quickScaleVLastPoint;
                            boolean bl = motionEvent.getY() > pointF.y;
                            pointF5.set(0.0f, motionEvent.getY());
                            float f13 = Math.abs(1.0f - f12 / this.quickScaleLastDistance) * 0.5f;
                            if (f13 > 0.03f || this.quickScaleMoved) {
                                SubsamplingScaleImageView subsamplingScaleImageView10;
                                this.quickScaleMoved = true;
                                float f14 = 1.0f;
                                f13 = subsamplingScaleImageView10.quickScaleLastDistance > 0.0f ? (bl ? (f13 += 1.0f) : 1.0f - f13) : f14;
                                SubsamplingScaleImageView subsamplingScaleImageView11 = this;
                                double d3 = subsamplingScaleImageView11.scale;
                                subsamplingScaleImageView11.scale = f13 = Math.max(subsamplingScaleImageView11.minScale(), Math.min(this.maxScale, this.scale * f13));
                                if (subsamplingScaleImageView11.panEnabled) {
                                    SubsamplingScaleImageView subsamplingScaleImageView12 = this;
                                    PointF pointF6 = subsamplingScaleImageView12.vCenterStart;
                                    float f15 = pointF6.x;
                                    PointF pointF7 = this.vTranslateStart;
                                    float f16 = f15 - pointF7.x;
                                    float f17 = pointF6.y;
                                    float f18 = f13;
                                    float f19 = f13;
                                    f13 = this.scaleStart;
                                    float f20 = f16 * (f19 / f13);
                                    f13 = (f17 - pointF7.y) * (f18 / f13);
                                    PointF pointF8 = subsamplingScaleImageView12.vTranslate;
                                    pointF8.x = f15 - f20;
                                    subsamplingScaleImageView12.vTranslate.y = f17 - f13;
                                    if (d3 * (double)subsamplingScaleImageView12.sHeight() < (double)this.getHeight() && this.scale * (float)this.sHeight() >= (float)this.getHeight() || d3 * (double)this.sWidth() < (double)this.getWidth() && this.scale * (float)this.sWidth() >= (float)this.getWidth()) {
                                        SubsamplingScaleImageView subsamplingScaleImageView13 = this;
                                        subsamplingScaleImageView13.fitToBounds(true);
                                        SubsamplingScaleImageView subsamplingScaleImageView14 = this;
                                        subsamplingScaleImageView13.vCenterStart.set(subsamplingScaleImageView14.sourceToViewCoord(subsamplingScaleImageView14.quickScaleSCenter));
                                        subsamplingScaleImageView13.vTranslateStart.set(this.vTranslate);
                                        subsamplingScaleImageView13.scaleStart = subsamplingScaleImageView13.scale;
                                        f12 = 0.0f;
                                    }
                                } else if (this.sRequestedCenter != null) {
                                    SubsamplingScaleImageView subsamplingScaleImageView15 = this;
                                    subsamplingScaleImageView15.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * this.sRequestedCenter.x;
                                    subsamplingScaleImageView15.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * this.sRequestedCenter.y;
                                } else {
                                    SubsamplingScaleImageView subsamplingScaleImageView16 = this;
                                    subsamplingScaleImageView16.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * (float)(this.sWidth() / 2);
                                    subsamplingScaleImageView16.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * (float)(this.sHeight() / 2);
                                }
                            }
                            SubsamplingScaleImageView subsamplingScaleImageView17 = this;
                            subsamplingScaleImageView17.quickScaleLastDistance = f12;
                            subsamplingScaleImageView17.fitToBounds(true);
                            subsamplingScaleImageView17.refreshRequiredTiles(subsamplingScaleImageView17.eagerLoadingEnabled);
                            n3 = 1;
                        } else if (!this.isZooming) {
                            float f21 = Math.abs(motionEvent.getX() - this.vCenterStart.x);
                            float f22 = Math.abs(motionEvent.getY() - this.vCenterStart.y);
                            float f23 = this.density * 5.0f;
                            float f24 = f21 - f23;
                            float f25 = f24 == 0.0f ? 0 : (f24 > 0.0f ? 1 : -1);
                            if (f25 > 0 || f22 > f23 || this.isPanning) {
                                n3 = 1;
                                this.vTranslate.x = this.vTranslateStart.x + (motionEvent.getX() - this.vCenterStart.x);
                                this.vTranslate.y = this.vTranslateStart.y + (motionEvent.getY() - this.vCenterStart.y);
                                motionEvent = this.vTranslate;
                                float f26 = motionEvent.x;
                                SubsamplingScaleImageView subsamplingScaleImageView = this;
                                float f27 = motionEvent.y;
                                subsamplingScaleImageView.fitToBounds(true);
                                PointF pointF = subsamplingScaleImageView.vTranslate;
                                boolean bl = f26 != pointF.x;
                                float f28 = pointF.y;
                                boolean bl2 = f27 != f28;
                                boolean bl3 = bl && f21 > f22 && !this.isPanning;
                                boolean bl4 = bl2 && f22 > f21 && !this.isPanning;
                                boolean bl5 = f27 == f28 && f22 > f23 * 3.0f;
                                if (!(bl3 || bl4 || bl && bl2 && !bl5 && !this.isPanning)) {
                                    this.isPanning = true;
                                } else if (f25 > 0 || f22 > f23) {
                                    SubsamplingScaleImageView subsamplingScaleImageView18 = this;
                                    subsamplingScaleImageView18.maxTouchCount = 0;
                                    subsamplingScaleImageView18.handler.removeMessages(1);
                                    subsamplingScaleImageView18.requestDisallowInterceptTouchEvent(false);
                                }
                                if (!this.panEnabled) {
                                    SubsamplingScaleImageView subsamplingScaleImageView19 = this;
                                    PointF pointF9 = subsamplingScaleImageView19.vTranslate;
                                    PointF pointF10 = this.vTranslateStart;
                                    pointF9.x = pointF10.x;
                                    pointF9.y = pointF10.y;
                                    subsamplingScaleImageView19.requestDisallowInterceptTouchEvent(false);
                                }
                                SubsamplingScaleImageView subsamplingScaleImageView20 = this;
                                subsamplingScaleImageView20.refreshRequiredTiles(subsamplingScaleImageView20.eagerLoadingEnabled);
                            }
                        }
                    }
                    if (n3 != 0) {
                        SubsamplingScaleImageView subsamplingScaleImageView = this;
                        subsamplingScaleImageView.handler.removeMessages(1);
                        subsamplingScaleImageView.invalidate();
                        return true;
                    }
                }
                return false;
            }
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            subsamplingScaleImageView.handler.removeMessages(1);
            if (subsamplingScaleImageView.isQuickScaling) {
                this.isQuickScaling = false;
                if (!this.quickScaleMoved) {
                    SubsamplingScaleImageView subsamplingScaleImageView21 = this;
                    PointF pointF = subsamplingScaleImageView21.quickScaleSCenter;
                    subsamplingScaleImageView21.doubleTapZoom(pointF, subsamplingScaleImageView21.vCenterStart);
                }
            }
            if (this.maxTouchCount > 0) {
                boolean bl = this.isZooming;
                n3 = bl ? 1 : 0;
                if (bl || this.isPanning) {
                    if (n3 != 0 && n2 == 2) {
                        this.isPanning = true;
                        PointF pointF = this.vTranslate;
                        float f29 = pointF.x;
                        this.vTranslateStart.set(f29, pointF.y);
                        if (motionEvent.getActionIndex() == 1) {
                            MotionEvent motionEvent5 = motionEvent;
                            float f30 = motionEvent5.getX(0);
                            this.vCenterStart.set(f30, motionEvent5.getY(0));
                        } else {
                            MotionEvent motionEvent6 = motionEvent;
                            float f31 = motionEvent6.getX(1);
                            this.vCenterStart.set(f31, motionEvent6.getY(1));
                        }
                    }
                    if (n2 < 3) {
                        this.isZooming = false;
                    }
                    if (n2 < 2) {
                        SubsamplingScaleImageView subsamplingScaleImageView22 = this;
                        subsamplingScaleImageView22.isPanning = false;
                        subsamplingScaleImageView22.maxTouchCount = 0;
                    }
                    this.refreshRequiredTiles(true);
                    return true;
                }
            }
            if (n2 == 1) {
                SubsamplingScaleImageView subsamplingScaleImageView23 = this;
                subsamplingScaleImageView23.isZooming = false;
                subsamplingScaleImageView23.isPanning = false;
                subsamplingScaleImageView23.maxTouchCount = 0;
            }
            return true;
        }
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        subsamplingScaleImageView.anim = null;
        subsamplingScaleImageView.requestDisallowInterceptTouchEvent(true);
        subsamplingScaleImageView.maxTouchCount = Math.max(subsamplingScaleImageView.maxTouchCount, n2);
        if (n2 >= 2) {
            if (this.zoomEnabled) {
                SubsamplingScaleImageView subsamplingScaleImageView24 = this;
                MotionEvent motionEvent7 = motionEvent;
                float f32 = motionEvent7.getX(0);
                float f33 = motionEvent7.getX(1);
                float f34 = motionEvent7.getY(0);
                float f35 = motionEvent7.getY(1);
                f32 = subsamplingScaleImageView24.distance(f32, f33, f34, f35);
                subsamplingScaleImageView24.scaleStart = subsamplingScaleImageView24.scale;
                subsamplingScaleImageView24.vDistStart = f32;
                PointF pointF = this.vTranslate;
                f32 = pointF.x;
                subsamplingScaleImageView24.vTranslateStart.set(f32, pointF.y);
                MotionEvent motionEvent8 = motionEvent;
                f32 = (motionEvent8.getX(0) + motionEvent.getX(1)) / 2.0f;
                subsamplingScaleImageView24.vCenterStart.set(f32, (motionEvent8.getY(0) + motionEvent.getY(1)) / 2.0f);
            } else {
                this.maxTouchCount = 0;
            }
            this.handler.removeMessages(1);
        } else if (!this.isQuickScaling) {
            SubsamplingScaleImageView subsamplingScaleImageView25 = this;
            PointF pointF = this.vTranslate;
            float f36 = pointF.x;
            subsamplingScaleImageView25.vTranslateStart.set(f36, pointF.y);
            MotionEvent motionEvent9 = motionEvent;
            f36 = motionEvent9.getX();
            subsamplingScaleImageView25.vCenterStart.set(f36, motionEvent9.getY());
            subsamplingScaleImageView25.handler.sendEmptyMessageDelayed(1, 600L);
        }
        return true;
    }

    private void requestDisallowInterceptTouchEvent(boolean bl) {
        if ((this = this.getParent()) != null) {
            this.requestDisallowInterceptTouchEvent(bl);
        }
    }

    private void doubleTapZoom(PointF pointF, PointF pointF2) {
        if (!this.panEnabled) {
            PointF pointF3 = this.sRequestedCenter;
            if (pointF3 != null) {
                pointF.x = pointF3.x;
                pointF.y = pointF3.y;
            } else {
                pointF.x = this.sWidth() / 2;
                pointF.y = this.sHeight() / 2;
            }
        }
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        float f2 = subsamplingScaleImageView.scale;
        float f3 = Math.min(subsamplingScaleImageView.maxScale, this.doubleTapZoomScale);
        boolean bl = (double)f2 <= (double)f3 * 0.9 || f2 == this.minScale;
        if (!bl) {
            f3 = this.minScale();
        }
        int n2 = this.doubleTapZoomStyle;
        if (n2 == 3) {
            this.setScaleAndCenter(f3, pointF);
        } else if (n2 != 2 && bl && this.panEnabled) {
            if (n2 == 1) {
                new AnimationBuilder(this, f3, pointF, pointF2).withInterruptible(false).withDuration(this.doubleTapZoomDuration).withOrigin(4).start();
            }
        } else {
            new AnimationBuilder(this, f3, pointF).withInterruptible(false).withDuration(this.doubleTapZoomDuration).withOrigin(4).start();
        }
        this.invalidate();
    }

    private void setMatrixArray(float[] fArray, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float[] fArray2 = fArray;
        float[] fArray3 = fArray;
        fArray2[0] = f2;
        fArray3[1] = f3;
        fArray2[2] = f4;
        fArray3[3] = f5;
        fArray2[4] = f6;
        fArray3[5] = f7;
        fArray2[6] = f8;
        fArray3[7] = f9;
    }

    private boolean isBaseLayerReady() {
        if (this.bitmap != null && !this.bitmapIsPreview) {
            return true;
        }
        Map<Integer, List<Tile>> map = this.tileMap;
        if (map != null) {
            boolean bl = true;
            for (Map.Entry<Integer, List<Tile>> entry : map.entrySet()) {
                if (entry.getKey() != this.fullImageSampleSize) continue;
                entry = entry.getValue().iterator();
                while (entry.hasNext()) {
                    Tile tile = (Tile)entry.next();
                    if (!tile.loading && tile.bitmap != null) continue;
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    private boolean checkReady() {
        boolean bl = onImageEventListener.getWidth() > 0 && onImageEventListener.getHeight() > 0 && ((SubsamplingScaleImageView)((Object)onImageEventListener)).sWidth > 0 && ((SubsamplingScaleImageView)((Object)onImageEventListener)).sHeight > 0 && (((SubsamplingScaleImageView)((Object)onImageEventListener)).bitmap != null || ((SubsamplingScaleImageView)((Object)onImageEventListener)).isBaseLayerReady());
        if (!((SubsamplingScaleImageView)((Object)onImageEventListener)).readySent && bl) {
            SubsamplingScaleImageView subsamplingScaleImageView = onImageEventListener;
            subsamplingScaleImageView.preDraw();
            subsamplingScaleImageView.readySent = true;
            subsamplingScaleImageView.onReady();
            OnImageEventListener onImageEventListener = subsamplingScaleImageView.onImageEventListener;
            if (onImageEventListener != null) {
                onImageEventListener.onReady();
            }
        }
        return bl;
    }

    private boolean checkImageLoaded() {
        SubsamplingScaleImageView subsamplingScaleImageView = onImageEventListener;
        boolean bl = subsamplingScaleImageView.isBaseLayerReady();
        if (!subsamplingScaleImageView.imageLoadedSent && bl) {
            SubsamplingScaleImageView subsamplingScaleImageView2 = onImageEventListener;
            subsamplingScaleImageView2.preDraw();
            subsamplingScaleImageView2.imageLoadedSent = true;
            subsamplingScaleImageView2.onImageLoaded();
            OnImageEventListener onImageEventListener = subsamplingScaleImageView2.onImageEventListener;
            if (onImageEventListener != null) {
                onImageEventListener.onImageLoaded();
            }
        }
        return bl;
    }

    private void createPaints() {
        if (this.bitmapPaint == null) {
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            this.bitmapPaint = new Paint();
            this.bitmapPaint.setAntiAlias(true);
            subsamplingScaleImageView.bitmapPaint.setFilterBitmap(true);
            subsamplingScaleImageView.bitmapPaint.setDither(true);
        }
        if ((this.debugTextPaint == null || this.debugLinePaint == null) && this.debug) {
            Paint paint;
            Paint paint2;
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            Paint paint3 = paint2 = paint;
            paint3();
            this.debugTextPaint = paint3;
            paint.setTextSize((float)this.px(12));
            subsamplingScaleImageView.debugTextPaint.setColor(-65281);
            subsamplingScaleImageView.debugTextPaint.setStyle(Paint.Style.FILL);
            this.debugLinePaint = new Paint();
            this.debugLinePaint.setColor(-65281);
            subsamplingScaleImageView.debugLinePaint.setStyle(Paint.Style.STROKE);
            subsamplingScaleImageView.debugLinePaint.setStrokeWidth((float)this.px(1));
        }
    }

    private synchronized void initialiseBaseLayer(@NonNull Point object) {
        int n2;
        PointF pointF;
        ScaleAndTranslate scaleAndTranslate;
        SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView4;
        Object[] objectArray = new Object[2];
        Object object2 = objectArray;
        object2[0] = ((Point)object).x;
        objectArray[1] = ((Point)object).y;
        subsamplingScaleImageView.debug("initialiseBaseLayer maxTileDimensions=%dx%d", object2);
        object2 = scaleAndTranslate;
        PointF pointF2 = pointF;
        pointF = new PointF(0.0f, 0.0f);
        subsamplingScaleImageView.satTemp = new ScaleAndTranslate(0.0f, pointF2);
        subsamplingScaleImageView.fitToBounds(true, (ScaleAndTranslate)object2);
        subsamplingScaleImageView4.fullImageSampleSize = n2 = subsamplingScaleImageView.calculateInSampleSize(subsamplingScaleImageView.satTemp.scale);
        if (n2 > 1) {
            subsamplingScaleImageView4.fullImageSampleSize = n2 / 2;
        }
        if (subsamplingScaleImageView4.fullImageSampleSize == 1 && subsamplingScaleImageView4.sRegion == null && subsamplingScaleImageView4.sWidth() < ((Point)object).x && subsamplingScaleImageView4.sHeight() < ((Point)object).y) {
            SubsamplingScaleImageView subsamplingScaleImageView2 = subsamplingScaleImageView4;
            subsamplingScaleImageView2.decoder.recycle();
            subsamplingScaleImageView2.decoder = null;
            SubsamplingScaleImageView subsamplingScaleImageView3 = subsamplingScaleImageView4;
            SubsamplingScaleImageView subsamplingScaleImageView4 = subsamplingScaleImageView3.getContext();
            object = subsamplingScaleImageView3.bitmapDecoderFactory;
            Uri uri = subsamplingScaleImageView3.uri;
            subsamplingScaleImageView2.execute(new BitmapLoadTask(subsamplingScaleImageView3, (Context)subsamplingScaleImageView4, (DecoderFactory<? extends ImageDecoder>)object, uri, false));
        } else {
            SubsamplingScaleImageView subsamplingScaleImageView5 = subsamplingScaleImageView4;
            subsamplingScaleImageView5.initialiseTileMap((Point)object);
            for (Tile tile : subsamplingScaleImageView5.tileMap.get(subsamplingScaleImageView4.fullImageSampleSize)) {
                SubsamplingScaleImageView subsamplingScaleImageView6 = subsamplingScaleImageView4;
                subsamplingScaleImageView4.execute(new TileLoadTask(subsamplingScaleImageView6, subsamplingScaleImageView6.decoder, tile));
            }
            subsamplingScaleImageView4.refreshRequiredTiles(true);
        }
    }

    private void refreshRequiredTiles(boolean bl) {
        if (this.decoder != null && this.tileMap != null) {
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            SubsamplingScaleImageView subsamplingScaleImageView2 = this;
            int n2 = Math.min(subsamplingScaleImageView.fullImageSampleSize, subsamplingScaleImageView2.calculateInSampleSize(subsamplingScaleImageView2.scale));
            Iterator<Map.Entry<Integer, List<Tile>>> iterator = subsamplingScaleImageView.tileMap.entrySet().iterator();
            while (iterator.hasNext()) {
                for (Tile tile : iterator.next().getValue()) {
                    if (tile.sampleSize < n2 || tile.sampleSize > n2 && tile.sampleSize != this.fullImageSampleSize) {
                        Tile tile2 = tile;
                        Tile.access$402(tile2, false);
                        if (tile2.bitmap != null) {
                            Tile tile3 = tile;
                            tile3.bitmap.recycle();
                            Tile.access$502(tile3, null);
                        }
                    }
                    if (tile.sampleSize == n2) {
                        if (this.tileVisible(tile)) {
                            TileLoadTask tileLoadTask;
                            Tile tile4 = tile;
                            Tile.access$402(tile4, true);
                            if (tile4.loading || tile.bitmap != null || !bl) continue;
                            TileLoadTask tileLoadTask2 = tileLoadTask;
                            tileLoadTask = new TileLoadTask(this, this.decoder, tile);
                            this.execute(tileLoadTask2);
                            continue;
                        }
                        if (tile.sampleSize == this.fullImageSampleSize) continue;
                        Tile tile5 = tile;
                        Tile.access$402(tile5, false);
                        if (tile5.bitmap == null) continue;
                        Tile tile6 = tile;
                        tile6.bitmap.recycle();
                        Tile.access$502(tile6, null);
                        continue;
                    }
                    if (tile.sampleSize != this.fullImageSampleSize) continue;
                    Tile.access$402(tile, true);
                }
            }
            return;
        }
    }

    private boolean tileVisible(Tile tile) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        float f2 = subsamplingScaleImageView.viewToSourceX(subsamplingScaleImageView.getWidth());
        float f3 = subsamplingScaleImageView.viewToSourceY(0.0f);
        float f4 = subsamplingScaleImageView.viewToSourceY(subsamplingScaleImageView.getHeight());
        return !(this.viewToSourceX(0.0f) > (float)((Tile)tile).sRect.right || (float)((Tile)tile).sRect.left > f2 || f3 > (float)((Tile)tile).sRect.bottom || (float)((Tile)tile).sRect.top > f4);
    }

    private void preDraw() {
        if (this.getWidth() != 0 && this.getHeight() != 0 && this.sWidth > 0 && this.sHeight > 0) {
            Float f2;
            if (this.sPendingCenter != null && (f2 = this.pendingScale) != null) {
                this.scale = f2.floatValue();
                if (this.vTranslate == null) {
                    PointF pointF;
                    f2 = pointF;
                    pointF = new PointF();
                    this.vTranslate = f2;
                }
                SubsamplingScaleImageView subsamplingScaleImageView = this;
                subsamplingScaleImageView.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * this.sPendingCenter.x;
                subsamplingScaleImageView.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * this.sPendingCenter.y;
                subsamplingScaleImageView.sPendingCenter = null;
                subsamplingScaleImageView.pendingScale = null;
                subsamplingScaleImageView.fitToBounds(true);
                subsamplingScaleImageView.refreshRequiredTiles(true);
            }
            this.fitToBounds(false);
            return;
        }
    }

    private int calculateInSampleSize(float f2) {
        if (this.minimumTileDpi > 0) {
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            DisplayMetrics displayMetrics = subsamplingScaleImageView.getResources().getDisplayMetrics();
            float f3 = (displayMetrics.xdpi + displayMetrics.ydpi) / 2.0f;
            f2 = (float)subsamplingScaleImageView.minimumTileDpi / f3 * f2;
        }
        int n2 = (int)((float)this.sWidth() * f2);
        int n3 = (int)((float)this.sHeight() * f2);
        int n4 = 1;
        if (n2 != 0 && n3 != 0) {
            int n5;
            if (this.sHeight() <= n3 && this.sWidth() <= n2) {
                n5 = n4;
            } else {
                n3 = Math.round((float)this.sHeight() / (float)n3);
                if (n3 < (n5 = Math.round((float)this.sWidth() / (float)n2))) {
                    n5 = n3;
                }
            }
            n3 = 1;
            while ((n2 = n3 * 2) < n5) {
                n3 = n2;
            }
            return n3;
        }
        return 32;
    }

    private void fitToBounds(boolean bl, ScaleAndTranslate scaleAndTranslate) {
        float f2;
        float f3;
        if (this.panLimit == 2 && this.isReady()) {
            bl = false;
        }
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        ScaleAndTranslate scaleAndTranslate2 = scaleAndTranslate;
        PointF pointF = scaleAndTranslate2.vTranslate;
        float f4 = subsamplingScaleImageView.limitedScale(scaleAndTranslate2.scale);
        float f5 = f4 * (float)this.sWidth();
        float f6 = f4 * (float)this.sHeight();
        if (subsamplingScaleImageView.panLimit == 3 && this.isReady()) {
            PointF pointF2 = pointF;
            pointF2.x = Math.max(pointF2.x, (float)(this.getWidth() / 2) - f5);
            pointF2.y = Math.max(pointF2.y, (float)(this.getHeight() / 2) - f6);
        } else if (bl) {
            PointF pointF3 = pointF;
            pointF3.x = Math.max(pointF3.x, (float)this.getWidth() - f5);
            pointF3.y = Math.max(pointF3.y, (float)this.getHeight() - f6);
        } else {
            PointF pointF4 = pointF;
            pointF4.x = Math.max(pointF4.x, -f5);
            pointF4.y = Math.max(pointF4.y, -f6);
        }
        float f7 = this.getPaddingLeft() <= 0 && this.getPaddingRight() <= 0 ? 0.5f : (float)this.getPaddingLeft() / (float)(this.getPaddingLeft() + this.getPaddingRight());
        float f8 = this.getPaddingTop() <= 0 && this.getPaddingBottom() <= 0 ? 0.5f : (float)this.getPaddingTop() / (float)(this.getPaddingTop() + this.getPaddingBottom());
        if (this.panLimit == 3 && this.isReady()) {
            SubsamplingScaleImageView subsamplingScaleImageView2 = this;
            f3 = Math.max(0, subsamplingScaleImageView2.getWidth() / 2);
            f2 = Math.max(0, subsamplingScaleImageView2.getHeight() / 2);
        } else if (bl) {
            SubsamplingScaleImageView subsamplingScaleImageView3 = this;
            f3 = Math.max(0.0f, ((float)subsamplingScaleImageView3.getWidth() - f5) * f7);
            f2 = Math.max(0.0f, ((float)subsamplingScaleImageView3.getHeight() - f6) * f8);
        } else {
            SubsamplingScaleImageView subsamplingScaleImageView4 = this;
            f3 = Math.max(0, subsamplingScaleImageView4.getWidth());
            f2 = Math.max(0, subsamplingScaleImageView4.getHeight());
        }
        PointF pointF5 = pointF;
        pointF5.x = Math.min(pointF5.x, f3);
        pointF5.y = Math.min(pointF5.y, f2);
        ScaleAndTranslate.access$4702(scaleAndTranslate, f4);
    }

    private void fitToBounds(boolean bl) {
        Object object;
        boolean bl2 = false;
        if (this.vTranslate == null) {
            PointF pointF;
            bl2 = true;
            object = pointF;
            pointF = new PointF(0.0f, 0.0f);
            this.vTranslate = object;
        }
        if (this.satTemp == null) {
            PointF pointF;
            ScaleAndTranslate scaleAndTranslate;
            object = scaleAndTranslate;
            PointF pointF2 = pointF;
            pointF = new PointF(0.0f, 0.0f);
            scaleAndTranslate = new ScaleAndTranslate(0.0f, pointF2);
            this.satTemp = object;
        }
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        SubsamplingScaleImageView subsamplingScaleImageView2 = this;
        ScaleAndTranslate.access$4702(subsamplingScaleImageView2.satTemp, this.scale);
        subsamplingScaleImageView2.satTemp.vTranslate.set(this.vTranslate);
        subsamplingScaleImageView.fitToBounds(bl, subsamplingScaleImageView2.satTemp);
        subsamplingScaleImageView.scale = subsamplingScaleImageView.satTemp.scale;
        subsamplingScaleImageView.vTranslate.set(this.satTemp.vTranslate);
        if (bl2 && this.minimumScaleType != 4) {
            SubsamplingScaleImageView subsamplingScaleImageView3 = this;
            float f2 = subsamplingScaleImageView3.sWidth() / 2;
            float f3 = subsamplingScaleImageView3.sHeight() / 2;
            float f4 = subsamplingScaleImageView3.scale;
            this.vTranslate.set(subsamplingScaleImageView3.vTranslateForSCenter(f2, f3, f4));
        }
    }

    private void initialiseTileMap(Point point) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = point.x;
        objectArray[1] = point.y;
        subsamplingScaleImageView.debug("initialiseTileMap maxTileDimensions=%dx%d", objectArray2);
        subsamplingScaleImageView.tileMap = new LinkedHashMap<Integer, List<Tile>>();
        int n2 = subsamplingScaleImageView.fullImageSampleSize;
        int n3 = 1;
        int n4 = 1;
        block0: while (true) {
            SubsamplingScaleImageView subsamplingScaleImageView2 = this;
            int n5 = subsamplingScaleImageView2.sWidth() / n3;
            int n6 = subsamplingScaleImageView2.sHeight() / n4;
            int n7 = n5 / n2;
            int n8 = n6 / n2;
            while (true) {
                if (!(n7 + n3 + 1 > point.x || (double)n7 > (double)this.getWidth() * 1.25 && n2 < this.fullImageSampleSize)) {
                    while (true) {
                        if (!(n8 + n4 + 1 > point.y || (double)n8 > (double)this.getHeight() * 1.25 && n2 < this.fullImageSampleSize)) {
                            ArrayList<Tile> arrayList;
                            ArrayList<Tile> arrayList2 = arrayList;
                            arrayList = new ArrayList<Tile>(n3 * n4);
                            for (n8 = 0; n8 < n3; ++n8) {
                                for (int i2 = 0; i2 < n4; ++i2) {
                                    Rect rect;
                                    Tile tile;
                                    Tile tile2 = tile;
                                    tile2();
                                    Tile.access$4302(tile, n2);
                                    boolean bl = n2 == this.fullImageSampleSize;
                                    Tile.access$402(tile2, bl);
                                    int n9 = n8 * n5;
                                    int n10 = i2 * n6;
                                    int n11 = n8 == n3 - 1 ? this.sWidth() : (n8 + 1) * n5;
                                    int n12 = i2 == n4 - 1 ? this.sHeight() : (i2 + 1) * n6;
                                    Tile tile3 = tile2;
                                    Rect rect2 = rect;
                                    rect2(n9, n10, n11, n12);
                                    Tile.access$4102(tile3, rect2);
                                    Tile.access$4202(tile3, new Rect(0, 0, 0, 0));
                                    Tile.access$5002(tile3, new Rect(tile2.sRect));
                                    arrayList2.add(tile3);
                                }
                            }
                            this.tileMap.put(n2, arrayList2);
                            if (n2 == 1) {
                                return;
                            }
                            n2 /= 2;
                            continue block0;
                        }
                        n6 = this.sHeight() / ++n4;
                        n8 = n6 / n2;
                    }
                }
                n5 = this.sWidth() / ++n3;
                n7 = n5 / n2;
            }
            break;
        }
    }

    private synchronized void onTilesInited(ImageRegionDecoder imageRegionDecoder, int n2, int n3, int n4) {
        int n5;
        int n6;
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n2;
        objectArray2[1] = n3;
        objectArray[2] = this.orientation;
        subsamplingScaleImageView.debug("onTilesInited sWidth=%d, sHeight=%d, sOrientation=%d", objectArray2);
        int n7 = subsamplingScaleImageView.sWidth;
        if (n7 > 0 && (n6 = this.sHeight) > 0 && (n7 != n2 || n6 != n3)) {
            SubsamplingScaleImageView subsamplingScaleImageView2 = this;
            subsamplingScaleImageView2.reset(false);
            Object object = subsamplingScaleImageView2.bitmap;
            if (object != null) {
                if (!this.bitmapIsCached) {
                    object.recycle();
                }
                this.bitmap = null;
                object = this.onImageEventListener;
                if (object != null && this.bitmapIsCached) {
                    object.onPreviewReleased();
                }
                SubsamplingScaleImageView subsamplingScaleImageView3 = this;
                subsamplingScaleImageView3.bitmapIsPreview = false;
                subsamplingScaleImageView3.bitmapIsCached = false;
            }
        }
        SubsamplingScaleImageView subsamplingScaleImageView4 = this;
        this.decoder = imageRegionDecoder;
        this.sWidth = n2;
        this.sHeight = n3;
        subsamplingScaleImageView4.sOrientation = n4;
        subsamplingScaleImageView4.checkReady();
        if (!subsamplingScaleImageView4.checkImageLoaded() && (n5 = this.maxTileWidth) > 0 && n5 != Integer.MAX_VALUE && (n5 = this.maxTileHeight) > 0 && n5 != Integer.MAX_VALUE && this.getWidth() > 0 && this.getHeight() > 0) {
            Point point;
            Point point2 = point;
            SubsamplingScaleImageView subsamplingScaleImageView5 = this;
            n4 = subsamplingScaleImageView5.maxTileWidth;
            point = new Point(n4, subsamplingScaleImageView5.maxTileHeight);
            this.initialiseBaseLayer(point2);
        }
        SubsamplingScaleImageView subsamplingScaleImageView6 = this;
        subsamplingScaleImageView6.invalidate();
        subsamplingScaleImageView6.requestLayout();
        subsamplingScaleImageView6.resetAllScale(n2, n3);
    }

    private void resetAllScale(int n2, int n3) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        float f2 = (float)subsamplingScaleImageView.getWidth() / (float)n2;
        this.setMinScale(f2);
        float f3 = f2 + 4.0f;
        this.setMaxScale(f3);
        subsamplingScaleImageView.setDoubleTapZoomScale(f3 * 0.9f);
        if (n2 <= subsamplingScaleImageView.getWidth() && n3 <= n2) {
            SubsamplingScaleImageView subsamplingScaleImageView2 = this;
            float f4 = n3;
            subsamplingScaleImageView2.setDoubleTapZoomScale((float)subsamplingScaleImageView2.getHeight() / f4);
            subsamplingScaleImageView2.setMaxScale((float)subsamplingScaleImageView2.getHeight() / f4 / 0.7f);
        }
    }

    private synchronized void onTileLoaded() {
        Object object;
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        subsamplingScaleImageView.debug("onTileLoaded", new Object[0]);
        subsamplingScaleImageView.checkReady();
        subsamplingScaleImageView.checkImageLoaded();
        if (subsamplingScaleImageView.isBaseLayerReady() && (object = this.bitmap) != null) {
            if (!this.bitmapIsCached) {
                object.recycle();
            }
            this.bitmap = null;
            object = this.onImageEventListener;
            if (object != null && this.bitmapIsCached) {
                object.onPreviewReleased();
            }
            SubsamplingScaleImageView subsamplingScaleImageView2 = this;
            subsamplingScaleImageView2.bitmapIsPreview = false;
            subsamplingScaleImageView2.bitmapIsCached = false;
        }
        this.invalidate();
    }

    private synchronized void onPreviewLoaded(Bitmap bitmap) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        subsamplingScaleImageView.debug("onPreviewLoaded", new Object[0]);
        if (subsamplingScaleImageView.bitmap == null && !this.imageLoadedSent) {
            Rect rect = this.pRegion;
            if (rect != null) {
                Rect rect2 = rect;
                int n2 = rect2.left;
                int n3 = rect2.top;
                int n4 = rect2.width();
                int n5 = n2;
                n2 = this.pRegion.height();
                this.bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)n5, (int)n3, (int)n4, (int)n2);
            } else {
                this.bitmap = bitmap;
            }
            this.bitmapIsPreview = true;
            if (this.checkReady()) {
                SubsamplingScaleImageView subsamplingScaleImageView2 = this;
                subsamplingScaleImageView2.invalidate();
                subsamplingScaleImageView2.requestLayout();
            }
            return;
        }
        bitmap.recycle();
    }

    private synchronized void onImageLoaded(Bitmap bitmap, int n2, boolean bl) {
        Object object;
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        subsamplingScaleImageView.debug("onImageLoaded", new Object[0]);
        int n3 = subsamplingScaleImageView.sWidth;
        if (n3 > 0 && this.sHeight > 0 && (n3 != bitmap.getWidth() || this.sHeight != bitmap.getHeight())) {
            this.reset(false);
        }
        if ((object = this.bitmap) != null && !this.bitmapIsCached) {
            object.recycle();
        }
        if (this.bitmap != null && this.bitmapIsCached && (object = this.onImageEventListener) != null) {
            object.onPreviewReleased();
        }
        this.bitmapIsPreview = false;
        this.bitmapIsCached = bl;
        this.bitmap = bitmap;
        this.sWidth = bitmap.getWidth();
        this.sHeight = bitmap.getHeight();
        this.sOrientation = n2;
        boolean bl2 = this.checkImageLoaded();
        if (this.checkReady() || bl2) {
            SubsamplingScaleImageView subsamplingScaleImageView2 = this;
            subsamplingScaleImageView2.invalidate();
            subsamplingScaleImageView2.requestLayout();
            int n4 = subsamplingScaleImageView2.sWidth;
            subsamplingScaleImageView2.resetAllScale(n4, subsamplingScaleImageView2.sHeight);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @AnyThread
    private int getExifOrientation(Context context, String string2) {
        int n2;
        int n3 = 0;
        if (string2.startsWith("content")) {
            Throwable throwable2222222;
            block14: {
                int n4;
                block16: {
                    block15: {
                        Context context2 = context;
                        context = null;
                        String[] stringArray = new String[1];
                        {
                            Context context3;
                            catch (Throwable throwable2222222) {
                                break block14;
                            }
                            catch (Exception exception) {}
                            {
                                context3 = context;
                                Log.w((String)TAG, (String)"Could not get orientation of image from media store");
                            }
                            if (context3 != null) {
                                context.close();
                            }
                            n4 = n3;
                            return n4;
                        }
                        String[] stringArray2 = stringArray;
                        {
                            stringArray[0] = "orientation";
                            context = context2.getContentResolver().query(Uri.parse((String)string2), stringArray2, null, null, null);
                        }
                        {
                            if (context == null || !context.moveToFirst()) break block15;
                            n4 = context.getInt(0);
                            if (VALID_ORIENTATIONS.contains(n4) && n4 != -1) break block16;
                            Log.w((String)TAG, (String)("Unsupported orientation: " + n4));
                        }
                    }
                    n4 = n3;
                }
                if (context == null) return n4;
                context.close();
                return n4;
            }
            if (context == null) throw throwable2222222;
            context.close();
            throw throwable2222222;
        }
        if (!string2.startsWith("file:///")) return n3;
        if (string2.startsWith("file:///android_asset/")) return n3;
        try {
            n2 = new ExifInterface(string2.substring(7)).getAttributeInt("Orientation", 1);
            if (n2 == 1) return 0;
            if (n2 == 0) return 0;
            if (n2 == 6) {
                return 90;
            }
            if (n2 == 3) {
                return 180;
            }
            if (n2 == 8) {
                return 270;
            }
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"Could not get EXIF orientation of image");
            return n3;
        }
        {
            Log.w((String)TAG, (String)("Unsupported EXIF orientation: " + n2));
        }
        return n3;
    }

    private void execute(AsyncTask<Void, Void, ?> asyncTask) {
        asyncTask.executeOnExecutor(this.executor, (Object[])new Void[0]);
    }

    private void restoreState(ImageViewState imageViewState) {
        if (imageViewState != null && VALID_ORIENTATIONS.contains(imageViewState.getOrientation())) {
            this.sPendingCenter = imageViewState.getCenter();
            this.invalidate();
        }
    }

    @NonNull
    private Point getMaxBitmapDimensions(Canvas canvas) {
        return new Point(Math.min(canvas.getMaximumBitmapWidth(), this.maxTileWidth), Math.min(canvas.getMaximumBitmapHeight(), this.maxTileHeight));
    }

    private int sWidth() {
        int n2 = this.getRequiredRotation();
        if (n2 != 90 && n2 != 270) {
            return this.sWidth;
        }
        return this.sHeight;
    }

    private int sHeight() {
        int n2 = this.getRequiredRotation();
        if (n2 != 90 && n2 != 270) {
            return this.sHeight;
        }
        return this.sWidth;
    }

    @AnyThread
    private void fileSRect(Rect rect, Rect rect2) {
        if (this.getRequiredRotation() == 0) {
            rect2.set(rect);
        } else if (this.getRequiredRotation() == 90) {
            int n2 = rect.top;
            int n3 = this.sHeight;
            int n4 = n2;
            Rect rect3 = rect;
            n2 = n3 - rect.right;
            int n5 = rect3.bottom;
            rect2.set(n4, n2, n5, n3 -= rect3.left);
        } else if (this.getRequiredRotation() == 180) {
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            int n6 = subsamplingScaleImageView.sWidth;
            int n7 = n6 - rect.right;
            int n8 = subsamplingScaleImageView.sHeight;
            int n9 = n7;
            int n10 = n6;
            n6 = n8 - rect.bottom;
            int n11 = n10 - rect.left;
            n7 = n8 - rect.top;
            rect2.set(n9, n6, n11, n7);
        } else {
            int n12 = this.sWidth;
            int n13 = n12;
            Rect rect4 = rect;
            int n14 = rect4.left;
            int n15 = n12 - rect4.top;
            int n16 = rect.right;
            rect2.set(n13 -= rect.bottom, n14, n15, n16);
        }
    }

    @AnyThread
    private int getRequiredRotation() {
        int n2 = this.orientation;
        if (n2 == -1) {
            return this.sOrientation;
        }
        return n2;
    }

    private float distance(float f2, float f3, float f4, float f5) {
        float f6;
        float f7 = f2 - f3;
        float f8 = f6 = f4 - f5;
        return (float)Math.sqrt(f7 * f7 + f8 * f8);
    }

    private float viewToSourceX(float f2) {
        PointF pointF = this.vTranslate;
        if (pointF == null) {
            return Float.NaN;
        }
        return (f2 - pointF.x) / this.scale;
    }

    private float viewToSourceY(float f2) {
        PointF pointF = this.vTranslate;
        if (pointF == null) {
            return Float.NaN;
        }
        return (f2 - pointF.y) / this.scale;
    }

    private float sourceToViewX(float f2) {
        PointF pointF = this.vTranslate;
        if (pointF == null) {
            return Float.NaN;
        }
        return f2 * this.scale + pointF.x;
    }

    private float sourceToViewY(float f2) {
        PointF pointF = this.vTranslate;
        if (pointF == null) {
            return Float.NaN;
        }
        return f2 * this.scale + pointF.y;
    }

    private void sourceToViewRect(@NonNull Rect rect, @NonNull Rect rect2) {
        int n2 = (int)this.sourceToViewX(rect.left);
        int n3 = (int)this.sourceToViewY(rect.top);
        int n4 = (int)this.sourceToViewX(rect.right);
        int n5 = (int)this.sourceToViewY(rect.bottom);
        rect2.set(n2, n3, n4, n5);
    }

    @NonNull
    private PointF vTranslateForSCenter(float f2, float f3, float f4) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        int n2 = subsamplingScaleImageView.getPaddingLeft() + (this.getWidth() - this.getPaddingRight() - this.getPaddingLeft()) / 2;
        int n3 = subsamplingScaleImageView.getPaddingTop() + (this.getHeight() - this.getPaddingBottom() - this.getPaddingTop()) / 2;
        if (subsamplingScaleImageView.satTemp == null) {
            PointF pointF;
            ScaleAndTranslate scaleAndTranslate;
            ScaleAndTranslate scaleAndTranslate2 = scaleAndTranslate;
            PointF pointF2 = pointF;
            pointF = new PointF(0.0f, 0.0f);
            scaleAndTranslate = new ScaleAndTranslate(0.0f, pointF2);
            this.satTemp = scaleAndTranslate2;
        }
        SubsamplingScaleImageView subsamplingScaleImageView2 = this;
        ScaleAndTranslate.access$4702(subsamplingScaleImageView2.satTemp, f4);
        subsamplingScaleImageView2.satTemp.vTranslate.set((float)n2 - f2 * f4, (float)n3 - f3 * f4);
        subsamplingScaleImageView2.fitToBounds(true, subsamplingScaleImageView2.satTemp);
        return subsamplingScaleImageView2.satTemp.vTranslate;
    }

    @NonNull
    private PointF limitedSCenter(float f2, float f3, float f4, @NonNull PointF pointF) {
        PointF pointF2 = pointF;
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        PointF pointF3 = subsamplingScaleImageView.vTranslateForSCenter(f2, f3, f4);
        int n2 = this.getPaddingTop() + (this.getHeight() - this.getPaddingBottom() - this.getPaddingTop()) / 2;
        pointF2.set(((float)(subsamplingScaleImageView.getPaddingLeft() + (this.getWidth() - this.getPaddingRight() - this.getPaddingLeft()) / 2) - pointF3.x) / f4, ((float)n2 - pointF3.y) / f4);
        return pointF2;
    }

    private float minScale() {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        int n2 = subsamplingScaleImageView.getPaddingBottom() + this.getPaddingTop();
        int n3 = subsamplingScaleImageView.getPaddingLeft() + this.getPaddingRight();
        int n4 = subsamplingScaleImageView.minimumScaleType;
        if (n4 != 2 && n4 != 4) {
            if (n4 == 3) {
                float f2;
                float f3 = this.minScale;
                if (f2 > 0.0f) {
                    return f3;
                }
            }
            return Math.min((float)(this.getWidth() - n3) / (float)this.sWidth(), (float)(this.getHeight() - n2) / (float)this.sHeight());
        }
        return Math.max((float)(this.getWidth() - n3) / (float)this.sWidth(), (float)(this.getHeight() - n2) / (float)this.sHeight());
    }

    private float limitedScale(float f2) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        float f3 = Math.max(subsamplingScaleImageView.minScale(), f2);
        return Math.min(subsamplingScaleImageView.maxScale, f3);
    }

    private float ease(int n2, long l2, float f2, float f3, long l3) {
        if (n2 != 1) {
            if (n2 == 2) {
                return this.easeInOutQuad(l2, f2, f3, l3);
            }
            throw new IllegalStateException("Unexpected easing type: " + n2);
        }
        return this.easeOutQuad(l2, f2, f3, l3);
    }

    private float easeOutQuad(long l2, float f2, float f3, long l3) {
        float f4 = (float)l2 / (float)l3;
        return -f3 * f4 * (f4 - 2.0f) + f2;
    }

    private float easeInOutQuad(long l2, float f2, float f3, long l3) {
        float f4;
        float f5 = (float)l2 / ((float)l3 / 2.0f);
        if (f4 < 1.0f) {
            return f3 / 2.0f * f5 * f5 + f2;
        }
        float f6 = f5 -= 1.0f;
        return -f3 / 2.0f * (f6 * (f6 - 2.0f) - 1.0f) + f2;
    }

    @AnyThread
    private void debug(String string2, Object ... objectArray) {
        if (this.debug) {
            Log.d((String)TAG, (String)StringUtil.format(string2, objectArray));
        }
    }

    private int px(int n2) {
        return (int)(this.density * (float)n2);
    }

    private void sendStateChanged(float f2, PointF pointF, int n2) {
        float f3;
        OnStateChangedListener onStateChangedListener = this.onStateChangedListener;
        if (onStateChangedListener != null && (f3 = this.scale) != f2) {
            onStateChangedListener.onScaleChanged(f3, n2);
        }
        if (this.onStateChangedListener != null && !this.vTranslate.equals((Object)pointF)) {
            this.onStateChangedListener.onCenterChanged(this.getCenter(), n2);
        }
    }

    static /* synthetic */ int access$102(SubsamplingScaleImageView subsamplingScaleImageView, int n2) {
        subsamplingScaleImageView.maxTouchCount = n2;
        return n2;
    }

    static /* synthetic */ PointF access$1702(SubsamplingScaleImageView subsamplingScaleImageView, PointF pointF) {
        subsamplingScaleImageView.vCenterStart = pointF;
        return pointF;
    }

    static /* synthetic */ PointF access$1802(SubsamplingScaleImageView subsamplingScaleImageView, PointF pointF) {
        subsamplingScaleImageView.vTranslateStart = pointF;
        return pointF;
    }

    static /* synthetic */ float access$1902(SubsamplingScaleImageView subsamplingScaleImageView, float f2) {
        subsamplingScaleImageView.scaleStart = f2;
        return f2;
    }

    static /* synthetic */ boolean access$2002(SubsamplingScaleImageView subsamplingScaleImageView, boolean bl) {
        subsamplingScaleImageView.isQuickScaling = bl;
        return bl;
    }

    static /* synthetic */ boolean access$902(SubsamplingScaleImageView subsamplingScaleImageView, boolean bl) {
        subsamplingScaleImageView.isZooming = bl;
        return bl;
    }

    static /* synthetic */ float access$2102(SubsamplingScaleImageView subsamplingScaleImageView, float f2) {
        subsamplingScaleImageView.quickScaleLastDistance = f2;
        return f2;
    }

    static /* synthetic */ PointF access$2202(SubsamplingScaleImageView subsamplingScaleImageView, PointF pointF) {
        subsamplingScaleImageView.quickScaleSCenter = pointF;
        return pointF;
    }

    static /* synthetic */ PointF access$2302(SubsamplingScaleImageView subsamplingScaleImageView, PointF pointF) {
        subsamplingScaleImageView.quickScaleVStart = pointF;
        return pointF;
    }

    static /* synthetic */ PointF access$2402(SubsamplingScaleImageView subsamplingScaleImageView, PointF pointF) {
        subsamplingScaleImageView.quickScaleVLastPoint = pointF;
        return pointF;
    }

    static /* synthetic */ boolean access$2502(SubsamplingScaleImageView subsamplingScaleImageView, boolean bl) {
        subsamplingScaleImageView.quickScaleMoved = bl;
        return bl;
    }

    static /* synthetic */ ReadWriteLock access$5700(SubsamplingScaleImageView subsamplingScaleImageView) {
        return subsamplingScaleImageView.decoderLock;
    }

    static /* synthetic */ void access$5800(SubsamplingScaleImageView subsamplingScaleImageView, Rect rect, Rect rect2) {
        subsamplingScaleImageView.fileSRect(rect, rect2);
    }

    static /* synthetic */ Anim access$6402(SubsamplingScaleImageView subsamplingScaleImageView, Anim anim2) {
        subsamplingScaleImageView.anim = anim2;
        return anim2;
    }

    public final void setOrientation(int n2) {
        if (VALID_ORIENTATIONS.contains(n2)) {
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            subsamplingScaleImageView.orientation = n2;
            subsamplingScaleImageView.reset(false);
            subsamplingScaleImageView.invalidate();
            subsamplingScaleImageView.requestLayout();
            return;
        }
        throw new IllegalArgumentException("Invalid orientation: " + n2);
    }

    public final void setImage(@NonNull ImageSource object) {
        PointF pointF;
        ImageViewState imageViewState;
        ImageSource imageSource = object;
        object = imageViewState;
        PointF pointF2 = pointF;
        pointF = new PointF((float)this.getWidth() / 2.0f, 0.0f);
        imageViewState = new ImageViewState(0.0f, pointF2, 0);
        this.setImage(imageSource, null, (ImageViewState)object);
    }

    public final void setImage(@NonNull ImageSource imageSource, ImageViewState imageViewState) {
        this.setImage(imageSource, null, imageViewState);
    }

    public final void setImage(@NonNull ImageSource imageSource, ImageSource imageSource2) {
        this.setImage(imageSource, imageSource2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setImage(@NonNull ImageSource object, ImageSource object2, ImageViewState object3) {
        Uri uri;
        if (object == null) throw new NullPointerException("imageSource must not be null");
        subsamplingScaleImageView2.reset(true);
        if (object3 != null) {
            subsamplingScaleImageView2.restoreState((ImageViewState)object3);
        }
        if (object2 != null) {
            if (((ImageSource)object).getBitmap() != null) throw new IllegalArgumentException("Preview image cannot be used when a bitmap is provided for the main image");
            if (((ImageSource)object).getSWidth() <= 0 || ((ImageSource)object).getSHeight() <= 0) throw new IllegalArgumentException("Preview image cannot be used unless dimensions are provided for the main image");
            subsamplingScaleImageView2.sWidth = ((ImageSource)object).getSWidth();
            subsamplingScaleImageView2.sHeight = ((ImageSource)object).getSHeight();
            subsamplingScaleImageView2.pRegion = ((ImageSource)object2).getSRegion();
            if (((ImageSource)object2).getBitmap() != null) {
                subsamplingScaleImageView2.bitmapIsCached = ((ImageSource)object2).isCached();
                subsamplingScaleImageView2.onPreviewLoaded(((ImageSource)object2).getBitmap());
            } else {
                BitmapLoadTask bitmapLoadTask;
                object3 = ((ImageSource)object2).getUri();
                if (object3 == null && ((ImageSource)object2).getResource() != null) {
                    object3 = Uri.parse((String)("android.resource://" + subsamplingScaleImageView2.getContext().getPackageName() + "/" + ((ImageSource)object2).getResource()));
                }
                object2 = bitmapLoadTask;
                SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView2;
                uri = subsamplingScaleImageView.getContext();
                DecoderFactory<? extends ImageDecoder> decoderFactory = subsamplingScaleImageView.bitmapDecoderFactory;
                bitmapLoadTask = new BitmapLoadTask(subsamplingScaleImageView2, (Context)uri, decoderFactory, (Uri)object3, true);
                subsamplingScaleImageView2.execute((AsyncTask<Void, Void, ?>)object2);
            }
        }
        if (((ImageSource)object).getBitmap() != null && ((ImageSource)object).getSRegion() != null) {
            Object object4 = object;
            int n2 = ((ImageSource)object4).getSRegion().top;
            int n3 = ((ImageSource)object4).getSRegion().width();
            int n4 = ((ImageSource)object4).getSRegion().height();
            subsamplingScaleImageView2.onImageLoaded(Bitmap.createBitmap((Bitmap)((ImageSource)object).getBitmap(), (int)((ImageSource)object).getSRegion().left, (int)n2, (int)n3, (int)n4), 0, false);
            return;
        } else if (((ImageSource)object).getBitmap() != null) {
            SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView2;
            Object object5 = object;
            SubsamplingScaleImageView subsamplingScaleImageView2 = ((ImageSource)object5).getBitmap();
            boolean bl = ((ImageSource)object5).isCached();
            subsamplingScaleImageView.onImageLoaded((Bitmap)subsamplingScaleImageView2, 0, bl);
            return;
        } else {
            subsamplingScaleImageView2.sRegion = ((ImageSource)object).getSRegion();
            subsamplingScaleImageView2.uri = ((ImageSource)object).getUri();
            if (subsamplingScaleImageView2.uri == null && ((ImageSource)object).getResource() != null) {
                subsamplingScaleImageView2.uri = Uri.parse((String)("android.resource://" + subsamplingScaleImageView2.getContext().getPackageName() + "/" + ((ImageSource)object).getResource()));
            }
            if (!((ImageSource)object).getTile() && subsamplingScaleImageView2.sRegion == null) {
                BitmapLoadTask bitmapLoadTask;
                object = bitmapLoadTask;
                SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView2;
                object2 = subsamplingScaleImageView.getContext();
                object3 = subsamplingScaleImageView.bitmapDecoderFactory;
                uri = subsamplingScaleImageView.uri;
                bitmapLoadTask = new BitmapLoadTask(subsamplingScaleImageView2, (Context)object2, (DecoderFactory<? extends ImageDecoder>)object3, uri, false);
                subsamplingScaleImageView2.execute((AsyncTask<Void, Void, ?>)object);
                return;
            } else {
                TilesInitTask tilesInitTask;
                object = tilesInitTask;
                SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView2;
                object2 = subsamplingScaleImageView.getContext();
                object3 = subsamplingScaleImageView.regionDecoderFactory;
                uri = subsamplingScaleImageView.uri;
                tilesInitTask = new TilesInitTask(subsamplingScaleImageView2, (Context)object2, (DecoderFactory<? extends ImageRegionDecoder>)object3, uri);
                subsamplingScaleImageView2.execute((AsyncTask<Void, Void, ?>)object);
            }
        }
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n4;
        objectArray2[1] = n5;
        objectArray2[2] = n2;
        objectArray[3] = n3;
        subsamplingScaleImageView.debug("onSizeChanged %dx%d -> %dx%d", objectArray2);
        PointF pointF = subsamplingScaleImageView.getCenter();
        if (subsamplingScaleImageView.readySent && pointF != null) {
            this.anim = null;
            this.pendingScale = Float.valueOf(this.scale);
            this.sPendingCenter = pointF;
        }
    }

    protected void onMeasure(int n2, int n3) {
        int n4 = View.MeasureSpec.getMode((int)n2);
        int n5 = n3;
        int n6 = n2;
        n2 = View.MeasureSpec.getMode((int)n3);
        n3 = View.MeasureSpec.getSize((int)n6);
        int n7 = View.MeasureSpec.getSize((int)n5);
        boolean bl = n4 != 0x40000000;
        n2 = n2 != 0x40000000 ? 1 : 0;
        if (this.sWidth > 0 && this.sHeight > 0) {
            if (bl && n2 != 0) {
                SubsamplingScaleImageView subsamplingScaleImageView = this;
                n3 = subsamplingScaleImageView.sWidth();
                n7 = subsamplingScaleImageView.sHeight();
            } else if (n2 != 0) {
                n7 = (int)((double)this.sHeight() / (double)this.sWidth() * (double)n3);
            } else if (bl) {
                n3 = (int)((double)this.sWidth() / (double)this.sHeight() * (double)n7);
            }
        }
        int n8 = Math.max(n3, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(n8, Math.max(n7, this.getSuggestedMinimumHeight()));
    }

    public boolean onTouchEvent(@NonNull MotionEvent motionEvent) {
        Anim anim2 = subsamplingScaleImageView.anim;
        if (anim2 != null && !anim2.interruptible) {
            subsamplingScaleImageView.requestDisallowInterceptTouchEvent(true);
            return true;
        }
        anim2 = subsamplingScaleImageView.anim;
        if (anim2 != null && anim2.listener != null) {
            try {
                subsamplingScaleImageView.anim.listener.onInterruptedByUser();
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)"Error thrown by animation listener", (Throwable)exception);
            }
        }
        subsamplingScaleImageView.anim = null;
        if (subsamplingScaleImageView.vTranslate == null) {
            SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView.singleDetector;
            if (subsamplingScaleImageView != null) {
                subsamplingScaleImageView.onTouchEvent(motionEvent);
            }
            return true;
        }
        if (!subsamplingScaleImageView.isQuickScaling && ((anim2 = subsamplingScaleImageView.detector) == null || anim2.onTouchEvent(motionEvent))) {
            SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView;
            subsamplingScaleImageView.isZooming = false;
            subsamplingScaleImageView.isPanning = false;
            subsamplingScaleImageView.maxTouchCount = 0;
            return true;
        }
        if (subsamplingScaleImageView.vTranslateStart == null) {
            PointF pointF;
            anim2 = pointF;
            pointF = new PointF(0.0f, 0.0f);
            subsamplingScaleImageView.vTranslateStart = anim2;
        }
        if (subsamplingScaleImageView.vTranslateBefore == null) {
            PointF pointF;
            anim2 = pointF;
            pointF = new PointF(0.0f, 0.0f);
            subsamplingScaleImageView.vTranslateBefore = anim2;
        }
        if (subsamplingScaleImageView.vCenterStart == null) {
            PointF pointF;
            anim2 = pointF;
            pointF = new PointF(0.0f, 0.0f);
            subsamplingScaleImageView.vCenterStart = anim2;
        }
        SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView;
        float f2 = subsamplingScaleImageView.scale;
        subsamplingScaleImageView.vTranslateBefore.set(subsamplingScaleImageView.vTranslate);
        boolean bl = subsamplingScaleImageView.onTouchEventInternal(motionEvent);
        subsamplingScaleImageView.sendStateChanged(f2, subsamplingScaleImageView.vTranslateBefore, 2);
        return bl || super.onTouchEvent(motionEvent);
    }

    protected void onDraw(Canvas canvas) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        super.onDraw(canvas);
        subsamplingScaleImageView.createPaints();
        if (subsamplingScaleImageView.sWidth != 0 && this.sHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
            boolean bl;
            float f2;
            float f3;
            if (this.tileMap == null && this.decoder != null) {
                SubsamplingScaleImageView subsamplingScaleImageView2 = this;
                subsamplingScaleImageView2.initialiseBaseLayer(subsamplingScaleImageView2.getMaxBitmapDimensions(canvas));
            }
            if (!this.checkReady()) {
                return;
            }
            SubsamplingScaleImageView subsamplingScaleImageView3 = this;
            subsamplingScaleImageView3.preDraw();
            Anim anim2 = subsamplingScaleImageView3.anim;
            if (anim2 != null && anim2.vFocusStart != null) {
                SubsamplingScaleImageView subsamplingScaleImageView4 = this;
                float f4 = subsamplingScaleImageView4.scale;
                if (subsamplingScaleImageView4.vTranslateBefore == null) {
                    PointF pointF;
                    PointF pointF2 = pointF;
                    pointF = new PointF(0.0f, 0.0f);
                    this.vTranslateBefore = pointF2;
                }
                this.vTranslateBefore.set(this.vTranslate);
                long l2 = System.currentTimeMillis() - this.anim.time;
                boolean bl2 = l2 > this.anim.duration;
                SubsamplingScaleImageView subsamplingScaleImageView5 = this;
                l2 = Math.min(l2, this.anim.duration);
                SubsamplingScaleImageView subsamplingScaleImageView6 = this;
                f3 = subsamplingScaleImageView6.anim.scaleStart;
                float f5 = subsamplingScaleImageView6.anim.scaleEnd - this.anim.scaleStart;
                long l3 = subsamplingScaleImageView6.anim.duration;
                subsamplingScaleImageView5.scale = subsamplingScaleImageView5.ease(subsamplingScaleImageView5.anim.easing, l2, f3, f5, l3);
                SubsamplingScaleImageView subsamplingScaleImageView7 = this;
                f3 = ((Anim)subsamplingScaleImageView7.anim).vFocusStart.x;
                f5 = ((Anim)subsamplingScaleImageView7.anim).vFocusEnd.x - ((Anim)this.anim).vFocusStart.x;
                l3 = subsamplingScaleImageView7.anim.duration;
                f3 = subsamplingScaleImageView5.ease(subsamplingScaleImageView5.anim.easing, l2, f3, f5, l3);
                SubsamplingScaleImageView subsamplingScaleImageView8 = this;
                float f6 = ((Anim)subsamplingScaleImageView8.anim).vFocusStart.y;
                f2 = ((Anim)subsamplingScaleImageView8.anim).vFocusEnd.y - ((Anim)this.anim).vFocusStart.y;
                long l4 = subsamplingScaleImageView8.anim.duration;
                f6 = subsamplingScaleImageView5.ease(subsamplingScaleImageView5.anim.easing, l2, f6, f2, l4);
                SubsamplingScaleImageView subsamplingScaleImageView9 = this;
                subsamplingScaleImageView5.vTranslate.x -= subsamplingScaleImageView9.sourceToViewX(((Anim)subsamplingScaleImageView9.anim).sCenterEnd.x) - f3;
                SubsamplingScaleImageView subsamplingScaleImageView10 = this;
                subsamplingScaleImageView5.vTranslate.y -= subsamplingScaleImageView10.sourceToViewY(((Anim)subsamplingScaleImageView10.anim).sCenterEnd.y) - f6;
                bl = bl2 || this.anim.scaleStart == this.anim.scaleEnd;
                SubsamplingScaleImageView subsamplingScaleImageView11 = this;
                subsamplingScaleImageView11.fitToBounds(bl);
                anim2 = subsamplingScaleImageView11.vTranslateBefore;
                this.sendStateChanged(f4, (PointF)anim2, subsamplingScaleImageView11.anim.origin);
                this.refreshRequiredTiles(bl2);
                if (bl2) {
                    if (this.anim.listener != null) {
                        try {
                            this.anim.listener.onComplete();
                        }
                        catch (Exception exception) {
                            Log.w((String)TAG, (String)"Error thrown by animation listener", (Throwable)exception);
                        }
                    }
                    this.anim = null;
                }
                this.invalidate();
            }
            if (this.tileMap != null && this.isBaseLayerReady()) {
                SubsamplingScaleImageView subsamplingScaleImageView12 = this;
                SubsamplingScaleImageView subsamplingScaleImageView13 = this;
                int n2 = Math.min(subsamplingScaleImageView12.fullImageSampleSize, subsamplingScaleImageView13.calculateInSampleSize(subsamplingScaleImageView13.scale));
                bl = false;
                for (Map.Entry<Integer, List<Tile>> entry : subsamplingScaleImageView12.tileMap.entrySet()) {
                    if (entry.getKey() != n2) continue;
                    entry = entry.getValue().iterator();
                    while (entry.hasNext()) {
                        Tile tile = (Tile)entry.next();
                        if (!tile.visible || !tile.loading && tile.bitmap != null) continue;
                        bl = true;
                    }
                }
                for (Map.Entry<Integer, List<Tile>> entry : this.tileMap.entrySet()) {
                    if (entry.getKey() != n2 && !bl) continue;
                    entry = entry.getValue().iterator();
                    while (entry.hasNext()) {
                        Paint paint;
                        Object object = (Tile)entry.next();
                        Rect rect = ((Tile)object).sRect;
                        this.sourceToViewRect(rect, ((Tile)object).vRect);
                        if (!((Tile)object).loading && ((Tile)object).bitmap != null) {
                            float f7;
                            float f8;
                            float f9;
                            float f10;
                            if (this.tileBgPaint != null) {
                                rect = ((Tile)object).vRect;
                                canvas.drawRect(rect, this.tileBgPaint);
                            }
                            if (this.matrix == null) {
                                Matrix matrix;
                                rect = matrix;
                                matrix = new Matrix();
                                this.matrix = rect;
                            }
                            SubsamplingScaleImageView subsamplingScaleImageView14 = this;
                            subsamplingScaleImageView14.matrix.reset();
                            Tile tile = object;
                            float f11 = tile.bitmap.getWidth();
                            float f12 = tile.bitmap.getWidth();
                            float f13 = tile.bitmap.getHeight();
                            float f14 = tile.bitmap.getHeight();
                            subsamplingScaleImageView14.setMatrixArray(subsamplingScaleImageView14.srcArray, 0.0f, 0.0f, f11, 0.0f, f12, f13, 0.0f, f14);
                            if (subsamplingScaleImageView14.getRequiredRotation() == 0) {
                                SubsamplingScaleImageView subsamplingScaleImageView15 = this;
                                Object object2 = object;
                                f11 = ((Tile)object2).vRect.left;
                                f12 = ((Tile)object2).vRect.top;
                                f13 = ((Tile)object2).vRect.right;
                                f14 = ((Tile)object2).vRect.top;
                                f10 = ((Tile)object2).vRect.right;
                                f9 = ((Tile)object2).vRect.bottom;
                                f8 = ((Tile)object2).vRect.left;
                                f7 = ((Tile)object2).vRect.bottom;
                                subsamplingScaleImageView15.setMatrixArray(subsamplingScaleImageView15.dstArray, f11, f12, f13, f14, f10, f9, f8, f7);
                            } else if (this.getRequiredRotation() == 90) {
                                SubsamplingScaleImageView subsamplingScaleImageView16 = this;
                                Object object3 = object;
                                f11 = ((Tile)object3).vRect.right;
                                f12 = ((Tile)object3).vRect.top;
                                f13 = ((Tile)object3).vRect.right;
                                f14 = ((Tile)object3).vRect.bottom;
                                f10 = ((Tile)object3).vRect.left;
                                f9 = ((Tile)object3).vRect.bottom;
                                f8 = ((Tile)object3).vRect.left;
                                f7 = ((Tile)object3).vRect.top;
                                subsamplingScaleImageView16.setMatrixArray(subsamplingScaleImageView16.dstArray, f11, f12, f13, f14, f10, f9, f8, f7);
                            } else if (this.getRequiredRotation() == 180) {
                                SubsamplingScaleImageView subsamplingScaleImageView17 = this;
                                Object object4 = object;
                                f11 = ((Tile)object4).vRect.right;
                                f12 = ((Tile)object4).vRect.bottom;
                                f13 = ((Tile)object4).vRect.left;
                                f14 = ((Tile)object4).vRect.bottom;
                                f10 = ((Tile)object4).vRect.left;
                                f9 = ((Tile)object4).vRect.top;
                                f8 = ((Tile)object4).vRect.right;
                                f7 = ((Tile)object4).vRect.top;
                                subsamplingScaleImageView17.setMatrixArray(subsamplingScaleImageView17.dstArray, f11, f12, f13, f14, f10, f9, f8, f7);
                            } else if (this.getRequiredRotation() == 270) {
                                SubsamplingScaleImageView subsamplingScaleImageView18 = this;
                                Object object5 = object;
                                f11 = ((Tile)object5).vRect.left;
                                f12 = ((Tile)object5).vRect.bottom;
                                f13 = ((Tile)object5).vRect.left;
                                f14 = ((Tile)object5).vRect.top;
                                f10 = ((Tile)object5).vRect.right;
                                f9 = ((Tile)object5).vRect.top;
                                f8 = ((Tile)object5).vRect.right;
                                f7 = ((Tile)object5).vRect.bottom;
                                subsamplingScaleImageView18.setMatrixArray(subsamplingScaleImageView18.dstArray, f11, f12, f13, f14, f10, f9, f8, f7);
                            }
                            SubsamplingScaleImageView subsamplingScaleImageView19 = this;
                            SubsamplingScaleImageView subsamplingScaleImageView20 = this;
                            Object object6 = subsamplingScaleImageView20.srcArray;
                            Object object7 = subsamplingScaleImageView20.dstArray;
                            this.matrix.setPolyToPoly(object6, 0, object7, 0, 4);
                            object6 = ((Tile)object).bitmap;
                            object7 = subsamplingScaleImageView19.matrix;
                            paint = subsamplingScaleImageView19.bitmapPaint;
                            canvas.drawBitmap((Bitmap)object6, (Matrix)object7, paint);
                            if (this.debug) {
                                object6 = ((Tile)object).vRect;
                                canvas.drawRect((Rect)object6, this.debugLinePaint);
                            }
                        } else if (((Tile)object).loading && this.debug) {
                            Tile tile = object;
                            float f15 = ((Tile)tile).vRect.left + this.px(5);
                            float f16 = ((Tile)tile).vRect.top + this.px(35);
                            paint = this.debugTextPaint;
                            canvas.drawText("LOADING", f15, f16, paint);
                        }
                        if (!((Tile)object).visible || !this.debug) continue;
                        Tile tile = object;
                        object = "ISS " + ((Tile)object).sampleSize + " RECT " + ((Tile)object).sRect.top + "," + ((Tile)object).sRect.left + "," + ((Tile)object).sRect.bottom + "," + ((Tile)object).sRect.right;
                        float f17 = ((Tile)tile).vRect.left + this.px(5);
                        float f18 = ((Tile)tile).vRect.top + this.px(15);
                        paint = this.debugTextPaint;
                        canvas.drawText((String)object, f17, f18, paint);
                    }
                }
            } else {
                anim2 = this.bitmap;
                if (anim2 != null) {
                    float f19;
                    SubsamplingScaleImageView subsamplingScaleImageView21 = this;
                    float f20 = subsamplingScaleImageView21.scale;
                    if (subsamplingScaleImageView21.bitmapIsPreview) {
                        f20 *= (float)this.sWidth / (float)anim2.getWidth();
                        f19 = this.scale * ((float)this.sHeight / (float)this.bitmap.getHeight());
                    } else {
                        f19 = f20;
                    }
                    if (this.matrix == null) {
                        Matrix matrix;
                        Matrix matrix2 = matrix;
                        matrix = new Matrix();
                        this.matrix = matrix2;
                    }
                    SubsamplingScaleImageView subsamplingScaleImageView22 = this;
                    subsamplingScaleImageView22.matrix.reset();
                    subsamplingScaleImageView22.matrix.postScale(f20, f19);
                    subsamplingScaleImageView22.matrix.postRotate((float)this.getRequiredRotation());
                    PointF pointF = this.vTranslate;
                    f19 = pointF.x;
                    subsamplingScaleImageView22.matrix.postTranslate(f19, pointF.y);
                    if (subsamplingScaleImageView22.getRequiredRotation() == 180) {
                        float f21 = this.scale;
                        f19 = f21 * (float)this.sWidth;
                        this.matrix.postTranslate(f19, f21 * (float)this.sHeight);
                    } else if (this.getRequiredRotation() == 90) {
                        this.matrix.postTranslate(this.scale * (float)this.sHeight, 0.0f);
                    } else if (this.getRequiredRotation() == 270) {
                        this.matrix.postTranslate(0.0f, this.scale * (float)this.sWidth);
                    }
                    if (this.tileBgPaint != null) {
                        if (this.sRect == null) {
                            RectF rectF;
                            RectF rectF2 = rectF;
                            rectF = new RectF();
                            this.sRect = rectF2;
                        }
                        SubsamplingScaleImageView subsamplingScaleImageView23 = this;
                        RectF rectF = subsamplingScaleImageView23.sRect;
                        f20 = 0.0f;
                        f2 = 0.0f;
                        float f22 = subsamplingScaleImageView23.bitmapIsPreview ? (float)this.bitmap.getWidth() : (float)this.sWidth;
                        f3 = this.bitmapIsPreview ? (float)this.bitmap.getHeight() : (float)this.sHeight;
                        SubsamplingScaleImageView subsamplingScaleImageView24 = this;
                        rectF.set(f20, f2, f22, f3);
                        subsamplingScaleImageView24.matrix.mapRect(this.sRect);
                        rectF = subsamplingScaleImageView24.sRect;
                        canvas.drawRect(rectF, subsamplingScaleImageView24.tileBgPaint);
                    }
                    SubsamplingScaleImageView subsamplingScaleImageView25 = this;
                    Bitmap bitmap = subsamplingScaleImageView25.bitmap;
                    Matrix matrix = subsamplingScaleImageView25.matrix;
                    Paint paint = subsamplingScaleImageView25.bitmapPaint;
                    canvas.drawBitmap(bitmap, matrix, paint);
                }
            }
            if (this.debug) {
                SubsamplingScaleImageView subsamplingScaleImageView26 = this;
                SubsamplingScaleImageView subsamplingScaleImageView27 = this;
                SubsamplingScaleImageView subsamplingScaleImageView28 = this;
                PointF pointF = Locale.ENGLISH;
                Object[] objectArray = new Object[1];
                PointF pointF3 = objectArray;
                objectArray[0] = Float.valueOf(this.scale);
                StringBuilder stringBuilder = new StringBuilder().append("Scale: ").append(String.format((Locale)Locale.ENGLISH, "%.2f", (Object[])pointF3)).append(" (");
                Object[] objectArray2 = new Object[1];
                pointF3 = objectArray2;
                objectArray2[0] = Float.valueOf(this.minScale());
                StringBuilder stringBuilder2 = stringBuilder.append(String.format((Locale)pointF, "%.2f", (Object[])pointF3)).append(" - ");
                Object[] objectArray3 = new Object[1];
                pointF3 = objectArray3;
                objectArray3[0] = Float.valueOf(this.maxScale);
                pointF3 = stringBuilder2.append(String.format((Locale)pointF, "%.2f", (Object[])pointF3)).append(")").toString();
                float f23 = subsamplingScaleImageView28.px(5);
                float f24 = subsamplingScaleImageView28.px(15);
                Paint paint = subsamplingScaleImageView28.debugTextPaint;
                canvas.drawText((String)pointF3, f23, f24, paint);
                Object[] objectArray4 = new Object[1];
                pointF3 = objectArray4;
                objectArray4[0] = Float.valueOf(this.vTranslate.x);
                StringBuilder stringBuilder3 = new StringBuilder().append("Translate: ").append(String.format((Locale)pointF, "%.2f", (Object[])pointF3)).append(":");
                Object[] objectArray5 = new Object[1];
                pointF3 = objectArray5;
                objectArray5[0] = Float.valueOf(this.vTranslate.y);
                pointF3 = stringBuilder3.append(String.format((Locale)pointF, "%.2f", (Object[])pointF3)).toString();
                f23 = subsamplingScaleImageView27.px(5);
                f24 = subsamplingScaleImageView27.px(30);
                paint = subsamplingScaleImageView27.debugTextPaint;
                canvas.drawText((String)pointF3, f23, f24, paint);
                pointF3 = subsamplingScaleImageView26.getCenter();
                Object[] objectArray6 = new Object[1];
                Object[] objectArray7 = objectArray6;
                objectArray6[0] = Float.valueOf(pointF3.x);
                StringBuilder stringBuilder4 = new StringBuilder().append("Source center: ").append(String.format((Locale)pointF, "%.2f", objectArray7)).append(":");
                Object[] objectArray8 = pointF;
                Object[] objectArray9 = new Object[1];
                pointF = objectArray9;
                objectArray9[0] = Float.valueOf(pointF3.y);
                pointF = stringBuilder4.append(String.format((Locale)objectArray8, "%.2f", (Object[])pointF)).toString();
                float f25 = subsamplingScaleImageView26.px(5);
                float f26 = subsamplingScaleImageView26.px(45);
                Paint paint2 = subsamplingScaleImageView26.debugTextPaint;
                canvas.drawText((String)pointF, f25, f26, paint2);
                pointF = this.anim;
                if (pointF != null) {
                    SubsamplingScaleImageView subsamplingScaleImageView29 = this;
                    SubsamplingScaleImageView subsamplingScaleImageView30 = this;
                    pointF = subsamplingScaleImageView30.sourceToViewCoord(((Anim)pointF).sCenterStart);
                    PointF pointF4 = subsamplingScaleImageView30.sourceToViewCoord(subsamplingScaleImageView30.anim.sCenterEndRequested);
                    PointF pointF5 = subsamplingScaleImageView30.sourceToViewCoord(subsamplingScaleImageView30.anim.sCenterEnd);
                    SubsamplingScaleImageView subsamplingScaleImageView31 = this;
                    PointF pointF6 = pointF4;
                    SubsamplingScaleImageView subsamplingScaleImageView32 = this;
                    PointF pointF7 = pointF;
                    float f27 = pointF7.x;
                    f25 = pointF7.y;
                    f26 = subsamplingScaleImageView32.px(10);
                    paint2 = subsamplingScaleImageView32.debugLinePaint;
                    canvas.drawCircle(f27, f25, f26, paint2);
                    this.debugLinePaint.setColor(-65536);
                    f27 = pointF6.x;
                    f25 = pointF6.y;
                    f26 = subsamplingScaleImageView31.px(20);
                    paint2 = subsamplingScaleImageView31.debugLinePaint;
                    canvas.drawCircle(f27, f25, f26, paint2);
                    this.debugLinePaint.setColor(-16776961);
                    f27 = pointF5.x;
                    f25 = pointF5.y;
                    f26 = subsamplingScaleImageView30.px(25);
                    paint2 = subsamplingScaleImageView30.debugLinePaint;
                    canvas.drawCircle(f27, f25, f26, paint2);
                    subsamplingScaleImageView29.debugLinePaint.setColor(-16711681);
                    f27 = subsamplingScaleImageView29.getWidth() / 2;
                    f25 = subsamplingScaleImageView29.getHeight() / 2;
                    f26 = subsamplingScaleImageView29.px(30);
                    paint2 = subsamplingScaleImageView29.debugLinePaint;
                    canvas.drawCircle(f27, f25, f26, paint2);
                }
                if (this.vCenterStart != null) {
                    SubsamplingScaleImageView subsamplingScaleImageView33 = this;
                    subsamplingScaleImageView33.debugLinePaint.setColor(-65536);
                    PointF pointF8 = subsamplingScaleImageView33.vCenterStart;
                    float f28 = pointF8.x;
                    f25 = pointF8.y;
                    f26 = subsamplingScaleImageView33.px(20);
                    paint2 = subsamplingScaleImageView33.debugLinePaint;
                    canvas.drawCircle(f28, f25, f26, paint2);
                }
                if (this.quickScaleSCenter != null) {
                    SubsamplingScaleImageView subsamplingScaleImageView34 = this;
                    subsamplingScaleImageView34.debugLinePaint.setColor(-16776961);
                    float f29 = subsamplingScaleImageView34.sourceToViewX(subsamplingScaleImageView34.quickScaleSCenter.x);
                    f25 = subsamplingScaleImageView34.sourceToViewY(subsamplingScaleImageView34.quickScaleSCenter.y);
                    f26 = subsamplingScaleImageView34.px(35);
                    paint2 = subsamplingScaleImageView34.debugLinePaint;
                    canvas.drawCircle(f29, f25, f26, paint2);
                }
                if (this.quickScaleVStart != null && this.isQuickScaling) {
                    SubsamplingScaleImageView subsamplingScaleImageView35 = this;
                    subsamplingScaleImageView35.debugLinePaint.setColor(-16711681);
                    PointF pointF9 = subsamplingScaleImageView35.quickScaleVStart;
                    float f30 = pointF9.x;
                    float f31 = pointF9.y;
                    f25 = subsamplingScaleImageView35.px(30);
                    Paint paint3 = subsamplingScaleImageView35.debugLinePaint;
                    canvas.drawCircle(f30, f31, f25, paint3);
                }
                this.debugLinePaint.setColor(-65281);
            }
            return;
        }
    }

    public void setOnTileInited(TilesInited tilesInited) {
        this.inited = tilesInited;
    }

    public void setMaxTileSize(int n2) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        subsamplingScaleImageView.maxTileWidth = n2;
        subsamplingScaleImageView.maxTileHeight = n2;
    }

    public void setMaxTileSize(int n2, int n3) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        subsamplingScaleImageView.maxTileWidth = n2;
        subsamplingScaleImageView.maxTileHeight = n3;
    }

    public void recycle() {
        this.reset(true);
        this.bitmapPaint = null;
        this.debugTextPaint = null;
        this.debugLinePaint = null;
        this.tileBgPaint = null;
    }

    public void viewToFileRect(Rect rect, Rect rect2) {
        if (this.vTranslate != null && this.readySent) {
            Rect rect3 = rect2;
            Rect rect4 = rect2;
            int n2 = (int)this.viewToSourceX(rect.left);
            int n3 = (int)this.viewToSourceY(rect.top);
            int n4 = (int)this.viewToSourceX(rect.right);
            int n5 = (int)this.viewToSourceY(rect.bottom);
            rect4.set(n2, n3, n4, n5);
            this.fileSRect(rect4, rect2);
            n2 = Math.max(0, rect3.left);
            n3 = rect3.top;
            int n6 = n2;
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            int n7 = Math.max(0, n3);
            n2 = Math.min(subsamplingScaleImageView.sWidth, rect2.right);
            n3 = Math.min(subsamplingScaleImageView.sHeight, rect2.bottom);
            rect3.set(n6, n7, n2, n3);
            Rect rect5 = this.sRegion;
            if (rect5 != null) {
                Rect rect6 = rect5;
                int n8 = rect6.left;
                rect2.offset(n8, rect6.top);
            }
            return;
        }
    }

    public void visibleFileRect(Rect rect) {
        if (this.vTranslate != null && this.readySent) {
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            int n2 = subsamplingScaleImageView.getWidth();
            int n3 = subsamplingScaleImageView.getHeight();
            rect.set(0, 0, n2, n3);
            Rect rect2 = rect;
            this.viewToFileRect(rect2, rect2);
            return;
        }
    }

    @Nullable
    public final PointF viewToSourceCoord(PointF pointF) {
        PointF pointF2;
        PointF pointF3 = pointF;
        float f2 = pointF3.x;
        float f3 = pointF3.y;
        PointF pointF4 = pointF2;
        pointF2 = new PointF();
        return this.viewToSourceCoord(f2, f3, pointF4);
    }

    @Nullable
    public final PointF viewToSourceCoord(float f2, float f3) {
        PointF pointF;
        SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView2;
        SubsamplingScaleImageView subsamplingScaleImageView2 = pointF;
        pointF = new PointF();
        return subsamplingScaleImageView.viewToSourceCoord(f2, f3, (PointF)subsamplingScaleImageView2);
    }

    @Nullable
    public final PointF viewToSourceCoord(PointF pointF, @NonNull PointF pointF2) {
        PointF pointF3 = pointF;
        float f2 = pointF3.x;
        return this.viewToSourceCoord(f2, pointF3.y, pointF2);
    }

    @Nullable
    public final PointF viewToSourceCoord(float f2, float f3, @NonNull PointF pointF) {
        if (this.vTranslate == null) {
            return null;
        }
        PointF pointF2 = pointF;
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        float f4 = subsamplingScaleImageView.viewToSourceX(f2);
        pointF2.set(f4, subsamplingScaleImageView.viewToSourceY(f3));
        return pointF2;
    }

    @Nullable
    public final PointF sourceToViewCoord(PointF pointF) {
        PointF pointF2;
        PointF pointF3 = pointF;
        float f2 = pointF3.x;
        float f3 = pointF3.y;
        PointF pointF4 = pointF2;
        pointF2 = new PointF();
        return this.sourceToViewCoord(f2, f3, pointF4);
    }

    @Nullable
    public final PointF sourceToViewCoord(float f2, float f3) {
        PointF pointF;
        SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView2;
        SubsamplingScaleImageView subsamplingScaleImageView2 = pointF;
        pointF = new PointF();
        return subsamplingScaleImageView.sourceToViewCoord(f2, f3, (PointF)subsamplingScaleImageView2);
    }

    @Nullable
    public final PointF sourceToViewCoord(PointF pointF, @NonNull PointF pointF2) {
        PointF pointF3 = pointF;
        float f2 = pointF3.x;
        return this.sourceToViewCoord(f2, pointF3.y, pointF2);
    }

    @Nullable
    public final PointF sourceToViewCoord(float f2, float f3, @NonNull PointF pointF) {
        if (this.vTranslate == null) {
            return null;
        }
        PointF pointF2 = pointF;
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        float f4 = subsamplingScaleImageView.sourceToViewX(f2);
        pointF2.set(f4, subsamplingScaleImageView.sourceToViewY(f3));
        return pointF2;
    }

    public final void setRegionDecoderClass(@NonNull Class<? extends ImageRegionDecoder> clazz) {
        if (clazz != null) {
            CompatDecoderFactory<? extends ImageRegionDecoder> compatDecoderFactory;
            SubsamplingScaleImageView subsamplingScaleImageView = object;
            Object object = compatDecoderFactory;
            compatDecoderFactory = new CompatDecoderFactory<ImageRegionDecoder>(clazz);
            subsamplingScaleImageView.regionDecoderFactory = object;
            return;
        }
        throw new IllegalArgumentException("Decoder class cannot be set to null");
    }

    public final void setRegionDecoderFactory(@NonNull DecoderFactory<? extends ImageRegionDecoder> decoderFactory) {
        if (decoderFactory != null) {
            this.regionDecoderFactory = decoderFactory;
            return;
        }
        throw new IllegalArgumentException("Decoder factory cannot be set to null");
    }

    public final void setBitmapDecoderClass(@NonNull Class<? extends ImageDecoder> clazz) {
        if (clazz != null) {
            CompatDecoderFactory<? extends ImageDecoder> compatDecoderFactory;
            SubsamplingScaleImageView subsamplingScaleImageView = object;
            Object object = compatDecoderFactory;
            compatDecoderFactory = new CompatDecoderFactory<ImageDecoder>(clazz);
            subsamplingScaleImageView.bitmapDecoderFactory = object;
            return;
        }
        throw new IllegalArgumentException("Decoder class cannot be set to null");
    }

    public final void setBitmapDecoderFactory(@NonNull DecoderFactory<? extends ImageDecoder> decoderFactory) {
        if (decoderFactory != null) {
            this.bitmapDecoderFactory = decoderFactory;
            return;
        }
        throw new IllegalArgumentException("Decoder factory cannot be set to null");
    }

    public final void getPanRemaining(RectF rectF) {
        if (!this.isReady()) {
            return;
        }
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        float f2 = subsamplingScaleImageView.scale * (float)this.sWidth();
        float f3 = subsamplingScaleImageView.scale * (float)this.sHeight();
        int n2 = subsamplingScaleImageView.panLimit;
        if (n2 == 3) {
            rectF.top = Math.max(0.0f, -(this.vTranslate.y - (float)(this.getHeight() / 2)));
            rectF.left = Math.max(0.0f, -(this.vTranslate.x - (float)(this.getWidth() / 2)));
            rectF.bottom = Math.max(0.0f, this.vTranslate.y - ((float)(this.getHeight() / 2) - f3));
            rectF.right = Math.max(0.0f, this.vTranslate.x - ((float)(this.getWidth() / 2) - f2));
        } else if (n2 == 2) {
            rectF.top = Math.max(0.0f, -(this.vTranslate.y - (float)this.getHeight()));
            rectF.left = Math.max(0.0f, -(this.vTranslate.x - (float)this.getWidth()));
            rectF.bottom = Math.max(0.0f, this.vTranslate.y + f3);
            rectF.right = Math.max(0.0f, this.vTranslate.x + f2);
        } else {
            rectF.top = Math.max(0.0f, -this.vTranslate.y);
            rectF.left = Math.max(0.0f, -this.vTranslate.x);
            rectF.bottom = Math.max(0.0f, f3 + this.vTranslate.y - (float)this.getHeight());
            rectF.right = Math.max(0.0f, f2 + this.vTranslate.x - (float)this.getWidth());
        }
    }

    public final void setPanLimit(int n2) {
        if (VALID_PAN_LIMITS.contains(n2)) {
            this.panLimit = n2;
            if (this.isReady()) {
                SubsamplingScaleImageView subsamplingScaleImageView = this;
                subsamplingScaleImageView.fitToBounds(true);
                subsamplingScaleImageView.invalidate();
            }
            return;
        }
        throw new IllegalArgumentException("Invalid pan limit: " + n2);
    }

    public final void setMinimumScaleType(int n2) {
        if (VALID_SCALE_TYPES.contains(n2)) {
            this.minimumScaleType = n2;
            if (this.isReady()) {
                SubsamplingScaleImageView subsamplingScaleImageView = this;
                subsamplingScaleImageView.fitToBounds(true);
                subsamplingScaleImageView.invalidate();
            }
            return;
        }
        throw new IllegalArgumentException("Invalid scale type: " + n2);
    }

    public final void setMaxScale(float f2) {
        this.maxScale = f2;
    }

    public final void setMinScale(float f2) {
        this.minScale = f2;
    }

    public final void setMinimumDpi(int n2) {
        SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView2;
        SubsamplingScaleImageView subsamplingScaleImageView2 = subsamplingScaleImageView.getResources().getDisplayMetrics();
        subsamplingScaleImageView.setMaxScale((((DisplayMetrics)subsamplingScaleImageView2).xdpi + ((DisplayMetrics)subsamplingScaleImageView2).ydpi) / 2.0f / (float)n2);
    }

    public final void setMaximumDpi(int n2) {
        SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView2;
        SubsamplingScaleImageView subsamplingScaleImageView2 = subsamplingScaleImageView.getResources().getDisplayMetrics();
        subsamplingScaleImageView.setMinScale((((DisplayMetrics)subsamplingScaleImageView2).xdpi + ((DisplayMetrics)subsamplingScaleImageView2).ydpi) / 2.0f / (float)n2);
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    public final float getMinScale() {
        return this.minScale();
    }

    public void setMinimumTileDpi(int n2) {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        DisplayMetrics displayMetrics = subsamplingScaleImageView.getResources().getDisplayMetrics();
        subsamplingScaleImageView.minimumTileDpi = (int)Math.min((displayMetrics.xdpi + displayMetrics.ydpi) / 2.0f, (float)n2);
        if (subsamplingScaleImageView.isReady()) {
            SubsamplingScaleImageView subsamplingScaleImageView2 = this;
            subsamplingScaleImageView2.reset(false);
            subsamplingScaleImageView2.invalidate();
        }
    }

    @Nullable
    public final PointF getCenter() {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        int n2 = subsamplingScaleImageView.getWidth() / 2;
        float f2 = n2;
        return subsamplingScaleImageView.viewToSourceCoord(f2, subsamplingScaleImageView.getHeight() / 2);
    }

    public final float getScale() {
        return this.scale;
    }

    public final void setScaleAndCenter(float f2, @Nullable PointF pointF) {
        this.anim = null;
        this.pendingScale = Float.valueOf(f2);
        this.sPendingCenter = pointF;
        this.sRequestedCenter = pointF;
        this.invalidate();
    }

    public final void resetScaleAndCenter() {
        SubsamplingScaleImageView subsamplingScaleImageView = this;
        subsamplingScaleImageView.anim = null;
        subsamplingScaleImageView.pendingScale = Float.valueOf(subsamplingScaleImageView.limitedScale(0.0f));
        if (subsamplingScaleImageView.isReady()) {
            this.sPendingCenter = new PointF((float)(this.sWidth() / 2), (float)(this.sHeight() / 2));
        } else {
            PointF pointF;
            PointF pointF2 = pointF;
            pointF = new PointF(0.0f, 0.0f);
            this.sPendingCenter = pointF2;
        }
        this.invalidate();
    }

    public final boolean isReady() {
        return this.readySent;
    }

    protected void onReady() {
    }

    public final boolean isImageLoaded() {
        return this.imageLoadedSent;
    }

    protected void onImageLoaded() {
    }

    public final int getSWidth() {
        return this.sWidth;
    }

    public final int getSHeight() {
        return this.sHeight;
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final int getAppliedOrientation() {
        return this.getRequiredRotation();
    }

    @Nullable
    public final ImageViewState getState() {
        if (this.vTranslate != null && this.sWidth > 0 && this.sHeight > 0) {
            SubsamplingScaleImageView subsamplingScaleImageView = this;
            float f2 = subsamplingScaleImageView.getScale();
            PointF pointF = subsamplingScaleImageView.getCenter();
            int n2 = subsamplingScaleImageView.getOrientation();
            return new ImageViewState(f2, pointF, n2);
        }
        return null;
    }

    public final boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    public final void setZoomEnabled(boolean bl) {
        this.zoomEnabled = bl;
    }

    public final boolean isQuickScaleEnabled() {
        return this.quickScaleEnabled;
    }

    public final void setQuickScaleEnabled(boolean bl) {
        this.quickScaleEnabled = bl;
    }

    public final boolean isPanEnabled() {
        return this.panEnabled;
    }

    public final void setPanEnabled(boolean bl) {
        PointF pointF;
        this.panEnabled = bl;
        if (!bl && (pointF = this.vTranslate) != null) {
            pointF.x = (float)(this.getWidth() / 2) - this.scale * (float)(this.sWidth() / 2);
            this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * (float)(this.sHeight() / 2);
            if (this.isReady()) {
                SubsamplingScaleImageView subsamplingScaleImageView = this;
                subsamplingScaleImageView.refreshRequiredTiles(true);
                subsamplingScaleImageView.invalidate();
            }
        }
    }

    public final void setTileBackgroundColor(int n2) {
        if (Color.alpha((int)n2) == 0) {
            this.tileBgPaint = null;
        } else {
            this.tileBgPaint = new Paint();
            this.tileBgPaint.setStyle(Paint.Style.FILL);
            this.tileBgPaint.setColor(n2);
        }
        this.invalidate();
    }

    public final void setDoubleTapZoomScale(float f2) {
        this.doubleTapZoomScale = f2;
    }

    public final void setDoubleTapZoomDpi(int n2) {
        SubsamplingScaleImageView subsamplingScaleImageView = subsamplingScaleImageView2;
        SubsamplingScaleImageView subsamplingScaleImageView2 = subsamplingScaleImageView.getResources().getDisplayMetrics();
        subsamplingScaleImageView.setDoubleTapZoomScale((((DisplayMetrics)subsamplingScaleImageView2).xdpi + ((DisplayMetrics)subsamplingScaleImageView2).ydpi) / 2.0f / (float)n2);
    }

    public final void setDoubleTapZoomStyle(int n2) {
        if (VALID_ZOOM_STYLES.contains(n2)) {
            this.doubleTapZoomStyle = n2;
            return;
        }
        throw new IllegalArgumentException("Invalid zoom style: " + n2);
    }

    public final void setDoubleTapZoomDuration(int n2) {
        this.doubleTapZoomDuration = Math.max(0, n2);
    }

    public void setExecutor(@NonNull Executor executor) {
        if (executor != null) {
            this.executor = executor;
            return;
        }
        throw new NullPointerException("Executor must not be null");
    }

    public void setEagerLoadingEnabled(boolean bl) {
        this.eagerLoadingEnabled = bl;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean hasImage() {
        return this.uri != null || this.bitmap != null;
    }

    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        super.setOnLongClickListener(onLongClickListener);
        this.onLongClickListener = onLongClickListener;
    }

    public void setOnImageEventListener(OnImageEventListener onImageEventListener) {
        this.onImageEventListener = onImageEventListener;
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.onStateChangedListener = onStateChangedListener;
    }

    @Nullable
    public AnimationBuilder animateCenter(PointF pointF) {
        if (!this.isReady()) {
            return null;
        }
        return new AnimationBuilder(this, pointF);
    }

    @Nullable
    public AnimationBuilder animateScale(float f2) {
        if (!this.isReady()) {
            return null;
        }
        return new AnimationBuilder(this, f2);
    }

    @Nullable
    public AnimationBuilder animateScaleAndCenter(float f2, PointF pointF) {
        if (!this.isReady()) {
            return null;
        }
        return new AnimationBuilder(this, f2, pointF);
    }

    public static class DefaultOnStateChangedListener
    implements OnStateChangedListener {
        @Override
        public void onCenterChanged(PointF pointF, int n2) {
        }

        @Override
        public void onScaleChanged(float f2, int n2) {
        }
    }

    public static interface OnStateChangedListener {
        public void onScaleChanged(float var1, int var2);

        public void onCenterChanged(PointF var1, int var2);
    }

    public static class DefaultOnImageEventListener
    implements OnImageEventListener {
        @Override
        public void onReady() {
        }

        @Override
        public void onImageLoaded() {
        }

        @Override
        public void onPreviewLoadError(Exception exception) {
        }

        @Override
        public void onImageLoadError(Exception exception) {
        }

        @Override
        public void onTileLoadError(Exception exception) {
        }

        @Override
        public void onPreviewReleased() {
        }
    }

    public static interface OnImageEventListener {
        public void onReady();

        public void onImageLoaded();

        public void onPreviewLoadError(Exception var1);

        public void onImageLoadError(Exception var1);

        public void onTileLoadError(Exception var1);

        public void onPreviewReleased();
    }

    public static class DefaultOnAnimationEventListener
    implements OnAnimationEventListener {
        @Override
        public void onComplete() {
        }

        @Override
        public void onInterruptedByUser() {
        }

        @Override
        public void onInterruptedByNewAnim() {
        }
    }

    public static interface OnAnimationEventListener {
        public void onComplete();

        public void onInterruptedByUser();

        public void onInterruptedByNewAnim();
    }

    public final class AnimationBuilder {
        private final float targetScale;
        private final PointF targetSCenter;
        private final PointF vFocus;
        private long duration;
        private int easing;
        private int origin;
        private boolean interruptible;
        private boolean panLimited;
        private OnAnimationEventListener listener;
        final /* synthetic */ SubsamplingScaleImageView this$0;

        private AnimationBuilder(SubsamplingScaleImageView subsamplingScaleImageView, PointF pointF) {
            AnimationBuilder animationBuilder = this;
            this.this$0 = subsamplingScaleImageView;
            this.duration = 500L;
            this.easing = 2;
            this.origin = 1;
            this.interruptible = true;
            this.panLimited = true;
            this.targetScale = subsamplingScaleImageView.scale;
            animationBuilder.targetSCenter = pointF;
            animationBuilder.vFocus = null;
        }

        private AnimationBuilder(SubsamplingScaleImageView subsamplingScaleImageView, float f2) {
            AnimationBuilder animationBuilder = this;
            this.this$0 = subsamplingScaleImageView;
            this.duration = 500L;
            this.easing = 2;
            this.origin = 1;
            this.interruptible = true;
            this.panLimited = true;
            this.targetScale = f2;
            animationBuilder.targetSCenter = subsamplingScaleImageView.getCenter();
            animationBuilder.vFocus = null;
        }

        private AnimationBuilder(SubsamplingScaleImageView subsamplingScaleImageView, float f2, PointF pointF) {
            this.this$0 = subsamplingScaleImageView;
            this.duration = 500L;
            this.easing = 2;
            this.origin = 1;
            this.interruptible = true;
            this.panLimited = true;
            this.targetScale = f2;
            this.targetSCenter = pointF;
            this.vFocus = null;
        }

        private AnimationBuilder(SubsamplingScaleImageView subsamplingScaleImageView, float f2, PointF pointF, PointF pointF2) {
            this.this$0 = subsamplingScaleImageView;
            this.duration = 500L;
            this.easing = 2;
            this.origin = 1;
            this.interruptible = true;
            this.panLimited = true;
            this.targetScale = f2;
            this.targetSCenter = pointF;
            this.vFocus = pointF2;
        }

        @NonNull
        private AnimationBuilder withPanLimited(boolean bl) {
            this.panLimited = bl;
            return this;
        }

        @NonNull
        private AnimationBuilder withOrigin(int n2) {
            this.origin = n2;
            return this;
        }

        @NonNull
        public AnimationBuilder withDuration(long l2) {
            this.duration = l2;
            return this;
        }

        @NonNull
        public AnimationBuilder withInterruptible(boolean bl) {
            this.interruptible = bl;
            return this;
        }

        @NonNull
        public AnimationBuilder withEasing(int n2) {
            if (VALID_EASING_STYLES.contains(n2)) {
                this.easing = n2;
                return this;
            }
            throw new IllegalArgumentException("Unknown easing type: " + n2);
        }

        @NonNull
        public AnimationBuilder withOnAnimationEventListener(OnAnimationEventListener onAnimationEventListener) {
            this.listener = onAnimationEventListener;
            return this;
        }

        public void start() {
            Object object;
            if (this.this$0.anim != null && this.this$0.anim.listener != null) {
                try {
                    this.this$0.anim.listener.onInterruptedByNewAnim();
                }
                catch (Exception exception) {
                    Log.w((String)TAG, (String)"Error thrown by animation listener", (Throwable)exception);
                }
            }
            AnimationBuilder animationBuilder = this;
            int n2 = animationBuilder.this$0.getPaddingLeft() + (this.this$0.getWidth() - this.this$0.getPaddingRight() - this.this$0.getPaddingLeft()) / 2;
            int n3 = animationBuilder.this$0.getPaddingTop() + (this.this$0.getHeight() - this.this$0.getPaddingBottom() - this.this$0.getPaddingTop()) / 2;
            float f2 = animationBuilder.this$0.limitedScale(this.targetScale);
            if (animationBuilder.panLimited) {
                PointF pointF;
                PointF pointF2 = this.targetSCenter;
                float f3 = pointF2.x;
                float f4 = pointF2.y;
                object = pointF;
                pointF = new PointF();
                object = this.this$0.limitedSCenter(f3, f4, f2, object);
            } else {
                object = this.targetSCenter;
            }
            AnimationBuilder animationBuilder2 = this;
            SubsamplingScaleImageView.access$6402(animationBuilder2.this$0, new Anim());
            Anim.access$3502(animationBuilder2.this$0.anim, this.this$0.scale);
            Anim.access$3602(animationBuilder2.this$0.anim, f2);
            Anim.access$3202(animationBuilder2.this$0.anim, System.currentTimeMillis());
            Anim.access$4502(animationBuilder2.this$0.anim, object);
            Anim.access$4402(animationBuilder2.this$0.anim, this.this$0.getCenter());
            Anim.access$3802(animationBuilder2.this$0.anim, object);
            Anim.access$3102(animationBuilder2.this$0.anim, this.this$0.sourceToViewCoord((PointF)object));
            float f5 = n2;
            Anim.access$3702(animationBuilder2.this$0.anim, new PointF(f5, (float)n3));
            Anim.access$3302(animationBuilder2.this$0.anim, this.duration);
            Anim.access$2702(animationBuilder2.this$0.anim, this.interruptible);
            Anim.access$3402(animationBuilder2.this$0.anim, this.easing);
            Anim.access$3902(animationBuilder2.this$0.anim, this.origin);
            Anim.access$3202(animationBuilder2.this$0.anim, System.currentTimeMillis());
            Anim.access$2802(animationBuilder2.this$0.anim, this.listener);
            PointF pointF = animationBuilder2.vFocus;
            if (pointF != null) {
                ScaleAndTranslate scaleAndTranslate;
                AnimationBuilder animationBuilder3 = this;
                float f6 = pointF.x - f2 * ((Anim)((SubsamplingScaleImageView)this.this$0).anim).sCenterStart.x;
                float f7 = animationBuilder3.vFocus.y - f2 * ((Anim)((SubsamplingScaleImageView)this.this$0).anim).sCenterStart.y;
                object = scaleAndTranslate;
                scaleAndTranslate = new ScaleAndTranslate(f2, new PointF(f6, f7));
                animationBuilder3.this$0.fitToBounds(true, (ScaleAndTranslate)object);
                Anim.access$3702(animationBuilder3.this$0.anim, new PointF(this.vFocus.x + (((ScaleAndTranslate)object).vTranslate.x - f6), this.vFocus.y + (((ScaleAndTranslate)object).vTranslate.y - f7)));
            }
            this.this$0.invalidate();
        }
    }

    private static class ScaleAndTranslate {
        private float scale;
        private final PointF vTranslate;

        private ScaleAndTranslate(float f2, PointF pointF) {
            this.scale = f2;
            this.vTranslate = pointF;
        }

        static /* synthetic */ float access$4702(ScaleAndTranslate scaleAndTranslate, float f2) {
            scaleAndTranslate.scale = f2;
            return f2;
        }
    }

    private static class Anim {
        private float scaleStart;
        private float scaleEnd;
        private PointF sCenterStart;
        private PointF sCenterEnd;
        private PointF sCenterEndRequested;
        private PointF vFocusStart;
        private PointF vFocusEnd;
        private long duration = 500L;
        private boolean interruptible = true;
        private int easing = 2;
        private int origin = 1;
        private long time = System.currentTimeMillis();
        private OnAnimationEventListener listener;

        private Anim() {
        }

        static /* synthetic */ float access$3502(Anim anim2, float f2) {
            anim2.scaleStart = f2;
            return f2;
        }

        static /* synthetic */ float access$3602(Anim anim2, float f2) {
            anim2.scaleEnd = f2;
            return f2;
        }

        static /* synthetic */ long access$3202(Anim anim2, long l2) {
            anim2.time = l2;
            return l2;
        }

        static /* synthetic */ PointF access$4502(Anim anim2, PointF pointF) {
            anim2.sCenterEndRequested = pointF;
            return pointF;
        }

        static /* synthetic */ PointF access$4402(Anim anim2, PointF pointF) {
            anim2.sCenterStart = pointF;
            return pointF;
        }

        static /* synthetic */ PointF access$3802(Anim anim2, PointF pointF) {
            anim2.sCenterEnd = pointF;
            return pointF;
        }

        static /* synthetic */ PointF access$3102(Anim anim2, PointF pointF) {
            anim2.vFocusStart = pointF;
            return pointF;
        }

        static /* synthetic */ PointF access$3702(Anim anim2, PointF pointF) {
            anim2.vFocusEnd = pointF;
            return pointF;
        }

        static /* synthetic */ long access$3302(Anim anim2, long l2) {
            anim2.duration = l2;
            return l2;
        }

        static /* synthetic */ boolean access$2702(Anim anim2, boolean bl) {
            anim2.interruptible = bl;
            return bl;
        }

        static /* synthetic */ int access$3402(Anim anim2, int n2) {
            anim2.easing = n2;
            return n2;
        }

        static /* synthetic */ int access$3902(Anim anim2, int n2) {
            anim2.origin = n2;
            return n2;
        }

        static /* synthetic */ OnAnimationEventListener access$2802(Anim anim2, OnAnimationEventListener onAnimationEventListener) {
            anim2.listener = onAnimationEventListener;
            return onAnimationEventListener;
        }
    }

    private static class Tile {
        private Rect sRect;
        private int sampleSize;
        private Bitmap bitmap;
        private boolean loading;
        private boolean visible;
        private Rect vRect;
        private Rect fileSRect;

        private Tile() {
        }

        static /* synthetic */ boolean access$402(Tile tile, boolean bl) {
            tile.visible = bl;
            return bl;
        }

        static /* synthetic */ Bitmap access$502(Tile tile, Bitmap bitmap) {
            tile.bitmap = bitmap;
            return bitmap;
        }

        static /* synthetic */ int access$4302(Tile tile, int n2) {
            tile.sampleSize = n2;
            return n2;
        }

        static /* synthetic */ Rect access$4102(Tile tile, Rect rect) {
            tile.sRect = rect;
            return rect;
        }

        static /* synthetic */ Rect access$4202(Tile tile, Rect rect) {
            tile.vRect = rect;
            return rect;
        }

        static /* synthetic */ Rect access$5002(Tile tile, Rect rect) {
            tile.fileSRect = rect;
            return rect;
        }

        static /* synthetic */ boolean access$4002(Tile tile, boolean bl) {
            tile.loading = bl;
            return bl;
        }

        static /* synthetic */ Rect access$5000(Tile tile) {
            return tile.fileSRect;
        }
    }

    private static class BitmapLoadTask
    extends AsyncTask<Void, Void, Integer> {
        private final WeakReference<SubsamplingScaleImageView> viewRef;
        private final WeakReference<Context> contextRef;
        private final WeakReference<DecoderFactory<? extends ImageDecoder>> decoderFactoryRef;
        private final Uri source;
        private final boolean preview;
        private Bitmap bitmap;
        private Exception exception;

        BitmapLoadTask(SubsamplingScaleImageView subsamplingScaleImageView, Context context, DecoderFactory<? extends ImageDecoder> decoderFactory, Uri uri, boolean bl) {
            WeakReference<DecoderFactory<? extends ImageDecoder>> weakReference;
            WeakReference<Context> weakReference2;
            WeakReference<SubsamplingScaleImageView> weakReference3;
            Object object = weakReference3;
            weakReference3 = new WeakReference<SubsamplingScaleImageView>(subsamplingScaleImageView);
            v1.viewRef = object;
            object = weakReference2;
            weakReference2 = new WeakReference<Context>(context);
            v1.contextRef = object;
            object = weakReference;
            weakReference = new WeakReference<DecoderFactory<? extends ImageDecoder>>(decoderFactory);
            v1.decoderFactoryRef = object;
            v1.source = uri;
            v1.preview = bl;
        }

        protected Integer doInBackground(Void ... object) {
            block7: {
                BitmapLoadTask bitmapLoadTask = this;
                BitmapLoadTask bitmapLoadTask2 = bitmapLoadTask;
                object = bitmapLoadTask.source.toString();
                Context context = (Context)bitmapLoadTask2.contextRef.get();
                BitmapLoadTask bitmapLoadTask3 = this;
                BitmapLoadTask bitmapLoadTask4 = bitmapLoadTask3;
                DecoderFactory decoderFactory = (DecoderFactory)bitmapLoadTask3.decoderFactoryRef.get();
                SubsamplingScaleImageView subsamplingScaleImageView = (SubsamplingScaleImageView)((Object)bitmapLoadTask4.viewRef.get());
                if (context == null || decoderFactory == null || subsamplingScaleImageView == null) break block7;
                try {
                    subsamplingScaleImageView.debug("BitmapLoadTask.doInBackground", new Object[0]);
                    this.bitmap = ((ImageDecoder)decoderFactory.make()).decode(context, this.source);
                    return subsamplingScaleImageView.getExifOrientation(context, (String)object);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e((String)TAG, (String)"Failed to load bitmap - OutOfMemoryError", (Throwable)outOfMemoryError);
                    this.exception = new RuntimeException(outOfMemoryError);
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)"Failed to load bitmap", (Throwable)exception);
                    this.exception = exception;
                }
            }
            return null;
        }

        protected void onPostExecute(Integer n2) {
            SubsamplingScaleImageView subsamplingScaleImageView = (SubsamplingScaleImageView)((Object)this.viewRef.get());
            if (subsamplingScaleImageView != null) {
                Bitmap bitmap = this.bitmap;
                if (bitmap != null && n2 != null) {
                    if (this.preview) {
                        subsamplingScaleImageView.onPreviewLoaded(bitmap);
                    } else {
                        subsamplingScaleImageView.onImageLoaded(bitmap, n2, false);
                    }
                } else if (this.exception != null && subsamplingScaleImageView.onImageEventListener != null) {
                    if (this.preview) {
                        subsamplingScaleImageView.onImageEventListener.onPreviewLoadError(this.exception);
                    } else {
                        subsamplingScaleImageView.onImageEventListener.onImageLoadError(this.exception);
                    }
                }
            }
        }
    }

    private static class TileLoadTask
    extends AsyncTask<Void, Void, Bitmap> {
        private final WeakReference<SubsamplingScaleImageView> viewRef;
        private final WeakReference<ImageRegionDecoder> decoderRef;
        private final WeakReference<Tile> tileRef;
        private Exception exception;

        TileLoadTask(SubsamplingScaleImageView subsamplingScaleImageView, ImageRegionDecoder imageRegionDecoder, Tile tile) {
            WeakReference<Tile> weakReference;
            WeakReference<ImageRegionDecoder> weakReference2;
            WeakReference<SubsamplingScaleImageView> weakReference3;
            Object object = weakReference3;
            weakReference3 = new WeakReference<SubsamplingScaleImageView>(subsamplingScaleImageView);
            v1.viewRef = object;
            object = weakReference2;
            weakReference2 = new WeakReference<ImageRegionDecoder>(imageRegionDecoder);
            v1.decoderRef = object;
            object = weakReference;
            weakReference = new WeakReference<Tile>(tile);
            v1.tileRef = object;
            Tile.access$4002(tile, true);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        protected Bitmap doInBackground(Void ... var1_1) {
            block24: {
                block22: {
                    block23: {
                        v0 = this;
                        v1 = v0;
                        var1_1 /* !! */  = (SubsamplingScaleImageView)v0.viewRef.get();
                        var2_4 = (ImageRegionDecoder)v1.decoderRef.get();
                        var3_6 = (Tile)this.tileRef.get();
                        if (var2_4 == null || var3_6 == null || var1_1 /* !! */  == null) break block22;
                        if (!var2_4.isReady()) break block22;
                        if (!Tile.access$400(var3_6)) break block22;
                        v2 = new Object[2];
                        var4_7 = 0;
                        v2[var4_7] = Tile.access$4100(var3_6);
                        v2[1] = Tile.access$4300(var3_6);
                        SubsamplingScaleImageView.access$5100((SubsamplingScaleImageView)var1_1 /* !! */ , "TileLoadTask.doInBackground, tile.sRect=%s, tile.sampleSize=%d", v2);
                        SubsamplingScaleImageView.access$5700((SubsamplingScaleImageView)var1_1 /* !! */ ).readLock().lock();
                        if (!var2_4.isReady()) break block23;
                        v3 /* !! */  = var1_1 /* !! */ ;
                        v4 /* !! */  = var1_1 /* !! */ ;
                        v5 = var3_6;
                        v6 = v5;
                        var4_8 = Tile.access$4100(v5);
                        SubsamplingScaleImageView.access$5800((SubsamplingScaleImageView)v3 /* !! */ , var4_8, Tile.access$5000(v6));
                        if (SubsamplingScaleImageView.access$5300((SubsamplingScaleImageView)v4 /* !! */ ) == null) ** GOTO lbl36
                        Tile.access$5000(var3_6).offset(SubsamplingScaleImageView.access$5300((SubsamplingScaleImageView)var1_1 /* !! */ ).left, SubsamplingScaleImageView.access$5300((SubsamplingScaleImageView)var1_1 /* !! */ ).top);
lbl36:
                        // 2 sources

                        v7 = var2_4;
                        v8 = var3_6;
                        v9 = v8;
                        var2_4 = Tile.access$5000(v8);
                        v10 = v7.decodeRegion((Rect)var2_4, Tile.access$4300(v9));
                        SubsamplingScaleImageView.access$5700((SubsamplingScaleImageView)var1_1 /* !! */ ).readLock().unlock();
                        return v10;
                    }
                    v11 /* !! */  = var1_1 /* !! */ ;
                    Tile.access$4002(var3_6, false);
                    SubsamplingScaleImageView.access$5700((SubsamplingScaleImageView)v11 /* !! */ ).readLock().unlock();
                    catch (Throwable var2_5) {
                        SubsamplingScaleImageView.access$5700((SubsamplingScaleImageView)var1_1 /* !! */ ).readLock().unlock();
                        throw var2_5;
                    }
                }
                if (var3_6 != null) {
                    Tile.access$4002(var3_6, false);
                }
                break block24;
                {
                    catch (OutOfMemoryError var1_2) {
                        Log.e((String)SubsamplingScaleImageView.access$5400(), (String)"Failed to decode tile - OutOfMemoryError", (Throwable)var1_2);
                        this.exception = new RuntimeException(var1_2);
                        break block24;
                    }
                    catch (Exception var1_3) {
                        Log.e((String)SubsamplingScaleImageView.access$5400(), (String)"Failed to decode tile", (Throwable)var1_3);
                        this.exception = var1_3;
                    }
                }
            }
            return null;
        }

        protected void onPostExecute(Bitmap bitmap) {
            SubsamplingScaleImageView subsamplingScaleImageView = (SubsamplingScaleImageView)((Object)this.viewRef.get());
            Tile tile = (Tile)this.tileRef.get();
            if (subsamplingScaleImageView != null && tile != null) {
                if (bitmap != null) {
                    Tile tile2 = tile;
                    Tile.access$502(tile2, bitmap);
                    Tile.access$4002(tile2, false);
                    subsamplingScaleImageView.onTileLoaded();
                } else if (this.exception != null && subsamplingScaleImageView.onImageEventListener != null) {
                    subsamplingScaleImageView.onImageEventListener.onTileLoadError(this.exception);
                }
            }
        }
    }

    public static interface TilesInited {
        public void onTileInited();
    }

    private static class TilesInitTask
    extends AsyncTask<Void, Void, int[]> {
        private final WeakReference<SubsamplingScaleImageView> viewRef;
        private final WeakReference<Context> contextRef;
        private final WeakReference<DecoderFactory<? extends ImageRegionDecoder>> decoderFactoryRef;
        private final Uri source;
        private ImageRegionDecoder decoder;
        private Exception exception;

        TilesInitTask(SubsamplingScaleImageView subsamplingScaleImageView, Context context, DecoderFactory<? extends ImageRegionDecoder> decoderFactory, Uri uri) {
            WeakReference<DecoderFactory<? extends ImageRegionDecoder>> weakReference;
            WeakReference<Context> weakReference2;
            WeakReference<SubsamplingScaleImageView> weakReference3;
            Object object = weakReference3;
            weakReference3 = new WeakReference<SubsamplingScaleImageView>(subsamplingScaleImageView);
            v1.viewRef = object;
            object = weakReference2;
            weakReference2 = new WeakReference<Context>(context);
            v1.contextRef = object;
            object = weakReference;
            weakReference = new WeakReference<DecoderFactory<? extends ImageRegionDecoder>>(decoderFactory);
            v1.decoderFactoryRef = object;
            v1.source = uri;
        }

        protected int[] doInBackground(Void ... object) {
            block15: {
                int n2;
                int n3;
                int n4;
                block16: {
                    TilesInitTask tilesInitTask = this;
                    TilesInitTask tilesInitTask2 = tilesInitTask;
                    object = tilesInitTask.source.toString();
                    Context context = (Context)tilesInitTask2.contextRef.get();
                    TilesInitTask tilesInitTask3 = this;
                    TilesInitTask tilesInitTask4 = tilesInitTask3;
                    DecoderFactory decoderFactory = (DecoderFactory)tilesInitTask3.decoderFactoryRef.get();
                    SubsamplingScaleImageView subsamplingScaleImageView = (SubsamplingScaleImageView)((Object)tilesInitTask4.viewRef.get());
                    if (context == null || decoderFactory == null || subsamplingScaleImageView == null) break block15;
                    SubsamplingScaleImageView subsamplingScaleImageView2 = subsamplingScaleImageView;
                    Object object2 = object;
                    subsamplingScaleImageView.debug("TilesInitTask.doInBackground", new Object[0]);
                    object = (ImageRegionDecoder)decoderFactory.make();
                    this.decoder = object;
                    Point point = object.init(context, this.source);
                    Point point2 = point;
                    n4 = point.x;
                    n3 = point2.y;
                    n2 = subsamplingScaleImageView2.getExifOrientation(context, (String)object2);
                    if (subsamplingScaleImageView2.sRegion == null) break block16;
                    SubsamplingScaleImageView subsamplingScaleImageView3 = subsamplingScaleImageView;
                    SubsamplingScaleImageView subsamplingScaleImageView4 = subsamplingScaleImageView3;
                    SubsamplingScaleImageView subsamplingScaleImageView5 = subsamplingScaleImageView3;
                    SubsamplingScaleImageView subsamplingScaleImageView6 = subsamplingScaleImageView3;
                    SubsamplingScaleImageView subsamplingScaleImageView7 = subsamplingScaleImageView3;
                    SubsamplingScaleImageView subsamplingScaleImageView8 = subsamplingScaleImageView3;
                    Rect rect = subsamplingScaleImageView3.sRegion;
                    rect.left = Math.max(0, ((SubsamplingScaleImageView)subsamplingScaleImageView).sRegion.left);
                    Rect rect2 = subsamplingScaleImageView6.sRegion;
                    rect2.top = Math.max(0, ((SubsamplingScaleImageView)subsamplingScaleImageView).sRegion.top);
                    ((SubsamplingScaleImageView)subsamplingScaleImageView7).sRegion.right = Math.min(n4, ((SubsamplingScaleImageView)subsamplingScaleImageView).sRegion.right);
                    ((SubsamplingScaleImageView)subsamplingScaleImageView8).sRegion.bottom = Math.min(n3, ((SubsamplingScaleImageView)subsamplingScaleImageView).sRegion.bottom);
                    n4 = subsamplingScaleImageView4.sRegion.width();
                    n3 = subsamplingScaleImageView5.sRegion.height();
                }
                try {
                    return new int[]{n4, n3, n2};
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)"Failed to initialise bitmap decoder", (Throwable)exception);
                    this.exception = exception;
                }
            }
            return null;
        }

        protected void onPostExecute(int[] nArray) {
            SubsamplingScaleImageView subsamplingScaleImageView = (SubsamplingScaleImageView)((Object)this.viewRef.get());
            if (subsamplingScaleImageView != null) {
                ImageRegionDecoder imageRegionDecoder = this.decoder;
                if (imageRegionDecoder != null && nArray != null && nArray.length == 3) {
                    int n2 = nArray[0];
                    int n3 = nArray[1];
                    int n4 = nArray[2];
                    subsamplingScaleImageView.onTilesInited(imageRegionDecoder, n2, n3, n4);
                } else if (this.exception != null && subsamplingScaleImageView.onImageEventListener != null) {
                    subsamplingScaleImageView.onImageEventListener.onImageLoadError(this.exception);
                }
            }
        }
    }
}

