/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.gg.dcloud;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.view.View;
import io.dcloud.feature.gg.dcloud.ADHandler;

public class BitmapView
extends View {
    Bitmap mDrawable = null;
    int mMaxHeight = 0;
    int mMaxWidth = 0;
    ADHandler.AdData mAdData = null;
    Paint paint;
    Rect src;
    RectF dest;
    Bitmap backgroundBitmap;
    RectF backgroundRect;

    public BitmapView(Context context, Bitmap bitmap, ADHandler.AdData adData) {
        super(context);
        Paint paint;
        BitmapView bitmapView = paint;
        paint = new Paint();
        v1.paint = bitmapView;
        v1.src = null;
        v1.dest = null;
        v1.backgroundBitmap = null;
        v1.backgroundRect = null;
        v1.mDrawable = bitmap;
        v1.mAdData = adData;
    }

    private void drawBackgroundImage(Canvas canvas) {
        float f2;
        BitmapView bitmapView = bitmapView5;
        float f3 = bitmapView.mDrawable.getHeight();
        float f4 = bitmapView.mDrawable.getWidth();
        float f5 = bitmapView.getHeight() > 0 ? (float)bitmapView5.getHeight() : (float)canvas.getHeight();
        float f6 = bitmapView5.getWidth() > 0 ? (float)bitmapView5.getWidth() : (float)canvas.getWidth();
        float f7 = f3 / f4;
        float f8 = f5 / f6 - f7;
        if ((double)f2 > 0.15) {
            f7 = (f5 - f6 * f7) / 2.0f;
            float f9 = f5 - f7;
            bitmapView5.dest = new RectF(0.0f, f7, f6, f9);
            if (bitmapView5.backgroundRect == null) {
                float f10;
                Rect rect;
                Paint paint;
                Canvas canvas2;
                BitmapView bitmapView2 = bitmapView5;
                int n2 = (int)f4;
                int n3 = (int)f3;
                bitmapView2.backgroundBitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas3 = canvas2;
                canvas3(bitmapView5.backgroundBitmap);
                Paint paint2 = paint;
                paint = new Paint();
                Rect rect2 = rect;
                rect = new Rect(0, 0, n2, n3);
                canvas2.drawBitmap(bitmapView5.mDrawable, new Rect(0, 0, n2, n3), rect2, paint2);
                n3 = bitmapView2.getBright(bitmapView2.mDrawable) >= 128 ? 0x66000000 : 0x66FFFFFF;
                BitmapView bitmapView3 = bitmapView5;
                canvas3.drawColor(n3);
                float f11 = f10 = f8 * f4 / 2.0f;
                f10 = -f11;
                bitmapView3.backgroundRect = new RectF(f10, 0.0f, f6 += f11, f5);
                bitmapView3.blurBitmap(bitmapView3.backgroundBitmap);
            }
        } else {
            RectF rectF;
            BitmapView bitmapView4 = bitmapView5;
            BitmapView bitmapView5 = rectF;
            rectF = new RectF(0.0f, 0.0f, f6, f5);
            bitmapView4.dest = bitmapView5;
        }
    }

    private void blurBitmap(Bitmap bitmap) {
        BitmapView bitmapView = RenderScript.create((Context)bitmapView.getContext());
        Allocation allocation = Allocation.createFromBitmap((RenderScript)bitmapView, (Bitmap)bitmap);
        ScriptIntrinsicBlur scriptIntrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)bitmapView, (Element)allocation.getElement());
        scriptIntrinsicBlur.setInput(allocation);
        scriptIntrinsicBlur.setRadius(20.0f);
        scriptIntrinsicBlur.forEach(allocation);
        allocation.copyTo(bitmap);
        bitmapView.destroy();
    }

    private void testData(Canvas canvas) {
        TextPaint textPaint;
        StringBuffer stringBuffer;
        Canvas canvas2 = canvas;
        canvas2.save();
        canvas2.translate(100.0f, 100.0f);
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer().append("path=").append(this.mAdData.mImgPath).append("\n");
        stringBuffer2.append("tid=").append(this.mAdData.data().optString("tid"));
        canvas = textPaint;
        textPaint = new TextPaint(this.paint);
        int n2 = this.mMaxWidth / 2;
        new StaticLayout((CharSequence)stringBuffer2.toString(), (TextPaint)canvas, n2, Layout.Alignment.ALIGN_CENTER, 0.0f, 0.0f, false).draw(canvas);
        canvas2.restore();
    }

    protected void onDraw(Canvas canvas) {
        Bitmap bitmap = bitmapView4.mDrawable;
        if (bitmap != null && !bitmap.isRecycled()) {
            Rect rect;
            BitmapView bitmapView = bitmapView4;
            bitmapView.drawBackgroundImage(canvas);
            bitmap = bitmapView.backgroundBitmap;
            if (bitmap != null) {
                BitmapView bitmapView2 = bitmapView4;
                rect = bitmapView2.src;
                RectF rectF = bitmapView2.backgroundRect;
                Paint paint = bitmapView2.paint;
                canvas.drawBitmap(bitmap, rect, rectF, paint);
            }
            Canvas canvas2 = canvas;
            BitmapView bitmapView3 = bitmapView4;
            BitmapView bitmapView4 = bitmapView3.mDrawable;
            canvas = bitmapView3.src;
            bitmap = bitmapView3.dest;
            rect = bitmapView3.paint;
            canvas2.drawBitmap((Bitmap)bitmapView4, (Rect)canvas, (RectF)bitmap, (Paint)rect);
        }
    }

    public int getBright(Bitmap bitmap) {
        Bitmap bitmap2 = bitmap;
        int n2 = bitmap2.getWidth();
        int n3 = bitmap2.getHeight();
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                int n6 = n5;
                ++n4;
                int n7 = bitmap.getPixel(i2, i3);
                n5 = (n7 | 0xFF00FFFF) >> 16 & 0xFF;
                int n8 = (n7 | 0xFFFF00FF) >> 8 & 0xFF;
                int n9 = (n7 | 0xFFFFFF00) & 0xFF;
                n5 = (int)((double)n6 + (double)n5 * 0.299 + (double)n8 * 0.587 + (double)n9 * 0.114);
            }
        }
        return n5 / n4;
    }

    protected void initRect() {
        float f2;
        float f3;
        float f4 = this.mDrawable.getWidth();
        BitmapView bitmapView = this;
        float f5 = bitmapView.mMaxHeight;
        float f6 = bitmapView.mMaxWidth;
        float f7 = (float)this.mDrawable.getHeight() / f4;
        f5 /= f6;
        if (f3 > f2) {
            BitmapView bitmapView2 = this;
            int n2 = (int)f4;
            int n3 = (int)(f4 * f5);
            bitmapView2.src = new Rect(0, 0, n2, n3);
            BitmapView bitmapView3 = this;
            float f8 = bitmapView3.getTop();
            float f9 = bitmapView3.mMaxWidth;
            float f10 = bitmapView3.mMaxHeight;
            bitmapView2.dest = new RectF((float)this.getLeft(), f8, f9, f10);
        } else {
            BitmapView bitmapView4 = this;
            bitmapView4.src = null;
            BitmapView bitmapView5 = this;
            float f11 = bitmapView5.getLeft();
            f4 = bitmapView5.getTop();
            f5 = bitmapView5.mMaxWidth;
            bitmapView4.dest = new RectF(f11, f4, f5, f6 *= f7);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.backgroundBitmap = null;
    }
}

