/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.view.View;
import com.dcloud.zxing2.ResultPoint;
import io.dcloud.feature.barcode2.decoding.IBarHandler;
import io.dcloud.feature.barcode2.view.DetectorViewConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public final class ViewfinderView
extends View {
    private static final long ANIMATION_DELAY = 100L;
    private static final int OPAQUE = 255;
    private final Paint paint;
    private Collection<ResultPoint> possibleResultPoints;
    private Collection<ResultPoint> lastPossibleResultPoints;
    IBarHandler barHandler = null;
    private Rect lastRect = null;
    ShapeDrawable laserBitmap = null;
    int laserY = -DetectorViewConfig.LASER_WIDTH;
    Timer mUpdateProgressBar = null;
    private boolean running = false;

    public ViewfinderView(Context context, IBarHandler iBarHandler) {
        super(context);
        this.barHandler = iBarHandler;
        this.paint = new Paint();
        this.getResources();
        this.possibleResultPoints = new HashSet<ResultPoint>(5);
    }

    private void drawResultPoint(Canvas canvas, Rect rect) {
        float f2;
        ViewfinderView viewfinderView = this;
        Iterator<ResultPoint> iterator = viewfinderView.possibleResultPoints;
        Object object = viewfinderView.lastPossibleResultPoints;
        if (iterator.isEmpty()) {
            this.lastPossibleResultPoints = null;
        } else {
            ViewfinderView viewfinderView2 = this;
            this.possibleResultPoints = new HashSet<ResultPoint>(5);
            viewfinderView2.lastPossibleResultPoints = iterator;
            viewfinderView2.paint.setAlpha(255);
            viewfinderView2.paint.setColor(DetectorViewConfig.resultPointColor);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Rect rect2 = rect;
                ResultPoint resultPoint = iterator.next();
                float f3 = (float)rect2.left + resultPoint.getX();
                f2 = (float)rect2.top + resultPoint.getY();
                Paint paint = this.paint;
                canvas.drawCircle(f3, f2, 6.0f, paint);
            }
        }
        if (object != null) {
            ViewfinderView viewfinderView3 = this;
            viewfinderView3.paint.setAlpha(127);
            viewfinderView3.paint.setColor(DetectorViewConfig.resultPointColor);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                Rect rect3 = rect;
                object = iterator.next();
                f2 = (float)rect3.left + ((ResultPoint)object).getX();
                float f4 = (float)rect3.top + ((ResultPoint)object).getY();
                Paint paint = this.paint;
                canvas.drawCircle(f2, f4, 3.0f, paint);
            }
        }
    }

    private void drawLaserLine(Canvas canvas, Rect rect) {
        if (this.laserBitmap == null) {
            RadialGradient radialGradient;
            this.laserBitmap = new ShapeDrawable((Shape)new OvalShape());
            RadialGradient radialGradient2 = radialGradient;
            int n2 = DetectorViewConfig.laserColor;
            int n3 = n2 & 0xFFFFFF;
            Shader.TileMode tileMode = Shader.TileMode.CLAMP;
            radialGradient = new RadialGradient((float)(rect.width() / 2), (float)(DetectorViewConfig.LASER_WIDTH / 2), 240.0f, n2, n3, tileMode);
            this.laserBitmap.getPaint().setShader((Shader)radialGradient2);
        }
        ViewfinderView viewfinderView = this;
        viewfinderView.paint.setAntiAlias(true);
        int n4 = rect.left;
        int n5 = this.laserY;
        int n6 = n4 + rect.width();
        int n7 = this.laserY + DetectorViewConfig.LASER_WIDTH;
        viewfinderView.laserBitmap.setBounds(n4, n5, n6, n7);
        viewfinderView.laserBitmap.draw(canvas);
        viewfinderView.paint.setShader(null);
    }

    private void updateScreen() {
        Rect rect = DetectorViewConfig.getInstance().getDetectorRect();
        int n2 = this.laserY;
        this.laserY = n2 > rect.bottom ? rect.top : n2 + 1;
        this.postInvalidate();
    }

    private void drawNonDetectorArea(Canvas canvas, Rect rect, Rect rect2) {
        Rect rect3 = rect2;
        Rect rect4 = rect;
        Rect rect5 = rect;
        Rect rect6 = rect2;
        Rect rect7 = rect;
        Rect rect8 = rect;
        this.paint.setColor(DetectorViewConfig.maskColor);
        float f2 = rect2.right;
        float f3 = rect.top;
        rect = this.paint;
        canvas.drawRect(0.0f, 0.0f, f2, f3, (Paint)rect);
        f2 = rect8.top;
        f3 = rect8.left;
        float f4 = rect8.bottom;
        rect2 = this.paint;
        canvas.drawRect(0.0f, f2, f3, f4, (Paint)rect2);
        f2 = rect7.right;
        f3 = rect7.top;
        f4 = rect6.right;
        float f5 = rect5.bottom;
        Paint paint = this.paint;
        canvas.drawRect(f2, f3, f4, f5, paint);
        f2 = rect4.bottom;
        f3 = rect3.right;
        f4 = rect3.bottom;
        Paint paint2 = this.paint;
        canvas.drawRect(0.0f, f2, f3, f4, paint2);
    }

    private void drawDetectorCorner(Canvas canvas, Rect rect) {
        Rect rect2 = rect;
        Rect rect3 = rect;
        Rect rect4 = rect;
        Rect rect5 = rect;
        Rect rect6 = rect;
        Rect rect7 = rect;
        Rect rect8 = rect;
        Rect rect9 = rect;
        this.paint.setColor(DetectorViewConfig.cornerColor);
        int n2 = DetectorViewConfig.CORNER_WIDTH / 2;
        int n3 = DetectorViewConfig.CORNER_HEIGHT;
        int n4 = rect9.left;
        float f2 = n4 - n2;
        int n5 = rect9.top;
        float f3 = n5 - n2;
        float f4 = n4 + n3;
        float f5 = n5 + n2;
        Paint paint = this.paint;
        canvas.drawRect(f2, f3, f4, f5, paint);
        int n6 = rect8.left;
        f2 = n6 - n2;
        int n7 = rect8.top;
        float f6 = n7;
        float f7 = n6 + n2;
        f5 = n7 + n3;
        paint = this.paint;
        canvas.drawRect(f2, f6, f7, f5, paint);
        int n8 = rect7.right;
        f2 = n8 - n3;
        int n9 = rect7.top;
        float f8 = n9 - n2;
        float f9 = n8 + n2;
        f5 = n9 + n2;
        paint = this.paint;
        canvas.drawRect(f2, f8, f9, f5, paint);
        int n10 = rect6.right;
        f2 = n10 - n2;
        int n11 = rect6.top;
        float f10 = n11;
        float f11 = n10 + n2;
        f5 = n11 + n3;
        paint = this.paint;
        canvas.drawRect(f2, f10, f11, f5, paint);
        int n12 = rect5.left;
        f2 = n12 - n2;
        int n13 = rect5.bottom;
        float f12 = n13 - n3;
        float f13 = n12 + n2;
        f5 = n13;
        paint = this.paint;
        canvas.drawRect(f2, f12, f13, f5, paint);
        int n14 = rect4.left;
        f2 = n14 - n2;
        int n15 = rect4.bottom;
        float f14 = n15 - n2;
        float f15 = n14 + n3;
        f5 = n15 + n2;
        paint = this.paint;
        canvas.drawRect(f2, f14, f15, f5, paint);
        int n16 = rect3.right;
        f2 = n16 - n3;
        int n17 = rect3.bottom;
        float f16 = n17 - n2;
        float f17 = n16 + n2;
        f5 = n17 + n2;
        paint = this.paint;
        canvas.drawRect(f2, f16, f17, f5, paint);
        int n18 = rect2.right;
        f2 = n18 - n2;
        int n19 = rect2.bottom;
        float f18 = n19 - n3;
        float f19 = n18 + n2;
        float f20 = n19 + n2;
        Paint paint2 = this.paint;
        canvas.drawRect(f2, f18, f19, f20, paint2);
    }

    public void onDraw(Canvas canvas) {
        Rect rect = DetectorViewConfig.getInstance().getDetectorRect();
        Rect rect2 = DetectorViewConfig.getInstance().gatherRect;
        if (rect == null) {
            return;
        }
        ViewfinderView viewfinderView = this;
        this.drawNonDetectorArea(canvas, rect, rect2);
        viewfinderView.drawDetectorCorner(canvas, rect);
        if (viewfinderView.running) {
            this.drawLaserLine(canvas, rect);
        } else {
            this.lastRect = rect;
            if (rect != null) {
                this.drawLaserLine(canvas, rect);
            }
        }
    }

    public void stopUpdateScreenTimer() {
        if (this.running) {
            Timer timer = this.mUpdateProgressBar;
            if (timer != null) {
                timer.cancel();
                this.mUpdateProgressBar = null;
            }
            this.running = false;
            this.updateScreen();
        }
    }

    public void startUpdateScreenTimer() {
        if (!this.running) {
            this.stopUpdateScreenTimer();
            this.laserY = DetectorViewConfig.getInstance().getDetectorRect().top;
            this.mUpdateProgressBar = new Timer();
            this.mUpdateProgressBar.schedule(new TimerTask(){

                @Override
                public void run() {
                    ViewfinderView.this.updateScreen();
                }
            }, 0L, 10L);
            this.running = true;
        }
    }

    public void drawViewfinder() {
        this.invalidate();
    }

    public void addPossibleResultPoint(ResultPoint resultPoint) {
        this.possibleResultPoints.add(resultPoint);
    }
}

