/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.decoding;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.media.ThumbnailUtils;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.ResultPointCallback;
import io.dcloud.feature.barcode2.camera.CameraManager;
import io.dcloud.feature.barcode2.decoding.DecodeHandler;
import io.dcloud.feature.barcode2.decoding.DecodeThread;
import io.dcloud.feature.barcode2.decoding.IBarHandler;
import io.dcloud.feature.barcode2.view.ViewfinderResultPointCallback;
import java.util.ArrayList;
import java.util.Vector;

public final class CaptureActivityHandler
extends Handler {
    private static final String TAG = CaptureActivityHandler.class.getSimpleName();
    public static final int CODE_AUTO_FOCUS = 1000;
    public static final int CODE_DECODE_FAILED = 1001;
    public static final int CODE_DECODE_SUCCEEDED = 1002;
    public static final int CODE_QUIT = 1003;
    public static final int CODE_DECODE = 1004;
    public static final int CODE_DECODE_NEED_ZOOM = 1010;
    public static final int CODE_DECODE_portrait = 1005;
    public static final int CODE_DECODE_landscape = 1006;
    private final IBarHandler activity;
    private final DecodeThread decodeThread;
    private State state;

    public CaptureActivityHandler(IBarHandler iBarHandler, Vector<BarcodeFormat> vector, String string2, boolean bl) {
        CaptureActivityHandler captureActivityHandler;
        ViewfinderResultPointCallback viewfinderResultPointCallback;
        object.activity = iBarHandler;
        Object object = viewfinderResultPointCallback;
        viewfinderResultPointCallback = new ViewfinderResultPointCallback(iBarHandler.getViewfinderView());
        object.decodeThread = new DecodeThread(iBarHandler, vector, string2, (ResultPointCallback)object, bl);
        object.decodeThread.start();
        captureActivityHandler.state = State.SUCCESS;
        captureActivityHandler.resume();
    }

    public static Result decode(Bitmap bitmap, boolean bl) {
        Result result = DecodeHandler.decode(bitmap, bl);
        if (result != null) {
            return result;
        }
        result = CaptureActivityHandler.trySmallerBitmap(bitmap, true, bl);
        if (result != null) {
            return result;
        }
        return CaptureActivityHandler.tryBiggerBitmap(bitmap, bl);
    }

    public static Result tryBiggerBitmap(Bitmap bitmap, boolean bl) {
        Bitmap bitmap2;
        if (bitmap == null) {
            return null;
        }
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        if (n2 < 1200 && n3 < 1200) {
            Paint paint;
            bitmap2 = Bitmap.createBitmap((int)(n2 + 200), (int)(n3 + 200), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap2);
            canvas.drawColor(-1);
            bitmap = paint;
            paint = new Paint();
            canvas.drawBitmap(bitmap, 100.0f, 100.0f, (Paint)bitmap);
        } else {
            bitmap2 = bitmap;
        }
        Bitmap bitmap3 = bitmap2;
        int n4 = bitmap3.getWidth();
        return DecodeHandler.decode(CaptureActivityHandler.convertToBMW(bitmap3, n4, bitmap3.getHeight(), 180), bl);
    }

    public static Bitmap convertToBMW(Bitmap bitmap, int n2, int n3, int n4) {
        Bitmap bitmap2 = bitmap;
        int n5 = bitmap2.getWidth();
        int n6 = bitmap.getHeight();
        int[] nArray = new int[n5 * n6];
        bitmap2.getPixels(nArray, 0, n5, 0, 0, n5, n6);
        for (int i2 = 0; i2 < n6; ++i2) {
            for (int i3 = 0; i3 < n5; ++i3) {
                int n7 = n5 * i2 + i3;
                int n8 = nArray[n7];
                int n9 = n8;
                int n10 = (n8 & 0xFF000000) >> 24;
                int n11 = n9;
                n9 = (n11 & 0xFF00) >> 8;
                int n12 = n11 & 0xFF;
                int n13 = (n8 & 0xFF0000) >> 16 > n4 ? 255 : 0;
                n12 = n12 > n4 ? 255 : 0;
                n9 = n9 > n4 ? 255 : 0;
                nArray[n7] = n10 << 24 | n13 << 16 | n9 << 8 | n12;
                nArray[n7] = nArray[n7] == -1 ? -1 : -16777216;
            }
        }
        Bitmap bitmap3 = Bitmap.createBitmap((int)n5, (int)n6, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap3.setPixels(nArray, 0, n5, 0, 0, n5, n6);
        return ThumbnailUtils.extractThumbnail((Bitmap)bitmap3, (int)n2, (int)n3);
    }

    public static Result trySmallerBitmap(Bitmap bitmap, boolean n2, boolean bl) {
        if (bitmap == null) {
            return null;
        }
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        if (n3 >= 200 && n4 >= 200) {
            Object object;
            Bitmap bitmap2;
            Object object2;
            Object object3;
            ArrayList arrayList;
            Bitmap bitmap3;
            boolean bl2 = n3 <= n4;
            if (bl2) {
                int n5 = n4 / 2;
                bitmap3 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n3, (int)n5);
            } else {
                int n6 = n3 / 2;
                bitmap3 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n6, (int)n4);
            }
            int n7 = 0;
            final ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            if (n2 != 0) {
                ResultPointCallback resultPointCallback;
                object3 = resultPointCallback;
                resultPointCallback = new ResultPointCallback(){

                    @Override
                    public void foundPossibleResultPoint(ResultPoint resultPoint) {
                        arrayList2.add(resultPoint);
                    }
                };
                object3 = DecodeHandler.decode(bitmap3, (ResultPointCallback)object3, bl);
            } else {
                object3 = DecodeHandler.decode(bitmap3, bl);
            }
            if (object3 != null) {
                return object3;
            }
            if (n2 != 0) {
                ArrayList arrayList3 = arrayList2;
                n7 = arrayList3.size();
                arrayList3.clear();
            }
            if (bl2) {
                int n8 = n4 / 2;
                object3 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)n8, (int)n3, (int)n8);
            } else {
                int n9 = n3 / 2;
                object3 = Bitmap.createBitmap((Bitmap)bitmap, (int)n9, (int)0, (int)n9, (int)n4);
            }
            int n10 = 0;
            if (n2 != 0) {
                ResultPointCallback resultPointCallback;
                object2 = resultPointCallback;
                resultPointCallback = new ResultPointCallback(){

                    @Override
                    public void foundPossibleResultPoint(ResultPoint resultPoint) {
                        arrayList2.add(resultPoint);
                    }
                };
                object2 = DecodeHandler.decode((Bitmap)object3, (ResultPointCallback)object2, bl);
            } else {
                object2 = DecodeHandler.decode((Bitmap)object3, bl);
            }
            if (object2 != null) {
                return object2;
            }
            if (n2 != 0) {
                ArrayList arrayList4 = arrayList2;
                n10 = arrayList4.size();
                arrayList4.clear();
            }
            if (bl2) {
                int n11 = n4;
                int n12 = n11 / 8;
                n4 = n11 / 4 * 3;
                bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)n12, (int)n3, (int)n4);
            } else {
                int n13 = n3;
                int n14 = n13 / 8;
                n3 = n13 / 4 * 3;
                bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)n14, (int)0, (int)n3, (int)n4);
            }
            if (n2 != 0) {
                ResultPointCallback resultPointCallback;
                object = resultPointCallback;
                resultPointCallback = new ResultPointCallback(){

                    @Override
                    public void foundPossibleResultPoint(ResultPoint resultPoint) {
                        arrayList2.add(resultPoint);
                    }
                };
                object = DecodeHandler.decode(bitmap2, (ResultPointCallback)object, bl);
            } else {
                object = DecodeHandler.decode(bitmap2, bl);
            }
            if (object != null) {
                return object;
            }
            if (n2 != 0) {
                ArrayList arrayList5 = arrayList2;
                n2 = arrayList5.size();
                arrayList5.clear();
                if (n7 > n2 && n7 > n10) {
                    return CaptureActivityHandler.trySmallerBitmap(bitmap3, false, bl);
                }
                if (n2 > n10 && n2 > n7) {
                    return CaptureActivityHandler.trySmallerBitmap(bitmap2, false, bl);
                }
                if (n10 > n2 && n10 > n7) {
                    return CaptureActivityHandler.trySmallerBitmap((Bitmap)object3, false, bl);
                }
            }
            return null;
        }
        return null;
    }

    public void resume() {
        CaptureActivityHandler captureActivityHandler = this;
        CameraManager.get().startPreview();
        captureActivityHandler.activity.drawViewfinder();
        captureActivityHandler.restartPreviewAndDecode();
    }

    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                break;
            }
            case 1002: {
                Log.d((String)TAG, (String)"Got decode succeeded message");
                this.state = State.SUCCESS;
                Object object = message.getData();
                object = object == null ? null : (Bitmap)object.getParcelable("barcode_bitmap");
                this.activity.handleDecode((Result)message.obj, (Bitmap)object);
                if (object == null) break;
                object.recycle();
                System.out.println("barcode.recycle");
                break;
            }
            case 1001: {
                Log.d((String)TAG, (String)"CODE_DECODE_FAILED");
                this.state = State.PREVIEW;
                CameraManager.get().requestPreviewFrame(this.activity, this.decodeThread.getHandler(), 1004);
                break;
            }
            case 1000: {
                Log.d((String)TAG, (String)"Got auto-focus message");
                if (this.state != State.PREVIEW) break;
                CameraManager.get().requestAutoFocus(this, 1000);
            }
        }
    }

    public void quitSynchronously() {
        CaptureActivityHandler captureActivityHandler = this;
        captureActivityHandler.state = State.DONE;
        CameraManager.get().stopPreview();
        Message.obtain((Handler)captureActivityHandler.decodeThread.getHandler(), (int)1003).sendToTarget();
        try {
            captureActivityHandler.decodeThread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.stopDecode();
    }

    public void restartPreviewAndDecode() {
        if (this.state == State.SUCCESS) {
            this.state = State.PREVIEW;
            CameraManager.get().requestPreviewFrame(this.activity, this.decodeThread.getHandler(), 1004);
            this.autoFocus();
        }
    }

    public void autoFocus() {
        CameraManager.get().requestAutoFocus(this, 1000);
    }

    public void stopDecode() {
        CaptureActivityHandler captureActivityHandler = this;
        captureActivityHandler.removeMessages(1002);
        captureActivityHandler.removeMessages(1001);
        CameraManager.get().removeAutoFocus();
        captureActivityHandler.state = State.SUCCESS;
    }

    private static final class State
    extends Enum<State> {
        public static final /* enum */ State PREVIEW;
        public static final /* enum */ State SUCCESS;
        public static final /* enum */ State DONE;
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        static {
            State state;
            State state2;
            State state3;
            State state4 = state3;
            PREVIEW = new State();
            State state5 = state2;
            SUCCESS = new State();
            State state6 = state;
            DONE = new State();
            $VALUES = new State[]{state4, state5, state6};
        }
    }
}

