/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.camera;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import io.dcloud.feature.barcode2.camera.AutoFocusCallback;
import io.dcloud.feature.barcode2.camera.CameraConfigurationManager;
import io.dcloud.feature.barcode2.camera.FlashlightManager;
import io.dcloud.feature.barcode2.camera.PlanarYUVLuminanceSource;
import io.dcloud.feature.barcode2.camera.PreviewCallback;
import io.dcloud.feature.barcode2.decoding.IBarHandler;
import io.dcloud.feature.barcode2.view.DetectorViewConfig;
import java.io.IOException;

public final class CameraManager {
    private static final String TAG = "CameraManager";
    private static final int MIN_FRAME_WIDTH = 240;
    private static final int MIN_FRAME_HEIGHT = 240;
    private static final int MAX_FRAME_WIDTH = 640;
    private static final int MAX_FRAME_HEIGHT = 640;
    private static CameraManager cameraManager;
    public static int sScreenWidth;
    public static int sScreenAllHeight;
    static final int SDK_INT;
    private static boolean mIsVerticalScreen;
    private static Camera.Parameters parameters;
    private final Context context;
    private final CameraConfigurationManager configManager;
    private Camera camera;
    private Rect framingRect;
    private boolean initialized;
    private boolean previewing;
    private boolean useOneShotPreviewCallback;
    private final PreviewCallback previewCallback;
    private final AutoFocusCallback autoFocusCallback;
    private boolean horizontalOrientation;

    public static void init(Context context) {
        if (cameraManager == null) {
            cameraManager = new CameraManager(context);
        }
    }

    public static void init(Context context, boolean bl) {
        mIsVerticalScreen = bl;
        CameraManager.init(context);
    }

    public static CameraManager get() {
        return cameraManager;
    }

    private CameraManager(Context context) {
        AutoFocusCallback autoFocusCallback;
        PreviewCallback previewCallback;
        CameraConfigurationManager cameraConfigurationManager;
        CameraManager cameraManager = autoFocusCallback2;
        ((CameraManager)((Object)autoFocusCallback2)).horizontalOrientation = false;
        cameraManager.context = context;
        CameraConfigurationManager cameraConfigurationManager2 = cameraConfigurationManager;
        cameraManager.configManager = new CameraConfigurationManager(context);
        boolean bl = Integer.parseInt(Build.VERSION.SDK) > 3;
        CameraManager cameraManager2 = autoFocusCallback2;
        cameraManager2.useOneShotPreviewCallback = bl;
        PreviewCallback previewCallback2 = previewCallback;
        previewCallback = new PreviewCallback(cameraConfigurationManager2, ((CameraManager)((Object)autoFocusCallback2)).useOneShotPreviewCallback);
        cameraManager2.previewCallback = previewCallback2;
        cameraManager2.useOneShotPreviewCallback = false;
        AutoFocusCallback autoFocusCallback2 = autoFocusCallback;
        autoFocusCallback = new AutoFocusCallback();
        cameraManager2.autoFocusCallback = autoFocusCallback2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Point getCR(int n2, int n3) {
        Point point;
        Camera camera;
        Point point2 = null;
        Camera camera2 = null;
        try {
            camera2 = Camera.open();
            if (parameters == null) {
                parameters = camera2.getParameters();
            }
            camera = camera2;
        }
        catch (Exception exception) {
            Point point3;
            Point point4 = point3;
            point3 = new Point(n2, n3);
            Camera.Parameters parameters = CameraManager.parameters;
            if (parameters != null) {
                point2 = CameraConfigurationManager.getCameraResolution(parameters, point4);
            } else if (camera2 != null) {
                try {
                    Camera camera3 = camera2;
                    CameraManager.parameters = camera3.getParameters();
                    point2 = CameraConfigurationManager.getCameraResolution(CameraManager.parameters, point4);
                    camera3.release();
                    camera2 = null;
                }
                catch (Exception exception2) {}
            }
            if (camera2 != null) {
                camera2.release();
            }
            exception.printStackTrace();
            return point2;
        }
        Point point5 = point;
        {
            point = new Point(n2, n3);
            point2 = CameraConfigurationManager.getCameraResolution(parameters, point5);
            camera.release();
            return point2;
        }
    }

    static {
        int n2;
        try {
            n2 = Integer.parseInt(Build.VERSION.SDK);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 10000;
        }
        SDK_INT = n2;
        mIsVerticalScreen = true;
        parameters = null;
    }

    public void setHorizontalOrientation(boolean bl) {
        this.horizontalOrientation = bl;
    }

    public byte[] getLastBitmapData() {
        PreviewCallback previewCallback = ((CameraManager)((Object)previewCallback)).previewCallback;
        if (previewCallback == null) {
            return null;
        }
        return previewCallback.getLastBitmapData();
    }

    public void clearLastBitmapData() {
        PreviewCallback previewCallback = ((CameraManager)((Object)previewCallback)).previewCallback;
        if (previewCallback != null) {
            previewCallback.setLastBitmapData(null);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void openDriver(SurfaceTexture surfaceTexture) throws IOException, RuntimeException {
        Camera camera;
        if (this.camera != null) return;
        try {
            camera = Camera.open();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        {
            this.camera = camera;
            if (camera == null) throw new IOException();
            camera.setPreviewTexture(surfaceTexture);
            if (mIsVerticalScreen) {
                this.camera.setDisplayOrientation(90);
            } else {
                CameraManager cameraManager = this;
                surfaceTexture = cameraManager.camera;
                int n2 = cameraManager.horizontalOrientation ? 180 : 0;
                surfaceTexture.setDisplayOrientation(n2);
            }
            CameraManager cameraManager = this;
            cameraManager.configManager.initFromCameraParameters(this.camera);
            cameraManager.configManager.setDesiredCameraParameters(this.camera);
            return;
        }
    }

    public void setFlashlight(boolean bl) {
        if (bl) {
            FlashlightManager.enableFlashlight();
        } else {
            FlashlightManager.disableFlashlight();
        }
    }

    public Camera getCameraHandler() {
        return this.camera;
    }

    public void closeDriver() {
        if (this.camera != null) {
            CameraManager cameraManager = this;
            FlashlightManager.disableFlashlight();
            cameraManager.camera.setPreviewCallback(null);
            cameraManager.camera.release();
            cameraManager.camera = null;
        }
    }

    public void startPreview() {
        block4: {
            Camera camera;
            try {
                camera = this.camera;
                if (camera == null) break block4;
            }
            catch (Exception exception) {}
            if (this.previewing) break block4;
            camera.startPreview();
            this.previewing = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopPreview() {
        try {
            Camera camera = this.camera;
            if (camera == null) return;
            if (!this.previewing) return;
            if (!this.useOneShotPreviewCallback) {
                camera.setPreviewCallback(null);
            }
            CameraManager cameraManager = this;
            cameraManager.camera.stopPreview();
            cameraManager.previewCallback.setHandler(null, null, 0, mIsVerticalScreen);
            cameraManager.autoFocusCallback.setHandler(null, 0);
            cameraManager.previewing = false;
            return;
        }
        catch (Exception exception) {}
    }

    public void requestPreviewFrame(IBarHandler iBarHandler, Handler handler, int n2) {
        if (this.camera != null && this.previewing) {
            CameraManager cameraManager = this;
            boolean bl = mIsVerticalScreen;
            cameraManager.previewCallback.setHandler(iBarHandler, handler, n2, bl);
            if (cameraManager.useOneShotPreviewCallback) {
                this.camera.setOneShotPreviewCallback((Camera.PreviewCallback)this.previewCallback);
            } else {
                this.camera.setPreviewCallback((Camera.PreviewCallback)this.previewCallback);
            }
        }
    }

    public void requestAutoFocus(Handler handler, int n2) {
        if (this.camera != null && this.previewing) {
            CameraManager cameraManager = this;
            cameraManager.autoFocusCallback.setHandler(handler, n2);
            try {
                cameraManager.camera.autoFocus((Camera.AutoFocusCallback)this.autoFocusCallback);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void removeAutoFocus() {
        CameraManager cameraManager = cameraManager.camera;
        if (cameraManager != null) {
            cameraManager.cancelAutoFocus();
        }
    }

    public Rect getFramingRectInPreview() {
        return mIsVerticalScreen ? this.getPortraitFramingRectInPreview() : this.getLandscapeFramingRectInPreview();
    }

    public Rect getPortraitFramingRectInPreview() {
        CameraManager cameraManager = cameraManager.configManager.getCameraResolution();
        Rect rect = DetectorViewConfig.getInstance().getDetectorRect();
        Rect rect2 = DetectorViewConfig.getInstance().surfaceViewRect;
        int cfr_ignored_0 = rect2.width() / ((Point)cameraManager).y;
        int n2 = (rect.top - DetectorViewConfig.detectorRectOffestTop) * ((Point)cameraManager).x / rect2.height();
        int n3 = n2 + rect.height() * ((Point)cameraManager).x / rect2.height();
        int n4 = (rect2.right - rect.right) * ((Point)cameraManager).y / rect2.width();
        int n5 = n4 + rect.width() * ((Point)cameraManager).x / rect2.height();
        return new Rect(n2, n4, n3, n5);
    }

    public Rect getLandscapeFramingRectInPreview() {
        CameraManager cameraManager = cameraManager.configManager.getCameraResolution();
        Rect rect = DetectorViewConfig.getInstance().getDetectorRect();
        Rect rect2 = DetectorViewConfig.getInstance().surfaceViewRect;
        int cfr_ignored_0 = rect2.width() / ((Point)cameraManager).y;
        int n2 = (rect.left - DetectorViewConfig.detectorRectOffestLeft) * ((Point)cameraManager).x / rect2.width();
        int n3 = n2 + rect.height() * ((Point)cameraManager).y / rect2.height();
        int n4 = (rect2.bottom - rect.bottom) * ((Point)cameraManager).y / rect2.height();
        int n5 = n4 + rect.width() * ((Point)cameraManager).y / rect2.height();
        return new Rect(n2, n4, n3, n5);
    }

    public PlanarYUVLuminanceSource buildLuminanceSource(byte[] byArray, int n2, int n3) {
        CameraManager cameraManager = string2;
        Rect rect = cameraManager.getFramingRectInPreview();
        int n4 = cameraManager.configManager.getPreviewFormat();
        String string2 = ((CameraManager)((Object)string2)).configManager.getPreviewFormatString();
        if (n4 != 16 && n4 != 17) {
            if ("yuv420p".equals(string2)) {
                Rect rect2 = rect;
                int n5 = rect2.left;
                int n6 = rect2.top;
                n4 = rect2.width();
                int n7 = rect2.height();
                return new PlanarYUVLuminanceSource(byArray, n2, n3, n5, n6, n4, n7);
            }
            throw new IllegalArgumentException("Unsupported picture format: " + n4 + '/' + (String)string2);
        }
        Rect rect3 = rect;
        int n8 = rect3.left;
        int n9 = rect3.top;
        n4 = rect3.width();
        int n10 = rect3.height();
        return new PlanarYUVLuminanceSource(byArray, n2, n3, n8, n9, n4, n10);
    }

    public AutoFocusCallback getAutoFocusCallback() {
        return this.autoFocusCallback;
    }
}

