/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.audio.recorder;

import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.audio.AudioRecorderMgr;
import org.json.JSONObject;

public class RecordOption {
    public String mFileName;
    public int mSamplingRate;
    public String mFormat;
    public IWebview mWebview;
    public boolean isRateDeft;

    public RecordOption(IWebview object, JSONObject jSONObject) {
        String string2;
        JSONObject jSONObject2 = jSONObject;
        this.isRateDeft = false;
        this.mWebview = object;
        object = JSONUtil.getString(jSONObject2, "samplerate");
        this.mFormat = string2 = JSONUtil.getString(jSONObject2, "format");
        if (PdrUtil.isEmpty(string2)) {
            this.mFormat = "amr";
        }
        int n2 = 8000;
        if (AudioRecorderMgr.isPause(this.mFormat)) {
            n2 = 44100;
        }
        if (!PdrUtil.isEmpty(object)) {
            this.isRateDeft = false;
            this.mSamplingRate = PdrUtil.parseInt(JSONUtil.getString(jSONObject, "samplerate"), n2);
        } else {
            RecordOption recordOption = this;
            recordOption.isRateDeft = true;
            recordOption.mSamplingRate = n2;
        }
        object = PdrUtil.getDefaultPrivateDocPath(JSONUtil.getString(jSONObject, "filename"), this.mFormat);
        this.mFileName = this.mWebview.obtainFrameView().obtainApp().convert2AbsFullPath(this.mWebview.obtainFullUrl(), (String)object);
    }
}

