/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.util.net;

import android.content.BroadcastReceiver;
import android.content.IntentFilter;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.ICore;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.net.DownloadMgr;
import io.dcloud.common.util.net.NetCheckReceiver;
import io.dcloud.common.util.net.UploadMgr;
import io.dcloud.common.util.net.http.IServer;

public class NetMgr
extends AbsMgr
implements IMgr.NetEvent {
    DownloadMgr mDownloadMgr;
    UploadMgr mUploadMgr;
    NetCheckReceiver mNetCheckReceiver;
    IServer mLocalServer;

    public NetMgr(ICore iCore) {
        IntentFilter intentFilter;
        NetMgr netMgr = this;
        super(iCore, "netmgr", IMgr.MgrType.NetMgr);
        netMgr.mNetCheckReceiver = null;
        netMgr.mLocalServer = null;
        netMgr.startMiniServer();
        netMgr.mUploadMgr = UploadMgr.getUploadMgr();
        netMgr.mDownloadMgr = DownloadMgr.getDownloadMgr();
        netMgr.mNetCheckReceiver = new NetCheckReceiver(this);
        iCore = intentFilter;
        new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE").addAction("android.intent.action.SIM_STATE_CHANGED");
        netMgr.getContext().registerReceiver((BroadcastReceiver)this.mNetCheckReceiver, (IntentFilter)iCore);
    }

    private IServer initLocalServer() {
        if (BaseInfo.SyncDebug) {
            Class[] classArray = new Class[2];
            Class[] classArray2 = classArray;
            classArray[0] = AbsMgr.class;
            classArray[1] = Integer.TYPE;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            objectArray[1] = 13131;
            Object object = PlatformUtil.newInstance("io.dcloud.common.util.net.http.LocalServer", classArray2, objectArray2);
            if (object != null && object instanceof IServer) {
                return (IServer)object;
            }
        }
        return null;
    }

    protected void startMiniServer() {
        IServer iServer;
        if (!BaseInfo.ISDEBUG) {
            return;
        }
        this.mLocalServer = iServer = this.initLocalServer();
        if (iServer != null) {
            iServer.start();
        }
    }

    @Override
    public Object processEvent(IMgr.MgrType mgrType, int n2, Object object) {
        Object object2;
        block3: {
            object2 = null;
            if (this.checkMgrId(mgrType)) break block3;
            try {
                object2 = this.mCore.dispatchEvent(mgrType, n2, object);
            }
            catch (Throwable throwable) {
                Logger.w("NetMgr.processEvent", throwable);
            }
        }
        return object2;
    }

    @Override
    public void onExecute(ISysEventListener.SysEventType object, Object object2) {
        if (object == ISysEventListener.SysEventType.onPause) {
            object = this.mLocalServer;
            if (object != null) {
                object.stop();
                this.mLocalServer = null;
            }
        } else if (object == ISysEventListener.SysEventType.onResume && this.mLocalServer == null) {
            if (!BaseInfo.ISDEBUG) {
                return;
            }
            this.mLocalServer = object = this.initLocalServer();
            if (object != null) {
                object.start();
            }
        }
    }

    @Override
    public void dispose() {
        Object object = this.mLocalServer;
        if (object != null) {
            object.stop();
        }
        if ((object = this.mUploadMgr) != null) {
            ((UploadMgr)object).dispose();
        }
        this.getContext().unregisterReceiver((BroadcastReceiver)this.mNetCheckReceiver);
    }
}

