/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.util.language;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.alibaba.fastjson.JSONObject;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.util.PdrUtil;
import java.util.Locale;

public class LanguageUtil {
    public static final String LanguageConfigSPFile = "language_uni_sp_file";
    public static final String LanguageConfigKey = "language_uni_current_key";
    public static final String LanguageBroadCastIntent = "language_uni_broad_cast_intent";
    private static String sCurrentLocalLanguage = "";
    private static String deviceDefLocalLanguage = "";

    public static String getDeviceDefLocalLanguage() {
        return deviceDefLocalLanguage;
    }

    public static void updateDeviceDefLocalLanguage(Locale locale) {
        if (locale != null) {
            DeviceInfo.sLanguage = deviceDefLocalLanguage = locale.getLanguage() + "-" + locale.getCountry();
        }
    }

    public static void updateDeviceDefLocalLanguage(Context context) {
        LanguageUtil.updateDeviceDefLocalLanguage(LanguageUtil.getCurrentLocal(context, true));
    }

    private static void updateAppBootLanguage(Context context) {
        Context context2 = context;
        String string2 = context2.getSharedPreferences(LanguageConfigSPFile, 0).getString(LanguageConfigKey, "");
        String string3 = "";
        try {
            string3 = context2.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData.getString("DCLOUD_APP_DEFAULT_LANGUAGE");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
            string3 = string2;
        }
        if ("auto".equalsIgnoreCase(string3)) {
            string3 = "";
        }
        sCurrentLocalLanguage = string3;
        LanguageUtil.updateDeviceDefLocalLanguage(context);
    }

    public static Context updateContextLanguageAfterO(Context context, boolean bl) {
        return LanguageUtil.updateContextLanguageAfterO(context, bl, true);
    }

    public static Context updateContextLanguageAfterO(Context context, boolean bl, boolean bl2) {
        if (bl) {
            LanguageUtil.updateAppBootLanguage(context);
        }
        if (TextUtils.isEmpty((CharSequence)sCurrentLocalLanguage)) {
            return context;
        }
        return LanguageUtil.wrapContextConfigurationAfterO(context, sCurrentLocalLanguage, bl2);
    }

    public static Context wrapContextConfigurationAfterO(Context context, String string2) {
        return LanguageUtil.wrapContextConfigurationAfterO(context, string2, true);
    }

    public static Context wrapContextConfigurationAfterO(Context context, String string2, boolean bl) {
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList localeList;
            Resources resources = context.getResources();
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            Configuration configuration = resources.getConfiguration();
            LocaleList localeList2 = localeList;
            Locale[] localeArray = new Locale[1];
            Locale[] localeArray2 = localeArray;
            localeArray[0] = Locale.forLanguageTag(string2);
            LocaleList.setDefault((LocaleList)new LocaleList(localeArray2));
            configuration.setLocales(localeList2);
            resources.updateConfiguration(configuration, displayMetrics);
            if (bl) {
                return context.createConfigurationContext(configuration);
            }
        }
        return context;
    }

    public static void initAppLanguageForAppBeforeO(Context context) {
        Context context2 = context;
        LanguageUtil.updateAppBootLanguage(context2);
        LanguageUtil.updateSystemLanguage(context2);
    }

    public static void updateSystemLanguage(Context object) {
        int n2;
        if (object == null) {
            return;
        }
        String string2 = sCurrentLocalLanguage;
        if (!"zh-Hant-TW".equals(string2) && !"zh-Hant".equals(string2)) {
            if ("zh-Hant-HK".equals(string2)) {
                string2 = "zh-HK";
            }
        } else {
            string2 = "zh-TW";
        }
        if ((n2 = Build.VERSION.SDK_INT) >= 24) {
            LocaleList localeList;
            object = object.getResources();
            DisplayMetrics displayMetrics = object.getDisplayMetrics();
            Configuration configuration = object.getConfiguration();
            if (TextUtils.isEmpty((CharSequence)string2)) {
                string2 = deviceDefLocalLanguage;
            }
            Context context = object;
            object = localeList;
            Locale[] localeArray = new Locale[1];
            Locale[] localeArray2 = localeArray;
            localeArray[0] = Locale.forLanguageTag(string2);
            LocaleList.setDefault((LocaleList)new LocaleList(localeArray2));
            configuration.setLocales((LocaleList)object);
            context.updateConfiguration(configuration, displayMetrics);
        } else if (n2 >= 21) {
            object = object.getResources();
            if (TextUtils.isEmpty((CharSequence)string2)) {
                string2 = deviceDefLocalLanguage;
            }
            Context context = object;
            object = Locale.forLanguageTag(string2);
            Locale.setDefault((Locale)object);
            string2 = context.getConfiguration();
            string2.setLocale((Locale)object);
            context.updateConfiguration((Configuration)string2, context.getDisplayMetrics());
        }
    }

    public static void updateLanguage(Context context, String string2) {
        if (context == null) {
            return;
        }
        SharedPreferences.Editor editor = context.getSharedPreferences(LanguageConfigSPFile, 0).edit();
        editor.putString(LanguageConfigKey, string2);
        editor.commit();
        sCurrentLocalLanguage = string2;
        LanguageUtil.updateSystemLanguage(context);
    }

    public static String getString(JSONObject jSONObject, String string2) {
        String string3;
        String[] stringArray;
        if (jSONObject != null && !TextUtils.isEmpty((CharSequence)(stringArray = LanguageUtil.getCurrentLocaleLanguage(DeviceInfo.sApplicationContext)))) {
            string3 = LanguageUtil.getString((String)stringArray, jSONObject);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                if (stringArray.equalsIgnoreCase("zh-CN")) {
                    string3 = LanguageUtil.getString("zh-Hans", jSONObject);
                } else if (stringArray.equalsIgnoreCase("zh-HK")) {
                    string3 = LanguageUtil.getString("zh-Hant-HK", jSONObject);
                } else if (stringArray.equalsIgnoreCase("zh-TW")) {
                    string3 = LanguageUtil.getString("zh-Hant-TW", jSONObject);
                }
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    int n2 = (stringArray = stringArray.split("-")).length;
                    if (n2 != 2) {
                        if (n2 == 3) {
                            string3 = LanguageUtil.getString(stringArray[0] + "-" + stringArray[2], jSONObject);
                            if (TextUtils.isEmpty((CharSequence)string3)) {
                                string3 = LanguageUtil.getString(stringArray[0] + "-" + stringArray[1], jSONObject);
                            }
                            if (TextUtils.isEmpty((CharSequence)string3)) {
                                string3 = LanguageUtil.getString(stringArray[0], jSONObject);
                            }
                        }
                    } else {
                        string3 = LanguageUtil.getString(stringArray[0], jSONObject);
                    }
                }
            }
        } else {
            string3 = string2;
        }
        if (PdrUtil.isEmpty(string3)) {
            string3 = string2;
        }
        return string3;
    }

    private static String getString(String string2, JSONObject jSONObject) {
        if (jSONObject != null && jSONObject.containsKey((Object)string2)) {
            return jSONObject.getString(string2);
        }
        return null;
    }

    public static Locale getCurrentLocal(Context object, boolean bl) {
        Object var2_3 = null;
        if (object != null) {
            if (Build.VERSION.SDK_INT >= 24) {
                LocaleList localeList = object.getResources().getConfiguration().getLocales();
                if (bl) {
                    object.getResources();
                    localeList = Resources.getSystem().getConfiguration().getLocales();
                }
                object = localeList != null && localeList.size() > 0 ? localeList.get(0) : object.getResources().getConfiguration().locale;
            } else if (bl) {
                object.getResources();
                object = Resources.getSystem().getConfiguration().locale;
            } else {
                object = object.getResources().getConfiguration().locale;
            }
        } else {
            object = var2_3;
        }
        return object;
    }

    public static String getCurrentLocaleLanguage(Context object) {
        if (TextUtils.isEmpty((CharSequence)sCurrentLocalLanguage)) {
            if ((object = LanguageUtil.getCurrentLocal((Context)object, true)) == null) {
                return deviceDefLocalLanguage;
            }
            String string2 = ((Locale)object).getLanguage() + "-" + ((Locale)object).getCountry();
            if (Build.VERSION.SDK_INT > 21) {
                string2 = ((Locale)object).toLanguageTag();
            }
            object = ((Locale)object).getLanguage();
            ((String)object).hashCode();
            int n2 = -1;
            switch (((String)object).hashCode()) {
                default: {
                    break;
                }
                case 3886: {
                    if (!((String)object).equals("zh")) break;
                    n2 = 3;
                    break;
                }
                case 3276: {
                    if (!((String)object).equals("fr")) break;
                    n2 = 2;
                    break;
                }
                case 3246: {
                    if (!((String)object).equals("es")) break;
                    n2 = 1;
                    break;
                }
                case 3241: {
                    if (!((String)object).equals("en")) break;
                    n2 = 0;
                }
            }
            switch (n2) {
                default: {
                    return string2;
                }
                case 3: {
                    if (string2.equalsIgnoreCase("zh-CN")) {
                        return "zh-Hans";
                    }
                    if (string2.equalsIgnoreCase("zh-HK")) {
                        return "zh-Hant-HK";
                    }
                    if (string2.equalsIgnoreCase("zh-TW")) {
                        return "zh-Hant-TW";
                    }
                    return string2;
                }
                case 2: {
                    return "fr";
                }
                case 1: {
                    return "es";
                }
                case 0: 
            }
            return "en";
        }
        return sCurrentLocalLanguage;
    }
}

