/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.util.hostpicker;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import io.dcloud.g.a;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;

public class HostPicker {
    private static HostPicker instance = new HostPicker();
    private final String SP_FILE_NAME;
    private final String SP_LAST_SUIT_HOST_NAME;

    private HostPicker() {
        this.SP_FILE_NAME = "UNIAPP_HostPicker_0817";
        this.SP_LAST_SUIT_HOST_NAME = "SP_LAST_SUIT_HOST_NAME_0817";
    }

    private void initHostsForRequest(Context context, List<Host> object, String object2) {
        List<Host> list = object;
        String string2 = "SP_LAST_SUIT_HOST_NAME_0817" + (String)object2;
        context = context.getSharedPreferences("UNIAPP_HostPicker_0817", 0);
        object = context.getString(string2, "");
        for (Host host : list) {
            if (host.isFormatRightful()) {
                if (TextUtils.isEmpty((CharSequence)object) || host.priority == Host.PriorityEnum.BACKUP) continue;
                if (((String)object).equals(host.hostUrl)) {
                    host.priority = Host.PriorityEnum.FIRST;
                    continue;
                }
                host.priority = Host.PriorityEnum.NORMAL;
                continue;
            }
            throw new RuntimeException("error format host");
        }
        context.edit().remove(string2).apply();
    }

    public static HostPicker getInstance() {
        return instance;
    }

    public void pickSuitHost(Context context, List<Host> object, String string2, HostPickCallback hostPickCallback) {
        if (object != null && !object.isEmpty()) {
            List<Host> list = object;
            ((HostPicker)object2).initHostsForRequest(context, (List<Host>)object, string2);
            Collections.sort(list);
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                object = (Host)object2.next();
                if (!hostPickCallback.doRequest((Host)object)) continue;
                if (((Host)object).priority != Host.PriorityEnum.BACKUP) {
                    object2 = "SP_LAST_SUIT_HOST_NAME_0817" + string2;
                    context.getSharedPreferences("UNIAPP_HostPicker_0817", 0).edit().putString((String)object2, ((Host)object).hostUrl).apply();
                }
                hostPickCallback.onOneSelected((Host)object);
                return;
            }
            hostPickCallback.onNoOnePicked();
            return;
        }
        throw new RuntimeException("call initHosts first");
    }

    public static class Host
    implements Comparable<Host>,
    Cloneable {
        String hostUrl;
        PriorityEnum priority = PriorityEnum.NORMAL;

        public Host(String string2, PriorityEnum priorityEnum) {
            this.hostUrl = string2;
            this.priority = priorityEnum;
        }

        public String getRealHost() {
            String string2;
            if (TextUtils.isEmpty((CharSequence)this.hostUrl)) {
                return "";
            }
            String string3 = "";
            String string4 = string2;
            try {
                string2 = new String(Base64.decode((byte[])this.hostUrl.getBytes("UTF-8"), (int)2), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                string4 = string3;
            }
            return a.b(string4);
        }

        public boolean isFormatRightful() {
            return !TextUtils.isEmpty((CharSequence)this.hostUrl);
        }

        public String getHostUrl() {
            return this.hostUrl;
        }

        public PriorityEnum getPriority() {
            return this.priority;
        }

        @Override
        public int compareTo(Host host) {
            if (host == null) {
                return 1;
            }
            Host host2 = object;
            Object object = host.priority;
            return ((PriorityEnum)((Object)object)).val - host2.priority.val;
        }

        public int hashCode() {
            return this.hostUrl.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Host)) {
                return false;
            }
            object = (Host)object;
            if (TextUtils.isEmpty((CharSequence)((Host)object).hostUrl)) {
                return false;
            }
            return ((Host)object).hostUrl.equals(this.hostUrl);
        }

        protected Host clone() {
            Host host = string2;
            String string2 = host.hostUrl;
            return new Host(string2, host.priority);
        }

        public String toString() {
            return "Host{hostUrl='" + this.hostUrl + '\'' + ", priority=" + (Object)((Object)this.priority) + '}';
        }

        public static final class PriorityEnum
        extends Enum<PriorityEnum> {
            public static final /* enum */ PriorityEnum NORMAL;
            public static final /* enum */ PriorityEnum FIRST;
            public static final /* enum */ PriorityEnum BACKUP;
            private static final /* synthetic */ PriorityEnum[] $VALUES;
            int val = 0;

            public static PriorityEnum[] values() {
                return (PriorityEnum[])$VALUES.clone();
            }

            public static PriorityEnum valueOf(String string2) {
                return Enum.valueOf(PriorityEnum.class, string2);
            }

            private PriorityEnum(int n3) {
                this.val = n3;
            }

            static {
                PriorityEnum priorityEnum;
                PriorityEnum priorityEnum2;
                PriorityEnum priorityEnum3;
                PriorityEnum priorityEnum4 = priorityEnum3;
                NORMAL = new PriorityEnum(0);
                PriorityEnum priorityEnum5 = priorityEnum2;
                FIRST = new PriorityEnum(1);
                PriorityEnum priorityEnum6 = priorityEnum;
                BACKUP = new PriorityEnum(-1);
                $VALUES = new PriorityEnum[]{priorityEnum4, priorityEnum5, priorityEnum6};
            }
        }
    }

    public static interface HostPickCallback {
        public void onNoOnePicked();

        public boolean doRequest(Host var1);

        public void onOneSelected(Host var1);
    }
}

