/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import androidx.core.content.FileProvider;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.MobilePhoneModel;
import io.dcloud.common.util.HashUtils;
import io.dcloud.common.util.IOUtil;
import io.dcloud.common.util.Md5Utils;
import io.dcloud.common.util.ReflectUtils;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class LoadAppUtils {
    private static final String TAG = "LoadAppUtils";
    private static final int APP_TYPE_ALL = 0;
    private static final int APP_TYPE_NON_SYSTEM = 1;
    private static final int APP_TYPE_SYSTEM = 2;
    public static final int APK_INSTALLED = 0;
    public static final int APK_UNINSTALLED = -2;
    public static final int APK_UPGRADE = 1;
    public static final int APK_DOWNGRADE = -1;

    public static int getLoadState(PackageInfo packageInfo, int n2) {
        int n3;
        return packageInfo == null ? -2 : ((n3 = packageInfo.versionCode) == n2 ? 0 : (n3 < n2 ? 1 : -1));
    }

    public static PackageInfo getLoadedApp(Context context, PackageManager packageManager, String string2) {
        Context context2 = context;
        context = null;
        try {
            context = context2.getPackageManager().getPackageInfo(string2, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        return context;
    }

    public static String getLoadedAppNameByPackageInfo(Context context, PackageManager packageManager, PackageInfo packageInfo) {
        if (packageManager == null) {
            packageManager = context.getPackageManager();
        }
        return packageManager.getApplicationLabel(packageInfo.applicationInfo).toString();
    }

    public static boolean isAppLoad(Context context, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2.equals(context.getPackageName())) {
            return true;
        }
        try {
            boolean bl = context.getPackageManager().getPackageInfo(string2, 256) != null;
            return bl;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return new File("/sdcard/Android/data/" + string2).exists();
        }
    }

    public static void uninstall(Context context, String string2) {
        Context context2 = context;
        context = Uri.fromParts((String)"package", (String)string2, null);
        Intent intent = new Intent("android.intent.action.DELETE", (Uri)context);
        Intent intent2 = intent;
        intent.addFlags(0x10000000);
        try {
            context2.startActivity(intent2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean openApp(Context context, String string2) {
        string2 = context.getPackageManager().getLaunchIntentForPackage(string2);
        if (string2 != null) {
            context.startActivity((Intent)string2);
            return true;
        }
        return false;
    }

    public static boolean isSystemApp(ApplicationInfo applicationInfo) {
        if ((applicationInfo.flags & 1) > 0) {
            return !applicationInfo.publicSourceDir.startsWith("data/dataapp") && !applicationInfo.publicSourceDir.startsWith("/data/dataapp");
            {
            }
        }
        return false;
    }

    public static String getAppSignatureMd5(Context context, String string2) {
        try {
            return Md5Utils.md5LowerCase(Arrays.toString(context.getPackageManager().getPackageInfo((String)string2, (int)64).signatures[0].toByteArray()));
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static String getAppSignatureSHA1(Context signatureArray) {
        int n2;
        signatureArray = signatureArray.getPackageManager().getPackageInfo((String)signatureArray.getPackageName(), (int)64).signatures;
        String string2 = null;
        try {
            n2 = signatureArray.getPackageManager().getPackageInfo((String)signatureArray.getPackageName(), (int)64).signatures.length;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            string2 = LoadAppUtils.getSignatureString(signatureArray[i2], "SHA1");
            continue;
        }
        return string2;
    }

    public static String getSignatureString(Signature object, String string2) {
        block9: {
            StringBuilder stringBuilder;
            String string3 = string2;
            object = object.toByteArray();
            string2 = "error!";
            Object object2 = MessageDigest.getInstance(string3);
            if (object2 == null) break block9;
            byte[] byArray = ((MessageDigest)object2).digest((byte[])object);
            object = byArray;
            object2 = stringBuilder;
            stringBuilder = new StringBuilder();
            int n2 = byArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object3 = object2;
                Signature signature = object[i2];
                ((StringBuilder)object3).append(Integer.toHexString(signature & 0xFF | 0x100).substring(1, 3));
            }
            try {
                string2 = ((StringBuilder)object2).toString();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
        }
        return string2;
    }

    private static String[] getPackageSignatures(Context object, String object2) {
        block7: {
            object = object.getPackageManager().getPackageArchiveInfo((String)object2, 64);
            if (object == null) break block7;
            object2 = object.signatures;
            if (object.signatures == null) break block7;
            if (((Signature[])object2).length <= 0) break block7;
            Context context = object;
            object = HashUtils.getHash(Arrays.toString(object2[0].toByteArray())).toLowerCase(Locale.ENGLISH);
            object2 = context.applicationInfo.packageName;
            try {
                return new String[]{object, object2};
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Object parsePackage(String var0, int var1_4) {
        block41: {
            var2_5 = Build.VERSION.SDK_INT;
            if (var2_5 < 21) break block41;
            v0 = ReflectUtils.getObjectConstructor("android.content.pm.PackageParser", new Class[0]).newInstance(new Object[0]);
lbl6:
            // 2 sources

            while (true) {
                var3_6 = v0;
                ** GOTO lbl16
                break;
            }
        }
        v1 = new Class[1];
        v1[0] = String.class;
        v0 = ReflectUtils.getObjectConstructor("android.content.pm.PackageParser", v1).newInstance(new Object[]{var0});
        ** continue;
lbl16:
        // 1 sources

        v2 = var2_5;
        var4_7 = v3;
        new DisplayMetrics().setToDefaults();
        var5_8 = v4;
        v4 = new File(var0);
        if (v2 >= 21) {
            v5 = var3_6.getClass();
            v6 = new Class[2];
            v6[0] = File.class;
            v6[1] = Integer.TYPE;
            v7 = v5.getMethod("parsePackage", v6);
            v8 = var3_6;
            v9 = new Object[2];
            v10 = var1_4;
            v9[0] = var5_8;
            var0_1 = 1;
            v9[var0_1] = v10;
            v11 = v7.invoke(v8, v9);
lbl42:
            // 2 sources

            while (true) {
                continue;
                break;
            }
        }
        v12 = var3_6.getClass();
        v13 = new Class[4];
        v13[0] = File.class;
        v13[1] = String.class;
        v13[2] = DisplayMetrics.class;
        v13[3] = Integer.TYPE;
        v14 = v12.getMethod("parsePackage", v13);
        v15 = var3_6;
        v16 = new Object[4];
        v17 = var1_4;
        v16[0] = var5_8;
        v16[1] = var0;
        v16[2] = var4_7;
        var0_3 = 3;
        try {
            v16[var0_3] = v17;
            v11 = v14.invoke(v15, v16);
            ** continue;
        }
        catch (Exception v33) {
            v33.printStackTrace();
            return null;
        }
        var0_2 = v11;
        if (var0_2 == null) {
            Log.d((String)"LoadAppUtils", (String)("---parsePackage is null------;;sourceFile=" + var5_8.getAbsolutePath()));
            return null;
        }
        if (var2_5 >= 21) {
            v18 = var3_6.getClass();
            v19 = new Class[3];
            v19[0] = ReflectUtils.classForName("android.content.pm.PackageParser$Package");
            v19[1] = File.class;
            v19[2] = Integer.TYPE;
            v20 = v18.getDeclaredMethod("collectCertificates", v19);
            v21 = var3_6;
            v20.setAccessible(true);
            v22 = new Object[3];
            v23 = v22;
            v24 = v22;
            v22[0] = var0_2;
            v22[1] = var5_8;
            v23[2] = 1;
            v25 = v20.invoke(v21, v24);
lbl98:
            // 2 sources

            while (true) {
                break;
            }
        } else {
            v26 = var3_6.getClass();
            v27 = new Class[2];
            v27[0] = ReflectUtils.classForName("android.content.pm.PackageParser$Package");
            v27[1] = Integer.TYPE;
            v28 = v26.getDeclaredMethod("collectCertificates", v27);
            v29 = var3_6;
            v30 = new Object[2];
            v31 = v30;
            v32 = v30;
            v30[0] = var0_2;
            v32[1] = 1;
            v25 = v28.invoke(v29, v31);
            ** continue;
        }
        return var0_2;
    }

    public static String[] getApkFileSignatureAndPackageName(Context object, String object2) {
        block11: {
            block10: {
                try {
                    object = LoadAppUtils.getPackageSignatures((Context)object, (String)object2);
                    if (object == null) break block10;
                    return object;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            try {
                object = LoadAppUtils.parsePackage((String)object2, 64);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                object = null;
            }
            if (object == null) {
                return null;
            }
            object2 = LoadAppUtils.getApkSignature(object, (String)object2);
            if (object2 == null) break block11;
            if (((Signature[])object2).length <= 0) break block11;
            Object object3 = object;
            object = HashUtils.getHash(Arrays.toString(object2[0].toByteArray())).toLowerCase(Locale.ENGLISH);
            object2 = (String)ReflectUtils.getObjectFieldNoDeclared(ReflectUtils.getField(object3, "applicationInfo"), "packageName");
            return new String[]{object, object2};
        }
        return null;
    }

    public static Signature[] getApkSignature(Object signatureArray, String string2) {
        Signature[] signatureArray2 = signatureArray;
        signatureArray = new Signature[]{};
        try {
            signatureArray = (Signature[])ReflectUtils.getField(signatureArray2, "mSignatures");
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        if (signatureArray == null) {
            return null;
        }
        if (signatureArray.length <= 0) {
            return null;
        }
        return signatureArray;
    }

    public static String[] getApkFileSignatureAndPackageNameEx(Context object, String object2) {
        block7: {
            block8: {
                try {
                    object = LoadAppUtils.parsePackage((String)object2, 64);
                    if (object == null) break block7;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
                object2 = (Signature[])ReflectUtils.getField(object, "mSignatures");
                if (object2 == null) break block8;
                if (((Signature[])object2).length == 0) break block8;
                Object object3 = object;
                object = HashUtils.getHash(Arrays.toString(object2[0].toByteArray())).toLowerCase(Locale.ENGLISH);
                object2 = (String)ReflectUtils.getField(object3, "packageName");
                return new String[]{object, object2};
            }
            return null;
        }
        return null;
    }

    public static boolean isValidAppPackageName(String string2) {
        return Pattern.compile("^[a-zA-Z_]\\w*(\\.[a-zA-Z_]\\w*)*$").matcher(string2).matches();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static String getApkFileLable(Context var0, String var1_3) {
        block47: {
            block46: {
                var2_4 = "android.content.res.AssetManager";
                var3_6 = Class.forName("android.content.pm.PackageParser");
                v0 = new Class[1];
                var4_8 = v0;
                v0[0] = String.class;
                var5_9 = Build.VERSION.SDK_INT;
                if (var5_9 < 21) break block46;
                v1 = var3_6.getConstructor(new Class[0]);
lbl13:
                // 2 sources

                while (true) {
                    var4_8 = v1;
                    ** GOTO lbl20
                    break;
                }
            }
            v1 = var3_6.getConstructor((Class<?>)var4_8);
            ** continue;
lbl20:
            // 1 sources

            v2 = var5_9;
            v3 = new Object[1];
            var6_11 = v3;
            v3[0] = var1_3 /* !! */ ;
            if (v2 >= 21) {
                v4 = var4_8.newInstance(new Object[0]);
lbl28:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
            }
            try {
                v4 = var4_8.newInstance((Object[])var6_11);
                ** continue;
            }
            catch (Exception v5) {
                v5.printStackTrace();
                return "-1";
            }
            var4_8 = v4;
            Log.d((String)"DownloadUtils", (String)("pkgParser:" + var4_8.toString()));
            var6_11 = v6;
            new DisplayMetrics().setToDefaults();
            if (var5_9 < 21) ** GOTO lbl52
            v7 = new Class[2];
            var7_12 = v7;
            v7[0] = File.class;
            v7[1] = Integer.TYPE;
            ** GOTO lbl62
lbl52:
            // 1 sources

            v8 = new Class[4];
            var7_12 = v8;
            v8[0] = File.class;
            v8[1] = String.class;
            v8[2] = DisplayMetrics.class;
            v8[3] = Integer.TYPE;
lbl62:
            // 2 sources

            var3_6 = var3_6.getDeclaredMethod("parsePackage", var7_12);
            if (var5_9 < 21) ** GOTO lbl72
            v9 = new Object[2];
            var5_10 = v9;
            v9[0] = new File(var1_3 /* !! */ );
            v9[1] = 0;
            ** GOTO lbl80
lbl72:
            // 1 sources

            v10 = new Object[4];
            var5_10 = v10;
            v10[0] = new File(var1_3 /* !! */ );
            v10[1] = var1_3 /* !! */ ;
            v10[2] = var6_11;
            v10[3] = 0;
lbl80:
            // 2 sources

            var3_6 = var3_6.invoke(var4_8, var5_10);
            var3_6 = (ApplicationInfo)var3_6.getClass().getDeclaredField("applicationInfo").get(var3_6);
            v11 = var0;
            Log.d((String)"DownloadUtils", (String)("pkg:" + var3_6.packageName + " uid=" + var3_6.uid));
            v12 = Class.forName((String)var2_4);
            v13 = v12.getConstructor(null);
            var0 = v13.newInstance(null);
            v14 = new Class[1];
            var2_4 = v14;
            v14[0] = String.class;
            v12.getDeclaredMethod("addAssetPath", (Class<?>[])var2_4).invoke(var0, new Object[]{var1_3 /* !! */ });
            var1_3 /* !! */  = v11.getResources();
            v15 = new Class[3];
            var2_4 = v15;
            var3_7 = 0;
            v15[var3_7] = var0.getClass();
            v15[1] = var1_3 /* !! */ .getDisplayMetrics().getClass();
            v15[2] = var1_3 /* !! */ .getConfiguration().getClass();
            v16 = Resources.class.getConstructor((Class<?>[])var2_4);
            v17 = new Object[3];
            var2_4 = v17;
            v18 = var1_3 /* !! */ ;
            v19 = var2_4;
            v20 = var1_3 /* !! */ ;
            var2_4[0] = var0;
            var0_1 = 1;
            v19[var0_1] = v20.getDisplayMetrics();
            var0_1 = 2;
            v17[var0_1] = v18.getConfiguration();
            var0_2 = (Resources)v16.newInstance(v17);
            var1_3 /* !! */  = null;
            var2_5 = var3_6.labelRes;
            if (var2_5 == 0) break block47;
            var1_3 /* !! */  = var0_2.getText(var2_5);
        }
        Log.d((String)"DownloadUtils", (String)("label=" + var1_3 /* !! */ ));
        return var1_3 /* !! */ .toString();
    }

    public static void loadRunApp(Context context, String string2) {
        Context context2 = context;
        context2.startActivity(LoadAppUtils.getDataAndTypeIntent(context2, string2, "application/vnd.android.package-archive"));
    }

    public static Intent getDataAndTypeIntent(Context context, String string2, String string3) {
        Intent intent;
        Intent intent2 = intent;
        new Intent().addFlags(0x10000000);
        intent2.setAction("android.intent.action.VIEW");
        if (Build.VERSION.SDK_INT >= 24) {
            Intent intent3 = intent2;
            context = FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".dc.fileprovider"), (File)new File(string2));
            intent3.addFlags(1);
            intent3.setDataAndType((Uri)context, string3);
        } else {
            intent2.setDataAndType(Uri.fromFile((File)new File(string2)), string3);
        }
        return intent2;
    }

    public static boolean startSecuritySettingPage(Context context) {
        if (LoadAppUtils.isVivoRom()) {
            return LoadAppUtils.startShortcutSettingsVivo(context);
        }
        if (LoadAppUtils.isEMUIRom()) {
            Context context2 = context;
            return LoadAppUtils.startShortcutSettingsEMUI(context2, context2.getPackageName());
        }
        Context context3 = context;
        return LoadAppUtils.startAppDetailSettings(context3, context3.getPackageName());
    }

    public static boolean isVivoRom() {
        Locale locale = Locale.ENGLISH;
        return Build.FINGERPRINT.toLowerCase(locale).contains("vivo") || Build.MODEL.toLowerCase(locale).contains("vivo");
    }

    public static boolean isEMUIRom() {
        return Build.MANUFACTURER.equalsIgnoreCase(MobilePhoneModel.HUAWEI);
    }

    public static boolean startShortcutSettingsVivo(Context context) {
        Intent intent;
        block6: {
            Intent intent2;
            Context context2;
            try {
                context2 = context;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            intent = intent2;
            new Intent("com.bbk.launcher.installshortcutpermission.open").setPackage("com.bbk.launcher2");
            if (context2 instanceof Activity) break block6;
            intent.setFlags(0x10000000);
        }
        context.startActivity(intent);
        return true;
    }

    private static boolean startAppDetailSettings(Context context, String string2) {
        return SafeCenter.goSafeCenter(context);
    }

    public static boolean startShortcutSettingsEMUI(Context context, String string2) {
        Intent intent;
        Intent intent2 = intent;
        intent = new Intent();
        if (!(context instanceof Activity)) {
            intent2.setFlags(0x10000000);
        }
        Intent intent3 = intent2;
        intent3.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent3.setData(Uri.fromParts((String)"package", (String)string2, null));
        context.startActivity(intent3);
        return true;
    }

    public static String getAppName(Context context) {
        int n2;
        Context context2;
        try {
            Context context3 = context;
            context2 = context3;
            n2 = context3.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).applicationInfo.labelRes;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return context2.getResources().getString(n2);
    }

    public static String getAppVersionName(Context object, String string2) {
        Context context = object;
        object = "";
        try {
            object = context.getPackageManager().getPackageInfo((String)string2, (int)0).versionName;
        }
        catch (Exception exception) {}
        return object;
    }

    static class SafeCenter {
        private static ArrayList<Item> datas = new ArrayList();

        SafeCenter() {
        }

        static void init(Context object) {
            block17: {
                int n2;
                JSONArray jSONArray;
                String string2;
                File file;
                if (!datas.isEmpty()) {
                    return;
                }
                File file2 = file;
                file = new File(object.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS) + "/temp.j");
                object = string2;
                string2 = new String(IOUtil.toString(new FileInputStream(file2)));
                file2 = jSONArray;
                try {
                    jSONArray = new JSONArray((String)object);
                    n2 = 0;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                while (true) {
                    block18: {
                        Item item;
                        if (n2 >= file2.length()) break block17;
                        Object object2 = file2.optJSONObject(n2);
                        String string3 = object2.optString("p");
                        if (TextUtils.isEmpty((CharSequence)string3)) break block18;
                        ArrayList<Item> arrayList = datas;
                        Item item2 = item;
                        Item item3 = item;
                        String string4 = string3;
                        JSONObject jSONObject = object2;
                        JSONObject jSONObject2 = jSONObject;
                        JSONObject jSONObject3 = jSONObject;
                        object2 = jSONObject.optString("c");
                        string3 = jSONObject3.optString("e");
                        String string5 = jSONObject2.optString("a");
                        item2(string4, (String)object2, string3, string5);
                        arrayList.add(item3);
                    }
                    ++n2;
                }
            }
            if (datas.isEmpty()) {
                datas.add(new Item("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity", "extra_pkgname", null));
                datas.add(new Item("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity", "extra_pkgname", null));
                datas.add(new Item("com.meizu.safe", "com.meizu.safe.security.AppSecActivity", "packageName", null));
                datas.add(new Item("com.aliyun.mobile.permission", "com.aliyun.mobile.permission.ExternalAppDetailActivity", "packageName", null));
                datas.add(new Item("com.iqoo.secure", "com.iqoo.secure.MainActivity", "packageName", null));
                datas.add(new Item("com.sonymobile.cta", "com.sonymobile.cta.SomcCTAMainActivity", "package", null));
                datas.add(new Item("com.mediatek.security", "com.mediatek.security.ui.PermissionControlPageActivity", "package", null));
                datas.add(new Item("com.yulong.android.launcher3", "com.yulong.android.launcher3.LauncherSettingsActivity", "package", null));
                datas.add(new Item("com.android.settings", "com.android.settings.Settings$ManageApplicationsActivity", "package", null));
                datas.add(new Item(null, null, "package", "android.settings.MANAGE_APPLICATIONS_SETTINGS"));
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private static boolean goSafeCenter(Context var0) {
            try {
                v0 = var0;
                SafeCenter.init(v0);
                var1_2 /* !! */  = v0.getPackageManager();
                var2_3 = 0;
            }
            catch (Exception var0_1) {
                Logger.e("Permission", "Exception =" + var0_1);
                return false;
            }
            while (true) {
                block21: {
                    block24: {
                        block23: {
                            block22: {
                                if (var2_3 >= SafeCenter.datas.size()) break;
                                v1 = var1_2 /* !! */ ;
                                var3_4 = v2;
                                v2 = new Intent();
                                var4_5 = SafeCenter.datas.get(var2_3);
                                if (v1.getPackageInfo(var4_5.pname, 0) == null) break block21;
                                if (TextUtils.isEmpty((CharSequence)var4_5.clsName)) break block22;
                                v3 = var3_4;
                                v4 = var4_5;
                                v5 = v4;
                                var1_2 /* !! */  = v4.pname;
                                v6 = v3.setClassName((String)var1_2 /* !! */ , v5.clsName);
lbl26:
                                // 2 sources

                                while (true) {
                                    ** GOTO lbl34
                                    break;
                                }
                            }
                            if (TextUtils.isEmpty((CharSequence)var4_5.pname)) ** GOTO lbl34
                            v6 = var3_4.setPackage(var4_5.pname);
                            ** continue;
lbl34:
                            // 2 sources

                            if (TextUtils.isEmpty((CharSequence)var4_5.action)) break block23;
                            var3_4.setAction(var4_5.action);
                        }
                        if (TextUtils.isEmpty((CharSequence)var4_5.extParamName)) break block24;
                        v7 = var3_4;
                        v8 = var0;
                        var1_2 /* !! */  = var4_5.extParamName;
                        v7.putExtra((String)var1_2 /* !! */ , v8.getPackageName());
                    }
                    v9 = var0;
                    v10 = var3_4;
                    v11 = v10;
                    v10.setFlags(0x10000000);
                    v9.startActivity(v11);
                    Logger.e("Permission", "successful " + Build.MODEL + "intent=" + var3_4);
                    return true;
                    catch (PackageManager.NameNotFoundException v12) {}
                }
                ++var2_3;
            }
            return true;
        }

        static class Item {
            String pname;
            String clsName;
            String extParamName;
            String action;

            Item(String string2, String string3, String string4, String string5) {
                this.pname = string2;
                this.clsName = string3;
                this.extParamName = string4;
                this.action = string5;
            }
        }
    }
}

