/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.util;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.media.MediaDataSource;
import android.media.MediaMetadataRetriever;
import android.os.Build;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import android.util.Pair;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

public class ExifInterface {
    private static final String TAG = "ExifInterface";
    private static final boolean DEBUG;
    public static final String TAG_IMAGE_WIDTH = "ImageWidth";
    public static final String TAG_IMAGE_LENGTH = "ImageLength";
    public static final String TAG_BITS_PER_SAMPLE = "BitsPerSample";
    public static final String TAG_COMPRESSION = "Compression";
    public static final String TAG_PHOTOMETRIC_INTERPRETATION = "PhotometricInterpretation";
    public static final String TAG_ORIENTATION = "Orientation";
    public static final String TAG_SAMPLES_PER_PIXEL = "SamplesPerPixel";
    public static final String TAG_PLANAR_CONFIGURATION = "PlanarConfiguration";
    public static final String TAG_Y_CB_CR_SUB_SAMPLING = "YCbCrSubSampling";
    public static final String TAG_Y_CB_CR_POSITIONING = "YCbCrPositioning";
    public static final String TAG_X_RESOLUTION = "XResolution";
    public static final String TAG_Y_RESOLUTION = "YResolution";
    public static final String TAG_RESOLUTION_UNIT = "ResolutionUnit";
    public static final String TAG_STRIP_OFFSETS = "StripOffsets";
    public static final String TAG_ROWS_PER_STRIP = "RowsPerStrip";
    public static final String TAG_STRIP_BYTE_COUNTS = "StripByteCounts";
    public static final String TAG_JPEG_INTERCHANGE_FORMAT = "JPEGInterchangeFormat";
    public static final String TAG_JPEG_INTERCHANGE_FORMAT_LENGTH = "JPEGInterchangeFormatLength";
    public static final String TAG_TRANSFER_FUNCTION = "TransferFunction";
    public static final String TAG_WHITE_POINT = "WhitePoint";
    public static final String TAG_PRIMARY_CHROMATICITIES = "PrimaryChromaticities";
    public static final String TAG_Y_CB_CR_COEFFICIENTS = "YCbCrCoefficients";
    public static final String TAG_REFERENCE_BLACK_WHITE = "ReferenceBlackWhite";
    public static final String TAG_DATETIME = "DateTime";
    public static final String TAG_IMAGE_DESCRIPTION = "ImageDescription";
    public static final String TAG_MAKE = "Make";
    public static final String TAG_MODEL = "Model";
    public static final String TAG_SOFTWARE = "Software";
    public static final String TAG_ARTIST = "Artist";
    public static final String TAG_COPYRIGHT = "Copyright";
    public static final String TAG_EXIF_VERSION = "ExifVersion";
    public static final String TAG_FLASHPIX_VERSION = "FlashpixVersion";
    public static final String TAG_COLOR_SPACE = "ColorSpace";
    public static final String TAG_GAMMA = "Gamma";
    public static final String TAG_PIXEL_X_DIMENSION = "PixelXDimension";
    public static final String TAG_PIXEL_Y_DIMENSION = "PixelYDimension";
    public static final String TAG_COMPONENTS_CONFIGURATION = "ComponentsConfiguration";
    public static final String TAG_COMPRESSED_BITS_PER_PIXEL = "CompressedBitsPerPixel";
    public static final String TAG_MAKER_NOTE = "MakerNote";
    public static final String TAG_USER_COMMENT = "UserComment";
    public static final String TAG_RELATED_SOUND_FILE = "RelatedSoundFile";
    public static final String TAG_DATETIME_ORIGINAL = "DateTimeOriginal";
    public static final String TAG_DATETIME_DIGITIZED = "DateTimeDigitized";
    public static final String TAG_OFFSET_TIME = "OffsetTime";
    public static final String TAG_OFFSET_TIME_ORIGINAL = "OffsetTimeOriginal";
    public static final String TAG_OFFSET_TIME_DIGITIZED = "OffsetTimeDigitized";
    public static final String TAG_SUBSEC_TIME = "SubSecTime";
    public static final String TAG_SUBSEC_TIME_ORIGINAL = "SubSecTimeOriginal";
    public static final String TAG_SUBSEC_TIME_DIGITIZED = "SubSecTimeDigitized";
    public static final String TAG_EXPOSURE_TIME = "ExposureTime";
    public static final String TAG_F_NUMBER = "FNumber";
    public static final String TAG_EXPOSURE_PROGRAM = "ExposureProgram";
    public static final String TAG_SPECTRAL_SENSITIVITY = "SpectralSensitivity";
    @Deprecated
    public static final String TAG_ISO_SPEED_RATINGS = "ISOSpeedRatings";
    public static final String TAG_PHOTOGRAPHIC_SENSITIVITY = "PhotographicSensitivity";
    public static final String TAG_OECF = "OECF";
    public static final String TAG_SENSITIVITY_TYPE = "SensitivityType";
    public static final String TAG_STANDARD_OUTPUT_SENSITIVITY = "StandardOutputSensitivity";
    public static final String TAG_RECOMMENDED_EXPOSURE_INDEX = "RecommendedExposureIndex";
    public static final String TAG_ISO_SPEED = "ISOSpeed";
    public static final String TAG_ISO_SPEED_LATITUDE_YYY = "ISOSpeedLatitudeyyy";
    public static final String TAG_ISO_SPEED_LATITUDE_ZZZ = "ISOSpeedLatitudezzz";
    public static final String TAG_SHUTTER_SPEED_VALUE = "ShutterSpeedValue";
    public static final String TAG_APERTURE_VALUE = "ApertureValue";
    public static final String TAG_BRIGHTNESS_VALUE = "BrightnessValue";
    public static final String TAG_EXPOSURE_BIAS_VALUE = "ExposureBiasValue";
    public static final String TAG_MAX_APERTURE_VALUE = "MaxApertureValue";
    public static final String TAG_SUBJECT_DISTANCE = "SubjectDistance";
    public static final String TAG_METERING_MODE = "MeteringMode";
    public static final String TAG_LIGHT_SOURCE = "LightSource";
    public static final String TAG_FLASH = "Flash";
    public static final String TAG_SUBJECT_AREA = "SubjectArea";
    public static final String TAG_FOCAL_LENGTH = "FocalLength";
    public static final String TAG_FLASH_ENERGY = "FlashEnergy";
    public static final String TAG_SPATIAL_FREQUENCY_RESPONSE = "SpatialFrequencyResponse";
    public static final String TAG_FOCAL_PLANE_X_RESOLUTION = "FocalPlaneXResolution";
    public static final String TAG_FOCAL_PLANE_Y_RESOLUTION = "FocalPlaneYResolution";
    public static final String TAG_FOCAL_PLANE_RESOLUTION_UNIT = "FocalPlaneResolutionUnit";
    public static final String TAG_SUBJECT_LOCATION = "SubjectLocation";
    public static final String TAG_EXPOSURE_INDEX = "ExposureIndex";
    public static final String TAG_SENSING_METHOD = "SensingMethod";
    public static final String TAG_FILE_SOURCE = "FileSource";
    public static final String TAG_SCENE_TYPE = "SceneType";
    public static final String TAG_CFA_PATTERN = "CFAPattern";
    public static final String TAG_CUSTOM_RENDERED = "CustomRendered";
    public static final String TAG_EXPOSURE_MODE = "ExposureMode";
    public static final String TAG_WHITE_BALANCE = "WhiteBalance";
    public static final String TAG_DIGITAL_ZOOM_RATIO = "DigitalZoomRatio";
    public static final String TAG_FOCAL_LENGTH_IN_35MM_FILM = "FocalLengthIn35mmFilm";
    public static final String TAG_SCENE_CAPTURE_TYPE = "SceneCaptureType";
    public static final String TAG_GAIN_CONTROL = "GainControl";
    public static final String TAG_CONTRAST = "Contrast";
    public static final String TAG_SATURATION = "Saturation";
    public static final String TAG_SHARPNESS = "Sharpness";
    public static final String TAG_DEVICE_SETTING_DESCRIPTION = "DeviceSettingDescription";
    public static final String TAG_SUBJECT_DISTANCE_RANGE = "SubjectDistanceRange";
    public static final String TAG_IMAGE_UNIQUE_ID = "ImageUniqueID";
    @Deprecated
    public static final String TAG_CAMARA_OWNER_NAME = "CameraOwnerName";
    public static final String TAG_CAMERA_OWNER_NAME = "CameraOwnerName";
    public static final String TAG_BODY_SERIAL_NUMBER = "BodySerialNumber";
    public static final String TAG_LENS_SPECIFICATION = "LensSpecification";
    public static final String TAG_LENS_MAKE = "LensMake";
    public static final String TAG_LENS_MODEL = "LensModel";
    public static final String TAG_LENS_SERIAL_NUMBER = "LensSerialNumber";
    public static final String TAG_GPS_VERSION_ID = "GPSVersionID";
    public static final String TAG_GPS_LATITUDE_REF = "GPSLatitudeRef";
    public static final String TAG_GPS_LATITUDE = "GPSLatitude";
    public static final String TAG_GPS_LONGITUDE_REF = "GPSLongitudeRef";
    public static final String TAG_GPS_LONGITUDE = "GPSLongitude";
    public static final String TAG_GPS_ALTITUDE_REF = "GPSAltitudeRef";
    public static final String TAG_GPS_ALTITUDE = "GPSAltitude";
    public static final String TAG_GPS_TIMESTAMP = "GPSTimeStamp";
    public static final String TAG_GPS_SATELLITES = "GPSSatellites";
    public static final String TAG_GPS_STATUS = "GPSStatus";
    public static final String TAG_GPS_MEASURE_MODE = "GPSMeasureMode";
    public static final String TAG_GPS_DOP = "GPSDOP";
    public static final String TAG_GPS_SPEED_REF = "GPSSpeedRef";
    public static final String TAG_GPS_SPEED = "GPSSpeed";
    public static final String TAG_GPS_TRACK_REF = "GPSTrackRef";
    public static final String TAG_GPS_TRACK = "GPSTrack";
    public static final String TAG_GPS_IMG_DIRECTION_REF = "GPSImgDirectionRef";
    public static final String TAG_GPS_IMG_DIRECTION = "GPSImgDirection";
    public static final String TAG_GPS_MAP_DATUM = "GPSMapDatum";
    public static final String TAG_GPS_DEST_LATITUDE_REF = "GPSDestLatitudeRef";
    public static final String TAG_GPS_DEST_LATITUDE = "GPSDestLatitude";
    public static final String TAG_GPS_DEST_LONGITUDE_REF = "GPSDestLongitudeRef";
    public static final String TAG_GPS_DEST_LONGITUDE = "GPSDestLongitude";
    public static final String TAG_GPS_DEST_BEARING_REF = "GPSDestBearingRef";
    public static final String TAG_GPS_DEST_BEARING = "GPSDestBearing";
    public static final String TAG_GPS_DEST_DISTANCE_REF = "GPSDestDistanceRef";
    public static final String TAG_GPS_DEST_DISTANCE = "GPSDestDistance";
    public static final String TAG_GPS_PROCESSING_METHOD = "GPSProcessingMethod";
    public static final String TAG_GPS_AREA_INFORMATION = "GPSAreaInformation";
    public static final String TAG_GPS_DATESTAMP = "GPSDateStamp";
    public static final String TAG_GPS_DIFFERENTIAL = "GPSDifferential";
    public static final String TAG_GPS_H_POSITIONING_ERROR = "GPSHPositioningError";
    public static final String TAG_INTEROPERABILITY_INDEX = "InteroperabilityIndex";
    public static final String TAG_THUMBNAIL_IMAGE_LENGTH = "ThumbnailImageLength";
    public static final String TAG_THUMBNAIL_IMAGE_WIDTH = "ThumbnailImageWidth";
    public static final String TAG_THUMBNAIL_ORIENTATION = "ThumbnailOrientation";
    public static final String TAG_DNG_VERSION = "DNGVersion";
    public static final String TAG_DEFAULT_CROP_SIZE = "DefaultCropSize";
    public static final String TAG_ORF_THUMBNAIL_IMAGE = "ThumbnailImage";
    public static final String TAG_ORF_PREVIEW_IMAGE_START = "PreviewImageStart";
    public static final String TAG_ORF_PREVIEW_IMAGE_LENGTH = "PreviewImageLength";
    public static final String TAG_ORF_ASPECT_FRAME = "AspectFrame";
    public static final String TAG_RW2_SENSOR_BOTTOM_BORDER = "SensorBottomBorder";
    public static final String TAG_RW2_SENSOR_LEFT_BORDER = "SensorLeftBorder";
    public static final String TAG_RW2_SENSOR_RIGHT_BORDER = "SensorRightBorder";
    public static final String TAG_RW2_SENSOR_TOP_BORDER = "SensorTopBorder";
    public static final String TAG_RW2_ISO = "ISO";
    public static final String TAG_RW2_JPG_FROM_RAW = "JpgFromRaw";
    public static final String TAG_XMP = "Xmp";
    public static final String TAG_NEW_SUBFILE_TYPE = "NewSubfileType";
    public static final String TAG_SUBFILE_TYPE = "SubfileType";
    private static final String TAG_EXIF_IFD_POINTER = "ExifIFDPointer";
    private static final String TAG_GPS_INFO_IFD_POINTER = "GPSInfoIFDPointer";
    private static final String TAG_INTEROPERABILITY_IFD_POINTER = "InteroperabilityIFDPointer";
    private static final String TAG_SUB_IFD_POINTER = "SubIFDPointer";
    private static final String TAG_ORF_CAMERA_SETTINGS_IFD_POINTER = "CameraSettingsIFDPointer";
    private static final String TAG_ORF_IMAGE_PROCESSING_IFD_POINTER = "ImageProcessingIFDPointer";
    private static final int MAX_THUMBNAIL_SIZE = 512;
    public static final int ORIENTATION_UNDEFINED = 0;
    public static final int ORIENTATION_NORMAL = 1;
    public static final int ORIENTATION_FLIP_HORIZONTAL = 2;
    public static final int ORIENTATION_ROTATE_180 = 3;
    public static final int ORIENTATION_FLIP_VERTICAL = 4;
    public static final int ORIENTATION_TRANSPOSE = 5;
    public static final int ORIENTATION_ROTATE_90 = 6;
    public static final int ORIENTATION_TRANSVERSE = 7;
    public static final int ORIENTATION_ROTATE_270 = 8;
    private static final List<Integer> ROTATION_ORDER;
    private static final List<Integer> FLIPPED_ROTATION_ORDER;
    public static final short FORMAT_CHUNKY = 1;
    public static final short FORMAT_PLANAR = 2;
    public static final short Y_CB_CR_POSITIONING_CENTERED = 1;
    public static final short Y_CB_CR_POSITIONING_CO_SITED = 2;
    public static final short RESOLUTION_UNIT_INCHES = 2;
    public static final short RESOLUTION_UNIT_CENTIMETERS = 3;
    public static final int COLOR_SPACE_S_RGB = 1;
    public static final int COLOR_SPACE_UNCALIBRATED = 65535;
    public static final short EXPOSURE_PROGRAM_NOT_DEFINED = 0;
    public static final short EXPOSURE_PROGRAM_MANUAL = 1;
    public static final short EXPOSURE_PROGRAM_NORMAL = 2;
    public static final short EXPOSURE_PROGRAM_APERTURE_PRIORITY = 3;
    public static final short EXPOSURE_PROGRAM_SHUTTER_PRIORITY = 4;
    public static final short EXPOSURE_PROGRAM_CREATIVE = 5;
    public static final short EXPOSURE_PROGRAM_ACTION = 6;
    public static final short EXPOSURE_PROGRAM_PORTRAIT_MODE = 7;
    public static final short EXPOSURE_PROGRAM_LANDSCAPE_MODE = 8;
    public static final short SENSITIVITY_TYPE_UNKNOWN = 0;
    public static final short SENSITIVITY_TYPE_SOS = 1;
    public static final short SENSITIVITY_TYPE_REI = 2;
    public static final short SENSITIVITY_TYPE_ISO_SPEED = 3;
    public static final short SENSITIVITY_TYPE_SOS_AND_REI = 4;
    public static final short SENSITIVITY_TYPE_SOS_AND_ISO = 5;
    public static final short SENSITIVITY_TYPE_REI_AND_ISO = 6;
    public static final short SENSITIVITY_TYPE_SOS_AND_REI_AND_ISO = 7;
    public static final short METERING_MODE_UNKNOWN = 0;
    public static final short METERING_MODE_AVERAGE = 1;
    public static final short METERING_MODE_CENTER_WEIGHT_AVERAGE = 2;
    public static final short METERING_MODE_SPOT = 3;
    public static final short METERING_MODE_MULTI_SPOT = 4;
    public static final short METERING_MODE_PATTERN = 5;
    public static final short METERING_MODE_PARTIAL = 6;
    public static final short METERING_MODE_OTHER = 255;
    public static final short LIGHT_SOURCE_UNKNOWN = 0;
    public static final short LIGHT_SOURCE_DAYLIGHT = 1;
    public static final short LIGHT_SOURCE_FLUORESCENT = 2;
    public static final short LIGHT_SOURCE_TUNGSTEN = 3;
    public static final short LIGHT_SOURCE_FLASH = 4;
    public static final short LIGHT_SOURCE_FINE_WEATHER = 9;
    public static final short LIGHT_SOURCE_CLOUDY_WEATHER = 10;
    public static final short LIGHT_SOURCE_SHADE = 11;
    public static final short LIGHT_SOURCE_DAYLIGHT_FLUORESCENT = 12;
    public static final short LIGHT_SOURCE_DAY_WHITE_FLUORESCENT = 13;
    public static final short LIGHT_SOURCE_COOL_WHITE_FLUORESCENT = 14;
    public static final short LIGHT_SOURCE_WHITE_FLUORESCENT = 15;
    public static final short LIGHT_SOURCE_WARM_WHITE_FLUORESCENT = 16;
    public static final short LIGHT_SOURCE_STANDARD_LIGHT_A = 17;
    public static final short LIGHT_SOURCE_STANDARD_LIGHT_B = 18;
    public static final short LIGHT_SOURCE_STANDARD_LIGHT_C = 19;
    public static final short LIGHT_SOURCE_D55 = 20;
    public static final short LIGHT_SOURCE_D65 = 21;
    public static final short LIGHT_SOURCE_D75 = 22;
    public static final short LIGHT_SOURCE_D50 = 23;
    public static final short LIGHT_SOURCE_ISO_STUDIO_TUNGSTEN = 24;
    public static final short LIGHT_SOURCE_OTHER = 255;
    public static final short FLAG_FLASH_FIRED = 1;
    public static final short FLAG_FLASH_RETURN_LIGHT_NOT_DETECTED = 4;
    public static final short FLAG_FLASH_RETURN_LIGHT_DETECTED = 6;
    public static final short FLAG_FLASH_MODE_COMPULSORY_FIRING = 8;
    public static final short FLAG_FLASH_MODE_COMPULSORY_SUPPRESSION = 16;
    public static final short FLAG_FLASH_MODE_AUTO = 24;
    public static final short FLAG_FLASH_NO_FLASH_FUNCTION = 32;
    public static final short FLAG_FLASH_RED_EYE_SUPPORTED = 64;
    public static final short SENSOR_TYPE_NOT_DEFINED = 1;
    public static final short SENSOR_TYPE_ONE_CHIP = 2;
    public static final short SENSOR_TYPE_TWO_CHIP = 3;
    public static final short SENSOR_TYPE_THREE_CHIP = 4;
    public static final short SENSOR_TYPE_COLOR_SEQUENTIAL = 5;
    public static final short SENSOR_TYPE_TRILINEAR = 7;
    public static final short SENSOR_TYPE_COLOR_SEQUENTIAL_LINEAR = 8;
    public static final short FILE_SOURCE_OTHER = 0;
    public static final short FILE_SOURCE_TRANSPARENT_SCANNER = 1;
    public static final short FILE_SOURCE_REFLEX_SCANNER = 2;
    public static final short FILE_SOURCE_DSC = 3;
    public static final short SCENE_TYPE_DIRECTLY_PHOTOGRAPHED = 1;
    public static final short RENDERED_PROCESS_NORMAL = 0;
    public static final short RENDERED_PROCESS_CUSTOM = 1;
    public static final short EXPOSURE_MODE_AUTO = 0;
    public static final short EXPOSURE_MODE_MANUAL = 1;
    public static final short EXPOSURE_MODE_AUTO_BRACKET = 2;
    @Deprecated
    public static final int WHITEBALANCE_AUTO = 0;
    @Deprecated
    public static final int WHITEBALANCE_MANUAL = 1;
    public static final short WHITE_BALANCE_AUTO = 0;
    public static final short WHITE_BALANCE_MANUAL = 1;
    public static final short SCENE_CAPTURE_TYPE_STANDARD = 0;
    public static final short SCENE_CAPTURE_TYPE_LANDSCAPE = 1;
    public static final short SCENE_CAPTURE_TYPE_PORTRAIT = 2;
    public static final short SCENE_CAPTURE_TYPE_NIGHT = 3;
    public static final short GAIN_CONTROL_NONE = 0;
    public static final short GAIN_CONTROL_LOW_GAIN_UP = 1;
    public static final short GAIN_CONTROL_HIGH_GAIN_UP = 2;
    public static final short GAIN_CONTROL_LOW_GAIN_DOWN = 3;
    public static final short GAIN_CONTROL_HIGH_GAIN_DOWN = 4;
    public static final short CONTRAST_NORMAL = 0;
    public static final short CONTRAST_SOFT = 1;
    public static final short CONTRAST_HARD = 2;
    public static final short SATURATION_NORMAL = 0;
    public static final short SATURATION_LOW = 0;
    public static final short SATURATION_HIGH = 0;
    public static final short SHARPNESS_NORMAL = 0;
    public static final short SHARPNESS_SOFT = 1;
    public static final short SHARPNESS_HARD = 2;
    public static final short SUBJECT_DISTANCE_RANGE_UNKNOWN = 0;
    public static final short SUBJECT_DISTANCE_RANGE_MACRO = 1;
    public static final short SUBJECT_DISTANCE_RANGE_CLOSE_VIEW = 2;
    public static final short SUBJECT_DISTANCE_RANGE_DISTANT_VIEW = 3;
    public static final String LATITUDE_NORTH = "N";
    public static final String LATITUDE_SOUTH = "S";
    public static final String LONGITUDE_EAST = "E";
    public static final String LONGITUDE_WEST = "W";
    public static final short ALTITUDE_ABOVE_SEA_LEVEL = 0;
    public static final short ALTITUDE_BELOW_SEA_LEVEL = 1;
    public static final String GPS_MEASUREMENT_IN_PROGRESS = "A";
    public static final String GPS_MEASUREMENT_INTERRUPTED = "V";
    public static final String GPS_MEASUREMENT_2D = "2";
    public static final String GPS_MEASUREMENT_3D = "3";
    public static final String GPS_SPEED_KILOMETERS_PER_HOUR = "K";
    public static final String GPS_SPEED_MILES_PER_HOUR = "M";
    public static final String GPS_SPEED_KNOTS = "N";
    public static final String GPS_DIRECTION_TRUE = "T";
    public static final String GPS_DIRECTION_MAGNETIC = "M";
    public static final String GPS_DISTANCE_KILOMETERS = "K";
    public static final String GPS_DISTANCE_MILES = "M";
    public static final String GPS_DISTANCE_NAUTICAL_MILES = "N";
    public static final short GPS_MEASUREMENT_NO_DIFFERENTIAL = 0;
    public static final short GPS_MEASUREMENT_DIFFERENTIAL_CORRECTED = 1;
    public static final int DATA_UNCOMPRESSED = 1;
    public static final int DATA_HUFFMAN_COMPRESSED = 2;
    public static final int DATA_JPEG = 6;
    public static final int DATA_JPEG_COMPRESSED = 7;
    public static final int DATA_DEFLATE_ZIP = 8;
    public static final int DATA_PACK_BITS_COMPRESSED = 32773;
    public static final int DATA_LOSSY_JPEG = 34892;
    public static final int[] BITS_PER_SAMPLE_RGB;
    public static final int[] BITS_PER_SAMPLE_GREYSCALE_1;
    public static final int[] BITS_PER_SAMPLE_GREYSCALE_2;
    public static final int PHOTOMETRIC_INTERPRETATION_WHITE_IS_ZERO = 0;
    public static final int PHOTOMETRIC_INTERPRETATION_BLACK_IS_ZERO = 1;
    public static final int PHOTOMETRIC_INTERPRETATION_RGB = 2;
    public static final int PHOTOMETRIC_INTERPRETATION_YCBCR = 6;
    public static final int ORIGINAL_RESOLUTION_IMAGE = 0;
    public static final int REDUCED_RESOLUTION_IMAGE = 1;
    public static final int STREAM_TYPE_FULL_IMAGE_DATA = 0;
    public static final int STREAM_TYPE_EXIF_DATA_ONLY = 1;
    private static final int SIGNATURE_CHECK_SIZE = 5000;
    static final byte[] JPEG_SIGNATURE;
    private static final String RAF_SIGNATURE = "FUJIFILMCCD-RAW";
    private static final int RAF_OFFSET_TO_JPEG_IMAGE_OFFSET = 84;
    private static final byte[] HEIF_TYPE_FTYP;
    private static final byte[] HEIF_BRAND_MIF1;
    private static final byte[] HEIF_BRAND_HEIC;
    private static final short ORF_SIGNATURE_1 = 20306;
    private static final short ORF_SIGNATURE_2 = 21330;
    private static final byte[] ORF_MAKER_NOTE_HEADER_1;
    private static final byte[] ORF_MAKER_NOTE_HEADER_2;
    private static final int ORF_MAKER_NOTE_HEADER_1_SIZE = 8;
    private static final int ORF_MAKER_NOTE_HEADER_2_SIZE = 12;
    private static final short RW2_SIGNATURE = 85;
    private static final String PEF_SIGNATURE = "PENTAX";
    private static final int PEF_MAKER_NOTE_SKIP_SIZE = 6;
    private static final byte[] PNG_SIGNATURE;
    private static final byte[] PNG_CHUNK_TYPE_EXIF;
    private static final byte[] PNG_CHUNK_TYPE_IHDR;
    private static final byte[] PNG_CHUNK_TYPE_IEND;
    private static final int PNG_CHUNK_TYPE_BYTE_LENGTH = 4;
    private static final int PNG_CHUNK_CRC_BYTE_LENGTH = 4;
    private static final byte[] WEBP_SIGNATURE_1;
    private static final byte[] WEBP_SIGNATURE_2;
    private static final int WEBP_FILE_SIZE_BYTE_LENGTH = 4;
    private static final byte[] WEBP_CHUNK_TYPE_EXIF;
    private static final byte[] WEBP_VP8_SIGNATURE;
    private static final byte WEBP_VP8L_SIGNATURE = 47;
    private static final byte[] WEBP_CHUNK_TYPE_VP8X;
    private static final byte[] WEBP_CHUNK_TYPE_VP8L;
    private static final byte[] WEBP_CHUNK_TYPE_VP8;
    private static final byte[] WEBP_CHUNK_TYPE_ANIM;
    private static final byte[] WEBP_CHUNK_TYPE_ANMF;
    private static final int WEBP_CHUNK_TYPE_VP8X_DEFAULT_LENGTH = 10;
    private static final int WEBP_CHUNK_TYPE_BYTE_LENGTH = 4;
    private static final int WEBP_CHUNK_SIZE_BYTE_LENGTH = 4;
    private static SimpleDateFormat sFormatterPrimary;
    private static SimpleDateFormat sFormatterSecondary;
    static final short BYTE_ALIGN_II = 18761;
    static final short BYTE_ALIGN_MM = 19789;
    static final byte START_CODE = 42;
    private static final int IFD_OFFSET = 8;
    private static final int IFD_FORMAT_BYTE = 1;
    private static final int IFD_FORMAT_STRING = 2;
    private static final int IFD_FORMAT_USHORT = 3;
    private static final int IFD_FORMAT_ULONG = 4;
    private static final int IFD_FORMAT_URATIONAL = 5;
    private static final int IFD_FORMAT_SBYTE = 6;
    private static final int IFD_FORMAT_UNDEFINED = 7;
    private static final int IFD_FORMAT_SSHORT = 8;
    private static final int IFD_FORMAT_SLONG = 9;
    private static final int IFD_FORMAT_SRATIONAL = 10;
    private static final int IFD_FORMAT_SINGLE = 11;
    private static final int IFD_FORMAT_DOUBLE = 12;
    private static final int IFD_FORMAT_IFD = 13;
    static final String[] IFD_FORMAT_NAMES;
    static final int[] IFD_FORMAT_BYTES_PER_FORMAT;
    static final byte[] EXIF_ASCII_PREFIX;
    private static final ExifTag[] IFD_TIFF_TAGS;
    private static final ExifTag[] IFD_EXIF_TAGS;
    private static final ExifTag[] IFD_GPS_TAGS;
    private static final ExifTag[] IFD_INTEROPERABILITY_TAGS;
    private static final ExifTag[] IFD_THUMBNAIL_TAGS;
    private static final ExifTag TAG_RAF_IMAGE_SIZE;
    private static final ExifTag[] ORF_MAKER_NOTE_TAGS;
    private static final ExifTag[] ORF_CAMERA_SETTINGS_TAGS;
    private static final ExifTag[] ORF_IMAGE_PROCESSING_TAGS;
    private static final ExifTag[] PEF_TAGS;
    static final int IFD_TYPE_PRIMARY = 0;
    private static final int IFD_TYPE_EXIF = 1;
    private static final int IFD_TYPE_GPS = 2;
    private static final int IFD_TYPE_INTEROPERABILITY = 3;
    static final int IFD_TYPE_THUMBNAIL = 4;
    static final int IFD_TYPE_PREVIEW = 5;
    private static final int IFD_TYPE_ORF_MAKER_NOTE = 6;
    private static final int IFD_TYPE_ORF_CAMERA_SETTINGS = 7;
    private static final int IFD_TYPE_ORF_IMAGE_PROCESSING = 8;
    private static final int IFD_TYPE_PEF = 9;
    static final ExifTag[][] EXIF_TAGS;
    private static final ExifTag[] EXIF_POINTER_TAGS;
    private static final ExifTag JPEG_INTERCHANGE_FORMAT_TAG;
    private static final ExifTag JPEG_INTERCHANGE_FORMAT_LENGTH_TAG;
    private static final HashMap<Integer, ExifTag>[] sExifTagMapsForReading;
    private static final HashMap<String, ExifTag>[] sExifTagMapsForWriting;
    private static final HashSet<String> sTagSetForCompatibility;
    private static final HashMap<Integer, Integer> sExifPointerTagMap;
    static final Charset ASCII;
    static final byte[] IDENTIFIER_EXIF_APP1;
    private static final byte[] IDENTIFIER_XMP_APP1;
    static final byte MARKER = -1;
    private static final byte MARKER_SOI = -40;
    private static final byte MARKER_SOF0 = -64;
    private static final byte MARKER_SOF1 = -63;
    private static final byte MARKER_SOF2 = -62;
    private static final byte MARKER_SOF3 = -61;
    private static final byte MARKER_SOF5 = -59;
    private static final byte MARKER_SOF6 = -58;
    private static final byte MARKER_SOF7 = -57;
    private static final byte MARKER_SOF9 = -55;
    private static final byte MARKER_SOF10 = -54;
    private static final byte MARKER_SOF11 = -53;
    private static final byte MARKER_SOF13 = -51;
    private static final byte MARKER_SOF14 = -50;
    private static final byte MARKER_SOF15 = -49;
    private static final byte MARKER_SOS = -38;
    static final byte MARKER_APP1 = -31;
    private static final byte MARKER_COM = -2;
    static final byte MARKER_EOI = -39;
    private static final int IMAGE_TYPE_UNKNOWN = 0;
    private static final int IMAGE_TYPE_ARW = 1;
    private static final int IMAGE_TYPE_CR2 = 2;
    private static final int IMAGE_TYPE_DNG = 3;
    private static final int IMAGE_TYPE_JPEG = 4;
    private static final int IMAGE_TYPE_NEF = 5;
    private static final int IMAGE_TYPE_NRW = 6;
    private static final int IMAGE_TYPE_ORF = 7;
    private static final int IMAGE_TYPE_PEF = 8;
    private static final int IMAGE_TYPE_RAF = 9;
    private static final int IMAGE_TYPE_RW2 = 10;
    private static final int IMAGE_TYPE_SRW = 11;
    private static final int IMAGE_TYPE_HEIF = 12;
    private static final int IMAGE_TYPE_PNG = 13;
    private static final int IMAGE_TYPE_WEBP = 14;
    private static final Pattern NON_ZERO_TIME_PATTERN;
    private static final Pattern GPS_TIMESTAMP_PATTERN;
    private static final Pattern DATETIME_PRIMARY_FORMAT_PATTERN;
    private static final Pattern DATETIME_SECONDARY_FORMAT_PATTERN;
    private static final int DATETIME_VALUE_STRING_LENGTH = 19;
    private String mFilename;
    private FileDescriptor mSeekableFileDescriptor;
    private AssetManager.AssetInputStream mAssetInputStream;
    private int mMimeType;
    private boolean mIsExifDataOnly;
    private final HashMap<String, ExifAttribute>[] mAttributes;
    private Set<Integer> mAttributesOffsets;
    private ByteOrder mExifByteOrder;
    private boolean mHasThumbnail;
    private boolean mHasThumbnailStrips;
    private boolean mAreThumbnailStripsConsecutive;
    private int mThumbnailOffset;
    private int mThumbnailLength;
    private byte[] mThumbnailBytes;
    private int mThumbnailCompression;
    private int mOffsetToExifData;
    private int mOrfMakerNoteOffset;
    private int mOrfThumbnailOffset;
    private int mOrfThumbnailLength;
    private boolean mModified;
    private boolean mXmpIsFromSeparateMarker;

    public ExifInterface(File file) throws IOException {
        ExifTag[][] exifTagArray = EXIF_TAGS;
        this.mAttributes = new HashMap[EXIF_TAGS.length];
        this.mAttributesOffsets = new HashSet<Integer>(exifTagArray.length);
        this.mExifByteOrder = ByteOrder.BIG_ENDIAN;
        if (file != null) {
            this.initForFilename(file.getAbsolutePath());
            return;
        }
        throw new NullPointerException("file cannot be null");
    }

    public ExifInterface(String string2) throws IOException {
        ExifTag[][] exifTagArray = EXIF_TAGS;
        this.mAttributes = new HashMap[EXIF_TAGS.length];
        this.mAttributesOffsets = new HashSet<Integer>(exifTagArray.length);
        this.mExifByteOrder = ByteOrder.BIG_ENDIAN;
        if (string2 != null) {
            this.initForFilename(string2);
            return;
        }
        throw new NullPointerException("filename cannot be null");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExifInterface(FileDescriptor fileDescriptor) throws IOException {
        void var0_4;
        FileInputStream fileInputStream;
        boolean bl;
        block12: {
            FileInputStream fileInputStream2;
            ExifInterface exifInterface;
            FileInputStream fileInputStream3;
            ExifTag[][] exifTagArray = EXIF_TAGS;
            this.mAttributes = new HashMap[EXIF_TAGS.length];
            this.mAttributesOffsets = new HashSet<Integer>(exifTagArray.length);
            this.mExifByteOrder = ByteOrder.BIG_ENDIAN;
            if (fileDescriptor == null) {
                throw new NullPointerException("fileDescriptor cannot be null");
            }
            ExifInterface exifInterface2 = this;
            exifInterface2.mAssetInputStream = null;
            exifInterface2.mFilename = null;
            bl = false;
            if (Build.VERSION.SDK_INT >= 21 && ExifInterface.isSeekableFD(fileDescriptor)) {
                this.mSeekableFileDescriptor = fileDescriptor;
                try {
                    fileDescriptor = Os.dup((FileDescriptor)fileDescriptor);
                    bl = true;
                }
                catch (Exception exception) {
                    throw new IOException("Failed to duplicate file descriptor", exception);
                }
            } else {
                this.mSeekableFileDescriptor = null;
            }
            Object var3_8 = null;
            fileInputStream = fileInputStream3;
            try {
                exifInterface = this;
                FileInputStream fileInputStream4 = fileInputStream;
                fileInputStream2 = fileInputStream4;
                fileInputStream4(fileDescriptor);
            }
            catch (Throwable throwable) {
                fileInputStream = var3_8;
                break block12;
            }
            try {
                exifInterface.loadAttributes(fileInputStream2);
            }
            catch (Throwable throwable) {
                break block12;
            }
            ExifInterface.closeQuietly(fileInputStream3);
            if (bl) {
                ExifInterface.closeFileDescriptor(fileDescriptor);
            }
            return;
        }
        ExifInterface.closeQuietly(fileInputStream);
        if (bl) {
            ExifInterface.closeFileDescriptor(fileDescriptor);
        }
        throw var0_4;
    }

    public ExifInterface(InputStream inputStream) throws IOException {
        this(inputStream, 0);
    }

    public ExifInterface(InputStream inputStream, int n2) throws IOException {
        ExifTag[][] exifTagArray = EXIF_TAGS;
        this.mAttributes = new HashMap[EXIF_TAGS.length];
        this.mAttributesOffsets = new HashSet<Integer>(exifTagArray.length);
        this.mExifByteOrder = ByteOrder.BIG_ENDIAN;
        if (inputStream != null) {
            InputStream inputStream2;
            this.mFilename = null;
            if (n2 == 1) {
                BufferedInputStream bufferedInputStream;
                inputStream2 = bufferedInputStream;
                if (!ExifInterface.isExifDataOnly(new BufferedInputStream(inputStream, 5000))) {
                    Log.w((String)TAG, (String)"Given data does not follow the structure of an Exif-only data.");
                    return;
                }
                ExifInterface exifInterface = this;
                exifInterface.mIsExifDataOnly = true;
                exifInterface.mAssetInputStream = null;
                exifInterface.mSeekableFileDescriptor = null;
            } else {
                FileInputStream fileInputStream;
                if (inputStream instanceof AssetManager.AssetInputStream) {
                    ExifInterface exifInterface = this;
                    exifInterface.mAssetInputStream = (AssetManager.AssetInputStream)inputStream;
                    exifInterface.mSeekableFileDescriptor = null;
                } else if (inputStream instanceof FileInputStream && ExifInterface.isSeekableFD((fileInputStream = (FileInputStream)inputStream).getFD())) {
                    this.mAssetInputStream = null;
                    this.mSeekableFileDescriptor = fileInputStream.getFD();
                } else {
                    ExifInterface exifInterface = this;
                    exifInterface.mAssetInputStream = null;
                    exifInterface.mSeekableFileDescriptor = null;
                }
                inputStream2 = inputStream;
            }
            this.loadAttributes(inputStream2);
            return;
        }
        throw new NullPointerException("inputStream cannot be null");
    }

    public static boolean isSupportedMimeType(String string2) {
        if (string2 != null) {
            string2 = string2.toLowerCase(Locale.ROOT);
            string2.hashCode();
            int n2 = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 2111234748: {
                    if (!string2.equals("image/x-canon-cr2")) break;
                    n2 = 14;
                    break;
                }
                case 2099152524: {
                    if (!string2.equals("image/x-nikon-nrw")) break;
                    n2 = 13;
                    break;
                }
                case 2099152104: {
                    if (!string2.equals("image/x-nikon-nef")) break;
                    n2 = 12;
                    break;
                }
                case 1378106698: {
                    if (!string2.equals("image/x-olympus-orf")) break;
                    n2 = 11;
                    break;
                }
                case -332763809: {
                    if (!string2.equals("image/x-pentax-pef")) break;
                    n2 = 10;
                    break;
                }
                case -879258763: {
                    if (!string2.equals("image/png")) break;
                    n2 = 9;
                    break;
                }
                case -985160897: {
                    if (!string2.equals("image/x-panasonic-rw2")) break;
                    n2 = 8;
                    break;
                }
                case -1423313290: {
                    if (!string2.equals("image/x-adobe-dng")) break;
                    n2 = 7;
                    break;
                }
                case -1487018032: {
                    if (!string2.equals("image/webp")) break;
                    n2 = 6;
                    break;
                }
                case -1487394660: {
                    if (!string2.equals("image/jpeg")) break;
                    n2 = 5;
                    break;
                }
                case -1487464690: {
                    if (!string2.equals("image/heif")) break;
                    n2 = 4;
                    break;
                }
                case -1487464693: {
                    if (!string2.equals("image/heic")) break;
                    n2 = 3;
                    break;
                }
                case -1594371159: {
                    if (!string2.equals("image/x-sony-arw")) break;
                    n2 = 2;
                    break;
                }
                case -1635437028: {
                    if (!string2.equals("image/x-samsung-srw")) break;
                    n2 = 1;
                    break;
                }
                case -1875291391: {
                    if (!string2.equals("image/x-fuji-raf")) break;
                    n2 = 0;
                }
            }
            switch (n2) {
                default: {
                    return false;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
            }
            return true;
        }
        throw new NullPointerException("mimeType shouldn't be null");
    }

    private ExifAttribute getExifAttribute(String string2) {
        if (string2 != null) {
            if (TAG_ISO_SPEED_RATINGS.equals(string2)) {
                if (DEBUG) {
                    Log.d((String)TAG, (String)"getExifAttribute: Replacing TAG_ISO_SPEED_RATINGS with TAG_PHOTOGRAPHIC_SENSITIVITY.");
                }
                string2 = TAG_PHOTOGRAPHIC_SENSITIVITY;
            }
            for (int i2 = 0; i2 < EXIF_TAGS.length; ++i2) {
                ExifAttribute exifAttribute = this.mAttributes[i2].get(string2);
                if (exifAttribute == null) continue;
                return exifAttribute;
            }
            return null;
        }
        throw new NullPointerException("tag shouldn't be null");
    }

    private void removeAttribute(String string2) {
        for (int i2 = 0; i2 < EXIF_TAGS.length; ++i2) {
            this.mAttributes[i2].remove(string2);
        }
    }

    /*
     * Exception decompiling
     */
    private void loadAttributes(InputStream var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 15[TRYBLOCK] [30 : 326->329)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isSeekableFD(FileDescriptor fileDescriptor) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Os.lseek((FileDescriptor)fileDescriptor, (long)0L, (int)OsConstants.SEEK_CUR);
            }
            catch (Exception exception) {
                if (DEBUG) {
                    Log.d((String)TAG, (String)"The file descriptor for the given input is not seekable");
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void printAttributes() {
        for (int i2 = 0; i2 < this.mAttributes.length; ++i2) {
            Log.d((String)TAG, (String)("The size of tag group[" + i2 + "]: " + this.mAttributes[i2].size()));
            for (Map.Entry<String, ExifAttribute> entry : this.mAttributes[i2].entrySet()) {
                ExifAttribute exifAttribute = entry.getValue();
                Log.d((String)TAG, (String)("tagName: " + entry.getKey() + ", tagType: " + exifAttribute.toString() + ", tagValue: '" + exifAttribute.getStringValue(this.mExifByteOrder) + "'"));
            }
        }
    }

    private static Long parseDateTime(String string2, String string3, String string4) {
        if (string2 != null && NON_ZERO_TIME_PATTERN.matcher(string2).matches()) {
            long l2;
            block19: {
                int n2;
                int n3;
                block20: {
                    Date date;
                    block18: {
                        ParsePosition parsePosition;
                        ParsePosition parsePosition2 = parsePosition;
                        parsePosition = new ParsePosition(0);
                        date = sFormatterPrimary.parse(string2, parsePosition2);
                        if (date != null) break block18;
                        date = sFormatterSecondary.parse(string2, parsePosition2);
                        if (date != null) break block18;
                        return null;
                    }
                    l2 = date.getTime();
                    if (string4 == null) break block19;
                    String string5 = string4;
                    String string6 = string5;
                    String string7 = string5;
                    string2 = string5.substring(0, 1);
                    n3 = Integer.parseInt(string7.substring(1, 3));
                    n2 = Integer.parseInt(string6.substring(4, 6));
                    if ("+".equals(string2)) break block20;
                    if (!"-".equals(string2)) break block19;
                }
                if (!":".equals(string4.substring(3, 4)) || n3 > 14) break block19;
                int n4 = (n3 * 60 + n2) * 60 * 1000;
                int n5 = "-".equals(string2) ? 1 : -1;
                l2 += (long)(n4 * n5);
            }
            if (string3 != null) {
                long l3;
                long l4;
                try {
                    l4 = Long.parseLong(string3);
                }
                catch (NumberFormatException numberFormatException) {}
                while ((l3 = l4) > 1000L) {
                    l4 = l3 / 10L;
                }
                l2 += l3;
            }
            try {
                return l2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initForFilename(String string2) throws IOException {
        Throwable throwable2;
        FileInputStream fileInputStream;
        block6: {
            FileInputStream fileInputStream2;
            if (string2 == null) {
                throw new NullPointerException("filename cannot be null");
            }
            FileInputStream fileInputStream3 = null;
            this.mAssetInputStream = null;
            this.mFilename = string2;
            fileInputStream = fileInputStream2;
            try {
                fileInputStream2 = new FileInputStream(string2);
            }
            catch (Throwable throwable2) {
                fileInputStream = fileInputStream3;
                break block6;
            }
            try {
                this.mSeekableFileDescriptor = ExifInterface.isSeekableFD(fileInputStream2.getFD()) ? fileInputStream.getFD() : null;
                this.loadAttributes(fileInputStream);
                ExifInterface.closeQuietly(fileInputStream);
                return;
            }
            catch (Throwable throwable2) {}
        }
        ExifInterface.closeQuietly(fileInputStream);
        throw throwable2;
    }

    private static double convertRationalLatLonToDouble(String stringArray, String string2) {
        block16: {
            double d2;
            block14: {
                block15: {
                    String string3 = string2;
                    stringArray = stringArray.split(",", -1);
                    String[] stringArray2 = stringArray[0].split("/", -1);
                    double d3 = Double.parseDouble(stringArray2[0].trim()) / Double.parseDouble(stringArray2[1].trim());
                    stringArray2 = stringArray[1].split("/", -1);
                    double d4 = Double.parseDouble(stringArray2[0].trim()) / Double.parseDouble(stringArray2[1].trim());
                    stringArray = stringArray[2].split("/", -1);
                    d2 = Double.parseDouble(stringArray[0].trim()) / Double.parseDouble(stringArray[1].trim());
                    d2 = d3 + d4 / 60.0 + d2 / 3600.0;
                    if (string3.equals(LATITUDE_SOUTH)) break block14;
                    if (string2.equals(LONGITUDE_WEST)) break block14;
                    if (string2.equals("N")) break block15;
                    if (string2.equals(LONGITUDE_EAST)) break block15;
                    try {
                        throw new IllegalArgumentException();
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        break block16;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                return d2;
            }
            return -d2;
        }
        throw new IllegalArgumentException();
    }

    private String convertDecimalDegree(double d2) {
        StringBuilder stringBuilder;
        double d3 = d2;
        long l2 = (long)d3;
        double d4 = d3 - (double)l2;
        long l3 = (long)(d4 * 60.0);
        long l4 = Math.round((d4 - (double)l3 / 60.0) * 3600.0 * 1.0E7);
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        return stringBuilder.append(l2).append("/1,").append(l3).append("/1,").append(l4).append("/10000000").toString();
    }

    private int getMimeType(BufferedInputStream object) throws IOException {
        BufferedInputStream bufferedInputStream = object;
        bufferedInputStream.mark(5000);
        byte[] byArray = new byte[5000];
        object = byArray;
        bufferedInputStream.read(byArray);
        bufferedInputStream.reset();
        if (ExifInterface.isJpegFormat((byte[])object)) {
            return 4;
        }
        if (this.isRafFormat((byte[])object)) {
            return 9;
        }
        if (this.isHeifFormat((byte[])object)) {
            return 12;
        }
        if (this.isOrfFormat((byte[])object)) {
            return 7;
        }
        if (this.isRw2Format((byte[])object)) {
            return 10;
        }
        if (this.isPngFormat((byte[])object)) {
            return 13;
        }
        if (this.isWebpFormat((byte[])object)) {
            return 14;
        }
        return 0;
    }

    private static boolean isJpegFormat(byte[] byArray) throws IOException {
        int n2 = 0;
        while (true) {
            byte[] byArray2 = JPEG_SIGNATURE;
            if (n2 >= JPEG_SIGNATURE.length) break;
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isRafFormat(byte[] byArray) throws IOException {
        Object object = RAF_SIGNATURE.getBytes(Charset.defaultCharset());
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            if (byArray[i2] == object[i2]) continue;
            return false;
        }
        return true;
    }

    /*
     * Loose catch block
     */
    private boolean isHeifFormat(byte[] object) throws IOException {
        Object object2;
        block38: {
            block41: {
                block34: {
                    block40: {
                        block39: {
                            long l2;
                            boolean bl;
                            boolean bl2;
                            byte[] byArray;
                            long l3;
                            long l4;
                            long l5;
                            block33: {
                                block31: {
                                    ByteOrderedDataInputStream byteOrderedDataInputStream;
                                    ExifInterface exifInterface = null;
                                    object2 = byteOrderedDataInputStream;
                                    byteOrderedDataInputStream = new ByteOrderedDataInputStream((byte[])object);
                                    l5 = byteOrderedDataInputStream.readInt();
                                    byte[] byArray2 = new byte[4];
                                    ((InputStream)object2).read(byArray2);
                                    if (Arrays.equals(byArray2, HEIF_TYPE_FTYP)) break block31;
                                    ((InputStream)object2).close();
                                    return false;
                                }
                                l4 = 8L;
                                if (l5 == 1L) {
                                    block32: {
                                        l5 = ((ByteOrderedDataInputStream)object2).readLong();
                                        if (l5 >= 16L) break block32;
                                        ((InputStream)object2).close();
                                        return false;
                                    }
                                    l4 = 16L;
                                }
                                if (l5 <= (long)((byte[])object).length) break block33;
                                l5 = ((byte[])object).length;
                            }
                            if ((l3 = l5 - l4) < 8L) {
                                ((InputStream)object2).close();
                                return false;
                            }
                            int n2 = 4;
                            try {
                                byArray = new byte[4];
                                bl2 = false;
                                bl = false;
                                l2 = 0L;
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                break block38;
                            }
                            catch (Exception exception) {
                                object = exception;
                                break block39;
                            }
                            while (true) {
                                block35: {
                                    if (l2 >= l3 / 4L) break block34;
                                    if (((InputStream)object2).read(byArray) == n2) break block35;
                                    ((InputStream)object2).close();
                                    return false;
                                }
                                if (l2 != 1L) {
                                    block37: {
                                        block36: {
                                            if (!Arrays.equals(byArray, HEIF_BRAND_MIF1)) break block36;
                                            bl2 = true;
                                            break block37;
                                        }
                                        if (!Arrays.equals(byArray, HEIF_BRAND_HEIC)) break block37;
                                        bl = true;
                                    }
                                    if (bl2 && bl) {
                                        ((InputStream)object2).close();
                                        return true;
                                    }
                                }
                                ++l2;
                            }
                            catch (Throwable throwable) {
                                object2 = exifInterface;
                                break block38;
                            }
                            catch (Exception exception) {
                                object2 = exifInterface;
                            }
                        }
                        if (!DEBUG) break block40;
                        try {
                            Log.d((String)TAG, (String)"Exception parsing HEIF file type box.", (Throwable)object);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (object2 == null) break block41;
                }
                ((InputStream)object2).close();
            }
            return false;
        }
        if (object2 != null) {
            ((InputStream)object2).close();
        }
        throw object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isOrfFormat(byte[] byArray) throws IOException {
        ByteOrderedDataInputStream byteOrderedDataInputStream;
        block12: {
            void var0_8;
            block11: {
                void var0_5;
                block13: {
                    ByteOrder bl;
                    ByteOrderedDataInputStream byteOrderedDataInputStream2;
                    ExifInterface exifInterface;
                    ByteOrderedDataInputStream byteOrderedDataInputStream3;
                    Object var2_11 = null;
                    byteOrderedDataInputStream = byteOrderedDataInputStream3;
                    try {
                        void var1_10;
                        ExifInterface byteOrder;
                        ExifInterface exifInterface2 = byteOrder;
                        exifInterface = exifInterface2;
                        ExifInterface exifInterface3 = exifInterface2;
                        ByteOrderedDataInputStream byteOrderedDataInputStream4 = byteOrderedDataInputStream;
                        byteOrderedDataInputStream2 = byteOrderedDataInputStream4;
                        byteOrderedDataInputStream4((byte[])var1_10);
                    }
                    catch (Throwable throwable) {
                        byteOrderedDataInputStream = var2_11;
                        break block11;
                    }
                    catch (Exception exception) {
                        byteOrderedDataInputStream = var2_11;
                        break block12;
                    }
                    try {
                        bl = exifInterface.readByteOrder(byteOrderedDataInputStream2);
                    }
                    catch (Throwable throwable) {
                        break block11;
                    }
                    catch (Exception exception) {
                        break block12;
                    }
                    {
                        exifInterface3.mExifByteOrder = bl;
                        byteOrderedDataInputStream3.setByteOrder(bl);
                        short throwable = byteOrderedDataInputStream3.readShort();
                        if (throwable != 20306 && throwable != 21330) {
                            boolean throwable2 = false;
                            break block13;
                        }
                        boolean bl2 = true;
                    }
                }
                byteOrderedDataInputStream.close();
                return (boolean)var0_5;
            }
            if (byteOrderedDataInputStream != null) {
                byteOrderedDataInputStream.close();
            }
            throw var0_8;
        }
        if (byteOrderedDataInputStream != null) {
            byteOrderedDataInputStream.close();
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRw2Format(byte[] byArray) throws IOException {
        ByteOrderedDataInputStream byteOrderedDataInputStream;
        block11: {
            void var0_4;
            block10: {
                boolean bl;
                ByteOrderedDataInputStream byteOrderedDataInputStream2;
                ExifInterface exifInterface;
                ByteOrder byteOrder;
                ByteOrderedDataInputStream byteOrderedDataInputStream3;
                Object var2_6 = null;
                byteOrderedDataInputStream = byteOrderedDataInputStream3;
                try {
                    ExifInterface exifInterface2 = byteOrder;
                    exifInterface = exifInterface2;
                    ExifInterface exifInterface3 = exifInterface2;
                    ByteOrderedDataInputStream byteOrderedDataInputStream4 = byteOrderedDataInputStream;
                    byteOrderedDataInputStream2 = byteOrderedDataInputStream4;
                    byteOrderedDataInputStream4(byArray);
                }
                catch (Throwable throwable) {
                    byteOrderedDataInputStream = var2_6;
                    break block10;
                }
                catch (Exception exception) {
                    byteOrderedDataInputStream = var2_6;
                    break block11;
                }
                try {
                    byteOrder = exifInterface.readByteOrder(byteOrderedDataInputStream2);
                }
                catch (Throwable throwable) {
                    break block10;
                }
                catch (Exception exception) {
                    break block11;
                }
                {
                    exifInterface3.mExifByteOrder = byteOrder;
                    byteOrderedDataInputStream3.setByteOrder(byteOrder);
                    bl = byteOrderedDataInputStream3.readShort() == 85;
                }
                byteOrderedDataInputStream.close();
                return bl;
            }
            if (byteOrderedDataInputStream != null) {
                byteOrderedDataInputStream.close();
            }
            throw var0_4;
        }
        if (byteOrderedDataInputStream != null) {
            byteOrderedDataInputStream.close();
        }
        return false;
    }

    private boolean isPngFormat(byte[] byArray) throws IOException {
        int n2 = 0;
        while (true) {
            byte[] byArray2 = PNG_SIGNATURE;
            if (n2 >= PNG_SIGNATURE.length) break;
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isWebpFormat(byte[] byArray) throws IOException {
        byte[] byArray2;
        int n2 = 0;
        while (true) {
            byArray2 = WEBP_SIGNATURE_1;
            if (n2 >= WEBP_SIGNATURE_1.length) break;
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        n2 = 0;
        while (true) {
            byArray2 = WEBP_SIGNATURE_2;
            if (n2 >= WEBP_SIGNATURE_2.length) break;
            if (byArray[n2 + WEBP_SIGNATURE_1.length + 4] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isExifDataOnly(BufferedInputStream object) throws IOException {
        BufferedInputStream bufferedInputStream = object;
        object = IDENTIFIER_EXIF_APP1;
        bufferedInputStream.mark(IDENTIFIER_EXIF_APP1.length);
        byte[] byArray = new byte[((Object)object).length];
        object = byArray;
        bufferedInputStream.read(byArray);
        bufferedInputStream.reset();
        int n2 = 0;
        while (true) {
            byte[] byArray2 = IDENTIFIER_EXIF_APP1;
            if (n2 >= IDENTIFIER_EXIF_APP1.length) break;
            if (object[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getJpegAttributes(ByteOrderedDataInputStream byteOrderedDataInputStream, int n2, int n3) throws IOException {
        if (DEBUG) {
            Log.d((String)TAG, (String)("getJpegAttributes starting with: " + byteOrderedDataInputStream));
        }
        ByteOrderedDataInputStream byteOrderedDataInputStream2 = byteOrderedDataInputStream;
        byteOrderedDataInputStream2.mark(0);
        byteOrderedDataInputStream2.setByteOrder(ByteOrder.BIG_ENDIAN);
        int n4 = byteOrderedDataInputStream2.readByte();
        if (n4 != -1) {
            throw new IOException("Invalid marker: " + Integer.toHexString(n4 & 0xFF));
        }
        if (byteOrderedDataInputStream.readByte() != -40) {
            throw new IOException("Invalid marker: " + Integer.toHexString(n4 & 0xFF));
        }
        n4 = 2;
        while (true) {
            int n5;
            int n6;
            byte by;
            if ((by = byteOrderedDataInputStream.readByte()) != -1) {
                throw new IOException("Invalid marker:" + Integer.toHexString(by & 0xFF));
            }
            ++n4;
            by = byteOrderedDataInputStream.readByte();
            int n7 = DEBUG;
            if (n7 != 0) {
                Log.d((String)TAG, (String)("Found JPEG segment indicator: " + Integer.toHexString(by & 0xFF)));
            }
            ++n4;
            if (by == -39 || by == -38) break;
            int n8 = n7;
            n7 = byteOrderedDataInputStream.readUnsignedShort() - 2;
            n4 += 2;
            if (n8 != 0) {
                Log.d((String)TAG, (String)("JPEG segment: " + Integer.toHexString(by & 0xFF) + " (length: " + (n7 + 2) + ")"));
            }
            if (n7 < 0) {
                throw new IOException("Invalid length");
            }
            switch (by) {
                case -2: {
                    byte[] byArray = new byte[n7];
                    if (byteOrderedDataInputStream.read(byArray) != n7) {
                        throw new IOException("Invalid exif");
                    }
                    n7 = 0;
                    if (this.getAttribute(TAG_USER_COMMENT) == null) {
                        this.mAttributes[1].put(TAG_USER_COMMENT, ExifAttribute.createString(new String(byArray, ASCII)));
                    }
                }
                default: {
                    n6 = n4;
                    n5 = n7;
                    break;
                }
                case -31: {
                    ExifAttribute exifAttribute;
                    byte[] byArray = new byte[n7];
                    byteOrderedDataInputStream.readFully(byArray);
                    n6 = n4 + n7;
                    n5 = 0;
                    byte[] byArray2 = IDENTIFIER_EXIF_APP1;
                    if (ExifInterface.startsWith(byArray, IDENTIFIER_EXIF_APP1)) {
                        ExifInterface exifInterface = this;
                        byte[] byArray3 = Arrays.copyOfRange(byArray, byArray2.length, n7);
                        exifInterface.mOffsetToExifData = n2 + n4 + byArray2.length;
                        exifInterface.readExifSegment(byArray3, n3);
                        exifInterface.setThumbnailData(new ByteOrderedDataInputStream(byArray3));
                        break;
                    }
                    byArray2 = IDENTIFIER_XMP_APP1;
                    if (!ExifInterface.startsWith(byArray, IDENTIFIER_XMP_APP1)) break;
                    n4 += byArray2.length;
                    byArray = Arrays.copyOfRange(byArray, byArray2.length, n7);
                    if (this.getAttribute(TAG_XMP) != null) break;
                    ExifAttribute exifAttribute2 = exifAttribute;
                    int n9 = n4;
                    n4 = byArray.length;
                    long l2 = n9;
                    exifAttribute = new ExifAttribute(1, n4, l2, byArray);
                    this.mAttributes[0].put(TAG_XMP, exifAttribute2);
                    this.mXmpIsFromSeparateMarker = true;
                    break;
                }
                case -64: 
                case -63: 
                case -62: 
                case -61: 
                case -59: 
                case -58: 
                case -57: 
                case -55: 
                case -54: 
                case -53: 
                case -51: 
                case -50: 
                case -49: {
                    if (byteOrderedDataInputStream.skipBytes(1) != 1) {
                        throw new IOException("Invalid SOFx");
                    }
                    ExifInterface exifInterface = this;
                    exifInterface.mAttributes[n3].put(TAG_IMAGE_LENGTH, ExifAttribute.createULong(byteOrderedDataInputStream.readUnsignedShort(), this.mExifByteOrder));
                    exifInterface.mAttributes[n3].put(TAG_IMAGE_WIDTH, ExifAttribute.createULong(byteOrderedDataInputStream.readUnsignedShort(), this.mExifByteOrder));
                    n5 = n7 + -5;
                    n6 = n4;
                    break;
                }
            }
            if (n5 < 0) {
                throw new IOException("Invalid length");
            }
            if (byteOrderedDataInputStream.skipBytes(n5) != n5) {
                throw new IOException("Invalid JPEG segment");
            }
            n4 = n6 + n5;
        }
        byteOrderedDataInputStream.setByteOrder(this.mExifByteOrder);
    }

    private void getRawAttributes(ByteOrderedDataInputStream object) throws IOException {
        ExifInterface exifInterface = this;
        ByteOrderedDataInputStream byteOrderedDataInputStream = object;
        this.parseTiffHeaders(byteOrderedDataInputStream, byteOrderedDataInputStream.available());
        this.readImageFileDirectory((ByteOrderedDataInputStream)object, 0);
        this.updateImageSizeValues((ByteOrderedDataInputStream)object, 0);
        this.updateImageSizeValues((ByteOrderedDataInputStream)object, 5);
        exifInterface.updateImageSizeValues((ByteOrderedDataInputStream)object, 4);
        exifInterface.validateImages();
        if (exifInterface.mMimeType == 8 && (object = this.mAttributes[1].get(TAG_MAKER_NOTE)) != null) {
            ExifInterface exifInterface2 = this;
            ByteOrderedDataInputStream byteOrderedDataInputStream2 = new ByteOrderedDataInputStream(((ExifAttribute)object).bytes);
            byteOrderedDataInputStream2.setByteOrder(this.mExifByteOrder);
            byteOrderedDataInputStream2.seek(6L);
            exifInterface2.readImageFileDirectory(byteOrderedDataInputStream2, 9);
            object = exifInterface2.mAttributes[9].get(TAG_COLOR_SPACE);
            if (object != null) {
                this.mAttributes[1].put(TAG_COLOR_SPACE, (ExifAttribute)object);
            }
        }
    }

    private void getRafAttributes(ByteOrderedDataInputStream byteOrderedDataInputStream) throws IOException {
        boolean bl = DEBUG;
        if (bl) {
            Log.d((String)TAG, (String)("getRafAttributes starting with: " + byteOrderedDataInputStream));
        }
        ByteOrderedDataInputStream byteOrderedDataInputStream2 = byteOrderedDataInputStream;
        ByteOrderedDataInputStream byteOrderedDataInputStream3 = byteOrderedDataInputStream;
        byteOrderedDataInputStream3.mark(0);
        byteOrderedDataInputStream3.skipBytes(84);
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        byteOrderedDataInputStream3.read(byArray);
        byteOrderedDataInputStream3.read(byArray2);
        byteOrderedDataInputStream3.read(byArray3);
        int n2 = ByteBuffer.wrap(byArray).getInt();
        int n3 = ByteBuffer.wrap(byArray3).getInt();
        byArray3 = new byte[ByteBuffer.wrap(byArray2).getInt()];
        byteOrderedDataInputStream3.seek(n2);
        byteOrderedDataInputStream3.read(byArray3);
        ((ExifInterface)((Object)exifAttribute)).getJpegAttributes(new ByteOrderedDataInputStream(byArray3), n2, 5);
        byteOrderedDataInputStream2.seek(n3);
        byteOrderedDataInputStream2.setByteOrder(ByteOrder.BIG_ENDIAN);
        n2 = byteOrderedDataInputStream2.readInt();
        if (bl) {
            Log.d((String)TAG, (String)("numberOfDirectoryEntry: " + n2));
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = byteOrderedDataInputStream.readUnsignedShort();
            if (byteOrderedDataInputStream.readUnsignedShort() == ExifInterface.TAG_RAF_IMAGE_SIZE.number) {
                ExifInterface exifInterface = exifAttribute;
                ByteOrderedDataInputStream byteOrderedDataInputStream4 = byteOrderedDataInputStream;
                short s = byteOrderedDataInputStream4.readShort();
                short s2 = byteOrderedDataInputStream4.readShort();
                n2 = s2;
                ExifInterface exifInterface2 = exifAttribute;
                ExifAttribute exifAttribute = ExifAttribute.createUShort(s, ((ExifInterface)((Object)exifAttribute)).mExifByteOrder);
                ExifAttribute exifAttribute2 = ExifAttribute.createUShort(s2, exifInterface2.mExifByteOrder);
                exifInterface.mAttributes[0].put(TAG_IMAGE_LENGTH, exifAttribute);
                exifInterface.mAttributes[0].put(TAG_IMAGE_WIDTH, exifAttribute2);
                if (DEBUG) {
                    Log.d((String)TAG, (String)("Updated to length: " + s + ", width: " + n2));
                }
                return;
            }
            byteOrderedDataInputStream.skipBytes(n4);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void getHeifAttributes(ByteOrderedDataInputStream var1_1) throws IOException {
        block40: {
            block44: {
                block45: {
                    block42: {
                        block41: {
                            var2_2 = v0;
                            v0 = new MediaMetadataRetriever();
                            if (Build.VERSION.SDK_INT < 23) ** GOTO lbl8
                            var2_2.setDataSource(new MediaDataSource((ByteOrderedDataInputStream)var1_1){
                                long mPosition;
                                final /* synthetic */ ByteOrderedDataInputStream val$in;
                                {
                                    this.val$in = byteOrderedDataInputStream;
                                }

                                public void close() throws IOException {
                                }

                                /*
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                public int readAt(long l2, byte[] byArray, int n2, int n3) throws IOException {
                                    if (n3 == 0) {
                                        return 0;
                                    }
                                    if (l2 < 0L) {
                                        return -1;
                                    }
                                    try {
                                        int n4;
                                        long l3 = this.mPosition;
                                        if (l3 != l2) {
                                            if (l3 >= 0L && l2 >= l3 + (long)this.val$in.available()) {
                                                return -1;
                                            }
                                            this.val$in.seek(l2);
                                            this.mPosition = l2;
                                        }
                                        if (n3 > this.val$in.available()) {
                                            n3 = this.val$in.available();
                                        }
                                        if ((n4 = this.val$in.read(byArray, n2, n3)) >= 0) {
                                            this.mPosition += (long)n4;
                                            return n4;
                                        }
                                    }
                                    catch (IOException iOException) {}
                                    this.mPosition = -1L;
                                    return -1;
                                }

                                public long getSize() throws IOException {
                                    return -1L;
                                }
                            });
                            ** GOTO lbl17
lbl8:
                            // 1 sources

                            var3_3 = this.mSeekableFileDescriptor;
                            if (var3_3 == null) ** GOTO lbl13
                            var2_2.setDataSource((FileDescriptor)var3_3);
                            ** GOTO lbl17
lbl13:
                            // 1 sources

                            var3_3 = this.mFilename;
                            if (var3_3 == null) break block40;
                            var2_2.setDataSource((String)var3_3);
lbl17:
                            // 3 sources

                            v1 = var2_2;
                            v2 = v1;
                            v3 = v1;
                            v4 = v1;
                            var3_3 = v1.extractMetadata(33);
                            var4_5 = v2.extractMetadata(34);
                            var5_7 = v3.extractMetadata(26);
                            var6_9 = v4.extractMetadata(17);
                            var7_11 = null;
                            var8_12 = null;
                            var9_13 = null;
                            if (!"yes".equals(var5_7)) break block41;
                            v5 = var2_2;
                            v6 = v5;
                            v7 = v5;
                            var7_11 = v5.extractMetadata(29);
                            var8_12 = v7.extractMetadata(30);
                            v8 = v6.extractMetadata(31);
lbl42:
                            // 2 sources

                            while (true) {
                                var9_13 = v8;
                                break block42;
                                break;
                            }
                        }
                        try {
                            if (!"yes".equals(var6_9)) break block42;
                        }
                        catch (Throwable v9) {
                            var2_2.release();
                            throw v9;
                        }
                        v10 = var2_2;
                        v11 = v10;
                        v12 = v10;
                        var7_11 = v10.extractMetadata(18);
                        var8_12 = v12.extractMetadata(19);
                        v8 = v11.extractMetadata(24);
                        ** continue;
                    }
                    if (var7_11 != null) {
                        v13 = this.mAttributes[0];
                        v13.put("ImageWidth", ExifAttribute.createUShort(Integer.parseInt(var7_11), this.mExifByteOrder));
                    }
                    if (var8_12 != null) {
                        v14 = this.mAttributes[0];
                        v14.put("ImageLength", ExifAttribute.createUShort(Integer.parseInt(var8_12), this.mExifByteOrder));
                    }
                    if (var9_13 != null) {
                        block43: {
                            var5_8 = 1;
                            var6_10 = Integer.parseInt(var9_13);
                            if (var6_10 != 90) {
                                if (var6_10 != 180) {
                                    if (var6_10 == 270) {
                                        var5_8 = 8;
                                    }
                                } else {
                                    var5_8 = 3;
                                }
                                break block43;
                            }
                            var5_8 = 6;
                        }
                        v15 = this.mAttributes[0];
                        var5_7 = "Orientation";
                        v15.put((String)var5_7, ExifAttribute.createUShort(var5_8, this.mExifByteOrder));
                    }
                    if (var3_3 == null || var4_5 == null) ** GOTO lbl125
                    v16 = var4_5;
                    var3_4 = Integer.parseInt((String)var3_3);
                    var4_6 = Integer.parseInt(v16);
                    if (var4_6 <= 6) ** GOTO lbl124
                    v17 = var1_1;
                    v17.seek(var3_4);
                    v18 = new byte[6];
                    var5_7 = v18;
                    if (v17.read(v18) != 6) ** GOTO lbl123
                    var3_4 += 6;
                    var4_6 -= 6;
                    if (!Arrays.equals((byte[])var5_7, ExifInterface.IDENTIFIER_EXIF_APP1)) ** GOTO lbl122
                    v19 = var1_1;
                    v20 = new byte[var4_6];
                    var1_1 = v20;
                    if (v19.read(v20) != var4_6) ** GOTO lbl121
                    this.mOffsetToExifData = var3_4;
                    this.readExifSegment((byte[])var1_1, 0);
                    break block45;
lbl121:
                    // 1 sources

                    throw new IOException("Can't read exif");
lbl122:
                    // 1 sources

                    throw new IOException("Invalid identifier");
lbl123:
                    // 1 sources

                    throw new IOException("Can't read identifier");
lbl124:
                    // 1 sources

                    throw new IOException("Invalid exif length");
                }
                if (!ExifInterface.DEBUG) break block44;
                Log.d((String)"ExifInterface", (String)("Heif meta: " + var7_11 + "x" + var8_12 + ", rotation " + var9_13));
            }
            var2_2.release();
            return;
        }
        var2_2.release();
    }

    private void getStandaloneAttributes(ByteOrderedDataInputStream object) throws IOException {
        ExifInterface exifInterface = object2;
        ByteOrderedDataInputStream byteOrderedDataInputStream = object;
        Object object2 = IDENTIFIER_EXIF_APP1;
        byteOrderedDataInputStream.skipBytes(IDENTIFIER_EXIF_APP1.length);
        byte[] byArray = new byte[byteOrderedDataInputStream.available()];
        object = byArray;
        byteOrderedDataInputStream.readFully(byArray);
        exifInterface.mOffsetToExifData = ((Object)object2).length;
        exifInterface.readExifSegment((byte[])object, 0);
    }

    private void getOrfAttributes(ByteOrderedDataInputStream object) throws IOException {
        ExifAttribute exifAttribute;
        ExifInterface exifInterface = exifAttribute;
        exifInterface.getRawAttributes((ByteOrderedDataInputStream)object);
        ExifAttribute exifAttribute2 = exifInterface.mAttributes[1].get(TAG_MAKER_NOTE);
        if (exifAttribute2 != null) {
            ExifAttribute exifAttribute3;
            byte[] byArray;
            ByteOrderedDataInputStream byteOrderedDataInputStream;
            ByteOrderedDataInputStream byteOrderedDataInputStream2 = byteOrderedDataInputStream;
            byteOrderedDataInputStream2(exifAttribute2.bytes);
            byteOrderedDataInputStream.setByteOrder(((ExifInterface)((Object)exifAttribute)).mExifByteOrder);
            byte[] exifAttribute22 = ORF_MAKER_NOTE_HEADER_1;
            byte[] byArray2 = new byte[ORF_MAKER_NOTE_HEADER_1.length];
            ByteOrderedDataInputStream byteOrderedDataInputStream3 = byteOrderedDataInputStream2;
            byteOrderedDataInputStream3.readFully(byArray2);
            byteOrderedDataInputStream3.seek(0L);
            byte[] byArray3 = ORF_MAKER_NOTE_HEADER_2;
            byArray2 = new byte[ORF_MAKER_NOTE_HEADER_2.length];
            byteOrderedDataInputStream3.readFully(byArray2);
            if (Arrays.equals(byArray, exifAttribute22)) {
                byteOrderedDataInputStream2.seek(8L);
            } else if (Arrays.equals(byArray2, byArray3)) {
                byteOrderedDataInputStream2.seek(12L);
            }
            ExifInterface exifInterface2 = exifAttribute;
            exifInterface2.readImageFileDirectory(byteOrderedDataInputStream2, 6);
            ExifAttribute exifAttribute4 = exifInterface2.mAttributes[7].get(TAG_ORF_PREVIEW_IMAGE_START);
            ExifAttribute exifAttribute5 = ((ExifInterface)((Object)exifAttribute)).mAttributes[7].get(TAG_ORF_PREVIEW_IMAGE_LENGTH);
            if (exifAttribute4 != null && exifAttribute5 != null) {
                ExifInterface exifInterface3 = exifAttribute;
                exifInterface3.mAttributes[5].put(TAG_JPEG_INTERCHANGE_FORMAT, exifAttribute4);
                exifInterface3.mAttributes[5].put(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, exifAttribute5);
            }
            if ((exifAttribute3 = ((ExifInterface)((Object)exifAttribute)).mAttributes[8].get(TAG_ORF_ASPECT_FRAME)) != null) {
                int[] nArray = (int[])exifAttribute3.getValue(((ExifInterface)((Object)exifAttribute)).mExifByteOrder);
                if (nArray != null && nArray.length == 4) {
                    if (nArray[2] > nArray[0] && nArray[3] > nArray[1]) {
                        int n2;
                        int n3;
                        int n4 = nArray[2] - nArray[0] + 1;
                        int n5 = nArray[3] - nArray[1] + 1;
                        if (n4 < n5) {
                            int n6 = n4 + n5;
                            n3 = n6 - n5;
                            n2 = n6 - n3;
                        }
                        ExifInterface exifInterface5 = exifAttribute;
                        exifInterface5 = exifAttribute;
                        exifAttribute = ExifAttribute.createUShort(n2, ((ExifInterface)((Object)exifAttribute)).mExifByteOrder);
                        ExifAttribute exifAttribute6 = ExifAttribute.createUShort(n3, exifInterface5.mExifByteOrder);
                        exifInterface4.mAttributes[0].put(TAG_IMAGE_WIDTH, exifAttribute);
                        exifInterface4.mAttributes[0].put(TAG_IMAGE_LENGTH, exifAttribute6);
                    }
                } else {
                    Log.w((String)TAG, (String)("Invalid aspect frame values. frame=" + Arrays.toString(nArray)));
                    return;
                }
            }
        }
    }

    private void getRw2Attributes(ByteOrderedDataInputStream object) throws IOException {
        if (DEBUG) {
            Log.d((String)TAG, (String)("getRw2Attributes starting with: " + object));
        }
        ExifInterface exifInterface = this;
        exifInterface.getRawAttributes((ByteOrderedDataInputStream)object);
        object = exifInterface.mAttributes[0].get(TAG_RW2_JPG_FROM_RAW);
        if (object != null) {
            this.getJpegAttributes(new ByteOrderedDataInputStream(((ExifAttribute)object).bytes), (int)((ExifAttribute)object).bytesOffset, 5);
        }
        object = this.mAttributes[0].get(TAG_RW2_ISO);
        ExifAttribute exifAttribute = this.mAttributes[1].get(TAG_PHOTOGRAPHIC_SENSITIVITY);
        if (object != null && exifAttribute == null) {
            this.mAttributes[1].put(TAG_PHOTOGRAPHIC_SENSITIVITY, (ExifAttribute)object);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void getPngAttributes(ByteOrderedDataInputStream var1_1) throws IOException {
        if (ExifInterface.DEBUG) {
            Log.d((String)"ExifInterface", (String)("getPngAttributes starting with: " + var1_1));
        }
        v0 = var1_1;
        v0.mark(0);
        v0.setByteOrder(ByteOrder.BIG_ENDIAN);
        var2_3 = ExifInterface.PNG_SIGNATURE;
        v0.skipBytes(ExifInterface.PNG_SIGNATURE.length);
        var2_4 = var2_3.length + 0;
        while (true) {
            block17: {
                v1 = var1_1;
                v2 = v1;
                var3_5 = v1.readInt();
                var2_4 += 4;
                var4_7 = 4;
                var5_9 = new byte[4];
                if (v2.read(var5_9) != var4_7) break;
                if ((var2_4 += 4) != 16) ** GOTO lbl27
                if (Arrays.equals(var5_9, ExifInterface.PNG_CHUNK_TYPE_IHDR)) ** GOTO lbl27
                throw new IOException("Encountered invalid PNG file--IHDR chunk should appearas the first chunk");
lbl27:
                // 2 sources

                if (Arrays.equals(var5_9, ExifInterface.PNG_CHUNK_TYPE_IEND)) ** GOTO lbl49
                if (!Arrays.equals(var5_9, ExifInterface.PNG_CHUNK_TYPE_EXIF)) break block17;
                v3 = var1_1;
                var4_8 = new byte[var3_5];
                if (v3.read(var4_8) != var3_5) ** GOTO lbl51
                var1_2 = var1_1.readInt();
                var3_6 = v4;
                var3_6();
                var3_6.update(var5_9);
                v4.update(var4_8);
                if ((int)v4.getValue() != var1_2) ** GOTO lbl50
                v5 = this;
                this.mOffsetToExifData = var2_4;
                v5.readExifSegment(var4_8, 0);
                v5.validateImages();
                v5.setThumbnailData(new ByteOrderedDataInputStream(var4_8));
lbl49:
                // 2 sources

                return;
lbl50:
                // 1 sources

                throw new IOException("Encountered invalid CRC value for PNG-EXIF chunk.\n recorded CRC value: " + var1_2 + ", calculated CRC value: " + var3_6.getValue());
lbl51:
                // 1 sources

                throw new IOException("Failed to read given length for given PNG chunk type: " + ExifInterface.byteArrayToHexString(var5_9));
            }
            v6 = var2_4;
            var2_4 = var3_5 + 4;
            var1_1.skipBytes(var2_4);
            var2_4 = v6 + var2_4;
        }
        try {
            throw new IOException("Encountered invalid length while parsing PNG chunktype");
        }
        catch (EOFException v7) {
            throw new IOException("Encountered corrupt PNG file.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void getWebpAttributes(ByteOrderedDataInputStream var1_1) throws IOException {
        if (ExifInterface.DEBUG) {
            Log.d((String)"ExifInterface", (String)("getWebpAttributes starting with: " + var1_1));
        }
        v0 = var1_1;
        v0.mark(0);
        v0.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        v0.skipBytes(ExifInterface.WEBP_SIGNATURE_1.length);
        var2_2 = v0.readInt() + 8;
        var3_3 = v0.skipBytes(ExifInterface.WEBP_SIGNATURE_2.length) + 8;
        while (true) {
            block17: {
                block16: {
                    var4_4 = 4;
                    var5_6 = new byte[4];
                    if (var1_1.read(var5_6) != var4_4) ** GOTO lbl51
                    var3_3 += 4;
                    var4_4 = var1_1.readInt();
                    var3_3 += 4;
                    if (!Arrays.equals(ExifInterface.WEBP_CHUNK_TYPE_EXIF, var5_6)) ** GOTO lbl36
                    v1 = var1_1;
                    v2 = new byte[var4_4];
                    var1_1 = v2;
                    if (v1.read(v2) != var4_4) ** GOTO lbl35
                    v3 = this;
                    this.mOffsetToExifData = var3_3;
                    v3.readExifSegment((byte[])var1_1, 0);
                    v3.setThumbnailData(new ByteOrderedDataInputStream((byte[])var1_1));
                    break block16;
lbl35:
                    // 1 sources

                    throw new IOException("Failed to read given length for given PNG chunk type: " + ExifInterface.byteArrayToHexString(var5_6));
lbl36:
                    // 1 sources

                    if (var4_4 % 2 == 1) {
                        ++var4_4;
                    }
                    if ((var5_5 = var3_3 + var4_4) != var2_2) break block17;
                }
                return;
            }
            if (var5_5 > var2_2) ** GOTO lbl50
            var5_5 = var1_1.skipBytes(var4_4);
            if (var5_5 != var4_4) break;
            var3_3 += var5_5;
            continue;
            break;
        }
        try {
            throw new IOException("Encountered WebP file with invalid chunk size");
lbl50:
            // 1 sources

            throw new IOException("Encountered WebP file with invalid chunk size");
lbl51:
            // 1 sources

            throw new IOException("Encountered invalid length while parsing WebP chunktype");
        }
        catch (EOFException v4) {
            throw new IOException("Encountered corrupt WebP file.");
        }
    }

    private void saveJpegAttributes(InputStream closeable, OutputStream object) throws IOException {
        ByteOrderedDataOutputStream byteOrderedDataOutputStream;
        DataInputStream dataInputStream;
        if (DEBUG) {
            Log.d((String)TAG, (String)("saveJpegAttributes starting with (inputStream: " + closeable + ", outputStream: " + object + ")"));
        }
        DataInputStream dataInputStream2 = dataInputStream;
        dataInputStream = new DataInputStream((InputStream)closeable);
        closeable = byteOrderedDataOutputStream;
        byteOrderedDataOutputStream = new ByteOrderedDataOutputStream((OutputStream)object, ByteOrder.BIG_ENDIAN);
        if (dataInputStream.readByte() == -1) {
            ((ByteOrderedDataOutputStream)closeable).writeByte(-1);
            if (dataInputStream2.readByte() == -40) {
                ((ByteOrderedDataOutputStream)closeable).writeByte(-40);
                object = null;
                if (this.getAttribute(TAG_XMP) != null && this.mXmpIsFromSeparateMarker) {
                    object = this.mAttributes[0].remove(TAG_XMP);
                }
                Closeable closeable2 = closeable;
                ((ByteOrderedDataOutputStream)closeable2).writeByte(-1);
                ((ByteOrderedDataOutputStream)closeable2).writeByte(-31);
                this.writeExifSegment((ByteOrderedDataOutputStream)closeable);
                if (object != null) {
                    this.mAttributes[0].put(TAG_XMP, (ExifAttribute)object);
                }
                int n2 = 4096;
                object = new byte[4096];
                block0: while (dataInputStream2.readByte() == -1) {
                    int n3 = dataInputStream2.readByte();
                    if (n3 != -39 && n3 != -38) {
                        int n4;
                        if (n3 != -31) {
                            Closeable closeable3 = closeable;
                            ((ByteOrderedDataOutputStream)closeable3).writeByte(-1);
                            ((ByteOrderedDataOutputStream)closeable3).writeByte(n3);
                            n3 = dataInputStream2.readUnsignedShort();
                            ((ByteOrderedDataOutputStream)closeable).writeUnsignedShort(n3);
                            if ((n3 += -2) >= 0) {
                                while (n3 > 0) {
                                    n4 = Math.min(n3, n2);
                                    if ((n4 = dataInputStream2.read((byte[])object, 0, n4)) < 0) continue block0;
                                    ((ByteOrderedDataOutputStream)closeable).write((byte[])object, 0, n4);
                                    n3 -= n4;
                                }
                                continue;
                            }
                            throw new IOException("Invalid length");
                        }
                        n4 = dataInputStream2.readUnsignedShort() - 2;
                        if (n4 >= 0) {
                            byte[] byArray = new byte[6];
                            if (n4 >= 6) {
                                if (dataInputStream2.read(byArray) == 6) {
                                    if (Arrays.equals(byArray, IDENTIFIER_EXIF_APP1)) {
                                        n3 = n4 - 6;
                                        if (dataInputStream2.skipBytes(n3) == n3) continue;
                                        throw new IOException("Invalid length");
                                    }
                                } else {
                                    throw new IOException("Invalid exif");
                                }
                            }
                            ((ByteOrderedDataOutputStream)closeable).writeByte(-1);
                            ((ByteOrderedDataOutputStream)closeable).writeByte(n3);
                            ((ByteOrderedDataOutputStream)closeable).writeUnsignedShort(n4 + 2);
                            if (n4 >= 6) {
                                n4 -= 6;
                                ((ByteOrderedDataOutputStream)closeable).write(byArray);
                            }
                            while (n4 > 0) {
                                n3 = Math.min(n4, n2);
                                if ((n3 = dataInputStream2.read((byte[])object, 0, n3)) < 0) continue block0;
                                ((ByteOrderedDataOutputStream)closeable).write((byte[])object, 0, n3);
                                n4 -= n3;
                            }
                            continue;
                        }
                        throw new IOException("Invalid length");
                    }
                    Closeable closeable4 = closeable;
                    ((ByteOrderedDataOutputStream)closeable4).writeByte(-1);
                    ((ByteOrderedDataOutputStream)closeable4).writeByte(n3);
                    ExifInterface.copy(dataInputStream2, (OutputStream)closeable);
                    return;
                }
                throw new IOException("Invalid marker");
            }
            throw new IOException("Invalid marker");
        }
        throw new IOException("Invalid marker");
    }

    /*
     * Loose catch block
     */
    private void savePngAttributes(InputStream object, OutputStream object2) throws IOException {
        Throwable throwable2;
        Object object3;
        block15: {
            CRC32 cRC32;
            ByteOrderedDataOutputStream byteOrderedDataOutputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            ByteOrderedDataOutputStream byteOrderedDataOutputStream2;
            DataInputStream dataInputStream;
            if (DEBUG) {
                Log.d((String)TAG, (String)("savePngAttributes starting with (inputStream: " + object + ", outputStream: " + object2 + ")"));
            }
            DataInputStream dataInputStream2 = dataInputStream;
            dataInputStream = new DataInputStream((InputStream)object);
            object = byteOrderedDataOutputStream2;
            OutputStream outputStream = object2;
            object2 = ByteOrder.BIG_ENDIAN;
            byteOrderedDataOutputStream2 = new ByteOrderedDataOutputStream(outputStream, (ByteOrder)object2);
            object3 = PNG_SIGNATURE;
            ExifInterface.copy(dataInputStream, (OutputStream)object, PNG_SIGNATURE.length);
            int n2 = ((ExifInterface)object4).mOffsetToExifData;
            if (n2 == 0) {
                int n3 = dataInputStream2.readInt();
                ((ByteOrderedDataOutputStream)object).writeInt(n3);
                ExifInterface.copy(dataInputStream2, (OutputStream)object, n3 + 4 + 4);
            } else {
                DataInputStream dataInputStream3 = dataInputStream2;
                ExifInterface.copy(dataInputStream3, (OutputStream)object, n2 - ((byte[])object3).length - 4 - 4);
                dataInputStream3.skipBytes(dataInputStream3.readInt() + 4 + 4);
            }
            DataInputStream dataInputStream4 = dataInputStream2;
            Closeable closeable = object;
            dataInputStream2 = null;
            object3 = byteArrayOutputStream;
            Closeable closeable2 = object;
            Closeable closeable3 = closeable2;
            Closeable closeable4 = closeable2;
            ExifInterface exifInterface = object4;
            object3();
            Object object4 = byteOrderedDataOutputStream;
            try {
                exifInterface.writeExifSegment(new ByteOrderedDataOutputStream((OutputStream)object3, (ByteOrder)object2));
            }
            catch (Throwable throwable2) {}
            byte[] byArray = ((ByteArrayOutputStream)((ByteOrderedDataOutputStream)object4).mOutputStream).toByteArray();
            object4 = byArray;
            ((ByteOrderedDataOutputStream)closeable3).write(byArray);
            object = cRC32;
            Object object5 = object4;
            Object object6 = object5;
            Object object7 = object5;
            ((CRC32)object)();
            int n4 = 4;
            int n5 = ((Object)object6).length;
            cRC32.update((byte[])object7, n4, n5 - 4);
            int n6 = (int)cRC32.getValue();
            ((ByteOrderedDataOutputStream)closeable4).writeInt(n6);
            ExifInterface.closeQuietly(byteArrayOutputStream);
            ExifInterface.copy(dataInputStream4, (OutputStream)closeable);
            return;
            break block15;
            catch (Throwable throwable2) {
                object3 = dataInputStream2;
            }
        }
        ExifInterface.closeQuietly((Closeable)object3);
        throw throwable2;
    }

    /*
     * Exception decompiling
     */
    private void saveWebpAttributes(InputStream var1_4, OutputStream var2_5) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void copyChunksUpToGivenChunkType(ByteOrderedDataInputStream object, ByteOrderedDataOutputStream object2, byte[] byArray, byte[] byArray2) throws IOException {
        byte[] byArray3;
        do {
            if (((InputStream)object).read(byArray3 = new byte[4]) != 4) {
                object = ASCII;
                object2 = new StringBuilder().append("Encountered invalid length while copying WebP chunks up tochunk type ").append(new String(byArray, (Charset)object));
                object = byArray2 == null ? "" : " or " + new String(byArray2, (Charset)object);
                Object object3 = this;
                ((IOException)object3)(((StringBuilder)object2).append((String)object).toString());
                throw object3;
            }
            super.copyWebPChunk((ByteOrderedDataInputStream)object, (ByteOrderedDataOutputStream)object2, byArray3);
        } while (!Arrays.equals(byArray3, byArray) && (byArray2 == null || !Arrays.equals(byArray3, byArray2)));
    }

    private void copyWebPChunk(ByteOrderedDataInputStream byteOrderedDataInputStream, ByteOrderedDataOutputStream byteOrderedDataOutputStream, byte[] byArray) throws IOException {
        int n2 = byteOrderedDataInputStream.readInt();
        byteOrderedDataOutputStream.write(byArray);
        byteOrderedDataOutputStream.writeInt(n2);
        if (n2 % 2 == 1) {
            ++n2;
        }
        ExifInterface.copy(byteOrderedDataInputStream, byteOrderedDataOutputStream, n2);
    }

    private void readExifSegment(byte[] byArray, int n2) throws IOException {
        ByteOrderedDataInputStream byteOrderedDataInputStream;
        ExifInterface exifInterface = byteOrderedDataInputStream2;
        ByteOrderedDataInputStream byteOrderedDataInputStream2 = byteOrderedDataInputStream;
        byteOrderedDataInputStream = new ByteOrderedDataInputStream(byArray);
        exifInterface.parseTiffHeaders(byteOrderedDataInputStream2, byArray.length);
        exifInterface.readImageFileDirectory(byteOrderedDataInputStream2, n2);
    }

    private void addDefaultValuesForCompatibility() {
        Object object = ((ExifInterface)((Object)byteOrder)).getAttribute(TAG_DATETIME_ORIGINAL);
        if (object != null && ((ExifInterface)((Object)byteOrder)).getAttribute(TAG_DATETIME) == null) {
            ((ExifInterface)((Object)byteOrder)).mAttributes[0].put(TAG_DATETIME, ExifAttribute.createString((String)object));
        }
        if (((ExifInterface)((Object)byteOrder)).getAttribute(TAG_IMAGE_WIDTH) == null) {
            object = ((ExifInterface)((Object)byteOrder)).mExifByteOrder;
            ((ExifInterface)((Object)byteOrder)).mAttributes[0].put(TAG_IMAGE_WIDTH, ExifAttribute.createULong(0L, (ByteOrder)object));
        }
        if (((ExifInterface)((Object)byteOrder)).getAttribute(TAG_IMAGE_LENGTH) == null) {
            object = ((ExifInterface)((Object)byteOrder)).mExifByteOrder;
            ((ExifInterface)((Object)byteOrder)).mAttributes[0].put(TAG_IMAGE_LENGTH, ExifAttribute.createULong(0L, (ByteOrder)object));
        }
        if (((ExifInterface)((Object)byteOrder)).getAttribute(TAG_ORIENTATION) == null) {
            object = ((ExifInterface)((Object)byteOrder)).mExifByteOrder;
            ((ExifInterface)((Object)byteOrder)).mAttributes[0].put(TAG_ORIENTATION, ExifAttribute.createULong(0L, (ByteOrder)object));
        }
        if (((ExifInterface)((Object)byteOrder)).getAttribute(TAG_LIGHT_SOURCE) == null) {
            ByteOrder byteOrder = ((ExifInterface)((Object)byteOrder)).mExifByteOrder;
            ((ExifInterface)((Object)byteOrder)).mAttributes[1].put(TAG_LIGHT_SOURCE, ExifAttribute.createULong(0L, byteOrder));
        }
    }

    private ByteOrder readByteOrder(ByteOrderedDataInputStream byteOrderedDataInputStream) throws IOException {
        short s = byteOrderedDataInputStream.readShort();
        if (s != 18761) {
            if (s == 19789) {
                if (DEBUG) {
                    Log.d((String)TAG, (String)"readExifSegment: Byte Align MM");
                }
                return ByteOrder.BIG_ENDIAN;
            }
            throw new IOException("Invalid byte order: " + Integer.toHexString(s));
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"readExifSegment: Byte Align II");
        }
        return ByteOrder.LITTLE_ENDIAN;
    }

    private void parseTiffHeaders(ByteOrderedDataInputStream byteOrderedDataInputStream, int n2) throws IOException {
        ExifInterface exifInterface = byteOrder;
        ByteOrderedDataInputStream byteOrderedDataInputStream2 = byteOrderedDataInputStream;
        ByteOrder byteOrder = ((ExifInterface)((Object)byteOrder)).readByteOrder(byteOrderedDataInputStream);
        v2.mExifByteOrder = byteOrder;
        byteOrderedDataInputStream2.setByteOrder(byteOrder);
        int n3 = byteOrderedDataInputStream2.readUnsignedShort();
        int n4 = exifInterface.mMimeType;
        if (n4 != 7 && n4 != 10 && n3 != 42) {
            throw new IOException("Invalid start code: " + Integer.toHexString(n3));
        }
        n3 = byteOrderedDataInputStream.readInt();
        if (n3 >= 8 && n3 < n2) {
            if ((n3 += -8) > 0 && byteOrderedDataInputStream.skipBytes(n3) != n3) {
                throw new IOException("Couldn't jump to first Ifd: " + n3);
            }
            return;
        }
        throw new IOException("Invalid first Ifd offset: " + n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readImageFileDirectory(ByteOrderedDataInputStream byteOrderedDataInputStream, int n2) throws IOException {
        long l2;
        this.mAttributesOffsets.add(byteOrderedDataInputStream.mPosition);
        if (byteOrderedDataInputStream.mPosition + 2 > byteOrderedDataInputStream.mLength) {
            return;
        }
        short s = byteOrderedDataInputStream.readShort();
        if (DEBUG) {
            Log.d((String)TAG, (String)("numberOfDirectoryEntry: " + s));
        }
        if (byteOrderedDataInputStream.mPosition + s * 12 > byteOrderedDataInputStream.mLength) return;
        if (s <= 0) {
            return;
        }
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            ExifAttribute exifAttribute;
            long l3;
            ExifTag exifTag;
            long l4;
            int n3;
            int n4;
            block41: {
                block46: {
                    boolean bl;
                    block45: {
                        Integer n5;
                        block44: {
                            block42: {
                                block43: {
                                    int n6;
                                    Object object;
                                    int n7;
                                    block38: {
                                        block39: {
                                            int[] nArray;
                                            block40: {
                                                block37: {
                                                    ByteOrderedDataInputStream byteOrderedDataInputStream2 = byteOrderedDataInputStream;
                                                    n7 = byteOrderedDataInputStream2.readUnsignedShort();
                                                    n4 = byteOrderedDataInputStream2.readUnsignedShort();
                                                    n3 = byteOrderedDataInputStream2.readInt();
                                                    l4 = (long)byteOrderedDataInputStream2.peek() + 4L;
                                                    exifTag = sExifTagMapsForReading[n2].get(n7);
                                                    bl = DEBUG;
                                                    if (bl) {
                                                        String string2 = TAG;
                                                        String string3 = "ifdType: %d, tagNumber: %d, tagName: %s, dataFormat: %d, numberOfComponents: %d";
                                                        Object[] objectArray = new Object[5];
                                                        Object[] objectArray2 = objectArray;
                                                        objectArray2[0] = n2;
                                                        objectArray[1] = n7;
                                                        int n8 = 2;
                                                        object = exifTag != null ? exifTag.name : null;
                                                        objectArray2[n8] = object;
                                                        objectArray2[3] = n4;
                                                        objectArray2[4] = n3;
                                                        Log.d((String)string2, (String)String.format(string3, objectArray2));
                                                    }
                                                    l3 = 0L;
                                                    n6 = 0;
                                                    if (exifTag != null) break block37;
                                                    if (bl) {
                                                        Log.d((String)TAG, (String)("Skip the tag entry since tag number is not defined: " + n7));
                                                    }
                                                    break block38;
                                                }
                                                if (n4 <= 0) break block39;
                                                nArray = IFD_FORMAT_BYTES_PER_FORMAT;
                                                if (n4 >= IFD_FORMAT_BYTES_PER_FORMAT.length) break block39;
                                                if (exifTag.isFormatCompatible(n4)) break block40;
                                                if (bl) {
                                                    Log.d((String)TAG, (String)("Skip the tag entry since data format (" + IFD_FORMAT_NAMES[n4] + ") is unexpected for tag: " + exifTag.name));
                                                }
                                                break block38;
                                            }
                                            if (n4 == 7) {
                                                n4 = exifTag.primaryFormat;
                                            }
                                            if ((l3 = (long)n3 * (long)nArray[n4]) >= 0L && l3 <= Integer.MAX_VALUE) {
                                                n6 = 1;
                                                break block38;
                                            } else if (bl) {
                                                Log.d((String)TAG, (String)("Skip the tag entry since the number of components is invalid: " + n3));
                                            }
                                            break block38;
                                        }
                                        if (bl) {
                                            Log.d((String)TAG, (String)("Skip the tag entry since data format is invalid: " + n4));
                                        }
                                    }
                                    if (n6 == 0) {
                                        byteOrderedDataInputStream.seek(l4);
                                        continue;
                                    }
                                    if (l3 > 4L) {
                                        long l5;
                                        n6 = byteOrderedDataInputStream.readInt();
                                        if (bl) {
                                            Log.d((String)TAG, (String)("seek to data offset: " + n6));
                                        }
                                        if (this.mMimeType == 7) {
                                            if (TAG_MAKER_NOTE.equals(exifTag.name)) {
                                                this.mOrfMakerNoteOffset = n6;
                                            } else if (n2 == 6 && TAG_ORF_THUMBNAIL_IMAGE.equals(exifTag.name)) {
                                                ExifInterface exifInterface = this;
                                                this.mOrfThumbnailOffset = n6;
                                                exifInterface.mOrfThumbnailLength = n3;
                                                ExifAttribute exifAttribute2 = ExifAttribute.createUShort(6, exifInterface.mExifByteOrder);
                                                object = ExifAttribute.createULong(exifInterface.mOrfThumbnailOffset, this.mExifByteOrder);
                                                ExifAttribute exifAttribute3 = ExifAttribute.createULong(exifInterface.mOrfThumbnailLength, this.mExifByteOrder);
                                                exifInterface.mAttributes[4].put(TAG_COMPRESSION, exifAttribute2);
                                                exifInterface.mAttributes[4].put(TAG_JPEG_INTERCHANGE_FORMAT, (ExifAttribute)object);
                                                exifInterface.mAttributes[4].put(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, exifAttribute3);
                                            }
                                        }
                                        if ((l5 = (long)n6) + l3 <= (long)byteOrderedDataInputStream.mLength) {
                                            byteOrderedDataInputStream.seek(l5);
                                        } else {
                                            if (bl) {
                                                Log.d((String)TAG, (String)("Skip the tag entry since data offset is invalid: " + n6));
                                            }
                                            byteOrderedDataInputStream.seek(l4);
                                            continue;
                                        }
                                    }
                                    n5 = sExifPointerTagMap.get(n7);
                                    if (bl) {
                                        Log.d((String)TAG, (String)("nextIfdType: " + n5 + " byteCount: " + l3));
                                    }
                                    if (n5 == null) break block41;
                                    l3 = -1L;
                                    if (n4 == 3) break block42;
                                    if (n4 == 4) break block43;
                                    if (n4 != 8) {
                                        if (n4 == 9 || n4 == 13) {
                                            l3 = byteOrderedDataInputStream.readInt();
                                        }
                                        break block44;
                                    } else {
                                        l3 = byteOrderedDataInputStream.readShort();
                                    }
                                    break block44;
                                }
                                l3 = byteOrderedDataInputStream.readUnsignedInt();
                                break block44;
                            }
                            l3 = byteOrderedDataInputStream.readUnsignedShort();
                        }
                        if (bl) {
                            Object[] objectArray = new Object[2];
                            Object[] objectArray3 = objectArray;
                            objectArray3[0] = l3;
                            objectArray[1] = exifTag.name;
                            Log.d((String)TAG, (String)String.format("Offset: %d, tagName: %s", objectArray3));
                        }
                        if (l3 <= 0L || l3 >= (long)byteOrderedDataInputStream.mLength) break block45;
                        if (!this.mAttributesOffsets.contains((int)l3)) {
                            byteOrderedDataInputStream.seek(l3);
                            this.readImageFileDirectory(byteOrderedDataInputStream, n5);
                            break block46;
                        } else if (bl) {
                            Log.d((String)TAG, (String)("Skip jump into the IFD since it has already been read: IfdType " + n5 + " (at " + l3 + ")"));
                        }
                        break block46;
                    }
                    if (bl) {
                        Log.d((String)TAG, (String)("Skip jump into the IFD since its offset is invalid: " + l3));
                    }
                }
                byteOrderedDataInputStream.seek(l4);
                continue;
            }
            int n9 = byteOrderedDataInputStream.peek() + this.mOffsetToExifData;
            byte[] byArray = new byte[(int)l3];
            byteOrderedDataInputStream.readFully(byArray);
            ExifAttribute exifAttribute4 = exifAttribute;
            long l6 = n9;
            exifAttribute = new ExifAttribute(n4, n3, l6, byArray);
            this.mAttributes[n2].put(exifTag.name, exifAttribute4);
            if (TAG_DNG_VERSION.equals(exifTag.name)) {
                this.mMimeType = 3;
            }
            if ((TAG_MAKE.equals(exifTag.name) || TAG_MODEL.equals(exifTag.name)) && exifAttribute4.getStringValue(this.mExifByteOrder).contains(PEF_SIGNATURE) || TAG_COMPRESSION.equals(exifTag.name) && exifAttribute4.getIntValue(this.mExifByteOrder) == 65535) {
                this.mMimeType = 8;
            }
            if ((long)byteOrderedDataInputStream.peek() == l4) continue;
            byteOrderedDataInputStream.seek(l4);
        }
        if (byteOrderedDataInputStream.peek() + 4 > byteOrderedDataInputStream.mLength) return;
        n2 = byteOrderedDataInputStream.readInt();
        boolean bl = DEBUG;
        s = (short)(bl ? 1 : 0);
        if (bl) {
            Object[] objectArray = new Object[1];
            Object[] objectArray4 = objectArray;
            objectArray[0] = n2;
            Log.d((String)TAG, (String)String.format("nextIfdOffset: %d", objectArray4));
        }
        if ((l2 = (long)n2) > 0L && n2 < byteOrderedDataInputStream.mLength) {
            if (this.mAttributesOffsets.contains(n2)) {
                if (s == 0) return;
                Log.d((String)TAG, (String)("Stop reading file since re-reading an IFD may cause an infinite loop: " + n2));
                return;
            }
            byteOrderedDataInputStream.seek(l2);
            if (this.mAttributes[4].isEmpty()) {
                this.readImageFileDirectory(byteOrderedDataInputStream, 4);
                return;
            }
            if (!this.mAttributes[5].isEmpty()) return;
            this.readImageFileDirectory(byteOrderedDataInputStream, 5);
            return;
        }
        if (s == 0) return;
        Log.d((String)TAG, (String)("Stop reading file since a wrong offset may cause an infinite loop: " + n2));
    }

    private void retrieveJpegImageSize(ByteOrderedDataInputStream object, int n2) throws IOException {
        ExifAttribute exifAttribute = this.mAttributes[n2].get(TAG_IMAGE_WIDTH);
        if (this.mAttributes[n2].get(TAG_IMAGE_LENGTH) == null || exifAttribute == null) {
            exifAttribute = this.mAttributes[n2].get(TAG_JPEG_INTERCHANGE_FORMAT);
            ExifAttribute exifAttribute2 = this.mAttributes[n2].get(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH);
            if (exifAttribute != null && exifAttribute2 != null) {
                ByteOrderedDataInputStream byteOrderedDataInputStream = object;
                int n3 = exifAttribute.getIntValue(this.mExifByteOrder);
                int n4 = exifAttribute.getIntValue(this.mExifByteOrder);
                ((ByteOrderedDataInputStream)object).seek(n3);
                byte[] byArray = new byte[n4];
                object = byArray;
                byteOrderedDataInputStream.read(byArray);
                this.getJpegAttributes(new ByteOrderedDataInputStream((byte[])object), n3, n2);
            }
        }
    }

    private void setThumbnailData(ByteOrderedDataInputStream byteOrderedDataInputStream) throws IOException {
        block4: {
            HashMap<String, ExifAttribute> hashMap;
            block1: {
                block2: {
                    block3: {
                        int n2;
                        hashMap = this.mAttributes[4];
                        ExifAttribute exifAttribute = hashMap.get(TAG_COMPRESSION);
                        if (exifAttribute == null) break block1;
                        this.mThumbnailCompression = n2 = exifAttribute.getIntValue(this.mExifByteOrder);
                        if (n2 == 1) break block2;
                        if (n2 == 6) break block3;
                        if (n2 == 7) break block2;
                        break block4;
                    }
                    this.handleThumbnailFromJfif(byteOrderedDataInputStream, hashMap);
                    break block4;
                }
                if (this.isSupportedDataType(hashMap)) {
                    this.handleThumbnailFromStrips(byteOrderedDataInputStream, hashMap);
                }
                break block4;
            }
            this.mThumbnailCompression = 6;
            this.handleThumbnailFromJfif(byteOrderedDataInputStream, hashMap);
        }
    }

    private void handleThumbnailFromJfif(ByteOrderedDataInputStream object, HashMap object2) throws IOException {
        ExifAttribute exifAttribute = (ExifAttribute)((HashMap)object2).get(TAG_JPEG_INTERCHANGE_FORMAT);
        object2 = (ExifAttribute)((HashMap)object2).get(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH);
        if (exifAttribute != null && object2 != null) {
            int n2 = exifAttribute.getIntValue(this.mExifByteOrder);
            int n3 = ((ExifAttribute)object2).getIntValue(this.mExifByteOrder);
            if (this.mMimeType == 7) {
                n2 += this.mOrfMakerNoteOffset;
            }
            n3 = Math.min(n3, ((ByteOrderedDataInputStream)object).getLength() - n2);
            if (n2 > 0 && n3 > 0) {
                this.mHasThumbnail = true;
                if (this.mFilename == null && this.mAssetInputStream == null && this.mSeekableFileDescriptor == null) {
                    ByteOrderedDataInputStream byteOrderedDataInputStream = object;
                    object = new byte[n3];
                    byteOrderedDataInputStream.skip(n2);
                    byteOrderedDataInputStream.read((byte[])object);
                    this.mThumbnailBytes = (byte[])object;
                }
                ExifInterface exifInterface = this;
                exifInterface.mThumbnailOffset = n2;
                exifInterface.mThumbnailLength = n3;
            }
            if (DEBUG) {
                Log.d((String)TAG, (String)("Setting thumbnail attributes with offset: " + n2 + ", length: " + n3));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleThumbnailFromStrips(ByteOrderedDataInputStream byteOrderedDataInputStream, HashMap object) throws IOException {
        int n2;
        int n3;
        long l2;
        Object object2;
        block11: {
            object2 = (ExifAttribute)((HashMap)object).get(TAG_STRIP_OFFSETS);
            object = (ExifAttribute)((HashMap)object).get(TAG_STRIP_BYTE_COUNTS);
            if (object2 == null) return;
            if (object == null) return;
            long[] lArray = ExifInterface.convertToLongArray(((ExifAttribute)object2).getValue(this.mExifByteOrder));
            object2 = lArray;
            object = ExifInterface.convertToLongArray(((ExifAttribute)object).getValue(this.mExifByteOrder));
            if (lArray != null && ((Object)object2).length != 0) {
                if (object != null && ((Object)object).length != 0) {
                    if (((Object)object2).length != ((Object)object).length) {
                        Log.w((String)TAG, (String)"stripOffsets and stripByteCounts should have same length.");
                        return;
                    }
                    l2 = 0L;
                    n3 = ((Object)object).length;
                    for (n2 = 0; n2 < n3; l2 += object[n2], ++n2) {
                    }
                    break block11;
                } else {
                    Log.w((String)TAG, (String)"stripByteCounts should not be null or have zero length.");
                    return;
                }
            }
            Log.w((String)TAG, (String)"stripOffsets should not be null or have zero length.");
            return;
        }
        ExifInterface exifInterface = this;
        int n4 = (int)l2;
        byte[] byArray = new byte[n4];
        n3 = 0;
        n2 = 0;
        exifInterface.mAreThumbnailStripsConsecutive = true;
        exifInterface.mHasThumbnailStrips = true;
        exifInterface.mHasThumbnail = true;
        int n5 = 0;
        while (true) {
            if (n5 >= ((Object)object2).length) {
                this.mThumbnailBytes = byArray;
                if (!this.mAreThumbnailStripsConsecutive) return;
                this.mThumbnailOffset = (int)object2[0];
                this.mThumbnailLength = n4;
                return;
            }
            int n6 = (int)object2[n5];
            int n7 = (int)object[n5];
            if (n5 < ((Object)object2).length - 1 && (long)(n6 + n7) != object2[n5 + 1]) {
                this.mAreThumbnailStripsConsecutive = false;
            }
            if ((n6 -= n3) < 0) {
                Log.d((String)TAG, (String)"Invalid strip offset value");
                return;
            }
            long l3 = n6;
            if (byteOrderedDataInputStream.skip(l3) != l3) {
                Log.d((String)TAG, (String)("Failed to skip " + n6 + " bytes."));
                return;
            }
            n3 += n6;
            byte[] byArray2 = new byte[n7];
            if (byteOrderedDataInputStream.read(byArray2) != n7) {
                Log.d((String)TAG, (String)("Failed to read " + n7 + " bytes."));
                return;
            }
            n3 += n7;
            System.arraycopy(byArray2, 0, byArray, n2, n7);
            n2 += n7;
            ++n5;
        }
    }

    private boolean isSupportedDataType(HashMap object) throws IOException {
        Object object2 = (ExifAttribute)((HashMap)object).get(TAG_BITS_PER_SAMPLE);
        if (object2 != null) {
            int n2;
            object2 = (int[])((ExifAttribute)object2).getValue(this.mExifByteOrder);
            int[] nArray = BITS_PER_SAMPLE_RGB;
            if (Arrays.equals(BITS_PER_SAMPLE_RGB, (int[])object2)) {
                return true;
            }
            if (this.mMimeType == 3 && (object = (ExifAttribute)((HashMap)object).get(TAG_PHOTOMETRIC_INTERPRETATION)) != null && ((n2 = ((ExifAttribute)object).getIntValue(this.mExifByteOrder)) == 1 && Arrays.equals((int[])object2, BITS_PER_SAMPLE_GREYSCALE_2) || n2 == 6 && Arrays.equals((int[])object2, nArray))) {
                return true;
            }
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"Unsupported data type value");
        }
        return false;
    }

    private boolean isThumbnail(HashMap object) throws IOException {
        ExifAttribute exifAttribute = (ExifAttribute)((HashMap)object).get(TAG_IMAGE_LENGTH);
        object = (ExifAttribute)((HashMap)object).get(TAG_IMAGE_WIDTH);
        if (exifAttribute != null && object != null) {
            int n2 = ((ExifAttribute)object).getIntValue(this.mExifByteOrder);
            if (exifAttribute.getIntValue(this.mExifByteOrder) <= 512 && n2 <= 512) {
                return true;
            }
        }
        return false;
    }

    private void validateImages() throws IOException {
        ExifInterface exifInterface = this;
        exifInterface.swapBasedOnImageSize(0, 5);
        exifInterface.swapBasedOnImageSize(0, 4);
        exifInterface.swapBasedOnImageSize(5, 4);
        Object object = exifInterface.mAttributes[1].get(TAG_PIXEL_X_DIMENSION);
        ExifAttribute exifAttribute = this.mAttributes[1].get(TAG_PIXEL_Y_DIMENSION);
        if (object != null && exifAttribute != null) {
            ExifInterface exifInterface2 = this;
            exifInterface2.mAttributes[0].put(TAG_IMAGE_WIDTH, (ExifAttribute)object);
            exifInterface2.mAttributes[0].put(TAG_IMAGE_LENGTH, exifAttribute);
        }
        if (this.mAttributes[4].isEmpty()) {
            ExifInterface exifInterface3 = this;
            if (exifInterface3.isThumbnail(exifInterface3.mAttributes[5])) {
                HashMap hashMap;
                HashMap<String, ExifAttribute>[] hashMapArray = this.mAttributes;
                hashMapArray[4] = hashMapArray[5];
                object = hashMap;
                hashMap = new HashMap();
                this.mAttributes[5] = object;
            }
        }
        ExifInterface exifInterface4 = this;
        if (!exifInterface4.isThumbnail(exifInterface4.mAttributes[4])) {
            Log.d((String)TAG, (String)"No image meets the size requirements of a thumbnail image.");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void updateImageSizeValues(ByteOrderedDataInputStream object, int n2) throws IOException {
        ExifAttribute exifAttribute;
        ExifAttribute exifAttribute2;
        ExifAttribute exifAttribute3;
        ExifAttribute exifAttribute4;
        void var2_10;
        block9: {
            int[] nArray;
            block10: {
                void var1_6;
                ExifAttribute exifAttribute5;
                block8: {
                    exifAttribute5 = ((ExifInterface)((Object)exifAttribute8)).mAttributes[var2_10].get(TAG_DEFAULT_CROP_SIZE);
                    ExifInterface exifInterface = exifAttribute8;
                    exifAttribute4 = exifInterface.mAttributes[var2_10].get(TAG_RW2_SENSOR_TOP_BORDER);
                    exifAttribute3 = exifInterface.mAttributes[var2_10].get(TAG_RW2_SENSOR_LEFT_BORDER);
                    exifAttribute2 = exifInterface.mAttributes[var2_10].get(TAG_RW2_SENSOR_BOTTOM_BORDER);
                    exifAttribute = exifInterface.mAttributes[var2_10].get(TAG_RW2_SENSOR_RIGHT_BORDER);
                    if (exifAttribute5 == null) break block9;
                    if (exifAttribute5.format == 5) {
                        Object[] objectArray = (Rational[])exifAttribute5.getValue(((ExifInterface)((Object)exifAttribute8)).mExifByteOrder);
                        if (objectArray != null && objectArray.length == 2) {
                            ExifAttribute exifAttribute6 = ExifAttribute.createURational((Rational)objectArray[0], ((ExifInterface)((Object)exifAttribute8)).mExifByteOrder);
                            exifAttribute5 = ExifAttribute.createURational((Rational)objectArray[1], ((ExifInterface)((Object)exifAttribute8)).mExifByteOrder);
                            break block8;
                        } else {
                            Log.w((String)TAG, (String)("Invalid crop size values. cropSize=" + Arrays.toString(objectArray)));
                            return;
                        }
                    }
                    nArray = (int[])exifAttribute5.getValue(((ExifInterface)((Object)exifAttribute8)).mExifByteOrder);
                    if (nArray == null || nArray.length != 2) break block10;
                    ExifAttribute exifAttribute7 = ExifAttribute.createUShort(nArray[0], ((ExifInterface)((Object)exifAttribute8)).mExifByteOrder);
                    exifAttribute5 = ExifAttribute.createUShort(nArray[1], ((ExifInterface)((Object)exifAttribute8)).mExifByteOrder);
                }
                ExifInterface exifInterface = exifAttribute8;
                exifInterface.mAttributes[var2_10].put(TAG_IMAGE_WIDTH, (ExifAttribute)var1_6);
                exifInterface.mAttributes[var2_10].put(TAG_IMAGE_LENGTH, exifAttribute5);
                return;
            }
            Log.w((String)TAG, (String)("Invalid crop size values. cropSize=" + Arrays.toString(nArray)));
            return;
        }
        if (exifAttribute4 != null && exifAttribute3 != null && exifAttribute2 != null && exifAttribute != null) {
            int n3 = exifAttribute4.getIntValue(((ExifInterface)((Object)exifAttribute8)).mExifByteOrder);
            int n4 = exifAttribute2.getIntValue(((ExifInterface)((Object)exifAttribute8)).mExifByteOrder);
            int n5 = exifAttribute.getIntValue(((ExifInterface)((Object)exifAttribute8)).mExifByteOrder);
            int n6 = exifAttribute3.getIntValue(((ExifInterface)((Object)exifAttribute8)).mExifByteOrder);
            if (n4 <= n3) return;
            if (n5 <= n6) return;
            ExifInterface exifInterface = exifAttribute8;
            int n7 = n4 - n3;
            ExifInterface exifInterface2 = exifAttribute8;
            ExifAttribute exifAttribute8 = ExifAttribute.createUShort(n7, ((ExifInterface)((Object)exifAttribute8)).mExifByteOrder);
            ExifAttribute exifAttribute9 = ExifAttribute.createUShort(n5 - n6, exifInterface2.mExifByteOrder);
            exifInterface.mAttributes[var2_10].put(TAG_IMAGE_LENGTH, exifAttribute8);
            exifInterface.mAttributes[var2_10].put(TAG_IMAGE_WIDTH, exifAttribute9);
            return;
        }
        ((ExifInterface)((Object)exifAttribute8)).retrieveJpegImageSize((ByteOrderedDataInputStream)object, (int)var2_10);
    }

    private int writeExifSegment(ByteOrderedDataOutputStream byteOrderedDataOutputStream) throws IOException {
        int n2;
        int n3;
        Object object;
        int n4;
        int n5;
        int[] nArray = new int[EXIF_TAGS.length];
        Object object2 = new int[EXIF_TAGS.length];
        ExifTag[] exifTagArray = EXIF_POINTER_TAGS;
        int n6 = EXIF_POINTER_TAGS.length;
        for (n5 = 0; n5 < n6; ++n5) {
            this.removeAttribute(exifTagArray[n5].name);
        }
        ExifInterface exifInterface = this;
        exifInterface.removeAttribute(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name);
        exifInterface.removeAttribute(ExifInterface.JPEG_INTERCHANGE_FORMAT_LENGTH_TAG.name);
        for (int i2 = 0; i2 < EXIF_TAGS.length; ++i2) {
            Object[] objectArray = this.mAttributes[i2].entrySet().toArray();
            n5 = objectArray.length;
            for (n4 = 0; n4 < n5; ++n4) {
                object = (Map.Entry)objectArray[n4];
                if (object.getValue() != null) continue;
                this.mAttributes[i2].remove(object.getKey());
            }
        }
        if (!this.mAttributes[1].isEmpty()) {
            String string2 = ExifInterface.EXIF_POINTER_TAGS[1].name;
            ByteOrder byteOrder = this.mExifByteOrder;
            this.mAttributes[0].put(string2, ExifAttribute.createULong(0L, byteOrder));
        }
        if (!this.mAttributes[2].isEmpty()) {
            String string3 = ExifInterface.EXIF_POINTER_TAGS[2].name;
            ByteOrder byteOrder = this.mExifByteOrder;
            this.mAttributes[0].put(string3, ExifAttribute.createULong(0L, byteOrder));
        }
        if (!this.mAttributes[3].isEmpty()) {
            String string4 = ExifInterface.EXIF_POINTER_TAGS[3].name;
            ByteOrder byteOrder = this.mExifByteOrder;
            this.mAttributes[1].put(string4, ExifAttribute.createULong(0L, byteOrder));
        }
        if (this.mHasThumbnail) {
            ExifInterface exifInterface2 = this;
            String string5 = ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name;
            ByteOrder byteOrder = this.mExifByteOrder;
            exifInterface2.mAttributes[4].put(string5, ExifAttribute.createULong(0L, byteOrder));
            exifInterface2.mAttributes[4].put(ExifInterface.JPEG_INTERCHANGE_FORMAT_LENGTH_TAG.name, ExifAttribute.createULong(this.mThumbnailLength, this.mExifByteOrder));
        }
        for (n3 = 0; n3 < EXIF_TAGS.length; ++n3) {
            n6 = 0;
            Iterator<Map.Entry<String, ExifAttribute>> iterator = this.mAttributes[n3].entrySet().iterator();
            while (iterator.hasNext()) {
                n4 = iterator.next().getValue().size();
                if (n4 <= 4) continue;
                n6 += n4;
            }
            object2[n3] = object2[n3] + n6;
        }
        n3 = 8;
        for (n6 = 0; n6 < EXIF_TAGS.length; ++n6) {
            if (this.mAttributes[n6].isEmpty()) continue;
            nArray[n6] = n3;
            n3 += this.mAttributes[n6].size() * 12 + 2 + 4 + object2[n6];
        }
        if (this.mHasThumbnail) {
            this.mAttributes[4].put(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name, ExifAttribute.createULong(n3, this.mExifByteOrder));
            this.mThumbnailOffset = n3;
            n3 += this.mThumbnailLength;
        }
        if (this.mMimeType == 4) {
            n3 += 8;
        }
        if (DEBUG) {
            for (n6 = 0; n6 < EXIF_TAGS.length; ++n6) {
                Object[] objectArray = new Object[5];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = n6;
                objectArray2[1] = nArray[n6];
                objectArray2[2] = this.mAttributes[n6].size();
                objectArray2[3] = object2[n6];
                objectArray[4] = n3;
                Log.d((String)TAG, (String)String.format("index: %d, offsets: %d, tag count: %d, data sizes: %d, total size: %d", objectArray2));
            }
        }
        if (!this.mAttributes[1].isEmpty()) {
            object2 = ExifInterface.EXIF_POINTER_TAGS[1].name;
            this.mAttributes[0].put((String)object2, ExifAttribute.createULong(nArray[1], this.mExifByteOrder));
        }
        if (!this.mAttributes[2].isEmpty()) {
            object2 = ExifInterface.EXIF_POINTER_TAGS[2].name;
            this.mAttributes[0].put((String)object2, ExifAttribute.createULong(nArray[2], this.mExifByteOrder));
        }
        if (!this.mAttributes[3].isEmpty()) {
            object2 = ExifInterface.EXIF_POINTER_TAGS[3].name;
            this.mAttributes[1].put((String)object2, ExifAttribute.createULong(nArray[3], this.mExifByteOrder));
        }
        if ((n2 = this.mMimeType) != 4) {
            if (n2 != 13) {
                if (n2 == 14) {
                    byteOrderedDataOutputStream.write(WEBP_CHUNK_TYPE_EXIF);
                    byteOrderedDataOutputStream.writeInt(n3);
                }
            } else {
                ByteOrderedDataOutputStream byteOrderedDataOutputStream2 = byteOrderedDataOutputStream;
                byteOrderedDataOutputStream2.writeInt(n3);
                byteOrderedDataOutputStream2.write(PNG_CHUNK_TYPE_EXIF);
            }
        } else {
            ByteOrderedDataOutputStream byteOrderedDataOutputStream3 = byteOrderedDataOutputStream;
            byteOrderedDataOutputStream3.writeUnsignedShort(n3);
            byteOrderedDataOutputStream3.write(IDENTIFIER_EXIF_APP1);
        }
        n2 = this.mExifByteOrder == ByteOrder.BIG_ENDIAN ? 19789 : 18761;
        ByteOrderedDataOutputStream byteOrderedDataOutputStream4 = byteOrderedDataOutputStream;
        byteOrderedDataOutputStream.writeShort((short)n2);
        byteOrderedDataOutputStream4.setByteOrder(this.mExifByteOrder);
        byteOrderedDataOutputStream4.writeUnsignedShort(42);
        byteOrderedDataOutputStream4.writeUnsignedInt(8L);
        for (n2 = 0; n2 < EXIF_TAGS.length; ++n2) {
            if (this.mAttributes[n2].isEmpty()) continue;
            byteOrderedDataOutputStream.writeUnsignedShort(this.mAttributes[n2].size());
            n6 = nArray[n2] + 2 + this.mAttributes[n2].size() * 12 + 4;
            for (Map.Entry<String, ExifAttribute> entry : this.mAttributes[n2].entrySet()) {
                int n7;
                n4 = ExifInterface.sExifTagMapsForWriting[n2].get((Object)entry.getKey()).number;
                object = entry.getValue();
                byteOrderedDataOutputStream.writeUnsignedShort(n4);
                byteOrderedDataOutputStream.writeUnsignedShort(((ExifAttribute)object).format);
                byteOrderedDataOutputStream.writeInt(((ExifAttribute)object).numberOfComponents);
                if (n7 > 4) {
                    byteOrderedDataOutputStream.writeUnsignedInt(n6);
                    n6 += n7;
                    continue;
                }
                byteOrderedDataOutputStream.write(((ExifAttribute)object).bytes);
                if (n7 >= 4) continue;
                for (n7 = ((ExifAttribute)object).size(); n7 < 4; ++n7) {
                    byteOrderedDataOutputStream.writeByte(0);
                }
            }
            if (n2 == 0 && !this.mAttributes[4].isEmpty()) {
                byteOrderedDataOutputStream.writeUnsignedInt(nArray[4]);
            } else {
                byteOrderedDataOutputStream.writeUnsignedInt(0L);
            }
            Iterator<Map.Entry<String, ExifAttribute>> iterator = this.mAttributes[n2].entrySet().iterator();
            while (iterator.hasNext()) {
                Object object3 = iterator.next().getValue().bytes;
                if (iterator.next().getValue().bytes.length <= 4) continue;
                n4 = ((Object)object3).length;
                byteOrderedDataOutputStream.write((byte[])object3, 0, n4);
            }
        }
        if (this.mHasThumbnail) {
            byteOrderedDataOutputStream.write(this.getThumbnailBytes());
        }
        if (this.mMimeType == 14 && n3 % 2 == 1) {
            byteOrderedDataOutputStream.writeByte(0);
        }
        byteOrderedDataOutputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Pair<Integer, Integer> guessDataFormat(String stringArray) {
        Pair pair;
        if (stringArray.contains(",")) {
            stringArray = stringArray.split(",", -1);
            pair = ExifInterface.guessDataFormat(stringArray[0]);
            if ((Integer)pair.first == 2) {
                return pair;
            }
        } else {
            if (stringArray.contains("/")) {
                if ((stringArray = stringArray.split("/", -1)).length != 2) return new Pair((Object)2, (Object)-1);
                try {
                    long l2 = (long)Double.parseDouble(stringArray[0]);
                    long l3 = (long)Double.parseDouble(stringArray[1]);
                    if (l2 < 0L) return new Pair((Object)10, (Object)-1);
                    if (l3 < 0L) {
                        return new Pair((Object)10, (Object)-1);
                    }
                    if (l2 > Integer.MAX_VALUE) return new Pair((Object)5, (Object)-1);
                    if (l3 > Integer.MAX_VALUE) {
                        return new Pair((Object)5, (Object)-1);
                    }
                    return new Pair((Object)10, (Object)5);
                }
                catch (NumberFormatException numberFormatException) {}
                return new Pair((Object)2, (Object)-1);
            }
            try {
                Long l4 = Long.parseLong((String)stringArray);
                if (l4 >= 0L && l4 <= 65535L) {
                    return new Pair((Object)3, (Object)4);
                }
                if (l4 >= 0L) return new Pair((Object)4, (Object)-1);
                return new Pair((Object)9, (Object)-1);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Double.parseDouble((String)stringArray);
                }
                catch (NumberFormatException numberFormatException2) {
                    return new Pair((Object)2, (Object)-1);
                }
                return new Pair((Object)12, (Object)-1);
            }
        }
        int n2 = 1;
        while (n2 < stringArray.length) {
            Pair<Integer, Integer> pair2 = ExifInterface.guessDataFormat(stringArray[n2]);
            int n3 = -1;
            int n4 = -1;
            if (((Integer)pair2.first).equals(pair.first) || ((Integer)pair2.second).equals(pair.first)) {
                n3 = (Integer)pair.first;
            }
            if ((Integer)pair.second != -1 && (((Integer)pair2.first).equals(pair.second) || ((Integer)pair2.second).equals(pair.second))) {
                n4 = (Integer)pair.second;
            }
            if (n3 == -1 && n4 == -1) {
                return new Pair((Object)2, (Object)-1);
            }
            if (n3 == -1) {
                Pair pair3;
                pair = pair3;
                pair3 = new Pair((Object)n4, (Object)-1);
            } else if (n4 == -1) {
                Pair pair4;
                pair = pair4;
                pair4 = new Pair((Object)n3, (Object)-1);
            }
            ++n2;
        }
        return pair;
    }

    private void swapBasedOnImageSize(int n2, int n3) throws IOException {
        if (!((ExifInterface)((Object)hashMap)).mAttributes[n2].isEmpty() && !((ExifInterface)((Object)hashMap)).mAttributes[n3].isEmpty()) {
            ExifAttribute exifAttribute = ((ExifInterface)((Object)hashMap)).mAttributes[n2].get(TAG_IMAGE_LENGTH);
            ExifInterface exifInterface = hashMap;
            ExifAttribute exifAttribute2 = exifInterface.mAttributes[n2].get(TAG_IMAGE_WIDTH);
            ExifAttribute exifAttribute3 = exifInterface.mAttributes[n3].get(TAG_IMAGE_LENGTH);
            ExifAttribute exifAttribute4 = exifInterface.mAttributes[n3].get(TAG_IMAGE_WIDTH);
            if (exifAttribute != null && exifAttribute2 != null) {
                if (exifAttribute3 != null && exifAttribute4 != null) {
                    int n4 = exifAttribute2.getIntValue(((ExifInterface)((Object)hashMap)).mExifByteOrder);
                    int n5 = exifAttribute3.getIntValue(((ExifInterface)((Object)hashMap)).mExifByteOrder);
                    int n6 = exifAttribute4.getIntValue(((ExifInterface)((Object)hashMap)).mExifByteOrder);
                    if (exifAttribute.getIntValue(((ExifInterface)((Object)hashMap)).mExifByteOrder) < n5 && n4 < n6) {
                        HashMap<String, ExifAttribute>[] hashMapArray = ((ExifInterface)((Object)hashMap)).mAttributes;
                        HashMap<String, ExifAttribute>[] hashMapArray2 = ((ExifInterface)((Object)hashMap)).mAttributes;
                        HashMap<String, ExifAttribute> hashMap = hashMapArray[n2];
                        hashMapArray[n2] = hashMapArray2[n3];
                        hashMapArray2[n3] = hashMap;
                    }
                } else if (DEBUG) {
                    Log.d((String)TAG, (String)"Second image does not contain valid size information");
                }
            } else if (DEBUG) {
                Log.d((String)TAG, (String)"First image does not contain valid size information");
            }
            return;
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)"Cannot perform swap since only one image data exists");
        }
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
        }
    }

    private static void closeFileDescriptor(FileDescriptor fileDescriptor) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Os.close((FileDescriptor)fileDescriptor);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Error closing fd.");
            }
        } else {
            Log.e((String)TAG, (String)"closeFileDescriptor is called in API < 21, which must be wrong.");
        }
    }

    private static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        int n3 = 0;
        byte[] byArray = new byte[8192];
        while ((n2 = inputStream.read(byArray)) != -1) {
            n3 += n2;
            outputStream.write(byArray, 0, n2);
        }
        return n3;
    }

    private static void copy(InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        byte[] byArray = new byte[8192];
        while (n2 > 0) {
            int n3 = Math.min(n2, 8192);
            int n4 = inputStream.read(byArray, 0, n3);
            if (n4 == n3) {
                n2 -= n4;
                outputStream.write(byArray, 0, n4);
                continue;
            }
            throw new IOException("Failed to copy the given amount of bytes from the inputstream to the output stream.");
        }
    }

    private static long[] convertToLongArray(Object object) {
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            object = nArray;
            long[] lArray = new long[nArray.length];
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                lArray[i2] = (long)object[i2];
            }
            return lArray;
        }
        if (object instanceof long[]) {
            return (long[])object;
        }
        return null;
    }

    private static boolean startsWith(byte[] byArray, byte[] byArray2) {
        if (byArray != null && byArray2 != null) {
            if (byArray.length < byArray2.length) {
                return false;
            }
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                if (byArray[i2] == byArray2[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String byteArrayToHexString(byte[] byArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = byArray[i2];
            stringBuilder2.append(String.format("%02x", objectArray2));
        }
        return stringBuilder2.toString();
    }

    private boolean isSupportedFormatForSavingAttributes() {
        int n2 = this.mMimeType;
        return n2 == 4 || n2 == 13 || n2 == 14;
        {
        }
    }

    static {
        ExifTag exifTag;
        ExifTag exifTag2;
        ExifTag exifTag3;
        ExifTag exifTag4;
        ExifTag exifTag5;
        ExifTag exifTag6;
        ExifTag exifTag7;
        ExifTag[] exifTagArray;
        ExifTag exifTag8;
        ExifTag[] exifTagArray2;
        ExifTag exifTag9;
        ExifTag exifTag10;
        ExifTag[] exifTagArray3;
        ExifTag exifTag11;
        ExifTag exifTag12;
        ExifTag exifTag13;
        ExifTag exifTag14;
        ExifTag exifTag15;
        ExifTag exifTag16;
        ExifTag exifTag17;
        ExifTag exifTag18;
        ExifTag exifTag19;
        ExifTag exifTag20;
        ExifTag exifTag21;
        ExifTag exifTag22;
        ExifTag exifTag23;
        ExifTag exifTag24;
        ExifTag exifTag25;
        ExifTag exifTag26;
        ExifTag exifTag27;
        ExifTag exifTag28;
        ExifTag exifTag29;
        ExifTag exifTag30;
        ExifTag exifTag31;
        ExifTag exifTag32;
        ExifTag exifTag33;
        ExifTag exifTag34;
        ExifTag exifTag35;
        ExifTag exifTag36;
        ExifTag exifTag37;
        ExifTag exifTag38;
        ExifTag exifTag39;
        ExifTag exifTag40;
        ExifTag exifTag41;
        ExifTag exifTag42;
        ExifTag exifTag43;
        ExifTag exifTag44;
        ExifTag exifTag45;
        ExifTag exifTag46;
        ExifTag[] exifTagArray4;
        ExifTag[] exifTagArray5;
        ExifTag exifTag47;
        ExifTag exifTag48;
        ExifTag exifTag49;
        ExifTag exifTag50;
        ExifTag exifTag51;
        ExifTag exifTag52;
        ExifTag exifTag53;
        ExifTag exifTag54;
        ExifTag exifTag55;
        ExifTag exifTag56;
        ExifTag exifTag57;
        ExifTag exifTag58;
        ExifTag exifTag59;
        ExifTag exifTag60;
        ExifTag exifTag61;
        ExifTag exifTag62;
        ExifTag exifTag63;
        ExifTag exifTag64;
        ExifTag exifTag65;
        ExifTag exifTag66;
        ExifTag exifTag67;
        ExifTag exifTag68;
        ExifTag exifTag69;
        ExifTag exifTag70;
        ExifTag exifTag71;
        ExifTag exifTag72;
        ExifTag exifTag73;
        ExifTag exifTag74;
        ExifTag exifTag75;
        ExifTag exifTag76;
        ExifTag exifTag77;
        ExifTag[] exifTagArray6;
        ExifTag exifTag78;
        ExifTag exifTag79;
        ExifTag exifTag80;
        ExifTag exifTag81;
        ExifTag exifTag82;
        ExifTag exifTag83;
        ExifTag exifTag84;
        ExifTag exifTag85;
        ExifTag exifTag86;
        ExifTag exifTag87;
        ExifTag exifTag88;
        ExifTag exifTag89;
        ExifTag exifTag90;
        ExifTag exifTag91;
        ExifTag exifTag92;
        ExifTag exifTag93;
        ExifTag exifTag94;
        ExifTag exifTag95;
        ExifTag exifTag96;
        ExifTag exifTag97;
        ExifTag exifTag98;
        ExifTag exifTag99;
        ExifTag exifTag100;
        ExifTag exifTag101;
        ExifTag exifTag102;
        ExifTag exifTag103;
        ExifTag exifTag104;
        ExifTag exifTag105;
        ExifTag exifTag106;
        ExifTag exifTag107;
        ExifTag exifTag108;
        ExifTag exifTag109;
        ExifTag exifTag110;
        ExifTag exifTag111;
        ExifTag exifTag112;
        ExifTag exifTag113;
        ExifTag exifTag114;
        ExifTag exifTag115;
        ExifTag exifTag116;
        ExifTag exifTag117;
        ExifTag exifTag118;
        ExifTag exifTag119;
        ExifTag exifTag120;
        ExifTag exifTag121;
        ExifTag exifTag122;
        ExifTag exifTag123;
        ExifTag exifTag124;
        ExifTag exifTag125;
        ExifTag exifTag126;
        ExifTag exifTag127;
        ExifTag exifTag128;
        ExifTag exifTag129;
        ExifTag exifTag130;
        ExifTag exifTag131;
        ExifTag exifTag132;
        ExifTag exifTag133;
        ExifTag exifTag134;
        ExifTag exifTag135;
        ExifTag exifTag136;
        ExifTag exifTag137;
        ExifTag exifTag138;
        ExifTag exifTag139;
        ExifTag exifTag140;
        ExifTag exifTag141;
        ExifTag exifTag142;
        ExifTag exifTag143;
        ExifTag exifTag144;
        ExifTag exifTag145;
        ExifTag exifTag146;
        ExifTag exifTag147;
        ExifTag exifTag148;
        ExifTag exifTag149;
        ExifTag exifTag150;
        ExifTag[] exifTagArray7;
        ExifTag exifTag151;
        ExifTag exifTag152;
        ExifTag exifTag153;
        ExifTag exifTag154;
        ExifTag exifTag155;
        ExifTag exifTag156;
        ExifTag exifTag157;
        ExifTag exifTag158;
        ExifTag exifTag159;
        ExifTag exifTag160;
        ExifTag exifTag161;
        ExifTag exifTag162;
        ExifTag exifTag163;
        ExifTag exifTag164;
        ExifTag exifTag165;
        ExifTag exifTag166;
        ExifTag exifTag167;
        ExifTag exifTag168;
        ExifTag exifTag169;
        ExifTag exifTag170;
        ExifTag exifTag171;
        ExifTag exifTag172;
        ExifTag exifTag173;
        ExifTag exifTag174;
        ExifTag exifTag175;
        ExifTag exifTag176;
        ExifTag exifTag177;
        ExifTag exifTag178;
        ExifTag exifTag179;
        ExifTag exifTag180;
        ExifTag exifTag181;
        ExifTag exifTag182;
        ExifTag exifTag183;
        ExifTag exifTag184;
        ExifTag exifTag185;
        ExifTag exifTag186;
        ExifTag exifTag187;
        ExifTag exifTag188;
        ExifTag exifTag189;
        ExifTag exifTag190;
        ExifTag exifTag191;
        ExifTag exifTag192;
        DEBUG = Log.isLoggable((String)TAG, (int)3);
        ROTATION_ORDER = Arrays.asList(1, 6, 3, 8);
        FLIPPED_ROTATION_ORDER = Arrays.asList(2, 7, 4, 5);
        BITS_PER_SAMPLE_RGB = new int[]{8, 8, 8};
        BITS_PER_SAMPLE_GREYSCALE_1 = new int[]{4};
        BITS_PER_SAMPLE_GREYSCALE_2 = new int[]{8};
        JPEG_SIGNATURE = new byte[]{-1, -40, -1};
        HEIF_TYPE_FTYP = new byte[]{102, 116, 121, 112};
        HEIF_BRAND_MIF1 = new byte[]{109, 105, 102, 49};
        HEIF_BRAND_HEIC = new byte[]{104, 101, 105, 99};
        ORF_MAKER_NOTE_HEADER_1 = new byte[]{79, 76, 89, 77, 80, 0};
        ORF_MAKER_NOTE_HEADER_2 = new byte[]{79, 76, 89, 77, 80, 85, 83, 0, 73, 73};
        PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        PNG_CHUNK_TYPE_EXIF = new byte[]{101, 88, 73, 102};
        PNG_CHUNK_TYPE_IHDR = new byte[]{73, 72, 68, 82};
        PNG_CHUNK_TYPE_IEND = new byte[]{73, 69, 78, 68};
        WEBP_SIGNATURE_1 = new byte[]{82, 73, 70, 70};
        WEBP_SIGNATURE_2 = new byte[]{87, 69, 66, 80};
        WEBP_CHUNK_TYPE_EXIF = new byte[]{69, 88, 73, 70};
        WEBP_VP8_SIGNATURE = new byte[]{-99, 1, 42};
        WEBP_CHUNK_TYPE_VP8X = "VP8X".getBytes(Charset.defaultCharset());
        WEBP_CHUNK_TYPE_VP8L = "VP8L".getBytes(Charset.defaultCharset());
        WEBP_CHUNK_TYPE_VP8 = "VP8 ".getBytes(Charset.defaultCharset());
        WEBP_CHUNK_TYPE_ANIM = "ANIM".getBytes(Charset.defaultCharset());
        WEBP_CHUNK_TYPE_ANMF = "ANMF".getBytes(Charset.defaultCharset());
        IFD_FORMAT_NAMES = new String[]{"", "BYTE", "STRING", "USHORT", "ULONG", "URATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "SINGLE", "DOUBLE", "IFD"};
        IFD_FORMAT_BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8, 1};
        EXIF_ASCII_PREFIX = new byte[]{65, 83, 67, 73, 73, 0, 0, 0};
        ExifTag[] exifTagArray8 = new ExifTag[42];
        Object object = exifTagArray8;
        ExifTag object2 = exifTag192;
        exifTag192 = new ExifTag(TAG_NEW_SUBFILE_TYPE, 254, 4);
        exifTagArray8[0] = object2;
        ExifTag exifTag193 = exifTag191;
        exifTag191 = new ExifTag(TAG_SUBFILE_TYPE, 255, 4);
        exifTagArray8[1] = exifTag193;
        ExifTag exifTag194 = exifTag190;
        exifTag190 = new ExifTag(TAG_IMAGE_WIDTH, 256, 3, 4);
        exifTagArray8[2] = exifTag194;
        ExifTag exifTag195 = exifTag189;
        exifTag189 = new ExifTag(TAG_IMAGE_LENGTH, 257, 3, 4);
        exifTagArray8[3] = exifTag195;
        ExifTag exifTag196 = exifTag188;
        exifTag188 = new ExifTag(TAG_BITS_PER_SAMPLE, 258, 3);
        exifTagArray8[4] = exifTag196;
        ExifTag exifTag197 = exifTag187;
        exifTag187 = new ExifTag(TAG_COMPRESSION, 259, 3);
        exifTagArray8[5] = exifTag197;
        ExifTag exifTag198 = exifTag186;
        exifTag186 = new ExifTag(TAG_PHOTOMETRIC_INTERPRETATION, 262, 3);
        exifTagArray8[6] = exifTag198;
        ExifTag exifTag199 = exifTag185;
        exifTag185 = new ExifTag(TAG_IMAGE_DESCRIPTION, 270, 2);
        exifTagArray8[7] = exifTag199;
        ExifTag exifTag200 = exifTag184;
        exifTag184 = new ExifTag(TAG_MAKE, 271, 2);
        exifTagArray8[8] = exifTag200;
        ExifTag exifTag201 = exifTag183;
        exifTag183 = new ExifTag(TAG_MODEL, 272, 2);
        exifTagArray8[9] = exifTag201;
        ExifTag exifTag202 = exifTag182;
        exifTag182 = new ExifTag(TAG_STRIP_OFFSETS, 273, 3, 4);
        exifTagArray8[10] = exifTag202;
        ExifTag exifTag203 = exifTag181;
        exifTag181 = new ExifTag(TAG_ORIENTATION, 274, 3);
        exifTagArray8[11] = exifTag203;
        ExifTag exifTag204 = exifTag180;
        exifTag180 = new ExifTag(TAG_SAMPLES_PER_PIXEL, 277, 3);
        exifTagArray8[12] = exifTag204;
        ExifTag exifTag205 = exifTag179;
        exifTag179 = new ExifTag(TAG_ROWS_PER_STRIP, 278, 3, 4);
        exifTagArray8[13] = exifTag205;
        ExifTag exifTag206 = exifTag178;
        exifTag178 = new ExifTag(TAG_STRIP_BYTE_COUNTS, 279, 3, 4);
        exifTagArray8[14] = exifTag206;
        ExifTag exifTag207 = exifTag177;
        exifTag177 = new ExifTag(TAG_X_RESOLUTION, 282, 5);
        exifTagArray8[15] = exifTag207;
        ExifTag exifTag208 = exifTag176;
        exifTag176 = new ExifTag(TAG_Y_RESOLUTION, 283, 5);
        exifTagArray8[16] = exifTag208;
        ExifTag exifTag209 = exifTag175;
        exifTag175 = new ExifTag(TAG_PLANAR_CONFIGURATION, 284, 3);
        exifTagArray8[17] = exifTag209;
        ExifTag exifTag210 = exifTag174;
        exifTag174 = new ExifTag(TAG_RESOLUTION_UNIT, 296, 3);
        exifTagArray8[18] = exifTag210;
        ExifTag exifTag211 = exifTag173;
        exifTag173 = new ExifTag(TAG_TRANSFER_FUNCTION, 301, 3);
        exifTagArray8[19] = exifTag211;
        ExifTag exifTag212 = exifTag172;
        exifTag172 = new ExifTag(TAG_SOFTWARE, 305, 2);
        exifTagArray8[20] = exifTag212;
        ExifTag exifTag213 = exifTag171;
        exifTag171 = new ExifTag(TAG_DATETIME, 306, 2);
        exifTagArray8[21] = exifTag213;
        ExifTag exifTag214 = exifTag170;
        exifTag170 = new ExifTag(TAG_ARTIST, 315, 2);
        exifTagArray8[22] = exifTag214;
        ExifTag exifTag215 = exifTag169;
        exifTag169 = new ExifTag(TAG_WHITE_POINT, 318, 5);
        exifTagArray8[23] = exifTag215;
        ExifTag exifTag216 = exifTag168;
        exifTag168 = new ExifTag(TAG_PRIMARY_CHROMATICITIES, 319, 5);
        exifTagArray8[24] = exifTag216;
        ExifTag exifTag217 = exifTag167;
        exifTag167 = new ExifTag(TAG_SUB_IFD_POINTER, 330, 4);
        exifTagArray8[25] = exifTag217;
        ExifTag exifTag218 = exifTag166;
        exifTag166 = new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT, 513, 4);
        exifTagArray8[26] = exifTag218;
        ExifTag exifTag219 = exifTag165;
        exifTag165 = new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, 514, 4);
        exifTagArray8[27] = exifTag219;
        ExifTag exifTag220 = exifTag164;
        exifTag164 = new ExifTag(TAG_Y_CB_CR_COEFFICIENTS, 529, 5);
        exifTagArray8[28] = exifTag220;
        ExifTag exifTag221 = exifTag163;
        exifTag163 = new ExifTag(TAG_Y_CB_CR_SUB_SAMPLING, 530, 3);
        exifTagArray8[29] = exifTag221;
        ExifTag exifTag222 = exifTag162;
        exifTag162 = new ExifTag(TAG_Y_CB_CR_POSITIONING, 531, 3);
        exifTagArray8[30] = exifTag222;
        ExifTag exifTag223 = exifTag161;
        exifTag161 = new ExifTag(TAG_REFERENCE_BLACK_WHITE, 532, 5);
        exifTagArray8[31] = exifTag223;
        ExifTag exifTag224 = exifTag160;
        exifTag160 = new ExifTag(TAG_COPYRIGHT, 33432, 2);
        exifTagArray8[32] = exifTag224;
        ExifTag exifTag225 = exifTag159;
        exifTag159 = new ExifTag(TAG_EXIF_IFD_POINTER, 34665, 4);
        exifTagArray8[33] = exifTag225;
        ExifTag exifTag226 = exifTag158;
        exifTag158 = new ExifTag(TAG_GPS_INFO_IFD_POINTER, 34853, 4);
        exifTagArray8[34] = exifTag226;
        ExifTag exifTag227 = exifTag157;
        exifTag157 = new ExifTag(TAG_RW2_SENSOR_TOP_BORDER, 4, 4);
        exifTagArray8[35] = exifTag227;
        ExifTag exifTag228 = exifTag156;
        exifTag156 = new ExifTag(TAG_RW2_SENSOR_LEFT_BORDER, 5, 4);
        exifTagArray8[36] = exifTag228;
        ExifTag exifTag229 = exifTag155;
        exifTag155 = new ExifTag(TAG_RW2_SENSOR_BOTTOM_BORDER, 6, 4);
        exifTagArray8[37] = exifTag229;
        ExifTag exifTag230 = exifTag154;
        exifTag154 = new ExifTag(TAG_RW2_SENSOR_RIGHT_BORDER, 7, 4);
        exifTagArray8[38] = exifTag230;
        ExifTag exifTag231 = exifTag153;
        exifTag153 = new ExifTag(TAG_RW2_ISO, 23, 3);
        exifTagArray8[39] = exifTag231;
        ExifTag exifTag232 = exifTag152;
        exifTag152 = new ExifTag(TAG_RW2_JPG_FROM_RAW, 46, 7);
        exifTagArray8[40] = exifTag232;
        ExifTag exifTag233 = exifTag151;
        exifTag151 = new ExifTag(TAG_XMP, 700, 1);
        exifTagArray8[41] = exifTag233;
        IFD_TIFF_TAGS = exifTagArray8;
        ExifTag[] exifTagArray9 = new ExifTag[74];
        ExifTag[] exifTagArray10 = exifTagArray9;
        ExifTag[] exifTagArray11 = exifTagArray7;
        exifTagArray7 = new ExifTag(TAG_EXPOSURE_TIME, 33434, 5);
        exifTagArray9[0] = exifTagArray11;
        exifTagArray11 = exifTag150;
        exifTag150 = new ExifTag(TAG_F_NUMBER, 33437, 5);
        exifTagArray9[1] = exifTagArray11;
        exifTagArray11 = exifTag149;
        exifTag149 = new ExifTag(TAG_EXPOSURE_PROGRAM, 34850, 3);
        exifTagArray9[2] = exifTagArray11;
        exifTagArray11 = exifTag148;
        exifTag148 = new ExifTag(TAG_SPECTRAL_SENSITIVITY, 34852, 2);
        exifTagArray9[3] = exifTagArray11;
        exifTagArray11 = exifTag147;
        exifTag147 = new ExifTag(TAG_PHOTOGRAPHIC_SENSITIVITY, 34855, 3);
        exifTagArray9[4] = exifTagArray11;
        exifTagArray11 = exifTag146;
        exifTag146 = new ExifTag(TAG_OECF, 34856, 7);
        exifTagArray9[5] = exifTagArray11;
        exifTagArray11 = exifTag145;
        exifTag145 = new ExifTag(TAG_SENSITIVITY_TYPE, 34864, 3);
        exifTagArray9[6] = exifTagArray11;
        exifTagArray11 = exifTag144;
        exifTag144 = new ExifTag(TAG_STANDARD_OUTPUT_SENSITIVITY, 34865, 4);
        exifTagArray9[7] = exifTagArray11;
        exifTagArray11 = exifTag143;
        exifTag143 = new ExifTag(TAG_RECOMMENDED_EXPOSURE_INDEX, 34866, 4);
        exifTagArray9[8] = exifTagArray11;
        exifTagArray11 = exifTag142;
        exifTag142 = new ExifTag(TAG_ISO_SPEED, 34867, 4);
        exifTagArray9[9] = exifTagArray11;
        exifTagArray11 = exifTag141;
        exifTag141 = new ExifTag(TAG_ISO_SPEED_LATITUDE_YYY, 34868, 4);
        exifTagArray9[10] = exifTagArray11;
        exifTagArray11 = exifTag140;
        exifTag140 = new ExifTag(TAG_ISO_SPEED_LATITUDE_ZZZ, 34869, 4);
        exifTagArray9[11] = exifTagArray11;
        exifTagArray11 = exifTag139;
        exifTag139 = new ExifTag(TAG_EXIF_VERSION, 36864, 2);
        exifTagArray9[12] = exifTagArray11;
        exifTagArray11 = exifTag138;
        exifTag138 = new ExifTag(TAG_DATETIME_ORIGINAL, 36867, 2);
        exifTagArray9[13] = exifTagArray11;
        exifTagArray11 = exifTag137;
        exifTag137 = new ExifTag(TAG_DATETIME_DIGITIZED, 36868, 2);
        exifTagArray9[14] = exifTagArray11;
        exifTagArray11 = exifTag136;
        exifTag136 = new ExifTag(TAG_OFFSET_TIME, 36880, 2);
        exifTagArray9[15] = exifTagArray11;
        exifTagArray11 = exifTag135;
        exifTag135 = new ExifTag(TAG_OFFSET_TIME_ORIGINAL, 36881, 2);
        exifTagArray9[16] = exifTagArray11;
        exifTagArray11 = exifTag134;
        exifTag134 = new ExifTag(TAG_OFFSET_TIME_DIGITIZED, 36882, 2);
        exifTagArray9[17] = exifTagArray11;
        exifTagArray11 = exifTag133;
        exifTag133 = new ExifTag(TAG_COMPONENTS_CONFIGURATION, 37121, 7);
        exifTagArray9[18] = exifTagArray11;
        exifTagArray11 = exifTag132;
        exifTag132 = new ExifTag(TAG_COMPRESSED_BITS_PER_PIXEL, 37122, 5);
        exifTagArray9[19] = exifTagArray11;
        exifTagArray11 = exifTag131;
        exifTag131 = new ExifTag(TAG_SHUTTER_SPEED_VALUE, 37377, 10);
        exifTagArray9[20] = exifTagArray11;
        exifTagArray11 = exifTag130;
        exifTag130 = new ExifTag(TAG_APERTURE_VALUE, 37378, 5);
        exifTagArray9[21] = exifTagArray11;
        exifTagArray11 = exifTag129;
        exifTag129 = new ExifTag(TAG_BRIGHTNESS_VALUE, 37379, 10);
        exifTagArray9[22] = exifTagArray11;
        exifTagArray11 = exifTag128;
        exifTag128 = new ExifTag(TAG_EXPOSURE_BIAS_VALUE, 37380, 10);
        exifTagArray9[23] = exifTagArray11;
        exifTagArray11 = exifTag127;
        exifTag127 = new ExifTag(TAG_MAX_APERTURE_VALUE, 37381, 5);
        exifTagArray9[24] = exifTagArray11;
        exifTagArray11 = exifTag126;
        exifTag126 = new ExifTag(TAG_SUBJECT_DISTANCE, 37382, 5);
        exifTagArray9[25] = exifTagArray11;
        exifTagArray11 = exifTag125;
        exifTag125 = new ExifTag(TAG_METERING_MODE, 37383, 3);
        exifTagArray9[26] = exifTagArray11;
        exifTagArray11 = exifTag124;
        exifTag124 = new ExifTag(TAG_LIGHT_SOURCE, 37384, 3);
        exifTagArray9[27] = exifTagArray11;
        exifTagArray11 = exifTag123;
        exifTag123 = new ExifTag(TAG_FLASH, 37385, 3);
        exifTagArray9[28] = exifTagArray11;
        exifTagArray11 = exifTag122;
        exifTag122 = new ExifTag(TAG_FOCAL_LENGTH, 37386, 5);
        exifTagArray9[29] = exifTagArray11;
        exifTagArray11 = exifTag121;
        exifTag121 = new ExifTag(TAG_SUBJECT_AREA, 37396, 3);
        exifTagArray9[30] = exifTagArray11;
        exifTagArray11 = exifTag120;
        exifTag120 = new ExifTag(TAG_MAKER_NOTE, 37500, 7);
        exifTagArray9[31] = exifTagArray11;
        exifTagArray11 = exifTag119;
        exifTag119 = new ExifTag(TAG_USER_COMMENT, 37510, 7);
        exifTagArray9[32] = exifTagArray11;
        exifTagArray11 = exifTag118;
        exifTag118 = new ExifTag(TAG_SUBSEC_TIME, 37520, 2);
        exifTagArray9[33] = exifTagArray11;
        exifTagArray11 = exifTag117;
        exifTag117 = new ExifTag(TAG_SUBSEC_TIME_ORIGINAL, 37521, 2);
        exifTagArray9[34] = exifTagArray11;
        exifTagArray11 = exifTag116;
        exifTag116 = new ExifTag(TAG_SUBSEC_TIME_DIGITIZED, 37522, 2);
        exifTagArray9[35] = exifTagArray11;
        exifTagArray11 = exifTag115;
        exifTag115 = new ExifTag(TAG_FLASHPIX_VERSION, 40960, 7);
        exifTagArray9[36] = exifTagArray11;
        exifTagArray11 = exifTag114;
        exifTag114 = new ExifTag(TAG_COLOR_SPACE, 40961, 3);
        exifTagArray9[37] = exifTagArray11;
        exifTagArray11 = exifTag113;
        exifTag113 = new ExifTag(TAG_PIXEL_X_DIMENSION, 40962, 3, 4);
        exifTagArray9[38] = exifTagArray11;
        exifTagArray11 = exifTag112;
        exifTag112 = new ExifTag(TAG_PIXEL_Y_DIMENSION, 40963, 3, 4);
        exifTagArray9[39] = exifTagArray11;
        exifTagArray11 = exifTag111;
        exifTag111 = new ExifTag(TAG_RELATED_SOUND_FILE, 40964, 2);
        exifTagArray9[40] = exifTagArray11;
        exifTagArray11 = exifTag110;
        exifTag110 = new ExifTag(TAG_INTEROPERABILITY_IFD_POINTER, 40965, 4);
        exifTagArray9[41] = exifTagArray11;
        exifTagArray11 = exifTag109;
        exifTag109 = new ExifTag(TAG_FLASH_ENERGY, 41483, 5);
        exifTagArray9[42] = exifTagArray11;
        exifTagArray11 = exifTag108;
        exifTag108 = new ExifTag(TAG_SPATIAL_FREQUENCY_RESPONSE, 41484, 7);
        exifTagArray9[43] = exifTagArray11;
        exifTagArray11 = exifTag107;
        exifTag107 = new ExifTag(TAG_FOCAL_PLANE_X_RESOLUTION, 41486, 5);
        exifTagArray9[44] = exifTagArray11;
        exifTagArray11 = exifTag106;
        exifTag106 = new ExifTag(TAG_FOCAL_PLANE_Y_RESOLUTION, 41487, 5);
        exifTagArray9[45] = exifTagArray11;
        exifTagArray11 = exifTag105;
        exifTag105 = new ExifTag(TAG_FOCAL_PLANE_RESOLUTION_UNIT, 41488, 3);
        exifTagArray9[46] = exifTagArray11;
        exifTagArray11 = exifTag104;
        exifTag104 = new ExifTag(TAG_SUBJECT_LOCATION, 41492, 3);
        exifTagArray9[47] = exifTagArray11;
        exifTagArray11 = exifTag103;
        exifTag103 = new ExifTag(TAG_EXPOSURE_INDEX, 41493, 5);
        exifTagArray9[48] = exifTagArray11;
        exifTagArray11 = exifTag102;
        exifTag102 = new ExifTag(TAG_SENSING_METHOD, 41495, 3);
        exifTagArray9[49] = exifTagArray11;
        exifTagArray11 = exifTag101;
        exifTag101 = new ExifTag(TAG_FILE_SOURCE, 41728, 7);
        exifTagArray9[50] = exifTagArray11;
        exifTagArray11 = exifTag100;
        exifTag100 = new ExifTag(TAG_SCENE_TYPE, 41729, 7);
        exifTagArray9[51] = exifTagArray11;
        exifTagArray11 = exifTag99;
        exifTag99 = new ExifTag(TAG_CFA_PATTERN, 41730, 7);
        exifTagArray9[52] = exifTagArray11;
        exifTagArray11 = exifTag98;
        exifTag98 = new ExifTag(TAG_CUSTOM_RENDERED, 41985, 3);
        exifTagArray9[53] = exifTagArray11;
        exifTagArray11 = exifTag97;
        exifTag97 = new ExifTag(TAG_EXPOSURE_MODE, 41986, 3);
        exifTagArray9[54] = exifTagArray11;
        exifTagArray11 = exifTag96;
        exifTag96 = new ExifTag(TAG_WHITE_BALANCE, 41987, 3);
        exifTagArray9[55] = exifTagArray11;
        exifTagArray11 = exifTag95;
        exifTag95 = new ExifTag(TAG_DIGITAL_ZOOM_RATIO, 41988, 5);
        exifTagArray9[56] = exifTagArray11;
        exifTagArray11 = exifTag94;
        exifTag94 = new ExifTag(TAG_FOCAL_LENGTH_IN_35MM_FILM, 41989, 3);
        exifTagArray9[57] = exifTagArray11;
        exifTagArray11 = exifTag93;
        exifTag93 = new ExifTag(TAG_SCENE_CAPTURE_TYPE, 41990, 3);
        exifTagArray9[58] = exifTagArray11;
        exifTagArray11 = exifTag92;
        exifTag92 = new ExifTag(TAG_GAIN_CONTROL, 41991, 3);
        exifTagArray9[59] = exifTagArray11;
        exifTagArray11 = exifTag91;
        exifTag91 = new ExifTag(TAG_CONTRAST, 41992, 3);
        exifTagArray9[60] = exifTagArray11;
        exifTagArray11 = exifTag90;
        exifTag90 = new ExifTag(TAG_SATURATION, 41993, 3);
        exifTagArray9[61] = exifTagArray11;
        exifTagArray11 = exifTag89;
        exifTag89 = new ExifTag(TAG_SHARPNESS, 41994, 3);
        exifTagArray9[62] = exifTagArray11;
        exifTagArray11 = exifTag88;
        exifTag88 = new ExifTag(TAG_DEVICE_SETTING_DESCRIPTION, 41995, 7);
        exifTagArray9[63] = exifTagArray11;
        exifTagArray11 = exifTag87;
        exifTag87 = new ExifTag(TAG_SUBJECT_DISTANCE_RANGE, 41996, 3);
        exifTagArray9[64] = exifTagArray11;
        exifTagArray11 = exifTag86;
        exifTag86 = new ExifTag(TAG_IMAGE_UNIQUE_ID, 42016, 2);
        exifTagArray9[65] = exifTagArray11;
        exifTagArray11 = exifTag85;
        exifTag85 = new ExifTag("CameraOwnerName", 42032, 2);
        exifTagArray9[66] = exifTagArray11;
        exifTagArray11 = exifTag84;
        exifTag84 = new ExifTag(TAG_BODY_SERIAL_NUMBER, 42033, 2);
        exifTagArray9[67] = exifTagArray11;
        exifTagArray11 = exifTag83;
        exifTag83 = new ExifTag(TAG_LENS_SPECIFICATION, 42034, 5);
        exifTagArray9[68] = exifTagArray11;
        exifTagArray11 = exifTag82;
        exifTag82 = new ExifTag(TAG_LENS_MAKE, 42035, 2);
        exifTagArray9[69] = exifTagArray11;
        exifTagArray11 = exifTag81;
        exifTag81 = new ExifTag(TAG_LENS_MODEL, 42036, 2);
        exifTagArray9[70] = exifTagArray11;
        exifTagArray11 = exifTag80;
        exifTag80 = new ExifTag(TAG_GAMMA, 42240, 5);
        exifTagArray9[71] = exifTagArray11;
        exifTagArray11 = exifTag79;
        exifTag79 = new ExifTag(TAG_DNG_VERSION, 50706, 1);
        exifTagArray9[72] = exifTagArray11;
        exifTagArray11 = exifTag78;
        exifTag78 = new ExifTag(TAG_DEFAULT_CROP_SIZE, 50720, 3, 4);
        exifTagArray9[73] = exifTagArray11;
        IFD_EXIF_TAGS = exifTagArray9;
        ExifTag[] exifTagArray12 = new ExifTag[32];
        exifTagArray11 = exifTagArray12;
        ExifTag[] exifTagArray13 = exifTagArray6;
        exifTagArray6 = new ExifTag(TAG_GPS_VERSION_ID, 0, 1);
        exifTagArray12[0] = exifTagArray13;
        exifTagArray13 = exifTag77;
        exifTag77 = new ExifTag(TAG_GPS_LATITUDE_REF, 1, 2);
        exifTagArray12[1] = exifTagArray13;
        exifTagArray13 = exifTag76;
        exifTag76 = new ExifTag(TAG_GPS_LATITUDE, 2, 5, 10);
        exifTagArray12[2] = exifTagArray13;
        exifTagArray13 = exifTag75;
        exifTag75 = new ExifTag(TAG_GPS_LONGITUDE_REF, 3, 2);
        exifTagArray12[3] = exifTagArray13;
        exifTagArray13 = exifTag74;
        exifTag74 = new ExifTag(TAG_GPS_LONGITUDE, 4, 5, 10);
        exifTagArray12[4] = exifTagArray13;
        exifTagArray13 = exifTag73;
        exifTag73 = new ExifTag(TAG_GPS_ALTITUDE_REF, 5, 1);
        exifTagArray12[5] = exifTagArray13;
        exifTagArray13 = exifTag72;
        exifTag72 = new ExifTag(TAG_GPS_ALTITUDE, 6, 5);
        exifTagArray12[6] = exifTagArray13;
        exifTagArray13 = exifTag71;
        exifTag71 = new ExifTag(TAG_GPS_TIMESTAMP, 7, 5);
        exifTagArray12[7] = exifTagArray13;
        exifTagArray13 = exifTag70;
        exifTag70 = new ExifTag(TAG_GPS_SATELLITES, 8, 2);
        exifTagArray12[8] = exifTagArray13;
        exifTagArray13 = exifTag69;
        exifTag69 = new ExifTag(TAG_GPS_STATUS, 9, 2);
        exifTagArray12[9] = exifTagArray13;
        exifTagArray13 = exifTag68;
        exifTag68 = new ExifTag(TAG_GPS_MEASURE_MODE, 10, 2);
        exifTagArray12[10] = exifTagArray13;
        exifTagArray13 = exifTag67;
        exifTag67 = new ExifTag(TAG_GPS_DOP, 11, 5);
        exifTagArray12[11] = exifTagArray13;
        exifTagArray13 = exifTag66;
        exifTag66 = new ExifTag(TAG_GPS_SPEED_REF, 12, 2);
        exifTagArray12[12] = exifTagArray13;
        exifTagArray13 = exifTag65;
        exifTag65 = new ExifTag(TAG_GPS_SPEED, 13, 5);
        exifTagArray12[13] = exifTagArray13;
        exifTagArray13 = exifTag64;
        exifTag64 = new ExifTag(TAG_GPS_TRACK_REF, 14, 2);
        exifTagArray12[14] = exifTagArray13;
        exifTagArray13 = exifTag63;
        exifTag63 = new ExifTag(TAG_GPS_TRACK, 15, 5);
        exifTagArray12[15] = exifTagArray13;
        exifTagArray13 = exifTag62;
        exifTag62 = new ExifTag(TAG_GPS_IMG_DIRECTION_REF, 16, 2);
        exifTagArray12[16] = exifTagArray13;
        exifTagArray13 = exifTag61;
        exifTag61 = new ExifTag(TAG_GPS_IMG_DIRECTION, 17, 5);
        exifTagArray12[17] = exifTagArray13;
        exifTagArray13 = exifTag60;
        exifTag60 = new ExifTag(TAG_GPS_MAP_DATUM, 18, 2);
        exifTagArray12[18] = exifTagArray13;
        exifTagArray13 = exifTag59;
        exifTag59 = new ExifTag(TAG_GPS_DEST_LATITUDE_REF, 19, 2);
        exifTagArray12[19] = exifTagArray13;
        exifTagArray13 = exifTag58;
        exifTag58 = new ExifTag(TAG_GPS_DEST_LATITUDE, 20, 5);
        exifTagArray12[20] = exifTagArray13;
        exifTagArray13 = exifTag57;
        exifTag57 = new ExifTag(TAG_GPS_DEST_LONGITUDE_REF, 21, 2);
        exifTagArray12[21] = exifTagArray13;
        exifTagArray13 = exifTag56;
        exifTag56 = new ExifTag(TAG_GPS_DEST_LONGITUDE, 22, 5);
        exifTagArray12[22] = exifTagArray13;
        exifTagArray13 = exifTag55;
        exifTag55 = new ExifTag(TAG_GPS_DEST_BEARING_REF, 23, 2);
        exifTagArray12[23] = exifTagArray13;
        exifTagArray13 = exifTag54;
        exifTag54 = new ExifTag(TAG_GPS_DEST_BEARING, 24, 5);
        exifTagArray12[24] = exifTagArray13;
        exifTagArray13 = exifTag53;
        exifTag53 = new ExifTag(TAG_GPS_DEST_DISTANCE_REF, 25, 2);
        exifTagArray12[25] = exifTagArray13;
        exifTagArray13 = exifTag52;
        exifTag52 = new ExifTag(TAG_GPS_DEST_DISTANCE, 26, 5);
        exifTagArray12[26] = exifTagArray13;
        exifTagArray13 = exifTag51;
        exifTag51 = new ExifTag(TAG_GPS_PROCESSING_METHOD, 27, 7);
        exifTagArray12[27] = exifTagArray13;
        exifTagArray13 = exifTag50;
        exifTag50 = new ExifTag(TAG_GPS_AREA_INFORMATION, 28, 7);
        exifTagArray12[28] = exifTagArray13;
        exifTagArray13 = exifTag49;
        exifTag49 = new ExifTag(TAG_GPS_DATESTAMP, 29, 2);
        exifTagArray12[29] = exifTagArray13;
        exifTagArray13 = exifTag48;
        exifTag48 = new ExifTag(TAG_GPS_DIFFERENTIAL, 30, 3);
        exifTagArray12[30] = exifTagArray13;
        exifTagArray13 = exifTag47;
        exifTag47 = new ExifTag(TAG_GPS_H_POSITIONING_ERROR, 31, 5);
        exifTagArray12[31] = exifTagArray13;
        IFD_GPS_TAGS = exifTagArray12;
        ExifTag[] exifTagArray14 = new ExifTag[1];
        exifTagArray13 = exifTagArray14;
        Object object32 = exifTagArray5;
        exifTagArray5 = new ExifTag(TAG_INTEROPERABILITY_INDEX, 1, 2);
        exifTagArray14[0] = object32;
        IFD_INTEROPERABILITY_TAGS = exifTagArray14;
        ExifTag[] exifTagArray15 = new ExifTag[37];
        object32 = exifTagArray15;
        ExifTag[] exifTagArray16 = exifTagArray4;
        exifTagArray4 = new ExifTag(TAG_NEW_SUBFILE_TYPE, 254, 4);
        exifTagArray15[0] = exifTagArray16;
        exifTagArray16 = exifTag46;
        exifTag46 = new ExifTag(TAG_SUBFILE_TYPE, 255, 4);
        exifTagArray15[1] = exifTagArray16;
        exifTagArray16 = exifTag45;
        exifTag45 = new ExifTag(TAG_THUMBNAIL_IMAGE_WIDTH, 256, 3, 4);
        exifTagArray15[2] = exifTagArray16;
        exifTagArray16 = exifTag44;
        exifTag44 = new ExifTag(TAG_THUMBNAIL_IMAGE_LENGTH, 257, 3, 4);
        exifTagArray15[3] = exifTagArray16;
        exifTagArray16 = exifTag43;
        exifTag43 = new ExifTag(TAG_BITS_PER_SAMPLE, 258, 3);
        exifTagArray15[4] = exifTagArray16;
        exifTagArray16 = exifTag42;
        exifTag42 = new ExifTag(TAG_COMPRESSION, 259, 3);
        exifTagArray15[5] = exifTagArray16;
        exifTagArray16 = exifTag41;
        exifTag41 = new ExifTag(TAG_PHOTOMETRIC_INTERPRETATION, 262, 3);
        exifTagArray15[6] = exifTagArray16;
        exifTagArray16 = exifTag40;
        exifTag40 = new ExifTag(TAG_IMAGE_DESCRIPTION, 270, 2);
        exifTagArray15[7] = exifTagArray16;
        exifTagArray16 = exifTag39;
        exifTag39 = new ExifTag(TAG_MAKE, 271, 2);
        exifTagArray15[8] = exifTagArray16;
        exifTagArray16 = exifTag38;
        exifTag38 = new ExifTag(TAG_MODEL, 272, 2);
        exifTagArray15[9] = exifTagArray16;
        exifTagArray16 = exifTag37;
        exifTag37 = new ExifTag(TAG_STRIP_OFFSETS, 273, 3, 4);
        exifTagArray15[10] = exifTagArray16;
        exifTagArray16 = exifTag36;
        exifTag36 = new ExifTag(TAG_THUMBNAIL_ORIENTATION, 274, 3);
        exifTagArray15[11] = exifTagArray16;
        exifTagArray16 = exifTag35;
        exifTag35 = new ExifTag(TAG_SAMPLES_PER_PIXEL, 277, 3);
        exifTagArray15[12] = exifTagArray16;
        exifTagArray16 = exifTag34;
        exifTag34 = new ExifTag(TAG_ROWS_PER_STRIP, 278, 3, 4);
        exifTagArray15[13] = exifTagArray16;
        exifTagArray16 = exifTag33;
        exifTag33 = new ExifTag(TAG_STRIP_BYTE_COUNTS, 279, 3, 4);
        exifTagArray15[14] = exifTagArray16;
        exifTagArray16 = exifTag32;
        exifTag32 = new ExifTag(TAG_X_RESOLUTION, 282, 5);
        exifTagArray15[15] = exifTagArray16;
        exifTagArray16 = exifTag31;
        exifTag31 = new ExifTag(TAG_Y_RESOLUTION, 283, 5);
        exifTagArray15[16] = exifTagArray16;
        exifTagArray16 = exifTag30;
        exifTag30 = new ExifTag(TAG_PLANAR_CONFIGURATION, 284, 3);
        exifTagArray15[17] = exifTagArray16;
        exifTagArray16 = exifTag29;
        exifTag29 = new ExifTag(TAG_RESOLUTION_UNIT, 296, 3);
        exifTagArray15[18] = exifTagArray16;
        exifTagArray16 = exifTag28;
        exifTag28 = new ExifTag(TAG_TRANSFER_FUNCTION, 301, 3);
        exifTagArray15[19] = exifTagArray16;
        exifTagArray16 = exifTag27;
        exifTag27 = new ExifTag(TAG_SOFTWARE, 305, 2);
        exifTagArray15[20] = exifTagArray16;
        exifTagArray16 = exifTag26;
        exifTag26 = new ExifTag(TAG_DATETIME, 306, 2);
        exifTagArray15[21] = exifTagArray16;
        exifTagArray16 = exifTag25;
        exifTag25 = new ExifTag(TAG_ARTIST, 315, 2);
        exifTagArray15[22] = exifTagArray16;
        exifTagArray16 = exifTag24;
        exifTag24 = new ExifTag(TAG_WHITE_POINT, 318, 5);
        exifTagArray15[23] = exifTagArray16;
        exifTagArray16 = exifTag23;
        exifTag23 = new ExifTag(TAG_PRIMARY_CHROMATICITIES, 319, 5);
        exifTagArray15[24] = exifTagArray16;
        exifTagArray16 = exifTag22;
        exifTag22 = new ExifTag(TAG_SUB_IFD_POINTER, 330, 4);
        exifTagArray15[25] = exifTagArray16;
        exifTagArray16 = exifTag21;
        exifTag21 = new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT, 513, 4);
        exifTagArray15[26] = exifTagArray16;
        exifTagArray16 = exifTag20;
        exifTag20 = new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, 514, 4);
        exifTagArray15[27] = exifTagArray16;
        exifTagArray16 = exifTag19;
        exifTag19 = new ExifTag(TAG_Y_CB_CR_COEFFICIENTS, 529, 5);
        exifTagArray15[28] = exifTagArray16;
        exifTagArray16 = exifTag18;
        exifTag18 = new ExifTag(TAG_Y_CB_CR_SUB_SAMPLING, 530, 3);
        exifTagArray15[29] = exifTagArray16;
        exifTagArray16 = exifTag17;
        exifTag17 = new ExifTag(TAG_Y_CB_CR_POSITIONING, 531, 3);
        exifTagArray15[30] = exifTagArray16;
        exifTagArray16 = exifTag16;
        exifTag16 = new ExifTag(TAG_REFERENCE_BLACK_WHITE, 532, 5);
        exifTagArray15[31] = exifTagArray16;
        exifTagArray16 = exifTag15;
        exifTag15 = new ExifTag(TAG_COPYRIGHT, 33432, 2);
        exifTagArray15[32] = exifTagArray16;
        exifTagArray16 = exifTag14;
        exifTag14 = new ExifTag(TAG_EXIF_IFD_POINTER, 34665, 4);
        exifTagArray15[33] = exifTagArray16;
        exifTagArray16 = exifTag13;
        exifTag13 = new ExifTag(TAG_GPS_INFO_IFD_POINTER, 34853, 4);
        exifTagArray15[34] = exifTagArray16;
        exifTagArray16 = exifTag12;
        exifTag12 = new ExifTag(TAG_DNG_VERSION, 50706, 1);
        exifTagArray15[35] = exifTagArray16;
        exifTagArray16 = exifTag11;
        exifTag11 = new ExifTag(TAG_DEFAULT_CROP_SIZE, 50720, 3, 4);
        exifTagArray15[36] = exifTagArray16;
        IFD_THUMBNAIL_TAGS = exifTagArray15;
        TAG_RAF_IMAGE_SIZE = new ExifTag(TAG_STRIP_OFFSETS, 273, 3);
        ExifTag[] exifTagArray17 = new ExifTag[3];
        exifTagArray16 = exifTagArray17;
        ExifTag[] exifTagArray18 = exifTagArray3;
        exifTagArray3 = new ExifTag(TAG_ORF_THUMBNAIL_IMAGE, 256, 7);
        exifTagArray17[0] = exifTagArray18;
        exifTagArray18 = exifTag10;
        exifTag10 = new ExifTag(TAG_ORF_CAMERA_SETTINGS_IFD_POINTER, 8224, 4);
        exifTagArray17[1] = exifTagArray18;
        exifTagArray18 = exifTag9;
        exifTag9 = new ExifTag(TAG_ORF_IMAGE_PROCESSING_IFD_POINTER, 8256, 4);
        exifTagArray17[2] = exifTagArray18;
        ORF_MAKER_NOTE_TAGS = exifTagArray17;
        ExifTag[] exifTagArray19 = new ExifTag[2];
        exifTagArray18 = exifTagArray19;
        ExifTag[] exifTagArray20 = exifTagArray2;
        exifTagArray2 = new ExifTag(TAG_ORF_PREVIEW_IMAGE_START, 257, 4);
        exifTagArray19[0] = exifTagArray20;
        exifTagArray20 = exifTag8;
        exifTag8 = new ExifTag(TAG_ORF_PREVIEW_IMAGE_LENGTH, 258, 4);
        exifTagArray19[1] = exifTagArray20;
        ORF_CAMERA_SETTINGS_TAGS = exifTagArray19;
        ExifTag[] exifTagArray21 = new ExifTag[1];
        exifTagArray20 = exifTagArray21;
        ExifTag[] exifTagArray22 = exifTagArray;
        exifTagArray = new ExifTag(TAG_ORF_ASPECT_FRAME, 4371, 3);
        exifTagArray21[0] = exifTagArray22;
        ORF_IMAGE_PROCESSING_TAGS = exifTagArray21;
        ExifTag[] exifTagArray23 = new ExifTag[1];
        exifTagArray22 = exifTagArray23;
        ExifTag exifTag234 = exifTag7;
        exifTag7 = new ExifTag(TAG_COLOR_SPACE, 55, 3);
        exifTagArray23[0] = exifTag234;
        PEF_TAGS = exifTagArray23;
        EXIF_TAGS = new ExifTag[][]{object, exifTagArray10, exifTagArray11, exifTagArray13, object32, object, exifTagArray16, exifTagArray18, exifTagArray20, exifTagArray22};
        ExifTag[] exifTagArray24 = new ExifTag[6];
        object = exifTag6;
        exifTag6 = new ExifTag(TAG_SUB_IFD_POINTER, 330, 4);
        exifTagArray24[0] = object;
        object = exifTag5;
        exifTag5 = new ExifTag(TAG_EXIF_IFD_POINTER, 34665, 4);
        exifTagArray24[1] = object;
        object = exifTag4;
        exifTag4 = new ExifTag(TAG_GPS_INFO_IFD_POINTER, 34853, 4);
        exifTagArray24[2] = object;
        object = exifTag3;
        exifTag3 = new ExifTag(TAG_INTEROPERABILITY_IFD_POINTER, 40965, 4);
        exifTagArray24[3] = object;
        object = exifTag2;
        exifTag2 = new ExifTag(TAG_ORF_CAMERA_SETTINGS_IFD_POINTER, 8224, 1);
        exifTagArray24[4] = object;
        object = exifTag;
        exifTag = new ExifTag(TAG_ORF_IMAGE_PROCESSING_IFD_POINTER, 8256, 1);
        exifTagArray24[5] = object;
        EXIF_POINTER_TAGS = exifTagArray24;
        JPEG_INTERCHANGE_FORMAT_TAG = new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT, 513, 4);
        JPEG_INTERCHANGE_FORMAT_LENGTH_TAG = new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, 514, 4);
        sExifTagMapsForReading = new HashMap[EXIF_TAGS.length];
        sExifTagMapsForWriting = new HashMap[EXIF_TAGS.length];
        sTagSetForCompatibility = new HashSet<String>(Arrays.asList(TAG_F_NUMBER, TAG_DIGITAL_ZOOM_RATIO, TAG_EXPOSURE_TIME, TAG_SUBJECT_DISTANCE, TAG_GPS_TIMESTAMP));
        sExifPointerTagMap = new HashMap();
        object = Charset.forName("US-ASCII");
        ASCII = object;
        IDENTIFIER_EXIF_APP1 = "Exif\u0000\u0000".getBytes((Charset)object);
        IDENTIFIER_XMP_APP1 = "http://ns.adobe.com/xap/1.0/\u0000".getBytes((Charset)object);
        object = Locale.US;
        sFormatterPrimary = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss", (Locale)object);
        sFormatterPrimary.setTimeZone(TimeZone.getTimeZone("UTC"));
        sFormatterSecondary = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", (Locale)object);
        sFormatterSecondary.setTimeZone(TimeZone.getTimeZone("UTC"));
        int n2 = 0;
        while (true) {
            HashMap hashMap;
            HashMap hashMap2;
            ExifTag[][] exifTagArray25 = EXIF_TAGS;
            if (n2 >= EXIF_TAGS.length) break;
            HashMap hashMap3 = hashMap2;
            hashMap2 = new HashMap();
            ExifInterface.sExifTagMapsForReading[n2] = hashMap3;
            HashMap hashMap4 = hashMap;
            hashMap = new HashMap();
            ExifInterface.sExifTagMapsForWriting[n2] = hashMap4;
            for (Object object32 : exifTagArray25[n2]) {
                sExifTagMapsForReading[n2].put(object32.number, (ExifTag)object32);
                sExifTagMapsForWriting[n2].put(object32.name, (ExifTag)object32);
            }
            ++n2;
        }
        HashMap<Integer, Integer> hashMap = sExifPointerTagMap;
        ExifTag[] exifTagArray26 = EXIF_POINTER_TAGS;
        hashMap.put(exifTagArray26[0].number, 5);
        hashMap.put(exifTagArray26[1].number, 1);
        hashMap.put(exifTagArray26[2].number, 2);
        hashMap.put(exifTagArray26[3].number, 3);
        hashMap.put(exifTagArray26[4].number, 7);
        hashMap.put(EXIF_POINTER_TAGS[5].number, 8);
        NON_ZERO_TIME_PATTERN = Pattern.compile(".*[1-9].*");
        GPS_TIMESTAMP_PATTERN = Pattern.compile("^(\\d{2}):(\\d{2}):(\\d{2})$");
        DATETIME_PRIMARY_FORMAT_PATTERN = Pattern.compile("^(\\d{4}):(\\d{2}):(\\d{2})\\s(\\d{2}):(\\d{2}):(\\d{2})$");
        DATETIME_SECONDARY_FORMAT_PATTERN = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})\\s(\\d{2}):(\\d{2}):(\\d{2})$");
    }

    public String getAttribute(String string2) {
        if (string2 != null) {
            ExifAttribute exifAttribute = objectArray.getExifAttribute(string2);
            if (exifAttribute != null) {
                if (!sTagSetForCompatibility.contains(string2)) {
                    return exifAttribute.getStringValue(objectArray.mExifByteOrder);
                }
                if (string2.equals(TAG_GPS_TIMESTAMP)) {
                    int n2 = exifAttribute.format;
                    if (n2 != 5 && n2 != 10) {
                        Log.w((String)TAG, (String)("GPS Timestamp format is not rational. format=" + exifAttribute.format));
                        return null;
                    }
                    Object[] objectArray = (Rational[])exifAttribute.getValue(objectArray.mExifByteOrder);
                    if (objectArray != null && objectArray.length == 3) {
                        Object[] objectArray2 = new Object[3];
                        Object[] objectArray3 = objectArray2;
                        objectArray3[0] = (int)((float)((Rational)objectArray[0]).numerator / (float)((Rational)objectArray[0]).denominator);
                        objectArray3[1] = (int)((float)((Rational)objectArray[1]).numerator / (float)((Rational)objectArray[1]).denominator);
                        objectArray2[2] = (int)((float)((Rational)objectArray[2]).numerator / (float)((Rational)objectArray[2]).denominator);
                        return String.format("%02d:%02d:%02d", objectArray3);
                    }
                    Log.w((String)TAG, (String)("Invalid GPS Timestamp array. array=" + Arrays.toString(objectArray)));
                    return null;
                }
                try {
                    return Double.toString(exifAttribute.getDoubleValue(objectArray.mExifByteOrder));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            return null;
        }
        throw new NullPointerException("tag shouldn't be null");
    }

    public int getAttributeInt(String object, int n2) {
        if (object != null) {
            if ((object = this.getExifAttribute((String)object)) == null) {
                return n2;
            }
            try {
                return ((ExifAttribute)object).getIntValue(this.mExifByteOrder);
            }
            catch (NumberFormatException numberFormatException) {
                return n2;
            }
        }
        throw new NullPointerException("tag shouldn't be null");
    }

    public double getAttributeDouble(String object, double d2) {
        if (object != null) {
            if ((object = this.getExifAttribute((String)object)) == null) {
                return d2;
            }
            try {
                return ((ExifAttribute)object).getDoubleValue(this.mExifByteOrder);
            }
            catch (NumberFormatException numberFormatException) {
                return d2;
            }
        }
        throw new NullPointerException("tag shouldn't be null");
    }

    public void setAttribute(String string2, String string3) {
        if (string2 != null) {
            int n2;
            if ((TAG_DATETIME.equals(string2) || TAG_DATETIME_ORIGINAL.equals(string2) || TAG_DATETIME_DIGITIZED.equals(string2)) && string3 != null) {
                n2 = DATETIME_PRIMARY_FORMAT_PATTERN.matcher(string3).find();
                boolean bl = DATETIME_SECONDARY_FORMAT_PATTERN.matcher(string3).find();
                if (string3.length() == 19 && (n2 != 0 || bl)) {
                    if (bl) {
                        string3 = string3.replaceAll("-", ":");
                    }
                } else {
                    Log.w((String)TAG, (String)("Invalid value for " + string2 + " : " + string3));
                    return;
                }
            }
            if (TAG_ISO_SPEED_RATINGS.equals(string2)) {
                if (DEBUG) {
                    Log.d((String)TAG, (String)"setAttribute: Replacing TAG_ISO_SPEED_RATINGS with TAG_PHOTOGRAPHIC_SENSITIVITY.");
                }
                string2 = TAG_PHOTOGRAPHIC_SENSITIVITY;
            }
            if (string3 != null && sTagSetForCompatibility.contains(string2)) {
                if (string2.equals(TAG_GPS_TIMESTAMP)) {
                    Matcher matcher = GPS_TIMESTAMP_PATTERN.matcher(string3);
                    if (!matcher.find()) {
                        Log.w((String)TAG, (String)("Invalid value for " + string2 + " : " + string3));
                        return;
                    }
                    string3 = Integer.parseInt(matcher.group(1)) + "/1," + Integer.parseInt(matcher.group(2)) + "/1," + Integer.parseInt(matcher.group(3)) + "/1";
                } else {
                    double d2;
                    try {
                        d2 = Double.parseDouble(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Log.w((String)TAG, (String)("Invalid value for " + string2 + " : " + string3));
                        return;
                    }
                    string3 = new Rational(d2).toString();
                }
            }
            block13: for (n2 = 0; n2 < EXIF_TAGS.length; ++n2) {
                Object object;
                String[] stringArray;
                int n3;
                Object object2;
                if (n2 == 4 && !this.mHasThumbnail || (object2 = sExifTagMapsForWriting[n2].get(string2)) == null) continue;
                if (string3 == null) {
                    this.mAttributes[n2].remove(string2);
                    continue;
                }
                Object object3 = ExifInterface.guessDataFormat(string3);
                if (((ExifTag)object2).primaryFormat != (Integer)object3.first && ((ExifTag)object2).primaryFormat != (Integer)object3.second) {
                    n3 = ((ExifTag)object2).secondaryFormat;
                    if (n3 != -1 && (n3 == (Integer)object3.first || ((ExifTag)object2).secondaryFormat == (Integer)object3.second)) {
                        int n4;
                        n3 = n4 = ((ExifTag)object2).secondaryFormat;
                    } else {
                        n3 = ((ExifTag)object2).primaryFormat;
                        if (n3 != 1 && n3 != 7 && n3 != 2) {
                            if (!DEBUG) continue;
                            String string4 = TAG;
                            stringArray = IFD_FORMAT_NAMES;
                            object = new StringBuilder().append("Given tag (").append(string2).append(") value didn't match with one of expected formats: ").append(IFD_FORMAT_NAMES[((ExifTag)object2).primaryFormat]);
                            object2 = ((ExifTag)object2).secondaryFormat == -1 ? "" : ", " + stringArray[((ExifTag)object2).secondaryFormat];
                            object2 = ((StringBuilder)object).append((String)object2).append(" (guess: ").append(stringArray[(Integer)object3.first]);
                            object3 = (Integer)object3.second == -1 ? "" : ", " + stringArray[(Integer)object3.second];
                            Log.d((String)string4, (String)((StringBuilder)object2).append((String)object3).append(")").toString());
                            continue;
                        }
                    }
                } else {
                    n3 = ((ExifTag)object2).primaryFormat;
                }
                switch (n3) {
                    default: {
                        if (!DEBUG) continue block13;
                        Log.d((String)TAG, (String)("Data format isn't one of expected formats: " + n3));
                        continue block13;
                    }
                    case 12: {
                        String[] stringArray2 = string3.split(",", -1);
                        object3 = new double[stringArray2.length];
                        for (n3 = 0; n3 < stringArray2.length; ++n3) {
                            object3[n3] = (Rational)Double.parseDouble(stringArray2[n3]);
                        }
                        this.mAttributes[n2].put(string2, ExifAttribute.createDouble((double[])object3, this.mExifByteOrder));
                        continue block13;
                    }
                    case 10: {
                        long l2;
                        long l3;
                        String[] stringArray3 = string3.split(",", -1);
                        object3 = new Rational[stringArray3.length];
                        for (n3 = 0; n3 < stringArray3.length; ++n3) {
                            Rational rational;
                            stringArray = stringArray3[n3].split("/", -1);
                            object = rational;
                            l3 = (long)Double.parseDouble(stringArray[0]);
                            l2 = (long)Double.parseDouble(stringArray[1]);
                            rational = new Rational(l3, l2);
                            object3[n3] = object;
                        }
                        this.mAttributes[n2].put(string2, ExifAttribute.createSRational(object3, this.mExifByteOrder));
                        continue block13;
                    }
                    case 9: {
                        String[] stringArray4 = string3.split(",", -1);
                        object3 = new int[stringArray4.length];
                        for (n3 = 0; n3 < stringArray4.length; ++n3) {
                            object3[n3] = (Rational)Integer.parseInt(stringArray4[n3]);
                        }
                        this.mAttributes[n2].put(string2, ExifAttribute.createSLong((int[])object3, this.mExifByteOrder));
                        continue block13;
                    }
                    case 5: {
                        long l2;
                        long l3;
                        String[] stringArray5 = string3.split(",", -1);
                        object3 = new Rational[stringArray5.length];
                        for (n3 = 0; n3 < stringArray5.length; ++n3) {
                            Rational rational;
                            stringArray = stringArray5[n3].split("/", -1);
                            object = rational;
                            l3 = (long)Double.parseDouble(stringArray[0]);
                            l2 = (long)Double.parseDouble(stringArray[1]);
                            rational = new Rational(l3, l2);
                            object3[n3] = object;
                        }
                        this.mAttributes[n2].put(string2, ExifAttribute.createURational(object3, this.mExifByteOrder));
                        continue block13;
                    }
                    case 4: {
                        String[] stringArray6 = string3.split(",", -1);
                        object3 = new long[stringArray6.length];
                        for (n3 = 0; n3 < stringArray6.length; ++n3) {
                            object3[n3] = (Rational)Long.parseLong(stringArray6[n3]);
                        }
                        this.mAttributes[n2].put(string2, ExifAttribute.createULong((long[])object3, this.mExifByteOrder));
                        continue block13;
                    }
                    case 3: {
                        String[] stringArray7 = string3.split(",", -1);
                        object3 = new int[stringArray7.length];
                        for (n3 = 0; n3 < stringArray7.length; ++n3) {
                            object3[n3] = (Rational)Integer.parseInt(stringArray7[n3]);
                        }
                        this.mAttributes[n2].put(string2, ExifAttribute.createUShort((int[])object3, this.mExifByteOrder));
                        continue block13;
                    }
                    case 2: 
                    case 7: {
                        this.mAttributes[n2].put(string2, ExifAttribute.createString(string3));
                        continue block13;
                    }
                    case 1: {
                        this.mAttributes[n2].put(string2, ExifAttribute.createByte(string3));
                    }
                }
            }
            return;
        }
        throw new NullPointerException("tag shouldn't be null");
    }

    public void resetOrientation() {
        this.setAttribute(TAG_ORIENTATION, Integer.toString(1));
    }

    public void rotate(int n2) {
        if (n2 % 90 == 0) {
            int n3;
            List<Integer> list = ROTATION_ORDER;
            int n4 = this.getAttributeInt(TAG_ORIENTATION, 1);
            if (list.contains(n4)) {
                n2 = (list.indexOf(n4) + n2 / 90) % 4;
                n4 = n2 < 0 ? 4 : 0;
                n3 = list.get(n2 + n4);
            } else {
                list = FLIPPED_ROTATION_ORDER;
                if (list.contains(n4)) {
                    n2 = (list.indexOf(n4) + n2 / 90) % 4;
                    n4 = n2 < 0 ? 4 : 0;
                    n3 = list.get(n2 + n4);
                } else {
                    n3 = 0;
                }
            }
            String string2 = Integer.toString(n3);
            this.setAttribute(TAG_ORIENTATION, string2);
            return;
        }
        throw new IllegalArgumentException("degree should be a multiple of 90");
    }

    public void flipVertically() {
        int n2;
        switch (this.getAttributeInt(TAG_ORIENTATION, 1)) {
            default: {
                n2 = 0;
                break;
            }
            case 8: {
                n2 = 5;
                break;
            }
            case 7: {
                n2 = 6;
                break;
            }
            case 6: {
                n2 = 7;
                break;
            }
            case 5: {
                n2 = 8;
                break;
            }
            case 4: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 4;
            }
        }
        String string2 = Integer.toString(n2);
        this.setAttribute(TAG_ORIENTATION, string2);
    }

    public void flipHorizontally() {
        int n2;
        switch (this.getAttributeInt(TAG_ORIENTATION, 1)) {
            default: {
                n2 = 0;
                break;
            }
            case 8: {
                n2 = 7;
                break;
            }
            case 7: {
                n2 = 8;
                break;
            }
            case 6: {
                n2 = 5;
                break;
            }
            case 5: {
                n2 = 6;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
            }
        }
        String string2 = Integer.toString(n2);
        this.setAttribute(TAG_ORIENTATION, string2);
    }

    public boolean isFlipped() {
        int n2 = this.getAttributeInt(TAG_ORIENTATION, 1);
        return n2 == 2 || n2 == 7 || n2 == 4 || n2 == 5;
    }

    public int getRotationDegrees() {
        switch (this.getAttributeInt(TAG_ORIENTATION, 1)) {
            default: {
                return 0;
            }
            case 6: 
            case 7: {
                return 90;
            }
            case 5: 
            case 8: {
                return 270;
            }
            case 3: 
            case 4: 
        }
        return 180;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveAttributes() throws IOException {
        block60: {
            block62: {
                block66: {
                    block68: {
                        block67: {
                            block61: {
                                block65: {
                                    block69: {
                                        block58: {
                                            block59: {
                                                if (!this.isSupportedFormatForSavingAttributes()) {
                                                    throw new IOException("ExifInterface only supports saving attributes on JPEG, PNG, or WebP formats.");
                                                }
                                                if (this.mSeekableFileDescriptor == null && this.mFilename == null) {
                                                    throw new IOException("ExifInterface does not support saving attributes for the current input.");
                                                }
                                                v0 = this;
                                                v0.mModified = true;
                                                v0.mThumbnailBytes = v0.getThumbnail();
                                                var1_15 /* !! */  = null;
                                                var2_17 /* !! */  = null;
                                                var3_19 = File.createTempFile("temp", "tmp");
                                                if (v0.mFilename == null) ** GOTO lbl17
                                                var4_20 /* !! */  = v1;
                                                v1 = new FileInputStream(this.mFilename);
                                                break block58;
lbl17:
                                                // 1 sources

                                                if (Build.VERSION.SDK_INT < 21) break block59;
                                                Os.lseek((FileDescriptor)this.mSeekableFileDescriptor, (long)0L, (int)OsConstants.SEEK_SET);
                                                var4_20 /* !! */  = v2;
                                                v2 = new FileInputStream(this.mSeekableFileDescriptor);
                                                break block58;
                                            }
                                            var4_20 /* !! */  = var1_15 /* !! */ ;
                                        }
                                        v3 = this;
                                        var1_15 /* !! */  = v4;
                                        v5 = var4_20 /* !! */ ;
                                        v6 = v5;
                                        v7 = v5;
                                        v8 /* !! */  = var1_15 /* !! */ ;
                                        v9 /* !! */  = v8 /* !! */ ;
                                        v8 /* !! */ (var3_19);
                                        ** try [egrp 6[TRYBLOCK] [20, 21 : 138->141)] { 
lbl38:
                                        // 1 sources

                                        break block69;
lbl39:
                                        // 1 sources

                                        catch (Throwable v10) {
                                            // empty catch block
                                            break block60;
                                        }
                                        catch (Throwable v10) {
                                            v11 = var1_15 /* !! */ ;
                                            var1_15 /* !! */  = var2_17 /* !! */ ;
                                            var4_20 /* !! */  = v11;
                                            break block60;
                                        }
                                        catch (Exception var0_13) {
                                            v12 = var1_15 /* !! */ ;
                                            var1_15 /* !! */  = var2_17 /* !! */ ;
                                            var4_20 /* !! */  = v12;
                                            throw new IOException("Failed to copy original file to temp file", (Throwable)var0_14);
                                        }
                                        catch (Throwable v10) {
                                            var1_15 /* !! */  = var2_17 /* !! */ ;
                                            break block60;
                                        }
                                        catch (Exception var0_12) {
                                            var1_15 /* !! */  = var2_17 /* !! */ ;
                                            throw new IOException("Failed to copy original file to temp file", (Throwable)var0_14);
                                        }
                                    }
                                    ExifInterface.copy(v6, (OutputStream)v9 /* !! */ );
                                    ExifInterface.closeQuietly(v7);
                                    ExifInterface.closeQuietly(v4);
                                    var1_15 /* !! */  = null;
                                    var2_17 /* !! */  = null;
                                    var4_20 /* !! */  = null;
                                    var5_22 = null;
                                    var6_25 = false;
                                    var7_26 = v13;
                                    try {
                                        try {
                                            v13 = new FileInputStream(var3_19);
                                        }
                                        catch (Exception var7_27) {
                                            v14 /* !! */  = var1_15 /* !! */ ;
                                            v15 = var2_17 /* !! */ ;
                                            v16 = var4_20 /* !! */ ;
                                            var4_20 /* !! */  = var5_22;
                                            var2_17 /* !! */  = v16;
                                            var1_15 /* !! */  = v15;
                                            var5_22 = v14 /* !! */ ;
                                            break block61;
                                        }
                                        if (v3.mFilename == null) ** GOTO lbl102
                                        ** GOTO lbl99
                                    }
                                    catch (Throwable var0_2) {
                                        v17 = var4_20 /* !! */ ;
                                        var4_20 /* !! */  = var5_22;
                                        var2_17 /* !! */  = v17;
                                        break block62;
                                    }
                                    {
                                        block63: {
                                            block64: {
                                                catch (Exception var1_16) {
                                                    v18 = var2_17 /* !! */ ;
                                                    v19 = var4_20 /* !! */ ;
                                                    var4_20 /* !! */  = var5_22;
                                                    var2_17 /* !! */  = v19;
                                                    var1_15 /* !! */  = v18;
                                                    var5_22 = var7_26;
                                                    var7_26 = var1_16;
                                                    break block61;
                                                }
lbl99:
                                                // 1 sources

                                                var1_15 /* !! */  = v20;
                                                {
                                                    v20 = new FileOutputStream(this.mFilename);
                                                    break block63;
lbl102:
                                                    // 1 sources

                                                    if (Build.VERSION.SDK_INT < 21) break block64;
                                                    Os.lseek((FileDescriptor)this.mSeekableFileDescriptor, (long)0L, (int)OsConstants.SEEK_SET);
                                                }
                                                var1_15 /* !! */  = v21;
                                                {
                                                    v21 = new FileOutputStream(this.mSeekableFileDescriptor);
                                                    break block63;
                                                }
                                            }
                                            var1_15 /* !! */  = var2_17 /* !! */ ;
                                        }
                                        try {
                                            v22 = this;
                                        }
                                        catch (Exception var2_18) {
                                            v23 = var4_20 /* !! */ ;
                                            var4_20 /* !! */  = var5_22;
                                            var2_17 /* !! */  = v23;
                                            var5_22 = var7_26;
                                            var7_26 = var2_18;
                                            break block61;
                                        }
                                    }
                                    var2_17 /* !! */  = v24;
                                    {
                                        v24 = new BufferedInputStream((InputStream)var7_26);
                                    }
                                    var4_20 /* !! */  = v25;
                                    try {
                                        v25 = new BufferedOutputStream((OutputStream)var1_15 /* !! */ );
                                    }
                                    catch (Throwable var0_1) {
                                        var4_20 /* !! */  = var5_22;
                                        break block62;
                                    }
                                    catch (Exception var4_21) {
                                        var4_20 /* !! */  = var5_22;
                                        var5_22 = var7_26;
                                        var7_26 = var4_21;
                                        break block61;
                                    }
                                    try {
                                        var5_23 = v22.mMimeType;
                                        if (var5_23 == 4) {
                                            this.saveJpegAttributes(var2_17 /* !! */ , (OutputStream)var4_20 /* !! */ );
                                            break block65;
                                        }
                                        if (var5_23 == 13) {
                                            this.savePngAttributes(var2_17 /* !! */ , (OutputStream)var4_20 /* !! */ );
                                            break block65;
                                        }
                                        if (var5_23 != 14) break block65;
                                        this.saveWebpAttributes(var2_17 /* !! */ , (OutputStream)var4_20 /* !! */ );
                                    }
                                    catch (Exception var5_24) {
                                        var5_22 = var7_26;
                                        var7_26 = var5_24;
                                    }
                                }
                                ExifInterface.closeQuietly(var2_17 /* !! */ );
                                ExifInterface.closeQuietly(var4_20 /* !! */ );
                                var3_19.delete();
                                this.mThumbnailBytes = null;
                                return;
                            }
                            try {
                                v26 = this;
                            }
                            catch (Throwable var0_6) {
                                v27 /* !! */  = var5_22;
                                var5_22 = var1_15 /* !! */ ;
                                var8_28 = v27 /* !! */ ;
                                ** GOTO lbl-1000
                            }
                            catch (Exception var0_7) {
                                v28 /* !! */  = var5_22;
                                var5_22 = var1_15 /* !! */ ;
                                var8_28 = v28 /* !! */ ;
                                break block66;
                            }
                            var8_28 = v29;
                            {
                                v29 = new FileInputStream(var3_19);
                            }
                            try {
                                if (v26.mFilename != null) break block67;
                                if (Build.VERSION.SDK_INT >= 21) {
                                    Os.lseek((FileDescriptor)this.mSeekableFileDescriptor, (long)0L, (int)OsConstants.SEEK_SET);
                                }
                                ** GOTO lbl186
                            }
                            catch (Throwable var0_4) {
                                var5_22 = var1_15 /* !! */ ;
                                ** GOTO lbl-1000
                            }
                            catch (Exception var0_5) {
                                var5_22 = var1_15 /* !! */ ;
                                break block66;
                            }
                            var5_22 = v30;
                            {
                                v30 = new FileOutputStream(this.mSeekableFileDescriptor);
                                break block68;
lbl186:
                                // 1 sources

                                var5_22 = var1_15 /* !! */ ;
                                break block68;
                            }
                        }
                        var5_22 = v31;
                        {
                            v31 = new FileOutputStream(this.mFilename);
                        }
                    }
                    try {
                        v32 /* !! */  = var5_22;
                        v33 = var8_28;
                        v34 = v33;
                        ExifInterface.copy(v33, (OutputStream)var5_22);
                    }
                    catch (Exception var0_3) {}
                    {
                        ExifInterface.closeQuietly(v34);
                        ExifInterface.closeQuietly(v32 /* !! */ );
                        throw new IOException("Failed to save new file", (Throwable)var7_26);
                    }
                }
                var6_25 = true;
                {
                    throw new IOException("Failed to save new file. Original file is stored in " + var3_19.getAbsolutePath(), (Throwable)this);
                }
lbl-1000:
                // 2 sources

                {
                    ExifInterface.closeQuietly(var8_28);
                    ExifInterface.closeQuietly((Closeable)var5_22);
                    throw this;
                }
            }
            ExifInterface.closeQuietly(var2_17 /* !! */ );
            ExifInterface.closeQuietly(var4_20 /* !! */ );
            if (var6_25) throw var0_10;
            var3_19.delete();
            throw var0_10;
lbl215:
            // 1 sources

            catch (Exception var0_11) {}
            {
                throw new IOException("Failed to copy original file to temp file", (Throwable)var0_14);
            }
        }
        ExifInterface.closeQuietly(var4_20 /* !! */ );
        ExifInterface.closeQuietly(var1_15 /* !! */ );
        throw v10;
    }

    public boolean hasThumbnail() {
        return this.mHasThumbnail;
    }

    public boolean hasAttribute(String string2) {
        return this.getExifAttribute(string2) != null;
    }

    public byte[] getThumbnail() {
        int n2 = this.mThumbnailCompression;
        if (n2 != 6 && n2 != 7) {
            return null;
        }
        return this.getThumbnailBytes();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getThumbnailBytes() {
        block26: {
            block23: {
                block24: {
                    block21: {
                        block22: {
                            block20: {
                                if (!this.mHasThumbnail) {
                                    return null;
                                }
                                var1_7 = this.mThumbnailBytes;
                                if (this.mThumbnailBytes != null) {
                                    return var1_7;
                                }
                                var1_7 = null;
                                var2_8 = null;
                                var3_9 = this.mAssetInputStream;
                                if (var3_9 == null) break block20;
                                if (var3_9.markSupported()) {
                                    var3_9.reset();
                                    break block21;
                                }
                                Log.d((String)"ExifInterface", (String)"Cannot read thumbnail from inputstream without mark/reset support");
                                ExifInterface.closeQuietly((Closeable)var3_9);
                                return null;
                            }
                            if (this.mFilename == null) ** GOTO lbl26
                            var3_9 = v0;
                            v0 = new FileInputStream(this.mFilename);
                            break block21;
lbl26:
                            // 1 sources

                            if (Build.VERSION.SDK_INT < 21) break block22;
                            var2_8 = Os.dup((FileDescriptor)this.mSeekableFileDescriptor);
                            Os.lseek((FileDescriptor)var2_8, (long)0L, (int)OsConstants.SEEK_SET);
                            var3_9 = v1;
                            v1 = new FileInputStream(var2_8);
                            break block21;
                        }
                        var3_9 = var1_7;
                    }
                    if (var3_9 == null) ** GOTO lbl58
                    if (var3_9.skip(this.mThumbnailOffset + this.mOffsetToExifData) != (long)(this.mThumbnailOffset + this.mOffsetToExifData)) ** GOTO lbl57
                    v2 = var3_9;
                    var1_7 = new byte[this.mThumbnailLength];
                    if (v2.read(var1_7) != this.mThumbnailLength) break block23;
                    this.mThumbnailBytes = var1_7;
                    ExifInterface.closeQuietly((Closeable)var3_9);
                    if (var2_8 == null) break block24;
                    ExifInterface.closeFileDescriptor(var2_8);
                }
                return var1_7;
            }
            try {
                block25: {
                    try {
                        throw new IOException("Corrupted image");
                    }
                    catch (Exception var0_1) {
                        break block25;
                    }
lbl57:
                    // 1 sources

                    throw new IOException("Corrupted image");
lbl58:
                    // 1 sources

                    throw new FileNotFoundException();
                    catch (Throwable var0_2) {
                        var3_9 = var1_7;
                        break block26;
                    }
                    catch (Exception var0_3) {
                        var3_9 = var1_7;
                    }
                }
                v3 = var2_8;
                v4 = var3_9;
                Log.d((String)"ExifInterface", (String)"Encountered exception while getting thumbnail", (Throwable)var0_4);
            }
            catch (Throwable var0_5) {
                // empty catch block
            }
            ExifInterface.closeQuietly((Closeable)v4);
            if (v3 != null) {
                ExifInterface.closeFileDescriptor(var2_8);
            }
            return null;
        }
        ExifInterface.closeQuietly((Closeable)var3_9);
        if (var2_8 != null) {
            ExifInterface.closeFileDescriptor(var2_8);
        }
        throw var0_6;
    }

    public Bitmap getThumbnailBitmap() {
        int n2;
        if (!this.mHasThumbnail) {
            return null;
        }
        if (this.mThumbnailBytes == null) {
            this.mThumbnailBytes = this.getThumbnailBytes();
        }
        if ((n2 = this.mThumbnailCompression) != 6 && n2 != 7) {
            if (n2 == 1) {
                n2 = this.mThumbnailBytes.length / 3;
                int[] nArray = new int[n2];
                int n3 = 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    byte[] byArray = this.mThumbnailBytes;
                    int n4 = i2 * 3;
                    nArray[i2] = n3 + (this.mThumbnailBytes[n4] << 16) + (byArray[n4 + 1] << 8) + byArray[n4 + 2];
                }
                ExifAttribute exifAttribute = this.mAttributes[4].get(TAG_IMAGE_LENGTH);
                ExifAttribute exifAttribute2 = this.mAttributes[4].get(TAG_IMAGE_WIDTH);
                if (exifAttribute != null && exifAttribute2 != null) {
                    int n5 = exifAttribute.getIntValue(this.mExifByteOrder);
                    return Bitmap.createBitmap((int[])nArray, (int)exifAttribute2.getIntValue(this.mExifByteOrder), (int)n5, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
            }
            return null;
        }
        return BitmapFactory.decodeByteArray((byte[])this.mThumbnailBytes, (int)0, (int)this.mThumbnailLength);
    }

    public boolean isThumbnailCompressed() {
        if (!this.mHasThumbnail) {
            return false;
        }
        int n2 = this.mThumbnailCompression;
        return n2 == 6 || n2 == 7;
        {
        }
    }

    public long[] getThumbnailRange() {
        if (!this.mModified) {
            if (this.mHasThumbnail) {
                if (this.mHasThumbnailStrips && !this.mAreThumbnailStripsConsecutive) {
                    return null;
                }
                long l2 = this.mThumbnailOffset + this.mOffsetToExifData;
                l2 = this.mThumbnailLength;
                return new long[]{l2, l2};
            }
            return null;
        }
        throw new IllegalStateException("The underlying file has been modified since being parsed");
    }

    public long[] getAttributeRange(String string2) {
        if (string2 != null) {
            if (!((ExifInterface)this).mModified) {
                if ((this = ((ExifInterface)this).getExifAttribute(string2)) != null) {
                    long l2 = ((ExifAttribute)this).bytesOffset;
                    l2 = ((ExifAttribute)this).bytes.length;
                    return new long[]{l2, l2};
                }
                return null;
            }
            throw new IllegalStateException("The underlying file has been modified since being parsed");
        }
        throw new NullPointerException("tag shouldn't be null");
    }

    public byte[] getAttributeBytes(String string2) {
        if (string2 != null) {
            if ((this = ((ExifInterface)this).getExifAttribute(string2)) != null) {
                return ((ExifAttribute)this).bytes;
            }
            return null;
        }
        throw new NullPointerException("tag shouldn't be null");
    }

    @Deprecated
    public boolean getLatLong(float[] fArray) {
        double[] dArray = ((ExifInterface)object).getLatLong();
        Object object = dArray;
        if (dArray == null) {
            return false;
        }
        fArray[0] = (float)object[0];
        fArray[1] = (float)object[1];
        return true;
    }

    public double[] getLatLong() {
        String string2 = ((ExifInterface)((Object)string3)).getAttribute(TAG_GPS_LATITUDE);
        ExifInterface exifInterface = string3;
        String string3 = exifInterface.getAttribute(TAG_GPS_LATITUDE_REF);
        String string4 = exifInterface.getAttribute(TAG_GPS_LONGITUDE);
        String string5 = exifInterface.getAttribute(TAG_GPS_LONGITUDE_REF);
        if (string2 != null && string3 != null && string4 != null && string5 != null) {
            String string6 = string4;
            String string7 = string5;
            double d2 = ExifInterface.convertRationalLatLonToDouble(string2, string3);
            double d3 = ExifInterface.convertRationalLatLonToDouble(string6, string7);
            try {
                return new double[]{d2, d3};
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object[] objectArray = new Object[4];
                Object[] objectArray2 = objectArray;
                objectArray[0] = string2;
                objectArray[1] = string3;
                objectArray[2] = string4;
                objectArray[3] = string5;
                Log.w((String)TAG, (String)("Latitude/longitude values are not parsable. " + String.format("latValue=%s, latRef=%s, lngValue=%s, lngRef=%s", objectArray2)));
            }
        }
        return null;
    }

    public void setGpsInfo(Location location) {
        if (location == null) {
            return;
        }
        ExifInterface exifInterface = this;
        Location location2 = location;
        this.setAttribute(TAG_GPS_PROCESSING_METHOD, location.getProvider());
        double d2 = location2.getLatitude();
        double d3 = location2.getLongitude();
        this.setLatLong(d2, d3);
        exifInterface.setAltitude(location.getAltitude());
        exifInterface.setAttribute(TAG_GPS_SPEED_REF, "K");
        exifInterface.setAttribute(TAG_GPS_SPEED, new Rational(location.getSpeed() * (float)TimeUnit.HOURS.toSeconds(1L) / 1000.0f).toString());
        String[] stringArray = sFormatterPrimary.format(new Date(location.getTime())).split("\\s+", -1);
        this.setAttribute(TAG_GPS_DATESTAMP, stringArray[0]);
        exifInterface.setAttribute(TAG_GPS_TIMESTAMP, stringArray[1]);
    }

    public void setLatLong(double d2, double d3) {
        if (!(d2 < -90.0 || d2 > 90.0 || Double.isNaN(d2))) {
            if (!(d3 < -180.0 || d3 > 180.0 || Double.isNaN(d3))) {
                String string2 = TAG_GPS_LATITUDE_REF;
                String string3 = d2 >= 0.0 ? "N" : LATITUDE_SOUTH;
                ExifInterface exifInterface = this;
                this.setAttribute(string2, string3);
                exifInterface.setAttribute(TAG_GPS_LATITUDE, exifInterface.convertDecimalDegree(Math.abs(d2)));
                String string4 = TAG_GPS_LONGITUDE_REF;
                String string5 = d3 >= 0.0 ? LONGITUDE_EAST : LONGITUDE_WEST;
                ExifInterface exifInterface2 = this;
                this.setAttribute(string4, string5);
                exifInterface2.setAttribute(TAG_GPS_LONGITUDE, exifInterface2.convertDecimalDegree(Math.abs(d3)));
                return;
            }
            throw new IllegalArgumentException("Longitude value " + d3 + " is not valid.");
        }
        throw new IllegalArgumentException("Latitude value " + d2 + " is not valid.");
    }

    public double getAltitude(double d2) {
        double d3;
        double d4 = this.getAttributeDouble(TAG_GPS_ALTITUDE, -1.0);
        int n2 = this.getAttributeInt(TAG_GPS_ALTITUDE_REF, -1);
        if (d3 >= 0.0 && n2 >= 0) {
            double d5 = n2 == 1 ? -1 : 1;
            return d4 * d5;
        }
        return d2;
    }

    public void setAltitude(double d2) {
        String string2 = d2 >= 0.0 ? "0" : "1";
        ExifInterface exifInterface = this;
        exifInterface.setAttribute(TAG_GPS_ALTITUDE, new Rational(Math.abs(d2)).toString());
        exifInterface.setAttribute(TAG_GPS_ALTITUDE_REF, string2);
    }

    public void setDateTime(Long l2) {
        long l3 = l2 % 1000L;
        this.setAttribute(TAG_DATETIME, sFormatterPrimary.format(new Date(l2)));
        this.setAttribute(TAG_SUBSEC_TIME, Long.toString(l3));
    }

    public Long getDateTime() {
        String string2 = ((ExifInterface)((Object)string3)).getAttribute(TAG_DATETIME);
        ExifInterface exifInterface = string3;
        String string3 = exifInterface.getAttribute(TAG_SUBSEC_TIME);
        return ExifInterface.parseDateTime(string2, string3, exifInterface.getAttribute(TAG_OFFSET_TIME));
    }

    public Long getDateTimeDigitized() {
        String string2 = ((ExifInterface)((Object)string3)).getAttribute(TAG_DATETIME_DIGITIZED);
        ExifInterface exifInterface = string3;
        String string3 = exifInterface.getAttribute(TAG_SUBSEC_TIME_DIGITIZED);
        return ExifInterface.parseDateTime(string2, string3, exifInterface.getAttribute(TAG_OFFSET_TIME_DIGITIZED));
    }

    public Long getDateTimeOriginal() {
        String string2 = ((ExifInterface)((Object)string3)).getAttribute(TAG_DATETIME_ORIGINAL);
        ExifInterface exifInterface = string3;
        String string3 = exifInterface.getAttribute(TAG_SUBSEC_TIME_ORIGINAL);
        return ExifInterface.parseDateTime(string2, string3, exifInterface.getAttribute(TAG_OFFSET_TIME_ORIGINAL));
    }

    public Long getGpsDateTime() {
        Serializable serializable;
        Object object = ((ExifInterface)object2).getAttribute(TAG_GPS_DATESTAMP);
        Object object2 = ((ExifInterface)object2).getAttribute(TAG_GPS_TIMESTAMP);
        if (object != null && object2 != null && (((Pattern)(serializable = NON_ZERO_TIME_PATTERN)).matcher((CharSequence)object).matches() || ((Pattern)serializable).matcher((CharSequence)object2).matches())) {
            block5: {
                ParsePosition parsePosition;
                object2 = (String)object + ' ' + (String)object2;
                object = parsePosition;
                parsePosition = new ParsePosition(0);
                try {
                    serializable = sFormatterPrimary.parse((String)object2, (ParsePosition)object);
                    if (serializable != null) break block5;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
                serializable = sFormatterSecondary.parse((String)object2, (ParsePosition)object);
                if (serializable != null) break block5;
                return null;
            }
            return ((Date)serializable).getTime();
        }
        return null;
    }

    private static class ByteOrderedDataOutputStream
    extends FilterOutputStream {
        final OutputStream mOutputStream;
        private ByteOrder mByteOrder;

        public ByteOrderedDataOutputStream(OutputStream outputStream, ByteOrder byteOrder) {
            super(outputStream);
            this.mOutputStream = outputStream;
            this.mByteOrder = byteOrder;
        }

        public void setByteOrder(ByteOrder byteOrder) {
            this.mByteOrder = byteOrder;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.mOutputStream.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.mOutputStream.write(byArray, n2, n3);
        }

        public void writeByte(int n2) throws IOException {
            this.mOutputStream.write(n2);
        }

        public void writeShort(short s) throws IOException {
            ByteOrder byteOrder = this.mByteOrder;
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                ByteOrderedDataOutputStream byteOrderedDataOutputStream = this;
                byteOrderedDataOutputStream.mOutputStream.write(s >>> 0 & 0xFF);
                byteOrderedDataOutputStream.mOutputStream.write(s >>> 8 & 0xFF);
            } else if (byteOrder == ByteOrder.BIG_ENDIAN) {
                ByteOrderedDataOutputStream byteOrderedDataOutputStream = this;
                byteOrderedDataOutputStream.mOutputStream.write(s >>> 8 & 0xFF);
                byteOrderedDataOutputStream.mOutputStream.write(s >>> 0 & 0xFF);
            }
        }

        public void writeInt(int n2) throws IOException {
            ByteOrder byteOrder = this.mByteOrder;
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                ByteOrderedDataOutputStream byteOrderedDataOutputStream = this;
                byteOrderedDataOutputStream.mOutputStream.write(n2 >>> 0 & 0xFF);
                byteOrderedDataOutputStream.mOutputStream.write(n2 >>> 8 & 0xFF);
                byteOrderedDataOutputStream.mOutputStream.write(n2 >>> 16 & 0xFF);
                byteOrderedDataOutputStream.mOutputStream.write(n2 >>> 24 & 0xFF);
            } else if (byteOrder == ByteOrder.BIG_ENDIAN) {
                ByteOrderedDataOutputStream byteOrderedDataOutputStream = this;
                byteOrderedDataOutputStream.mOutputStream.write(n2 >>> 24 & 0xFF);
                byteOrderedDataOutputStream.mOutputStream.write(n2 >>> 16 & 0xFF);
                byteOrderedDataOutputStream.mOutputStream.write(n2 >>> 8 & 0xFF);
                byteOrderedDataOutputStream.mOutputStream.write(n2 >>> 0 & 0xFF);
            }
        }

        public void writeUnsignedShort(int n2) throws IOException {
            this.writeShort((short)n2);
        }

        public void writeUnsignedInt(long l2) throws IOException {
            this.writeInt((int)l2);
        }
    }

    private static class ByteOrderedDataInputStream
    extends InputStream
    implements DataInput {
        private static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
        private static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
        private DataInputStream mDataInputStream;
        private ByteOrder mByteOrder;
        final int mLength;
        int mPosition;

        public ByteOrderedDataInputStream(InputStream inputStream) throws IOException {
            this(inputStream, ByteOrder.BIG_ENDIAN);
        }

        ByteOrderedDataInputStream(InputStream inputStream, ByteOrder byteOrder) throws IOException {
            int n2;
            ByteOrderedDataInputStream byteOrderedDataInputStream = this;
            byteOrderedDataInputStream.mByteOrder = ByteOrder.BIG_ENDIAN;
            this.mDataInputStream = new DataInputStream(inputStream);
            byteOrderedDataInputStream.mLength = n2 = this.mDataInputStream.available();
            byteOrderedDataInputStream.mPosition = 0;
            byteOrderedDataInputStream.mDataInputStream.mark(n2);
            this.mByteOrder = byteOrder;
        }

        public ByteOrderedDataInputStream(byte[] byArray) throws IOException {
            ByteArrayInputStream byteArrayInputStream;
            ByteOrderedDataInputStream byteOrderedDataInputStream = inputStream;
            InputStream inputStream = byteArrayInputStream;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            byteOrderedDataInputStream(inputStream);
        }

        public void setByteOrder(ByteOrder byteOrder) {
            this.mByteOrder = byteOrder;
        }

        public void seek(long l2) throws IOException {
            int n2 = this.mPosition;
            if ((long)n2 > l2) {
                ByteOrderedDataInputStream byteOrderedDataInputStream = this;
                byteOrderedDataInputStream.mPosition = 0;
                byteOrderedDataInputStream.mDataInputStream.reset();
                byteOrderedDataInputStream.mDataInputStream.mark(this.mLength);
            } else {
                l2 -= (long)n2;
            }
            int n3 = (int)l2;
            if (this.skipBytes(n3) == n3) {
                return;
            }
            throw new IOException("Couldn't seek up to the byteCount");
        }

        public int peek() {
            return this.mPosition;
        }

        @Override
        public int available() throws IOException {
            return this.mDataInputStream.available();
        }

        @Override
        public int read() throws IOException {
            ByteOrderedDataInputStream byteOrderedDataInputStream = this;
            ++byteOrderedDataInputStream.mPosition;
            return byteOrderedDataInputStream.mDataInputStream.read();
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4 = this.mDataInputStream.read(byArray, n2, n3);
            this.mPosition += n4;
            return n4;
        }

        @Override
        public int readUnsignedByte() throws IOException {
            ByteOrderedDataInputStream byteOrderedDataInputStream = this;
            ++byteOrderedDataInputStream.mPosition;
            return byteOrderedDataInputStream.mDataInputStream.readUnsignedByte();
        }

        @Override
        public String readLine() throws IOException {
            Log.d((String)ExifInterface.TAG, (String)"Currently unsupported");
            return null;
        }

        @Override
        public boolean readBoolean() throws IOException {
            ByteOrderedDataInputStream byteOrderedDataInputStream = this;
            ++byteOrderedDataInputStream.mPosition;
            return byteOrderedDataInputStream.mDataInputStream.readBoolean();
        }

        @Override
        public char readChar() throws IOException {
            ByteOrderedDataInputStream byteOrderedDataInputStream = this;
            byteOrderedDataInputStream.mPosition += 2;
            return byteOrderedDataInputStream.mDataInputStream.readChar();
        }

        @Override
        public String readUTF() throws IOException {
            ByteOrderedDataInputStream byteOrderedDataInputStream = this;
            byteOrderedDataInputStream.mPosition += 2;
            return byteOrderedDataInputStream.mDataInputStream.readUTF();
        }

        @Override
        public void readFully(byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            this.mPosition = n4 = this.mPosition + n3;
            if (n4 <= this.mLength) {
                if (this.mDataInputStream.read(byArray, n2, n3) == n3) {
                    return;
                }
                throw new IOException("Couldn't read up to the length of buffer");
            }
            throw new EOFException();
        }

        @Override
        public void readFully(byte[] byArray) throws IOException {
            int n2;
            this.mPosition = n2 = this.mPosition + byArray.length;
            if (n2 <= this.mLength) {
                if (this.mDataInputStream.read(byArray, 0, byArray.length) == byArray.length) {
                    return;
                }
                throw new IOException("Couldn't read up to the length of buffer");
            }
            throw new EOFException();
        }

        @Override
        public byte readByte() throws IOException {
            int n2;
            this.mPosition = n2 = this.mPosition + 1;
            if (n2 <= this.mLength) {
                int n3 = this.mDataInputStream.read();
                if (n3 >= 0) {
                    return (byte)n3;
                }
                throw new EOFException();
            }
            throw new EOFException();
        }

        @Override
        public short readShort() throws IOException {
            int n2;
            this.mPosition = n2 = this.mPosition + 2;
            if (n2 <= this.mLength) {
                int n3;
                n2 = this.mDataInputStream.read();
                if ((n2 | (n3 = this.mDataInputStream.read())) >= 0) {
                    ByteOrder byteOrder = this.mByteOrder;
                    if (byteOrder == LITTLE_ENDIAN) {
                        return (short)((n3 << 8) + n2);
                    }
                    if (byteOrder == BIG_ENDIAN) {
                        return (short)((n2 << 8) + n3);
                    }
                    throw new IOException("Invalid byte order: " + this.mByteOrder);
                }
                throw new EOFException();
            }
            throw new EOFException();
        }

        @Override
        public int readInt() throws IOException {
            int n2;
            this.mPosition = n2 = this.mPosition + 4;
            if (n2 <= this.mLength) {
                int n3;
                n2 = this.mDataInputStream.read();
                int n4 = this.mDataInputStream.read();
                ByteOrderedDataInputStream byteOrderedDataInputStream = this;
                int n5 = byteOrderedDataInputStream.mDataInputStream.read();
                if ((n2 | n4 | n5 | (n3 = byteOrderedDataInputStream.mDataInputStream.read())) >= 0) {
                    ByteOrder byteOrder = this.mByteOrder;
                    if (byteOrder == LITTLE_ENDIAN) {
                        return (n3 << 24) + (n5 << 16) + (n4 << 8) + n2;
                    }
                    if (byteOrder == BIG_ENDIAN) {
                        return (n2 << 24) + (n4 << 16) + (n5 << 8) + n3;
                    }
                    throw new IOException("Invalid byte order: " + this.mByteOrder);
                }
                throw new EOFException();
            }
            throw new EOFException();
        }

        @Override
        public int skipBytes(int n2) throws IOException {
            int n3;
            n2 = Math.min(n2, this.mLength - this.mPosition);
            for (n3 = 0; n3 < n2; n3 += this.mDataInputStream.skipBytes(n2 - n3)) {
            }
            this.mPosition += n3;
            return n3;
        }

        @Override
        public int readUnsignedShort() throws IOException {
            int n2;
            this.mPosition = n2 = this.mPosition + 2;
            if (n2 <= this.mLength) {
                int n3;
                n2 = this.mDataInputStream.read();
                if ((n2 | (n3 = this.mDataInputStream.read())) >= 0) {
                    ByteOrder byteOrder = this.mByteOrder;
                    if (byteOrder == LITTLE_ENDIAN) {
                        return (n3 << 8) + n2;
                    }
                    if (byteOrder == BIG_ENDIAN) {
                        return (n2 << 8) + n3;
                    }
                    throw new IOException("Invalid byte order: " + this.mByteOrder);
                }
                throw new EOFException();
            }
            throw new EOFException();
        }

        public long readUnsignedInt() throws IOException {
            return (long)this.readInt() & 0xFFFFFFFFL;
        }

        @Override
        public long readLong() throws IOException {
            int n2;
            this.mPosition = n2 = this.mPosition + 8;
            if (n2 <= this.mLength) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                n2 = this.mDataInputStream.read();
                int n8 = this.mDataInputStream.read();
                ByteOrderedDataInputStream byteOrderedDataInputStream = this;
                int n9 = byteOrderedDataInputStream.mDataInputStream.read();
                if ((n2 | n8 | n9 | (n7 = byteOrderedDataInputStream.mDataInputStream.read()) | (n6 = byteOrderedDataInputStream.mDataInputStream.read()) | (n5 = byteOrderedDataInputStream.mDataInputStream.read()) | (n4 = byteOrderedDataInputStream.mDataInputStream.read()) | (n3 = byteOrderedDataInputStream.mDataInputStream.read())) >= 0) {
                    ByteOrder byteOrder = this.mByteOrder;
                    if (byteOrder == LITTLE_ENDIAN) {
                        return ((long)n3 << 56) + ((long)n4 << 48) + ((long)n5 << 40) + ((long)n6 << 32) + ((long)n7 << 24) + ((long)n9 << 16) + ((long)n8 << 8) + (long)n2;
                    }
                    if (byteOrder == BIG_ENDIAN) {
                        return ((long)n2 << 56) + ((long)n8 << 48) + ((long)n9 << 40) + ((long)n7 << 32) + ((long)n6 << 24) + ((long)n5 << 16) + ((long)n4 << 8) + (long)n3;
                    }
                    throw new IOException("Invalid byte order: " + this.mByteOrder);
                }
                throw new EOFException();
            }
            throw new EOFException();
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        @Override
        public synchronized void mark(int n2) {
            this.mDataInputStream.mark(n2);
        }

        public int getLength() {
            return this.mLength;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IfdType {
    }

    static class ExifTag {
        public final int number;
        public final String name;
        public final int primaryFormat;
        public final int secondaryFormat;

        ExifTag(String string2, int n2, int n3) {
            this.name = string2;
            this.number = n2;
            this.primaryFormat = n3;
            this.secondaryFormat = -1;
        }

        ExifTag(String string2, int n2, int n3, int n4) {
            this.name = string2;
            this.number = n2;
            this.primaryFormat = n3;
            this.secondaryFormat = n4;
        }

        boolean isFormatCompatible(int n2) {
            int n3 = this.primaryFormat;
            if (n3 != 7 && n2 != 7) {
                int n4;
                if (n3 != n2 && (n4 = this.secondaryFormat) != n2) {
                    if ((n3 == 4 || n4 == 4) && n2 == 3) {
                        return true;
                    }
                    if ((n3 == 9 || n4 == 9) && n2 == 8) {
                        return true;
                    }
                    return (n3 == 12 || n4 == 12) && n2 == 11;
                }
                return true;
            }
            return true;
        }
    }

    private static class ExifAttribute {
        public static final long BYTES_OFFSET_UNKNOWN = -1L;
        public final int format;
        public final int numberOfComponents;
        public final long bytesOffset;
        public final byte[] bytes;

        ExifAttribute(int n2, int n3, byte[] byArray) {
            this(n2, n3, -1L, byArray);
        }

        ExifAttribute(int n2, int n3, long l2, byte[] byArray) {
            this.format = n2;
            this.numberOfComponents = n3;
            this.bytesOffset = l2;
            this.bytes = byArray;
        }

        public static ExifAttribute createUShort(int[] nArray, ByteOrder byteOrder) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[3] * nArray.length]);
            byteBuffer.order(byteOrder);
            int n2 = nArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                byteBuffer.putShort((short)nArray[i2]);
            }
            int n3 = nArray.length;
            byte[] byArray = byteBuffer.array();
            return new ExifAttribute(3, n3, byArray);
        }

        public static ExifAttribute createUShort(int n2, ByteOrder byteOrder) {
            return ExifAttribute.createUShort(new int[]{n2}, byteOrder);
        }

        public static ExifAttribute createULong(long[] lArray, ByteOrder byteOrder) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[4] * lArray.length]);
            byteBuffer.order(byteOrder);
            int n2 = lArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                byteBuffer.putInt((int)lArray[i2]);
            }
            int n3 = lArray.length;
            byte[] byArray = byteBuffer.array();
            return new ExifAttribute(4, n3, byArray);
        }

        public static ExifAttribute createULong(long l2, ByteOrder byteOrder) {
            return ExifAttribute.createULong(new long[]{l2}, byteOrder);
        }

        public static ExifAttribute createSLong(int[] nArray, ByteOrder byteOrder) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[9] * nArray.length]);
            byteBuffer.order(byteOrder);
            int n2 = nArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                byteBuffer.putInt(nArray[i2]);
            }
            int n3 = nArray.length;
            byte[] byArray = byteBuffer.array();
            return new ExifAttribute(9, n3, byArray);
        }

        public static ExifAttribute createSLong(int n2, ByteOrder byteOrder) {
            return ExifAttribute.createSLong(new int[]{n2}, byteOrder);
        }

        public static ExifAttribute createByte(String object) {
            if (((String)object).length() == 1 && ((String)object).charAt(0) >= '0' && ((String)object).charAt(0) <= '1') {
                byte[] byArray = new byte[1];
                byte[] byArray2 = byArray;
                byArray[0] = (byte)(((String)object).charAt(0) - 48);
                return new ExifAttribute(1, 1, byArray2);
            }
            object = ((String)object).getBytes(ASCII);
            return new ExifAttribute(1, ((Object)object).length, (byte[])object);
        }

        public static ExifAttribute createString(String object) {
            object = ((String)object + '\u0000').getBytes(ASCII);
            return new ExifAttribute(2, ((Object)object).length, (byte[])object);
        }

        public static ExifAttribute createURational(Rational[] rationalArray, ByteOrder byteOrder) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[5] * rationalArray.length]);
            byteBuffer.order(byteOrder);
            int n2 = rationalArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ByteBuffer byteBuffer2 = byteBuffer;
                Rational rational = rationalArray[i2];
                byteBuffer2.putInt((int)rational.numerator);
                byteBuffer2.putInt((int)rational.denominator);
            }
            int n3 = rationalArray.length;
            byte[] byArray = byteBuffer.array();
            return new ExifAttribute(5, n3, byArray);
        }

        public static ExifAttribute createURational(Rational rational, ByteOrder byteOrder) {
            return ExifAttribute.createURational(new Rational[]{rational}, byteOrder);
        }

        public static ExifAttribute createSRational(Rational[] rationalArray, ByteOrder byteOrder) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[10] * rationalArray.length]);
            byteBuffer.order(byteOrder);
            int n2 = rationalArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ByteBuffer byteBuffer2 = byteBuffer;
                Rational rational = rationalArray[i2];
                byteBuffer2.putInt((int)rational.numerator);
                byteBuffer2.putInt((int)rational.denominator);
            }
            int n3 = rationalArray.length;
            byte[] byArray = byteBuffer.array();
            return new ExifAttribute(10, n3, byArray);
        }

        public static ExifAttribute createSRational(Rational rational, ByteOrder byteOrder) {
            return ExifAttribute.createSRational(new Rational[]{rational}, byteOrder);
        }

        public static ExifAttribute createDouble(double[] dArray, ByteOrder byteOrder) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[12] * dArray.length]);
            byteBuffer.order(byteOrder);
            int n2 = dArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                byteBuffer.putDouble(dArray[i2]);
            }
            int n3 = dArray.length;
            byte[] byArray = byteBuffer.array();
            return new ExifAttribute(12, n3, byArray);
        }

        public static ExifAttribute createDouble(double d2, ByteOrder byteOrder) {
            return ExifAttribute.createDouble(new double[]{d2}, byteOrder);
        }

        public String toString() {
            return "(" + IFD_FORMAT_NAMES[this.format] + ", data length:" + this.bytes.length + ")";
        }

        /*
         * Exception decompiling
         */
        Object getValue(ByteOrder var1_16) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 68[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public double getDoubleValue(ByteOrder byteOrder) {
            if ((rationalArray = rationalArray.getValue(byteOrder)) != null) {
                Rational[] rationalArray;
                if (rationalArray instanceof String) {
                    return Double.parseDouble((String)rationalArray);
                }
                if (rationalArray instanceof long[]) {
                    long[] lArray = (long[])rationalArray;
                    rationalArray = (Rational[])lArray;
                    if (lArray.length == 1) {
                        return (double)rationalArray[0];
                    }
                    throw new NumberFormatException("There are more than one component");
                }
                if (rationalArray instanceof int[]) {
                    int[] nArray = (int[])rationalArray;
                    rationalArray = (Rational[])nArray;
                    if (nArray.length == 1) {
                        return (double)rationalArray[0];
                    }
                    throw new NumberFormatException("There are more than one component");
                }
                if (rationalArray instanceof double[]) {
                    double[] dArray = (double[])rationalArray;
                    rationalArray = (Rational[])dArray;
                    if (dArray.length == 1) {
                        return (double)rationalArray[0];
                    }
                    throw new NumberFormatException("There are more than one component");
                }
                if (rationalArray instanceof Rational[]) {
                    if ((rationalArray = (Rational[])rationalArray).length == 1) {
                        return rationalArray[0].calculate();
                    }
                    throw new NumberFormatException("There are more than one component");
                }
                throw new NumberFormatException("Couldn't find a double value");
            }
            throw new NumberFormatException("NULL can't be converted to a double value");
        }

        public int getIntValue(ByteOrder byteOrder) {
            if ((object = ((ExifAttribute)object).getValue(byteOrder)) != null) {
                Object object;
                if (object instanceof String) {
                    return Integer.parseInt((String)object);
                }
                if (object instanceof long[]) {
                    long[] lArray = (long[])object;
                    object = lArray;
                    if (lArray.length == 1) {
                        return (int)object[0];
                    }
                    throw new NumberFormatException("There are more than one component");
                }
                if (object instanceof int[]) {
                    int[] nArray = (int[])object;
                    object = nArray;
                    if (nArray.length == 1) {
                        return (int)object[0];
                    }
                    throw new NumberFormatException("There are more than one component");
                }
                throw new NumberFormatException("Couldn't find a integer value");
            }
            throw new NumberFormatException("NULL can't be converted to a integer value");
        }

        public String getStringValue(ByteOrder object) {
            Rational[] rationalArray;
            StringBuilder stringBuilder;
            if ((rationalArray = rationalArray.getValue((ByteOrder)object)) == null) {
                return null;
            }
            if (rationalArray instanceof String) {
                return (String)rationalArray;
            }
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            if (rationalArray instanceof long[]) {
                rationalArray = (Rational[])((long[])rationalArray);
                int n2 = 0;
                while (n2 < rationalArray.length) {
                    ((StringBuilder)object).append((long)rationalArray[n2]);
                    if (++n2 == rationalArray.length) continue;
                    ((StringBuilder)object).append(",");
                }
                return ((StringBuilder)object).toString();
            }
            if (rationalArray instanceof int[]) {
                rationalArray = (Rational[])((int[])rationalArray);
                int n3 = 0;
                while (n3 < rationalArray.length) {
                    ((StringBuilder)object).append((int)rationalArray[n3]);
                    if (++n3 == rationalArray.length) continue;
                    ((StringBuilder)object).append(",");
                }
                return ((StringBuilder)object).toString();
            }
            if (rationalArray instanceof double[]) {
                rationalArray = (Rational[])((double[])rationalArray);
                int n4 = 0;
                while (n4 < rationalArray.length) {
                    ((StringBuilder)object).append((double)rationalArray[n4]);
                    if (++n4 == rationalArray.length) continue;
                    ((StringBuilder)object).append(",");
                }
                return ((StringBuilder)object).toString();
            }
            if (rationalArray instanceof Rational[]) {
                rationalArray = rationalArray;
                int n5 = 0;
                while (n5 < rationalArray.length) {
                    Object object2 = object;
                    ((StringBuilder)object2).append(rationalArray[n5].numerator);
                    ((StringBuilder)object2).append('/');
                    ((StringBuilder)object).append(rationalArray[n5].denominator);
                    if (++n5 == rationalArray.length) continue;
                    ((StringBuilder)object).append(",");
                }
                return ((StringBuilder)object).toString();
            }
            return null;
        }

        public int size() {
            return IFD_FORMAT_BYTES_PER_FORMAT[this.format] * this.numberOfComponents;
        }
    }

    private static class Rational {
        public final long numerator;
        public final long denominator;

        Rational(double d2) {
            this((long)(d2 * 10000.0), 10000L);
        }

        Rational(long l2, long l3) {
            if (l3 == 0L) {
                Rational rational = this;
                rational.numerator = 0L;
                rational.denominator = 1L;
                return;
            }
            Rational rational = this;
            rational.numerator = l2;
            rational.denominator = l3;
        }

        public String toString() {
            return this.numerator + "/" + this.denominator;
        }

        public double calculate() {
            return (double)this.numerator / (double)this.denominator;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ExifStreamType {
    }
}

