/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.adapter.util;

import android.content.ContentUris;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;

public class ContentUriUtil {
    public static String getImageAbsolutePath(Context stringArray, Uri stringArray2) {
        if (stringArray != null && stringArray2 != null) {
            if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)stringArray, (Uri)stringArray2)) {
                if (ContentUriUtil.isMediaDocument((Uri)stringArray2)) {
                    stringArray2 = DocumentsContract.getDocumentId((Uri)stringArray2).split(":");
                    String string2 = stringArray2[0];
                    Uri uri = null;
                    if ("image".equals(string2)) {
                        uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(string2)) {
                        uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(string2)) {
                        uri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String[] stringArray3 = stringArray;
                    String[] stringArray4 = new String[1];
                    stringArray = stringArray4;
                    stringArray4[0] = stringArray2[1];
                    return ContentUriUtil.getDataColumn((Context)stringArray3, uri, "_id=?", stringArray);
                }
                if (ContentUriUtil.isExternalStorageDocument((Uri)stringArray2)) {
                    stringArray = DocumentsContract.getDocumentId((Uri)stringArray2).split(":");
                    if ("primary".equalsIgnoreCase(stringArray[0])) {
                        return Environment.getExternalStorageDirectory() + "/" + stringArray[1];
                    }
                } else if (ContentUriUtil.isDownloadsDocument((Uri)stringArray2)) {
                    return ContentUriUtil.getDataColumn((Context)stringArray, ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(DocumentsContract.getDocumentId((Uri)stringArray2))), null, null);
                }
            } else {
                if ("content".equalsIgnoreCase(stringArray2.getScheme())) {
                    if (ContentUriUtil.isGooglePhotosUri((Uri)stringArray2)) {
                        return stringArray2.getLastPathSegment();
                    }
                    return ContentUriUtil.getDataColumn((Context)stringArray, (Uri)stringArray2, null, null);
                }
                if ("file".equalsIgnoreCase(stringArray2.getScheme())) {
                    return stringArray2.getPath();
                }
            }
            return null;
        }
        return null;
    }

    public static String getDataColumn(Context context, Uri object, String string2, String[] stringArray) {
        block6: {
            block7: {
                Context context2 = context;
                context = null;
                String string3 = "_data";
                String[] stringArray2 = new String[1];
                String[] stringArray3 = stringArray2;
                stringArray2[0] = string3;
                try {
                    context = context2.getContentResolver().query(object, stringArray3, string2, stringArray, null);
                    if (context == null) break block6;
                }
                catch (Throwable throwable) {
                    if (context != null) {
                        context.close();
                    }
                    throw throwable;
                }
                if (!context.moveToFirst()) break block6;
                Context context3 = context;
                object = context3.getString(context3.getColumnIndexOrThrow(string3));
                if (context3 == null) break block7;
                context.close();
            }
            return object;
        }
        if (context != null) {
            context.close();
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }
}

