/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.DHInterface.message;

import io.dcloud.common.DHInterface.message.AbsActionObserver;
import io.dcloud.common.DHInterface.message.EnumUniqueID;
import io.dcloud.common.DHInterface.message.action.BadgeSyncAction;
import io.dcloud.common.DHInterface.message.action.IAction;
import java.util.HashMap;
import java.util.HashSet;

public class ActionBus {
    private static ActionBus instance = new ActionBus();
    HashSet<Class<? extends IAction>> supportMessageType;
    HashMap<EnumUniqueID, AbsActionObserver> observers;

    public static ActionBus getInstance() {
        return instance;
    }

    private ActionBus() {
        ActionBus actionBus = this;
        actionBus.supportMessageType = new HashSet();
        actionBus.observers = new HashMap();
        actionBus.supportMessageType.add(BadgeSyncAction.class);
    }

    public boolean sendToBus(IAction iAction) {
        if (iAction == null) {
            return false;
        }
        if (!((ActionBus)this).supportMessageType.contains(iAction.getClass())) {
            return false;
        }
        for (AbsActionObserver absActionObserver : ((ActionBus)this).observers.values()) {
            if (absActionObserver == null) continue;
            absActionObserver.handleMessage(iAction);
        }
        return true;
    }

    public boolean observeAction(AbsActionObserver absActionObserver) {
        if (absActionObserver == null) {
            return false;
        }
        if (this.observers.containsKey((Object)absActionObserver.getObserverUniqueID())) {
            return false;
        }
        this.observers.put(absActionObserver.getObserverUniqueID(), absActionObserver);
        return true;
    }

    public void stopObserve(EnumUniqueID enumUniqueID) {
        this.observers.remove((Object)enumUniqueID);
    }
}

