/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Segment;
import dc.squareup.okio.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

final class SegmentedByteString
extends ByteString {
    final transient byte[][] segments;
    final transient int[] directory;

    SegmentedByteString(Buffer buffer, int n2) {
        int n3;
        Buffer buffer2 = buffer;
        super(null);
        long l2 = n2;
        Util.checkOffsetAndCount(buffer2.size, 0L, l2);
        int n4 = 0;
        int n5 = 0;
        Segment segment = buffer2.head;
        while (n4 < n2) {
            n3 = segment.limit;
            int n6 = segment.pos;
            if (n3 != n6) {
                n4 += n3 - n6;
                ++n5;
                segment = segment.next;
                continue;
            }
            throw new AssertionError((Object)"s.limit == s.pos");
        }
        this.segments = new byte[n5][];
        this.directory = new int[n5 * 2];
        int n7 = 0;
        n4 = 0;
        Object object = buffer.head;
        while (n7 < n2) {
            byte[][] byArray = this.segments;
            this.segments[n4] = ((Segment)object).data;
            int n8 = ((Segment)object).pos;
            n3 = n7 + (((Segment)object).limit - n8);
            if (n3 > n2) {
                n3 = n2;
            }
            Segment segment2 = object;
            object = this.directory;
            object[n4] = n3;
            this.directory[n4 + byArray.length] = n8;
            segment2.shared = true;
            ++n4;
            object = segment2.next;
            n7 = n3;
        }
    }

    private int segment(int n2) {
        int n3 = n2 + 1;
        if ((n3 = Arrays.binarySearch(this.directory, 0, this.segments.length, n3)) < 0) {
            n3 ^= 0xFFFFFFFF;
        }
        return n3;
    }

    private ByteString toByteString() {
        return new ByteString(this.toByteArray());
    }

    private Object writeReplace() {
        return this.toByteString();
    }

    @Override
    public String utf8() {
        return this.toByteString().utf8();
    }

    @Override
    public String string(Charset charset) {
        return this.toByteString().string(charset);
    }

    @Override
    public String base64() {
        return this.toByteString().base64();
    }

    @Override
    public String hex() {
        return this.toByteString().hex();
    }

    @Override
    public ByteString toAsciiLowercase() {
        return this.toByteString().toAsciiLowercase();
    }

    @Override
    public ByteString toAsciiUppercase() {
        return this.toByteString().toAsciiUppercase();
    }

    @Override
    public ByteString md5() {
        return this.toByteString().md5();
    }

    @Override
    public ByteString sha1() {
        return this.toByteString().sha1();
    }

    @Override
    public ByteString sha256() {
        return this.toByteString().sha256();
    }

    @Override
    public ByteString hmacSha1(ByteString byteString) {
        return this.toByteString().hmacSha1(byteString);
    }

    @Override
    public ByteString hmacSha256(ByteString byteString) {
        return this.toByteString().hmacSha256(byteString);
    }

    @Override
    public String base64Url() {
        return this.toByteString().base64Url();
    }

    @Override
    public ByteString substring(int n2) {
        return this.toByteString().substring(n2);
    }

    @Override
    public ByteString substring(int n2, int n3) {
        return this.toByteString().substring(n2, n3);
    }

    @Override
    public byte getByte(int n2) {
        Util.checkOffsetAndCount(((SegmentedByteString)object).directory[((SegmentedByteString)object).segments.length - 1], n2, 1L);
        int n3 = ((SegmentedByteString)object).segment(n2);
        int n4 = n3 == 0 ? 0 : ((SegmentedByteString)object).directory[n3 - 1];
        SegmentedByteString segmentedByteString = object;
        Object object = segmentedByteString.directory;
        byte[][] byArray = segmentedByteString.segments;
        Object object2 = object[n3 + byArray.length];
        return segmentedByteString.segments[n3][n2 - n4 + object2];
    }

    @Override
    public int size() {
        return this.directory[this.segments.length - 1];
    }

    @Override
    public byte[] toByteArray() {
        SegmentedByteString segmentedByteString = this;
        Object[] objectArray = segmentedByteString.directory;
        objectArray = new byte[objectArray[segmentedByteString.segments.length - 1]];
        int n2 = 0;
        int n3 = segmentedByteString.segments.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            SegmentedByteString segmentedByteString2 = this;
            int n4 = segmentedByteString2.directory[n3 + i2];
            int n5 = segmentedByteString2.directory[i2];
            int n6 = n4;
            n4 = n5 - n2;
            System.arraycopy(segmentedByteString2.segments[i2], n6, objectArray, n2, n4);
            n2 = n5;
        }
        return objectArray;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.toByteArray()).asReadOnlyBuffer();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            int n2 = 0;
            int n3 = this.segments.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = this.directory[n3 + i2];
                int n5 = this.directory[i2];
                byte[] byArray = this.segments[i2];
                int n6 = n5 - n2;
                outputStream.write(byArray, n4, n6);
                n2 = n5;
            }
            return;
        }
        throw new IllegalArgumentException("out == null");
    }

    @Override
    void write(Buffer buffer) {
        int n2 = 0;
        int n3 = this.segments.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Segment segment;
            int n4 = this.directory[n3 + i2];
            int n5 = this.directory[i2];
            Segment segment2 = segment;
            byte[] byArray = this.segments[i2];
            n2 = n4 + n5 - n2;
            segment = new Segment(byArray, n4, n2, true, false);
            Segment segment3 = buffer.head;
            if (segment3 == null) {
                segment2.prev = segment2;
                segment2.next = segment2;
                buffer.head = segment2;
            } else {
                segment3.prev.push(segment2);
            }
            n2 = n5;
        }
        buffer.size += (long)n2;
    }

    @Override
    public boolean rangeEquals(int n2, ByteString byteString, int n3, int n4) {
        if (n2 >= 0 && n2 <= this.size() - n4) {
            int n5 = this.segment(n2);
            while (n4 > 0) {
                int n6 = n5 == 0 ? 0 : this.directory[n5 - 1];
                SegmentedByteString segmentedByteString = this;
                int n7 = Math.min(n4, n6 + (this.directory[n5] - n6) - n2);
                int[] nArray = segmentedByteString.directory;
                byte[][] byArray = segmentedByteString.segments;
                int n8 = n6;
                n6 = nArray[byArray.length + n5];
                if (!byteString.rangeEquals(n3, segmentedByteString.segments[n5], n6 = n2 - n8 + n6, n7)) {
                    return false;
                }
                n2 += n7;
                n3 += n7;
                n4 -= n7;
                ++n5;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean rangeEquals(int n2, byte[] byArray, int n3, int n4) {
        if (n2 >= 0 && n2 <= this.size() - n4 && n3 >= 0 && n3 <= byArray.length - n4) {
            int n5 = this.segment(n2);
            while (n4 > 0) {
                int n6 = n5 == 0 ? 0 : this.directory[n5 - 1];
                SegmentedByteString segmentedByteString = this;
                int n7 = Math.min(n4, n6 + (this.directory[n5] - n6) - n2);
                int[] nArray = segmentedByteString.directory;
                byte[][] byArray2 = segmentedByteString.segments;
                int n8 = n6;
                n6 = nArray[byArray2.length + n5];
                if (!Util.arrayRangeEquals(segmentedByteString.segments[n5], n6 = n2 - n8 + n6, byArray, n3, n7)) {
                    return false;
                }
                n2 += n7;
                n3 += n7;
                n4 -= n7;
                ++n5;
            }
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(byte[] byArray, int n2) {
        return this.toByteString().indexOf(byArray, n2);
    }

    @Override
    public int lastIndexOf(byte[] byArray, int n2) {
        return this.toByteString().lastIndexOf(byArray, n2);
    }

    @Override
    byte[] internalArray() {
        return this.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) return false;
        if (((ByteString)(object = (ByteString)object)).size() != this.size()) return false;
        SegmentedByteString segmentedByteString = this;
        int n2 = segmentedByteString.size();
        if (!segmentedByteString.rangeEquals(0, (ByteString)object, 0, n2)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = this.hashCode;
        if (n2 != 0) {
            return n2;
        }
        n2 = 1;
        int n3 = 0;
        int n4 = this.segments.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            SegmentedByteString segmentedByteString = this;
            byte[] byArray = segmentedByteString.segments[i2];
            int[] nArray = segmentedByteString.directory;
            int n6 = nArray[i2];
            n3 = n5 + (n6 - n3);
            for (n5 = segmentedByteString.directory[n4 + i2]; n5 < n3; ++n5) {
                n2 = n2 * 31 + byArray[n5];
            }
            n3 = n6;
        }
        this.hashCode = n2;
        return n2;
    }

    @Override
    public String toString() {
        return this.toByteString().toString();
    }
}

