/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import androidx.annotation.Nullable;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Options;
import dc.squareup.okio.PeekSource;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import dc.squareup.okio.Util;
import io.dcloud.common.util.StringUtil;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

final class RealBufferedSource
implements BufferedSource {
    public final Buffer buffer;
    public final Source source;
    boolean closed;

    RealBufferedSource(Source source) {
        Buffer buffer;
        Buffer buffer2 = buffer;
        buffer = new Buffer();
        this.buffer = buffer2;
        if (source != null) {
            this.source = source;
            return;
        }
        throw new NullPointerException("source == null");
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public long read(Buffer buffer, long l2) throws IOException {
        if (buffer != null) {
            if (l2 >= 0L) {
                if (!this.closed) {
                    Buffer buffer2 = this.buffer;
                    if (buffer2.size == 0L && this.source.read(buffer2, 8192L) == -1L) {
                        return -1L;
                    }
                    l2 = Math.min(l2, this.buffer.size);
                    return this.buffer.read(buffer, l2);
                }
                throw new IllegalStateException("closed");
            }
            throw new IllegalArgumentException("byteCount < 0: " + l2);
        }
        throw new IllegalArgumentException("sink == null");
    }

    @Override
    public boolean exhausted() throws IOException {
        if (!this.closed) {
            return this.buffer.exhausted() && this.source.read(this.buffer, 8192L) == -1L;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public void require(long l2) throws IOException {
        if (this.request(l2)) {
            return;
        }
        throw new EOFException();
    }

    @Override
    public boolean request(long l2) throws IOException {
        if (l2 >= 0L) {
            if (!this.closed) {
                block3: {
                    Buffer buffer;
                    do {
                        buffer = this.buffer;
                        if (buffer.size >= l2) break block3;
                    } while (this.source.read(buffer, 8192L) != -1L);
                    return false;
                }
                return true;
            }
            throw new IllegalStateException("closed");
        }
        throw new IllegalArgumentException("byteCount < 0: " + l2);
    }

    @Override
    public byte readByte() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(1L);
        return realBufferedSource.buffer.readByte();
    }

    @Override
    public ByteString readByteString() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.buffer.writeAll(this.source);
        return realBufferedSource.buffer.readByteString();
    }

    @Override
    public ByteString readByteString(long l2) throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(l2);
        return realBufferedSource.buffer.readByteString(l2);
    }

    @Override
    public int select(Options options) throws IOException {
        if (!this.closed) {
            int n2;
            block3: {
                do {
                    if ((n2 = this.buffer.selectPrefix(options, true)) == -1) {
                        return -1;
                    }
                    if (n2 != -2) break block3;
                } while (this.source.read(this.buffer, 8192L) != -1L);
                return -1;
            }
            int n3 = options.byteStrings[n2].size();
            this.buffer.skip(n3);
            return n2;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public byte[] readByteArray() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.buffer.writeAll(this.source);
        return realBufferedSource.buffer.readByteArray();
    }

    @Override
    public byte[] readByteArray(long l2) throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(l2);
        return realBufferedSource.buffer.readByteArray(l2);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        long l2;
        RealBufferedSource realBufferedSource;
        RealBufferedSource realBufferedSource2;
        try {
            RealBufferedSource realBufferedSource3 = this;
            realBufferedSource2 = realBufferedSource3;
            realBufferedSource = realBufferedSource3;
            l2 = byArray.length;
        }
        catch (EOFException eOFException) {
            block4: {
                int n2 = 0;
                while (true) {
                    Buffer buffer = this.buffer;
                    long l3 = buffer.size;
                    if (l3 <= 0L) break block4;
                    int n3 = (int)l3;
                    if ((n3 = buffer.read(byArray, n2, n3)) == -1) break;
                    n2 += n3;
                }
                throw new AssertionError();
            }
            throw eOFException;
        }
        realBufferedSource2.require(l2);
        realBufferedSource.buffer.readFully(byArray);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        long l2 = n2;
        long l3 = n3;
        Util.checkOffsetAndCount(byArray.length, l2, l3);
        Buffer buffer = this.buffer;
        if (buffer.size == 0L && this.source.read(buffer, 8192L) == -1L) {
            return -1;
        }
        int n4 = (int)Math.min(l3, this.buffer.size);
        return this.buffer.read(byArray, n2, n4);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        Buffer buffer = this.buffer;
        if (buffer.size == 0L && this.source.read(buffer, 8192L) == -1L) {
            return -1;
        }
        return this.buffer.read(byteBuffer);
    }

    @Override
    public void readFully(Buffer buffer, long l2) throws IOException {
        try {
            RealBufferedSource realBufferedSource = this;
            realBufferedSource.require(l2);
            realBufferedSource.buffer.readFully(buffer, l2);
            return;
        }
        catch (EOFException eOFException) {
            buffer.writeAll(this.buffer);
            throw eOFException;
        }
    }

    @Override
    public long readAll(Sink sink) throws IOException {
        if (sink != null) {
            long l2 = 0L;
            while (this.source.read(this.buffer, 8192L) != -1L) {
                long l3 = this.buffer.completeSegmentByteCount();
                if (l3 <= 0L) continue;
                l2 += l3;
                sink.write(this.buffer, l3);
            }
            if (this.buffer.size() > 0L) {
                l2 += this.buffer.size();
                Buffer buffer = this.buffer;
                sink.write(buffer, buffer.size());
            }
            return l2;
        }
        throw new IllegalArgumentException("sink == null");
    }

    @Override
    public String readUtf8() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.buffer.writeAll(this.source);
        return realBufferedSource.buffer.readUtf8();
    }

    @Override
    public String readUtf8(long l2) throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(l2);
        return realBufferedSource.buffer.readUtf8(l2);
    }

    @Override
    public String readString(Charset charset) throws IOException {
        if (charset != null) {
            RealBufferedSource realBufferedSource = this;
            realBufferedSource.buffer.writeAll(this.source);
            return realBufferedSource.buffer.readString(charset);
        }
        throw new IllegalArgumentException("charset == null");
    }

    @Override
    public String readString(long l2, Charset charset) throws IOException {
        this.require(l2);
        if (charset != null) {
            return this.buffer.readString(l2, charset);
        }
        throw new IllegalArgumentException("charset == null");
    }

    @Override
    @Nullable
    public String readUtf8Line() throws IOException {
        long l2 = this.indexOf((byte)10);
        if (l2 == -1L) {
            l2 = this.buffer.size;
            return l2 != 0L ? this.readUtf8(l2) : null;
        }
        return this.buffer.readUtf8Line(l2);
    }

    @Override
    public String readUtf8LineStrict() throws IOException {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    @Override
    public String readUtf8LineStrict(long l2) throws IOException {
        if (l2 >= 0L) {
            Buffer buffer;
            long l3 = l2 == Long.MAX_VALUE ? Long.MAX_VALUE : l2 + 1L;
            long l4 = this.indexOf((byte)10, 0L, l3);
            if (l4 != -1L) {
                return this.buffer.readUtf8Line(l4);
            }
            if (l3 < Long.MAX_VALUE && this.request(l3) && this.buffer.getByte(l3 - 1L) == 13 && this.request(l3 + 1L) && this.buffer.getByte(l3) == 10) {
                return this.buffer.readUtf8Line(l3);
            }
            Buffer buffer2 = buffer;
            buffer = new Buffer();
            Buffer buffer3 = this.buffer;
            long l5 = buffer3.size();
            l5 = Math.min(32L, l5);
            buffer3.copyTo(buffer2, 0L, l5);
            throw new EOFException("\\n not found: limit=" + Math.min(this.buffer.size(), l2) + " content=" + buffer2.readByteString().hex() + '\u2026');
        }
        throw new IllegalArgumentException("limit < 0: " + l2);
    }

    @Override
    public int readUtf8CodePoint() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(1L);
        byte by = realBufferedSource.buffer.getByte(0L);
        if ((by & 0xE0) == 192) {
            this.require(2L);
        } else if ((by & 0xF0) == 224) {
            this.require(3L);
        } else if ((by & 0xF8) == 240) {
            this.require(4L);
        }
        return this.buffer.readUtf8CodePoint();
    }

    @Override
    public short readShort() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(2L);
        return realBufferedSource.buffer.readShort();
    }

    @Override
    public short readShortLe() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(2L);
        return realBufferedSource.buffer.readShortLe();
    }

    @Override
    public int readInt() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(4L);
        return realBufferedSource.buffer.readInt();
    }

    @Override
    public int readIntLe() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(4L);
        return realBufferedSource.buffer.readIntLe();
    }

    @Override
    public long readLong() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(8L);
        return realBufferedSource.buffer.readLong();
    }

    @Override
    public long readLongLe() throws IOException {
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.require(8L);
        return realBufferedSource.buffer.readLongLe();
    }

    @Override
    public long readDecimalLong() throws IOException {
        int n2;
        objectArray2.require(1L);
        int n3 = 0;
        while (objectArray2.request(n2 = n3 + 1)) {
            byte by = objectArray2.buffer.getByte(n3);
            if (by >= 48 && by <= 57 || n3 == 0 && by == 45) {
                n3 = n2;
                continue;
            }
            if (n3 != 0) break;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = by;
            throw new NumberFormatException(StringUtil.format("Expected leading [0-9] or '-' character but was %#x", objectArray2));
        }
        return objectArray2.buffer.readDecimalLong();
    }

    @Override
    public long readHexadecimalUnsignedLong() throws IOException {
        int n2;
        objectArray2.require(1L);
        int n3 = 0;
        while (objectArray2.request(n2 = n3 + 1)) {
            byte by = objectArray2.buffer.getByte(n3);
            if (by >= 48 && by <= 57 || by >= 97 && by <= 102 || by >= 65 && by <= 70) {
                n3 = n2;
                continue;
            }
            if (n3 != 0) break;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = by;
            throw new NumberFormatException(StringUtil.format("Expected leading [0-9a-fA-F] character but was %#x", objectArray2));
        }
        return objectArray2.buffer.readHexadecimalUnsignedLong();
    }

    @Override
    public void skip(long l2) throws IOException {
        if (!this.closed) {
            while (l2 > 0L) {
                Buffer buffer = this.buffer;
                if (buffer.size == 0L && this.source.read(buffer, 8192L) == -1L) {
                    throw new EOFException();
                }
                long l3 = l2;
                l2 = Math.min(l3, this.buffer.size());
                this.buffer.skip(l2);
                l2 = l3 - l2;
            }
            return;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public long indexOf(byte by) throws IOException {
        return this.indexOf(by, 0L, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l2) throws IOException {
        return this.indexOf(by, l2, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l2, long l3) throws IOException {
        if (!objectArray2.closed) {
            if (l2 >= 0L && l3 >= l2) {
                while (l2 < l3) {
                    long l4 = objectArray2.buffer.indexOf(by, l2, l3);
                    if (l4 != -1L) {
                        return l4;
                    }
                    Buffer buffer = objectArray2.buffer;
                    long l5 = buffer.size;
                    if (l5 < l3 && objectArray2.source.read(buffer, 8192L) != -1L) {
                        l2 = Math.max(l2, l5);
                        continue;
                    }
                    return -1L;
                }
                return -1L;
            }
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = l2;
            objectArray[1] = l3;
            throw new IllegalArgumentException(StringUtil.format("fromIndex=%s toIndex=%s", objectArray2));
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public long indexOf(ByteString byteString) throws IOException {
        return this.indexOf(byteString, 0L);
    }

    @Override
    public long indexOf(ByteString byteString, long l2) throws IOException {
        if (!this.closed) {
            while (true) {
                long l3;
                if ((l3 = this.buffer.indexOf(byteString, l2)) != -1L) {
                    return l3;
                }
                RealBufferedSource realBufferedSource = this;
                Buffer buffer = realBufferedSource.buffer;
                long l4 = buffer.size;
                if (realBufferedSource.source.read(buffer, 8192L) == -1L) {
                    return -1L;
                }
                l2 = Math.max(l2, l4 - (long)byteString.size() + 1L);
            }
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public long indexOfElement(ByteString byteString) throws IOException {
        return this.indexOfElement(byteString, 0L);
    }

    @Override
    public long indexOfElement(ByteString byteString, long l2) throws IOException {
        if (!this.closed) {
            while (true) {
                long l3;
                if ((l3 = this.buffer.indexOfElement(byteString, l2)) != -1L) {
                    return l3;
                }
                RealBufferedSource realBufferedSource = this;
                Buffer buffer = realBufferedSource.buffer;
                long l4 = buffer.size;
                if (realBufferedSource.source.read(buffer, 8192L) == -1L) {
                    return -1L;
                }
                l2 = Math.max(l2, l4);
            }
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public boolean rangeEquals(long l2, ByteString byteString) throws IOException {
        int n2 = byteString.size();
        return this.rangeEquals(l2, byteString, 0, n2);
    }

    @Override
    public boolean rangeEquals(long l2, ByteString byteString, int n2, int n3) throws IOException {
        if (!this.closed) {
            if (l2 >= 0L && n2 >= 0 && n3 >= 0 && byteString.size() - n2 >= n3) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    long l3 = l2 + (long)i2;
                    if (!this.request(l3 + 1L)) {
                        return false;
                    }
                    if (this.buffer.getByte(l3) == byteString.getByte(n2 + i2)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSource peek() {
        return Okio.buffer(new PeekSource(this));
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                RealBufferedSource realBufferedSource = RealBufferedSource.this;
                if (!realBufferedSource.closed) {
                    Buffer buffer = realBufferedSource.buffer;
                    if (buffer.size == 0L && realBufferedSource.source.read(buffer, 8192L) == -1L) {
                        return -1;
                    }
                    return RealBufferedSource.this.buffer.readByte() & 0xFF;
                }
                throw new IOException("closed");
            }

            @Override
            public int read(byte[] byArray, int n2, int n3) throws IOException {
                if (!RealBufferedSource.this.closed) {
                    long l2 = n2;
                    long l3 = n3;
                    Util.checkOffsetAndCount(byArray.length, l2, l3);
                    RealBufferedSource realBufferedSource = RealBufferedSource.this;
                    Buffer buffer = realBufferedSource.buffer;
                    if (buffer.size == 0L && realBufferedSource.source.read(buffer, 8192L) == -1L) {
                        return -1;
                    }
                    return RealBufferedSource.this.buffer.read(byArray, n2, n3);
                }
                throw new IOException("closed");
            }

            @Override
            public int available() throws IOException {
                Closeable closeable = closeable.RealBufferedSource.this;
                if (!((RealBufferedSource)closeable).closed) {
                    return (int)Math.min(((RealBufferedSource)closeable).buffer.size, Integer.MAX_VALUE);
                }
                throw new IOException("closed");
            }

            @Override
            public void close() throws IOException {
                RealBufferedSource.this.close();
            }

            public String toString() {
                return RealBufferedSource.this + ".inputStream()";
            }
        };
    }

    @Override
    public boolean isOpen() {
        return this.closed ^ true;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        RealBufferedSource realBufferedSource = this;
        realBufferedSource.closed = true;
        realBufferedSource.source.close();
        realBufferedSource.buffer.clear();
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    public String toString() {
        return "buffer(" + this.source + ")";
    }
}

