/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import dc.squareup.okio.Util;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

final class RealBufferedSink
implements BufferedSink {
    public final Buffer buffer;
    public final Sink sink;
    boolean closed;

    RealBufferedSink(Sink sink) {
        Buffer buffer;
        Buffer buffer2 = buffer;
        buffer = new Buffer();
        this.buffer = buffer2;
        if (sink != null) {
            this.sink = sink;
            return;
        }
        throw new NullPointerException("sink == null");
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public void write(Buffer buffer, long l2) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.write(buffer, l2);
            realBufferedSink.emitCompleteSegments();
            return;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink write(ByteString byteString) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.write(byteString);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeUtf8(String string2) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeUtf8(string2);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeUtf8(String string2, int n2, int n3) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeUtf8(string2, n2, n3);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeUtf8CodePoint(int n2) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeUtf8CodePoint(n2);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeString(String string2, Charset charset) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeString(string2, charset);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeString(String string2, int n2, int n3, Charset charset) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeString(string2, n2, n3, charset);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink write(byte[] byArray) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.write(byArray);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink write(byte[] byArray, int n2, int n3) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.write(byArray, n2, n3);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (!this.closed) {
            int n2 = this.buffer.write(byteBuffer);
            this.emitCompleteSegments();
            return n2;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public long writeAll(Source source) throws IOException {
        if (source != null) {
            long l2;
            long l3 = 0L;
            while ((l2 = source.read(this.buffer, 8192L)) != -1L) {
                l3 += l2;
                this.emitCompleteSegments();
            }
            return l3;
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public BufferedSink write(Source source, long l2) throws IOException {
        while (l2 > 0L) {
            long l3 = source.read(this.buffer, l2);
            if (l3 != -1L) {
                l2 -= l3;
                this.emitCompleteSegments();
                continue;
            }
            throw new EOFException();
        }
        return this;
    }

    @Override
    public BufferedSink writeByte(int n2) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeByte(n2);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeShort(int n2) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeShort(n2);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeShortLe(int n2) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeShortLe(n2);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeInt(int n2) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeInt(n2);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeIntLe(int n2) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeIntLe(n2);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeLong(long l2) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeLong(l2);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeLongLe(long l2) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeLongLe(l2);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeDecimalLong(long l2) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeDecimalLong(l2);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeHexadecimalUnsignedLong(long l2) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeHexadecimalUnsignedLong(l2);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink emitCompleteSegments() throws IOException {
        if (!this.closed) {
            long l2 = this.buffer.completeSegmentByteCount();
            if (l2 > 0L) {
                this.sink.write(this.buffer, l2);
            }
            return this;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink emit() throws IOException {
        if (!this.closed) {
            long l2 = this.buffer.size();
            if (l2 > 0L) {
                this.sink.write(this.buffer, l2);
            }
            return this;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public OutputStream outputStream() {
        return new OutputStream(){

            @Override
            public void write(int n2) throws IOException {
                RealBufferedSink realBufferedSink = RealBufferedSink.this;
                if (!realBufferedSink.closed) {
                    realBufferedSink.buffer.writeByte((byte)n2);
                    RealBufferedSink.this.emitCompleteSegments();
                    return;
                }
                throw new IOException("closed");
            }

            @Override
            public void write(byte[] byArray, int n2, int n3) throws IOException {
                RealBufferedSink realBufferedSink = RealBufferedSink.this;
                if (!realBufferedSink.closed) {
                    realBufferedSink.buffer.write(byArray, n2, n3);
                    RealBufferedSink.this.emitCompleteSegments();
                    return;
                }
                throw new IOException("closed");
            }

            @Override
            public void flush() throws IOException {
                Closeable closeable = closeable.RealBufferedSink.this;
                if (!((RealBufferedSink)closeable).closed) {
                    ((RealBufferedSink)closeable).flush();
                }
            }

            @Override
            public void close() throws IOException {
                RealBufferedSink.this.close();
            }

            public String toString() {
                return RealBufferedSink.this + ".outputStream()";
            }
        };
    }

    @Override
    public void flush() throws IOException {
        if (!this.closed) {
            Buffer buffer = this.buffer;
            long l2 = buffer.size;
            if (l2 > 0L) {
                this.sink.write(buffer, l2);
            }
            this.sink.flush();
            return;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public boolean isOpen() {
        return this.closed ^ true;
    }

    @Override
    public void close() throws IOException {
        Buffer buffer;
        block9: {
            Object var1_1;
            block8: {
                if (this.closed) {
                    return;
                }
                var1_1 = null;
                buffer = this.buffer;
                long l2 = buffer.size;
                if (l2 <= 0L) break block8;
                try {
                    this.sink.write(buffer, l2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                this.sink.close();
            }
            catch (Throwable throwable) {
                if (var1_1 == null) break block9;
            }
            buffer = var1_1;
        }
        this.closed = true;
        if (buffer != null) {
            Util.sneakyRethrow((Throwable)((Object)buffer));
        }
    }

    @Override
    public Timeout timeout() {
        return this.sink.timeout();
    }

    public String toString() {
        return "buffer(" + this.sink + ")";
    }
}

