/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.Segment;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import java.io.IOException;

final class PeekSource
implements Source {
    private final BufferedSource upstream;
    private final Buffer buffer;
    private Segment expectedSegment;
    private int expectedPos;
    private boolean closed;
    private long pos;

    PeekSource(BufferedSource object) {
        this.upstream = object;
        this.buffer = object.buffer();
        this.expectedSegment = object = this.buffer.head;
        int n2 = object != null ? ((Segment)object).pos : -1;
        this.expectedPos = n2;
    }

    @Override
    public long read(Buffer buffer, long l2) throws IOException {
        long l3 = l2 - 0L;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        if (l4 >= 0) {
            if (!this.closed) {
                Segment segment;
                Segment segment2 = this.expectedSegment;
                if (segment2 != null && (segment2 != (segment2 = this.buffer.head) || this.expectedPos != segment2.pos)) {
                    throw new IllegalStateException("Peek source is invalid because upstream source was used");
                }
                if (l4 == false) {
                    return 0L;
                }
                if (!this.upstream.request(this.pos + 1L)) {
                    return -1L;
                }
                if (this.expectedSegment == null && (segment = this.buffer.head) != null) {
                    this.expectedSegment = segment;
                    this.expectedPos = segment.pos;
                }
                l2 = Math.min(l2, this.buffer.size - this.pos);
                PeekSource peekSource = this;
                peekSource.buffer.copyTo(buffer, this.pos, l2);
                peekSource.pos += l2;
                return l2;
            }
            throw new IllegalStateException("closed");
        }
        throw new IllegalArgumentException("byteCount < 0: " + l2);
    }

    @Override
    public Timeout timeout() {
        return this.upstream.timeout();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

