/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import androidx.annotation.Nullable;
import dc.squareup.okio.AsyncTimeout;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.RealBufferedSink;
import dc.squareup.okio.RealBufferedSource;
import dc.squareup.okio.Segment;
import dc.squareup.okio.SegmentPool;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import dc.squareup.okio.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Okio {
    static final Logger logger = Logger.getLogger(Okio.class.getName());

    private Okio() {
    }

    public static BufferedSource buffer(Source source) {
        return new RealBufferedSource(source);
    }

    public static BufferedSink buffer(Sink sink) {
        return new RealBufferedSink(sink);
    }

    public static Sink sink(OutputStream outputStream) {
        return Okio.sink(outputStream, new Timeout());
    }

    private static Sink sink(final OutputStream outputStream, final Timeout timeout) {
        if (outputStream != null) {
            if (timeout != null) {
                return new Sink(){

                    @Override
                    public void write(Buffer buffer, long l2) throws IOException {
                        Util.checkOffsetAndCount(buffer.size, 0L, l2);
                        while (l2 > 0L) {
                            timeout.throwIfReached();
                            Segment segment = buffer.head;
                            int n2 = (int)Math.min(l2, (long)(segment.limit - segment.pos));
                            Segment segment2 = segment;
                            byte[] byArray = segment2.data;
                            outputStream.write(byArray, segment2.pos, n2);
                            int n3 = segment.pos + n2;
                            long l3 = l2;
                            segment.pos = n3;
                            l2 = n2;
                            long l4 = l3 - l2;
                            buffer.size -= l2;
                            if (n3 == segment.limit) {
                                buffer.head = segment.pop();
                                SegmentPool.recycle(segment);
                            }
                            l2 = l4;
                        }
                    }

                    @Override
                    public void flush() throws IOException {
                        outputStream.flush();
                    }

                    @Override
                    public void close() throws IOException {
                        outputStream.close();
                    }

                    @Override
                    public Timeout timeout() {
                        return timeout;
                    }

                    public String toString() {
                        return "sink(" + outputStream + ")";
                    }
                };
            }
            throw new IllegalArgumentException("timeout == null");
        }
        throw new IllegalArgumentException("out == null");
    }

    public static Sink sink(Socket socket) throws IOException {
        if (socket != null) {
            if (socket.getOutputStream() != null) {
                AsyncTimeout asyncTimeout = Okio.timeout(socket);
                return asyncTimeout.sink(Okio.sink(socket.getOutputStream(), asyncTimeout));
            }
            throw new IOException("socket's output stream == null");
        }
        throw new IllegalArgumentException("socket == null");
    }

    public static Source source(InputStream inputStream) {
        return Okio.source(inputStream, new Timeout());
    }

    private static Source source(final InputStream inputStream, final Timeout timeout) {
        if (inputStream != null) {
            if (timeout != null) {
                return new Source(){

                    @Override
                    public long read(Buffer buffer, long l2) throws IOException {
                        long l3 = l2 - 0L;
                        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                        if (l4 >= 0) {
                            int n2;
                            block14: {
                                block15: {
                                    long l5;
                                    2 v0;
                                    if (l4 == false) {
                                        return 0L;
                                    }
                                    try {
                                        v0 = segment;
                                        l5 = l2;
                                        segment.timeout.throwIfReached();
                                        Segment segment = buffer.writableSegment(1);
                                    }
                                    catch (AssertionError assertionError) {
                                        if (Okio.isAndroidGetsocknameError(assertionError)) {
                                            throw new IOException((Throwable)((Object)assertionError));
                                        }
                                        throw assertionError;
                                    }
                                    long l6 = 8192 - segment.limit;
                                    n2 = (int)Math.min(l5, l6);
                                    InputStream inputStream2 = v0.inputStream;
                                    Object object = segment;
                                    Object object2 = object;
                                    byte[] byArray = ((Segment)object).data;
                                    n2 = inputStream2.read(byArray, ((Segment)object2).limit, n2);
                                    if (n2 != -1) break block14;
                                    if (segment.pos != segment.limit) break block15;
                                    buffer.head = segment.pop();
                                    SegmentPool.recycle(segment);
                                }
                                return -1L;
                            }
                            int n3 = n2;
                            Buffer buffer2 = buffer;
                            Segment segment = segment;
                            Segment segment2 = segment;
                            int n4 = segment.limit;
                            segment2.limit = n4 + n2;
                            long l7 = buffer2.size;
                            long l8 = n3;
                            buffer.size = l7 + l8;
                            return l8;
                        }
                        throw new IllegalArgumentException("byteCount < 0: " + l2);
                    }

                    @Override
                    public void close() throws IOException {
                        inputStream.close();
                    }

                    @Override
                    public Timeout timeout() {
                        return timeout;
                    }

                    public String toString() {
                        return "source(" + inputStream + ")";
                    }
                };
            }
            throw new IllegalArgumentException("timeout == null");
        }
        throw new IllegalArgumentException("in == null");
    }

    public static Source source(File file) throws FileNotFoundException {
        if (file != null) {
            return Okio.source(new FileInputStream(file));
        }
        throw new IllegalArgumentException("file == null");
    }

    public static Source source(Path path, OpenOption ... openOptionArray) throws IOException {
        if (path != null) {
            return Okio.source(Files.newInputStream(path, openOptionArray));
        }
        throw new IllegalArgumentException("path == null");
    }

    public static Sink sink(File file) throws FileNotFoundException {
        if (file != null) {
            return Okio.sink(new FileOutputStream(file));
        }
        throw new IllegalArgumentException("file == null");
    }

    public static Sink appendingSink(File file) throws FileNotFoundException {
        if (file != null) {
            return Okio.sink(new FileOutputStream(file, true));
        }
        throw new IllegalArgumentException("file == null");
    }

    public static Sink sink(Path path, OpenOption ... openOptionArray) throws IOException {
        if (path != null) {
            return Okio.sink(Files.newOutputStream(path, openOptionArray));
        }
        throw new IllegalArgumentException("path == null");
    }

    public static Sink blackhole() {
        return new Sink(){

            @Override
            public void write(Buffer buffer, long l2) throws IOException {
                buffer.skip(l2);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public Timeout timeout() {
                return Timeout.NONE;
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    public static Source source(Socket socket) throws IOException {
        if (socket != null) {
            if (socket.getInputStream() != null) {
                AsyncTimeout asyncTimeout = Okio.timeout(socket);
                return asyncTimeout.source(Okio.source(socket.getInputStream(), asyncTimeout));
            }
            throw new IOException("socket's input stream == null");
        }
        throw new IllegalArgumentException("socket == null");
    }

    private static AsyncTimeout timeout(final Socket socket) {
        return new AsyncTimeout(){

            @Override
            protected IOException newTimeoutException(@Nullable IOException iOException) {
                SocketTimeoutException socketTimeoutException;
                SocketTimeoutException socketTimeoutException2 = socketTimeoutException;
                socketTimeoutException = new SocketTimeoutException("timeout");
                if (iOException != null) {
                    socketTimeoutException2.initCause(iOException);
                }
                return socketTimeoutException2;
            }

            @Override
            protected void timedOut() {
                try {
                    socket.close();
                }
                catch (AssertionError assertionError) {
                    if (Okio.isAndroidGetsocknameError(assertionError)) {
                        logger.log(Level.WARNING, "Failed to close timed out socket " + socket, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Failed to close timed out socket " + socket, exception);
                }
            }
        };
    }

    static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        return ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains("getsockname failed");
    }
}

