/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Segment;
import dc.squareup.okio.SegmentPool;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public final class InflaterSource
implements Source {
    private final BufferedSource source;
    private final Inflater inflater;
    private int bufferBytesHeldByInflater;
    private boolean closed;

    public InflaterSource(Source source, Inflater inflater) {
        this(Okio.buffer(source), inflater);
    }

    InflaterSource(BufferedSource bufferedSource, Inflater inflater) {
        if (bufferedSource != null) {
            if (inflater != null) {
                InflaterSource inflaterSource = this;
                inflaterSource.source = bufferedSource;
                inflaterSource.inflater = inflater;
                return;
            }
            throw new IllegalArgumentException("inflater == null");
        }
        throw new IllegalArgumentException("source == null");
    }

    private void releaseInflatedBytes() throws IOException {
        int n2 = this.bufferBytesHeldByInflater;
        if (n2 == 0) {
            return;
        }
        InflaterSource inflaterSource = this;
        int n3 = n2 - this.inflater.getRemaining();
        inflaterSource.bufferBytesHeldByInflater -= n3;
        inflaterSource.source.skip(n3);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long read(Buffer var1_2, long var2_3) throws IOException {
        block15: {
            block16: {
                block14: {
                    cfr_temp_0 = var2_3 - 0L;
                    var4_4 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                    if (var4_4 < 0) break block15;
                    if (this.closed) break block16;
                    if (var4_4 == false) {
                        return 0L;
                    }
                    while (true) {
                        var4_4 = (long)this.refill();
                        var5_6 = var1_2.writableSegment(1);
                        v0 = 8192 - var5_6.limit;
                        var6_7 = (int)Math.min(var2_3, v0);
                        v1 = this.inflater;
                        v2 = var5_6;
                        v3 = v2;
                        var7_8 = v2.data;
                        var6_7 = v1.inflate(var7_8, v3.limit, var6_7);
                        if (var6_7 <= 0) ** GOTO lbl36
                        v4 = var6_7;
                        v5 = var1_2;
                        v6 = var5_6;
                        v7 = v6;
                        v8 = v6.limit;
                        v7.limit = v8 + var6_7;
                        var2_3 = v5.size;
                        var4_5 = v4;
                        var1_2.size = var2_3 + var4_5;
                        return var4_5;
lbl36:
                        // 1 sources

                        if (this.inflater.finished()) ** GOTO lbl42
                        if (this.inflater.needsDictionary()) ** GOTO lbl42
                        if (var4_4 == false) continue;
                        break;
                    }
                    throw new EOFException("source exhausted prematurely");
lbl42:
                    // 2 sources

                    this.releaseInflatedBytes();
                    if (var5_6.pos != var5_6.limit) break block14;
                    try {
                        var1_2.head = var5_6.pop();
                        SegmentPool.recycle(var5_6);
                    }
                    catch (DataFormatException var0_1) {
                        throw new IOException(var0_1);
                    }
                }
                return -1L;
            }
            throw new IllegalStateException("closed");
        }
        throw new IllegalArgumentException("byteCount < 0: " + var2_3);
    }

    public final boolean refill() throws IOException {
        if (!((InflaterSource)((Object)segment)).inflater.needsInput()) {
            return false;
        }
        InflaterSource inflaterSource = segment;
        inflaterSource.releaseInflatedBytes();
        if (inflaterSource.inflater.getRemaining() == 0) {
            int n2;
            if (((InflaterSource)((Object)segment)).source.exhausted()) {
                return true;
            }
            InflaterSource inflaterSource2 = segment;
            Segment segment = inflaterSource2.source.buffer().head;
            int n3 = segment.pos;
            inflaterSource2.bufferBytesHeldByInflater = n2 = segment.limit - n3;
            inflaterSource2.inflater.setInput(segment.data, n3, n2);
            return false;
        }
        throw new IllegalStateException("?");
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        InflaterSource inflaterSource = this;
        inflaterSource.inflater.end();
        inflaterSource.closed = true;
        inflaterSource.source.close();
    }
}

