/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import androidx.annotation.Nullable;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.ForwardingSink;
import dc.squareup.okio.Segment;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Util;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class HashingSink
extends ForwardingSink {
    @Nullable
    private final MessageDigest messageDigest;
    @Nullable
    private final Mac mac;

    public static HashingSink md5(Sink sink) {
        return new HashingSink(sink, "MD5");
    }

    public static HashingSink sha1(Sink sink) {
        return new HashingSink(sink, "SHA-1");
    }

    public static HashingSink sha256(Sink sink) {
        return new HashingSink(sink, "SHA-256");
    }

    public static HashingSink sha512(Sink sink) {
        return new HashingSink(sink, "SHA-512");
    }

    public static HashingSink hmacSha1(Sink sink, ByteString byteString) {
        return new HashingSink(sink, byteString, "HmacSHA1");
    }

    public static HashingSink hmacSha256(Sink sink, ByteString byteString) {
        return new HashingSink(sink, byteString, "HmacSHA256");
    }

    public static HashingSink hmacSha512(Sink sink, ByteString byteString) {
        return new HashingSink(sink, byteString, "HmacSHA512");
    }

    private HashingSink(Sink sink, String string2) {
        HashingSink hashingSink = this;
        super(sink);
        try {
            hashingSink.messageDigest = MessageDigest.getInstance(string2);
            hashingSink.mac = null;
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    private HashingSink(Sink sink, ByteString byteString, String string2) {
        super(sink);
        Mac mac = Mac.getInstance(string2);
        try {
            this.mac = mac;
            mac.init(new SecretKeySpec(byteString.toByteArray(), string2));
            this.messageDigest = null;
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    @Override
    public void write(Buffer buffer, long l2) throws IOException {
        int n2;
        Buffer buffer2 = buffer;
        Util.checkOffsetAndCount(buffer2.size, 0L, l2);
        Segment segment = buffer2.head;
        for (long i2 = 0L; i2 < l2; i2 += (long)n2) {
            n2 = (int)Math.min(l2 - i2, (long)(segment.limit - segment.pos));
            Object object = this.messageDigest;
            if (object != null) {
                MessageDigest messageDigest = object;
                Segment segment2 = segment;
                object = segment2.data;
                messageDigest.update((byte[])object, segment2.pos, n2);
            } else {
                Segment segment3 = segment;
                object = segment3.data;
                this.mac.update((byte[])object, segment3.pos, n2);
            }
            segment = segment.next;
        }
        super.write(buffer, l2);
    }

    public final ByteString hash() {
        MessageDigest messageDigest = this.messageDigest;
        return ByteString.of(messageDigest != null ? messageDigest.digest() : this.mac.doFinal());
    }
}

