/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.InflaterSource;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Segment;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import io.dcloud.common.util.StringUtil;
import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Inflater;

public final class GzipSource
implements Source {
    private static final byte FHCRC = 1;
    private static final byte FEXTRA = 2;
    private static final byte FNAME = 3;
    private static final byte FCOMMENT = 4;
    private static final byte SECTION_HEADER = 0;
    private static final byte SECTION_BODY = 1;
    private static final byte SECTION_TRAILER = 2;
    private static final byte SECTION_DONE = 3;
    private int section = 0;
    private final BufferedSource source;
    private final Inflater inflater;
    private final InflaterSource inflaterSource;
    private final CRC32 crc;

    public GzipSource(Source source) {
        CRC32 cRC32;
        Object object = cRC32;
        cRC32 = new CRC32();
        ((GzipSource)((Object)inflater2)).crc = object;
        if (source != null) {
            InflaterSource inflaterSource;
            Inflater inflater;
            GzipSource gzipSource = inflater2;
            GzipSource gzipSource2 = inflater2;
            Inflater inflater2 = inflater;
            inflater = new Inflater(true);
            gzipSource2.inflater = inflater2;
            source = Okio.buffer(source);
            gzipSource.source = source;
            object = inflaterSource;
            inflaterSource = new InflaterSource((BufferedSource)source, inflater2);
            gzipSource.inflaterSource = object;
            return;
        }
        throw new IllegalArgumentException("source == null");
    }

    private void consumeHeader() throws IOException {
        GzipSource gzipSource = this;
        gzipSource.source.require(10L);
        short s = gzipSource.source.buffer().getByte(3L);
        boolean bl = (s >> 1 & 1) == 1;
        if (bl) {
            GzipSource gzipSource2 = this;
            gzipSource2.updateCrc(gzipSource2.source.buffer(), 0L, 10L);
        }
        GzipSource gzipSource3 = this;
        short s2 = gzipSource3.source.readShort();
        gzipSource3.checkEqual("ID1ID2", 8075, s2);
        gzipSource3.source.skip(8L);
        if ((s >> 2 & 1) == 1) {
            this.source.require(2L);
            if (bl) {
                GzipSource gzipSource4 = this;
                gzipSource4.updateCrc(gzipSource4.source.buffer(), 0L, 2L);
            }
            GzipSource gzipSource5 = this;
            s2 = gzipSource5.source.buffer().readShortLe();
            long l2 = s2;
            gzipSource5.source.require(l2);
            if (bl) {
                GzipSource gzipSource6 = this;
                gzipSource6.updateCrc(gzipSource6.source.buffer(), 0L, l2);
            }
            this.source.skip(l2);
        }
        if ((s >> 3 & 1) == 1) {
            long l3 = this.source.indexOf((byte)0);
            if (l3 != -1L) {
                if (bl) {
                    Buffer buffer = this.source.buffer();
                    long l4 = l3 + 1L;
                    this.updateCrc(buffer, 0L, l4);
                }
                this.source.skip(l3 + 1L);
            } else {
                throw new EOFException();
            }
        }
        if ((s >> 4 & 1) == 1) {
            long l5 = this.source.indexOf((byte)0);
            if (l5 != -1L) {
                if (bl) {
                    Buffer buffer = this.source.buffer();
                    long l6 = l5 + 1L;
                    this.updateCrc(buffer, 0L, l6);
                }
                this.source.skip(l5 + 1L);
            } else {
                throw new EOFException();
            }
        }
        if (bl) {
            GzipSource gzipSource7 = this;
            short s3 = gzipSource7.source.readShortLe();
            s = (short)gzipSource7.crc.getValue();
            gzipSource7.checkEqual("FHCRC", s3, s);
            gzipSource7.crc.reset();
        }
    }

    private void consumeTrailer() throws IOException {
        GzipSource gzipSource = this;
        int n2 = gzipSource.source.readIntLe();
        int n3 = (int)gzipSource.crc.getValue();
        gzipSource.checkEqual("CRC", n2, n3);
        n2 = gzipSource.source.readIntLe();
        n3 = (int)gzipSource.inflater.getBytesWritten();
        gzipSource.checkEqual("ISIZE", n2, n3);
    }

    private void updateCrc(Buffer object, long l2, long l3) {
        int n2;
        int n3;
        object = ((Buffer)object).head;
        while (l2 >= (long)((n3 = ((Segment)object).limit) - (n2 = ((Segment)object).pos))) {
            l2 -= (long)(n3 - n2);
            object = ((Segment)object).next;
        }
        while (l3 > 0L) {
            Object object2 = object;
            int n4 = (int)((long)((Segment)object2).pos + l2);
            int n5 = (int)Math.min((long)(((Segment)object2).limit - n4), l3);
            this.crc.update(((Segment)object).data, n4, n5);
            l3 -= (long)n5;
            l2 = 0L;
            object = ((Segment)object).next;
        }
    }

    private void checkEqual(String string2, int n2, int n3) throws IOException {
        if (n3 == n2) {
            return;
        }
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = string2;
        objectArray2[1] = n3;
        objectArray[2] = n2;
        throw new IOException(StringUtil.format("%s: actual 0x%08x != expected 0x%08x", objectArray2));
    }

    @Override
    public long read(Buffer buffer, long l2) throws IOException {
        long l3 = l2 - 0L;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        if (l4 >= 0) {
            if (l4 == false) {
                return 0L;
            }
            if (this.section == 0) {
                this.consumeHeader();
                this.section = 1;
            }
            if (this.section == 1) {
                long l5 = buffer.size;
                if ((l2 = this.inflaterSource.read(buffer, l2)) != -1L) {
                    this.updateCrc(buffer, l5, l2);
                    return l2;
                }
                this.section = 2;
            }
            if (this.section == 2) {
                GzipSource gzipSource = this;
                gzipSource.consumeTrailer();
                gzipSource.section = 3;
                if (!gzipSource.source.exhausted()) {
                    throw new IOException("gzip finished without exhausting source");
                }
            }
            return -1L;
        }
        throw new IllegalArgumentException("byteCount < 0: " + l2);
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public void close() throws IOException {
        this.inflaterSource.close();
    }
}

