/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http2;

import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.http2.ErrorCode;
import dc.squareup.okhttp3.internal.http2.Header;
import dc.squareup.okhttp3.internal.http2.Hpack;
import dc.squareup.okhttp3.internal.http2.Http2;
import dc.squareup.okhttp3.internal.http2.Settings;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Http2Writer
implements Closeable {
    private static final Logger logger = Logger.getLogger(Http2.class.getName());
    private final BufferedSink sink;
    private final boolean client;
    private final Buffer hpackBuffer;
    private int maxFrameSize;
    private boolean closed;
    final Hpack.Writer hpackWriter;

    Http2Writer(BufferedSink object, boolean bl) {
        Hpack.Writer writer;
        Buffer buffer;
        closeable.sink = object;
        closeable.client = bl;
        Closeable closeable = buffer;
        buffer = new Buffer();
        v1.hpackBuffer = closeable;
        object = writer;
        writer = new Hpack.Writer((Buffer)closeable);
        v1.hpackWriter = object;
        v1.maxFrameSize = 16384;
    }

    private static void writeMedium(BufferedSink bufferedSink, int n2) throws IOException {
        bufferedSink.writeByte(n2 >>> 16 & 0xFF);
        bufferedSink.writeByte(n2 >>> 8 & 0xFF);
        bufferedSink.writeByte(n2 & 0xFF);
    }

    private void writeContinuationFrames(int n2, long l2) throws IOException {
        while (l2 > 0L) {
            int n3 = (int)Math.min((long)this.maxFrameSize, l2);
            long l3 = n3;
            long l4 = l2 - l3;
            byte by = 9;
            byte by2 = l4 == 0L ? (byte)4 : 0;
            Http2Writer http2Writer = this;
            http2Writer.frameHeader(n2, n3, by, by2);
            http2Writer.sink.write(this.hpackBuffer, l3);
            l2 = l4;
        }
    }

    public synchronized void connectionPreface() throws IOException {
        if (!this.closed) {
            if (!this.client) {
                return;
            }
            Object[] objectArray = logger;
            if (logger.isLoggable(Level.FINE)) {
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = Http2.CONNECTION_PREFACE.hex();
                objectArray2.fine(Util.format(">> CONNECTION %s", objectArray));
            }
            Http2Writer http2Writer = this;
            http2Writer.sink.write(Http2.CONNECTION_PREFACE.toByteArray());
            http2Writer.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void applyAndAckSettings(Settings settings) throws IOException {
        if (!this.closed) {
            this.maxFrameSize = settings.getMaxFrameSize(this.maxFrameSize);
            if (settings.getHeaderTableSize() != -1) {
                this.hpackWriter.setHeaderTableSizeSetting(settings.getHeaderTableSize());
            }
            Http2Writer http2Writer = this;
            http2Writer.frameHeader(0, 0, (byte)4, (byte)1);
            http2Writer.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void pushPromise(int n2, int n3, List<Header> list) throws IOException {
        if (!this.closed) {
            Http2Writer http2Writer = this;
            http2Writer.hpackWriter.writeHeaders(list);
            long l2 = http2Writer.hpackBuffer.size();
            int n4 = (int)Math.min((long)(this.maxFrameSize - 4), l2);
            byte by = 5;
            long l3 = n4;
            long l4 = l2 == l3 ? 0 : (l2 < l3 ? -1 : 1);
            byte by2 = l4 == false ? (byte)4 : 0;
            Http2Writer http2Writer2 = this;
            http2Writer2.frameHeader(n2, n4 + 4, by, by2);
            http2Writer2.sink.writeInt(n3 & Integer.MAX_VALUE);
            http2Writer2.sink.write(this.hpackBuffer, l3);
            if (l4 > 0) {
                long l5 = l2 - l3;
                this.writeContinuationFrames(n2, l5);
            }
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void flush() throws IOException {
        if (!this.closed) {
            this.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void synStream(boolean bl, int n2, int n3, List<Header> list) throws IOException {
        if (!this.closed) {
            this.headers(bl, n2, list);
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void synReply(boolean bl, int n2, List<Header> list) throws IOException {
        if (!this.closed) {
            this.headers(bl, n2, list);
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void headers(int n2, List<Header> list) throws IOException {
        if (!this.closed) {
            this.headers(false, n2, list);
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void rstStream(int n2, ErrorCode errorCode) throws IOException {
        if (!this.closed) {
            if (errorCode.httpCode != -1) {
                Http2Writer http2Writer = this;
                http2Writer.frameHeader(n2, 4, (byte)3, (byte)0);
                http2Writer.sink.writeInt(errorCode.httpCode);
                http2Writer.sink.flush();
                return;
            }
            throw new IllegalArgumentException();
        }
        throw new IOException("closed");
    }

    public int maxDataLength() {
        return this.maxFrameSize;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void data(boolean bl, int n2, Buffer buffer, int n3) throws IOException {
        if (!this.closed) {
            void var4_6;
            void var3_5;
            void var2_4;
            byte by;
            boolean bl2 = false;
            if (bl) {
                by = (byte)1;
            }
            this.dataFrame((int)var2_4, by, (Buffer)var3_5, (int)var4_6);
            return;
        }
        throw new IOException("closed");
    }

    void dataFrame(int n2, byte by, Buffer buffer, int n3) throws IOException {
        this.frameHeader(n2, n3, (byte)0, by);
        if (n3 > 0) {
            this.sink.write(buffer, (long)n3);
        }
    }

    public synchronized void settings(Settings settings) throws IOException {
        if (!this.closed) {
            this.frameHeader(0, settings.size() * 6, (byte)4, (byte)0);
            for (int i2 = 0; i2 < 10; ++i2) {
                if (!settings.isSet(i2)) continue;
                int n2 = i2 == 4 ? 3 : (i2 == 7 ? 4 : i2);
                Http2Writer http2Writer = this;
                http2Writer.sink.writeShort(n2);
                http2Writer.sink.writeInt(settings.get(i2));
            }
            this.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void ping(boolean bl, int n2, int n3) throws IOException {
        if (!this.closed) {
            Http2Writer http2Writer = this;
            byte by = 6;
            http2Writer.frameHeader(0, 8, by, (byte)(bl ? 1 : 0));
            http2Writer.sink.writeInt(n2);
            http2Writer.sink.writeInt(n3);
            http2Writer.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public synchronized void goAway(int n2, ErrorCode errorCode, byte[] byArray) throws IOException {
        if (!this.closed) {
            if (errorCode.httpCode != -1) {
                Http2Writer http2Writer = this;
                http2Writer.frameHeader(0, byArray.length + 8, (byte)7, (byte)0);
                http2Writer.sink.writeInt(n2);
                http2Writer.sink.writeInt(errorCode.httpCode);
                if (byArray.length > 0) {
                    this.sink.write(byArray);
                }
                this.sink.flush();
                return;
            }
            throw Http2.illegalArgument("errorCode.httpCode == -1", new Object[0]);
        }
        throw new IOException("closed");
    }

    public synchronized void windowUpdate(int n2, long l2) throws IOException {
        if (!objectArray2.closed) {
            if (l2 != 0L && l2 <= Integer.MAX_VALUE) {
                Object[] objectArray = objectArray2;
                objectArray.frameHeader(n2, 4, (byte)8, (byte)0);
                objectArray.sink.writeInt((int)l2);
                objectArray2.sink.flush();
                return;
            }
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = l2;
            throw Http2.illegalArgument("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: %s", objectArray2);
        }
        throw new IOException("closed");
    }

    public void frameHeader(int n2, int n3, byte by, byte by2) throws IOException {
        Object[] objectArray;
        int n4;
        Logger logger = Http2Writer.logger;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.frameLog(false, n2, n3, by, by2));
        }
        if (n3 <= (n4 = objectArray.maxFrameSize)) {
            if ((n2 & Integer.MIN_VALUE) == 0) {
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = objectArray;
                Http2Writer.writeMedium(objectArray2.sink, n3);
                objectArray3.sink.writeByte(by & 0xFF);
                objectArray2.sink.writeByte(by2 & 0xFF);
                objectArray3.sink.writeInt(n2 & Integer.MAX_VALUE);
                return;
            }
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = n2;
            throw Http2.illegalArgument("reserved bit set: %s", objectArray);
        }
        Object[] objectArray5 = new Object[2];
        objectArray = objectArray5;
        objectArray[0] = n4;
        objectArray5[1] = n3;
        throw Http2.illegalArgument("FRAME_SIZE_ERROR length > %d: %d", objectArray);
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        this.sink.close();
    }

    void headers(boolean bl, int n2, List<Header> list) throws IOException {
        if (!this.closed) {
            Http2Writer http2Writer = this;
            http2Writer.hpackWriter.writeHeaders(list);
            long l2 = http2Writer.hpackBuffer.size();
            int n3 = (int)Math.min((long)this.maxFrameSize, l2);
            byte by = 1;
            long l3 = n3;
            long l4 = l2 == l3 ? 0 : (l2 < l3 ? -1 : 1);
            byte by2 = l4 == false ? (byte)4 : 0;
            if (bl) {
                by2 = (byte)(by2 | 1);
            }
            Http2Writer http2Writer2 = this;
            http2Writer2.frameHeader(n2, n3, by, by2);
            http2Writer2.sink.write(this.hpackBuffer, l3);
            if (l4 > 0) {
                long l5 = l2 - l3;
                this.writeContinuationFrames(n2, l5);
            }
            return;
        }
        throw new IOException("closed");
    }
}

