/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http2;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.http2.ErrorCode;
import dc.squareup.okhttp3.internal.http2.Header;
import dc.squareup.okhttp3.internal.http2.Http2Connection;
import dc.squareup.okhttp3.internal.http2.StreamResetException;
import dc.squareup.okio.AsyncTimeout;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

public final class Http2Stream {
    static final /* synthetic */ boolean $assertionsDisabled;
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    final int id;
    final Http2Connection connection;
    private final Deque<Headers> headersQueue;
    private Header.Listener headersListener;
    private boolean hasResponseHeaders;
    private final FramingSource source;
    final FramingSink sink;
    final StreamTimeout readTimeout;
    final StreamTimeout writeTimeout;
    ErrorCode errorCode;

    Http2Stream(int n2, Http2Connection closeable, boolean bl, boolean bl2, @Nullable Headers headers) {
        StreamTimeout streamTimeout;
        StreamTimeout streamTimeout2;
        ArrayDeque<Headers> arrayDeque;
        ArrayDeque<Headers> arrayDeque2 = arrayDeque;
        arrayDeque = new ArrayDeque<Headers>();
        this.headersQueue = arrayDeque2;
        StreamTimeout streamTimeout3 = streamTimeout2;
        streamTimeout2 = new StreamTimeout();
        this.readTimeout = streamTimeout3;
        streamTimeout3 = streamTimeout;
        streamTimeout = new StreamTimeout();
        this.writeTimeout = streamTimeout3;
        this.errorCode = null;
        if (closeable != null) {
            FramingSink framingSink;
            FramingSource framingSource;
            Http2Stream http2Stream = this;
            this.id = n2;
            this.connection = closeable;
            http2Stream.bytesLeftInWriteWindow = closeable.peerSettings.getInitialWindowSize();
            FramingSource framingSource2 = framingSource;
            http2Stream.source = new FramingSource(closeable.okHttpSettings.getInitialWindowSize());
            Closeable closeable2 = closeable = framingSink;
            this.sink = closeable2;
            framingSource2.finished = bl2;
            framingSink.finished = bl;
            if (headers != null) {
                arrayDeque2.add(headers);
            }
            if (this.isLocallyInitiated() && headers != null) {
                throw new IllegalStateException("locally-initiated streams shouldn't have headers yet");
            }
            if (!this.isLocallyInitiated() && headers == null) {
                throw new IllegalStateException("remotely-initiated streams should have headers");
            }
            return;
        }
        throw new NullPointerException("connection == null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean closeInternal(ErrorCode errorCode) {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (http2Stream.errorCode != null) {
                // ** MonitorExit[this] (shouldn't be in output)
                return false;
            }
            if (this.source.finished && this.sink.finished) {
                // ** MonitorExit[this] (shouldn't be in output)
                return false;
            }
            Http2Stream http2Stream2 = this;
            http2Stream2.errorCode = errorCode;
            http2Stream2.notifyAll();
            // ** MonitorExit[v1] (shouldn't be in output)
            http2Stream2.connection.removeStream(this.id);
            return true;
        }
    }

    static {
        $assertionsDisabled = Http2Stream.class.desiredAssertionStatus() ^ true;
    }

    public int getId() {
        return this.id;
    }

    public synchronized boolean isOpen() {
        if (this.errorCode != null) {
            return false;
        }
        Closeable closeable = this.source;
        if (closeable.finished || closeable.closed) {
            closeable = this.sink;
            if ((((FramingSink)closeable).finished || ((FramingSink)closeable).closed) && this.hasResponseHeaders) {
                return false;
            }
        }
        return true;
    }

    public boolean isLocallyInitiated() {
        boolean bl = (this.id & 1) == 1;
        return this.connection.client == bl;
    }

    public Http2Connection getConnection() {
        return this.connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Headers takeHeaders() throws IOException {
        Http2Stream http2Stream;
        this.readTimeout.enter();
        try {
            while (this.headersQueue.isEmpty() && this.errorCode == null) {
                this.waitForIo();
            }
            http2Stream = this;
        }
        catch (Throwable throwable) {
            this.readTimeout.exitAndThrowIfTimedOut();
            throw throwable;
        }
        http2Stream.readTimeout.exitAndThrowIfTimedOut();
        if (!http2Stream.headersQueue.isEmpty()) {
            return this.headersQueue.removeFirst();
        }
        throw new StreamResetException(this.errorCode);
    }

    public synchronized ErrorCode getErrorCode() {
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeHeaders(List<Header> list, boolean bl) throws IOException {
        boolean bl2;
        block10: {
            Http2Connection http2Connection;
            Http2Stream http2Stream;
            if (!$assertionsDisabled && Thread.holdsLock(this)) {
                throw new AssertionError();
            }
            if (list == null) {
                throw new NullPointerException("headers == null");
            }
            boolean bl3 = bl;
            bl = false;
            bl2 = false;
            synchronized (this) {
                this.hasResponseHeaders = true;
                if (!bl3) {
                    this.sink.finished = true;
                    bl2 = true;
                    bl = true;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl15 : MonitorExitStatement: MONITOREXIT : this
                if (bl2) break block10;
                http2Stream = this;
                http2Connection = http2Stream.connection;
            }
            synchronized (http2Connection) {
                bl2 = http2Stream.connection.bytesLeftInWriteWindow == 0L;
            }
        }
        this.connection.writeSynReply(this.id, bl, list);
        if (bl2) {
            this.connection.flush();
        }
    }

    public Timeout readTimeout() {
        return this.readTimeout;
    }

    public Timeout writeTimeout() {
        return this.writeTimeout;
    }

    public Source getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sink getSink() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (!http2Stream.hasResponseHeaders && !this.isLocallyInitiated()) {
                throw new IllegalStateException("reply before requesting the sink");
            }
            Http2Stream http2Stream2 = this;
            // ** MonitorExit[v1] (shouldn't be in output)
            return http2Stream2.sink;
        }
    }

    public void close(ErrorCode errorCode) throws IOException {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynReset(this.id, errorCode);
    }

    public void closeLater(ErrorCode errorCode) {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynResetLater(this.id, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveHeaders(List<Header> list) {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            http2Stream.hasResponseHeaders = true;
            http2Stream.headersQueue.add(Util.toHeaders(list));
            boolean bl = http2Stream.isOpen();
            Http2Stream http2Stream2 = this;
            http2Stream2.notifyAll();
            // ** MonitorExit[v3] (shouldn't be in output)
            if (!bl) {
                this.connection.removeStream(this.id);
            }
            return;
        }
    }

    void receiveData(BufferedSource bufferedSource, int n2) throws IOException {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.source.receive(bufferedSource, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveFin() {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            http2Stream.source.finished = true;
            boolean bl = http2Stream.isOpen();
            Http2Stream http2Stream2 = this;
            http2Stream2.notifyAll();
            // ** MonitorExit[v2] (shouldn't be in output)
            if (!bl) {
                this.connection.removeStream(this.id);
            }
            return;
        }
    }

    synchronized void receiveRstStream(ErrorCode errorCode) {
        if (this.errorCode == null) {
            this.errorCode = errorCode;
            this.notifyAll();
        }
    }

    public synchronized void setHeadersListener(Header.Listener listener) {
        this.headersListener = listener;
        if (!this.headersQueue.isEmpty() && listener != null) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelStreamIfNecessary() throws IOException {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            boolean bl;
            block16: {
                block14: {
                    block15: {
                        Closeable closeable = http2Stream.source;
                        if (closeable.finished) break block14;
                        if (!closeable.closed) break block14;
                        closeable = this.sink;
                        if (((FramingSink)closeable).finished) break block15;
                        if (!((FramingSink)closeable).closed) break block14;
                    }
                    bl = true;
                    break block16;
                }
                bl = false;
            }
            boolean bl2 = bl;
            Http2Stream http2Stream2 = this;
            Http2Stream http2Stream3 = http2Stream2;
            bl = http2Stream2.isOpen();
            // ** MonitorExit[v4] (shouldn't be in output)
            if (bl2) {
                this.close(ErrorCode.CANCEL);
            } else if (!bl) {
                this.connection.removeStream(this.id);
            }
            return;
        }
    }

    void addBytesToWriteWindow(long l2) {
        this.bytesLeftInWriteWindow += l2;
        if (l2 > 0L) {
            this.notifyAll();
        }
    }

    void checkOutNotClosed() throws IOException {
        FramingSink framingSink = this.sink;
        if (!framingSink.closed) {
            if (!framingSink.finished) {
                if (this.errorCode == null) {
                    return;
                }
                throw new StreamResetException(this.errorCode);
            }
            throw new IOException("stream finished");
        }
        throw new IOException("stream closed");
    }

    void waitForIo() throws InterruptedIOException {
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    class StreamTimeout
    extends AsyncTimeout {
        StreamTimeout() {
        }

        @Override
        protected void timedOut() {
            StreamTimeout streamTimeout = this;
            streamTimeout.Http2Stream.this.closeLater(ErrorCode.CANCEL);
            streamTimeout.Http2Stream.this.connection.sendDegradedPingLater();
        }

        @Override
        protected IOException newTimeoutException(IOException iOException) {
            SocketTimeoutException socketTimeoutException;
            SocketTimeoutException socketTimeoutException2 = socketTimeoutException;
            socketTimeoutException = new SocketTimeoutException("timeout");
            if (iOException != null) {
                socketTimeoutException2.initCause(iOException);
            }
            return socketTimeoutException2;
        }

        public void exitAndThrowIfTimedOut() throws IOException {
            if (!this.exit()) {
                return;
            }
            throw this.newTimeoutException(null);
        }
    }

    final class FramingSink
    implements Sink {
        private static final long EMIT_BUFFER_SIZE = 16384L;
        static final /* synthetic */ boolean $assertionsDisabled;
        private final Buffer sendBuffer;
        boolean closed;
        boolean finished;

        FramingSink() {
            Buffer buffer;
            Sink sink = buffer;
            buffer = new Buffer();
            v1.sendBuffer = sink;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void emitFrame(boolean bl) throws IOException {
            FramingSink framingSink = this;
            Http2Stream http2Stream = framingSink.Http2Stream.this;
            synchronized (http2Stream) {
                boolean bl22;
                int n2;
                Object object;
                long l2;
                block22: {
                    Http2Stream http2Stream2;
                    Http2Stream http2Stream3;
                    framingSink.Http2Stream.this.writeTimeout.enter();
                    while (true) {
                        http2Stream3 = Http2Stream.this;
                        if (http2Stream3.bytesLeftInWriteWindow > 0L) break;
                        if (this.finished) break;
                        if (this.closed) break;
                        if (http2Stream3.errorCode != null) break;
                        http2Stream3.waitForIo();
                        continue;
                        break;
                    }
                    boolean bl3 = bl;
                    FramingSink framingSink2 = this;
                    Http2Stream http2Stream4 = http2Stream;
                    FramingSink framingSink3 = this;
                    FramingSink framingSink4 = framingSink3;
                    http2Stream3.writeTimeout.exitAndThrowIfTimedOut();
                    framingSink3.Http2Stream.this.checkOutNotClosed();
                    l2 = Math.min(framingSink3.Http2Stream.this.bytesLeftInWriteWindow, this.sendBuffer.size());
                    object = framingSink4.Http2Stream.this;
                    long l3 = ((Http2Stream)object).bytesLeftInWriteWindow;
                    ((Http2Stream)object).bytesLeftInWriteWindow = l3 - l2;
                    // ** MonitorExit[v3] (shouldn't be in output)
                    ((Http2Stream)object).writeTimeout.enter();
                    try {
                        Http2Stream http2Stream5 = framingSink2.Http2Stream.this;
                        http2Stream2 = http2Stream5;
                        object = http2Stream5.connection;
                    }
                    catch (Throwable throwable) {
                        Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
                        throw throwable;
                    }
                    n2 = http2Stream2.id;
                    if (bl3) {
                        if (l2 != this.sendBuffer.size()) break block22;
                        bl22 = true;
                    }
                }
                bl22 = false;
                ((Http2Connection)object).writeData(n2, bl22, this.sendBuffer, l2);
                Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
                return;
                catch (Throwable throwable) {
                    Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
                    throw throwable;
                }
            }
        }

        static {
            $assertionsDisabled = Http2Stream.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public void write(Buffer buffer, long l2) throws IOException {
            if (!$assertionsDisabled && Thread.holdsLock(Http2Stream.this)) {
                throw new AssertionError();
            }
            this.sendBuffer.write(buffer, l2);
            while (this.sendBuffer.size() >= 16384L) {
                this.emitFrame(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void flush() throws IOException {
            if (!$assertionsDisabled && Thread.holdsLock(Http2Stream.this)) {
                throw new AssertionError();
            }
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                Http2Stream.this.checkOutNotClosed();
            }
            while (this.sendBuffer.size() > 0L) {
                FramingSink framingSink = this;
                framingSink.emitFrame(false);
                framingSink.Http2Stream.this.connection.flush();
            }
            return;
        }

        @Override
        public Timeout timeout() {
            return Http2Stream.this.writeTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() throws IOException {
            block9: {
                Http2Stream http2Stream;
                block10: {
                    if (!$assertionsDisabled && Thread.holdsLock(Http2Stream.this)) {
                        throw new AssertionError();
                    }
                    FramingSink framingSink = this;
                    http2Stream = framingSink.Http2Stream.this;
                    synchronized (http2Stream) {
                        if (framingSink.closed) {
                            return;
                        }
                        // MONITOREXIT @DISABLED, blocks:[0, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                        if (Http2Stream.this.sink.finished) break block9;
                        if (this.sendBuffer.size() <= 0L) break block10;
                    }
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(true);
                    }
                    break block9;
                }
                http2Stream = Http2Stream.this;
                http2Stream.connection.writeData(http2Stream.id, true, null, 0L);
            }
            FramingSink framingSink = this;
            Http2Stream http2Stream = framingSink.Http2Stream.this;
            synchronized (http2Stream) {
                this.closed = true;
            }
            framingSink.Http2Stream.this.connection.flush();
            framingSink.Http2Stream.this.cancelStreamIfNecessary();
        }
    }

    private final class FramingSource
    implements Source {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final Buffer receiveBuffer;
        private final Buffer readBuffer;
        private final long maxByteCount;
        boolean closed;
        boolean finished;

        FramingSource(long l2) {
            Buffer buffer;
            Buffer buffer2;
            Source source = buffer2;
            buffer2 = new Buffer();
            v1.receiveBuffer = source;
            source = buffer;
            buffer = new Buffer();
            v1.readBuffer = source;
            v1.maxByteCount = l2;
        }

        private void updateConnectionFlowControl(long l2) {
            if (!$assertionsDisabled && Thread.holdsLock(Http2Stream.this)) {
                throw new AssertionError();
            }
            Http2Stream.this.connection.updateConnectionFlowControl(l2);
        }

        static {
            $assertionsDisabled = Http2Stream.class.desiredAssertionStatus() ^ true;
        }

        /*
         * Exception decompiling
         */
        @Override
        public long read(Buffer var1_1, long var2_3) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        void receive(BufferedSource var1_1, long var2_2) throws IOException {
            if (!FramingSource.$assertionsDisabled && Thread.holdsLock(Http2Stream.this)) {
                throw new AssertionError();
            }
            while (var2_2 > 0L) {
                block17: {
                    block16: {
                        v0 = this;
                        var4_4 = v0.Http2Stream.this;
                        synchronized (var4_4) {
                            var5_5 = v0.finished;
                            v1 = var2_2 + v0.readBuffer.size();
                            var6_7 = v1 > this.maxByteCount;
                            // MONITOREXIT @DISABLED, blocks:[3, 9, 13] lbl14 : MonitorExitStatement: MONITOREXIT : var4_4
                            if (!var6_7) break block16;
                        }
                        var1_1.skip(var2_2);
                        Http2Stream.this.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                        return;
                    }
                    if (var5_5) {
                        var1_1.skip(var2_2);
                        return;
                    }
                    var4_3 = var1_1.read(this.receiveBuffer, var2_2);
                    if (var4_3 == -1L) break block17;
                    v2 = this;
                    var2_2 -= var4_3;
                    var4_3 = 0L;
                    var6_6 = v2.Http2Stream.this;
                    synchronized (var6_6) {
                        if (!v2.closed) ** GOTO lbl41
                        v4 = this;
                        v5 = v4;
                        var4_3 = v4.receiveBuffer.size();
                        v5.receiveBuffer.clear();
                        ** GOTO lbl49
lbl41:
                        // 1 sources

                        var7_8 = this.readBuffer.size() == 0L;
                        v6 = var7_8;
                        this.readBuffer.writeAll(this.receiveBuffer);
                        if (!v6) ** GOTO lbl49
                        Http2Stream.this.notifyAll();
lbl49:
                        // 3 sources

                        // MONITOREXIT @DISABLED, blocks:[8, 10, 13] lbl46 : MonitorExitStatement: MONITOREXIT : var6_6
                        if (var4_3 <= 0L) continue;
                        this.updateConnectionFlowControl(var4_3);
                        continue;
                    }
                }
                throw new EOFException();
                {
                    catch (Throwable v7) {
                        throw v7;
                    }
                }
            }
        }

        @Override
        public Timeout timeout() {
            return Http2Stream.this.readTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void close() throws IOException {
            Header.Listener listener;
            ArrayList arrayList;
            block11: {
                FramingSource framingSource = iterator;
                arrayList = null;
                listener = null;
                Http2Stream http2Stream = framingSource.Http2Stream.this;
                synchronized (http2Stream) {
                    long l2;
                    block10: {
                        ArrayList arrayList2;
                        framingSource.closed = true;
                        l2 = framingSource.readBuffer.size();
                        framingSource.readBuffer.clear();
                        if (framingSource.Http2Stream.this.headersQueue.isEmpty()) break block10;
                        if (((FramingSource)((Object)iterator)).Http2Stream.this.headersListener == null) break block10;
                        FramingSource framingSource2 = iterator;
                        FramingSource framingSource3 = framingSource2;
                        FramingSource framingSource4 = framingSource2;
                        arrayList = arrayList2;
                        arrayList2 = new ArrayList(((FramingSource)((Object)iterator)).Http2Stream.this.headersQueue);
                        framingSource3.Http2Stream.this.headersQueue.clear();
                        listener = framingSource4.Http2Stream.this.headersListener;
                    }
                    ((FramingSource)((Object)iterator)).Http2Stream.this.notifyAll();
                    // MONITOREXIT @DISABLED, blocks:[5, 6] lbl25 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (l2 <= 0L) break block11;
                    ((FramingSource)((Object)iterator)).updateConnectionFlowControl(l2);
                }
            }
            ((FramingSource)((Object)iterator)).Http2Stream.this.cancelStreamIfNecessary();
            if (listener != null) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    listener.onHeaders((Headers)iterator.next());
                }
            }
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }
}

