/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http2;

import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.Interceptor;
import dc.squareup.okhttp3.OkHttpClient;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.ResponseBody;
import dc.squareup.okhttp3.internal.Internal;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.connection.StreamAllocation;
import dc.squareup.okhttp3.internal.http.HttpCodec;
import dc.squareup.okhttp3.internal.http.HttpHeaders;
import dc.squareup.okhttp3.internal.http.RealResponseBody;
import dc.squareup.okhttp3.internal.http.RequestLine;
import dc.squareup.okhttp3.internal.http.StatusLine;
import dc.squareup.okhttp3.internal.http2.ErrorCode;
import dc.squareup.okhttp3.internal.http2.Header;
import dc.squareup.okhttp3.internal.http2.Http2Connection;
import dc.squareup.okhttp3.internal.http2.Http2Stream;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.ForwardingSource;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class Http2Codec
implements HttpCodec {
    private static final String CONNECTION = "connection";
    private static final String HOST = "host";
    private static final String KEEP_ALIVE = "keep-alive";
    private static final String PROXY_CONNECTION = "proxy-connection";
    private static final String TRANSFER_ENCODING = "transfer-encoding";
    private static final String TE = "te";
    private static final String ENCODING = "encoding";
    private static final String UPGRADE = "upgrade";
    private static final List<String> HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableList("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade", ":method", ":path", ":scheme", ":authority");
    private static final List<String> HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableList("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade");
    private final Interceptor.Chain chain;
    final StreamAllocation streamAllocation;
    private final Http2Connection connection;
    private Http2Stream stream;
    private final Protocol protocol;

    public Http2Codec(OkHttpClient object, Interceptor.Chain chain, StreamAllocation streamAllocation, Http2Connection http2Connection) {
        this.chain = chain;
        this.streamAllocation = streamAllocation;
        this.connection = http2Connection;
        List<Protocol> list = object.protocols();
        object = Protocol.H2_PRIOR_KNOWLEDGE;
        if (!list.contains(object)) {
            object = Protocol.HTTP_2;
        }
        this.protocol = object;
    }

    public static List<Header> http2HeadersList(Request request) {
        ArrayList<Header> arrayList;
        Request request2 = request;
        Headers headers = request2.headers();
        ArrayList<Header> arrayList2 = arrayList;
        Object object = Header.TARGET_METHOD;
        new ArrayList<Header>(headers.size() + 4).add(new Header((ByteString)object, request.method()));
        arrayList2.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(request.url())));
        object = request2.header("Host");
        if (object != null) {
            arrayList2.add(new Header(Header.TARGET_AUTHORITY, (String)object));
        }
        arrayList2.add(new Header(Header.TARGET_SCHEME, request.url().scheme()));
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Header header;
            ByteString byteString = ByteString.encodeUtf8(headers.name(i2).toLowerCase(Locale.US));
            if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(byteString.utf8())) continue;
            Header header2 = header;
            header = new Header(byteString, headers.value(i2));
            arrayList2.add(header2);
        }
        return arrayList2;
    }

    public static Response.Builder readHttp2HeadersList(Headers headers, Protocol protocol) throws IOException {
        Headers.Builder builder;
        StatusLine statusLine = null;
        Headers.Builder builder2 = builder;
        builder = new Headers.Builder();
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = headers.name(i2);
            String string3 = headers.value(i2);
            if (string2.equals(":status")) {
                statusLine = StatusLine.parse("HTTP/1.1 " + string3);
                continue;
            }
            if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(string2)) continue;
            Internal.instance.addLenient(builder2, string2, string3);
        }
        if (statusLine != null) {
            return new Response.Builder().protocol(protocol).code(statusLine.code).message(statusLine.message).headers(builder2.build());
        }
        throw new ProtocolException("Expected ':status' header not present");
    }

    @Override
    public Sink createRequestBody(Request request, long l2) {
        return this.stream.getSink();
    }

    @Override
    public void writeRequestHeaders(Request object) throws IOException {
        if (this.stream != null) {
            return;
        }
        boolean bl = ((Request)object).body() != null;
        Http2Codec http2Codec = this;
        object = Http2Codec.http2HeadersList((Request)object);
        object = http2Codec.connection.newStream((List<Header>)object, bl);
        http2Codec.stream = object;
        Timeout timeout = ((Http2Stream)object).readTimeout();
        object = TimeUnit.MILLISECONDS;
        timeout.timeout(this.chain.readTimeoutMillis(), (TimeUnit)((Object)object));
        http2Codec.stream.writeTimeout().timeout(this.chain.writeTimeoutMillis(), (TimeUnit)((Object)object));
    }

    @Override
    public void flushRequest() throws IOException {
        this.connection.flush();
    }

    @Override
    public void finishRequest() throws IOException {
        this.stream.getSink().close();
    }

    @Override
    public Response.Builder readResponseHeaders(boolean bl) throws IOException {
        Response.Builder builder = Http2Codec.readHttp2HeadersList(((Http2Codec)((Object)builder)).stream.takeHeaders(), ((Http2Codec)((Object)builder)).protocol);
        if (bl && Internal.instance.code(builder) == 100) {
            return null;
        }
        return builder;
    }

    @Override
    public ResponseBody openResponseBody(Response object) throws IOException {
        StreamFinishingSource streamFinishingSource;
        Response response = object;
        object = this.streamAllocation;
        ((StreamAllocation)object).eventListener.responseBodyStart(((StreamAllocation)object).call);
        object = response.header("Content-Type");
        long l2 = HttpHeaders.contentLength(response);
        StreamFinishingSource streamFinishingSource2 = streamFinishingSource;
        Http2Codec http2Codec = this;
        streamFinishingSource = http2Codec.new StreamFinishingSource(http2Codec.stream.getSource());
        return new RealResponseBody((String)object, l2, Okio.buffer(streamFinishingSource2));
    }

    @Override
    public void cancel() {
        Http2Stream http2Stream = ((Http2Codec)((Object)http2Stream)).stream;
        if (http2Stream != null) {
            http2Stream.closeLater(ErrorCode.CANCEL);
        }
    }

    class StreamFinishingSource
    extends ForwardingSource {
        boolean completed;
        long bytesRead;

        StreamFinishingSource(Source source) {
            super(source);
            this.completed = false;
            this.bytesRead = 0L;
        }

        private void endOfInput(IOException iOException) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            Http2Codec http2Codec = Http2Codec.this;
            long l2 = this.bytesRead;
            http2Codec.streamAllocation.streamFinished(false, http2Codec, l2, iOException);
        }

        @Override
        public long read(Buffer buffer, long l2) throws IOException {
            long l3;
            block4: {
                try {
                    l3 = this.delegate().read(buffer, l2);
                    if (l3 <= 0L) break block4;
                }
                catch (IOException iOException) {
                    this.endOfInput(iOException);
                    throw iOException;
                }
                StreamFinishingSource streamFinishingSource = this;
                StreamFinishingSource streamFinishingSource2 = streamFinishingSource;
                long l4 = streamFinishingSource.bytesRead;
                streamFinishingSource2.bytesRead = l4 + l3;
            }
            return l3;
        }

        @Override
        public void close() throws IOException {
            StreamFinishingSource streamFinishingSource = this;
            super.close();
            streamFinishingSource.endOfInput(null);
        }
    }
}

