/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http2;

import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.http2.Header;
import dc.squareup.okhttp3.internal.http2.Huffman;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Source;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class Hpack {
    private static final int PREFIX_4_BITS = 15;
    private static final int PREFIX_5_BITS = 31;
    private static final int PREFIX_6_BITS = 63;
    private static final int PREFIX_7_BITS = 127;
    static final Header[] STATIC_HEADER_TABLE;
    static final Map<ByteString, Integer> NAME_TO_FIRST_INDEX;

    private Hpack() {
    }

    private static Map<ByteString, Integer> nameToFirstIndex() {
        LinkedHashMap<Header[], Integer> linkedHashMap;
        LinkedHashMap<Header[], Integer> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<Header[], Integer>(STATIC_HEADER_TABLE.length);
        int n2 = 0;
        while (true) {
            Object object = STATIC_HEADER_TABLE;
            if (n2 >= STATIC_HEADER_TABLE.length) break;
            if (!linkedHashMap2.containsKey(object[n2].name)) {
                object = object[n2].name;
                linkedHashMap2.put((Header[])object, n2);
            }
            ++n2;
        }
        return Collections.unmodifiableMap(linkedHashMap2);
    }

    static ByteString checkLowercase(ByteString byteString) throws IOException {
        int n2 = byteString.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byteString.getByte(i2);
            if (by < 65 || by > 90) continue;
            throw new IOException("PROTOCOL_ERROR response malformed: mixed case name: " + byteString.utf8());
        }
        return byteString;
    }

    static {
        Header header;
        Header header2;
        Header header3;
        Header header4;
        Header header5;
        Header header6;
        Header header7;
        Header header8;
        Header header9;
        Header header10;
        Header header11;
        Header header12;
        Header header13;
        Header header14;
        Header header15;
        Header header16;
        Header header17;
        Header header18;
        Header header19;
        Header header20;
        Header header21;
        Header header22;
        Header header23;
        Header header24;
        Header header25;
        Header header26;
        Header header27;
        Header header28;
        Header header29;
        Header header30;
        Header header31;
        Header header32;
        Header header33;
        Header header34;
        Header header35;
        Header header36;
        Header header37;
        Header header38;
        Header header39;
        Header header40;
        Header header41;
        Header header42;
        Header header43;
        Header header44;
        Header header45;
        Header header46;
        Header header47;
        Header header48;
        Header header49;
        Header header50;
        Header header51;
        Header header52;
        Header header53;
        Header header54;
        Header header55;
        Header header56;
        Header header57;
        Header header58;
        Header header59;
        Header header60;
        Header header61;
        Header[] headerArray = new Header[61];
        Header header62 = header61;
        header61 = new Header(Header.TARGET_AUTHORITY, "");
        headerArray[0] = header62;
        header62 = header60;
        ByteString byteString = Header.TARGET_METHOD;
        header60 = new Header(byteString, "GET");
        headerArray[1] = header62;
        header62 = header59;
        header59 = new Header(byteString, "POST");
        headerArray[2] = header62;
        header62 = header58;
        byteString = Header.TARGET_PATH;
        header58 = new Header(byteString, "/");
        headerArray[3] = header62;
        header62 = header57;
        header57 = new Header(byteString, "/index.html");
        headerArray[4] = header62;
        header62 = header56;
        byteString = Header.TARGET_SCHEME;
        header56 = new Header(byteString, "http");
        headerArray[5] = header62;
        header62 = header55;
        header55 = new Header(byteString, "https");
        headerArray[6] = header62;
        header62 = header54;
        byteString = Header.RESPONSE_STATUS;
        header54 = new Header(byteString, "200");
        headerArray[7] = header62;
        header62 = header53;
        header53 = new Header(byteString, "204");
        headerArray[8] = header62;
        header62 = header52;
        header52 = new Header(byteString, "206");
        headerArray[9] = header62;
        header62 = header51;
        header51 = new Header(byteString, "304");
        headerArray[10] = header62;
        header62 = header50;
        header50 = new Header(byteString, "400");
        headerArray[11] = header62;
        header62 = header49;
        header49 = new Header(byteString, "404");
        headerArray[12] = header62;
        header62 = header48;
        header48 = new Header(byteString, "500");
        headerArray[13] = header62;
        header62 = header47;
        header47 = new Header("accept-charset", "");
        headerArray[14] = header62;
        header62 = header46;
        header46 = new Header("accept-encoding", "gzip, deflate");
        headerArray[15] = header62;
        header62 = header45;
        header45 = new Header("accept-language", "");
        headerArray[16] = header62;
        header62 = header44;
        header44 = new Header("accept-ranges", "");
        headerArray[17] = header62;
        header62 = header43;
        header43 = new Header("accept", "");
        headerArray[18] = header62;
        header62 = header42;
        header42 = new Header("access-control-allow-origin", "");
        headerArray[19] = header62;
        header62 = header41;
        header41 = new Header("age", "");
        headerArray[20] = header62;
        header62 = header40;
        header40 = new Header("allow", "");
        headerArray[21] = header62;
        header62 = header39;
        header39 = new Header("authorization", "");
        headerArray[22] = header62;
        header62 = header38;
        header38 = new Header("cache-control", "");
        headerArray[23] = header62;
        header62 = header37;
        header37 = new Header("content-disposition", "");
        headerArray[24] = header62;
        header62 = header36;
        header36 = new Header("content-encoding", "");
        headerArray[25] = header62;
        header62 = header35;
        header35 = new Header("content-language", "");
        headerArray[26] = header62;
        header62 = header34;
        header34 = new Header("content-length", "");
        headerArray[27] = header62;
        header62 = header33;
        header33 = new Header("content-location", "");
        headerArray[28] = header62;
        header62 = header32;
        header32 = new Header("content-range", "");
        headerArray[29] = header62;
        header62 = header31;
        header31 = new Header("content-type", "");
        headerArray[30] = header62;
        header62 = header30;
        header30 = new Header("cookie", "");
        headerArray[31] = header62;
        header62 = header29;
        header29 = new Header("date", "");
        headerArray[32] = header62;
        header62 = header28;
        header28 = new Header("etag", "");
        headerArray[33] = header62;
        header62 = header27;
        header27 = new Header("expect", "");
        headerArray[34] = header62;
        header62 = header26;
        header26 = new Header("expires", "");
        headerArray[35] = header62;
        header62 = header25;
        header25 = new Header("from", "");
        headerArray[36] = header62;
        header62 = header24;
        header24 = new Header("host", "");
        headerArray[37] = header62;
        header62 = header23;
        header23 = new Header("if-match", "");
        headerArray[38] = header62;
        header62 = header22;
        header22 = new Header("if-modified-since", "");
        headerArray[39] = header62;
        header62 = header21;
        header21 = new Header("if-none-match", "");
        headerArray[40] = header62;
        header62 = header20;
        header20 = new Header("if-range", "");
        headerArray[41] = header62;
        header62 = header19;
        header19 = new Header("if-unmodified-since", "");
        headerArray[42] = header62;
        header62 = header18;
        header18 = new Header("last-modified", "");
        headerArray[43] = header62;
        header62 = header17;
        header17 = new Header("link", "");
        headerArray[44] = header62;
        header62 = header16;
        header16 = new Header("location", "");
        headerArray[45] = header62;
        header62 = header15;
        header15 = new Header("max-forwards", "");
        headerArray[46] = header62;
        header62 = header14;
        header14 = new Header("proxy-authenticate", "");
        headerArray[47] = header62;
        header62 = header13;
        header13 = new Header("proxy-authorization", "");
        headerArray[48] = header62;
        header62 = header12;
        header12 = new Header("range", "");
        headerArray[49] = header62;
        header62 = header11;
        header11 = new Header("referer", "");
        headerArray[50] = header62;
        header62 = header10;
        header10 = new Header("refresh", "");
        headerArray[51] = header62;
        header62 = header9;
        header9 = new Header("retry-after", "");
        headerArray[52] = header62;
        header62 = header8;
        header8 = new Header("server", "");
        headerArray[53] = header62;
        header62 = header7;
        header7 = new Header("set-cookie", "");
        headerArray[54] = header62;
        header62 = header6;
        header6 = new Header("strict-transport-security", "");
        headerArray[55] = header62;
        header62 = header5;
        header5 = new Header("transfer-encoding", "");
        headerArray[56] = header62;
        header62 = header4;
        header4 = new Header("user-agent", "");
        headerArray[57] = header62;
        header62 = header3;
        header3 = new Header("vary", "");
        headerArray[58] = header62;
        header62 = header2;
        header2 = new Header("via", "");
        headerArray[59] = header62;
        header62 = header;
        header = new Header("www-authenticate", "");
        headerArray[60] = header62;
        STATIC_HEADER_TABLE = headerArray;
        NAME_TO_FIRST_INDEX = Hpack.nameToFirstIndex();
    }

    static final class Writer {
        private static final int SETTINGS_HEADER_TABLE_SIZE = 4096;
        private static final int SETTINGS_HEADER_TABLE_SIZE_LIMIT = 16384;
        private final Buffer out;
        private final boolean useCompression;
        private int smallestHeaderTableSizeSetting;
        private boolean emitDynamicTableSizeUpdate;
        int headerTableSizeSetting;
        int maxDynamicTableByteCount;
        Header[] dynamicTable;
        int nextHeaderIndex;
        int headerCount;
        int dynamicTableByteCount;

        Writer(Buffer buffer) {
            this(4096, true, buffer);
        }

        Writer(int n2, boolean bl, Buffer buffer) {
            Header[] headerArray = headerArray6;
            Header[] headerArray2 = headerArray6;
            Header[] headerArray3 = headerArray6;
            Header[] headerArray4 = headerArray6;
            Header[] headerArray5 = headerArray6;
            headerArray5.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
            Header[] headerArray6 = new Header[8];
            v5.dynamicTable = headerArray6;
            headerArray5.nextHeaderIndex = headerArray6.length - 1;
            v5.headerCount = 0;
            headerArray5.dynamicTableByteCount = 0;
            headerArray4.headerTableSizeSetting = n2;
            headerArray3.maxDynamicTableByteCount = n2;
            headerArray2.useCompression = bl;
            headerArray.out = buffer;
        }

        private void clearDynamicTable() {
            Writer writer = this;
            Arrays.fill(writer.dynamicTable, null);
            writer.nextHeaderIndex = writer.dynamicTable.length - 1;
            writer.headerCount = 0;
            writer.dynamicTableByteCount = 0;
        }

        private int evictToRecoverBytes(int n2) {
            int n3 = 0;
            if (n2 > 0) {
                int n4;
                int n5;
                for (n5 = this.dynamicTable.length - 1; n5 >= (n4 = this.nextHeaderIndex) && n2 > 0; --n5) {
                    Writer writer = this;
                    Header[] headerArray = this.dynamicTable;
                    n4 = n2 - this.dynamicTable[n5].hpackSize;
                    writer.dynamicTableByteCount -= headerArray[n5].hpackSize;
                    --writer.headerCount;
                    ++n3;
                    n2 = n4;
                }
                Writer writer = this;
                int n6 = n4;
                n2 = n6 + 1;
                n5 = n6 + 1 + n3;
                n4 = this.headerCount;
                System.arraycopy(writer.dynamicTable, n2, writer.dynamicTable, n5, n4);
                int n7 = this.nextHeaderIndex;
                int n8 = n7 + 1;
                Arrays.fill(writer.dynamicTable, n8, n7 + 1 + n3, null);
                writer.nextHeaderIndex += n3;
            }
            return n3;
        }

        private void insertIntoDynamicTable(Header header) {
            int n2 = header.hpackSize;
            int n3 = this.maxDynamicTableByteCount;
            if (n2 > n3) {
                this.clearDynamicTable();
                return;
            }
            Writer writer = this;
            writer.evictToRecoverBytes(writer.dynamicTableByteCount + n2 - n3);
            Header[] headerArray = this.dynamicTable;
            if (writer.headerCount + 1 > this.dynamicTable.length) {
                Header[] headerArray2 = headerArray;
                headerArray = new Header[headerArray.length * 2];
                int n4 = headerArray2.length;
                int n5 = headerArray.length;
                System.arraycopy(headerArray2, 0, headerArray, n4, n5);
                this.nextHeaderIndex = this.dynamicTable.length - 1;
                this.dynamicTable = headerArray;
            }
            Writer writer2 = this;
            int n6 = writer2.nextHeaderIndex;
            writer2.nextHeaderIndex = n6 - 1;
            writer2.dynamicTable[n6] = header;
            ++writer2.headerCount;
            writer2.dynamicTableByteCount += n2;
        }

        private void adjustDynamicTableByteCount() {
            int n2 = this.maxDynamicTableByteCount;
            int n3 = this.dynamicTableByteCount;
            if (n2 < n3) {
                if (n2 == 0) {
                    this.clearDynamicTable();
                } else {
                    this.evictToRecoverBytes(n3 - n2);
                }
            }
        }

        void writeHeaders(List<Header> list) throws IOException {
            int n2;
            if (this.emitDynamicTableSizeUpdate) {
                n2 = this.smallestHeaderTableSizeSetting;
                if (n2 < this.maxDynamicTableByteCount) {
                    this.writeInt(n2, 31, 32);
                }
                Writer writer = this;
                writer.emitDynamicTableSizeUpdate = false;
                writer.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
                writer.writeInt(writer.maxDynamicTableByteCount, 31, 32);
            }
            int n3 = list.size();
            for (n2 = 0; n2 < n3; ++n2) {
                Header header = list.get(n2);
                ByteString byteString = header.name.toAsciiLowercase();
                ByteString byteString2 = header.value;
                int n4 = -1;
                int n5 = -1;
                Header[] headerArray = NAME_TO_FIRST_INDEX.get(byteString);
                if (headerArray != null && (n5 = headerArray.intValue() + 1) > 1 && n5 < 8) {
                    headerArray = STATIC_HEADER_TABLE;
                    if (Util.equal(STATIC_HEADER_TABLE[n5 - 1].value, byteString2)) {
                        n4 = n5;
                    } else if (Util.equal(headerArray[n5].value, byteString2)) {
                        n4 = n5 + 1;
                    }
                }
                if (n4 == -1) {
                    int n6 = this.dynamicTable.length;
                    for (int i2 = (v298336).nextHeaderIndex + 1; i2 < n6; ++i2) {
                        if (!Util.equal(this.dynamicTable[i2].name, byteString)) continue;
                        if (Util.equal(this.dynamicTable[i2].value, byteString2)) {
                            n4 = i2 - this.nextHeaderIndex + STATIC_HEADER_TABLE.length;
                            break;
                        }
                        if (n5 != -1) continue;
                        n5 = i2 - this.nextHeaderIndex + STATIC_HEADER_TABLE.length;
                    }
                }
                if (n4 != -1) {
                    this.writeInt(n4, 127, 128);
                    continue;
                }
                if (n5 == -1) {
                    this.out.writeByte(64);
                    this.writeByteString(byteString);
                    this.writeByteString(byteString2);
                    this.insertIntoDynamicTable(header);
                    continue;
                }
                if (byteString.startsWith(Header.PSEUDO_PREFIX) && !Header.TARGET_AUTHORITY.equals(byteString)) {
                    Writer writer = this;
                    writer.writeInt(n5, 15, 0);
                    writer.writeByteString(byteString2);
                    continue;
                }
                Writer writer = this;
                writer.writeInt(n5, 63, 64);
                writer.writeByteString(byteString2);
                writer.insertIntoDynamicTable(header);
            }
        }

        void writeInt(int n2, int n3, int n4) {
            if (n2 < n3) {
                this.out.writeByte(n4 | n2);
                return;
            }
            this.out.writeByte(n4 | n3);
            n2 -= n3;
            while (n2 >= 128) {
                int n5 = n2;
                this.out.writeByte((n2 &= 0x7F) | 0x80);
                n2 = n5 >>> 7;
            }
            this.out.writeByte(n2);
        }

        void writeByteString(ByteString byteString) throws IOException {
            if (((Writer)object).useCompression && Huffman.get().encodedLength(byteString) < byteString.size()) {
                Buffer buffer;
                Writer writer = object;
                Object object = buffer;
                buffer = new Buffer();
                Huffman.get().encode(byteString, (BufferedSink)object);
                object = buffer.readByteString();
                writer.writeInt(((ByteString)object).size(), 127, 128);
                writer.out.write((ByteString)object);
            } else {
                Writer writer = object;
                writer.writeInt(byteString.size(), 127, 0);
                writer.out.write(byteString);
            }
        }

        void setHeaderTableSizeSetting(int n2) {
            this.headerTableSizeSetting = n2;
            int n3 = this.maxDynamicTableByteCount;
            if (n3 == (n2 = Math.min(n2, 16384))) {
                return;
            }
            if (n2 < n3) {
                this.smallestHeaderTableSizeSetting = Math.min(this.smallestHeaderTableSizeSetting, n2);
            }
            this.emitDynamicTableSizeUpdate = true;
            this.maxDynamicTableByteCount = n2;
            this.adjustDynamicTableByteCount();
        }
    }

    static final class Reader {
        private final List<Header> headerList;
        private final BufferedSource source;
        private final int headerTableSizeSetting;
        private int maxDynamicTableByteCount;
        Header[] dynamicTable;
        int nextHeaderIndex;
        int headerCount;
        int dynamicTableByteCount;

        Reader(int n2, Source source) {
            int n3 = n2;
            this(n3, n3, source);
        }

        Reader(int n2, int n3, Source source) {
            Header[] headerArray = headerArray5;
            Header[] headerArray2 = headerArray5;
            Header[] headerArray3 = headerArray5;
            Header[] headerArray4 = headerArray5;
            headerArray4.headerList = new ArrayList<Header>();
            Header[] headerArray5 = new Header[8];
            v4.dynamicTable = headerArray5;
            headerArray4.nextHeaderIndex = headerArray5.length - 1;
            v4.headerCount = 0;
            headerArray4.dynamicTableByteCount = 0;
            headerArray3.headerTableSizeSetting = n2;
            headerArray2.maxDynamicTableByteCount = n3;
            headerArray.source = Okio.buffer(source);
        }

        private void adjustDynamicTableByteCount() {
            int n2 = this.maxDynamicTableByteCount;
            int n3 = this.dynamicTableByteCount;
            if (n2 < n3) {
                if (n2 == 0) {
                    this.clearDynamicTable();
                } else {
                    this.evictToRecoverBytes(n3 - n2);
                }
            }
        }

        private void clearDynamicTable() {
            Reader reader = this;
            Arrays.fill(reader.dynamicTable, null);
            reader.nextHeaderIndex = reader.dynamicTable.length - 1;
            reader.headerCount = 0;
            reader.dynamicTableByteCount = 0;
        }

        private int evictToRecoverBytes(int n2) {
            int n3 = 0;
            if (n2 > 0) {
                int n4;
                int n5;
                for (n5 = this.dynamicTable.length - 1; n5 >= (n4 = this.nextHeaderIndex) && n2 > 0; --n5) {
                    Reader reader = this;
                    Header[] headerArray = this.dynamicTable;
                    n4 = n2 - this.dynamicTable[n5].hpackSize;
                    reader.dynamicTableByteCount -= headerArray[n5].hpackSize;
                    --reader.headerCount;
                    ++n3;
                    n2 = n4;
                }
                Reader reader = this;
                int n6 = n4;
                int n7 = n6 + 1;
                n2 = n6 + 1 + n3;
                n5 = this.headerCount;
                System.arraycopy(reader.dynamicTable, n7, reader.dynamicTable, n2, n5);
                reader.nextHeaderIndex += n3;
            }
            return n3;
        }

        private void readIndexedHeader(int n2) throws IOException {
            block4: {
                block3: {
                    block2: {
                        if (!((Reader)((Object)header)).isStaticHeader(n2)) break block2;
                        Reader reader = header;
                        Header header = STATIC_HEADER_TABLE[n2];
                        reader.headerList.add(header);
                        break block3;
                    }
                    int n3 = ((Reader)((Object)header)).dynamicTableIndex(n2 - STATIC_HEADER_TABLE.length);
                    if (n3 < 0) break block4;
                    Header[] headerArray = ((Reader)((Object)header)).dynamicTable;
                    if (n3 >= ((Reader)((Object)header)).dynamicTable.length) break block4;
                    ((Reader)((Object)header)).headerList.add(headerArray[n3]);
                }
                return;
            }
            throw new IOException("Header index too large " + (n2 + 1));
        }

        private int dynamicTableIndex(int n2) {
            return this.nextHeaderIndex + 1 + n2;
        }

        private void readLiteralHeaderWithoutIndexingIndexedName(int n2) throws IOException {
            Reader reader = byteString;
            ByteString byteString = reader.getName(n2);
            ByteString byteString2 = reader.readByteString();
            reader.headerList.add(new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithoutIndexingNewName() throws IOException {
            Reader reader = byteString;
            ByteString byteString = Hpack.checkLowercase(reader.readByteString());
            ByteString byteString2 = reader.readByteString();
            reader.headerList.add(new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithIncrementalIndexingIndexedName(int n2) throws IOException {
            Header header;
            Reader reader = byteString;
            ByteString byteString = reader.getName(n2);
            ByteString byteString2 = reader.readByteString();
            Header header2 = header;
            header = new Header(byteString, byteString2);
            reader.insertIntoDynamicTable(-1, header2);
        }

        private void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
            Header header;
            Reader reader = byteString;
            ByteString byteString = Hpack.checkLowercase(reader.readByteString());
            ByteString byteString2 = reader.readByteString();
            Header header2 = header;
            header = new Header(byteString, byteString2);
            reader.insertIntoDynamicTable(-1, header2);
        }

        private ByteString getName(int n2) throws IOException {
            if (headerArray.isStaticHeader(n2)) {
                return Hpack.STATIC_HEADER_TABLE[n2].name;
            }
            int n3 = headerArray.dynamicTableIndex(n2 - STATIC_HEADER_TABLE.length);
            if (n3 >= 0) {
                Header[] headerArray = headerArray.dynamicTable;
                if (n3 < headerArray.dynamicTable.length) {
                    return headerArray[n3].name;
                }
            }
            throw new IOException("Header index too large " + (n2 + 1));
        }

        private boolean isStaticHeader(int n2) {
            return n2 >= 0 && n2 <= STATIC_HEADER_TABLE.length - 1;
        }

        private void insertIntoDynamicTable(int n2, Header header) {
            int n3;
            this.headerList.add(header);
            int n4 = header.hpackSize;
            if (n2 != -1) {
                n4 -= this.dynamicTable[this.dynamicTableIndex((int)n2)].hpackSize;
            }
            if (n4 > (n3 = this.maxDynamicTableByteCount)) {
                this.clearDynamicTable();
                return;
            }
            Reader reader = this;
            n3 = reader.evictToRecoverBytes(reader.dynamicTableByteCount + n4 - n3);
            if (n2 == -1) {
                Header[] headerArray = this.dynamicTable;
                if (this.headerCount + 1 > this.dynamicTable.length) {
                    Header[] headerArray2 = headerArray;
                    headerArray = new Header[headerArray.length * 2];
                    n3 = headerArray2.length;
                    int n5 = headerArray.length;
                    System.arraycopy(headerArray2, 0, headerArray, n3, n5);
                    this.nextHeaderIndex = this.dynamicTable.length - 1;
                    this.dynamicTable = headerArray;
                }
                Reader reader2 = this;
                int n6 = reader2.nextHeaderIndex;
                reader2.nextHeaderIndex = n6 - 1;
                reader2.dynamicTable[n6] = header;
                ++reader2.headerCount;
            } else {
                n2 += this.dynamicTableIndex(n2) + n3;
                this.dynamicTable[n2] = header;
            }
            this.dynamicTableByteCount += n4;
        }

        private int readByte() throws IOException {
            return this.source.readByte() & 0xFF;
        }

        int maxDynamicTableByteCount() {
            return this.maxDynamicTableByteCount;
        }

        void readHeaders() throws IOException {
            while (!this.source.exhausted()) {
                int n2 = this.source.readByte() & 0xFF;
                if (n2 != 128) {
                    if ((n2 & 0x80) == 128) {
                        Reader reader = this;
                        reader.readIndexedHeader(reader.readInt(n2, 127) - 1);
                        continue;
                    }
                    if (n2 == 64) {
                        this.readLiteralHeaderWithIncrementalIndexingNewName();
                        continue;
                    }
                    if ((n2 & 0x40) == 64) {
                        Reader reader = this;
                        reader.readLiteralHeaderWithIncrementalIndexingIndexedName(reader.readInt(n2, 63) - 1);
                        continue;
                    }
                    if ((n2 & 0x20) == 32) {
                        this.maxDynamicTableByteCount = n2 = this.readInt(n2, 31);
                        if (n2 >= 0 && n2 <= this.headerTableSizeSetting) {
                            this.adjustDynamicTableByteCount();
                            continue;
                        }
                        throw new IOException("Invalid dynamic table size update " + this.maxDynamicTableByteCount);
                    }
                    if (n2 != 16 && n2 != 0) {
                        Reader reader = this;
                        reader.readLiteralHeaderWithoutIndexingIndexedName(reader.readInt(n2, 15) - 1);
                        continue;
                    }
                    this.readLiteralHeaderWithoutIndexingNewName();
                    continue;
                }
                throw new IOException("index == 0");
            }
        }

        public List<Header> getAndResetHeaderList() {
            ArrayList<Header> arrayList = new ArrayList<Header>(this.headerList);
            this.headerList.clear();
            return arrayList;
        }

        int readInt(int n2, int n3) throws IOException {
            int n4;
            if ((n2 &= n3) < n3) {
                return n2;
            }
            n2 = 0;
            while (((n4 = this.readByte()) & 0x80) != 0) {
                n3 += (n4 & 0x7F) << n2;
                n2 += 7;
            }
            return n3 + (n4 << n2);
        }

        ByteString readByteString() throws IOException {
            int n2 = this.readByte();
            boolean bl = (n2 & 0x80) == 128;
            n2 = this.readInt(n2, 127);
            if (bl) {
                return ByteString.of(Huffman.get().decode(this.source.readByteArray(n2)));
            }
            return this.source.readByteString(n2);
        }
    }
}

