/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http1;

import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.OkHttpClient;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.ResponseBody;
import dc.squareup.okhttp3.internal.Internal;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.connection.RealConnection;
import dc.squareup.okhttp3.internal.connection.StreamAllocation;
import dc.squareup.okhttp3.internal.http.HttpCodec;
import dc.squareup.okhttp3.internal.http.HttpHeaders;
import dc.squareup.okhttp3.internal.http.RealResponseBody;
import dc.squareup.okhttp3.internal.http.RequestLine;
import dc.squareup.okhttp3.internal.http.StatusLine;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ForwardingTimeout;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;

public final class Http1Codec
implements HttpCodec {
    private static final int STATE_IDLE = 0;
    private static final int STATE_OPEN_REQUEST_BODY = 1;
    private static final int STATE_WRITING_REQUEST_BODY = 2;
    private static final int STATE_READ_RESPONSE_HEADERS = 3;
    private static final int STATE_OPEN_RESPONSE_BODY = 4;
    private static final int STATE_READING_RESPONSE_BODY = 5;
    private static final int STATE_CLOSED = 6;
    private static final int HEADER_LIMIT = 262144;
    final OkHttpClient client;
    final StreamAllocation streamAllocation;
    final BufferedSource source;
    final BufferedSink sink;
    int state = 0;
    private long headerLimit = 262144L;

    public Http1Codec(OkHttpClient okHttpClient, StreamAllocation streamAllocation, BufferedSource bufferedSource, BufferedSink bufferedSink) {
        this.client = okHttpClient;
        this.streamAllocation = streamAllocation;
        this.source = bufferedSource;
        this.sink = bufferedSink;
    }

    private String readHeaderLine() throws IOException {
        String string2 = this.source.readUtf8LineStrict(this.headerLimit);
        this.headerLimit -= (long)string2.length();
        return string2;
    }

    @Override
    public Sink createRequestBody(Request request, long l2) {
        if ("chunked".equalsIgnoreCase(request.header("Transfer-Encoding"))) {
            return this.newChunkedSink();
        }
        if (l2 != -1L) {
            return this.newFixedLengthSink(l2);
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    @Override
    public void cancel() {
        RealConnection realConnection = ((Http1Codec)((Object)realConnection)).streamAllocation.connection();
        if (realConnection != null) {
            realConnection.cancel();
        }
    }

    @Override
    public void writeRequestHeaders(Request request) throws IOException {
        Http1Codec http1Codec = string2;
        Request request2 = request;
        String string2 = RequestLine.get(request2, ((Http1Codec)((Object)string2)).streamAllocation.connection().route().proxy().type());
        http1Codec.writeRequest(request2.headers(), string2);
    }

    @Override
    public ResponseBody openResponseBody(Response response) throws IOException {
        Object object;
        Response response2 = response;
        Object object2 = ((Http1Codec)object).streamAllocation;
        ((StreamAllocation)object2).eventListener.responseBodyStart(((StreamAllocation)object2).call);
        object2 = response2.header("Content-Type");
        if (!HttpHeaders.hasBody(response2)) {
            object = ((Http1Codec)object).newFixedLengthSource(0L);
            object = Okio.buffer((Source)object);
            return new RealResponseBody((String)object2, 0L, (BufferedSource)object);
        }
        if ("chunked".equalsIgnoreCase(response.header("Transfer-Encoding"))) {
            object = ((Http1Codec)object).newChunkedSource(response.request().url());
            object = Okio.buffer((Source)object);
            return new RealResponseBody((String)object2, -1L, (BufferedSource)object);
        }
        long l2 = HttpHeaders.contentLength(response);
        if (l2 != -1L) {
            object = ((Http1Codec)object).newFixedLengthSource(l2);
            object = Okio.buffer((Source)object);
            return new RealResponseBody((String)object2, l2, (BufferedSource)object);
        }
        object = Okio.buffer(((Http1Codec)object).newUnknownLengthSource());
        return new RealResponseBody((String)object2, -1L, (BufferedSource)object);
    }

    public boolean isClosed() {
        return this.state == 6;
    }

    @Override
    public void flushRequest() throws IOException {
        this.sink.flush();
    }

    @Override
    public void finishRequest() throws IOException {
        this.sink.flush();
    }

    public void writeRequest(Headers headers, String string2) throws IOException {
        if (this.state == 0) {
            this.sink.writeUtf8(string2).writeUtf8("\r\n");
            int n2 = headers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.sink.writeUtf8(headers.name(i2)).writeUtf8(": ").writeUtf8(headers.value(i2)).writeUtf8("\r\n");
            }
            this.sink.writeUtf8("\r\n");
            this.state = 1;
            return;
        }
        throw new IllegalStateException("state: " + this.state);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response.Builder readResponseHeaders(boolean bl) throws IOException {
        StatusLine statusLine;
        boolean bl2;
        int n2 = this.state;
        if (n2 != 1 && n2 != 3) {
            throw new IllegalStateException("state: " + this.state);
        }
        try {
            bl2 = bl;
            statusLine = StatusLine.parse(this.readHeaderLine());
        }
        catch (EOFException eOFException) {
            IOException iOException = new IOException("unexpected end of stream on " + this.streamAllocation);
            iOException.initCause(eOFException);
            throw iOException;
        }
        {
            Response.Builder builder = new Response.Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.readHeaders());
            if (bl2 && statusLine.code == 100) {
                return null;
            }
            if (statusLine.code == 100) {
                this.state = 3;
                return builder;
            }
            this.state = 4;
            return builder;
        }
    }

    public Headers readHeaders() throws IOException {
        String string2;
        Headers.Builder builder;
        Headers.Builder builder2 = builder;
        builder = new Headers.Builder();
        while ((string2 = this.readHeaderLine()).length() != 0) {
            Internal.instance.addLenient(builder2, string2);
        }
        return builder2.build();
    }

    public Sink newChunkedSink() {
        if (this.state == 1) {
            this.state = 2;
            return new ChunkedSink();
        }
        throw new IllegalStateException("state: " + this.state);
    }

    public Sink newFixedLengthSink(long l2) {
        if (this.state == 1) {
            this.state = 2;
            return new FixedLengthSink(l2);
        }
        throw new IllegalStateException("state: " + this.state);
    }

    public Source newFixedLengthSource(long l2) throws IOException {
        if (this.state == 4) {
            this.state = 5;
            return new FixedLengthSource(l2);
        }
        throw new IllegalStateException("state: " + this.state);
    }

    public Source newChunkedSource(HttpUrl httpUrl) throws IOException {
        if (this.state == 4) {
            this.state = 5;
            return new ChunkedSource(httpUrl);
        }
        throw new IllegalStateException("state: " + this.state);
    }

    public Source newUnknownLengthSource() throws IOException {
        if (this.state == 4) {
            StreamAllocation streamAllocation = this.streamAllocation;
            if (streamAllocation != null) {
                this.state = 5;
                streamAllocation.noNewStreams();
                return new UnknownLengthSource();
            }
            throw new IllegalStateException("streamAllocation == null");
        }
        throw new IllegalStateException("state: " + this.state);
    }

    void detachTimeout(ForwardingTimeout forwardingTimeout) {
        Timeout timeout = forwardingTimeout.delegate();
        forwardingTimeout.setDelegate(Timeout.NONE);
        timeout.clearDeadline();
        timeout.clearTimeout();
    }

    private class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;

        UnknownLengthSource() {
        }

        @Override
        public long read(Buffer buffer, long l2) throws IOException {
            if (l2 >= 0L) {
                if (!this.closed) {
                    if (this.inputExhausted) {
                        return -1L;
                    }
                    long l3 = super.read(buffer, l2);
                    if (l3 == -1L) {
                        this.inputExhausted = true;
                        this.endOfInput(true, null);
                        return -1L;
                    }
                    return l3;
                }
                throw new IllegalStateException("closed");
            }
            throw new IllegalArgumentException("byteCount < 0: " + l2);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (!this.inputExhausted) {
                this.endOfInput(false, null);
            }
            this.closed = true;
        }
    }

    private class ChunkedSource
    extends AbstractSource {
        private static final long NO_CHUNK_YET = -1L;
        private final HttpUrl url;
        private long bytesRemainingInChunk;
        private boolean hasMoreChunks;

        ChunkedSource(HttpUrl httpUrl) {
            this.bytesRemainingInChunk = -1L;
            this.hasMoreChunks = true;
            this.url = httpUrl;
        }

        private void readChunkSize() throws IOException {
            String string2;
            block8: {
                block9: {
                    ChunkedSource chunkedSource;
                    if (this.bytesRemainingInChunk != -1L) {
                        Http1Codec.this.source.readUtf8LineStrict();
                    }
                    try {
                        ChunkedSource chunkedSource2 = this;
                        chunkedSource = chunkedSource2;
                        chunkedSource2.bytesRemainingInChunk = chunkedSource2.Http1Codec.this.source.readHexadecimalUnsignedLong();
                        string2 = chunkedSource2.Http1Codec.this.source.readUtf8LineStrict().trim();
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ProtocolException(numberFormatException.getMessage());
                    }
                    if (chunkedSource.bytesRemainingInChunk < 0L) break block8;
                    if (string2.isEmpty()) break block9;
                    if (!string2.startsWith(";")) break block8;
                }
                if (this.bytesRemainingInChunk == 0L) {
                    ChunkedSource chunkedSource = this;
                    chunkedSource.hasMoreChunks = false;
                    HttpHeaders.receiveHeaders(chunkedSource.Http1Codec.this.client.cookieJar(), this.url, Http1Codec.this.readHeaders());
                    chunkedSource.endOfInput(true, null);
                }
                return;
            }
            throw new ProtocolException("expected chunk size and optional extensions but was \"" + this.bytesRemainingInChunk + string2 + "\"");
        }

        @Override
        public long read(Buffer buffer, long l2) throws IOException {
            if (l2 >= 0L) {
                if (!this.closed) {
                    ProtocolException protocolException;
                    long l3;
                    if (!this.hasMoreChunks) {
                        return -1L;
                    }
                    long l4 = this.bytesRemainingInChunk;
                    if (l4 == 0L || l4 == -1L) {
                        ChunkedSource chunkedSource = this;
                        chunkedSource.readChunkSize();
                        if (!chunkedSource.hasMoreChunks) {
                            return -1L;
                        }
                    }
                    if ((l3 = super.read(buffer, Math.min(l2, this.bytesRemainingInChunk))) != -1L) {
                        this.bytesRemainingInChunk -= l3;
                        return l3;
                    }
                    ProtocolException protocolException2 = protocolException;
                    protocolException2("unexpected end of stream");
                    this.endOfInput(false, protocolException2);
                    throw protocolException;
                }
                throw new IllegalStateException("closed");
            }
            throw new IllegalArgumentException("byteCount < 0: " + l2);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.endOfInput(false, null);
            }
            this.closed = true;
        }
    }

    private class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;

        FixedLengthSource(long l2) throws IOException {
            this.bytesRemaining = l2;
            if (l2 == 0L) {
                this.endOfInput(true, null);
            }
        }

        @Override
        public long read(Buffer buffer, long l2) throws IOException {
            if (l2 >= 0L) {
                if (!this.closed) {
                    ProtocolException protocolException;
                    long l3 = this.bytesRemaining;
                    if (l3 == 0L) {
                        return -1L;
                    }
                    long l4 = super.read(buffer, Math.min(l3, l2));
                    if (l4 != -1L) {
                        this.bytesRemaining = l3 = this.bytesRemaining - l4;
                        if (l3 == 0L) {
                            this.endOfInput(true, null);
                        }
                        return l4;
                    }
                    ProtocolException protocolException2 = protocolException;
                    protocolException2("unexpected end of stream");
                    this.endOfInput(false, protocolException2);
                    throw protocolException;
                }
                throw new IllegalStateException("closed");
            }
            throw new IllegalArgumentException("byteCount < 0: " + l2);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.bytesRemaining != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.endOfInput(false, null);
            }
            this.closed = true;
        }
    }

    private abstract class AbstractSource
    implements Source {
        protected final ForwardingTimeout timeout;
        protected boolean closed;
        protected long bytesRead;

        private AbstractSource() {
            this.timeout = new ForwardingTimeout(Http1Codec.this.source.timeout());
            this.bytesRead = 0L;
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public long read(Buffer buffer, long l2) throws IOException {
            long l3;
            block4: {
                try {
                    l3 = Http1Codec.this.source.read(buffer, l2);
                    if (l3 <= 0L) break block4;
                }
                catch (IOException iOException) {
                    this.endOfInput(false, iOException);
                    throw iOException;
                }
                AbstractSource abstractSource = this;
                AbstractSource abstractSource2 = abstractSource;
                long l4 = abstractSource.bytesRead;
                abstractSource2.bytesRead = l4 + l3;
            }
            return l3;
        }

        protected final void endOfInput(boolean bl, IOException iOException) throws IOException {
            Http1Codec http1Codec = Http1Codec.this;
            int n2 = http1Codec.state;
            if (n2 == 6) {
                return;
            }
            if (n2 == 5) {
                http1Codec.detachTimeout(this.timeout);
                http1Codec = Http1Codec.this;
                http1Codec.state = 6;
                StreamAllocation streamAllocation = http1Codec.streamAllocation;
                if (streamAllocation != null) {
                    boolean bl2 = bl ^ true;
                    long l2 = this.bytesRead;
                    streamAllocation.streamFinished(bl2, http1Codec, l2, iOException);
                }
                return;
            }
            throw new IllegalStateException("state: " + Http1Codec.this.state);
        }
    }

    private final class ChunkedSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;

        ChunkedSink() {
            this.timeout = new ForwardingTimeout(Http1Codec.this.sink.timeout());
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(Buffer buffer, long l2) throws IOException {
            if (!this.closed) {
                if (l2 == 0L) {
                    return;
                }
                ChunkedSink chunkedSink = this;
                chunkedSink.Http1Codec.this.sink.writeHexadecimalUnsignedLong(l2);
                chunkedSink.Http1Codec.this.sink.writeUtf8("\r\n");
                chunkedSink.Http1Codec.this.sink.write(buffer, l2);
                chunkedSink.Http1Codec.this.sink.writeUtf8("\r\n");
                return;
            }
            throw new IllegalStateException("closed");
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.closed) {
                return;
            }
            Http1Codec.this.sink.flush();
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            ChunkedSink chunkedSink = this;
            chunkedSink.closed = true;
            chunkedSink.Http1Codec.this.sink.writeUtf8("0\r\n\r\n");
            chunkedSink.Http1Codec.this.detachTimeout(this.timeout);
            chunkedSink.Http1Codec.this.state = 3;
        }
    }

    private final class FixedLengthSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;
        private long bytesRemaining;

        FixedLengthSink(long l2) {
            this.timeout = new ForwardingTimeout(Http1Codec.this.sink.timeout());
            this.bytesRemaining = l2;
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(Buffer buffer, long l2) throws IOException {
            if (!this.closed) {
                Util.checkOffsetAndCount(buffer.size(), 0L, l2);
                if (l2 <= this.bytesRemaining) {
                    FixedLengthSink fixedLengthSink = this;
                    fixedLengthSink.Http1Codec.this.sink.write(buffer, l2);
                    fixedLengthSink.bytesRemaining -= l2;
                    return;
                }
                throw new ProtocolException("expected " + this.bytesRemaining + " bytes but received " + l2);
            }
            throw new IllegalStateException("closed");
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                return;
            }
            Http1Codec.this.sink.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.bytesRemaining <= 0L) {
                Http1Codec.this.detachTimeout(this.timeout);
                Http1Codec.this.state = 3;
                return;
            }
            throw new ProtocolException("unexpected end of stream");
        }
    }
}

