/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http;

import dc.squareup.okhttp3.Address;
import dc.squareup.okhttp3.Authenticator;
import dc.squareup.okhttp3.CertificatePinner;
import dc.squareup.okhttp3.ConnectionSpec;
import dc.squareup.okhttp3.Dns;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.Interceptor;
import dc.squareup.okhttp3.OkHttpClient;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.RequestBody;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.Route;
import dc.squareup.okhttp3.internal.connection.StreamAllocation;
import dc.squareup.okhttp3.internal.http.HttpMethod;
import dc.squareup.okhttp3.internal.http.UnrepeatableRequestBody;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public final class RetryAndFollowUpInterceptor
implements Interceptor {
    private static final int MAX_FOLLOW_UPS = 20;
    private final OkHttpClient client;
    private final boolean forWebSocket;
    private volatile StreamAllocation streamAllocation;
    private Object callStackTrace;
    private volatile boolean canceled;

    public RetryAndFollowUpInterceptor(OkHttpClient okHttpClient, boolean bl) {
        this.client = okHttpClient;
        this.forWebSocket = bl;
    }

    private Address createAddress(HttpUrl object) {
        SSLSocketFactory sSLSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (((HttpUrl)object).isHttps()) {
            RetryAndFollowUpInterceptor retryAndFollowUpInterceptor = dns;
            sSLSocketFactory = retryAndFollowUpInterceptor.client.sslSocketFactory();
            hostnameVerifier = retryAndFollowUpInterceptor.client.hostnameVerifier();
            certificatePinner = retryAndFollowUpInterceptor.client.certificatePinner();
        }
        HttpUrl httpUrl = object;
        object = httpUrl.host();
        int n2 = httpUrl.port();
        Object object2 = object;
        RetryAndFollowUpInterceptor retryAndFollowUpInterceptor = dns;
        Dns dns = retryAndFollowUpInterceptor.client.dns();
        object = retryAndFollowUpInterceptor.client.socketFactory();
        Authenticator authenticator = retryAndFollowUpInterceptor.client.proxyAuthenticator();
        Proxy proxy = retryAndFollowUpInterceptor.client.proxy();
        List<Protocol> list = retryAndFollowUpInterceptor.client.protocols();
        List<ConnectionSpec> list2 = retryAndFollowUpInterceptor.client.connectionSpecs();
        ProxySelector proxySelector = retryAndFollowUpInterceptor.client.proxySelector();
        return new Address((String)object2, n2, dns, (SocketFactory)object, sSLSocketFactory, hostnameVerifier, certificatePinner, authenticator, proxy, list, list2, proxySelector);
    }

    private boolean recover(IOException iOException, StreamAllocation streamAllocation, boolean bl, Request request) {
        streamAllocation.streamFailed(iOException);
        if (!this.client.retryOnConnectionFailure()) {
            return false;
        }
        if (bl && this.requestIsUnrepeatable(iOException, request)) {
            return false;
        }
        if (!this.isRecoverable(iOException, bl)) {
            return false;
        }
        return streamAllocation.hasMoreRoutes();
    }

    private boolean requestIsUnrepeatable(IOException iOException, Request request) {
        return request.body() instanceof UnrepeatableRequestBody || iOException instanceof FileNotFoundException;
    }

    private boolean isRecoverable(IOException iOException, boolean bl) {
        if (iOException instanceof ProtocolException) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            return iOException instanceof SocketTimeoutException && !bl;
        }
        if (iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        return !(iOException instanceof SSLPeerUnverifiedException);
    }

    private Request followUpRequest(Response response, Route object) throws IOException {
        if (response != null) {
            String string2 = response.request().method();
            switch (response.code()) {
                default: {
                    return null;
                }
                case 503: {
                    if (response.priorResponse() != null && response.priorResponse().code() == 503) {
                        return null;
                    }
                    if (this.retryAfter(response, Integer.MAX_VALUE) == 0) {
                        return response.request();
                    }
                    return null;
                }
                case 408: {
                    if (!this.client.retryOnConnectionFailure()) {
                        return null;
                    }
                    if (response.request().body() instanceof UnrepeatableRequestBody) {
                        return null;
                    }
                    if (response.priorResponse() != null && response.priorResponse().code() == 408) {
                        return null;
                    }
                    if (this.retryAfter(response, 0) > 0) {
                        return null;
                    }
                    return response.request();
                }
                case 407: {
                    if (((Route)object).proxy().type() == Proxy.Type.HTTP) {
                        return this.client.proxyAuthenticator().authenticate((Route)object, response);
                    }
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
                case 401: {
                    return this.client.authenticator().authenticate((Route)object, response);
                }
                case 307: 
                case 308: {
                    if (string2.equals("GET") || string2.equals("HEAD")) break;
                    return null;
                }
                case 300: 
                case 301: 
                case 302: 
                case 303: 
            }
            if (!this.client.followRedirects()) {
                return null;
            }
            object = response.header("Location");
            if (object == null) {
                return null;
            }
            object = response.request().url().resolve((String)object);
            if (object == null) {
                return null;
            }
            if (!((HttpUrl)object).scheme().equals(response.request().url().scheme()) && !this.client.followSslRedirects()) {
                return null;
            }
            Request.Builder builder = response.request().newBuilder();
            if (HttpMethod.permitsRequestBody(string2)) {
                String string3 = string2;
                boolean bl = HttpMethod.redirectsWithBody(string3);
                if (HttpMethod.redirectsToGet(string3)) {
                    builder.method("GET", null);
                } else {
                    RequestBody requestBody = bl ? response.request().body() : null;
                    builder.method(string2, requestBody);
                }
                if (!bl) {
                    Request.Builder builder2 = builder;
                    builder2.removeHeader("Transfer-Encoding");
                    builder2.removeHeader("Content-Length");
                    builder2.removeHeader("Content-Type");
                }
            }
            if (!this.sameConnection(response, (HttpUrl)object)) {
                builder.removeHeader("Authorization");
            }
            return builder.url((HttpUrl)object).build();
        }
        throw new IllegalStateException();
    }

    private int retryAfter(Response response, int n2) {
        String string2 = response.header("Retry-After");
        if (string2 == null) {
            return n2;
        }
        if (string2.matches("\\d+")) {
            return Integer.valueOf(string2);
        }
        return Integer.MAX_VALUE;
    }

    private boolean sameConnection(Response response, HttpUrl httpUrl) {
        HttpUrl httpUrl2 = response.request().url();
        return httpUrl2.host().equals(httpUrl.host()) && httpUrl2.port() == httpUrl.port() && httpUrl2.scheme().equals(httpUrl.scheme());
    }

    public void cancel() {
        ((RetryAndFollowUpInterceptor)((Object)streamAllocation)).canceled = true;
        StreamAllocation streamAllocation = ((RetryAndFollowUpInterceptor)((Object)streamAllocation)).streamAllocation;
        if (streamAllocation != null) {
            streamAllocation.cancel();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCallStackTrace(Object object) {
        this.callStackTrace = object;
    }

    public StreamAllocation streamAllocation() {
        return this.streamAllocation;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Response intercept(Interceptor.Chain var1_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 364->367)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

