/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http;

import dc.squareup.okhttp3.Call;
import dc.squareup.okhttp3.Connection;
import dc.squareup.okhttp3.EventListener;
import dc.squareup.okhttp3.Interceptor;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.connection.RealConnection;
import dc.squareup.okhttp3.internal.connection.StreamAllocation;
import dc.squareup.okhttp3.internal.http.HttpCodec;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RealInterceptorChain
implements Interceptor.Chain {
    private final List<Interceptor> interceptors;
    private final StreamAllocation streamAllocation;
    private final HttpCodec httpCodec;
    private final RealConnection connection;
    private final int index;
    private final Request request;
    private final Call call;
    private final EventListener eventListener;
    private final int connectTimeout;
    private final int readTimeout;
    private final int writeTimeout;
    private int calls;

    public RealInterceptorChain(List<Interceptor> list, StreamAllocation streamAllocation, HttpCodec httpCodec, RealConnection realConnection, int n2, Request request, Call call, EventListener eventListener, int n3, int n4, int n5) {
        this.interceptors = list;
        this.connection = realConnection;
        this.streamAllocation = streamAllocation;
        this.httpCodec = httpCodec;
        this.index = n2;
        this.request = request;
        this.call = call;
        this.eventListener = eventListener;
        this.connectTimeout = n3;
        this.readTimeout = n4;
        this.writeTimeout = n5;
    }

    @Override
    public Connection connection() {
        return this.connection;
    }

    @Override
    public int connectTimeoutMillis() {
        return this.connectTimeout;
    }

    @Override
    public Interceptor.Chain withConnectTimeout(int n2, TimeUnit object) {
        long l2 = n2;
        n2 = Util.checkDuration("timeout", l2, object);
        RealInterceptorChain realInterceptorChain = list;
        List<Interceptor> list = realInterceptorChain.interceptors;
        object = realInterceptorChain.streamAllocation;
        HttpCodec httpCodec = realInterceptorChain.httpCodec;
        RealConnection realConnection = realInterceptorChain.connection;
        int n3 = realInterceptorChain.index;
        Request request = realInterceptorChain.request;
        Call call = realInterceptorChain.call;
        EventListener eventListener = realInterceptorChain.eventListener;
        int n4 = realInterceptorChain.readTimeout;
        int n5 = realInterceptorChain.writeTimeout;
        return new RealInterceptorChain(list, (StreamAllocation)object, httpCodec, realConnection, n3, request, call, eventListener, n2, n4, n5);
    }

    @Override
    public int readTimeoutMillis() {
        return this.readTimeout;
    }

    @Override
    public Interceptor.Chain withReadTimeout(int n2, TimeUnit object) {
        long l2 = n2;
        n2 = Util.checkDuration("timeout", l2, object);
        RealInterceptorChain realInterceptorChain = list;
        List<Interceptor> list = realInterceptorChain.interceptors;
        object = realInterceptorChain.streamAllocation;
        HttpCodec httpCodec = realInterceptorChain.httpCodec;
        RealConnection realConnection = realInterceptorChain.connection;
        int n3 = realInterceptorChain.index;
        Request request = realInterceptorChain.request;
        Call call = realInterceptorChain.call;
        EventListener eventListener = realInterceptorChain.eventListener;
        int n4 = realInterceptorChain.connectTimeout;
        int n5 = realInterceptorChain.writeTimeout;
        return new RealInterceptorChain(list, (StreamAllocation)object, httpCodec, realConnection, n3, request, call, eventListener, n4, n2, n5);
    }

    @Override
    public int writeTimeoutMillis() {
        return this.writeTimeout;
    }

    @Override
    public Interceptor.Chain withWriteTimeout(int n2, TimeUnit object) {
        long l2 = n2;
        n2 = Util.checkDuration("timeout", l2, object);
        RealInterceptorChain realInterceptorChain = list;
        List<Interceptor> list = realInterceptorChain.interceptors;
        object = realInterceptorChain.streamAllocation;
        HttpCodec httpCodec = realInterceptorChain.httpCodec;
        RealConnection realConnection = realInterceptorChain.connection;
        int n3 = realInterceptorChain.index;
        Request request = realInterceptorChain.request;
        Call call = realInterceptorChain.call;
        EventListener eventListener = realInterceptorChain.eventListener;
        int n4 = realInterceptorChain.connectTimeout;
        int n5 = realInterceptorChain.readTimeout;
        return new RealInterceptorChain(list, (StreamAllocation)object, httpCodec, realConnection, n3, request, call, eventListener, n4, n5, n2);
    }

    public StreamAllocation streamAllocation() {
        return this.streamAllocation;
    }

    public HttpCodec httpStream() {
        return this.httpCodec;
    }

    @Override
    public Call call() {
        return this.call;
    }

    public EventListener eventListener() {
        return this.eventListener;
    }

    @Override
    public Request request() {
        return this.request;
    }

    @Override
    public Response proceed(Request object) throws IOException {
        RealInterceptorChain realInterceptorChain = streamAllocation;
        Request request = object;
        RealInterceptorChain realInterceptorChain2 = streamAllocation;
        StreamAllocation streamAllocation = realInterceptorChain2.streamAllocation;
        object = realInterceptorChain2.httpCodec;
        RealConnection realConnection = realInterceptorChain2.connection;
        return realInterceptorChain.proceed(request, streamAllocation, (HttpCodec)object, realConnection);
    }

    public Response proceed(Request object, StreamAllocation object2, HttpCodec httpCodec, RealConnection realConnection) throws IOException {
        if (this.index < this.interceptors.size()) {
            RealInterceptorChain realInterceptorChain;
            RealInterceptorChain realInterceptorChain2 = this;
            ++realInterceptorChain2.calls;
            if (realInterceptorChain2.httpCodec != null && !this.connection.supportsUrl(((Request)object).url())) {
                throw new IllegalStateException("network interceptor " + this.interceptors.get(this.index - 1) + " must retain the same host and port");
            }
            if (this.httpCodec != null && this.calls > 1) {
                throw new IllegalStateException("network interceptor " + this.interceptors.get(this.index - 1) + " must call proceed() exactly once");
            }
            RealInterceptorChain realInterceptorChain3 = realInterceptorChain;
            RealInterceptorChain realInterceptorChain4 = this;
            List<Interceptor> list = realInterceptorChain4.interceptors;
            int n2 = realInterceptorChain4.index + 1;
            Call call = realInterceptorChain4.call;
            EventListener eventListener = realInterceptorChain4.eventListener;
            int n3 = realInterceptorChain4.connectTimeout;
            int n4 = realInterceptorChain4.readTimeout;
            int n5 = realInterceptorChain4.writeTimeout;
            realInterceptorChain = new RealInterceptorChain(list, (StreamAllocation)object2, httpCodec, realConnection, n2, (Request)object, call, eventListener, n3, n4, n5);
            object = this.interceptors.get(this.index);
            object2 = object.intercept(realInterceptorChain3);
            if (httpCodec != null && this.index + 1 < this.interceptors.size() && realInterceptorChain3.calls != 1) {
                throw new IllegalStateException("network interceptor " + object + " must call proceed() exactly once");
            }
            if (object2 != null) {
                if (((Response)object2).body() != null) {
                    return object2;
                }
                throw new IllegalStateException("interceptor " + object + " returned a response with no body");
            }
            throw new NullPointerException("interceptor " + object + " returned null");
        }
        throw new AssertionError();
    }
}

