/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.connection;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.Address;
import dc.squareup.okhttp3.Call;
import dc.squareup.okhttp3.CertificatePinner;
import dc.squareup.okhttp3.Connection;
import dc.squareup.okhttp3.ConnectionPool;
import dc.squareup.okhttp3.ConnectionSpec;
import dc.squareup.okhttp3.EventListener;
import dc.squareup.okhttp3.Handshake;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.Interceptor;
import dc.squareup.okhttp3.OkHttpClient;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.Route;
import dc.squareup.okhttp3.internal.Internal;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.Version;
import dc.squareup.okhttp3.internal.connection.ConnectionSpecSelector;
import dc.squareup.okhttp3.internal.connection.RouteException;
import dc.squareup.okhttp3.internal.connection.StreamAllocation;
import dc.squareup.okhttp3.internal.http.HttpCodec;
import dc.squareup.okhttp3.internal.http.HttpHeaders;
import dc.squareup.okhttp3.internal.http1.Http1Codec;
import dc.squareup.okhttp3.internal.http2.ErrorCode;
import dc.squareup.okhttp3.internal.http2.Http2Codec;
import dc.squareup.okhttp3.internal.http2.Http2Connection;
import dc.squareup.okhttp3.internal.http2.Http2Stream;
import dc.squareup.okhttp3.internal.platform.Platform;
import dc.squareup.okhttp3.internal.tls.OkHostnameVerifier;
import dc.squareup.okhttp3.internal.ws.RealWebSocket;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Source;
import java.io.IOException;
import java.lang.ref.Reference;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public final class RealConnection
extends Http2Connection.Listener
implements Connection {
    private static final String NPE_THROW_WITH_NULL = "throw with null exception";
    private static final int MAX_TUNNEL_ATTEMPTS = 21;
    private final ConnectionPool connectionPool;
    private final Route route;
    private Socket rawSocket;
    private Socket socket;
    private Handshake handshake;
    private Protocol protocol;
    private Http2Connection http2Connection;
    private BufferedSource source;
    private BufferedSink sink;
    public boolean noNewStreams;
    public int successCount;
    public int allocationLimit = 1;
    public final List<Reference<StreamAllocation>> allocations;
    public long idleAtNanos;

    public RealConnection(ConnectionPool connectionPool, Route route) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        v1.allocations = arrayList2;
        v1.idleAtNanos = Long.MAX_VALUE;
        v1.connectionPool = connectionPool;
        v1.route = route;
    }

    public static RealConnection testConnection(ConnectionPool connectionPool, Route route, Socket socket, long l2) {
        new RealConnection(connectionPool, route).socket = socket;
        new RealConnection(connectionPool, route).idleAtNanos = l2;
        return new RealConnection(connectionPool, route);
    }

    private void connectTunnel(int n2, int n3, int n4, Call call, EventListener eventListener) throws IOException {
        Request request = this.createTunnelRequest();
        HttpUrl httpUrl = request.url();
        for (int i2 = 0; i2 < 21; ++i2) {
            RealConnection realConnection = this;
            realConnection.connectSocket(n2, n3, call, eventListener);
            request = realConnection.createTunnel(n3, n4, request, httpUrl);
            if (request == null) break;
            RealConnection realConnection2 = this;
            Util.closeQuietly(realConnection2.rawSocket);
            realConnection2.rawSocket = null;
            realConnection2.sink = null;
            realConnection2.source = null;
            InetSocketAddress inetSocketAddress = realConnection2.route.socketAddress();
            eventListener.connectEnd(call, inetSocketAddress, realConnection2.route.proxy(), null);
        }
    }

    private void connectSocket(int n2, int n3, Call call, EventListener eventListener) throws IOException {
        NullPointerException nullPointerException2;
        block6: {
            Proxy proxy = this.route.proxy();
            Object object = this.route.address();
            if (proxy.type() != Proxy.Type.DIRECT && proxy.type() != Proxy.Type.HTTP) {
                Socket socket;
                object = socket;
                socket = new Socket(proxy);
            } else {
                object = ((Address)object).socketFactory().createSocket();
            }
            RealConnection realConnection = this;
            this.rawSocket = object;
            eventListener.connectStart(call, this.route.socketAddress(), proxy);
            realConnection.rawSocket.setSoTimeout(n3);
            try {
                Platform.get().connectSocket(this.rawSocket, this.route.socketAddress(), n2);
            }
            catch (ConnectException connectException) {
                ConnectException connectException2 = new ConnectException("Failed to connect to " + this.route.socketAddress());
                connectException2.initCause(connectException);
                throw connectException2;
            }
            try {
                realConnection.source = Okio.buffer(Okio.source(realConnection.rawSocket));
                realConnection.sink = Okio.buffer(Okio.sink(realConnection.rawSocket));
            }
            catch (NullPointerException nullPointerException2) {
                if (NPE_THROW_WITH_NULL.equals(nullPointerException2.getMessage())) break block6;
            }
            return;
        }
        throw new IOException(nullPointerException2);
    }

    private void establishProtocol(ConnectionSpecSelector object, int n2, Call call, EventListener eventListener) throws IOException {
        if (this.route.address().sslSocketFactory() == null) {
            object = Protocol.H2_PRIOR_KNOWLEDGE;
            if (this.route.address().protocols().contains(object)) {
                this.socket = this.rawSocket;
                this.protocol = object;
                this.startHttp2(n2);
                return;
            }
            this.socket = this.rawSocket;
            this.protocol = Protocol.HTTP_1_1;
            return;
        }
        RealConnection realConnection = this;
        eventListener.secureConnectStart(call);
        realConnection.connectTls((ConnectionSpecSelector)object);
        eventListener.secureConnectEnd(call, realConnection.handshake);
        if (this.protocol == Protocol.HTTP_2) {
            this.startHttp2(n2);
        }
    }

    private void startHttp2(int n2) throws IOException {
        Http2Connection.Builder builder;
        this.socket.setSoTimeout(0);
        Object object = builder;
        RealConnection realConnection = this;
        ((Http2Connection.Builder)object)(true);
        object = realConnection.socket;
        String string2 = realConnection.route.address().url().host();
        BufferedSource bufferedSource = realConnection.source;
        BufferedSink bufferedSink = realConnection.sink;
        this.http2Connection = builder.socket((Socket)object, string2, bufferedSource, bufferedSink).listener(this).pingIntervalMillis(n2).build();
        this.http2Connection.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectTls(ConnectionSpecSelector var1_3) throws IOException {
        block13: {
            v0 = var1_3 /* !! */ ;
            var1_3 /* !! */  = this.route.address();
            var2_4 = null;
            v1 = var1_3 /* !! */ ;
            var3_5 = v1.url().host();
            var2_4 = (SSLSocket)var1_3 /* !! */ .sslSocketFactory().createSocket(this.rawSocket, (String)var3_5, v1.url().port(), true);
            {
                catch (Throwable var0_1) {
                    break block13;
                }
                catch (AssertionError var0_2) {}
                {
                    if (Util.isAndroidGetsocknameError(var0_2)) {
                        throw new IOException((Throwable)var0_2);
                    }
                    throw var0_2;
                }
            }
            {
                var3_5 = v0.configureSecureSocket(var2_4);
            }
            {
                if (var3_5.supportsTlsExtensions()) {
                    v2 = var1_3 /* !! */ ;
                    var4_6 = v2.url().host();
                    Platform.get().configureTlsExtensions(var2_4, (String)var4_6, v2.protocols());
                }
                v3 = var1_3 /* !! */ ;
                v4 = var2_4;
                v4.startHandshake();
                var4_6 = v4.getSession();
            }
            {
                var5_7 = Handshake.get((SSLSession)var4_6);
                if (v3.hostnameVerifier().verify(var1_3 /* !! */ .url().host(), (SSLSession)var4_6)) ** GOTO lbl31
            }
            {
                this = var5_7.peerCertificates();
                if (!this.isEmpty()) {
                    this = (X509Certificate)this.get(0);
                    throw new SSLPeerUnverifiedException("Hostname " + var1_3 /* !! */ .url().host() + " not verified:\n    certificate: " + CertificatePinner.pin((Certificate)this) + "\n    DN: " + this.getSubjectDN().getName() + "\n    subjectAltNames: " + OkHostnameVerifier.allSubjectAltNames((X509Certificate)this));
                }
                throw new SSLPeerUnverifiedException("Hostname " + var1_3 /* !! */ .url().host() + " not verified (no certificates)");
lbl31:
                // 1 sources

                v5 = var1_3 /* !! */ .certificatePinner();
                var1_3 /* !! */  = var1_3 /* !! */ .url().host();
                v5.check((String)var1_3 /* !! */ , var5_7.peerCertificates());
                var1_3 /* !! */  = var3_5.supportsTlsExtensions() != false ? Platform.get().getSelectedProtocol(var2_4) : null;
                this.socket = var2_4;
                this.source = Okio.buffer(Okio.source(var2_4));
                this.sink = Okio.buffer(Okio.sink(this.socket));
                this.handshake = var5_7;
                var1_3 /* !! */  = var1_3 /* !! */  != null ? Protocol.get((String)var1_3 /* !! */ ) : Protocol.HTTP_1_1;
                this.protocol = var1_3 /* !! */ ;
                if (var2_4 != null) {
                    Platform.get().afterHandshake(var2_4);
                }
                return;
            }
        }
        if (var2_4 != null) {
            Platform.get().afterHandshake(var2_4);
        }
        Util.closeQuietly(var2_4);
        throw var0_1;
    }

    private Request createTunnel(int n2, int n3, Request object, HttpUrl object2) throws IOException {
        block4: {
            block5: {
                object2 = "CONNECT " + Util.hostHeader((HttpUrl)object2, true) + " HTTP/1.1";
                while (true) {
                    Http1Codec http1Codec;
                    Object object3 = http1Codec;
                    RealConnection realConnection = this;
                    RealConnection realConnection2 = this;
                    Object object4 = realConnection2.source;
                    BufferedSink bufferedSink = realConnection2.sink;
                    ((Http1Codec)object3)(null, null, (BufferedSource)object4, bufferedSink);
                    object4 = TimeUnit.MILLISECONDS;
                    realConnection.source.timeout().timeout(n2, (TimeUnit)((Object)object4));
                    realConnection.sink.timeout().timeout(n3, (TimeUnit)((Object)object4));
                    http1Codec.writeRequest(((Request)object).headers(), (String)object2);
                    http1Codec.finishRequest();
                    object = http1Codec.readResponseHeaders(false).request((Request)object).build();
                    long l2 = HttpHeaders.contentLength((Response)object);
                    if (l2 == -1L) {
                        l2 = 0L;
                    }
                    Source source = ((Http1Codec)object3).newFixedLengthSource(l2);
                    Util.skipAll(source, Integer.MAX_VALUE, (TimeUnit)((Object)object4));
                    source.close();
                    int n4 = ((Response)object).code();
                    if (n4 == 200) break block4;
                    if (n4 != 407) break block5;
                    object3 = this.route.address().proxyAuthenticator().authenticate(this.route, (Response)object);
                    if (object3 == null) break;
                    if ("close".equalsIgnoreCase(((Response)object).header("Connection"))) {
                        return object3;
                    }
                    object = object3;
                }
                throw new IOException("Failed to authenticate with proxy");
            }
            throw new IOException("Unexpected response code for CONNECT: " + ((Response)object).code());
        }
        if (this.source.buffer().exhausted() && this.sink.buffer().exhausted()) {
            return null;
        }
        throw new IOException("TLS tunnel buffered too many bytes!");
    }

    private Request createTunnelRequest() throws IOException {
        Request request = new Request.Builder().url(((RealConnection)object).route.address().url()).method("CONNECT", null).header("Host", Util.hostHeader(((RealConnection)object).route.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", Version.userAgent()).build();
        Response response = new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(407).message("Preemptive Authenticate").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(-1L).header("Proxy-Authenticate", "OkHttp-Preemptive").build();
        Object object = ((RealConnection)object).route.address().proxyAuthenticator().authenticate(((RealConnection)object).route, response);
        if (object == null) {
            object = request;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(int n2, int n3, int n4, int n5, boolean bl, Call call, EventListener eventListener) {
        block12: {
            ProtocolException protocolException;
            Object object;
            ConnectionSpecSelector connectionSpecSelector;
            if (((RealConnection)object).protocol != null) throw new IllegalStateException("already connected");
            RealConnection realConnection = object;
            RouteException routeException = null;
            Object object2 = realConnection.route.address().connectionSpecs();
            ConnectionSpecSelector connectionSpecSelector2 = connectionSpecSelector;
            connectionSpecSelector = new ConnectionSpecSelector((List<ConnectionSpec>)object2);
            if (realConnection.route.address().sslSocketFactory() == null) {
                if (!object2.contains(ConnectionSpec.CLEARTEXT)) {
                    UnknownServiceException unknownServiceException;
                    object = unknownServiceException;
                    unknownServiceException = new UnknownServiceException("CLEARTEXT communication not enabled for client");
                    throw new RouteException((IOException)object);
                }
                object2 = ((RealConnection)object).route.address().url().host();
                if (!Platform.get().isCleartextTrafficPermitted((String)object2)) throw new RouteException(new UnknownServiceException("CLEARTEXT communication to " + (String)object2 + " not permitted by network security policy"));
            } else if (((RealConnection)object).route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
                UnknownServiceException unknownServiceException;
                object = unknownServiceException;
                unknownServiceException = new UnknownServiceException("H2_PRIOR_KNOWLEDGE cannot be used with HTTPS");
                throw new RouteException((IOException)object);
            }
            while (true) {
                Object object3;
                try {
                    block15: {
                        block14: {
                            block13: {
                                if (!((RealConnection)object).route.requiresTunnel()) break block13;
                                Object object4 = object;
                                super.connectTunnel(n2, n3, n4, call, eventListener);
                                if (((RealConnection)object4).rawSocket != null) break block14;
                                break block15;
                            }
                            super.connectSocket(n2, n3, call, eventListener);
                        }
                        Object object5 = object;
                        super.establishProtocol(connectionSpecSelector2, n5, call, eventListener);
                        object2 = ((RealConnection)object5).route.socketAddress();
                        object3 = ((RealConnection)object5).route.proxy();
                        Protocol protocol = ((RealConnection)object5).protocol;
                        eventListener.connectEnd(call, (InetSocketAddress)object2, (Proxy)object3, protocol);
                    }
                    if (((RealConnection)object).route.requiresTunnel() && ((RealConnection)object).rawSocket == null) break;
                    break block12;
                }
                catch (IOException iOException) {
                    Object object6 = object;
                    Util.closeQuietly(((RealConnection)object6).socket);
                    Util.closeQuietly(((RealConnection)object6).rawSocket);
                    ((RealConnection)object6).socket = null;
                    ((RealConnection)object6).rawSocket = null;
                    ((RealConnection)object6).source = null;
                    ((RealConnection)object6).sink = null;
                    ((RealConnection)object6).handshake = null;
                    ((RealConnection)object6).protocol = null;
                    ((RealConnection)object6).http2Connection = null;
                    object3 = ((RealConnection)object6).route.socketAddress();
                    eventListener.connectFailed(call, (InetSocketAddress)object3, ((RealConnection)object6).route.proxy(), null, iOException);
                    if (routeException == null) {
                        RouteException routeException2;
                        routeException = routeException2;
                        routeException2 = new RouteException(iOException);
                    } else {
                        routeException.addConnectException(iOException);
                    }
                    if (!bl) throw routeException;
                    if (!connectionSpecSelector2.connectionFailed(iOException)) throw routeException;
                    continue;
                }
                break;
            }
            object = protocolException;
            protocolException = new ProtocolException("Too many tunnel connections attempted: 21");
            throw new RouteException((IOException)object);
        }
        if (((RealConnection)object).http2Connection == null) return;
        ConnectionPool connectionPool = ((RealConnection)object).connectionPool;
        synchronized (connectionPool) {
            ((RealConnection)object).allocationLimit = ((RealConnection)object).http2Connection.maxConcurrentStreams();
            return;
        }
    }

    public boolean isEligible(Address address, @Nullable Route route) {
        if (this.allocations.size() < this.allocationLimit && !this.noNewStreams) {
            if (!Internal.instance.equalsNonHost(this.route.address(), address)) {
                return false;
            }
            if (address.url().host().equals(this.route().address().url().host())) {
                return true;
            }
            if (this.http2Connection == null) {
                return false;
            }
            if (route == null) {
                return false;
            }
            if (route.proxy().type() != Proxy.Type.DIRECT) {
                return false;
            }
            if (this.route.proxy().type() != Proxy.Type.DIRECT) {
                return false;
            }
            if (!this.route.socketAddress().equals(route.socketAddress())) {
                return false;
            }
            if (route.address().hostnameVerifier() != OkHostnameVerifier.INSTANCE) {
                return false;
            }
            if (!this.supportsUrl(address.url())) {
                return false;
            }
            try {
                address.certificatePinner().check(address.url().host(), this.handshake().peerCertificates());
                return true;
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                return false;
            }
        }
        return false;
    }

    public boolean supportsUrl(HttpUrl httpUrl) {
        if (httpUrl.port() != this.route.address().url().port()) {
            return false;
        }
        if (!httpUrl.host().equals(this.route.address().url().host())) {
            return this.handshake != null && OkHostnameVerifier.INSTANCE.verify(httpUrl.host(), (X509Certificate)this.handshake.peerCertificates().get(0));
        }
        return true;
    }

    public HttpCodec newCodec(OkHttpClient okHttpClient, Interceptor.Chain chain, StreamAllocation streamAllocation) throws SocketException {
        Object object;
        if (((RealConnection)object).http2Connection != null) {
            object = ((RealConnection)object).http2Connection;
            return new Http2Codec(okHttpClient, chain, streamAllocation, (Http2Connection)object);
        }
        RealConnection realConnection = object;
        realConnection.socket.setSoTimeout(chain.readTimeoutMillis());
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        realConnection.source.timeout().timeout(chain.readTimeoutMillis(), timeUnit);
        realConnection.sink.timeout().timeout(chain.writeTimeoutMillis(), timeUnit);
        Object object2 = object;
        object = ((RealConnection)object2).source;
        return new Http1Codec(okHttpClient, streamAllocation, (BufferedSource)object, ((RealConnection)object2).sink);
    }

    public RealWebSocket.Streams newWebSocketStreams(final StreamAllocation streamAllocation) {
        RealConnection realConnection = this;
        BufferedSource bufferedSource = realConnection.source;
        BufferedSink bufferedSink = realConnection.sink;
        return new RealWebSocket.Streams(true, bufferedSource, bufferedSink){

            @Override
            public void close() throws IOException {
                StreamAllocation streamAllocation2 = streamAllocation;
                streamAllocation2.streamFinished(true, streamAllocation2.codec(), -1L, null);
            }
        };
    }

    @Override
    public Route route() {
        return this.route;
    }

    public void cancel() {
        Util.closeQuietly(this.rawSocket);
    }

    @Override
    public Socket socket() {
        return this.socket;
    }

    /*
     * Loose catch block
     * Could not resolve type clashes
     */
    public boolean isHealthy(boolean bl) {
        if (!(this.socket.isClosed() || this.socket.isInputShutdown() || this.socket.isOutputShutdown())) {
            Http2Connection http2Connection = this.http2Connection;
            if (http2Connection != null) {
                return http2Connection.isHealthy(System.nanoTime());
            }
            if (bl) {
                block11: {
                    RealConnection realConnection = this;
                    RealConnection realConnection2 = realConnection;
                    RealConnection realConnection3 = realConnection;
                    bl = realConnection.socket.getSoTimeout();
                    realConnection3.socket.setSoTimeout(1);
                    if (!realConnection2.source.exhausted()) break block11;
                    this.socket.setSoTimeout(bl ? 1 : 0);
                    return false;
                }
                this.socket.setSoTimeout(bl ? 1 : 0);
                return true;
                catch (Throwable throwable) {
                    try {
                        this.socket.setSoTimeout(bl ? 1 : 0);
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                    catch (SocketTimeoutException socketTimeoutException) {}
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void onStream(Http2Stream http2Stream) throws IOException {
        http2Stream.close(ErrorCode.REFUSED_STREAM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSettings(Http2Connection http2Connection) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            this.allocationLimit = http2Connection.maxConcurrentStreams();
            return;
        }
    }

    @Override
    public Handshake handshake() {
        return this.handshake;
    }

    public boolean isMultiplexed() {
        return this.http2Connection != null;
    }

    @Override
    public Protocol protocol() {
        return this.protocol;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Connection{").append(this.route.address().url().host()).append(":").append(this.route.address().url().port()).append(", proxy=").append(this.route.proxy()).append(" hostAddress=").append(this.route.socketAddress()).append(" cipherSuite=");
        Object object = this.handshake;
        object = object != null ? ((Handshake)object).cipherSuite() : "none";
        return stringBuilder.append(object).append(" protocol=").append((Object)this.protocol).append('}').toString();
    }
}

