/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.CacheControl;
import dc.squareup.okhttp3.Challenge;
import dc.squareup.okhttp3.Handshake;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.ResponseBody;
import dc.squareup.okhttp3.internal.http.HttpHeaders;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class Response
implements Closeable {
    final Request request;
    final Protocol protocol;
    final int code;
    final String message;
    @Nullable
    final Handshake handshake;
    final Headers headers;
    @Nullable
    final ResponseBody body;
    @Nullable
    final Response networkResponse;
    @Nullable
    final Response cacheResponse;
    @Nullable
    final Response priorResponse;
    final long sentRequestAtMillis;
    final long receivedResponseAtMillis;
    @Nullable
    private volatile CacheControl cacheControl;

    Response(Builder builder) {
        this.request = builder.request;
        this.protocol = builder.protocol;
        this.code = builder.code;
        this.message = builder.message;
        this.handshake = builder.handshake;
        this.headers = builder.headers.build();
        this.body = builder.body;
        this.networkResponse = builder.networkResponse;
        this.cacheResponse = builder.cacheResponse;
        this.priorResponse = builder.priorResponse;
        this.sentRequestAtMillis = builder.sentRequestAtMillis;
        this.receivedResponseAtMillis = builder.receivedResponseAtMillis;
    }

    public Request request() {
        return this.request;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public int code() {
        return this.code;
    }

    public boolean isSuccessful() {
        int n2 = this.code;
        return n2 >= 200 && n2 < 300;
    }

    public String message() {
        return this.message;
    }

    @Nullable
    public Handshake handshake() {
        return this.handshake;
    }

    public List<String> headers(String string2) {
        return this.headers.values(string2);
    }

    @Nullable
    public String header(String string2) {
        return this.header(string2, null);
    }

    @Nullable
    public String header(String string2, @Nullable String string3) {
        Object object = ((Response)object).headers.get(string2);
        if (object == null) {
            object = string3;
        }
        return object;
    }

    public Headers headers() {
        return this.headers;
    }

    public ResponseBody peekBody(long l2) throws IOException {
        Buffer buffer;
        BufferedSource bufferedSource = this.body.source();
        bufferedSource.request(l2);
        Buffer buffer2 = bufferedSource.buffer().clone();
        if (buffer2.size() > l2) {
            Buffer buffer3;
            buffer = buffer3;
            new Buffer().write(buffer2, l2);
            buffer2.clear();
        } else {
            buffer = buffer2;
        }
        return ResponseBody.create(this.body.contentType(), buffer.size(), buffer);
    }

    @Nullable
    public ResponseBody body() {
        return this.body;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public boolean isRedirect() {
        switch (this.code) {
            default: {
                return false;
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: 
        }
        return true;
    }

    @Nullable
    public Response networkResponse() {
        return this.networkResponse;
    }

    @Nullable
    public Response cacheResponse() {
        return this.cacheResponse;
    }

    @Nullable
    public Response priorResponse() {
        return this.priorResponse;
    }

    public List<Challenge> challenges() {
        block4: {
            String string2;
            block3: {
                int n2;
                block2: {
                    n2 = this.code;
                    if (n2 != 401) break block2;
                    string2 = "WWW-Authenticate";
                    break block3;
                }
                if (n2 != 407) break block4;
                string2 = "Proxy-Authenticate";
            }
            return HttpHeaders.parseChallenges(this.headers(), string2);
        }
        return Collections.emptyList();
    }

    public CacheControl cacheControl() {
        CacheControl cacheControl = this.cacheControl;
        if (cacheControl == null) {
            this.cacheControl = cacheControl = CacheControl.parse(this.headers);
        }
        return cacheControl;
    }

    public long sentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    public long receivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    @Override
    public void close() {
        Closeable closeable = ((Response)closeable).body;
        if (closeable != null) {
            ((ResponseBody)closeable).close();
            return;
        }
        throw new IllegalStateException("response is not eligible for a body and must not be closed");
    }

    public String toString() {
        return "Response{protocol=" + (Object)((Object)this.protocol) + ", code=" + this.code + ", message=" + this.message + ", url=" + this.request.url() + '}';
    }

    public static class Builder {
        @Nullable
        Request request;
        @Nullable
        Protocol protocol;
        int code;
        String message;
        @Nullable
        Handshake handshake;
        Headers.Builder headers;
        @Nullable
        ResponseBody body;
        @Nullable
        Response networkResponse;
        @Nullable
        Response cacheResponse;
        @Nullable
        Response priorResponse;
        long sentRequestAtMillis;
        long receivedResponseAtMillis;

        public Builder() {
            Headers.Builder builder;
            ((Builder)((Object)builder2)).code = -1;
            Headers.Builder builder2 = builder;
            builder = new Headers.Builder();
            v1.headers = builder2;
        }

        Builder(Response response) {
            this.code = -1;
            this.request = response.request;
            this.protocol = response.protocol;
            this.code = response.code;
            this.message = response.message;
            this.handshake = response.handshake;
            this.headers = response.headers.newBuilder();
            this.body = response.body;
            this.networkResponse = response.networkResponse;
            this.cacheResponse = response.cacheResponse;
            this.priorResponse = response.priorResponse;
            this.sentRequestAtMillis = response.sentRequestAtMillis;
            this.receivedResponseAtMillis = response.receivedResponseAtMillis;
        }

        private void checkSupportResponse(String string2, Response response) {
            if (response.body == null) {
                if (response.networkResponse == null) {
                    if (response.cacheResponse == null) {
                        if (response.priorResponse == null) {
                            return;
                        }
                        throw new IllegalArgumentException(string2 + ".priorResponse != null");
                    }
                    throw new IllegalArgumentException(string2 + ".cacheResponse != null");
                }
                throw new IllegalArgumentException(string2 + ".networkResponse != null");
            }
            throw new IllegalArgumentException(string2 + ".body != null");
        }

        private void checkPriorResponse(Response response) {
            if (response.body == null) {
                return;
            }
            throw new IllegalArgumentException("priorResponse.body != null");
        }

        public Builder request(Request request) {
            this.request = request;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder code(int n2) {
            this.code = n2;
            return this;
        }

        public Builder message(String string2) {
            this.message = string2;
            return this;
        }

        public Builder handshake(@Nullable Handshake handshake) {
            this.handshake = handshake;
            return this;
        }

        public Builder header(String string2, String string3) {
            Builder builder = this;
            builder.headers.set(string2, string3);
            return builder;
        }

        public Builder addHeader(String string2, String string3) {
            Builder builder = this;
            builder.headers.add(string2, string3);
            return builder;
        }

        public Builder removeHeader(String string2) {
            Builder builder = this;
            builder.headers.removeAll(string2);
            return builder;
        }

        public Builder headers(Headers headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder body(@Nullable ResponseBody responseBody) {
            this.body = responseBody;
            return this;
        }

        public Builder networkResponse(@Nullable Response response) {
            if (response != null) {
                this.checkSupportResponse("networkResponse", response);
            }
            this.networkResponse = response;
            return this;
        }

        public Builder cacheResponse(@Nullable Response response) {
            if (response != null) {
                this.checkSupportResponse("cacheResponse", response);
            }
            this.cacheResponse = response;
            return this;
        }

        public Builder priorResponse(@Nullable Response response) {
            if (response != null) {
                this.checkPriorResponse(response);
            }
            this.priorResponse = response;
            return this;
        }

        public Builder sentRequestAtMillis(long l2) {
            this.sentRequestAtMillis = l2;
            return this;
        }

        public Builder receivedResponseAtMillis(long l2) {
            this.receivedResponseAtMillis = l2;
            return this;
        }

        public Response build() {
            if (this.request != null) {
                if (this.protocol != null) {
                    if (this.code >= 0) {
                        if (this.message != null) {
                            return new Response(this);
                        }
                        throw new IllegalStateException("message == null");
                    }
                    throw new IllegalStateException("code < 0: " + this.code);
                }
                throw new IllegalStateException("protocol == null");
            }
            throw new IllegalStateException("request == null");
        }
    }
}

