/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.internal.http.HttpHeaders;
import java.util.concurrent.TimeUnit;

public final class CacheControl {
    public static final CacheControl FORCE_NETWORK = new Builder().noCache().build();
    public static final CacheControl FORCE_CACHE = new Builder().onlyIfCached().maxStale(Integer.MAX_VALUE, TimeUnit.SECONDS).build();
    private final boolean noCache;
    private final boolean noStore;
    private final int maxAgeSeconds;
    private final int sMaxAgeSeconds;
    private final boolean isPrivate;
    private final boolean isPublic;
    private final boolean mustRevalidate;
    private final int maxStaleSeconds;
    private final int minFreshSeconds;
    private final boolean onlyIfCached;
    private final boolean noTransform;
    private final boolean immutable;
    @Nullable
    String headerValue;

    private CacheControl(boolean bl, boolean bl2, int n2, int n3, boolean bl3, boolean bl4, boolean bl5, int n4, int n5, boolean bl6, boolean bl7, boolean bl8, @Nullable String string2) {
        this.noCache = bl;
        this.noStore = bl2;
        this.maxAgeSeconds = n2;
        this.sMaxAgeSeconds = n3;
        this.isPrivate = bl3;
        this.isPublic = bl4;
        this.mustRevalidate = bl5;
        this.maxStaleSeconds = n4;
        this.minFreshSeconds = n5;
        this.onlyIfCached = bl6;
        this.noTransform = bl7;
        this.immutable = bl8;
        this.headerValue = string2;
    }

    CacheControl(Builder builder) {
        CacheControl cacheControl = this;
        this.noCache = builder.noCache;
        this.noStore = builder.noStore;
        cacheControl.maxAgeSeconds = builder.maxAgeSeconds;
        cacheControl.sMaxAgeSeconds = -1;
        cacheControl.isPrivate = false;
        cacheControl.isPublic = false;
        cacheControl.mustRevalidate = false;
        this.maxStaleSeconds = builder.maxStaleSeconds;
        this.minFreshSeconds = builder.minFreshSeconds;
        this.onlyIfCached = builder.onlyIfCached;
        this.noTransform = builder.noTransform;
        this.immutable = builder.immutable;
    }

    public static CacheControl parse(Headers headers) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = -1;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n4 = -1;
        int n5 = -1;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = true;
        String string2 = null;
        int n6 = headers.size();
        for (int i2 = 0; i2 < n6; ++i2) {
            String string3;
            block32: {
                block31: {
                    String string4;
                    block30: {
                        string4 = headers.name(i2);
                        string3 = headers.value(i2);
                        if (!string4.equalsIgnoreCase("Cache-Control")) break block30;
                        if (string2 != null) break block31;
                        string2 = string3;
                        break block32;
                    }
                    if (!string4.equalsIgnoreCase("Pragma")) continue;
                }
                bl9 = false;
            }
            int n7 = 0;
            while (n7 < string3.length()) {
                String string5;
                int n8;
                int n9 = HttpHeaders.skipUntil(string3, n7, "=,;");
                String string6 = string3;
                String string7 = string6.substring(n7, n9).trim();
                if (n9 != string6.length() && string3.charAt(n9) != ',' && string3.charAt(n9) != ';') {
                    if ((n9 = HttpHeaders.skipWhitespace(string3, n9 + 1)) < string3.length() && string3.charAt(n9) == '\"') {
                        String string8 = string3;
                        n8 = HttpHeaders.skipUntil(string8, ++n9, "\"");
                        string5 = string8.substring(n9, n8);
                        ++n8;
                    } else {
                        n8 = HttpHeaders.skipUntil(string3, n9, ",;");
                        string5 = string3.substring(n9, n8).trim();
                    }
                } else {
                    n8 = n9 + 1;
                    string5 = null;
                }
                if ("no-cache".equalsIgnoreCase(string7)) {
                    bl = true;
                } else if ("no-store".equalsIgnoreCase(string7)) {
                    bl2 = true;
                } else if ("max-age".equalsIgnoreCase(string7)) {
                    n2 = HttpHeaders.parseSeconds(string5, -1);
                } else if ("s-maxage".equalsIgnoreCase(string7)) {
                    n3 = HttpHeaders.parseSeconds(string5, -1);
                } else if ("private".equalsIgnoreCase(string7)) {
                    bl3 = true;
                } else if ("public".equalsIgnoreCase(string7)) {
                    bl4 = true;
                } else if ("must-revalidate".equalsIgnoreCase(string7)) {
                    bl5 = true;
                } else if ("max-stale".equalsIgnoreCase(string7)) {
                    n4 = HttpHeaders.parseSeconds(string5, Integer.MAX_VALUE);
                } else if ("min-fresh".equalsIgnoreCase(string7)) {
                    n5 = HttpHeaders.parseSeconds(string5, -1);
                } else if ("only-if-cached".equalsIgnoreCase(string7)) {
                    bl6 = true;
                } else if ("no-transform".equalsIgnoreCase(string7)) {
                    bl7 = true;
                } else if ("immutable".equalsIgnoreCase(string7)) {
                    bl8 = true;
                }
                n7 = n8;
            }
        }
        if (!bl9) {
            string2 = null;
        }
        return new CacheControl(bl, bl2, n2, n3, bl3, bl4, bl5, n4, n5, bl6, bl7, bl8, string2);
    }

    private String headerValue() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (this.noCache) {
            stringBuilder2.append("no-cache, ");
        }
        if (this.noStore) {
            stringBuilder2.append("no-store, ");
        }
        if (this.maxAgeSeconds != -1) {
            stringBuilder2.append("max-age=").append(this.maxAgeSeconds).append(", ");
        }
        if (this.sMaxAgeSeconds != -1) {
            stringBuilder2.append("s-maxage=").append(this.sMaxAgeSeconds).append(", ");
        }
        if (this.isPrivate) {
            stringBuilder2.append("private, ");
        }
        if (this.isPublic) {
            stringBuilder2.append("public, ");
        }
        if (this.mustRevalidate) {
            stringBuilder2.append("must-revalidate, ");
        }
        if (this.maxStaleSeconds != -1) {
            stringBuilder2.append("max-stale=").append(this.maxStaleSeconds).append(", ");
        }
        if (this.minFreshSeconds != -1) {
            stringBuilder2.append("min-fresh=").append(this.minFreshSeconds).append(", ");
        }
        if (this.onlyIfCached) {
            stringBuilder2.append("only-if-cached, ");
        }
        if (this.noTransform) {
            stringBuilder2.append("no-transform, ");
        }
        if (this.immutable) {
            stringBuilder2.append("immutable, ");
        }
        if (stringBuilder2.length() == 0) {
            return "";
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        int n2 = stringBuilder3.length() - 2;
        stringBuilder3.delete(n2, stringBuilder3.length());
        return stringBuilder3.toString();
    }

    public boolean noCache() {
        return this.noCache;
    }

    public boolean noStore() {
        return this.noStore;
    }

    public int maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public int sMaxAgeSeconds() {
        return this.sMaxAgeSeconds;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean mustRevalidate() {
        return this.mustRevalidate;
    }

    public int maxStaleSeconds() {
        return this.maxStaleSeconds;
    }

    public int minFreshSeconds() {
        return this.minFreshSeconds;
    }

    public boolean onlyIfCached() {
        return this.onlyIfCached;
    }

    public boolean noTransform() {
        return this.noTransform;
    }

    public boolean immutable() {
        return this.immutable;
    }

    public String toString() {
        String string2 = this.headerValue;
        if (string2 == null) {
            this.headerValue = string2 = this.headerValue();
        }
        return string2;
    }

    public static final class Builder {
        boolean noCache;
        boolean noStore;
        int maxAgeSeconds = -1;
        int maxStaleSeconds = -1;
        int minFreshSeconds = -1;
        boolean onlyIfCached;
        boolean noTransform;
        boolean immutable;

        public Builder noCache() {
            this.noCache = true;
            return this;
        }

        public Builder noStore() {
            this.noStore = true;
            return this;
        }

        public Builder maxAge(int n2, TimeUnit timeUnit) {
            if (n2 >= 0) {
                long l2 = timeUnit.toSeconds(n2);
                int n3 = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
                this.maxAgeSeconds = n3;
                return this;
            }
            throw new IllegalArgumentException("maxAge < 0: " + n2);
        }

        public Builder maxStale(int n2, TimeUnit timeUnit) {
            if (n2 >= 0) {
                long l2 = timeUnit.toSeconds(n2);
                int n3 = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
                this.maxStaleSeconds = n3;
                return this;
            }
            throw new IllegalArgumentException("maxStale < 0: " + n2);
        }

        public Builder minFresh(int n2, TimeUnit timeUnit) {
            if (n2 >= 0) {
                long l2 = timeUnit.toSeconds(n2);
                int n3 = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
                this.minFreshSeconds = n3;
                return this;
            }
            throw new IllegalArgumentException("minFresh < 0: " + n2);
        }

        public Builder onlyIfCached() {
            this.onlyIfCached = true;
            return this;
        }

        public Builder noTransform() {
            this.noTransform = true;
            return this;
        }

        public Builder immutable() {
            this.immutable = true;
            return this;
        }

        public CacheControl build() {
            return new CacheControl(this);
        }
    }
}

