/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core.display;

import android.graphics.Bitmap;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.nostra13.dcloudimageloader.core.assist.LoadedFrom;
import com.nostra13.dcloudimageloader.core.display.BitmapDisplayer;
import com.nostra13.dcloudimageloader.core.imageaware.ImageAware;

public class FadeInBitmapDisplayer
implements BitmapDisplayer {
    private final int durationMillis;
    private final boolean animateFromNetwork;
    private final boolean animateFromDisc;
    private final boolean animateFromMemory;

    public FadeInBitmapDisplayer(int n2) {
        this(n2, true, true, true);
    }

    public FadeInBitmapDisplayer(int n2, boolean bl, boolean bl2, boolean bl3) {
        this.durationMillis = n2;
        this.animateFromNetwork = bl;
        this.animateFromDisc = bl2;
        this.animateFromMemory = bl3;
    }

    public static void animate(View view, int n2) {
        if (view != null) {
            AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
            alphaAnimation.setDuration((long)n2);
            alphaAnimation.setInterpolator((Interpolator)new DecelerateInterpolator());
            view.startAnimation((Animation)alphaAnimation);
        }
    }

    @Override
    public Bitmap display(Bitmap bitmap, ImageAware imageAware, LoadedFrom loadedFrom) {
        imageAware.setImageBitmap(bitmap);
        if (this.animateFromNetwork && loadedFrom == LoadedFrom.NETWORK || this.animateFromDisc && loadedFrom == LoadedFrom.DISC_CACHE || this.animateFromMemory && loadedFrom == LoadedFrom.MEMORY_CACHE) {
            FadeInBitmapDisplayer.animate(imageAware.getWrappedView(), this.durationMillis);
        }
        return bitmap;
    }
}

