/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.cache.memory.impl;

import android.graphics.Bitmap;
import com.nostra13.dcloudimageloader.cache.memory.MemoryCacheAware;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LimitedAgeMemoryCache
implements MemoryCacheAware {
    private final MemoryCacheAware cache;
    private final long maxAge;
    private final Map<String, Long> loadingDates = Collections.synchronizedMap(new HashMap());

    public LimitedAgeMemoryCache(MemoryCacheAware memoryCacheAware, long l2) {
        this.cache = memoryCacheAware;
        this.maxAge = l2 * 1000L;
    }

    @Override
    public boolean put(String string2, Bitmap bitmap) {
        boolean bl = this.cache.put(string2, bitmap);
        if (bl) {
            this.loadingDates.put(string2, System.currentTimeMillis());
        }
        return bl;
    }

    @Override
    public Bitmap get(String string2) {
        Long l2 = this.loadingDates.get(string2);
        if (l2 != null && System.currentTimeMillis() - l2 > this.maxAge) {
            LimitedAgeMemoryCache limitedAgeMemoryCache = this;
            limitedAgeMemoryCache.cache.remove(string2);
            limitedAgeMemoryCache.loadingDates.remove(string2);
        }
        return this.cache.get(string2);
    }

    @Override
    public Bitmap remove(String string2) {
        LimitedAgeMemoryCache limitedAgeMemoryCache = this;
        limitedAgeMemoryCache.loadingDates.remove(string2);
        return limitedAgeMemoryCache.cache.remove(string2);
    }

    @Override
    public Collection<String> keys() {
        return this.cache.keys();
    }

    @Override
    public void clear() {
        LimitedAgeMemoryCache limitedAgeMemoryCache = this;
        limitedAgeMemoryCache.cache.clear();
        limitedAgeMemoryCache.loadingDates.clear();
    }
}

