/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.cache.disc;

import com.nostra13.dcloudimageloader.cache.disc.BaseDiscCache;
import com.nostra13.dcloudimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.dcloudimageloader.core.DefaultConfigurationFactory;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class LimitedDiscCache
extends BaseDiscCache {
    private static final int INVALID_SIZE = -1;
    private final AtomicInteger cacheSize;
    private final int sizeLimit;
    private final Map<File, Long> lastUsageDates = Collections.synchronizedMap(new HashMap());

    public LimitedDiscCache(File file, int n2) {
        this(file, DefaultConfigurationFactory.createFileNameGenerator(), n2);
    }

    public LimitedDiscCache(File file, FileNameGenerator fileNameGenerator, int n2) {
        super(file, fileNameGenerator);
        this.sizeLimit = n2;
        this.cacheSize = new AtomicInteger();
        this.calculateCacheSizeAndFillUsageMap();
    }

    private void calculateCacheSizeAndFillUsageMap() {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                int n2 = 0;
                File[] fileArray = LimitedDiscCache.this.cacheDir.listFiles();
                if (fileArray != null) {
                    for (File file : fileArray) {
                        int n3 = n2 + LimitedDiscCache.this.getSize(file);
                        File file2 = file;
                        LimitedDiscCache.this.lastUsageDates.put(file2, file2.lastModified());
                        n2 = n3;
                    }
                    LimitedDiscCache.this.cacheSize.set(n2);
                }
            }
        };
        new Thread(runnable2).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int removeNext() {
        int n2;
        block19: {
            if (this.lastUsageDates.isEmpty()) {
                return -1;
            }
            Long l2 = null;
            File file = null;
            Map<File, Long> map = this.lastUsageDates;
            synchronized (map) {
                Iterator<Map.Entry<File, Long>> iterator = this.lastUsageDates.entrySet().iterator();
                while (true) {
                    Long l3;
                    block18: {
                        block17: {
                            Map.Entry<File, Long> entry;
                            block16: {
                                if (!iterator.hasNext()) break;
                                entry = iterator.next();
                                if (file != null) break block16;
                                Map.Entry<File, Long> entry2 = entry;
                                Map.Entry<File, Long> entry3 = entry2;
                                file = entry2.getKey();
                                l2 = entry3.getValue();
                                break block17;
                            }
                            l3 = entry.getValue();
                            if (l3 >= l2) break block17;
                            file = entry.getKey();
                            break block18;
                        }
                        l3 = l2;
                    }
                    l2 = l3;
                }
                // MONITOREXIT @DISABLED, blocks:[8, 9] lbl33 : MonitorExitStatement: MONITOREXIT : var3_4
                n2 = 0;
                if (file == null) break block19;
            }
            if (file.exists()) {
                n2 = this.getSize(file);
                if (file.delete()) {
                    this.lastUsageDates.remove(file);
                }
            } else {
                this.lastUsageDates.remove(file);
            }
        }
        return n2;
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    @Override
    public void put(String string2, File file) {
        int n2;
        LimitedDiscCache limitedDiscCache = l2;
        int n3 = limitedDiscCache.getSize(file);
        int n4 = limitedDiscCache.cacheSize.get();
        while (n4 + n3 > ((LimitedDiscCache)((Object)l2)).sizeLimit && (n2 = ((LimitedDiscCache)((Object)l2)).removeNext()) != -1) {
            n4 = ((LimitedDiscCache)((Object)l2)).cacheSize.addAndGet(-n2);
        }
        LimitedDiscCache limitedDiscCache2 = l2;
        ((LimitedDiscCache)((Object)l2)).cacheSize.addAndGet(n3);
        Long l2 = System.currentTimeMillis();
        file.setLastModified(l2);
        limitedDiscCache2.lastUsageDates.put(file, l2);
    }

    @Override
    public File get(String object) {
        object = super.get((String)object);
        LimitedDiscCache limitedDiscCache = l2;
        Long l2 = System.currentTimeMillis();
        ((File)object).setLastModified(l2);
        limitedDiscCache.lastUsageDates.put((File)object, l2);
        return object;
    }

    @Override
    public void clear() {
        LimitedDiscCache limitedDiscCache = this;
        limitedDiscCache.lastUsageDates.clear();
        limitedDiscCache.cacheSize.set(0);
        super.clear();
    }

    protected abstract int getSize(File var1);
}

