/*
 * Decompiled with CFR 0.152.
 */
package com.dmcbig.mediapicker.adapter;

import android.content.ContentUris;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.provider.MediaStore;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.dcloud.android.widget.toast.ToastCompat;
import com.dmcbig.mediapicker.MediaPickerR;
import com.dmcbig.mediapicker.PickerConfig;
import com.dmcbig.mediapicker.entity.Media;
import com.dmcbig.mediapicker.utils.FileUtils;
import com.dmcbig.mediapicker.utils.ScreenUtils;
import java.util.ArrayList;

public class MediaGridAdapter
extends RecyclerView.Adapter<MyViewHolder> {
    ArrayList<Media> medias;
    Context context;
    FileUtils fileUtils;
    ArrayList<Media> selectMedias;
    long maxSelect;
    long maxSize;
    boolean isSingle;
    private OnRecyclerViewItemClickListener mOnItemClickListener;
    private OnPickerSelectMaxListener mOnMaxListener;

    public MediaGridAdapter(ArrayList<Media> arrayList, Context context, ArrayList<Media> arrayList2, int n2, long l2, boolean bl) {
        ArrayList arrayList3;
        FileUtils fileUtils;
        Object object = fileUtils;
        fileUtils = new FileUtils();
        this.fileUtils = object;
        object = arrayList3;
        arrayList3 = new ArrayList();
        this.selectMedias = object;
        this.isSingle = false;
        this.mOnItemClickListener = null;
        this.mOnMaxListener = null;
        if (arrayList2 != null) {
            this.selectMedias = arrayList2;
        }
        this.maxSelect = n2;
        this.maxSize = l2;
        this.medias = arrayList;
        this.context = context;
        this.isSingle = bl;
    }

    int getItemWidth() {
        int n2 = PickerConfig.GridSpanCount;
        return ScreenUtils.getScreenWidth(this.context) / n2 - n2;
    }

    public MyViewHolder onCreateViewHolder(ViewGroup viewGroup, int n2) {
        viewGroup = LayoutInflater.from((Context)viewGroup.getContext()).inflate(MediaPickerR.MP_LAYOUT_MEDIA_VIEW_ITEM, viewGroup, false);
        return new MyViewHolder((View)viewGroup);
    }

    public void onBindViewHolder(final MyViewHolder myViewHolder, int n2) {
        final Media media = this.medias.get(n2);
        Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        int n3 = media.mediaType;
        if (n3 != 1 && n3 == 3) {
            uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
        }
        uri = ContentUris.withAppendedId((Uri)uri, (long)media.id);
        Glide.with((Context)this.context).load(uri).into(myViewHolder.media_image);
        if (media.mediaType == 3) {
            MyViewHolder myViewHolder2 = myViewHolder;
            myViewHolder2.gif_info.setVisibility(4);
            myViewHolder2.video_info.setVisibility(0);
            myViewHolder2.textView_size.setText((CharSequence)this.fileUtils.getSizeByUnit(media.size));
        } else {
            MyViewHolder myViewHolder3 = myViewHolder;
            myViewHolder3.video_info.setVisibility(4);
            uri = myViewHolder3.gif_info;
            n3 = ".gif".equalsIgnoreCase(media.extension) ? 0 : 4;
            uri.setVisibility(n3);
        }
        MediaGridAdapter mediaGridAdapter = this;
        int n4 = mediaGridAdapter.isSelect(media);
        if (!mediaGridAdapter.isSingle) {
            View view = myViewHolder.mask_view;
            int n5 = n4 >= 0 ? 0 : 4;
            view.setVisibility(n5);
            ImageView imageView = myViewHolder.check_image;
            view = n4 >= 0 ? ContextCompat.getDrawable((Context)this.context, (int)MediaPickerR.MP_DRAWABLE_BNT_SELECTED) : ContextCompat.getDrawable((Context)this.context, (int)MediaPickerR.MP_DRAWABLE_BNT_UNSELECTED);
            imageView.setImageDrawable((Drawable)view);
        } else {
            MyViewHolder myViewHolder4 = myViewHolder;
            myViewHolder4.check_image.setVisibility(8);
            myViewHolder4.mask_view.setVisibility(8);
        }
        myViewHolder.media_image.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MediaGridAdapter mediaGridAdapter = media2.MediaGridAdapter.this;
                if (mediaGridAdapter.isSingle) {
                    mediaGridAdapter.mOnItemClickListener.onItemClick(view, media2.media, null);
                    return;
                }
                int n2 = mediaGridAdapter.isSelect(media2.media);
                MediaGridAdapter mediaGridAdapter2 = media2.MediaGridAdapter.this;
                if ((long)media2.MediaGridAdapter.this.selectMedias.size() >= mediaGridAdapter2.maxSelect && n2 < 0) {
                    if (mediaGridAdapter2.mOnMaxListener != null) {
                        media2.MediaGridAdapter.this.mOnMaxListener.onMaxed();
                    }
                } else if (media2.media.size > mediaGridAdapter2.maxSize) {
                    ToastCompat.makeText(mediaGridAdapter2.context, media2.MediaGridAdapter.this.context.getString(MediaPickerR.MP_STRING_MSG_SIZE_LIMIT) + FileUtils.fileSize(media2.MediaGridAdapter.this.maxSize), 1).show();
                } else {
                    mediaGridAdapter2 = media2.myViewHolder.mask_view;
                    int n3 = n2 >= 0 ? 4 : 0;
                    mediaGridAdapter2.setVisibility(n3);
                    ImageView imageView = media2.myViewHolder.check_image;
                    mediaGridAdapter2 = n2 >= 0 ? ContextCompat.getDrawable((Context)media2.MediaGridAdapter.this.context, (int)MediaPickerR.MP_DRAWABLE_BNT_UNSELECTED) : ContextCompat.getDrawable((Context)media2.MediaGridAdapter.this.context, (int)MediaPickerR.MP_DRAWABLE_BNT_SELECTED);
                    1 v0 = media2;
                    imageView.setImageDrawable((Drawable)mediaGridAdapter2);
                    v0.MediaGridAdapter.this.setSelectMedias(media2.media);
                    1 v1 = media2;
                    Media media2 = v1.media;
                    v0.MediaGridAdapter.this.mOnItemClickListener.onItemClick(view, media2, v1.MediaGridAdapter.this.selectMedias);
                }
            }
        });
    }

    public void setSelectMedias(Media media) {
        int n2 = this.isSelect(media);
        if (n2 == -1) {
            this.selectMedias.add(media);
        } else {
            this.selectMedias.remove(n2);
        }
    }

    public int isSelect(Media media) {
        int n2;
        block2: {
            int n3 = -1;
            if (this.selectMedias.size() <= 0) {
                return n3;
            }
            for (n2 = 0; n2 < this.selectMedias.size(); ++n2) {
                Media media2 = this.selectMedias.get(n2);
                if (!media2.path.equals(media.path)) continue;
                media2.id = media.id;
                break block2;
            }
            n2 = n3;
        }
        return n2;
    }

    public void updateSelectAdapter(ArrayList<Media> arrayList) {
        if (arrayList != null) {
            this.selectMedias = arrayList;
        }
        this.notifyDataSetChanged();
    }

    public void updateAdapter(ArrayList<Media> arrayList) {
        this.medias = arrayList;
        this.notifyDataSetChanged();
    }

    public ArrayList<Media> getMedias() {
        return this.medias;
    }

    public void setOnItemClickListener(OnRecyclerViewItemClickListener onRecyclerViewItemClickListener) {
        this.mOnItemClickListener = onRecyclerViewItemClickListener;
    }

    public void setOnMaxListener(OnPickerSelectMaxListener onPickerSelectMaxListener) {
        this.mOnMaxListener = onPickerSelectMaxListener;
    }

    public ArrayList<Media> getSelectMedias() {
        return this.selectMedias;
    }

    public int getItemCount() {
        return this.medias.size();
    }

    public int getItemIndex(Object object) {
        return this.medias.indexOf(object);
    }

    public static interface OnPickerSelectMaxListener {
        public void onMaxed();
    }

    public static interface OnRecyclerViewItemClickListener {
        public void onItemClick(View var1, Media var2, ArrayList<Media> var3);
    }

    public class MyViewHolder
    extends RecyclerView.ViewHolder {
        public ImageView media_image;
        public ImageView check_image;
        public View mask_view;
        public TextView textView_size;
        public RelativeLayout gif_info;
        public RelativeLayout video_info;

        public MyViewHolder(View view) {
            super(view);
            this.media_image = (ImageView)view.findViewById(MediaPickerR.MP_ID_MEDIA_IMAGE);
            this.check_image = (ImageView)view.findViewById(MediaPickerR.MP_ID_CHECK_IMAGE);
            this.mask_view = view.findViewById(MediaPickerR.MP_ID_MASK_VIEW);
            this.video_info = (RelativeLayout)view.findViewById(MediaPickerR.MP_ID_VIDEO_INFO);
            this.gif_info = (RelativeLayout)view.findViewById(MediaPickerR.MP_ID_GIF_INFO);
            this.textView_size = (TextView)view.findViewById(MediaPickerR.MP_ID_TEXTVIEW_SIZE);
            this.itemView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, MediaGridAdapter.this.getItemWidth()));
        }
    }
}

