/*
 * Decompiled with CFR 0.152.
 */
package com.dmcbig.mediapicker.adapter;

import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.bumptech.glide.Glide;
import com.dmcbig.mediapicker.MediaPickerR;
import com.dmcbig.mediapicker.entity.Folder;
import com.dmcbig.mediapicker.entity.Media;
import java.util.ArrayList;

public class FolderAdapter
extends BaseAdapter {
    ArrayList<Folder> folders;
    private LayoutInflater mInflater;
    private Context mContext;
    int lastSelected = 0;

    public FolderAdapter(ArrayList<Folder> arrayList, Context context) {
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.folders = arrayList;
        this.mContext = context;
    }

    public int getCount() {
        return this.folders.size();
    }

    public Folder getItem(int n2) {
        return this.folders.get(n2);
    }

    public long getItemId(int n2) {
        return 0L;
    }

    public void updateAdapter(ArrayList<Folder> arrayList) {
        this.folders = arrayList;
        this.notifyDataSetChanged();
    }

    public View getView(int n2, View view, ViewGroup object) {
        if (view == null) {
            ViewHolder viewHolder;
            view = folderAdapter2.mInflater.inflate(MediaPickerR.MP_LAYOUT_FOLDERS_VIEW_ITME, object, false);
            object = viewHolder;
            viewHolder = folderAdapter2.new ViewHolder(view);
        } else {
            object = (ViewHolder)view.getTag();
        }
        Folder folder = folderAdapter2.getItem(n2);
        if (folder.getMedias().size() > 0) {
            Media media = folder.getMedias().get(0);
            Glide.with((Context)folderAdapter2.mContext).load(Uri.parse((String)("file://" + media.path))).into(object.cover);
        } else {
            object.cover.setImageDrawable(ContextCompat.getDrawable((Context)folderAdapter2.mContext, (int)MediaPickerR.MP_DRAWABLE_DEFAULT_IMAGE));
        }
        FolderAdapter folderAdapter = folderAdapter2;
        Object object2 = object;
        object2.name.setText((CharSequence)folder.name);
        object2.size.setText((CharSequence)(folder.getMedias().size() + "" + folderAdapter2.mContext.getString(MediaPickerR.MP_STRING_COUNT_STRING)));
        FolderAdapter folderAdapter2 = object2.indicator;
        n2 = folderAdapter.lastSelected == n2 ? 0 : 4;
        folderAdapter2.setVisibility(n2);
        return view;
    }

    public void setSelectIndex(int n2) {
        if (this.lastSelected == n2) {
            return;
        }
        this.lastSelected = n2;
        this.notifyDataSetChanged();
    }

    public ArrayList<Media> getSelectMedias() {
        return this.folders.get(this.lastSelected).getMedias();
    }

    class ViewHolder {
        ImageView cover;
        ImageView indicator;
        TextView name;
        TextView path;
        TextView size;

        ViewHolder(View view) {
            this.cover = (ImageView)view.findViewById(MediaPickerR.MP_ID_COVER);
            this.name = (TextView)view.findViewById(MediaPickerR.MP_ID_NAME);
            this.path = (TextView)view.findViewById(MediaPickerR.MP_ID_PATH);
            this.size = (TextView)view.findViewById(MediaPickerR.MP_ID_SIZE);
            this.indicator = (ImageView)view.findViewById(MediaPickerR.MP_ID_INDICATOR);
            view.setTag((Object)this);
        }
    }
}

