/*
 * Decompiled with CFR 0.152.
 */
package com.dmcbig.mediapicker;

import android.app.Activity;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.TextView;
import androidtranscoder.MediaTranscoder;
import androidtranscoder.format.MediaFormatStrategyPresets;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.dcloud.android.widget.toast.ToastCompat;
import com.dmcbig.mediapicker.MediaPickerR;
import com.dmcbig.mediapicker.PickerConfig;
import com.dmcbig.mediapicker.PreviewActivity;
import com.dmcbig.mediapicker.adapter.FolderAdapter;
import com.dmcbig.mediapicker.adapter.MediaGridAdapter;
import com.dmcbig.mediapicker.adapter.SpacingDecoration;
import com.dmcbig.mediapicker.data.DataCallback;
import com.dmcbig.mediapicker.data.ImageLoader;
import com.dmcbig.mediapicker.data.MediaLoader;
import com.dmcbig.mediapicker.data.VideoLoader;
import com.dmcbig.mediapicker.entity.Folder;
import com.dmcbig.mediapicker.entity.Media;
import com.dmcbig.mediapicker.utils.ScreenUtils;
import io.dcloud.base.R;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.CompressUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.RuningAcitvityUtil;
import io.dcloud.common.util.ThreadPool;
import io.dcloud.common.util.language.LanguageUtil;
import io.dcloud.feature.gallery.imageedit.IMGEditActivity;
import io.dcloud.js.gallery.GalleryFeatureImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class PickerActivity
extends FragmentActivity
implements DataCallback,
View.OnClickListener {
    Intent argsIntent;
    RecyclerView recyclerView;
    Button done;
    Button category_btn;
    Button preview;
    ImageView fullImage;
    MediaGridAdapter gridAdapter;
    ListPopupWindow mFolderPopupWindow;
    private FolderAdapter mFolderAdapter;
    boolean isSingle = false;
    String doneBtnText = "";
    String cropOptions;
    String docPath;
    boolean isCompress = false;
    Iterator<Media> selectIterator;
    private boolean isFinish = false;

    private void setTopAndBottomBarColor() {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(Color.parseColor((String)"#21282C"));
            window.setNavigationBarColor(Color.parseColor((String)"#21282C"));
        }
    }

    private void getOtherArgs() {
        String string2;
        this.doneBtnText = string2 = this.argsIntent.getStringExtra("done_button_text");
        if (!PdrUtil.isEmpty(string2)) {
            this.done.setText((CharSequence)this.doneBtnText);
        }
        if (!PdrUtil.isEmpty(this.cropOptions)) {
            PickerActivity pickerActivity = this;
            pickerActivity.done.setVisibility(4);
            pickerActivity.findViewById(MediaPickerR.MP_ID_PREVIEW).setVisibility(4);
            pickerActivity.isCompress = false;
            pickerActivity.findViewById(R.id.check_origin_image_layout).setVisibility(8);
        }
    }

    private void compress(final ArrayList<Media> arrayList) {
        block5: {
            block4: {
                Runnable runnable;
                block6: {
                    Media media;
                    block7: {
                        block8: {
                            if (this.isFinishing() || this.isDestroyed()) break block5;
                            if (!this.selectIterator.hasNext()) break block6;
                            media = this.selectIterator.next();
                            if (media.extension.equalsIgnoreCase(".png") || media.extension.equalsIgnoreCase(".jpg") || media.extension.equalsIgnoreCase(".jpeg")) break block7;
                            if (media.mediaType != 3) break block8;
                            final String string2 = this.docPath.endsWith("/") ? this.docPath + "compress_video_" + SystemClock.elapsedRealtime() + ".mp4" : this.docPath + "/compress_video_" + SystemClock.elapsedRealtime() + ".mp4";
                            try {
                                new File(string2).getParentFile().mkdirs();
                            }
                            catch (Exception exception) {
                                this.compress(arrayList);
                                break block4;
                            }
                            MediaTranscoder.getInstance().transcodeVideo(media.path, string2, MediaFormatStrategyPresets.createAndroid720pStrategy(2, 1.0), new MediaTranscoder.Listener(){

                                @Override
                                public void onTranscodeProgress(double d2) {
                                }

                                @Override
                                public void onTranscodeCompleted() {
                                    media.path = string2;
                                    PickerActivity.this.compress(arrayList);
                                }

                                @Override
                                public void onTranscodeCanceled() {
                                    PickerActivity.this.compress(arrayList);
                                }

                                @Override
                                public void onTranscodeFailed(Exception exception) {
                                    PickerActivity.this.compress(arrayList);
                                }
                            });
                            break block4;
                        }
                        this.compress(arrayList);
                        break block4;
                    }
                    Media media2 = media;
                    String[] stringArray = media2.path.split("/");
                    String string3 = this.docPath + "uniapp_temp/compressed/" + System.currentTimeMillis() + "_" + stringArray[stringArray.length - 1];
                    if (!TextUtils.isEmpty((CharSequence)(string3 = CompressUtil.compressImage(media2.path, string3, media.extension.equalsIgnoreCase(".png"), (Context)this)))) {
                        media.path = string3;
                    }
                    this.compress(arrayList);
                    break block4;
                }
                Runnable runnable2 = runnable;
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        Intent intent;
                        5 v0 = this;
                        Intent intent2 = intent;
                        intent2();
                        intent.putParcelableArrayListExtra("select_result", arrayList);
                        v0.PickerActivity.this.setResult(19901026, intent2);
                        v0.PickerActivity.this.finish();
                    }
                };
                this.runOnUiThread(runnable2);
            }
            return;
        }
    }

    protected void onCreate(@Nullable Bundle object) {
        PickerActivity pickerActivity = this;
        super.onCreate((Bundle)object);
        pickerActivity.requestWindowFeature(1);
        pickerActivity.argsIntent = pickerActivity.getIntent();
        pickerActivity.setContentView(MediaPickerR.MP_LAYOUT_PICKER_MAIN);
        pickerActivity.recyclerView = (RecyclerView)pickerActivity.findViewById(MediaPickerR.MP_ID_RECYCLER_VIEW);
        pickerActivity.findViewById(MediaPickerR.MP_ID_BTN_BACK).setOnClickListener((View.OnClickListener)this);
        pickerActivity.setTitleBar();
        pickerActivity.done = (Button)pickerActivity.findViewById(MediaPickerR.MP_ID_DONE);
        pickerActivity.category_btn = (Button)pickerActivity.findViewById(MediaPickerR.MP_ID_CATEGORY_BTN);
        pickerActivity.preview = (Button)pickerActivity.findViewById(MediaPickerR.MP_ID_PREVIEW);
        pickerActivity.fullImage = (ImageView)pickerActivity.findViewById(R.id.check_origin_image);
        if (pickerActivity.argsIntent.getIntExtra("select_mode", 101) == 102) {
            boolean bl;
            PickerActivity pickerActivity2 = this;
            pickerActivity2.isCompress = bl = pickerActivity2.argsIntent.getBooleanExtra("COMPRESSED", false);
            pickerActivity2.fullImage.setSelected(bl ^ true);
            pickerActivity2.findViewById(R.id.check_origin_image_layout).setVisibility(8);
        } else {
            object = this.argsIntent;
            if (object != null && object.hasExtra("size_type")) {
                object = this.argsIntent.getStringExtra("size_type");
                if (object != null) {
                    if (((String)object).contains("original") && ((String)object).contains("compressed")) {
                        this.isCompress = true;
                        this.findViewById(R.id.check_origin_image_layout).setOnClickListener((View.OnClickListener)this);
                    } else if (((String)object).contains("original")) {
                        this.isCompress = false;
                        this.fullImage.setSelected(true);
                    } else {
                        this.isCompress = true;
                        this.findViewById(R.id.check_origin_image_layout).setVisibility(8);
                    }
                } else {
                    this.isCompress = true;
                    this.findViewById(R.id.check_origin_image_layout).setOnClickListener((View.OnClickListener)this);
                }
            } else {
                this.isCompress = true;
                this.findViewById(R.id.check_origin_image_layout).setOnClickListener((View.OnClickListener)this);
            }
        }
        PickerActivity pickerActivity3 = this;
        pickerActivity3.done.setOnClickListener((View.OnClickListener)this);
        pickerActivity3.category_btn.setOnClickListener((View.OnClickListener)this);
        pickerActivity3.preview.setOnClickListener((View.OnClickListener)this);
        if (BaseInfo.sGlobalFullScreen) {
            PickerActivity pickerActivity4 = this;
            pickerActivity4.setFullScreen((Activity)pickerActivity4, true);
        }
        PickerActivity pickerActivity5 = this;
        pickerActivity5.cropOptions = pickerActivity5.argsIntent.getStringExtra("image_crop");
        pickerActivity5.docPath = pickerActivity5.argsIntent.getStringExtra("doc_path");
        pickerActivity5.createAdapter();
        pickerActivity5.createFolderAdapter();
        pickerActivity5.getMediaData();
        pickerActivity5.getOtherArgs();
        pickerActivity5.setTopAndBottomBarColor();
    }

    protected void attachBaseContext(Context context) {
        if (Build.VERSION.SDK_INT < 26) {
            super.attachBaseContext(context);
        } else {
            super.attachBaseContext(LanguageUtil.updateContextLanguageAfterO(context, false));
        }
    }

    public void setTitleBar() {
        int n2 = this.argsIntent.getIntExtra("select_mode", 101);
        if (n2 == 101) {
            ((TextView)this.findViewById(MediaPickerR.MP_ID_BAR_TITLE)).setText((CharSequence)this.getString(MediaPickerR.MP_STRING_SELECT_TITLE));
        } else if (n2 == 100) {
            ((TextView)this.findViewById(MediaPickerR.MP_ID_BAR_TITLE)).setText((CharSequence)this.getString(MediaPickerR.MP_STRING_SELECT_IMAGE_TITLE));
        } else if (n2 == 102) {
            ((TextView)this.findViewById(MediaPickerR.MP_ID_BAR_TITLE)).setText((CharSequence)this.getString(MediaPickerR.MP_STRING_SELECT_VIDEO_TITLE));
        }
    }

    void createAdapter() {
        ArrayList arrayList;
        GridLayoutManager gridLayoutManager;
        PickerActivity pickerActivity = this;
        Object object = gridLayoutManager;
        gridLayoutManager = new GridLayoutManager((Context)this, PickerConfig.GridSpanCount);
        pickerActivity.recyclerView.setLayoutManager((RecyclerView.LayoutManager)object);
        pickerActivity.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SpacingDecoration(PickerConfig.GridSpanCount, PickerConfig.GridSpace));
        pickerActivity.recyclerView.setHasFixedSize(true);
        object = arrayList;
        arrayList = new ArrayList();
        ArrayList arrayList2 = pickerActivity.argsIntent.getParcelableArrayListExtra("default_list");
        final String string2 = pickerActivity.argsIntent.getStringExtra("select_max_cb_id");
        int n2 = pickerActivity.argsIntent.getIntExtra("max_select_count", Integer.MAX_VALUE);
        long l2 = pickerActivity.argsIntent.getLongExtra("max_select_size", Long.MAX_VALUE);
        pickerActivity.isSingle = pickerActivity.argsIntent.getBooleanExtra("single_select", false);
        if (!TextUtils.isEmpty((CharSequence)pickerActivity.cropOptions)) {
            this.isSingle = true;
        }
        if (this.isSingle) {
            Button button = this.done;
            if (button != null) {
                button.setVisibility(8);
            }
            if ((button = this.preview) != null) {
                button.setVisibility(4);
            }
        }
        boolean bl = this.isSingle;
        this.gridAdapter = new MediaGridAdapter((ArrayList<Media>)object, (Context)this, arrayList2, n2, l2, bl);
        this.gridAdapter.setOnMaxListener(new MediaGridAdapter.OnPickerSelectMaxListener(){

            @Override
            public void onMaxed() {
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    GalleryFeatureImpl.onMaxed((Context)PickerActivity.this, string2);
                }
            }
        });
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.gridAdapter);
    }

    void createFolderAdapter() {
        ArrayList<Folder> arrayList;
        PickerActivity pickerActivity = this;
        ArrayList<Folder> arrayList2 = arrayList;
        arrayList = new ArrayList<Folder>();
        pickerActivity.mFolderAdapter = new FolderAdapter(arrayList2, (Context)this);
        this.mFolderPopupWindow = new ListPopupWindow((Context)this);
        this.mFolderPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(-1));
        pickerActivity.mFolderPopupWindow.setAdapter((ListAdapter)this.mFolderAdapter);
        pickerActivity.mFolderPopupWindow.setHeight((int)((double)ScreenUtils.getScreenHeight((Context)this) * 0.6));
        pickerActivity.mFolderPopupWindow.setAnchorView(this.findViewById(MediaPickerR.MP_ID_FOOTER));
        pickerActivity.mFolderPopupWindow.setModal(true);
        pickerActivity.mFolderPopupWindow.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
                2 v0 = object;
                v0.PickerActivity.this.mFolderAdapter.setSelectIndex(n2);
                Object object = v0.PickerActivity.this;
                ((PickerActivity)object).category_btn.setText((CharSequence)((PickerActivity)object).mFolderAdapter.getItem((int)n2).name);
                object = v0.PickerActivity.this;
                ((PickerActivity)object).gridAdapter.updateAdapter(((PickerActivity)object).mFolderAdapter.getSelectMedias());
                v0.PickerActivity.this.mFolderPopupWindow.dismiss();
            }
        });
    }

    void getMediaData() {
        int n2 = this.argsIntent.getIntExtra("select_mode", 101);
        if (n2 == 101) {
            MediaLoader mediaLoader;
            MediaLoader mediaLoader2 = mediaLoader;
            PickerActivity pickerActivity = this;
            mediaLoader = new MediaLoader((Context)pickerActivity, pickerActivity);
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)mediaLoader2);
        } else if (n2 == 100) {
            ImageLoader imageLoader;
            ImageLoader imageLoader2 = imageLoader;
            PickerActivity pickerActivity = this;
            imageLoader = new ImageLoader((Context)pickerActivity, pickerActivity);
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)imageLoader2);
        } else if (n2 == 102) {
            VideoLoader videoLoader;
            VideoLoader videoLoader2 = videoLoader;
            PickerActivity pickerActivity = this;
            videoLoader = new VideoLoader((Context)pickerActivity, pickerActivity);
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)videoLoader2);
        }
    }

    @Override
    public void onData(ArrayList<Folder> arrayList) {
        PickerActivity pickerActivity = this;
        pickerActivity.setView(arrayList);
        pickerActivity.category_btn.setText((CharSequence)arrayList.get((int)0).name);
        pickerActivity.mFolderAdapter.updateAdapter(arrayList);
    }

    void setView(ArrayList<Folder> arrayList) {
        PickerActivity pickerActivity = this;
        pickerActivity.gridAdapter.updateAdapter(arrayList.get(0).getMedias());
        pickerActivity.setButtonText();
        pickerActivity.gridAdapter.setOnItemClickListener(new MediaGridAdapter.OnRecyclerViewItemClickListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onItemClick(View object, Media media, ArrayList<Media> arrayList) {
                ArrayList arrayList2;
                object = arrayList6.PickerActivity.this;
                if (!((PickerActivity)object).isSingle) {
                    ((PickerActivity)object).setButtonText();
                    return;
                }
                if (PdrUtil.isEmpty(((PickerActivity)object).cropOptions)) {
                    ArrayList<Integer> arrayList3;
                    ArrayList<Media> arrayList4;
                    Intent intent;
                    Object object2 = object = intent;
                    object((Context)arrayList6.PickerActivity.this, PreviewActivity.class);
                    object2.putExtra("max_select_count", arrayList6.PickerActivity.this.argsIntent.getIntExtra("max_select_count", Integer.MAX_VALUE));
                    object2.putExtra("single_select", true);
                    arrayList = arrayList4;
                    arrayList(1);
                    arrayList4.add(media);
                    ArrayList<Integer> arrayList5 = arrayList3;
                    arrayList5();
                    arrayList3.add(arrayList6.PickerActivity.this.gridAdapter.getItemIndex(media));
                    object2.putExtra("pre_raw_List", arrayList);
                    object.putExtra("FULL_IMAGE", arrayList6.PickerActivity.this.fullImage.isSelected());
                    object.putExtra("size_type", arrayList6.PickerActivity.this.argsIntent.getStringExtra("size_type"));
                    intent.putExtra("select_mode", arrayList6.PickerActivity.this.argsIntent.getIntExtra("select_mode", 101));
                    intent.putIntegerArrayListExtra("original_preview_index", arrayList5);
                    arrayList6.PickerActivity.this.startActivityForResult((Intent)object, 200);
                    return;
                }
                if (!".gif".equalsIgnoreCase(media.extension) && media.mediaType != 3) {
                    Intent intent;
                    Object object3 = object = intent;
                    object((Context)arrayList6.PickerActivity.this, IMGEditActivity.class);
                    int n2 = arrayList6.PickerActivity.this.gridAdapter.getItemIndex(media);
                    object.putExtra("IMAGE_URI", (Parcelable)Uri.parse((String)("file://" + media.path)));
                    object3.putExtra("IMAGE_MEDIA_ID", media.id);
                    object3.putExtra("IMAGE_INDEX", n2);
                    intent.putExtra("IMAGE_CROP", arrayList6.PickerActivity.this.cropOptions);
                    arrayList6.PickerActivity.this.startActivityForResult((Intent)object, 201);
                    return;
                }
                3 v6 = arrayList6;
                ArrayList<Media> arrayList6 = arrayList2;
                arrayList6();
                arrayList2.add(media);
                v6.PickerActivity.this.done(arrayList6);
            }
        });
    }

    void setButtonText() {
        PickerActivity pickerActivity = this;
        int n2 = pickerActivity.argsIntent.getIntExtra("max_select_count", Integer.MAX_VALUE);
        if (PdrUtil.isEmpty(pickerActivity.doneBtnText)) {
            this.doneBtnText = this.getString(MediaPickerR.MP_STRING_DONE);
        }
        if (n2 == Integer.MAX_VALUE) {
            this.done.setText((CharSequence)(this.doneBtnText + "(" + this.gridAdapter.getSelectMedias().size() + ")"));
        } else {
            this.done.setText((CharSequence)(this.doneBtnText + "(" + this.gridAdapter.getSelectMedias().size() + "/" + n2 + ")"));
        }
        if (PdrUtil.isEmpty(this.cropOptions)) {
            this.preview.setText((CharSequence)(this.getString(MediaPickerR.MP_STRING_PREVIEW) + "(" + this.gridAdapter.getSelectMedias().size() + ")"));
        } else {
            PickerActivity pickerActivity2 = this;
            pickerActivity2.done.setVisibility(4);
            pickerActivity2.findViewById(MediaPickerR.MP_ID_PREVIEW).setVisibility(4);
        }
    }

    public void onClick(View view) {
        ArrayList arrayList2;
        int n2 = view.getId();
        if (n2 == MediaPickerR.MP_ID_BTN_BACK) {
            ArrayList arrayList;
            PickerActivity pickerActivity = arrayList2;
            arrayList2 = arrayList;
            arrayList = new ArrayList();
            pickerActivity.done(arrayList2);
        } else if (n2 == MediaPickerR.MP_ID_CATEGORY_BTN) {
            if (((PickerActivity)((Object)arrayList2)).mFolderPopupWindow.isShowing()) {
                ((PickerActivity)((Object)arrayList2)).mFolderPopupWindow.dismiss();
            } else {
                ((PickerActivity)((Object)arrayList2)).mFolderPopupWindow.show();
            }
        } else if (n2 == MediaPickerR.MP_ID_DONE) {
            Object object = arrayList2;
            ((PickerActivity)object).done(((PickerActivity)object).gridAdapter.getSelectMedias());
        } else if (n2 == MediaPickerR.MP_ID_PREVIEW) {
            if (((PickerActivity)((Object)arrayList2)).gridAdapter.getSelectMedias().size() <= 0) {
                Object object = arrayList2;
                ToastCompat.makeText((Context)object, object.getString(MediaPickerR.MP_STRING_SELECT_NULL), 0).show();
                return;
            }
            if (PdrUtil.isEmpty(((PickerActivity)((Object)arrayList2)).cropOptions)) {
                ArrayList<Integer> arrayList;
                Intent intent;
                Intent intent2 = intent;
                intent2((Context)arrayList2, PreviewActivity.class);
                intent.putExtra("max_select_count", ((PickerActivity)((Object)arrayList2)).argsIntent.getIntExtra("max_select_count", Integer.MAX_VALUE));
                ArrayList<Integer> arrayList3 = ((PickerActivity)((Object)arrayList2)).gridAdapter.getSelectMedias();
                ArrayList<Integer> arrayList4 = arrayList3;
                intent2.putExtra("pre_raw_List", arrayList4);
                arrayList4 = arrayList;
                arrayList = new ArrayList<Integer>();
                for (Media media : arrayList3) {
                    arrayList4.add(((PickerActivity)((Object)arrayList2)).gridAdapter.getItemIndex(media));
                }
                Intent intent3 = intent2;
                Intent intent4 = intent2;
                intent2.putExtra("FULL_IMAGE", ((PickerActivity)((Object)arrayList2)).fullImage.isSelected());
                intent4.putExtra("size_type", ((PickerActivity)((Object)arrayList2)).argsIntent.getStringExtra("size_type"));
                intent4.putIntegerArrayListExtra("original_preview_index", arrayList4);
                intent2.putExtra("image_editable", ((PickerActivity)((Object)arrayList2)).argsIntent.getBooleanExtra("image_editable", true));
                intent2.putExtra("done_button_text", ((PickerActivity)((Object)arrayList2)).argsIntent.getStringExtra("done_button_text"));
                intent3.putExtra("select_mode", ((PickerActivity)((Object)arrayList2)).argsIntent.getIntExtra("select_mode", 101));
                arrayList2.startActivityForResult(intent3, 200);
            }
        } else if (n2 == R.id.check_origin_image_layout) {
            ArrayList arrayList = arrayList2;
            ImageView imageView = ((PickerActivity)((Object)arrayList)).fullImage;
            imageView.setSelected(imageView.isSelected() ^ true);
            ((PickerActivity)((Object)arrayList)).isCompress = ((PickerActivity)((Object)arrayList)).fullImage.isSelected() ^ true;
        }
    }

    public void done(ArrayList<Media> arrayList) {
        pickerActivity2.isFinish = true;
        if (pickerActivity2.isCompress && arrayList != null && arrayList.size() > 0) {
            PickerActivity pickerActivity = pickerActivity2;
            pickerActivity.done.setClickable(false);
            pickerActivity.done.setFocusable(true);
            pickerActivity.findViewById(R.id.loading).setVisibility(0);
            pickerActivity2.selectIterator = arrayList.iterator();
            ThreadPool.self().addThreadTask(() -> this.compress(arrayList));
        } else {
            Intent intent;
            PickerActivity pickerActivity = pickerActivity2;
            PickerActivity pickerActivity2 = intent;
            new Intent().putParcelableArrayListExtra("select_result", arrayList);
            pickerActivity.setResult(19901026, (Intent)pickerActivity2);
            pickerActivity.finish();
        }
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (this.isFinish) {
            return true;
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public void onBackPressed() {
        ArrayList arrayList;
        PickerActivity pickerActivity = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        pickerActivity.done(arrayList2);
        super.onBackPressed();
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
    }

    public void onRequestPermissionsResult(int n2, @NonNull String[] stringArray, @NonNull int[] nArray) {
        super.onRequestPermissionsResult(n2, stringArray, nArray);
    }

    protected void onActivityResult(int n2, int n3, Intent object) {
        super.onActivityResult(n2, n3, (Intent)object);
        if (object != null && object.hasExtra("FULL_IMAGE")) {
            PickerActivity pickerActivity = object3;
            pickerActivity.fullImage.setSelected(object.getBooleanExtra("FULL_IMAGE", false));
            pickerActivity.isCompress = pickerActivity.fullImage.isSelected() ^ true;
        }
        if (n2 == 200) {
            ArrayList arrayList = object.getParcelableArrayListExtra("select_result");
            if (n3 == 1990) {
                ArrayList arrayList2 = object.getIntegerArrayListExtra("original_preview_index");
                object = object.getParcelableArrayListExtra("edited_preview_data");
                if (arrayList2 != null && arrayList2.size() > 0 && object != null && ((ArrayList)object).size() > 0) {
                    ArrayList<Media> arrayList3 = ((PickerActivity)object3).gridAdapter.getMedias();
                    for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
                        int n4 = (Integer)arrayList2.get(i2);
                        if (n4 < 0) continue;
                        arrayList3.set(n4, (Media)((ArrayList)object).get(i2));
                    }
                    ((PickerActivity)object3).gridAdapter.updateAdapter(arrayList3);
                }
                PickerActivity pickerActivity = object3;
                pickerActivity.gridAdapter.updateSelectAdapter(arrayList);
                pickerActivity.setButtonText();
            } else if (n3 == 19901026) {
                ((PickerActivity)object3).done(arrayList);
            }
        } else if (n2 == 201 && n3 == -1 && object != null) {
            Intent intent = object;
            n2 = intent.getIntExtra("IMAGE_INDEX", -1);
            n3 = intent.getIntExtra("_id", -1);
            if (n3 != -1 && n2 != -1) {
                ArrayList<Media> arrayList;
                Media media;
                PickerActivity pickerActivity = object3;
                Object object2 = object;
                Object object3 = object2.getStringExtra("PATH");
                String string2 = object2.getStringExtra("_display_name");
                long l2 = System.currentTimeMillis();
                l2 = object2.getLongExtra("date_added", l2);
                int n5 = object2.getIntExtra("mime_type", 0);
                long l3 = object2.getLongExtra("_size", 0L);
                String string3 = object2.getStringExtra("PARENTPATH");
                Media media2 = media;
                media = new Media((String)object3, string2, l2, n5, l3, n3, string3);
                object3 = arrayList;
                new ArrayList<Media>().add(media2);
                pickerActivity.done((ArrayList<Media>)object3);
            } else {
                return;
            }
        }
    }

    public void setFullScreen(Activity activity, boolean bl) {
        PickerActivity pickerActivity = activity.getWindow();
        if (bl) {
            PickerActivity pickerActivity2 = pickerActivity;
            WindowManager.LayoutParams layoutParams = pickerActivity2.getAttributes();
            layoutParams.flags |= 0x400;
            pickerActivity2.setAttributes(layoutParams);
        } else {
            PickerActivity pickerActivity3 = pickerActivity;
            WindowManager.LayoutParams layoutParams = pickerActivity3.getAttributes();
            layoutParams.flags &= 0xFFFFFBFF;
            pickerActivity3.setAttributes(layoutParams);
        }
    }

    protected void onResume() {
        PickerActivity pickerActivity = this;
        super.onResume();
        RuningAcitvityUtil.putRuningActivity((Activity)pickerActivity);
    }

    protected void onPause() {
        PickerActivity pickerActivity = this;
        super.onPause();
        RuningAcitvityUtil.removeRuningActivity(pickerActivity.getComponentName().getClassName());
    }
}

