/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.encoder;

import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.common.CharacterSetECI;
import com.dcloud.zxing2.common.reedsolomon.GenericGF;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonEncoder;
import com.dcloud.zxing2.qrcode.decoder.ErrorCorrectionLevel;
import com.dcloud.zxing2.qrcode.decoder.Mode;
import com.dcloud.zxing2.qrcode.decoder.Version;
import com.dcloud.zxing2.qrcode.encoder.BlockPair;
import com.dcloud.zxing2.qrcode.encoder.ByteMatrix;
import com.dcloud.zxing2.qrcode.encoder.MaskUtil;
import com.dcloud.zxing2.qrcode.encoder.MatrixUtil;
import com.dcloud.zxing2.qrcode.encoder.QRCode;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public final class Encoder {
    private static final int[] ALPHANUMERIC_TABLE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, -1, -1, -1, 37, 38, -1, -1, -1, -1, 39, 40, -1, 41, 42, 43, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 44, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1};
    static final String DEFAULT_BYTE_MODE_ENCODING = "ISO-8859-1";

    private Encoder() {
    }

    private static int calculateMaskPenalty(ByteMatrix byteMatrix) {
        return MaskUtil.applyMaskPenaltyRule1(byteMatrix) + MaskUtil.applyMaskPenaltyRule2(byteMatrix) + MaskUtil.applyMaskPenaltyRule3(byteMatrix) + MaskUtil.applyMaskPenaltyRule4(byteMatrix);
    }

    public static QRCode encode(String string2, ErrorCorrectionLevel errorCorrectionLevel) throws WriterException {
        return Encoder.encode(string2, errorCorrectionLevel, null);
    }

    public static QRCode encode(String object, ErrorCorrectionLevel object2, Map<EncodeHintType, ?> object3) throws WriterException {
        ByteMatrix byteMatrix;
        QRCode qRCode;
        BitArray bitArray;
        BitArray bitArray2;
        Object object4;
        BitArray bitArray3;
        Object object5;
        Object object6 = DEFAULT_BYTE_MODE_ENCODING;
        if (object3 != null && object3.containsKey(object5 = EncodeHintType.CHARACTER_SET)) {
            object6 = object3.get(object5).toString();
        }
        object3 = Encoder.chooseMode((String)object, (String)object6);
        object5 = bitArray3;
        bitArray3 = new BitArray();
        Object object7 = Mode.BYTE;
        if (object3 == object7 && !DEFAULT_BYTE_MODE_ENCODING.equals(object6) && (object4 = CharacterSetECI.getCharacterSetECIByName((String)object6)) != null) {
            Encoder.appendECI((CharacterSetECI)((Object)object4), (BitArray)object5);
        }
        Mode mode = object7;
        Object object8 = object5;
        Object object9 = object3;
        Encoder.appendModeInfo((Mode)((Object)object9), (BitArray)object5);
        object7 = bitArray2;
        bitArray2 = new BitArray();
        Encoder.appendBytes((String)object, (Mode)((Object)object9), (BitArray)object7, (String)object6);
        object6 = Encoder.chooseVersion(((BitArray)object8).getSize() + ((Mode)((Object)object3)).getCharacterCountBits(Version.getVersionForNumber(1)) + ((BitArray)object7).getSize(), object2);
        object6 = Encoder.chooseVersion(((BitArray)object8).getSize() + ((Mode)((Object)object3)).getCharacterCountBits((Version)object6) + ((BitArray)object7).getSize(), object2);
        object4 = bitArray;
        ((BitArray)object4)();
        bitArray.appendBitArray((BitArray)object5);
        Encoder.appendLengthInfo(object3 == mode ? ((BitArray)object7).getSizeInBytes() : ((String)object).length(), (Version)object6, (Mode)((Object)object3), (BitArray)object4);
        ((BitArray)object4).appendBitArray((BitArray)object7);
        object = ((Version)object6).getECBlocksForLevel((ErrorCorrectionLevel)((Object)object2));
        Object object10 = object6;
        int n2 = ((Version)object10).getTotalCodewords() - ((Version.ECBlocks)object).getTotalECCodewords();
        Encoder.terminateBits(n2, (BitArray)object4);
        int n3 = ((Version)object10).getTotalCodewords();
        int n4 = ((Version.ECBlocks)object).getNumBlocks();
        BitArray bitArray4 = Encoder.interleaveWithECBytes((BitArray)object4, n3, n2, n4);
        QRCode qRCode2 = qRCode;
        ErrorCorrectionLevel errorCorrectionLevel = object2;
        ErrorCorrectionLevel errorCorrectionLevel2 = object2;
        qRCode2();
        qRCode2.setECLevel((ErrorCorrectionLevel)((Object)object2));
        qRCode2.setMode((Mode)((Object)object3));
        qRCode2.setVersion((Version)object6);
        int n5 = ((Version)object6).getDimensionForVersion();
        object2 = byteMatrix;
        int n6 = n5;
        byteMatrix = new ByteMatrix(n6, n6);
        n5 = Encoder.chooseMaskPattern(bitArray4, errorCorrectionLevel2, (Version)object6, (ByteMatrix)object2);
        qRCode2.setMaskPattern(n5);
        MatrixUtil.buildMatrix(bitArray4, errorCorrectionLevel, (Version)object6, n5, (ByteMatrix)object2);
        qRCode.setMatrix((ByteMatrix)object2);
        return qRCode;
    }

    static int getAlphanumericCode(int n2) {
        int[] nArray = ALPHANUMERIC_TABLE;
        if (n2 < ALPHANUMERIC_TABLE.length) {
            return nArray[n2];
        }
        return -1;
    }

    public static Mode chooseMode(String string2) {
        return Encoder.chooseMode(string2, null);
    }

    private static Mode chooseMode(String string2, String string3) {
        if ("Shift_JIS".equals(string3) && Encoder.isOnlyDoubleByteKanji(string2)) {
            return Mode.KANJI;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            if (c2 >= '0' && c2 <= '9') {
                bl = true;
                continue;
            }
            if (Encoder.getAlphanumericCode(c2) != -1) {
                bl2 = true;
                continue;
            }
            return Mode.BYTE;
        }
        if (bl2) {
            return Mode.ALPHANUMERIC;
        }
        if (bl) {
            return Mode.NUMERIC;
        }
        return Mode.BYTE;
    }

    private static boolean isOnlyDoubleByteKanji(String object) {
        byte[] byArray;
        try {
            byArray = ((String)object).getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        object = byArray;
        int n2 = byArray.length;
        if (n2 % 2 != 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; i2 += 2) {
            int n3 = object[i2] & 0xFF;
            if (n3 >= 129 && n3 <= 159 || n3 >= 224 && n3 <= 235) {
                continue;
            }
            return false;
        }
        return true;
    }

    private static int chooseMaskPattern(BitArray bitArray, ErrorCorrectionLevel errorCorrectionLevel, Version version, ByteMatrix byteMatrix) throws WriterException {
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        for (int i2 = 0; i2 < 8; ++i2) {
            MatrixUtil.buildMatrix(bitArray, errorCorrectionLevel, version, i2, byteMatrix);
            int n4 = Encoder.calculateMaskPenalty(byteMatrix);
            if (n4 < n2) {
                n3 = i2;
            } else {
                n4 = n2;
            }
            n2 = n4;
        }
        return n3;
    }

    private static Version chooseVersion(int n2, ErrorCorrectionLevel errorCorrectionLevel) throws WriterException {
        for (int i2 = 1; i2 <= 40; ++i2) {
            Version version = Version.getVersionForNumber(i2);
            if (version.getTotalCodewords() - version.getECBlocksForLevel(errorCorrectionLevel).getTotalECCodewords() < (n2 + 7) / 8) continue;
            return version;
        }
        throw new WriterException("Data too big");
    }

    static void terminateBits(int n2, BitArray bitArray) throws WriterException {
        int n3 = n2 * 8;
        if (bitArray.getSize() <= n3) {
            int n4;
            for (n4 = 0; n4 < 4 && bitArray.getSize() < n3; ++n4) {
                bitArray.appendBit(false);
            }
            n4 = bitArray.getSize() & 7;
            if (n4 > 0) {
                while (n4 < 8) {
                    bitArray.appendBit(false);
                    ++n4;
                }
            }
            n2 -= bitArray.getSizeInBytes();
            for (n4 = 0; n4 < n2; ++n4) {
                int n5 = (n4 & 1) == 0 ? 236 : 17;
                bitArray.appendBits(n5, 8);
            }
            if (bitArray.getSize() == n3) {
                return;
            }
            throw new WriterException("Bits size does not equal capacity");
        }
        throw new WriterException("data bits cannot fit in the QR Code" + bitArray.getSize() + " > " + n3);
    }

    static void getNumDataBytesAndNumECBytesForBlockID(int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) throws WriterException {
        if (n5 < n4) {
            int n6 = n2 % n4;
            int n7 = n4 - n6;
            int n8 = n2 / n4;
            n3 = n8 + 1;
            int n9 = n3 / n4;
            int n10 = n8 - n9;
            int n11 = n9 + 1;
            if (n10 == (n3 -= n11)) {
                if (n4 == n7 + n6) {
                    if (n2 == (n9 + n10) * n7 + (n11 + n3) * n6) {
                        if (n5 < n7) {
                            nArray[0] = n9;
                            nArray2[0] = n10;
                        } else {
                            nArray[0] = n11;
                            nArray2[0] = n3;
                        }
                        return;
                    }
                    throw new WriterException("Total bytes mismatch");
                }
                throw new WriterException("RS blocks mismatch");
            }
            throw new WriterException("EC bytes mismatch");
        }
        throw new WriterException("Block ID too large");
    }

    static BitArray interleaveWithECBytes(BitArray bitArray, int n2, int n3, int n4) throws WriterException {
        if (bitArray.getSizeInBytes() == n3) {
            ArrayList<BlockPair> arrayList;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            ArrayList<BlockPair> arrayList2 = arrayList;
            arrayList = new ArrayList<BlockPair>(n4);
            for (int i2 = 0; i2 < n4; ++i2) {
                int[] nArray = new int[1];
                Object[] objectArray = nArray;
                int n8 = n7;
                int[] nArray2 = new int[1];
                Encoder.getNumDataBytesAndNumECBytesForBlockID(n2, n3, n4, i2, objectArray, nArray2);
                n7 = objectArray[0];
                byte[] byArray = new byte[n7];
                objectArray = byArray;
                bitArray.toBytes(n5 * 8, (byte[])objectArray, 0, n7);
                byte[] byArray2 = Encoder.generateECBytes(byArray, nArray2[0]);
                arrayList2.add(new BlockPair((byte[])objectArray, byArray2));
                n6 = Math.max(n6, n7);
                n7 = Math.max(n8, byArray2.length);
                n5 += nArray[0];
            }
            if (n3 == n5) {
                BitArray bitArray2;
                bitArray = bitArray2;
                bitArray2 = new BitArray();
                for (n3 = 0; n3 < n6; ++n3) {
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        byte[] byArray = ((BlockPair)iterator.next()).getDataBytes();
                        if (n3 >= byArray.length) continue;
                        bitArray.appendBits(byArray[n3], 8);
                    }
                }
                for (n3 = 0; n3 < n7; ++n3) {
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        byte[] byArray = ((BlockPair)iterator.next()).getErrorCorrectionBytes();
                        if (n3 >= byArray.length) continue;
                        bitArray.appendBits(byArray[n3], 8);
                    }
                }
                if (n2 == bitArray.getSizeInBytes()) {
                    return bitArray;
                }
                throw new WriterException("Interleaving error: " + n2 + " and " + bitArray.getSizeInBytes() + " differ.");
            }
            throw new WriterException("Data bytes does not match offset");
        }
        throw new WriterException("Number of bits and data bytes does not match");
    }

    static byte[] generateECBytes(byte[] byArray, int n2) {
        int n3;
        int n4 = byArray.length;
        int[] nArray = new int[n4 + n2];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = byArray[n3] & 0xFF;
        }
        new ReedSolomonEncoder(GenericGF.QR_CODE_FIELD_256).encode(nArray, n2);
        byArray = new byte[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            byArray[n3] = (byte)nArray[n4 + n3];
        }
        return byArray;
    }

    static void appendModeInfo(Mode mode, BitArray bitArray) {
        bitArray.appendBits(mode.getBits(), 4);
    }

    static void appendLengthInfo(int n2, Version version, Mode mode, BitArray bitArray) throws WriterException {
        int n3 = mode.getCharacterCountBits(version);
        int n4 = 1 << n3;
        if (n2 < n4) {
            bitArray.appendBits(n2, n3);
            return;
        }
        throw new WriterException(n2 + " is bigger than " + (n4 - 1));
    }

    static void appendBytes(String string2, Mode mode, BitArray bitArray, String string3) throws WriterException {
        switch (1.$SwitchMap$com$dcloud$zxing2$qrcode$decoder$Mode[mode.ordinal()]) {
            default: {
                throw new WriterException("Invalid mode: " + (Object)((Object)mode));
            }
            case 4: {
                Encoder.appendKanjiBytes(string2, bitArray);
                break;
            }
            case 3: {
                Encoder.append8BitBytes(string2, bitArray, string3);
                break;
            }
            case 2: {
                Encoder.appendAlphanumericBytes(string2, bitArray);
                break;
            }
            case 1: {
                Encoder.appendNumericBytes(string2, bitArray);
            }
        }
    }

    static void appendNumericBytes(CharSequence charSequence, BitArray bitArray) {
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = charSequence.charAt(n3) - 48;
            int n5 = n3 + 2;
            if (n5 < n2) {
                int n6 = n4;
                n4 = charSequence.charAt(n3 + 1) - 48;
                n5 = charSequence.charAt(n5) - 48;
                bitArray.appendBits(n6 * 100 + n4 * 10 + n5, 10);
                n3 = n5 = n3 + 3;
                continue;
            }
            if (++n3 < n2) {
                n3 = charSequence.charAt(n3) - 48;
                bitArray.appendBits(n4 * 10 + n3, 7);
                n3 = n5;
                continue;
            }
            bitArray.appendBits(n4, 4);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void appendAlphanumericBytes(CharSequence charSequence, BitArray bitArray) throws WriterException {
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Encoder.getAlphanumericCode(charSequence.charAt(n3));
            if (n4 == -1) throw new WriterException();
            int n5 = n3 + 1;
            if (n5 < n2) {
                if ((n5 = Encoder.getAlphanumericCode(charSequence.charAt(n5))) == -1) throw new WriterException();
                bitArray.appendBits(n4 * 45 + n5, 11);
                n5 = n3 + 2;
            } else {
                bitArray.appendBits(n4, 6);
            }
            n3 = n5;
        }
    }

    static void append8BitBytes(String object, BitArray bitArray, String string2) throws WriterException {
        byte[] byArray;
        try {
            byArray = ((String)object).getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WriterException(unsupportedEncodingException);
        }
        object = byArray;
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            bitArray.appendBits((int)object[i2], 8);
        }
        return;
    }

    static void appendKanjiBytes(String object, BitArray bitArray) throws WriterException {
        byte[] byArray;
        try {
            byArray = ((String)object).getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WriterException(unsupportedEncodingException);
        }
        object = byArray;
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            int n3 = object[i2 + 1] & 0xFF;
            n3 = (object[i2] & 0xFF) << 8 | n3;
            int n4 = -1;
            if (n3 >= 33088 && n3 <= 40956) {
                n4 = n3 - 33088;
            } else if (n3 >= 57408 && n3 <= 60351) {
                n4 = n3 - 49472;
            }
            if (n4 != -1) {
                bitArray.appendBits((n4 >> 8) * 192 + (n4 & 0xFF), 13);
                continue;
            }
            throw new WriterException("Invalid byte sequence");
        }
        return;
    }

    private static void appendECI(CharacterSetECI characterSetECI, BitArray bitArray) {
        bitArray.appendBits(Mode.ECI.getBits(), 4);
        bitArray.appendBits(characterSetECI.getValue(), 8);
    }
}

