/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.decoder;

import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.common.BitSource;
import com.dcloud.zxing2.common.CharacterSetECI;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.common.StringUtils;
import com.dcloud.zxing2.qrcode.decoder.ErrorCorrectionLevel;
import com.dcloud.zxing2.qrcode.decoder.Mode;
import com.dcloud.zxing2.qrcode.decoder.Version;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

final class DecodedBitStreamParser {
    private static final char[] ALPHANUMERIC_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' ', '$', '%', '*', '+', '-', '.', '/', ':'};
    private static final int GB2312_SUBSET = 1;

    private DecodedBitStreamParser() {
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static DecoderResult decode(byte[] var0, Version var1_1, ErrorCorrectionLevel var2_2, Map<DecodeHintType, ?> var3_3) throws FormatException {
        var4_4 = v0;
        v0 = new BitSource(var0);
        var5_5 = v1;
        v1 = new StringBuilder(50);
        var6_6 = v2;
        v2 = new ArrayList<byte[]>(1);
        var7_7 = -1;
        var8_8 = -1;
        var9_9 = "";
        var10_10 = null;
        var11_11 = false;
        do {
            block25: {
                block27: {
                    block26: {
                        block24: {
                            if (var4_4.available() >= 4) break block24;
                            v3 = Mode.TERMINATOR;
lbl17:
                            // 2 sources

                            while (true) {
                                var12_12 = v3;
                                ** GOTO lbl24
                                break;
                            }
                        }
                        v3 = Mode.forBits(var4_4.readBits(4));
                        ** continue;
lbl24:
                        // 1 sources

                        var13_13 = Mode.TERMINATOR;
                        if (var12_12 == var13_13) continue;
                        if (var12_12 == Mode.FNC1_FIRST_POSITION) break block25;
                        if (var12_12 == Mode.FNC1_SECOND_POSITION) break block25;
                        if (var12_12 != Mode.STRUCTURED_APPEND) ** GOTO lbl44
                        if (var4_4.available() < 16) break block26;
                        v4 = var4_4;
                        v5 = v4;
                        var7_7 = v4.readBits(8);
                        var8_8 = v5.readBits(8);
                        continue;
                    }
                    throw FormatException.getFormatInstance();
lbl44:
                    // 1 sources

                    if (var12_12 != Mode.ECI) ** GOTO lbl50
                    var10_10 = CharacterSetECI.getCharacterSetECIByValue(DecodedBitStreamParser.parseECIValue(var4_4));
                    if (var10_10 != null) continue;
                    throw FormatException.getFormatInstance();
lbl50:
                    // 1 sources

                    if (var12_12 != Mode.HANZI) ** GOTO lbl57
                    var14_14 = var4_4.readBits(var12_12.getCharacterCountBits((Version)var1_1));
                    if (var4_4.readBits(4) != 1) continue;
                    DecodedBitStreamParser.decodeHanziSegment(var4_4, var5_5, var14_14);
                    continue;
lbl57:
                    // 1 sources

                    v6 = var12_12;
                    var14_14 = var4_4.readBits(var12_12.getCharacterCountBits((Version)var1_1));
                    if (v6 != Mode.NUMERIC) ** GOTO lbl64
                    DecodedBitStreamParser.decodeNumericSegment(var4_4, var5_5, var14_14);
                    continue;
lbl64:
                    // 1 sources

                    if (var12_12 != Mode.ALPHANUMERIC) ** GOTO lbl68
                    DecodedBitStreamParser.decodeAlphanumericSegment(var4_4, var5_5, var14_14, var11_11);
                    continue;
lbl68:
                    // 1 sources

                    if (var12_12 != Mode.BYTE) break block27;
                    var9_9 = DecodedBitStreamParser.decodeByteSegment(var4_4, var5_5, var14_14, var10_10, var6_6, var3_3);
                    continue;
                }
                if (var12_12 != Mode.KANJI) ** GOTO lbl78
                DecodedBitStreamParser.decodeKanjiSegment(var4_4, var5_5, var14_14);
                continue;
lbl78:
                // 1 sources

                throw FormatException.getFormatInstance();
            }
            var11_11 = true;
        } while (var12_12 != var13_13);
        var3_3 = var5_5.toString();
        if (var6_6.isEmpty()) {
            var6_6 = null;
        }
        var2_2 = var2_2 == null ? null : var2_2.toString();
        v7 = var1_1;
        v7(var0, (String)var3_3, var6_6, (String)var2_2, var7_7, var8_8);
        v7.textCharset = var9_9;
        return v7;
        catch (IllegalArgumentException v8) {
            throw FormatException.getFormatInstance();
        }
    }

    private static void decodeHanziSegment(BitSource bitSource, StringBuilder stringBuilder, int n2) throws FormatException {
        if (n2 * 13 <= bitSource.available()) {
            byte[] byArray = new byte[n2 * 2];
            int n3 = 0;
            while (n2 > 0) {
                int n4 = bitSource.readBits(13);
                n4 = (n4 = n4 / 96 << 8 | n4 % 96) < 959 ? (n4 += 41377) : (n4 += 42657);
                int n5 = n4;
                byArray[n3] = (byte)(n4 >> 8 & 0xFF);
                n4 = n3 + 1;
                byArray[n4] = (byte)(n5 & 0xFF);
                n3 += 2;
                --n2;
            }
            try {
                stringBuilder.append(new String(byArray, "GB2312"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw FormatException.getFormatInstance();
            }
            return;
        }
        throw FormatException.getFormatInstance();
    }

    private static void decodeKanjiSegment(BitSource bitSource, StringBuilder stringBuilder, int n2) throws FormatException {
        if (n2 * 13 <= bitSource.available()) {
            byte[] byArray = new byte[n2 * 2];
            int n3 = 0;
            while (n2 > 0) {
                int n4 = bitSource.readBits(13);
                n4 = (n4 = n4 / 192 << 8 | n4 % 192) < 7936 ? (n4 += 33088) : (n4 += 49472);
                int n5 = n4;
                byArray[n3] = (byte)(n4 >> 8);
                n4 = n3 + 1;
                byArray[n4] = (byte)n5;
                n3 += 2;
                --n2;
            }
            try {
                stringBuilder.append(new String(byArray, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw FormatException.getFormatInstance();
            }
            return;
        }
        throw FormatException.getFormatInstance();
    }

    private static String decodeByteSegment(BitSource object, StringBuilder stringBuilder, int n2, CharacterSetECI characterSetECI, Collection<byte[]> collection, Map<DecodeHintType, ?> map) throws FormatException {
        if (n2 * 8 <= ((BitSource)object).available()) {
            byte[] byArray;
            Collection<byte[]> collection2;
            Object object2;
            byte[] byArray2 = new byte[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray2[i2] = (byte)((BitSource)object).readBits(8);
            }
            object = characterSetECI == null ? StringUtils.guessEncoding(byArray2, map) : characterSetECI.name();
            try {
                object2 = object;
                collection2 = collection;
                byArray = byArray2;
                stringBuilder.append(new String(byArray2, (String)object));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw FormatException.getFormatInstance();
            }
            collection2.add(byArray);
            return object2;
        }
        throw FormatException.getFormatInstance();
    }

    private static char toAlphaNumericChar(int n2) throws FormatException {
        char[] cArray = ALPHANUMERIC_CHARS;
        if (n2 < ALPHANUMERIC_CHARS.length) {
            return cArray[n2];
        }
        throw FormatException.getFormatInstance();
    }

    private static void decodeAlphanumericSegment(BitSource bitSource, StringBuilder stringBuilder, int n2, boolean bl) throws FormatException {
        int n3 = stringBuilder.length();
        while (n2 > 1) {
            if (bitSource.available() >= 11) {
                int n4 = bitSource.readBits(11);
                stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n4 / 45));
                stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n4 % 45));
                n2 -= 2;
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        if (n2 == 1) {
            if (bitSource.available() >= 6) {
                stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(bitSource.readBits(6)));
            } else {
                throw FormatException.getFormatInstance();
            }
        }
        if (bl) {
            while (n3 < stringBuilder.length()) {
                if (stringBuilder.charAt(n3) == '%') {
                    int n5;
                    if (n3 < stringBuilder.length() - 1 && stringBuilder.charAt(n5 = n3 + 1) == '%') {
                        stringBuilder.deleteCharAt(n5);
                    } else {
                        stringBuilder.setCharAt(n3, '\u001d');
                    }
                }
                ++n3;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void decodeNumericSegment(BitSource bitSource, StringBuilder stringBuilder, int n2) throws FormatException {
        while (n2 >= 3) {
            if (bitSource.available() < 10) throw FormatException.getFormatInstance();
            int n3 = bitSource.readBits(10);
            if (n3 >= 1000) throw FormatException.getFormatInstance();
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n3 / 100));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n3 / 10 % 10));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n3 % 10));
            n2 -= 3;
        }
        if (n2 == 2) {
            if (bitSource.available() < 7) throw FormatException.getFormatInstance();
            int n4 = bitSource.readBits(7);
            if (n4 >= 100) throw FormatException.getFormatInstance();
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n4 / 10));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n4 % 10));
            return;
        } else {
            if (n2 != 1) return;
            if (bitSource.available() < 4) throw FormatException.getFormatInstance();
            int n5 = bitSource.readBits(4);
            if (n5 >= 10) throw FormatException.getFormatInstance();
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n5));
        }
    }

    private static int parseECIValue(BitSource bitSource) throws FormatException {
        int n2 = bitSource.readBits(8);
        if ((n2 & 0x80) == 0) {
            return n2 & 0x7F;
        }
        if ((n2 & 0xC0) == 128) {
            int n3 = bitSource.readBits(8);
            return (n2 & 0x3F) << 8 | n3;
        }
        if ((n2 & 0xE0) == 192) {
            int n4 = bitSource.readBits(16);
            return (n2 & 0x1F) << 16 | n4;
        }
        throw FormatException.getFormatInstance();
    }
}

