/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.decoder;

import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.qrcode.decoder.DataMask;
import com.dcloud.zxing2.qrcode.decoder.FormatInformation;
import com.dcloud.zxing2.qrcode.decoder.Version;

final class BitMatrixParser {
    private final BitMatrix bitMatrix;
    private Version parsedVersion;
    private FormatInformation parsedFormatInfo;
    private boolean mirror;

    BitMatrixParser(BitMatrix bitMatrix) throws FormatException {
        int n2 = bitMatrix.getHeight();
        if (n2 >= 21 && (n2 & 3) == 1) {
            this.bitMatrix = bitMatrix;
            return;
        }
        throw FormatException.getFormatInstance();
    }

    private int copyBit(int n2, int n3, int n4) {
        return (this.mirror ? this.bitMatrix.get(n3, n2) : this.bitMatrix.get(n2, n3)) ? n4 << 1 | 1 : n4 << 1;
    }

    FormatInformation readFormatInformation() throws FormatException {
        FormatInformation formatInformation;
        int n2;
        FormatInformation formatInformation2 = this.parsedFormatInfo;
        if (formatInformation2 != null) {
            return formatInformation2;
        }
        int n3 = 0;
        for (n2 = 0; n2 < 6; ++n2) {
            n3 = this.copyBit(n2, 8, n3);
        }
        BitMatrixParser bitMatrixParser = this;
        n3 = bitMatrixParser.copyBit(7, 8, n3);
        n3 = bitMatrixParser.copyBit(8, 8, n3);
        n3 = bitMatrixParser.copyBit(8, 7, n3);
        for (n2 = 5; n2 >= 0; --n2) {
            n3 = this.copyBit(8, n2, n3);
        }
        n2 = this.bitMatrix.getHeight();
        int n4 = 0;
        int n5 = n2 - 7;
        for (int i2 = n2 - 1; i2 >= n5; --i2) {
            n4 = this.copyBit(8, i2, n4);
        }
        for (n5 = n2 - 8; n5 < n2; ++n5) {
            n4 = this.copyBit(n5, 8, n4);
        }
        this.parsedFormatInfo = formatInformation = FormatInformation.decodeFormatInformation(n3, n4);
        if (formatInformation != null) {
            return formatInformation;
        }
        throw FormatException.getFormatInstance();
    }

    Version readVersion() throws FormatException {
        int n2;
        int n3;
        Version version = this.parsedVersion;
        if (version != null) {
            return version;
        }
        int n4 = this.bitMatrix.getHeight();
        int n5 = (n4 - 17) / 4;
        if (n5 <= 6) {
            return Version.getVersionForNumber(n5);
        }
        n5 = 0;
        int n6 = n4 - 11;
        for (n3 = 5; n3 >= 0; --n3) {
            for (n2 = n4 - 9; n2 >= n6; --n2) {
                n5 = this.copyBit(n2, n3, n5);
            }
        }
        Version version2 = Version.decodeVersionInformation(n5);
        if (version2 != null && version2.getDimensionForVersion() == n4) {
            this.parsedVersion = version2;
            return version2;
        }
        int n7 = 0;
        for (n3 = 5; n3 >= 0; --n3) {
            for (n2 = n4 - 9; n2 >= n6; --n2) {
                n7 = this.copyBit(n3, n2, n7);
            }
        }
        Version version3 = Version.decodeVersionInformation(n7);
        if (version3 != null && version3.getDimensionForVersion() == n4) {
            this.parsedVersion = version3;
            return version3;
        }
        throw FormatException.getFormatInstance();
    }

    /*
     * Unable to fully structure code
     */
    byte[] readCodewords() throws FormatException {
        v0 = this;
        var1_1 = v0.readFormatInformation();
        var2_2 = v0.readVersion();
        var1_1 = DataMask.forReference(var1_1.getDataMask());
        var3_3 = v0.bitMatrix.getHeight();
        v1 = var2_2;
        var1_1.unmaskBitMatrix(this.bitMatrix, var3_3);
        var1_1 = v1.buildFunctionPattern();
        var4_4 = true;
        var5_5 = new byte[v1.getTotalCodewords()];
        var6_6 = 0;
        var7_7 = 0;
        var8_8 = 0;
        for (var10_10 = var9_9 = var3_3 - 1; var10_10 > 0; var10_10 -= 2) {
            if (var10_10 == 6) {
                --var10_10;
            }
            for (var11_11 = 0; var11_11 < var3_3; ++var11_11) {
                var12_12 = var4_4 != false ? var9_9 - var11_11 : var11_11;
                for (var13_13 = 0; var13_13 < 2; ++var13_13) {
                    var14_14 = var10_10 - var13_13;
                    if (var1_1.get(var14_14, var12_12)) ** GOTO lbl-1000
                    ++var8_8;
                    var7_7 <<= 1;
                    if (this.bitMatrix.get(var14_14, var12_12)) {
                        var7_7 |= 1;
                    }
                    if (var8_8 == 8) {
                        v2 = var7_7;
                        var7_7 = var6_6 + 1;
                        var5_5[var6_6] = (byte)v2;
                        var8_8 = 0;
                        var6_6 = 0;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = var6_6;
                        var6_6 = var7_7;
                        var7_7 = v3;
                    }
                    v4 = var7_7;
                    var7_7 = var6_6;
                    var6_6 = v4;
                }
            }
            var4_4 ^= true;
        }
        if (var6_6 == var2_2.getTotalCodewords()) {
            return var5_5;
        }
        throw FormatException.getFormatInstance();
    }

    void remask() {
        FormatInformation formatInformation = this.parsedFormatInfo;
        if (formatInformation == null) {
            return;
        }
        BitMatrixParser bitMatrixParser = this;
        int n2 = bitMatrixParser.bitMatrix.getHeight();
        DataMask.forReference(formatInformation.getDataMask()).unmaskBitMatrix(bitMatrixParser.bitMatrix, n2);
    }

    void setMirror(boolean bl) {
        BitMatrixParser bitMatrixParser = this;
        bitMatrixParser.parsedVersion = null;
        bitMatrixParser.parsedFormatInfo = null;
        bitMatrixParser.mirror = bl;
    }

    void mirror() {
        int n2 = 0;
        while (n2 < this.bitMatrix.getWidth()) {
            int n3;
            for (int i2 = n3 = n2 + 1; i2 < this.bitMatrix.getHeight(); ++i2) {
                if (this.bitMatrix.get(n2, i2) == this.bitMatrix.get(i2, n2)) continue;
                BitMatrixParser bitMatrixParser = this;
                bitMatrixParser.bitMatrix.flip(i2, n2);
                bitMatrixParser.bitMatrix.flip(n2, i2);
            }
            n2 = n3;
        }
    }
}

