/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.Writer;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.qrcode.decoder.ErrorCorrectionLevel;
import com.dcloud.zxing2.qrcode.encoder.ByteMatrix;
import com.dcloud.zxing2.qrcode.encoder.Encoder;
import com.dcloud.zxing2.qrcode.encoder.QRCode;
import java.util.Map;

public final class QRCodeWriter
implements Writer {
    private static final int QUIET_ZONE_SIZE = 4;

    private static BitMatrix renderResult(QRCode object, int n2, int n3, int n4) {
        if ((object = ((QRCode)object).getMatrix()) != null) {
            BitMatrix bitMatrix;
            int n5 = n3;
            int n6 = n2;
            Object object2 = object;
            n2 = ((ByteMatrix)object2).getWidth();
            n3 = ((ByteMatrix)object2).getHeight();
            int n7 = n2 + (n4 *= 2);
            n4 = n3 + n4;
            int n8 = Math.max(n6, n7);
            int n9 = Math.max(n5, n4);
            n4 = Math.min(n8 / n7, n9 / n4);
            n7 = (n8 - n2 * n4) / 2;
            int n10 = (n9 - n3 * n4) / 2;
            BitMatrix bitMatrix2 = bitMatrix;
            bitMatrix = new BitMatrix(n8, n9);
            n8 = 0;
            while (n8 < n3) {
                n9 = 0;
                int n11 = n7;
                while (n9 < n2) {
                    if (((ByteMatrix)object).get(n9, n8) == 1) {
                        int n12 = n4;
                        bitMatrix2.setRegion(n11, n10, n12, n12);
                    }
                    ++n9;
                    n11 += n4;
                }
                ++n8;
                n10 += n4;
            }
            return bitMatrix2;
        }
        throw new IllegalStateException();
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3) throws WriterException {
        return this.encode(string2, barcodeFormat, n2, n3, null);
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (!string2.isEmpty()) {
            if (barcodeFormat == BarcodeFormat.QR_CODE) {
                if (n2 >= 0 && n3 >= 0) {
                    Object object = ErrorCorrectionLevel.L;
                    int n4 = 4;
                    if (map != null) {
                        EncodeHintType encodeHintType = EncodeHintType.ERROR_CORRECTION;
                        if (map.containsKey((Object)encodeHintType)) {
                            object = ErrorCorrectionLevel.valueOf(map.get((Object)encodeHintType).toString());
                        }
                        if (map.containsKey((Object)(encodeHintType = EncodeHintType.MARGIN))) {
                            n4 = Integer.parseInt(map.get((Object)encodeHintType).toString());
                        }
                    }
                    return QRCodeWriter.renderResult(Encoder.encode(string2, (ErrorCorrectionLevel)((Object)object), map), n2, n3, n4);
                }
                throw new IllegalArgumentException("Requested dimensions are too small: " + n2 + 'x' + n3);
            }
            throw new IllegalArgumentException("Can only encode QR_CODE, but got " + (Object)((Object)barcodeFormat));
        }
        throw new IllegalArgumentException("Found empty contents");
    }
}

