/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.encoder;

import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.CharacterSetECI;
import com.dcloud.zxing2.pdf417.encoder.Compaction;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;

final class PDF417HighLevelEncoder {
    private static final int TEXT_COMPACTION = 0;
    private static final int BYTE_COMPACTION = 1;
    private static final int NUMERIC_COMPACTION = 2;
    private static final int SUBMODE_ALPHA = 0;
    private static final int SUBMODE_LOWER = 1;
    private static final int SUBMODE_MIXED = 2;
    private static final int SUBMODE_PUNCTUATION = 3;
    private static final int LATCH_TO_TEXT = 900;
    private static final int LATCH_TO_BYTE_PADDED = 901;
    private static final int LATCH_TO_NUMERIC = 902;
    private static final int SHIFT_TO_BYTE = 913;
    private static final int LATCH_TO_BYTE = 924;
    private static final int ECI_USER_DEFINED = 925;
    private static final int ECI_GENERAL_PURPOSE = 926;
    private static final int ECI_CHARSET = 927;
    private static final byte[] TEXT_MIXED_RAW;
    private static final byte[] TEXT_PUNCTUATION_RAW;
    private static final byte[] MIXED;
    private static final byte[] PUNCTUATION;
    private static final Charset DEFAULT_ENCODING;

    private PDF417HighLevelEncoder() {
    }

    static String encodeHighLevel(String string2, Compaction compaction, Charset charset) throws WriterException {
        CharacterSetECI characterSetECI;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(string2.length());
        if (charset == null) {
            charset = DEFAULT_ENCODING;
        } else if (!DEFAULT_ENCODING.equals(charset) && (characterSetECI = CharacterSetECI.getCharacterSetECIByName(charset.name())) != null) {
            PDF417HighLevelEncoder.encodingECI(characterSetECI.getValue(), stringBuilder2);
        }
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        if (compaction == Compaction.TEXT) {
            PDF417HighLevelEncoder.encodeText(string2, n3, n2, stringBuilder2, n4);
        } else if (compaction == Compaction.BYTE) {
            byte[] byArray = string2.getBytes(charset);
            PDF417HighLevelEncoder.encodeBinary(byArray, n3, byArray.length, 1, stringBuilder2);
        } else if (compaction == Compaction.NUMERIC) {
            stringBuilder2.append('\u0386');
            PDF417HighLevelEncoder.encodeNumeric(string2, n3, n2, stringBuilder2);
        } else {
            int n5 = 0;
            while (n3 < n2) {
                int n6 = PDF417HighLevelEncoder.determineConsecutiveDigitCount(string2, n3);
                if (n6 >= 13) {
                    stringBuilder2.append('\u0386');
                    n5 = 2;
                    n4 = 0;
                    PDF417HighLevelEncoder.encodeNumeric(string2, n3, n6, stringBuilder2);
                    n3 += n6;
                    continue;
                }
                int n7 = PDF417HighLevelEncoder.determineConsecutiveTextCount(string2, n3);
                if (n7 < 5 && n6 != n2) {
                    n6 = PDF417HighLevelEncoder.determineConsecutiveBinaryCount(string2, n3, charset);
                    if (n6 == 0) {
                        n6 = 1;
                    }
                    int n8 = n3;
                    n3 = n8 + n6;
                    byte[] byArray = string2.substring(n8, n3).getBytes(charset);
                    if (byArray.length == 1 && n5 == 0) {
                        PDF417HighLevelEncoder.encodeBinary(byArray, 0, 1, 0, stringBuilder2);
                        continue;
                    }
                    PDF417HighLevelEncoder.encodeBinary(byArray, 0, byArray.length, n5, stringBuilder2);
                    n5 = 1;
                    n4 = 0;
                    continue;
                }
                if (n5 != 0) {
                    stringBuilder2.append('\u0384');
                    n5 = 0;
                    n4 = 0;
                }
                n4 = PDF417HighLevelEncoder.encodeText(string2, n3, n7, stringBuilder2, n4);
                n3 += n7;
            }
        }
        return stringBuilder2.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int encodeText(CharSequence charSequence, int n2, int n3, StringBuilder stringBuilder, int n4) {
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder2 = new StringBuilder(n3);
        int n5 = 0;
        while (true) {
            block25: {
                char c2;
                block26: {
                    block27: {
                        int n6 = n2 + n5;
                        c2 = charSequence.charAt(n6);
                        if (n4 == 0) break block26;
                        if (n4 == 1) break block27;
                        if (n4 != 2) {
                            if (PDF417HighLevelEncoder.isPunctuation(c2)) {
                                stringBuilder3.append((char)PUNCTUATION[c2]);
                                break block25;
                            } else {
                                n4 = 0;
                                stringBuilder3.append('\u001d');
                                continue;
                            }
                        }
                        if (PDF417HighLevelEncoder.isMixed(c2)) {
                            stringBuilder3.append((char)MIXED[c2]);
                            break block25;
                        } else {
                            if (PDF417HighLevelEncoder.isAlphaUpper(c2)) {
                                n4 = 0;
                                stringBuilder3.append('\u001c');
                                continue;
                            }
                            if (PDF417HighLevelEncoder.isAlphaLower(c2)) {
                                n4 = 1;
                                stringBuilder3.append('\u001b');
                                continue;
                            }
                            if (++n6 < n3 && PDF417HighLevelEncoder.isPunctuation(charSequence.charAt(n6))) {
                                n4 = 3;
                                stringBuilder3.append('\u0019');
                                continue;
                            }
                            StringBuilder stringBuilder4 = stringBuilder3;
                            stringBuilder4.append('\u001d');
                            stringBuilder4.append((char)PUNCTUATION[c2]);
                        }
                        break block25;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(c2)) {
                        if (c2 == ' ') {
                            stringBuilder3.append('\u001a');
                            break block25;
                        } else {
                            stringBuilder3.append((char)(c2 - 97));
                        }
                        break block25;
                    } else if (PDF417HighLevelEncoder.isAlphaUpper(c2)) {
                        stringBuilder3.append('\u001b');
                        stringBuilder3.append((char)(c2 - 65));
                        break block25;
                    } else {
                        if (PDF417HighLevelEncoder.isMixed(c2)) {
                            n4 = 2;
                            stringBuilder3.append('\u001c');
                            continue;
                        }
                        StringBuilder stringBuilder5 = stringBuilder3;
                        stringBuilder5.append('\u001d');
                        stringBuilder5.append((char)PUNCTUATION[c2]);
                    }
                    break block25;
                }
                if (PDF417HighLevelEncoder.isAlphaUpper(c2)) {
                    if (c2 == ' ') {
                        stringBuilder3.append('\u001a');
                    } else {
                        stringBuilder3.append((char)(c2 - 65));
                    }
                } else {
                    if (PDF417HighLevelEncoder.isAlphaLower(c2)) {
                        n4 = 1;
                        stringBuilder3.append('\u001b');
                        continue;
                    }
                    if (PDF417HighLevelEncoder.isMixed(c2)) {
                        n4 = 2;
                        stringBuilder3.append('\u001c');
                        continue;
                    }
                    StringBuilder stringBuilder6 = stringBuilder3;
                    stringBuilder6.append('\u001d');
                    stringBuilder6.append((char)PUNCTUATION[c2]);
                }
            }
            if (++n5 >= n3) break;
        }
        int n7 = 0;
        n2 = stringBuilder3.length();
        for (n3 = 0; n3 < n2; ++n3) {
            if (n3 % 2 != 0) {
                char c3 = (char)(n7 * 30 + stringBuilder3.charAt(n3));
                n7 = c3;
                stringBuilder.append(c3);
                continue;
            }
            n7 = stringBuilder3.charAt(n3);
        }
        if (n2 % 2 != 0) {
            stringBuilder.append((char)(n7 * 30 + 29));
        }
        return n4;
    }

    private static void encodeBinary(byte[] byArray, int n2, int n3, int n4, StringBuilder stringBuilder) {
        int n5;
        if (n3 == 1 && n4 == 0) {
            stringBuilder.append('\u0391');
        } else if (n3 % 6 == 0) {
            stringBuilder.append('\u039c');
        } else {
            stringBuilder.append('\u0385');
        }
        if (n3 >= 6) {
            char[] cArray = new char[5];
            n5 = n2;
            while (n2 + n3 - n5 >= 6) {
                int n6;
                long l2 = 0L;
                for (n6 = 0; n6 < 6; ++n6) {
                    l2 = (l2 << 8) + (long)(byArray[n5 + n6] & 0xFF);
                }
                for (n6 = 0; n6 < 5; ++n6) {
                    cArray[n6] = (char)(l2 % 900L);
                    l2 /= 900L;
                }
                for (int i2 = 4; i2 >= 0; --i2) {
                    stringBuilder.append(cArray[i2]);
                }
                n5 += 6;
            }
        } else {
            n5 = n2;
        }
        while (n5 < n2 + n3) {
            stringBuilder.append((char)(byArray[n5] & 0xFF));
            ++n5;
        }
    }

    private static void encodeNumeric(String string2, int n2, int n3, StringBuilder stringBuilder) {
        int n4;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder2 = new StringBuilder(n3 / 3 + 1);
        BigInteger bigInteger = BigInteger.valueOf(900L);
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        for (int i2 = 0; i2 < n3; i2 += n4) {
            BigInteger bigInteger3;
            stringBuilder3.setLength(0);
            n4 = Math.min(44, n3 - i2);
            int n5 = n2 + i2;
            String string3 = '1' + string2.substring(n5, n5 + n4);
            BigInteger bigInteger4 = bigInteger3;
            bigInteger3 = new BigInteger(string3);
            do {
                stringBuilder3.append((char)bigInteger4.mod(bigInteger).intValue());
            } while (!(bigInteger4 = bigInteger4.divide(bigInteger)).equals(bigInteger2));
            for (int i3 = stringBuilder3.length() - 1; i3 >= 0; --i3) {
                stringBuilder.append(stringBuilder3.charAt(i3));
            }
        }
    }

    private static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static boolean isAlphaUpper(char c2) {
        return c2 == ' ' || c2 >= 'A' && c2 <= 'Z';
    }

    private static boolean isAlphaLower(char c2) {
        return c2 == ' ' || c2 >= 'a' && c2 <= 'z';
    }

    private static boolean isMixed(char c2) {
        return MIXED[c2] != -1;
    }

    private static boolean isPunctuation(char c2) {
        return PUNCTUATION[c2] != -1;
    }

    private static boolean isText(char c2) {
        return c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 >= ' ' && c2 <= '~';
    }

    private static int determineConsecutiveDigitCount(CharSequence charSequence, int n2) {
        int n3 = 0;
        int n4 = charSequence.length();
        if (n2 < n4) {
            char c2 = charSequence.charAt(n2);
            while (PDF417HighLevelEncoder.isDigit(c2) && n2 < n4) {
                ++n3;
                if (++n2 >= n4) continue;
                c2 = charSequence.charAt(n2);
            }
        }
        return n3;
    }

    private static int determineConsecutiveTextCount(CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        int n4 = n2;
        while (n4 < n3) {
            int n5;
            char c2 = charSequence.charAt(n4);
            for (n5 = 0; n5 < 13 && PDF417HighLevelEncoder.isDigit(c2) && n4 < n3; ++n5) {
                if (++n4 >= n3) continue;
                c2 = charSequence.charAt(n4);
            }
            if (n5 >= 13) {
                return n4 - n2 - n5;
            }
            if (n5 > 0) continue;
            if (!PDF417HighLevelEncoder.isText(charSequence.charAt(n4))) break;
            ++n4;
        }
        return n4 - n2;
    }

    private static int determineConsecutiveBinaryCount(String string2, int n2, Charset object) throws WriterException {
        int n3;
        object = ((Charset)object).newEncoder();
        int n4 = string2.length();
        for (n3 = n2; n3 < n4; ++n3) {
            char c2 = string2.charAt(n3);
            int n5 = 0;
            while (n5 < 13 && PDF417HighLevelEncoder.isDigit(c2) && (c2 = n3 + ++n5) < n4) {
                c2 = string2.charAt(c2);
            }
            if (n5 >= 13) {
                return n3 - n2;
            }
            c2 = string2.charAt(n3);
            if (((CharsetEncoder)object).canEncode(c2)) {
                continue;
            }
            throw new WriterException("Non-encodable character detected: " + c2 + " (Unicode: " + c2 + ')');
        }
        return n3 - n2;
    }

    private static void encodingECI(int n2, StringBuilder stringBuilder) throws WriterException {
        block5: {
            block3: {
                block4: {
                    block2: {
                        if (n2 < 0 || n2 >= 900) break block2;
                        stringBuilder.append('\u039f');
                        stringBuilder.append((char)n2);
                        break block3;
                    }
                    if (n2 >= 810900) break block4;
                    stringBuilder.append('\u039e');
                    stringBuilder.append((char)(n2 / 900 - 1));
                    stringBuilder.append((char)(n2 % 900));
                    break block3;
                }
                if (n2 >= 811800) break block5;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.append('\u039d');
                stringBuilder2.append((char)(810900 - n2));
            }
            return;
        }
        throw new WriterException("ECI number not in valid range from 0..811799, but was " + n2);
    }

    static {
        byte[] byArray;
        TEXT_MIXED_RAW = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 38, 13, 9, 44, 58, 35, 45, 46, 36, 47, 43, 37, 42, 61, 94, 0, 32, 0, 0, 0};
        TEXT_PUNCTUATION_RAW = new byte[]{59, 60, 62, 64, 91, 92, 93, 95, 96, 126, 33, 13, 9, 44, 58, 10, 45, 46, 36, 47, 34, 124, 42, 40, 41, 63, 123, 125, 39, 0};
        MIXED = new byte[128];
        PUNCTUATION = new byte[128];
        DEFAULT_ENCODING = Charset.forName("ISO-8859-1");
        Arrays.fill(MIXED, (byte)-1);
        int n2 = 0;
        while (true) {
            byArray = TEXT_MIXED_RAW;
            if (n2 >= TEXT_MIXED_RAW.length) break;
            byte by = byArray[n2];
            if (by > 0) {
                PDF417HighLevelEncoder.MIXED[by] = n2;
            }
            n2 = (byte)(n2 + 1);
        }
        Arrays.fill(PUNCTUATION, (byte)-1);
        n2 = 0;
        while (true) {
            byArray = TEXT_PUNCTUATION_RAW;
            if (n2 >= TEXT_PUNCTUATION_RAW.length) break;
            byte by = byArray[n2];
            if (by > 0) {
                PDF417HighLevelEncoder.PUNCTUATION[by] = n2;
            }
            n2 = (byte)(n2 + 1);
        }
    }
}

