/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.encoder;

import com.dcloud.zxing2.pdf417.encoder.BarcodeRow;

public final class BarcodeMatrix {
    private final BarcodeRow[] matrix;
    private int currentRow;
    private final int height;
    private final int width;

    BarcodeMatrix(int n2, int n3) {
        this.matrix = new BarcodeRow[n2];
        int n4 = this.matrix.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            BarcodeRow barcodeRow;
            BarcodeRow barcodeRow2 = barcodeRow;
            barcodeRow = new BarcodeRow((n3 + 4) * 17 + 1);
            this.matrix[i2] = barcodeRow2;
        }
        BarcodeMatrix barcodeMatrix = this;
        this.width = n3 * 17;
        barcodeMatrix.height = n2;
        barcodeMatrix.currentRow = -1;
    }

    void set(int n2, int n3, byte by) {
        this.matrix[n3].set(n2, by);
    }

    void startRow() {
        ++this.currentRow;
    }

    BarcodeRow getCurrentRow() {
        return this.matrix[this.currentRow];
    }

    public byte[][] getMatrix() {
        return this.getScaledMatrix(1, 1);
    }

    public byte[][] getScaledMatrix(int n2, int n3) {
        int n4 = this.height;
        byte[][] byArray = new byte[n4 * n3][this.width * n2];
        int n5 = n4 * n3;
        for (int i2 = 0; i2 < n5; ++i2) {
            byArray[n5 - i2 - 1] = this.matrix[i2 / n3].getScaledRow(n2);
        }
        return byArray;
    }
}

