/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.detector;

import com.dcloud.zxing2.BinaryBitmap;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class Detector {
    private static final int[] INDEXES_START_PATTERN = new int[]{0, 4, 1, 5};
    private static final int[] INDEXES_STOP_PATTERN = new int[]{6, 2, 7, 3};
    private static final float MAX_AVG_VARIANCE = 0.42f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.8f;
    private static final int[] START_PATTERN = new int[]{8, 1, 1, 1, 1, 1, 1, 3};
    private static final int[] STOP_PATTERN = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};
    private static final int MAX_PIXEL_DRIFT = 3;
    private static final int MAX_PATTERN_DRIFT = 5;
    private static final int SKIPPED_ROW_COUNT_MAX = 25;
    private static final int ROW_STEP = 5;
    private static final int BARCODE_MIN_HEIGHT = 10;

    private Detector() {
    }

    public static PDF417DetectorResult detect(BinaryBitmap object, Map<DecodeHintType, ?> list, boolean bl) throws NotFoundException {
        list = Detector.detect(bl, (BitMatrix)(object = ((BinaryBitmap)object).getBlackMatrix()));
        if (list.isEmpty()) {
            object = ((BitMatrix)object).rotate90();
            list = Detector.detect(bl, (BitMatrix)object);
        }
        if (list.isEmpty()) {
            object = ((BitMatrix)object).rotate90();
            list = Detector.detect(bl, (BitMatrix)object);
        }
        if (list.isEmpty()) {
            object = ((BitMatrix)object).rotate90();
            list = Detector.detect(bl, (BitMatrix)object);
        }
        return new PDF417DetectorResult((BitMatrix)object, list);
    }

    private static List<ResultPoint[]> detect(boolean bl, BitMatrix bitMatrix) {
        ArrayList<ResultPoint[]> arrayList;
        ArrayList<ResultPoint[]> arrayList2 = arrayList;
        arrayList = new ArrayList<ResultPoint[]>();
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        while (n2 < bitMatrix.getHeight()) {
            ResultPoint[] resultPointArray = Detector.findVertices(bitMatrix, n2, n3);
            if (resultPointArray[0] == null && resultPointArray[3] == null) {
                if (!bl2) break;
                bl2 = false;
                n3 = 0;
                for (ResultPoint[] resultPointArray2 : arrayList2) {
                    if (resultPointArray2[1] != null) {
                        n2 = (int)Math.max((float)n2, resultPointArray2[1].getY());
                    }
                    if (resultPointArray2[3] == null) continue;
                    n2 = Math.max(n2, (int)resultPointArray2[3].getY());
                }
                n2 += 5;
                continue;
            }
            bl2 = true;
            arrayList2.add(resultPointArray);
            if (!bl) break;
            if (resultPointArray[2] != null) {
                n2 = (int)resultPointArray[2].getX();
                n3 = (int)resultPointArray[2].getY();
            } else {
                n2 = (int)resultPointArray[4].getX();
                n3 = (int)resultPointArray[4].getY();
            }
            int n4 = n3;
            n3 = n2;
            n2 = n4;
        }
        return arrayList2;
    }

    private static ResultPoint[] findVertices(BitMatrix object, int n2, int n3) {
        BitMatrix bitMatrix = object;
        int n4 = bitMatrix.getHeight();
        int n5 = bitMatrix.getWidth();
        ResultPoint[] resultPointArray = new ResultPoint[8];
        int[] nArray = START_PATTERN;
        Detector.copyToResult(resultPointArray, Detector.findRowsWithPattern((BitMatrix)object, n4, n5, n2, n3, nArray), INDEXES_START_PATTERN);
        if (resultPointArray[4] != null) {
            n3 = (int)resultPointArray[4].getX();
            n2 = (int)resultPointArray[4].getY();
        }
        BitMatrix bitMatrix2 = object;
        object = STOP_PATTERN;
        Detector.copyToResult(resultPointArray, Detector.findRowsWithPattern(bitMatrix2, n4, n5, n2, n3, (int[])object), INDEXES_STOP_PATTERN);
        return resultPointArray;
    }

    private static void copyToResult(ResultPoint[] resultPointArray, ResultPoint[] resultPointArray2, int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            resultPointArray[n2] = resultPointArray2[i2];
        }
    }

    private static ResultPoint[] findRowsWithPattern(BitMatrix object, int n2, int n3, int n4, int n5, int[] nArray) {
        int[] nArray2;
        int n6 = 4;
        ResultPoint[] resultPointArray = new ResultPoint[4];
        int n7 = 0;
        int[] nArray3 = new int[nArray.length];
        while (n4 < n2) {
            nArray2 = Detector.findGuardPattern((BitMatrix)object, n5, n4, n3, false, nArray, nArray3);
            if (nArray2 != null) {
                ResultPoint resultPoint;
                ResultPoint resultPoint2;
                while (n4 > 0) {
                    int[] nArray4;
                    if ((nArray4 = Detector.findGuardPattern((BitMatrix)object, n5, --n4, n3, false, nArray, nArray3)) != null) {
                        nArray2 = nArray4;
                        continue;
                    }
                    ++n4;
                    break;
                }
                ResultPoint resultPoint3 = resultPoint2;
                float f2 = nArray2[0];
                float f3 = n4;
                resultPoint2 = new ResultPoint(f2, f3);
                resultPointArray[0] = resultPoint3;
                resultPoint3 = resultPoint;
                resultPoint = new ResultPoint(nArray2[1], f3);
                resultPointArray[1] = resultPoint3;
                n7 = 1;
                break;
            }
            n4 += 5;
        }
        if (n7 != 0) {
            ResultPoint resultPoint;
            ResultPoint resultPoint4;
            n7 = 0;
            int[] nArray5 = new int[2];
            nArray2 = nArray5;
            nArray2[0] = (int)resultPointArray[0].getX();
            nArray5[1] = (int)resultPointArray[1].getX();
            for (n5 = n4 + 1; n5 < n2; ++n5) {
                int[] nArray6 = Detector.findGuardPattern((BitMatrix)object, nArray2[0], n5, n3, false, nArray, nArray3);
                if (nArray6 != null && Math.abs(nArray2[0] - nArray6[0]) < 5 && Math.abs(nArray2[1] - nArray6[1]) < 5) {
                    n7 = 0;
                } else {
                    if (n7 > 25) break;
                    ++n7;
                    nArray6 = nArray2;
                }
                nArray2 = nArray6;
            }
            object = resultPoint4;
            float f4 = nArray2[0];
            float f5 = n5 -= n7 + 1;
            resultPoint4 = new ResultPoint(f4, f5);
            resultPointArray[2] = object;
            object = resultPoint;
            resultPoint = new ResultPoint(nArray2[1], f5);
            resultPointArray[3] = object;
        }
        if (n5 - n4 < 10) {
            for (int i2 = 0; i2 < n6; ++i2) {
                resultPointArray[i2] = null;
            }
        }
        return resultPointArray;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] findGuardPattern(BitMatrix bitMatrix, int n2, int n3, int n4, boolean bl, int[] nArray, int[] nArray2) {
        void var4_6;
        void var5_7;
        void var6_8;
        void v0 = var6_8;
        Arrays.fill((int[])v0, 0, ((void)v0).length, 0);
        int n5 = ((void)var5_7).length;
        int n6 = 0;
        while (bitMatrix.get(n2, n3) && n2 > 0 && n6++ < 3) {
            --n2;
        }
        int n7 = n6 = 0;
        int n8 = n2;
        n6 = bl ? 1 : 0;
        int n9 = n7;
        while (n2 < n4) {
            if ((bitMatrix.get(n2, n3) ^ n6) != 0) {
                var6_8[n9] = var6_8[n9] + true;
            } else {
                int n10 = n5 - 1;
                if (n9 == n10) {
                    if (Detector.patternMatchVariance((int[])var6_8, (int[])var5_7, 0.8f) < 0.42f) {
                        return new int[]{var4_6, n2};
                    }
                    int n11 = n10;
                    void v3 = var6_8;
                    var4_6 += var6_8[0] + var6_8[1];
                    n10 = n5 - 2;
                    System.arraycopy(v3, 2, var6_8, 0, n10);
                    v3[n10] = false;
                    var6_8[n11] = false;
                    --n9;
                } else {
                    ++n9;
                }
                var6_8[n9] = true;
                n6 ^= 1;
            }
            ++n2;
        }
        if (n9 == n5 - 1 && Detector.patternMatchVariance((int[])var6_8, (int[])var5_7, 0.8f) < 0.42f) {
            return new int[]{var4_6, n2 - 1};
        }
        return null;
    }

    private static float patternMatchVariance(int[] nArray, int[] nArray2, float f2) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += nArray[i2];
            n4 += nArray2[i2];
        }
        if (n3 < n4) {
            return Float.POSITIVE_INFINITY;
        }
        float f3 = f2;
        f2 = n3;
        float f4 = f2 / (float)n4;
        float f5 = f3 * f4;
        float f6 = 0.0f;
        for (int i3 = 0; i3 < n2; ++i3) {
            float f7;
            float f8 = (float)nArray2[i3] * f4;
            float f9 = nArray[i3];
            f8 = f7 > f8 ? f9 - f8 : (f8 -= f9);
            if (f8 > f5) {
                return Float.POSITIVE_INFINITY;
            }
            f6 += f8;
        }
        return f6 / f2;
    }
}

