/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder.ec;

import com.dcloud.zxing2.pdf417.decoder.ec.ModulusGF;

final class ModulusPoly {
    private final ModulusGF field;
    private final int[] coefficients;

    ModulusPoly(ModulusGF modulusGF, int[] nArray) {
        if (nArray.length != 0) {
            ((ModulusPoly)object).field = modulusGF;
            int n2 = nArray.length;
            if (n2 > 1 && nArray[0] == 0) {
                int n3;
                for (n3 = 1; n3 < n2 && nArray[n3] == 0; ++n3) {
                }
                if (n3 == n2) {
                    ModulusPoly modulusPoly = object;
                    int[] nArray2 = new int[1];
                    Object object = nArray2;
                    nArray2[0] = 0;
                    modulusPoly.coefficients = (int[])object;
                } else {
                    int[] nArray3 = new int[n2 - n3];
                    ((ModulusPoly)object).coefficients = nArray3;
                    int n4 = nArray3.length;
                    System.arraycopy(nArray, n3, nArray3, 0, n4);
                }
            } else {
                ((ModulusPoly)object).coefficients = nArray;
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        return this.coefficients[0] == 0;
    }

    int getCoefficient(int n2) {
        return this.coefficients[this.coefficients.length - 1 - n2];
    }

    int evaluateAt(int n2) {
        if (n2 == 0) {
            return this.getCoefficient(0);
        }
        int[] nArray = this.coefficients;
        int n3 = this.coefficients.length;
        if (n2 == 1) {
            n2 = 0;
            for (int n4 : nArray) {
                n2 = this.field.add(n2, n4);
            }
            return n2;
        }
        int n5 = nArray[0];
        for (int i2 = 1; i2 < n3; ++i2) {
            ModulusGF modulusGF = this.field;
            n5 = modulusGF.add(modulusGF.multiply(n2, n5), this.coefficients[i2]);
        }
        return n5;
    }

    ModulusPoly add(ModulusPoly object) {
        if (this.field.equals(((ModulusPoly)object).field)) {
            if (this.isZero()) {
                return object;
            }
            if (((ModulusPoly)object).isZero()) {
                return this;
            }
            object = this.coefficients;
            Object object2 = ((ModulusPoly)object).coefficients;
            if (((Object)object).length > ((int[])object2).length) {
                Object object3 = object;
                object = object2;
                object2 = object3;
            }
            int[] nArray = new int[((int[])object2).length];
            int n2 = ((int[])object2).length - ((Object)object).length;
            System.arraycopy(object2, 0, nArray, 0, n2);
            for (int i2 = n2; i2 < ((int[])object2).length; ++i2) {
                Object object4 = object[i2 - n2];
                nArray[i2] = this.field.add((int)object4, object2[i2]);
            }
            return new ModulusPoly(this.field, nArray);
        }
        throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
    }

    ModulusPoly subtract(ModulusPoly modulusPoly) {
        if (this.field.equals(modulusPoly.field)) {
            if (modulusPoly.isZero()) {
                return this;
            }
            return this.add(modulusPoly.negative());
        }
        throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
    }

    ModulusPoly multiply(ModulusPoly object) {
        if (this.field.equals(((ModulusPoly)object).field)) {
            if (!this.isZero() && !((ModulusPoly)object).isZero()) {
                int[] nArray = this.coefficients;
                int n2 = this.coefficients.length;
                object = ((ModulusPoly)object).coefficients;
                int n3 = ((ModulusPoly)object).coefficients.length;
                int[] nArray2 = new int[n2 + n3 - 1];
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n4 = nArray[i2];
                    for (int i3 = 0; i3 < n3; ++i3) {
                        int n5 = i2 + i3;
                        ModulusGF modulusGF = this.field;
                        int n6 = nArray2[n5];
                        nArray2[n5] = modulusGF.add(n6, modulusGF.multiply(n4, (int)object[i3]));
                    }
                }
                return new ModulusPoly(this.field, nArray2);
            }
            return this.field.getZero();
        }
        throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
    }

    ModulusPoly negative() {
        int n2 = this.coefficients.length;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.field.subtract(0, this.coefficients[i2]);
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly multiply(int n2) {
        if (n2 == 0) {
            return this.field.getZero();
        }
        if (n2 == 1) {
            return this;
        }
        int n3 = this.coefficients.length;
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = this.field.multiply(this.coefficients[i2], n2);
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly multiplyByMonomial(int n2, int n3) {
        if (n2 >= 0) {
            if (n3 == 0) {
                return this.field.getZero();
            }
            int n4 = this.coefficients.length;
            int[] nArray = new int[n4 + n2];
            for (int i2 = 0; i2 < n4; ++i2) {
                nArray[i2] = this.field.multiply(this.coefficients[i2], n3);
            }
            return new ModulusPoly(this.field, nArray);
        }
        throw new IllegalArgumentException();
    }

    ModulusPoly[] divide(ModulusPoly modulusPoly) {
        if (this.field.equals(modulusPoly.field)) {
            if (!modulusPoly.isZero()) {
                ModulusPoly modulusPoly2 = modulusPoly;
                ModulusPoly modulusPoly3 = this.field.getZero();
                int n2 = modulusPoly2.getCoefficient(modulusPoly2.getDegree());
                n2 = this.field.inverse(n2);
                ModulusPoly modulusPoly4 = this;
                while (modulusPoly4.getDegree() >= modulusPoly.getDegree() && !modulusPoly4.isZero()) {
                    int n3 = modulusPoly4.getDegree() - modulusPoly.getDegree();
                    ModulusPoly modulusPoly5 = modulusPoly4;
                    int n4 = this.field.multiply(modulusPoly5.getCoefficient(modulusPoly5.getDegree()), n2);
                    ModulusPoly modulusPoly6 = modulusPoly.multiplyByMonomial(n3, n4);
                    modulusPoly3 = modulusPoly3.add(this.field.buildMonomial(n3, n4));
                    modulusPoly4 = modulusPoly4.subtract(modulusPoly6);
                }
                return new ModulusPoly[]{modulusPoly3, modulusPoly4};
            }
            throw new IllegalArgumentException("Divide by 0");
        }
        throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(this.getDegree() * 8);
        for (int i2 = this.getDegree(); i2 >= 0; --i2) {
            int n2 = this.getCoefficient(i2);
            if (n2 == 0) continue;
            if (n2 < 0) {
                stringBuilder2.append(" - ");
                n2 = -n2;
            } else if (stringBuilder2.length() > 0) {
                stringBuilder2.append(" + ");
            }
            if (i2 == 0 || n2 != 1) {
                stringBuilder2.append(n2);
            }
            if (i2 == 0) continue;
            if (i2 == 1) {
                stringBuilder2.append('x');
                continue;
            }
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3.append("x^");
            stringBuilder3.append(i2);
        }
        return stringBuilder2.toString();
    }
}

