/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder;

import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.pdf417.PDF417Common;
import com.dcloud.zxing2.pdf417.decoder.BarcodeMetadata;
import com.dcloud.zxing2.pdf417.decoder.BarcodeValue;
import com.dcloud.zxing2.pdf417.decoder.BoundingBox;
import com.dcloud.zxing2.pdf417.decoder.Codeword;
import com.dcloud.zxing2.pdf417.decoder.DecodedBitStreamParser;
import com.dcloud.zxing2.pdf417.decoder.DetectionResult;
import com.dcloud.zxing2.pdf417.decoder.DetectionResultColumn;
import com.dcloud.zxing2.pdf417.decoder.DetectionResultRowIndicatorColumn;
import com.dcloud.zxing2.pdf417.decoder.PDF417CodewordDecoder;
import com.dcloud.zxing2.pdf417.decoder.ec.ErrorCorrection;
import java.util.ArrayList;
import java.util.Formatter;

public final class PDF417ScanningDecoder {
    private static final int CODEWORD_SKEW_SIZE = 2;
    private static final int MAX_ERRORS = 3;
    private static final int MAX_EC_CODEWORDS = 512;
    private static final ErrorCorrection errorCorrection = new ErrorCorrection();

    private PDF417ScanningDecoder() {
    }

    /*
     * Unable to fully structure code
     */
    public static DecoderResult decode(BitMatrix var0, ResultPoint var1_1, ResultPoint var2_3, ResultPoint var3_5, ResultPoint var4_7, int var5_9, int var6_10) throws NotFoundException, FormatException, ChecksumException {
        var7_11 = v0;
        v0 = new BoundingBox(var0, var1_1, (ResultPoint)var2_3, var3_5, (ResultPoint)var4_7);
        var2_3 = null;
        var4_7 = null;
        var8_12 = null;
        for (var9_13 = 0; var9_13 < 2; ++var9_13) {
            if (var1_1 != null) {
                var2_3 = PDF417ScanningDecoder.getRowIndicatorColumn(var0, var7_11, var1_1, true, var5_9, var6_10);
            }
            if (var3_5 != null) {
                var4_7 = PDF417ScanningDecoder.getRowIndicatorColumn(var0, var7_11, var3_5, false, var5_9, var6_10);
            }
            if ((var8_12 = PDF417ScanningDecoder.merge((DetectionResultRowIndicatorColumn)var2_3, (DetectionResultRowIndicatorColumn)var4_7)) != null) {
                if (var9_13 == 0 && var8_12.getBoundingBox() != null && (var8_12.getBoundingBox().getMinY() < var7_11.getMinY() || var8_12.getBoundingBox().getMaxY() > var7_11.getMaxY())) {
                    var7_11 = var8_12.getBoundingBox();
                    continue;
                }
                var8_12.setBoundingBox(var7_11);
                break;
            }
            throw NotFoundException.getNotFoundInstance();
        }
        v1 = var8_12;
        var1_2 = v1.getBarcodeColumnCount() + 1;
        v1.setDetectionResultColumn(0, (DetectionResultColumn)var2_3);
        v1.setDetectionResultColumn(var1_2, (DetectionResultColumn)var4_7);
        var2_4 = var2_3 != null;
        for (var3_6 = 1; var3_6 <= var1_2; ++var3_6) {
            var4_8 = var2_4 != false ? var3_6 : var1_2 - var3_6;
            if (var8_12.getDetectionResultColumn(var4_8) != null) continue;
            if (var4_8 != 0 && var4_8 != var1_2) {
                var9_14 = v2;
                v2 = new DetectionResultColumn(var7_11);
            } else {
                var10_15 = var4_8 == 0 ? 1 : 0;
                var9_14 = new DetectionResultRowIndicatorColumn(var7_11, (boolean)var10_15);
            }
            var8_12.setDetectionResultColumn(var4_8, var9_14);
            var10_15 = -1;
            for (var11_16 = var7_11.getMinY(); var11_16 <= var7_11.getMaxY(); ++var11_16) {
                block11: {
                    var12_17 = PDF417ScanningDecoder.getStartColumn(var8_12, var4_8, var11_16, var2_4);
                    if (var12_17 >= 0 && var12_17 <= var7_11.getMaxX()) break block11;
                    if (var10_15 == -1) ** GOTO lbl-1000
                    var12_17 = var10_15;
                }
                v3 = var7_11;
                var13_19 = v3.getMinX();
                var13_18 = PDF417ScanningDecoder.detectCodeword(var0, var13_19, v3.getMaxX(), var2_4, var12_17, var11_16, var5_9, var6_10);
                if (var13_18 != null) {
                    var9_14.setCodeword(var11_16, var13_18);
                    var5_9 = Math.min(var5_9, var13_18.getWidth());
                    var6_10 = Math.max(var6_10, var13_18.getWidth());
                } else lbl-1000:
                // 2 sources

                {
                    var12_17 = var10_15;
                }
                var10_15 = var12_17;
            }
        }
        return PDF417ScanningDecoder.createDecoderResult(var8_12);
    }

    private static DetectionResult merge(DetectionResultRowIndicatorColumn object, DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn) throws NotFoundException, FormatException {
        if (object == null && detectionResultRowIndicatorColumn == null) {
            return null;
        }
        BarcodeMetadata barcodeMetadata = PDF417ScanningDecoder.getBarcodeMetadata((DetectionResultRowIndicatorColumn)object, detectionResultRowIndicatorColumn);
        if (barcodeMetadata == null) {
            return null;
        }
        object = BoundingBox.merge(PDF417ScanningDecoder.adjustBoundingBox((DetectionResultRowIndicatorColumn)object), PDF417ScanningDecoder.adjustBoundingBox(detectionResultRowIndicatorColumn));
        return new DetectionResult(barcodeMetadata, (BoundingBox)object);
    }

    private static BoundingBox adjustBoundingBox(DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn) throws NotFoundException, FormatException {
        if (detectionResultRowIndicatorColumn == null) {
            return null;
        }
        int[] nArray = detectionResultRowIndicatorColumn.getRowHeights();
        if (nArray == null) {
            return null;
        }
        int n2 = PDF417ScanningDecoder.getMax(nArray);
        int n3 = 0;
        for (int n4 : nArray) {
            n3 += n2 - n4;
            if (n4 > 0) break;
        }
        Codeword[] codewordArray = detectionResultRowIndicatorColumn.getCodewords();
        int n5 = 0;
        while (n3 > 0 && codewordArray[n5] == null) {
            --n3;
            ++n5;
        }
        n5 = 0;
        for (int n4 = nArray.length - 1; n4 >= 0; --n4) {
            n5 += n2 - nArray[n4];
            if (nArray[n4] > 0) break;
        }
        int n6 = codewordArray.length - 1;
        while (n5 > 0 && codewordArray[n6] == null) {
            --n5;
            --n6;
        }
        return detectionResultRowIndicatorColumn.getBoundingBox().addMissingRows(n3, n5, detectionResultRowIndicatorColumn.isLeft());
    }

    private static int getMax(int[] nArray) {
        int n2 = -1;
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = Math.max(n2, nArray[i2]);
        }
        return n2;
    }

    private static BarcodeMetadata getBarcodeMetadata(DetectionResultRowIndicatorColumn object, DetectionResultRowIndicatorColumn object2) {
        if (object != null && (object = ((DetectionResultRowIndicatorColumn)object).getBarcodeMetadata()) != null) {
            if (object2 != null && (object2 = ((DetectionResultRowIndicatorColumn)object2).getBarcodeMetadata()) != null) {
                if (((BarcodeMetadata)object).getColumnCount() != ((BarcodeMetadata)object2).getColumnCount() && ((BarcodeMetadata)object).getErrorCorrectionLevel() != ((BarcodeMetadata)object2).getErrorCorrectionLevel() && ((BarcodeMetadata)object).getRowCount() != ((BarcodeMetadata)object2).getRowCount()) {
                    return null;
                }
                return object;
            }
            return object;
        }
        return object2 == null ? null : ((DetectionResultRowIndicatorColumn)object2).getBarcodeMetadata();
    }

    private static DetectionResultRowIndicatorColumn getRowIndicatorColumn(BitMatrix bitMatrix, BoundingBox boundingBox, ResultPoint resultPoint, boolean bl, int n2, int n3) {
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn;
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn2 = detectionResultRowIndicatorColumn;
        detectionResultRowIndicatorColumn = new DetectionResultRowIndicatorColumn(boundingBox, bl);
        for (int i2 = 0; i2 < 2; ++i2) {
            int n4 = i2 == 0 ? 1 : -1;
            int n5 = (int)resultPoint.getX();
            for (int i3 = (int)(v684314).getY(); i3 <= boundingBox.getMaxY() && i3 >= boundingBox.getMinY(); i3 += n4) {
                BitMatrix bitMatrix2 = bitMatrix;
                Codeword codeword = PDF417ScanningDecoder.detectCodeword(bitMatrix2, 0, bitMatrix2.getWidth(), bl, n5, i3, n2, n3);
                if (codeword == null) continue;
                detectionResultRowIndicatorColumn2.setCodeword(i3, codeword);
                n5 = bl ? codeword.getStartX() : codeword.getEndX();
            }
        }
        return detectionResultRowIndicatorColumn2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void adjustCodewordCount(DetectionResult detectionResult, BarcodeValue[][] barcodeValueArray) throws NotFoundException {
        int[] nArray = barcodeValueArray[0][1].getValue();
        int n2 = detectionResult.getBarcodeColumnCount() * detectionResult.getBarcodeRowCount() - PDF417ScanningDecoder.getNumberOfECCodeWords(detectionResult.getBarcodeECLevel());
        if (nArray.length == 0) {
            if (n2 < 1 || n2 > 928) throw NotFoundException.getNotFoundInstance();
            barcodeValueArray[0][1].setValue(n2);
            return;
        } else {
            if (nArray[0] == n2) return;
            barcodeValueArray[0][1].setValue(n2);
        }
    }

    private static DecoderResult createDecoderResult(DetectionResult object) throws FormatException, ChecksumException, NotFoundException {
        int n2;
        ArrayList<Integer> arrayList;
        ArrayList<int[]> arrayList2;
        ArrayList<Integer> arrayList3;
        DetectionResult detectionResult = object;
        BarcodeValue[][] barcodeValueArray = PDF417ScanningDecoder.createBarcodeMatrix(detectionResult);
        PDF417ScanningDecoder.adjustCodewordCount(detectionResult, barcodeValueArray);
        ArrayList<Integer> arrayList4 = arrayList3;
        arrayList3 = new ArrayList<Integer>();
        int[] nArray = new int[detectionResult.getBarcodeRowCount() * ((DetectionResult)object).getBarcodeColumnCount()];
        ArrayList<int[]> arrayList5 = arrayList2;
        arrayList2 = new ArrayList<int[]>();
        ArrayList<Integer> arrayList6 = arrayList;
        arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < ((DetectionResult)object).getBarcodeRowCount(); ++i2) {
            n2 = 0;
            while (n2 < ((DetectionResult)object).getBarcodeColumnCount()) {
                int n3 = n2 + 1;
                int[] nArray2 = barcodeValueArray[i2][n3].getValue();
                n2 = i2 * ((DetectionResult)object).getBarcodeColumnCount() + n2;
                if (nArray2.length == 0) {
                    arrayList4.add(n2);
                } else if (nArray2.length == 1) {
                    nArray[n2] = nArray2[0];
                } else {
                    arrayList6.add(n2);
                    arrayList5.add(nArray2);
                }
                n2 = n3;
            }
        }
        int n4 = arrayList5.size();
        int[][] nArrayArray = new int[n4][];
        for (n2 = 0; n2 < n4; ++n2) {
            nArrayArray[n2] = (int[])arrayList5.get(n2);
        }
        int n5 = ((DetectionResult)object).getBarcodeECLevel();
        object = PDF417Common.toIntArray(arrayList4);
        return PDF417ScanningDecoder.createDecoderResultFromAmbiguousValues(n5, nArray, (int[])object, PDF417Common.toIntArray(arrayList6), nArrayArray);
    }

    private static DecoderResult createDecoderResultFromAmbiguousValues(int n2, int[] nArray, int[] nArray2, int[] nArray3, int[][] nArray4) throws FormatException, ChecksumException {
        int n3 = nArray3.length;
        int[] nArray5 = new int[n3];
        int n4 = 100;
        block2: while (true) {
            int n5;
            int n6 = n4;
            n4 = n6 + -1;
            if (n6 <= 0) break;
            for (n5 = 0; n5 < n3; ++n5) {
                int n7 = nArray3[n5];
                nArray[n7] = nArray4[n5][nArray5[n5]];
            }
            try {
                return PDF417ScanningDecoder.decodeCodewords(nArray, n2, nArray2);
            }
            catch (ChecksumException checksumException) {
                if (n3 != 0) {
                    n5 = 0;
                    while (true) {
                        if (n5 >= n3) continue block2;
                        if (nArray5[n5] < nArray4[n5].length - 1) {
                            nArray5[n5] = nArray5[n5] + 1;
                            continue block2;
                        }
                        nArray5[n5] = 0;
                        if (n5 == n3 - 1) break;
                        ++n5;
                    }
                    throw ChecksumException.getChecksumInstance();
                }
                throw ChecksumException.getChecksumInstance();
            }
            break;
        }
        throw ChecksumException.getChecksumInstance();
    }

    private static BarcodeValue[][] createBarcodeMatrix(DetectionResult detectionResult) throws FormatException {
        BarcodeValue[][] barcodeValueArray = new BarcodeValue[detectionResult.getBarcodeRowCount()][detectionResult.getBarcodeColumnCount() + 2];
        for (int i2 = 0; i2 < barcodeValueArray.length; ++i2) {
            for (int i3 = 0; i3 < barcodeValueArray[i2].length; ++i3) {
                BarcodeValue barcodeValue;
                BarcodeValue barcodeValue2 = barcodeValue;
                barcodeValue = new BarcodeValue();
                barcodeValueArray[i2][i3] = barcodeValue2;
            }
        }
        int n2 = 0;
        for (DetectionResultColumn detectionResultColumn : detectionResult.getDetectionResultColumns()) {
            if (detectionResultColumn != null) {
                for (Codeword codeword : detectionResultColumn.getCodewords()) {
                    int n3;
                    if (codeword == null || (n3 = codeword.getRowNumber()) < 0 || n3 >= barcodeValueArray.length) continue;
                    barcodeValueArray[n3][n2].setValue(codeword.getValue());
                }
            }
            ++n2;
        }
        return barcodeValueArray;
    }

    private static boolean isValidBarcodeColumn(DetectionResult detectionResult, int n2) {
        return n2 >= 0 && n2 <= detectionResult.getBarcodeColumnCount() + 1;
    }

    /*
     * WARNING - void declaration
     */
    private static int getStartColumn(DetectionResult detectionResult, int n2, int n3, boolean bl) {
        void var5_10;
        void var5_7;
        int n4 = bl ? 1 : -1;
        Object object = null;
        int n5 = n2 - n4;
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, n5)) {
            Codeword codeword = detectionResult.getDetectionResultColumn(n5).getCodeword(n3);
        }
        if (var5_7 != null) {
            return bl ? var5_7.getEndX() : var5_7.getStartX();
        }
        Codeword codeword = detectionResult.getDetectionResultColumn(n2).getCodewordNearby(n3);
        if (codeword != null) {
            return bl ? codeword.getStartX() : codeword.getEndX();
        }
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, n5)) {
            Codeword codeword2 = detectionResult.getDetectionResultColumn(n5).getCodewordNearby(n3);
        }
        if (var5_10 != null) {
            return bl ? var5_10.getEndX() : var5_10.getStartX();
        }
        n3 = 0;
        while (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, n2 -= n4)) {
            for (Codeword codeword3 : detectionResult.getDetectionResultColumn(n2).getCodewords()) {
                if (codeword3 == null) continue;
                return (bl ? codeword3.getEndX() : codeword3.getStartX()) + n4 * n3 * (codeword3.getEndX() - codeword3.getStartX());
            }
            ++n3;
        }
        return bl ? detectionResult.getBoundingBox().getMinX() : detectionResult.getBoundingBox().getMaxX();
    }

    private static Codeword detectCodeword(BitMatrix bitMatrix, int n2, int n3, boolean n4, int n5, int n6, int n7, int n8) {
        BitMatrix bitMatrix2 = bitMatrix;
        int n9 = PDF417ScanningDecoder.adjustCodewordStartColumn(bitMatrix2, n2, n3, n4 != 0, n5, n6);
        int[] nArray = PDF417ScanningDecoder.getModuleBitCount(bitMatrix2, n2, n3, n4 != 0, n9, n6);
        if (nArray == null) {
            return null;
        }
        n3 = PDF417Common.getBitCountSum(nArray);
        if (n4 != 0) {
            n4 = n9 + n3;
            int n10 = n9;
            n9 = n4;
            n4 = n10;
        } else {
            for (n4 = 0; n4 < nArray.length / 2; ++n4) {
                int[] nArray2 = nArray;
                n5 = nArray[n4];
                nArray2[n4] = nArray[nArray.length - 1 - n4];
                nArray[nArray2.length - 1 - n4] = n5;
            }
            n4 = n9 - n3;
        }
        if (!PDF417ScanningDecoder.checkCodewordSkew(n3, n7, n8)) {
            return null;
        }
        int n11 = PDF417CodewordDecoder.getDecodedValue(nArray);
        n3 = PDF417Common.getCodeword(n11);
        if (n3 == -1) {
            return null;
        }
        n11 = PDF417ScanningDecoder.getCodewordBucketNumber(n11);
        return new Codeword(n4, n9, n11, n3);
    }

    private static int[] getModuleBitCount(BitMatrix bitMatrix, int n2, int n3, boolean bl, int n4, int n5) {
        int n6 = 8;
        int[] nArray = new int[8];
        int n7 = 0;
        int n8 = bl ? 1 : -1;
        boolean bl2 = bl;
        while ((bl && n4 < n3 || !bl && n4 >= n2) && n7 < n6) {
            if (bitMatrix.get(n4, n5) == bl2) {
                nArray[n7] = nArray[n7] + 1;
                n4 += n8;
                continue;
            }
            ++n7;
            bl2 ^= true;
        }
        if (!(n7 == n6 || (bl && n4 == n3 || !bl && n4 == n2) && n7 == 7)) {
            return null;
        }
        return nArray;
    }

    private static int getNumberOfECCodeWords(int n2) {
        return 2 << n2;
    }

    private static int adjustCodewordStartColumn(BitMatrix bitMatrix, int n2, int n3, boolean bl, int n4, int n5) {
        int n6 = bl ? -1 : 1;
        int n7 = n4;
        for (int i2 = 0; i2 < 2; ++i2) {
            while ((bl && n7 >= n2 || !bl && n7 < n3) && bl == bitMatrix.get(n7, n5)) {
                if (Math.abs(n4 - n7) > 2) {
                    return n4;
                }
                n7 += n6;
            }
            n6 = -n6;
            bl ^= true;
        }
        return n7;
    }

    private static boolean checkCodewordSkew(int n2, int n3, int n4) {
        return n3 - 2 <= n2 && n2 <= n4 + 2;
    }

    private static DecoderResult decodeCodewords(int[] nArray, int n2, int[] nArray2) throws FormatException, ChecksumException {
        if (nArray.length != 0) {
            int n3 = n2;
            int n4 = 1 << n2 + 1;
            n2 = PDF417ScanningDecoder.correctErrors(nArray, nArray2, n4);
            PDF417ScanningDecoder.verifyCodewordCount(nArray, n4);
            DecoderResult decoderResult = DecodedBitStreamParser.decode(nArray, String.valueOf(n3));
            decoderResult.setErrorsCorrected(n2);
            decoderResult.setErasures(nArray2.length);
            return decoderResult;
        }
        throw FormatException.getFormatInstance();
    }

    private static int correctErrors(int[] nArray, int[] nArray2, int n2) throws ChecksumException {
        if ((nArray2 == null || nArray2.length <= n2 / 2 + 3) && n2 >= 0 && n2 <= 512) {
            return errorCorrection.decode(nArray, n2, nArray2);
        }
        throw ChecksumException.getChecksumInstance();
    }

    private static void verifyCodewordCount(int[] nArray, int n2) throws FormatException {
        if (nArray.length >= 4) {
            int n3 = nArray[0];
            if (n3 <= nArray.length) {
                if (n3 == 0) {
                    if (n2 < nArray.length) {
                        nArray[0] = nArray.length - n2;
                    } else {
                        throw FormatException.getFormatInstance();
                    }
                }
                return;
            }
            throw FormatException.getFormatInstance();
        }
        throw FormatException.getFormatInstance();
    }

    private static int[] getBitCountForCodeword(int n2) {
        int[] nArray = new int[8];
        int n3 = 0;
        int n4 = 7;
        while (true) {
            int n5;
            if ((n5 = n2 & 1) != n3) {
                if ((n4 += -1) < 0) {
                    return nArray;
                }
            } else {
                n5 = n3;
            }
            nArray[n4] = nArray[n4] + 1;
            n2 >>= 1;
            n3 = n5;
        }
    }

    private static int getCodewordBucketNumber(int n2) {
        return PDF417ScanningDecoder.getCodewordBucketNumber(PDF417ScanningDecoder.getBitCountForCodeword(n2));
    }

    private static int getCodewordBucketNumber(int[] nArray) {
        return (nArray[0] - nArray[2] + nArray[4] - nArray[6] + 9) % 9;
    }

    public static String toString(BarcodeValue[][] barcodeValueArray) {
        Formatter formatter;
        Formatter formatter2 = formatter;
        formatter = new Formatter();
        for (int i2 = 0; i2 < barcodeValueArray.length; ++i2) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = i2;
            formatter2.format("Row %2d: ", objectArray2);
            for (int i3 = 0; i3 < barcodeValueArray[i2].length; ++i3) {
                BarcodeValue barcodeValue = barcodeValueArray[i2][i3];
                if (barcodeValue.getValue().length == 0) {
                    formatter2.format("        ", null);
                    continue;
                }
                Object[] objectArray3 = new Object[2];
                Object[] objectArray4 = objectArray3;
                BarcodeValue barcodeValue2 = barcodeValue;
                objectArray4[0] = barcodeValue.getValue()[0];
                objectArray3[1] = barcodeValue2.getConfidence(barcodeValue2.getValue()[0]);
                formatter2.format("%4d(%2d)", objectArray4);
            }
            formatter2.format("%n", new Object[0]);
        }
        String string2 = formatter2.toString();
        formatter2.close();
        return string2;
    }
}

