/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder;

import com.dcloud.zxing2.pdf417.decoder.BarcodeMetadata;
import com.dcloud.zxing2.pdf417.decoder.BoundingBox;
import com.dcloud.zxing2.pdf417.decoder.Codeword;
import com.dcloud.zxing2.pdf417.decoder.DetectionResultColumn;
import com.dcloud.zxing2.pdf417.decoder.DetectionResultRowIndicatorColumn;
import java.util.Formatter;

final class DetectionResult {
    private static final int ADJUST_ROW_NUMBER_SKIP = 2;
    private final BarcodeMetadata barcodeMetadata;
    private final DetectionResultColumn[] detectionResultColumns;
    private BoundingBox boundingBox;
    private final int barcodeColumnCount;

    DetectionResult(BarcodeMetadata barcodeMetadata, BoundingBox boundingBox) {
        int n2;
        this.barcodeMetadata = barcodeMetadata;
        this.barcodeColumnCount = n2 = barcodeMetadata.getColumnCount();
        this.boundingBox = boundingBox;
        this.detectionResultColumns = new DetectionResultColumn[n2 + 2];
    }

    private void adjustIndicatorColumnRowNumbers(DetectionResultColumn detectionResultColumn) {
        if (detectionResultColumn != null) {
            ((DetectionResultRowIndicatorColumn)detectionResultColumn).adjustCompleteIndicatorColumnRowNumbers(this.barcodeMetadata);
        }
    }

    private int adjustRowNumbers() {
        int n2 = this.adjustRowNumbersByRow();
        if (n2 == 0) {
            return 0;
        }
        for (int i2 = 1; i2 < this.barcodeColumnCount + 1; ++i2) {
            Codeword[] codewordArray = this.detectionResultColumns[i2].getCodewords();
            for (int i3 = 0; i3 < codewordArray.length; ++i3) {
                if (codewordArray[i3] == null || codewordArray[i3].hasValidRowNumber()) continue;
                this.adjustRowNumbers(i2, i3, codewordArray);
            }
        }
        return n2;
    }

    private int adjustRowNumbersByRow() {
        DetectionResult detectionResult = this;
        detectionResult.adjustRowNumbersFromBothRI();
        return detectionResult.adjustRowNumbersFromLRI() + this.adjustRowNumbersFromRRI();
    }

    private void adjustRowNumbersFromBothRI() {
        Object[] objectArray = this.detectionResultColumns;
        if (this.detectionResultColumns[0] != null && objectArray[this.barcodeColumnCount + 1] != null) {
            objectArray = objectArray[0].getCodewords();
            Codeword[] codewordArray = this.detectionResultColumns[this.barcodeColumnCount + 1].getCodewords();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (objectArray[i2] == null || codewordArray[i2] == null || ((Codeword)objectArray[i2]).getRowNumber() != codewordArray[i2].getRowNumber()) continue;
                for (int i3 = 1; i3 <= this.barcodeColumnCount; ++i3) {
                    Codeword codeword = this.detectionResultColumns[i3].getCodewords()[i2];
                    if (codeword == null) continue;
                    Codeword codeword2 = codeword;
                    codeword2.setRowNumber(((Codeword)objectArray[i2]).getRowNumber());
                    if (codeword2.hasValidRowNumber()) continue;
                    this.detectionResultColumns[i3].getCodewords()[i2] = null;
                }
            }
            return;
        }
    }

    private int adjustRowNumbersFromRRI() {
        DetectionResultColumn[] detectionResultColumnArray = this.detectionResultColumns;
        int n2 = this.barcodeColumnCount;
        if (this.detectionResultColumns[n2 + 1] == null) {
            return 0;
        }
        int n3 = 0;
        Codeword[] codewordArray = detectionResultColumnArray[n2 + 1].getCodewords();
        for (int i2 = 0; i2 < codewordArray.length; ++i2) {
            if (codewordArray[i2] == null) continue;
            int n4 = codewordArray[i2].getRowNumber();
            int n5 = 0;
            for (int i3 = this.barcodeColumnCount + 1; i3 > 0 && n5 < 2; --i3) {
                Codeword codeword = this.detectionResultColumns[i3].getCodewords()[i2];
                if (codeword == null) continue;
                n5 = DetectionResult.adjustRowNumberIfValid(n4, n5, codeword);
                if (codeword.hasValidRowNumber()) continue;
                ++n3;
            }
        }
        return n3;
    }

    private int adjustRowNumbersFromLRI() {
        DetectionResultColumn[] detectionResultColumnArray = this.detectionResultColumns;
        if (this.detectionResultColumns[0] == null) {
            return 0;
        }
        int n2 = 0;
        Codeword[] codewordArray = detectionResultColumnArray[0].getCodewords();
        for (int i2 = 0; i2 < codewordArray.length; ++i2) {
            if (codewordArray[i2] == null) continue;
            int n3 = codewordArray[i2].getRowNumber();
            int n4 = 0;
            for (int i3 = 1; i3 < this.barcodeColumnCount + 1 && n4 < 2; ++i3) {
                Codeword codeword = this.detectionResultColumns[i3].getCodewords()[i2];
                if (codeword == null) continue;
                n4 = DetectionResult.adjustRowNumberIfValid(n3, n4, codeword);
                if (codeword.hasValidRowNumber()) continue;
                ++n2;
            }
        }
        return n2;
    }

    private static int adjustRowNumberIfValid(int n2, int n3, Codeword codeword) {
        if (codeword == null) {
            return n3;
        }
        if (!codeword.hasValidRowNumber()) {
            if (codeword.isValidRowNumber(n2)) {
                codeword.setRowNumber(n2);
                n3 = 0;
            } else {
                ++n3;
            }
        }
        return n3;
    }

    private void adjustRowNumbers(int n2, int n3, Codeword[] codewordArray) {
        int n4;
        DetectionResult detectionResult = codeword;
        Codeword codeword = codewordArray[n3];
        Codeword[] codewordArray2 = detectionResult.detectionResultColumns[n2 - 1].getCodewords();
        DetectionResultColumn[] detectionResultColumnArray = detectionResult.detectionResultColumns;
        Codeword[] codewordArray3 = detectionResult.detectionResultColumns[++n2] != null ? detectionResultColumnArray[n2].getCodewords() : codewordArray2;
        int n5 = 14;
        Codeword[] codewordArray4 = new Codeword[14];
        Codeword[] codewordArray5 = codewordArray4;
        codewordArray5[2] = codewordArray2[n3];
        codewordArray4[3] = codewordArray3[n3];
        if (n3 > 0) {
            n4 = n3 - 1;
            codewordArray5[0] = codewordArray[n4];
            codewordArray5[4] = codewordArray2[n4];
            codewordArray5[5] = codewordArray3[n4];
        }
        if (n3 > 1) {
            n4 = n3 - 2;
            codewordArray5[8] = codewordArray[n4];
            codewordArray5[10] = codewordArray2[n4];
            codewordArray5[11] = codewordArray3[n4];
        }
        if (n3 < codewordArray.length - 1) {
            n4 = n3 + 1;
            codewordArray5[1] = codewordArray[n4];
            codewordArray5[6] = codewordArray2[n4];
            codewordArray5[7] = codewordArray3[n4];
        }
        if (n3 < codewordArray.length - 2) {
            int n6 = n3 + 2;
            codewordArray5[9] = codewordArray[n6];
            codewordArray5[12] = codewordArray2[n6];
            codewordArray5[13] = codewordArray3[n6];
        }
        for (int i2 = 0; i2 < n5; ++i2) {
            if (!DetectionResult.adjustRowNumber(codeword, codewordArray5[i2])) continue;
            return;
        }
    }

    private static boolean adjustRowNumber(Codeword codeword, Codeword codeword2) {
        if (codeword2 == null) {
            return false;
        }
        if (codeword2.hasValidRowNumber() && codeword2.getBucket() == codeword.getBucket()) {
            codeword.setRowNumber(codeword2.getRowNumber());
            return true;
        }
        return false;
    }

    DetectionResultColumn[] getDetectionResultColumns() {
        int n2;
        DetectionResult detectionResult = this;
        detectionResult.adjustIndicatorColumnRowNumbers(detectionResult.detectionResultColumns[0]);
        detectionResult.adjustIndicatorColumnRowNumbers(detectionResult.detectionResultColumns[this.barcodeColumnCount + 1]);
        int n3 = 928;
        while ((n2 = this.adjustRowNumbers()) > 0 && n2 < n3) {
            n3 = n2;
        }
        return this.detectionResultColumns;
    }

    int getBarcodeColumnCount() {
        return this.barcodeColumnCount;
    }

    int getBarcodeRowCount() {
        return this.barcodeMetadata.getRowCount();
    }

    int getBarcodeECLevel() {
        return this.barcodeMetadata.getErrorCorrectionLevel();
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    void setDetectionResultColumn(int n2, DetectionResultColumn detectionResultColumn) {
        this.detectionResultColumns[n2] = detectionResultColumn;
    }

    DetectionResultColumn getDetectionResultColumn(int n2) {
        return this.detectionResultColumns[n2];
    }

    public String toString() {
        Formatter formatter;
        Object object = this.detectionResultColumns;
        DetectionResultColumn detectionResultColumn = this.detectionResultColumns[0];
        if (detectionResultColumn == null) {
            detectionResultColumn = object[this.barcodeColumnCount + 1];
        }
        object = formatter;
        formatter = new Formatter();
        for (int i2 = 0; i2 < detectionResultColumn.getCodewords().length; ++i2) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = i2;
            ((Formatter)object).format("CW %3d:", objectArray2);
            for (int i3 = 0; i3 < this.barcodeColumnCount + 2; ++i3) {
                Object object2 = this.detectionResultColumns;
                if (this.detectionResultColumns[i3] == null) {
                    ((Formatter)object).format("    |   ", new Object[0]);
                    continue;
                }
                if ((object2 = object2[i3].getCodewords()[i2]) == null) {
                    ((Formatter)object).format("    |   ", new Object[0]);
                    continue;
                }
                Object[] objectArray3 = new Object[2];
                Object[] objectArray4 = objectArray3;
                objectArray4[0] = ((Codeword)object2).getRowNumber();
                objectArray3[1] = ((Codeword)object2).getValue();
                ((Formatter)object).format(" %3d|%3d", objectArray4);
            }
            ((Formatter)object).format("%n", new Object[0]);
        }
        String string2 = ((Formatter)object).toString();
        ((Formatter)object).close();
        return string2;
    }
}

