/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned.rss.expanded.decoders;

import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.rss.expanded.decoders.BlockParsedResult;
import com.dcloud.zxing2.oned.rss.expanded.decoders.CurrentParsingState;
import com.dcloud.zxing2.oned.rss.expanded.decoders.DecodedChar;
import com.dcloud.zxing2.oned.rss.expanded.decoders.DecodedInformation;
import com.dcloud.zxing2.oned.rss.expanded.decoders.DecodedNumeric;
import com.dcloud.zxing2.oned.rss.expanded.decoders.DecodedObject;
import com.dcloud.zxing2.oned.rss.expanded.decoders.FieldParser;

final class GeneralAppIdDecoder {
    private final BitArray information;
    private final CurrentParsingState current;
    private final StringBuilder buffer;

    GeneralAppIdDecoder(BitArray bitArray) {
        StringBuilder stringBuilder;
        CurrentParsingState currentParsingState;
        Object object = currentParsingState;
        currentParsingState = new CurrentParsingState();
        v1.current = object;
        object = stringBuilder;
        stringBuilder = new StringBuilder();
        v1.buffer = object;
        v1.information = bitArray;
    }

    private boolean isStillNumeric(int n2) {
        int n3;
        if (n2 + 7 > this.information.getSize()) {
            return n2 + 4 <= this.information.getSize();
        }
        for (int i2 = n2; i2 < (n3 = n2 + 3); ++i2) {
            if (!this.information.get(i2)) continue;
            return true;
        }
        return this.information.get(n3);
    }

    private DecodedNumeric decodeNumeric(int n2) throws FormatException {
        int n3 = n2 + 7;
        if (n3 > this.information.getSize()) {
            if ((n2 = this.extractNumericValueFromBitArray(n2, 4)) == 0) {
                return new DecodedNumeric(this.information.getSize(), 10, 10);
            }
            int n4 = this.information.getSize();
            return new DecodedNumeric(n4, n2 - 1, 10);
        }
        int n5 = this.extractNumericValueFromBitArray(n2, 7) - 8;
        int n6 = n5 / 11;
        n2 = n5 % 11;
        return new DecodedNumeric(n3, n6, n2);
    }

    static int extractNumericValueFromBitArray(BitArray bitArray, int n2, int n3) {
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!bitArray.get(n2 + i2)) continue;
            n4 |= 1 << n3 - i2 - 1;
        }
        return n4;
    }

    private DecodedInformation parseBlocks() throws FormatException {
        BlockParsedResult blockParsedResult;
        boolean bl;
        int n2;
        do {
            GeneralAppIdDecoder generalAppIdDecoder = this;
            n2 = generalAppIdDecoder.current.getPosition();
            if (generalAppIdDecoder.current.isAlpha()) {
                blockParsedResult = this.parseAlphaBlock();
                bl = blockParsedResult.isFinished();
                continue;
            }
            if (this.current.isIsoIec646()) {
                blockParsedResult = this.parseIsoIec646Block();
                bl = blockParsedResult.isFinished();
                continue;
            }
            blockParsedResult = this.parseNumericBlock();
            bl = blockParsedResult.isFinished();
        } while ((n2 != this.current.getPosition() || bl) && !bl);
        return blockParsedResult.getDecodedInformation();
    }

    private BlockParsedResult parseNumericBlock() throws FormatException {
        while (true) {
            GeneralAppIdDecoder generalAppIdDecoder = this;
            if (!generalAppIdDecoder.isStillNumeric(generalAppIdDecoder.current.getPosition())) break;
            GeneralAppIdDecoder generalAppIdDecoder2 = this;
            Object object = generalAppIdDecoder2.decodeNumeric(generalAppIdDecoder2.current.getPosition());
            this.current.setPosition(((DecodedObject)object).getNewPosition());
            if (((DecodedNumeric)object).isFirstDigitFNC1()) {
                DecodedObject decodedObject;
                if (((DecodedNumeric)object).isSecondDigitFNC1()) {
                    DecodedInformation decodedInformation;
                    object = decodedInformation;
                    decodedInformation = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                    decodedObject = object;
                } else {
                    DecodedInformation decodedInformation;
                    decodedObject = decodedInformation;
                    DecodedObject decodedObject2 = object;
                    GeneralAppIdDecoder generalAppIdDecoder3 = this;
                    int n2 = generalAppIdDecoder3.current.getPosition();
                    object = generalAppIdDecoder3.buffer.toString();
                    int n3 = ((DecodedNumeric)decodedObject2).getSecondDigit();
                    decodedInformation = new DecodedInformation(n2, (String)object, n3);
                }
                return new BlockParsedResult((DecodedInformation)decodedObject, true);
            }
            this.buffer.append(((DecodedNumeric)object).getFirstDigit());
            if (((DecodedNumeric)object).isSecondDigitFNC1()) {
                DecodedInformation decodedInformation;
                object = decodedInformation;
                decodedInformation = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult((DecodedInformation)object, true);
            }
            this.buffer.append(((DecodedNumeric)object).getSecondDigit());
        }
        GeneralAppIdDecoder generalAppIdDecoder = this;
        if (generalAppIdDecoder.isNumericToAlphaNumericLatch(generalAppIdDecoder.current.getPosition())) {
            GeneralAppIdDecoder generalAppIdDecoder4 = this;
            generalAppIdDecoder4.current.setAlpha();
            generalAppIdDecoder4.current.incrementPosition(4);
        }
        return new BlockParsedResult(false);
    }

    private BlockParsedResult parseIsoIec646Block() throws FormatException {
        while (true) {
            GeneralAppIdDecoder generalAppIdDecoder = this;
            if (!generalAppIdDecoder.isStillIsoIec646(generalAppIdDecoder.current.getPosition())) break;
            GeneralAppIdDecoder generalAppIdDecoder2 = this;
            DecodedObject decodedObject = generalAppIdDecoder2.decodeIsoIec646(generalAppIdDecoder2.current.getPosition());
            this.current.setPosition(decodedObject.getNewPosition());
            if (((DecodedChar)decodedObject).isFNC1()) {
                DecodedInformation decodedInformation;
                decodedObject = decodedInformation;
                decodedInformation = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult((DecodedInformation)decodedObject, true);
            }
            this.buffer.append(((DecodedChar)decodedObject).getValue());
        }
        GeneralAppIdDecoder generalAppIdDecoder = this;
        if (generalAppIdDecoder.isAlphaOr646ToNumericLatch(generalAppIdDecoder.current.getPosition())) {
            GeneralAppIdDecoder generalAppIdDecoder3 = this;
            generalAppIdDecoder3.current.incrementPosition(3);
            generalAppIdDecoder3.current.setNumeric();
        } else {
            GeneralAppIdDecoder generalAppIdDecoder4 = this;
            if (generalAppIdDecoder4.isAlphaTo646ToAlphaLatch(generalAppIdDecoder4.current.getPosition())) {
                if (this.current.getPosition() + 5 < this.information.getSize()) {
                    this.current.incrementPosition(5);
                } else {
                    this.current.setPosition(this.information.getSize());
                }
                this.current.setAlpha();
            }
        }
        return new BlockParsedResult(false);
    }

    private BlockParsedResult parseAlphaBlock() {
        while (true) {
            GeneralAppIdDecoder generalAppIdDecoder = this;
            if (!generalAppIdDecoder.isStillAlpha(generalAppIdDecoder.current.getPosition())) break;
            GeneralAppIdDecoder generalAppIdDecoder2 = this;
            DecodedObject decodedObject = generalAppIdDecoder2.decodeAlphanumeric(generalAppIdDecoder2.current.getPosition());
            this.current.setPosition(decodedObject.getNewPosition());
            if (((DecodedChar)decodedObject).isFNC1()) {
                DecodedInformation decodedInformation;
                decodedObject = decodedInformation;
                decodedInformation = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult((DecodedInformation)decodedObject, true);
            }
            this.buffer.append(((DecodedChar)decodedObject).getValue());
        }
        GeneralAppIdDecoder generalAppIdDecoder = this;
        if (generalAppIdDecoder.isAlphaOr646ToNumericLatch(generalAppIdDecoder.current.getPosition())) {
            GeneralAppIdDecoder generalAppIdDecoder3 = this;
            generalAppIdDecoder3.current.incrementPosition(3);
            generalAppIdDecoder3.current.setNumeric();
        } else {
            GeneralAppIdDecoder generalAppIdDecoder4 = this;
            if (generalAppIdDecoder4.isAlphaTo646ToAlphaLatch(generalAppIdDecoder4.current.getPosition())) {
                if (this.current.getPosition() + 5 < this.information.getSize()) {
                    this.current.incrementPosition(5);
                } else {
                    this.current.setPosition(this.information.getSize());
                }
                this.current.setIsoIec646();
            }
        }
        return new BlockParsedResult(false);
    }

    private boolean isStillIsoIec646(int n2) {
        if (n2 + 5 > this.information.getSize()) {
            return false;
        }
        int n3 = this.extractNumericValueFromBitArray(n2, 5);
        if (n3 >= 5 && n3 < 16) {
            return true;
        }
        if (n2 + 7 > this.information.getSize()) {
            return false;
        }
        n3 = this.extractNumericValueFromBitArray(n2, 7);
        if (n3 >= 64 && n3 < 116) {
            return true;
        }
        if (n2 + 8 > this.information.getSize()) {
            return false;
        }
        int n4 = this.extractNumericValueFromBitArray(n2, 8);
        return n4 >= 232 && n4 < 253;
    }

    private DecodedChar decodeIsoIec646(int n2) throws FormatException {
        char c2;
        int n3 = this.extractNumericValueFromBitArray(n2, 5);
        if (n3 == 15) {
            return new DecodedChar(n2 + 5, '$');
        }
        if (n3 >= 5 && n3 < 15) {
            int n4 = n2 + 5;
            return new DecodedChar(n4, (char)(n3 + 48 - 5));
        }
        n3 = this.extractNumericValueFromBitArray(n2, 7);
        if (n3 >= 64 && n3 < 90) {
            int n5 = n2 + 7;
            return new DecodedChar(n5, (char)(n3 + 1));
        }
        if (n3 >= 90 && n3 < 116) {
            int n6 = n2 + 7;
            return new DecodedChar(n6, (char)(n3 + 7));
        }
        switch (this.extractNumericValueFromBitArray(n2, 8)) {
            default: {
                throw FormatException.getFormatInstance();
            }
            case 252: {
                c2 = ' ';
                break;
            }
            case 251: {
                c2 = '_';
                break;
            }
            case 250: {
                c2 = '?';
                break;
            }
            case 249: {
                c2 = '>';
                break;
            }
            case 248: {
                c2 = '=';
                break;
            }
            case 247: {
                c2 = '<';
                break;
            }
            case 246: {
                c2 = ';';
                break;
            }
            case 245: {
                c2 = ':';
                break;
            }
            case 244: {
                c2 = '/';
                break;
            }
            case 243: {
                c2 = '.';
                break;
            }
            case 242: {
                c2 = '-';
                break;
            }
            case 241: {
                c2 = ',';
                break;
            }
            case 240: {
                c2 = '+';
                break;
            }
            case 239: {
                c2 = '*';
                break;
            }
            case 238: {
                c2 = ')';
                break;
            }
            case 237: {
                c2 = '(';
                break;
            }
            case 236: {
                c2 = '\'';
                break;
            }
            case 235: {
                c2 = '&';
                break;
            }
            case 234: {
                c2 = '%';
                break;
            }
            case 233: {
                c2 = '\"';
                break;
            }
            case 232: {
                c2 = '!';
            }
        }
        char c3 = c2;
        return new DecodedChar(n2 + 8, c3);
    }

    private boolean isStillAlpha(int n2) {
        if (n2 + 5 > this.information.getSize()) {
            return false;
        }
        int n3 = this.extractNumericValueFromBitArray(n2, 5);
        if (n3 >= 5 && n3 < 16) {
            return true;
        }
        if (n2 + 6 > this.information.getSize()) {
            return false;
        }
        int n4 = this.extractNumericValueFromBitArray(n2, 6);
        return n4 >= 16 && n4 < 63;
    }

    private DecodedChar decodeAlphanumeric(int n2) {
        int n3 = this.extractNumericValueFromBitArray(n2, 5);
        if (n3 == 15) {
            return new DecodedChar(n2 + 5, '$');
        }
        if (n3 >= 5 && n3 < 15) {
            int n4 = n2 + 5;
            return new DecodedChar(n4, (char)(n3 + 48 - 5));
        }
        int n5 = this.extractNumericValueFromBitArray(n2, 6);
        if (n5 >= 32 && n5 < 58) {
            int n6 = n5;
            n5 = n2 + 6;
            return new DecodedChar(n5, (char)(n6 + 33));
        }
        switch (n5) {
            default: {
                throw new IllegalStateException("Decoding invalid alphanumeric value: " + n5);
            }
            case 62: {
                n5 = 47;
                break;
            }
            case 61: {
                n5 = 46;
                break;
            }
            case 60: {
                n5 = 45;
                break;
            }
            case 59: {
                n5 = 44;
                break;
            }
            case 58: {
                n5 = 42;
            }
        }
        return new DecodedChar(n2 + 6, (char)n5);
    }

    private boolean isAlphaTo646ToAlphaLatch(int n2) {
        int n3;
        if (n2 + 1 > this.information.getSize()) {
            return false;
        }
        for (int i2 = 0; i2 < 5 && (n3 = i2 + n2) < this.information.getSize(); ++i2) {
            if (!(i2 == 2 ? !this.information.get(n2 + 2) : this.information.get(n3))) continue;
            return false;
        }
        return true;
    }

    private boolean isAlphaOr646ToNumericLatch(int n2) {
        int n3 = n2 + 3;
        if (n3 > this.information.getSize()) {
            return false;
        }
        while (n2 < n3) {
            if (this.information.get(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isNumericToAlphaNumericLatch(int n2) {
        int n3;
        if (n2 + 1 > this.information.getSize()) {
            return false;
        }
        for (int i2 = 0; i2 < 4 && (n3 = i2 + n2) < this.information.getSize(); ++i2) {
            if (!this.information.get(n3)) continue;
            return false;
        }
        return true;
    }

    String decodeAllCodes(StringBuilder stringBuilder, int n2) throws NotFoundException, FormatException {
        Object object = null;
        while (true) {
            String string2;
            if ((string2 = FieldParser.parseFieldsInGeneralPurpose(((DecodedInformation)(object = this.decodeGeneralPurposeField(n2, (String)object))).getNewString())) != null) {
                stringBuilder.append(string2);
            }
            string2 = ((DecodedInformation)object).isRemaining() ? String.valueOf(((DecodedInformation)object).getRemainingValue()) : null;
            if (n2 == ((DecodedObject)object).getNewPosition()) {
                return stringBuilder.toString();
            }
            n2 = ((DecodedObject)object).getNewPosition();
            object = string2;
        }
    }

    int extractNumericValueFromBitArray(int n2, int n3) {
        return GeneralAppIdDecoder.extractNumericValueFromBitArray(this.information, n2, n3);
    }

    DecodedInformation decodeGeneralPurposeField(int n2, String string2) throws FormatException {
        this.buffer.setLength(0);
        if (string2 != null) {
            this.buffer.append(string2);
        }
        GeneralAppIdDecoder generalAppIdDecoder = this;
        generalAppIdDecoder.current.setPosition(n2);
        Object object = generalAppIdDecoder.parseBlocks();
        if (object != null && ((DecodedInformation)object).isRemaining()) {
            DecodedInformation decodedInformation = object;
            GeneralAppIdDecoder generalAppIdDecoder2 = this;
            int n3 = generalAppIdDecoder2.current.getPosition();
            object = generalAppIdDecoder2.buffer.toString();
            int n4 = decodedInformation.getRemainingValue();
            return new DecodedInformation(n3, (String)object, n4);
        }
        return new DecodedInformation(this.current.getPosition(), this.buffer.toString());
    }
}

